/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.datatables.SubPledgeSkillTree;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2SquadTrainer;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.util.StringTokenizer;

public class L2FortSupportCaptainInstance
extends L2MerchantInstance
implements L2SquadTrainer {
    private static final int[] TalismanIds = new int[]{9914, 9915, 9917, 9918, 9919, 9920, 9921, 9922, 9923, 9924, 9926, 9927, 9928, 9930, 9931, 9932, 9933, 9934, 9935, 9936, 9937, 9938, 9939, 9940, 9941, 9942, 9943, 9944, 9945, 9946, 9947, 9948, 9949, 9950, 9951, 9952, 9953, 9954, 9955, 9956, 9957, 9958, 9959, 9960, 9961, 9962, 9963, 9964, 9965, 9966, 10141, 10142, 10158};

    public L2FortSupportCaptainInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
        this.setInstanceType(L2Object.InstanceType.L2FortSupportCaptainInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (player.getLastFolkNPC().getObjectId() != this.getObjectId()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(command, " ");
        String actualCommand = st.nextToken();
        String par = "";
        if (st.countTokens() >= 1) {
            par = st.nextToken();
        }
        if (actualCommand.equalsIgnoreCase("Chat")) {
            int val = 0;
            try {
                val = Integer.parseInt(par);
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.showMessageWindow(player, val);
        } else if (actualCommand.equalsIgnoreCase("ExchangeKE")) {
            int item = TalismanIds[Rnd.get(TalismanIds.length)];
            if (player.destroyItemByItemId("FortSupportUnit", 9912, 10L, this, false)) {
                SystemMessage msg = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                msg.addItemName(9912);
                msg.addNumber(10);
                player.sendPacket(msg);
                player.addItem("FortSupportUnit", item, 1L, player, true);
                String filename = "data/html/fortress/supportunit-talisman.htm";
                this.showChatWindow(player, filename);
            } else {
                String filename = "data/html/fortress/supportunit-noepau.htm";
                this.showChatWindow(player, filename);
            }
        } else if (command.equals("subskills")) {
            if (player.getClan() != null) {
                if (player.isClanLeader()) {
                    AcquireSkillList skilllist = new AcquireSkillList(AcquireSkillList.SkillType.SubUnit);
                    SubPledgeSkillTree.SubUnitSkill[] array = SubPledgeSkillTree.getInstance().getAvailableSkills(player.getClan());
                    if (array.length == 0) {
                        player.sendPacket(SystemMessageId.NO_MORE_SKILLS_TO_LEARN);
                        return;
                    }
                    for (SubPledgeSkillTree.SubUnitSkill sus : array) {
                        skilllist.addSkill(sus.getSkill().getId(), sus.getSkill().getLevel(), sus.getSkill().getLevel(), sus.getReputation(), 0);
                    }
                    player.sendPacket(skilllist);
                } else {
                    String filename = "data/html/fortress/supportunit-nosquad.htm";
                    this.showChatWindow(player, filename);
                }
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        if (player.getClan() == null || this.getFort().getOwnerClan() == null || player.getClan() != this.getFort().getOwnerClan()) {
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(player.getHtmlPrefix(), "data/html/fortress/supportunit-noclan.htm");
            html.replace((CharSequence)"%objectId%", this.getObjectId());
            player.sendPacket(html);
            return;
        }
        this.showMessageWindow(player, 0);
    }

    private void showMessageWindow(L2PcInstance player, int val) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = val == 0 ? "data/html/fortress/supportunit.htm" : "data/html/fortress/supportunit-" + val + ".htm";
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcId%", this.getNpcId());
        if (this.getFort().getOwnerClan() != null) {
            html.replace((CharSequence)"%clanname%", this.getFort().getOwnerClan().getName());
        } else {
            html.replace((CharSequence)"%clanname%", "NPC");
        }
        player.sendPacket(html);
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }

    @Override
    public void showSubUnitSkillList(L2PcInstance player) {
        this.onBypassFeedback(player, "subskills");
    }
}

