/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.MultiSell;
import com.l2jserver.gameserver.datatables.NpcBufferTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExHeroList;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.L2FastList;
import java.util.Iterator;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class L2OlympiadManagerInstance
extends L2Npc {
    private static Logger _logOlymp = Logger.getLogger(L2OlympiadManagerInstance.class.getName());
    private static final int GATE_PASS = Config.ALT_OLY_COMP_RITEM;
    private static final String FEWER_THAN = Config.ALT_OLY_REG_DISPLAY + "\u540d\u672a\u6e80";
    private static final String MORE_THAN = Config.ALT_OLY_REG_DISPLAY + "\u540d\u4ee5\u4e0a";

    public L2OlympiadManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2OlympiadManagerInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        block35: {
            block38: {
                block37: {
                    int npcId;
                    block36: {
                        block34: {
                            npcId = this.getNpcId();
                            if (!command.startsWith("OlympiadDesc")) break block34;
                            int val = Integer.parseInt(command.substring(13, 14));
                            String suffix = command.substring(14);
                            this.showChatWindow(player, val, suffix);
                            break block35;
                        }
                        if (!command.startsWith("OlympiadNoble")) break block36;
                        if (!player.isNoble() || player.getClassId().level() < 3) {
                            return;
                        }
                        int val = Integer.parseInt(command.substring(14));
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        switch (val) {
                            case 1: {
                                Olympiad.getInstance().unRegisterNoble(player);
                                break;
                            }
                            case 2: {
                                int classed = 0;
                                int nonClassed = 0;
                                int[] array = Olympiad.getInstance().getWaitingList();
                                if (array != null) {
                                    classed = array[0];
                                    nonClassed = array[1];
                                }
                                html.setFile(player.getHtmlPrefix(), "data/html/olympiad/noble_registered.htm");
                                if (Config.ALT_OLY_REG_DISPLAY > 0) {
                                    html.replace((CharSequence)"%listClassed%", classed < Config.ALT_OLY_REG_DISPLAY ? FEWER_THAN : MORE_THAN);
                                    html.replace((CharSequence)"%listNonClassedTeam%", FEWER_THAN);
                                    html.replace((CharSequence)"%listNonClassed%", nonClassed < Config.ALT_OLY_REG_DISPLAY ? FEWER_THAN : MORE_THAN);
                                } else {
                                    html.replace((CharSequence)"%listClassed%", classed);
                                    html.replace((CharSequence)"%listNonClassedTeam%", "0");
                                    html.replace((CharSequence)"%listNonClassed%", nonClassed);
                                }
                                html.replace((CharSequence)"%objectId%", this.getObjectId());
                                player.sendPacket(html);
                                break;
                            }
                            case 3: {
                                int points = Olympiad.getInstance().getNoblePoints(player.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/olympiad/noble_points1.htm");
                                html.replace((CharSequence)"%points%", points);
                                html.replace((CharSequence)"%objectId%", this.getObjectId());
                                player.sendPacket(html);
                                break;
                            }
                            case 4: {
                                Olympiad.getInstance().registerNoble(player, false);
                                break;
                            }
                            case 5: {
                                Olympiad.getInstance().registerNoble(player, true);
                                break;
                            }
                            case 6: {
                                int passes = Olympiad.getInstance().getNoblessePasses(player, false);
                                if (passes > 0) {
                                    html.setFile(player.getHtmlPrefix(), "data/html/olympiad/noble_settle.htm");
                                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                                    player.sendPacket(html);
                                    break;
                                }
                                html.setFile(player.getHtmlPrefix(), "data/html/olympiad/noble_nopoints.htm");
                                html.replace((CharSequence)"%objectId%", this.getObjectId());
                                player.sendPacket(html);
                                break;
                            }
                            case 7: {
                                MultiSell.getInstance().separateAndSend(102, player, this, false);
                                break;
                            }
                            case 8: {
                                MultiSell.getInstance().separateAndSend(103, player, this, false);
                                break;
                            }
                            case 9: {
                                int point = Olympiad.getInstance().getLastNobleOlympiadPoints(player.getObjectId());
                                html.setFile(player.getHtmlPrefix(), "data/html/olympiad/noble_points2.htm");
                                html.replace((CharSequence)"%points%", point);
                                html.replace((CharSequence)"%objectId%", this.getObjectId());
                                player.sendPacket(html);
                                break;
                            }
                            case 10: {
                                int passes = Olympiad.getInstance().getNoblessePasses(player, true);
                                if (passes > 0) {
                                    L2ItemInstance item = player.getInventory().addItem("Olympiad", GATE_PASS, passes, player, this);
                                    InventoryUpdate iu = new InventoryUpdate();
                                    iu.addModifiedItem(item);
                                    player.sendPacket(iu);
                                    SystemMessage sm = new SystemMessage(SystemMessageId.EARNED_ITEM);
                                    sm.addItemNumber(passes);
                                    sm.addItemName(item);
                                    player.sendPacket(sm);
                                    break;
                                }
                                break block35;
                            }
                            default: {
                                _logOlymp.warning("Olympiad System: Couldnt send packet for request " + val);
                                break;
                            }
                        }
                        break block35;
                    }
                    if (!command.startsWith("OlyBuff")) break block37;
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    String[] params = command.split(" ");
                    if (params[1] == null) {
                        _log.warning("Olympiad Buffer Warning: npcId = " + npcId + " has no buffGroup set in the bypass for the buff selected.");
                        return;
                    }
                    int buffGroup = Integer.parseInt(params[1]);
                    int[] npcBuffGroupInfo = NpcBufferTable.getInstance().getSkillInfo(npcId, buffGroup);
                    if (npcBuffGroupInfo == null) {
                        _log.warning("Olympiad Buffer Warning: npcId = " + npcId + " Location: " + this.getX() + ", " + this.getY() + ", " + this.getZ() + " Player: " + player.getName() + " has tried to use skill group (" + buffGroup + ") not assigned to the NPC Buffer!");
                        return;
                    }
                    int skillId = npcBuffGroupInfo[0];
                    int skillLevel = npcBuffGroupInfo[1];
                    L2Skill skill = SkillTable.getInstance().getInfo(skillId, skillLevel);
                    this.setTarget(player);
                    if (player.olyBuff > 0 && skill != null) {
                        --player.olyBuff;
                        this.broadcastPacket(new MagicSkillUse(this, player, skill.getId(), skill.getLevel(), 0, 0));
                        skill.getEffects(player, player);
                        L2Summon summon = player.getPet();
                        if (summon != null) {
                            this.broadcastPacket(new MagicSkillUse(this, summon, skill.getId(), skill.getLevel(), 0, 0));
                            skill.getEffects(summon, summon);
                        }
                    }
                    if (player.olyBuff > 0) {
                        html.setFile(player.getHtmlPrefix(), player.olyBuff == 5 ? "data/html/olympiad/olympiad_buffs.htm" : "data/html/olympiad/olympiad_5buffs.htm");
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                        player.sendPacket(html);
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/olympiad/olympiad_nobuffs.htm");
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                        player.sendPacket(html);
                        this.deleteMe();
                    }
                    break block35;
                }
                if (!command.startsWith("Olympiad")) break block38;
                int val = Integer.parseInt(command.substring(9, 10));
                NpcHtmlMessage reply = new NpcHtmlMessage(this.getObjectId());
                switch (val) {
                    case 1: {
                        FastMap<Integer, String> matches = Olympiad.getInstance().getMatchList();
                        reply.setFile(player.getHtmlPrefix(), "data/html/olympiad/olympiad_observe1.htm");
                        for (int i = 0; i < Olympiad.getStadiumCount(); ++i) {
                            int arenaID = i + 1;
                            reply.replace((CharSequence)("%title" + arenaID + "%"), matches.containsKey((Object)i) ? (String)matches.get((Object)i) : "&$906;");
                        }
                        reply.replace((CharSequence)"%objectId%", this.getObjectId());
                        player.sendPacket(reply);
                        break;
                    }
                    case 2: {
                        int classId = Integer.parseInt(command.substring(11));
                        if (classId >= 88 && classId <= 118 || classId >= 131 && classId <= 134 || classId == 136) {
                            L2FastList<String> names = Olympiad.getInstance().getClassLeaderBoard(classId);
                            reply.setFile(player.getHtmlPrefix(), "data/html/olympiad/olympiad_ranking.htm");
                            int index = 1;
                            Iterator i$ = names.iterator();
                            while (i$.hasNext()) {
                                String name = (String)i$.next();
                                reply.replace((CharSequence)("%place" + index + "%"), index);
                                reply.replace((CharSequence)("%rank" + index + "%"), name);
                                if (++index <= 10) continue;
                                break;
                            }
                            while (index <= 10) {
                                reply.replace((CharSequence)("%place" + index + "%"), "");
                                reply.replace((CharSequence)("%rank" + index + "%"), "");
                                ++index;
                            }
                            reply.replace((CharSequence)"%objectId%", this.getObjectId());
                            player.sendPacket(reply);
                            break;
                        }
                        break block35;
                    }
                    case 3: {
                        int id = Integer.parseInt(command.substring(11));
                        Olympiad.addSpectator(id, player, true);
                        break;
                    }
                    case 4: {
                        player.sendPacket(new ExHeroList());
                        break;
                    }
                    default: {
                        _logOlymp.warning("Olympiad System: Couldnt send packet for request " + val);
                        break;
                    }
                }
                break block35;
            }
            super.onBypassFeedback(player, command);
        }
    }

    private void showChatWindow(L2PcInstance player, int val, String suffix) {
        String filename;
        if (val == 0) {
            filename = "data/html/olympiad/noble_main.htm";
        } else {
            StringBuilder s = new StringBuilder(128).append("data/html/olympiad/").append("noble_desc").append(val);
            if (suffix != null) {
                s.append(suffix);
            }
            filename = s.append(".htm").toString();
        }
        this.showChatWindow(player, filename);
    }
}

