/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.RaidBossPointsManager;
import com.l2jserver.gameserver.instancemanager.RaidBossSpawnManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;

public class L2RaidBossInstance
extends L2MonsterInstance {
    private static final int RAIDBOSS_MAINTENANCE_INTERVAL = 30000;
    private RaidBossSpawnManager.StatusEnum _raidStatus;
    private boolean _useRaidCurse = true;

    public L2RaidBossInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2RaidBossInstance);
        this.setIsRaid(true);
    }

    @Override
    public void onSpawn() {
        this.setIsNoRndWalk(true);
        super.onSpawn();
    }

    @Override
    protected int getMaintenanceInterval() {
        return 30000;
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        L2PcInstance player = null;
        if (killer instanceof L2PcInstance) {
            player = (L2PcInstance)killer;
        } else if (killer instanceof L2Summon) {
            player = ((L2Summon)killer).getOwner();
        }
        if (player != null) {
            this.broadcastPacket(new SystemMessage(SystemMessageId.RAID_WAS_SUCCESSFUL));
            if (player.getParty() != null) {
                for (L2PcInstance member : player.getParty().getPartyMembers()) {
                    RaidBossPointsManager.getInstance().addPoints(member, this.getNpcId(), this.getLevel() / 2 + Rnd.get(-5, 5));
                    if (!member.isNoble()) continue;
                    Hero.getInstance().setRBkilled(member.getObjectId(), this.getNpcId());
                }
            } else {
                RaidBossPointsManager.getInstance().addPoints(player, this.getNpcId(), this.getLevel() / 2 + Rnd.get(-5, 5));
                if (player.isNoble()) {
                    Hero.getInstance().setRBkilled(player.getObjectId(), this.getNpcId());
                }
            }
        }
        RaidBossSpawnManager.getInstance().updateStatus(this);
        return true;
    }

    @Override
    protected void startMaintenanceTask() {
        if (this._minionList != null) {
            this._minionList.spawnMinions();
        }
        this._maintenanceTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new Runnable(){

            @Override
            public void run() {
                L2RaidBossInstance.this.checkAndReturnToSpawn();
                if (L2RaidBossInstance.this._minionList != null) {
                    L2RaidBossInstance.this._minionList.maintainMinions();
                }
            }
        }, 60000L, this.getMaintenanceInterval() + Rnd.get(5000));
    }

    protected void checkAndReturnToSpawn() {
        if (this.isDead() || this.isMovementDisabled()) {
            return;
        }
        if (this.getNpcId() == 29095) {
            return;
        }
        L2Spawn spawn = this.getSpawn();
        if (spawn == null) {
            return;
        }
        int spawnX = spawn.getLocx();
        int spawnY = spawn.getLocy();
        int spawnZ = spawn.getLocz();
        if (!(this.isInCombat() || this.isMovementDisabled() || this.isInsideRadius(spawnX, spawnY, spawnZ, Math.max(Config.MAX_DRIFT_RANGE, 200), true, false))) {
            this.teleToLocation(spawnX, spawnY, spawnZ, false);
        }
    }

    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, boolean awake, boolean isDOT, L2Skill skill) {
        super.reduceCurrentHp(damage, attacker, awake, isDOT, skill);
    }

    public void setRaidStatus(RaidBossSpawnManager.StatusEnum status) {
        this._raidStatus = status;
    }

    public RaidBossSpawnManager.StatusEnum getRaidStatus() {
        return this._raidStatus;
    }

    @Override
    public float getVitalityPoints(int damage) {
        return -super.getVitalityPoints(damage) / 100.0f;
    }

    @Override
    public boolean useVitalityRate() {
        return false;
    }

    public void setUseRaidCurse(boolean val) {
        this._useRaidCurse = val;
    }

    @Override
    public boolean giveRaidCurse() {
        return this._useRaidCurse;
    }
}

