/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.CharTemplateTable;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.SkillTreeTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2PledgeSkillLearn;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.base.PlayerClass;
import com.l2jserver.gameserver.model.base.Race;
import com.l2jserver.gameserver.model.base.SubClass;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.StringUtil;
import java.util.Iterator;
import java.util.Set;

public class L2VillageMasterInstance
extends L2NpcInstance {
    private static final boolean ALLOW_BASECLASS_EVERYWHERE = false;

    public L2VillageMasterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2VillageMasterInstance);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/villagemaster/", npcId, val);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        String[] commandStr = command.split(" ");
        String actualCommand = commandStr[0];
        String cmdParams = "";
        String cmdParams2 = "";
        if (commandStr.length >= 2) {
            cmdParams = commandStr[1];
        }
        if (commandStr.length >= 3) {
            cmdParams2 = commandStr[2];
        }
        if (actualCommand.equalsIgnoreCase("create_clan")) {
            if (cmdParams.isEmpty()) {
                return;
            }
            ClanTable.getInstance().createClan(player, cmdParams);
        } else if (actualCommand.equalsIgnoreCase("create_academy")) {
            if (cmdParams.isEmpty()) {
                return;
            }
            L2VillageMasterInstance.createSubPledge(player, cmdParams, null, -1, 5);
        } else if (actualCommand.equalsIgnoreCase("rename_pledge")) {
            if (cmdParams.isEmpty() || cmdParams2.isEmpty()) {
                return;
            }
            L2VillageMasterInstance.renameSubPledge(player, Integer.valueOf(cmdParams), cmdParams2);
        } else if (actualCommand.equalsIgnoreCase("create_royal")) {
            if (cmdParams.isEmpty()) {
                return;
            }
            L2VillageMasterInstance.createSubPledge(player, cmdParams, cmdParams2, 100, 6);
        } else if (actualCommand.equalsIgnoreCase("create_knight")) {
            if (cmdParams.isEmpty()) {
                return;
            }
            L2VillageMasterInstance.createSubPledge(player, cmdParams, cmdParams2, 1001, 7);
        } else if (actualCommand.equalsIgnoreCase("assign_subpl_leader")) {
            if (cmdParams.isEmpty()) {
                return;
            }
            L2VillageMasterInstance.assignSubPledgeLeader(player, cmdParams, cmdParams2);
        } else if (actualCommand.equalsIgnoreCase("create_ally")) {
            if (cmdParams.isEmpty()) {
                return;
            }
            if (player.getClan() == null) {
                player.sendPacket(new SystemMessage(SystemMessageId.ONLY_CLAN_LEADER_CREATE_ALLIANCE));
            } else {
                player.getClan().createAlly(player, cmdParams);
            }
        } else if (actualCommand.equalsIgnoreCase("dissolve_ally")) {
            player.getClan().dissolveAlly(player);
        } else if (actualCommand.equalsIgnoreCase("dissolve_clan")) {
            L2VillageMasterInstance.dissolveClan(player, player.getClanId());
        } else if (actualCommand.equalsIgnoreCase("change_clan_leader")) {
            if (cmdParams.isEmpty()) {
                return;
            }
            L2VillageMasterInstance.changeClanLeader(player, cmdParams);
        } else if (actualCommand.equalsIgnoreCase("recover_clan")) {
            L2VillageMasterInstance.recoverClan(player, player.getClanId());
        } else if (actualCommand.equalsIgnoreCase("increase_clan_level")) {
            if (player.getClan().levelUpClan(player)) {
                player.broadcastPacket(new MagicSkillUse(player, 5103, 1, 0, 0));
                player.broadcastPacket(new MagicSkillLaunched(player, 5103, 1));
            }
        } else if (actualCommand.equalsIgnoreCase("learn_clan_skills")) {
            L2VillageMasterInstance.showPledgeSkillList(player);
        } else if (command.startsWith("Subclass")) {
            if (player.isCursedWeaponEquipped()) {
                player.sendMessage("\u546a\u308f\u308c\u305f\u6b66\u5668\u3092\u88c5\u7740\u3057\u305f\u72b6\u614b\u3067\u306f\u30b5\u30d6 \u30af\u30e9\u30b9\u3092\u4f5c\u308b\u3053\u3068\u3084\u3001\u5909\u66f4\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
                return;
            }
            if (player.isCastingNow() || player.isAllSkillsDisabled()) {
                player.sendPacket(new SystemMessage(SystemMessageId.SUBCLASS_NO_CHANGE_OR_CREATE_WHILE_SKILL_IN_USE));
                return;
            }
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            if (player.getTransformation() != null) {
                html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_NoTransformed.htm");
                player.sendPacket(html);
                return;
            }
            int cmdChoice = 0;
            int paramOne = 0;
            int paramTwo = 0;
            try {
                cmdChoice = Integer.parseInt(command.substring(9, 10).trim());
                int endIndex = command.indexOf(32, 11);
                if (endIndex == -1) {
                    endIndex = command.length();
                }
                paramOne = Integer.parseInt(command.substring(11, endIndex).trim());
                if (command.length() > endIndex) {
                    paramTwo = Integer.parseInt(command.substring(endIndex).trim());
                }
            }
            catch (Exception NumberFormatException2) {
                // empty catch block
            }
            switch (cmdChoice) {
                case 0: {
                    html.setFile(player.getHtmlPrefix(), this.getSubClassMenu(player.getRace()));
                    break;
                }
                case 1: {
                    if (player.getTotalSubClasses() >= Config.MAX_SUBCLASS) {
                        html.setFile(player.getHtmlPrefix(), this.getSubClassFail());
                        break;
                    }
                    html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_Add.htm");
                    StringBuilder content1 = StringUtil.startAppend(200, new String[0]);
                    Set<PlayerClass> subsAvailable = this.getAvailableSubClasses(player);
                    if (subsAvailable != null && !subsAvailable.isEmpty()) {
                        for (PlayerClass subClass : subsAvailable) {
                            StringUtil.append(content1, "<a action=\"bypass -h npc_%objectId%_Subclass 4 ", String.valueOf(subClass.ordinal()), "\" msg=\"1268;", L2VillageMasterInstance.formatClassForDisplay(subClass), "\">", L2VillageMasterInstance.formatClassForDisplay(subClass), "</a><br>");
                        }
                    } else {
                        player.sendMessage("\u53d6\u5f97\u53ef\u80fd\u306a\u30b5\u30d6 \u30af\u30e9\u30b9\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                        return;
                    }
                    html.replace((CharSequence)"%list%", content1.toString());
                    break;
                }
                case 2: {
                    if (player.getSubClasses().isEmpty()) {
                        html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_ChangeNo.htm");
                        break;
                    }
                    StringBuilder content2 = StringUtil.startAppend(200, new String[0]);
                    if (this.checkVillageMaster(player.getBaseClass()) && player.getActiveClass() != player.getBaseClass()) {
                        StringUtil.append(content2, "<a action=\"bypass -h npc_%objectId%_Subclass 5 0\"><FONT COLOR=00FF00>", CharTemplateTable.getInstance().getClassNameById(player.getBaseClass()), " (\u30e1\u30a4\u30f3 \u30af\u30e9\u30b9)</FONT></a><br>");
                    }
                    Iterator<SubClass> subList = L2VillageMasterInstance.iterSubClasses(player);
                    while (subList.hasNext()) {
                        SubClass subClass = subList.next();
                        if (!this.checkVillageMaster(subClass.getClassDefinition())) continue;
                        StringUtil.append(content2, "<a action=\"bypass -h npc_%objectId%_Subclass 5 ", String.valueOf(subClass.getClassIndex()), "\">", L2VillageMasterInstance.formatClassForDisplay(subClass.getClassDefinition()), "</a><br>");
                    }
                    if (content2.length() > 0) {
                        html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_Change.htm");
                        html.replace((CharSequence)"%list%", content2.toString());
                        break;
                    }
                    html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_ChangeNotFound.htm");
                    break;
                }
                case 3: {
                    if (player.getSubClasses() == null || player.getSubClasses().isEmpty()) {
                        html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_ModifyEmpty.htm");
                        break;
                    }
                    if (player.getTotalSubClasses() > 3) {
                        html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_ModifyCustom.htm");
                        StringBuilder content3 = StringUtil.startAppend(200, new String[0]);
                        int classIndex = 1;
                        Iterator<SubClass> subList = L2VillageMasterInstance.iterSubClasses(player);
                        while (subList.hasNext()) {
                            SubClass subClass = subList.next();
                            StringUtil.append(content3, "Sub-class ", String.valueOf(classIndex++), "<br>", "<a action=\"bypass -h npc_%objectId%_Subclass 6 ", String.valueOf(subClass.getClassIndex()), "\">", CharTemplateTable.getInstance().getClassNameById(subClass.getClassId()), "</a><br>");
                        }
                        html.replace((CharSequence)"%list%", content3.toString());
                        break;
                    }
                    html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_Modify.htm");
                    if (player.getSubClasses().containsKey(1)) {
                        html.replace((CharSequence)"%sub1%", CharTemplateTable.getInstance().getClassNameById(player.getSubClasses().get(1).getClassId()));
                    } else {
                        html.replace((CharSequence)"<a action=\"bypass -h npc_%objectId%_Subclass 6 1\">%sub1%</a><br>", "");
                    }
                    if (player.getSubClasses().containsKey(2)) {
                        html.replace((CharSequence)"%sub2%", CharTemplateTable.getInstance().getClassNameById(player.getSubClasses().get(2).getClassId()));
                    } else {
                        html.replace((CharSequence)"<a action=\"bypass -h npc_%objectId%_Subclass 6 2\">%sub2%</a><br>", "");
                    }
                    if (player.getSubClasses().containsKey(3)) {
                        html.replace((CharSequence)"%sub3%", CharTemplateTable.getInstance().getClassNameById(player.getSubClasses().get(3).getClassId()));
                        break;
                    }
                    html.replace((CharSequence)"<a action=\"bypass -h npc_%objectId%_Subclass 6 3\">%sub3%</a><br>", "");
                    break;
                }
                case 4: {
                    if (!player.getFloodProtectors().getSubclass().tryPerformAction("add subclass")) {
                        _log.warning("Player " + player.getName() + " has performed a subclass change too fast");
                        return;
                    }
                    boolean allowAddition = true;
                    if (player.getTotalSubClasses() >= Config.MAX_SUBCLASS) {
                        allowAddition = false;
                    }
                    if (player.getLevel() < 75) {
                        allowAddition = false;
                    }
                    if (allowAddition && !player.getSubClasses().isEmpty()) {
                        Iterator<SubClass> subList = L2VillageMasterInstance.iterSubClasses(player);
                        while (subList.hasNext()) {
                            SubClass subClass = subList.next();
                            if (subClass.getLevel() >= 75) continue;
                            allowAddition = false;
                            break;
                        }
                    }
                    if (allowAddition && !Config.ALT_GAME_SUBCLASS_WITHOUT_QUESTS) {
                        allowAddition = this.checkQuests(player);
                    }
                    if (allowAddition && this.isValidNewSubClass(player, paramOne)) {
                        if (!player.addSubClass(paramOne, player.getTotalSubClasses() + 1)) {
                            return;
                        }
                        player.setActiveClass(player.getTotalSubClasses());
                        html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_AddOk.htm");
                        player.sendPacket(new SystemMessage(SystemMessageId.ADD_NEW_SUBCLASS));
                        break;
                    }
                    html.setFile(player.getHtmlPrefix(), this.getSubClassFail());
                    break;
                }
                case 5: {
                    if (!player.getFloodProtectors().getSubclass().tryPerformAction("change class")) {
                        _log.warning("Player " + player.getName() + " has performed a subclass change too fast");
                        return;
                    }
                    if (player.getClassIndex() == paramOne) {
                        html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_Current.htm");
                        break;
                    }
                    if (paramOne == 0) {
                        if (!this.checkVillageMaster(player.getBaseClass())) {
                            return;
                        }
                    } else {
                        try {
                            if (!this.checkVillageMaster(player.getSubClasses().get(paramOne).getClassDefinition())) {
                                return;
                            }
                        }
                        catch (NullPointerException e) {
                            return;
                        }
                    }
                    player.setActiveClass(paramOne);
                    player.sendPacket(new SystemMessage(SystemMessageId.SUBCLASS_TRANSFER_COMPLETED));
                    return;
                }
                case 6: {
                    if (paramOne < 1 || paramOne > Config.MAX_SUBCLASS) {
                        return;
                    }
                    Set<PlayerClass> subsAvailable = this.getAvailableSubClasses(player);
                    if (subsAvailable == null || subsAvailable.isEmpty()) {
                        player.sendMessage("\u53d6\u5f97\u53ef\u80fd\u306a\u30b5\u30d6 \u30af\u30e9\u30b9\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                        return;
                    }
                    StringBuilder content6 = StringUtil.startAppend(200, new String[0]);
                    for (PlayerClass subClass : subsAvailable) {
                        StringUtil.append(content6, "<a action=\"bypass -h npc_%objectId%_Subclass 7 ", String.valueOf(paramOne), " ", String.valueOf(subClass.ordinal()), "\" msg=\"1445;", "\">", L2VillageMasterInstance.formatClassForDisplay(subClass), "</a><br>");
                    }
                    switch (paramOne) {
                        case 1: {
                            html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_ModifyChoice1.htm");
                            break;
                        }
                        case 2: {
                            html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_ModifyChoice2.htm");
                            break;
                        }
                        case 3: {
                            html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_ModifyChoice3.htm");
                            break;
                        }
                        default: {
                            html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_ModifyChoice.htm");
                        }
                    }
                    html.replace((CharSequence)"%list%", content6.toString());
                    break;
                }
                case 7: {
                    if (!player.getFloodProtectors().getSubclass().tryPerformAction("change class")) {
                        _log.warning("Player " + player.getName() + " has performed a subclass change too fast");
                        return;
                    }
                    if (!this.isValidNewSubClass(player, paramTwo)) {
                        return;
                    }
                    if (player.modifySubClass(paramOne, paramTwo)) {
                        player.abortCast();
                        player.stopAllEffectsExceptThoseThatLastThroughDeath();
                        player.stopCubics();
                        player.setActiveClass(paramOne);
                        html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/SubClass_ModifyOk.htm");
                        html.replace((CharSequence)"%name%", CharTemplateTable.getInstance().getClassNameById(paramTwo));
                        player.sendPacket(new SystemMessage(SystemMessageId.ADD_NEW_SUBCLASS));
                        break;
                    }
                    player.setActiveClass(0);
                    player.sendMessage("\u30b5\u30d6 \u30af\u30e9\u30b9\u306e\u8ffd\u52a0\u304c\u3067\u304d\u307e\u305b\u3093\u3002\u30e1\u30a4\u30f3 \u30af\u30e9\u30b9\u306b\u623b\u308a\u307e\u3057\u305f\u3002");
                    return;
                }
            }
            html.replace((CharSequence)"%objectId%", this.getObjectId());
            player.sendPacket(html);
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    protected String getSubClassMenu(Race pRace) {
        if (Config.ALT_GAME_SUBCLASS_EVERYWHERE || pRace != Race.Kamael) {
            return "data/html/villagemaster/SubClass.htm";
        }
        return "data/html/villagemaster/SubClass_NoOther.htm";
    }

    protected String getSubClassFail() {
        return "data/html/villagemaster/SubClass_Fail.htm";
    }

    protected boolean checkQuests(L2PcInstance player) {
        if (player.isNoble()) {
            return true;
        }
        QuestState qs = player.getQuestState("234_FatesWhisper");
        if (qs == null || !qs.isCompleted()) {
            return false;
        }
        qs = player.getQuestState("235_MimirsElixir");
        return qs != null && qs.isCompleted();
    }

    private final Set<PlayerClass> getAvailableSubClasses(L2PcInstance player) {
        int currentBaseId = player.getBaseClass();
        ClassId baseCID = ClassId.values()[currentBaseId];
        int baseClassId = baseCID.level() > 2 ? baseCID.getParent().ordinal() : currentBaseId;
        Set<PlayerClass> availSubs = PlayerClass.values()[baseClassId].getAvailableSubclasses(player);
        if (availSubs != null && !availSubs.isEmpty()) {
            Iterator<PlayerClass> availSub = availSubs.iterator();
            block0: while (availSub.hasNext()) {
                PlayerClass pclass = availSub.next();
                if (!this.checkVillageMaster(pclass)) {
                    availSub.remove();
                    continue;
                }
                int availClassId = pclass.ordinal();
                ClassId cid = ClassId.values()[availClassId];
                Iterator<SubClass> subList = L2VillageMasterInstance.iterSubClasses(player);
                while (subList.hasNext()) {
                    SubClass prevSubClass = subList.next();
                    ClassId subClassId = ClassId.values()[prevSubClass.getClassId()];
                    if (!subClassId.equalsOrChildOf(cid)) continue;
                    availSub.remove();
                    continue block0;
                }
            }
        }
        return availSubs;
    }

    private final boolean isValidNewSubClass(L2PcInstance player, int classId) {
        if (!this.checkVillageMaster(classId)) {
            return false;
        }
        ClassId cid = ClassId.values()[classId];
        Iterator<SubClass> subList = L2VillageMasterInstance.iterSubClasses(player);
        while (subList.hasNext()) {
            SubClass sub = subList.next();
            ClassId subClassId = ClassId.values()[sub.getClassId()];
            if (!subClassId.equalsOrChildOf(cid)) continue;
            return false;
        }
        int currentBaseId = player.getBaseClass();
        ClassId baseCID = ClassId.values()[currentBaseId];
        int baseClassId = baseCID.level() > 2 ? baseCID.getParent().ordinal() : currentBaseId;
        Set<PlayerClass> availSubs = PlayerClass.values()[baseClassId].getAvailableSubclasses(player);
        if (availSubs == null || availSubs.isEmpty()) {
            return false;
        }
        boolean found = false;
        for (PlayerClass pclass : availSubs) {
            if (pclass.ordinal() != classId) continue;
            found = true;
            break;
        }
        return found;
    }

    protected boolean checkVillageMasterRace(PlayerClass pclass) {
        return true;
    }

    protected boolean checkVillageMasterTeachType(PlayerClass pclass) {
        return true;
    }

    public final boolean checkVillageMaster(int classId) {
        return this.checkVillageMaster(PlayerClass.values()[classId]);
    }

    public final boolean checkVillageMaster(PlayerClass pclass) {
        if (Config.ALT_GAME_SUBCLASS_EVERYWHERE) {
            return true;
        }
        return this.checkVillageMasterRace(pclass) && this.checkVillageMasterTeachType(pclass);
    }

    private static final String formatClassForDisplay(PlayerClass className) {
        String classNameStr = className.toJapanese();
        if (classNameStr != null) {
            return classNameStr;
        }
        classNameStr = className.toString();
        char[] charArray = classNameStr.toCharArray();
        for (int i = 1; i < charArray.length; ++i) {
            if (!Character.isUpperCase(charArray[i])) continue;
            classNameStr = classNameStr.substring(0, i) + " " + classNameStr.substring(i);
        }
        return classNameStr;
    }

    private static final Iterator<SubClass> iterSubClasses(L2PcInstance player) {
        return player.getSubClasses().values().iterator();
    }

    private static final void dissolveClan(L2PcInstance player, int clanId) {
        if (!player.isClanLeader()) {
            player.sendPacket(new SystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
            return;
        }
        L2Clan clan = player.getClan();
        if (clan.getAllyId() != 0) {
            player.sendPacket(new SystemMessage(SystemMessageId.CANNOT_DISPERSE_THE_CLANS_IN_ALLY));
            return;
        }
        if (clan.isAtWar()) {
            player.sendPacket(new SystemMessage(SystemMessageId.CANNOT_DISSOLVE_WHILE_IN_WAR));
            return;
        }
        if (clan.getHasCastle() != 0 || clan.getHasHideout() != 0 || clan.getHasFort() != 0) {
            player.sendPacket(new SystemMessage(SystemMessageId.CANNOT_DISSOLVE_WHILE_OWNING_CLAN_HALL_OR_CASTLE));
            return;
        }
        for (Castle castle : CastleManager.getInstance().getCastles()) {
            if (!SiegeManager.getInstance().checkIsRegistered(clan, castle.getCastleId())) continue;
            player.sendPacket(new SystemMessage(SystemMessageId.CANNOT_DISSOLVE_WHILE_IN_SIEGE));
            return;
        }
        for (Fort fort : FortManager.getInstance().getForts()) {
            if (!FortSiegeManager.getInstance().checkIsRegistered(clan, fort.getFortId())) continue;
            player.sendPacket(new SystemMessage(SystemMessageId.CANNOT_DISSOLVE_WHILE_IN_SIEGE));
            return;
        }
        if (player.isInsideZone((byte)2)) {
            player.sendPacket(new SystemMessage(SystemMessageId.CANNOT_DISSOLVE_WHILE_IN_SIEGE));
            return;
        }
        if (clan.getDissolvingExpiryTime() > System.currentTimeMillis()) {
            player.sendPacket(new SystemMessage(SystemMessageId.DISSOLUTION_IN_PROGRESS));
            return;
        }
        clan.setDissolvingExpiryTime(System.currentTimeMillis() + (long)Config.ALT_CLAN_DISSOLVE_DAYS * 86400000L);
        clan.updateClanInDB();
        ClanTable.getInstance().scheduleRemoveClan(clan.getClanId());
        player.deathPenalty(false, false, false);
    }

    private static final void recoverClan(L2PcInstance player, int clanId) {
        if (!player.isClanLeader()) {
            player.sendPacket(new SystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
            return;
        }
        L2Clan clan = player.getClan();
        clan.setDissolvingExpiryTime(0L);
        clan.updateClanInDB();
    }

    private static final void changeClanLeader(L2PcInstance player, String target) {
        if (!player.isClanLeader()) {
            player.sendPacket(new SystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
            return;
        }
        if (player.getName().equalsIgnoreCase(target)) {
            return;
        }
        if (player.isFlying()) {
            player.sendMessage("\u98db\u884c\u4e2d\u3067\u3059\u3002");
            return;
        }
        L2Clan clan = player.getClan();
        L2ClanMember member = clan.getClanMember(target);
        if (member == null) {
            SystemMessage sm = new SystemMessage(SystemMessageId.S1_DOES_NOT_EXIST);
            sm.addString(target);
            player.sendPacket(sm);
            sm = null;
            return;
        }
        if (!member.isOnline()) {
            player.sendPacket(new SystemMessage(SystemMessageId.INVITED_USER_NOT_ONLINE));
            return;
        }
        clan.setNewLeader(member);
    }

    private static final void createSubPledge(L2PcInstance player, String clanName, String leaderName, int pledgeType, int minClanLvl) {
        L2ClanMember leaderSubPledge;
        L2PcInstance leaderPlayer;
        SystemMessage sm;
        int leaderId;
        if (!player.isClanLeader()) {
            player.sendPacket(new SystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
            return;
        }
        L2Clan clan = player.getClan();
        if (clan.getLevel() < minClanLvl) {
            if (pledgeType == -1) {
                player.sendPacket(new SystemMessage(SystemMessageId.YOU_DO_NOT_MEET_CRITERIA_IN_ORDER_TO_CREATE_A_CLAN_ACADEMY));
            } else {
                player.sendPacket(new SystemMessage(SystemMessageId.YOU_DO_NOT_MEET_CRITERIA_IN_ORDER_TO_CREATE_A_MILITARY_UNIT));
            }
            return;
        }
        if (!Util.isAlphaNumeric(clanName) || 2 > clanName.length()) {
            player.sendPacket(new SystemMessage(SystemMessageId.CLAN_NAME_INCORRECT));
            return;
        }
        if (clanName.length() > 16) {
            player.sendPacket(new SystemMessage(SystemMessageId.CLAN_NAME_TOO_LONG));
            return;
        }
        for (L2Clan tempClan : ClanTable.getInstance().getClans()) {
            if (tempClan.getSubPledge(clanName) == null) continue;
            if (pledgeType == -1) {
                SystemMessage sm2 = new SystemMessage(SystemMessageId.S1_ALREADY_EXISTS);
                sm2.addString(clanName);
                player.sendPacket(sm2);
                sm2 = null;
            } else {
                player.sendPacket(new SystemMessage(SystemMessageId.ANOTHER_MILITARY_UNIT_IS_ALREADY_USING_THAT_NAME));
            }
            return;
        }
        if (pledgeType != -1 && (clan.getClanMember(leaderName) == null || clan.getClanMember(leaderName).getPledgeType() != 0)) {
            if (pledgeType >= 1001) {
                player.sendPacket(new SystemMessage(SystemMessageId.CAPTAIN_OF_ORDER_OF_KNIGHTS_CANNOT_BE_APPOINTED));
            } else if (pledgeType >= 100) {
                player.sendPacket(new SystemMessage(SystemMessageId.CAPTAIN_OF_ROYAL_GUARD_CANNOT_BE_APPOINTED));
            }
            return;
        }
        int n = leaderId = pledgeType != -1 ? clan.getClanMember(leaderName).getObjectId() : 0;
        if (clan.createSubPledge(player, pledgeType, leaderId, clanName) == null) {
            return;
        }
        if (pledgeType == -1) {
            sm = new SystemMessage(SystemMessageId.THE_S1S_CLAN_ACADEMY_HAS_BEEN_CREATED);
            sm.addString(player.getClan().getName());
        } else if (pledgeType >= 1001) {
            sm = new SystemMessage(SystemMessageId.THE_KNIGHTS_OF_S1_HAVE_BEEN_CREATED);
            sm.addString(player.getClan().getName());
        } else if (pledgeType >= 100) {
            sm = new SystemMessage(SystemMessageId.THE_ROYAL_GUARD_OF_S1_HAVE_BEEN_CREATED);
            sm.addString(player.getClan().getName());
        } else {
            sm = new SystemMessage(SystemMessageId.CLAN_CREATED);
        }
        player.sendPacket(sm);
        if (pledgeType != -1 && (leaderPlayer = (leaderSubPledge = clan.getClanMember(leaderName)).getPlayerInstance()) != null) {
            leaderPlayer.setPledgeClass(leaderSubPledge.calculatePledgeClass(leaderPlayer));
            leaderPlayer.sendPacket(new UserInfo(leaderPlayer));
            leaderPlayer.sendPacket(new ExBrExtraUserInfo(leaderPlayer));
        }
    }

    private static final void renameSubPledge(L2PcInstance player, int pledgeType, String pledgeName) {
        if (!player.isClanLeader()) {
            player.sendPacket(new SystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
            return;
        }
        L2Clan clan = player.getClan();
        L2Clan.SubPledge subPledge = player.getClan().getSubPledge(pledgeType);
        if (subPledge == null) {
            player.sendMessage("Pledge don't exists.");
            return;
        }
        if (!Util.isAlphaNumeric(pledgeName) || 2 > pledgeName.length()) {
            player.sendPacket(new SystemMessage(SystemMessageId.CLAN_NAME_INCORRECT));
            return;
        }
        if (pledgeName.length() > 16) {
            player.sendPacket(new SystemMessage(SystemMessageId.CLAN_NAME_TOO_LONG));
            return;
        }
        subPledge.setName(pledgeName);
        clan.updateSubPledgeInDB(subPledge.getId());
        clan.broadcastClanStatus();
        player.sendMessage("Pledge name changed.");
    }

    private static final void assignSubPledgeLeader(L2PcInstance player, String clanName, String leaderName) {
        if (!player.isClanLeader()) {
            player.sendPacket(new SystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
            return;
        }
        if (leaderName.length() > 16) {
            player.sendPacket(new SystemMessage(SystemMessageId.NAMING_CHARNAME_UP_TO_16CHARS));
            return;
        }
        if (player.getName().equals(leaderName)) {
            player.sendPacket(new SystemMessage(SystemMessageId.CAPTAIN_OF_ROYAL_GUARD_CANNOT_BE_APPOINTED));
            return;
        }
        L2Clan clan = player.getClan();
        L2Clan.SubPledge subPledge = player.getClan().getSubPledge(clanName);
        if (null == subPledge || subPledge.getId() == -1) {
            player.sendPacket(new SystemMessage(SystemMessageId.CLAN_NAME_INCORRECT));
            return;
        }
        if (clan.getClanMember(leaderName) == null || clan.getClanMember(leaderName).getPledgeType() != 0) {
            if (subPledge.getId() >= 1001) {
                player.sendPacket(new SystemMessage(SystemMessageId.CAPTAIN_OF_ORDER_OF_KNIGHTS_CANNOT_BE_APPOINTED));
            } else if (subPledge.getId() >= 100) {
                player.sendPacket(new SystemMessage(SystemMessageId.CAPTAIN_OF_ROYAL_GUARD_CANNOT_BE_APPOINTED));
            }
            return;
        }
        subPledge.setLeaderId(clan.getClanMember(leaderName).getObjectId());
        clan.updateSubPledgeInDB(subPledge.getId());
        L2ClanMember leaderSubPledge = clan.getClanMember(leaderName);
        L2PcInstance leaderPlayer = leaderSubPledge.getPlayerInstance();
        if (leaderPlayer != null) {
            leaderPlayer.setPledgeClass(leaderSubPledge.calculatePledgeClass(leaderPlayer));
            leaderPlayer.sendPacket(new UserInfo(leaderPlayer));
            leaderPlayer.sendPacket(new ExBrExtraUserInfo(leaderPlayer));
        }
        clan.broadcastClanStatus();
        SystemMessage sm = new SystemMessage(SystemMessageId.C1_HAS_BEEN_SELECTED_AS_CAPTAIN_OF_S2);
        sm.addString(leaderName);
        sm.addString(clanName);
        clan.broadcastToOnlineMembers(sm);
        sm = null;
    }

    public static final void showPledgeSkillList(L2PcInstance player) {
        if (player.getClan() == null || !player.isClanLeader()) {
            NpcHtmlMessage html = new NpcHtmlMessage(1);
            html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/NotClanLeader.htm");
            player.sendPacket(html);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2PledgeSkillLearn[] skills = SkillTreeTable.getInstance().getAvailablePledgeSkills(player);
        AcquireSkillList asl = new AcquireSkillList(AcquireSkillList.SkillType.Clan);
        int counts = 0;
        for (L2PledgeSkillLearn s : skills) {
            int cost = s.getRepCost();
            int itemCount = s.getItemCount();
            ++counts;
            asl.addSkill(s.getId(), s.getLevel(), s.getLevel(), cost, itemCount);
        }
        if (counts == 0) {
            if (player.getClan().getLevel() < 8) {
                SystemMessage sm = new SystemMessage(SystemMessageId.DO_NOT_HAVE_FURTHER_SKILLS_TO_LEARN);
                if (player.getClan().getLevel() < 5) {
                    sm.addNumber(5);
                } else {
                    sm.addNumber(player.getClan().getLevel() + 1);
                }
                player.sendPacket(sm);
            } else {
                NpcHtmlMessage html = new NpcHtmlMessage(1);
                html.setFile(player.getHtmlPrefix(), "data/html/villagemaster/NoMoreSkills.htm");
                player.sendPacket(html);
            }
        } else {
            player.sendPacket(asl);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }
}

