/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ArmorSetsTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2ArmorSet;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.skills.SkillHolder;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.templates.item.L2Armor;
import com.l2jserver.gameserver.templates.item.L2EtcItem;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import javolution.util.FastList;

public abstract class Inventory
extends ItemContainer {
    public static final int PAPERDOLL_UNDER = 0;
    public static final int PAPERDOLL_REAR = 1;
    public static final int PAPERDOLL_LEAR = 2;
    public static final int PAPERDOLL_LREAR = 3;
    public static final int PAPERDOLL_NECK = 4;
    public static final int PAPERDOLL_LFINGER = 5;
    public static final int PAPERDOLL_RFINGER = 6;
    public static final int PAPERDOLL_LRFINGER = 7;
    public static final int PAPERDOLL_HEAD = 8;
    public static final int PAPERDOLL_RHAND = 9;
    public static final int PAPERDOLL_LHAND = 10;
    public static final int PAPERDOLL_GLOVES = 11;
    public static final int PAPERDOLL_CHEST = 12;
    public static final int PAPERDOLL_LEGS = 13;
    public static final int PAPERDOLL_FEET = 14;
    public static final int PAPERDOLL_BACK = 15;
    public static final int PAPERDOLL_LRHAND = 16;
    public static final int PAPERDOLL_FULLARMOR = 17;
    public static final int PAPERDOLL_HAIR = 18;
    public static final int PAPERDOLL_ALLDRESS = 19;
    public static final int PAPERDOLL_HAIR2 = 20;
    public static final int PAPERDOLL_HAIRALL = 21;
    public static final int PAPERDOLL_RBRACELET = 22;
    public static final int PAPERDOLL_LBRACELET = 23;
    public static final int PAPERDOLL_DECO1 = 24;
    public static final int PAPERDOLL_DECO2 = 25;
    public static final int PAPERDOLL_DECO3 = 26;
    public static final int PAPERDOLL_DECO4 = 27;
    public static final int PAPERDOLL_DECO5 = 28;
    public static final int PAPERDOLL_DECO6 = 29;
    public static final int PAPERDOLL_BELT = 30;
    public static final int PAPERDOLL_TOTALSLOTS = 31;
    public static final double MAX_ARMOR_WEIGHT = 12000.0;
    private final L2ItemInstance[] _paperdoll = new L2ItemInstance[31];
    private final List<PaperdollListener> _paperdollListeners = new FastList();
    protected int _totalWeight;
    private int _wearedMask;

    protected Inventory() {
        this.addPaperdollListener(new ArmorSetListener());
        this.addPaperdollListener(new CrossBowListener());
        this.addPaperdollListener(new BowListener());
        this.addPaperdollListener(new ItemSkillsListener());
        this.addPaperdollListener(new StatsListener());
        this.addPaperdollListener(new BraceletListener());
    }

    protected abstract L2ItemInstance.ItemLocation getEquipLocation();

    public ChangeRecorder newRecorder() {
        return new ChangeRecorder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance dropItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        if (item == null) {
            return null;
        }
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            if (!this._items.contains(item)) {
                return null;
            }
            this.removeItem(item);
            item.setOwnerId(process, 0, actor, reference);
            item.setLocation(L2ItemInstance.ItemLocation.VOID);
            item.setLastChange(3);
            item.updateDatabase();
            this.refreshWeight();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance dropItem(String process, int objectId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = this.getItemByObjectId(objectId);
        if (item == null) {
            return null;
        }
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            if (!this._items.contains(item)) {
                return null;
            }
            if (item.getCount() > count) {
                item.changeCount(process, -count, actor, reference);
                item.setLastChange(2);
                item.updateDatabase();
                item = ItemTable.getInstance().createItem(process, item.getItemId(), count, actor, reference);
                item.updateDatabase();
                this.refreshWeight();
                return item;
            }
        }
        return this.dropItem(process, item, actor, reference);
    }

    @Override
    protected void addItem(L2ItemInstance item) {
        super.addItem(item);
        if (item.isEquipped()) {
            this.equipItem(item);
        }
    }

    @Override
    protected boolean removeItem(L2ItemInstance item) {
        for (int i = 0; i < this._paperdoll.length; ++i) {
            if (this._paperdoll[i] != item) continue;
            this.unEquipItemInSlotAndRecord(i);
        }
        return super.removeItem(item);
    }

    public L2ItemInstance getPaperdollItem(int slot) {
        return this._paperdoll[slot];
    }

    public L2ItemInstance getPaperdollItemByL2ItemId(int slot) {
        switch (slot) {
            case 1: {
                return this._paperdoll[0];
            }
            case 2: {
                return this._paperdoll[1];
            }
            case 4: {
                return this._paperdoll[2];
            }
            case 6: {
                return this._paperdoll[3];
            }
            case 8: {
                return this._paperdoll[4];
            }
            case 16: {
                return this._paperdoll[5];
            }
            case 32: {
                return this._paperdoll[6];
            }
            case 48: {
                return this._paperdoll[7];
            }
            case 64: {
                return this._paperdoll[8];
            }
            case 128: {
                return this._paperdoll[9];
            }
            case 256: {
                return this._paperdoll[10];
            }
            case 512: {
                return this._paperdoll[11];
            }
            case 1024: {
                return this._paperdoll[12];
            }
            case 2048: {
                return this._paperdoll[13];
            }
            case 4096: {
                return this._paperdoll[14];
            }
            case 8192: {
                return this._paperdoll[15];
            }
            case 16384: {
                return this._paperdoll[16];
            }
            case 32768: {
                return this._paperdoll[17];
            }
            case 65536: {
                return this._paperdoll[18];
            }
            case 131072: {
                return this._paperdoll[19];
            }
            case 262144: {
                return this._paperdoll[20];
            }
            case 524288: {
                return this._paperdoll[21];
            }
            case 0x100000: {
                return this._paperdoll[22];
            }
            case 0x200000: {
                return this._paperdoll[23];
            }
            case 0x400000: {
                return this._paperdoll[24];
            }
            case 0x10000000: {
                return this._paperdoll[30];
            }
        }
        return null;
    }

    public int getPaperdollItemId(int slot) {
        L2ItemInstance item = this._paperdoll[slot];
        if (item != null) {
            return item.getItemId();
        }
        if (slot == 18 && (item = this._paperdoll[21]) != null) {
            return item.getItemId();
        }
        return 0;
    }

    public int getPaperdollAugmentationId(int slot) {
        L2ItemInstance item = this._paperdoll[slot];
        if (item != null) {
            if (item.getAugmentation() != null) {
                return item.getAugmentation().getAugmentationId();
            }
            return 0;
        }
        return 0;
    }

    public int getPaperdollObjectId(int slot) {
        L2ItemInstance item = this._paperdoll[slot];
        if (item != null) {
            return item.getObjectId();
        }
        if (slot == 18 && (item = this._paperdoll[21]) != null) {
            return item.getObjectId();
        }
        return 0;
    }

    public synchronized void addPaperdollListener(PaperdollListener listener) {
        assert (!this._paperdollListeners.contains(listener));
        this._paperdollListeners.add(listener);
    }

    public synchronized void removePaperdollListener(PaperdollListener listener) {
        this._paperdollListeners.remove(listener);
    }

    public synchronized L2ItemInstance setPaperdollItem(int slot, L2ItemInstance item) {
        L2ItemInstance old = this._paperdoll[slot];
        if (old != item) {
            if (old != null) {
                this._paperdoll[slot] = null;
                old.setLocation(this.getBaseLocation());
                old.setLastChange(2);
                int mask = 0;
                for (int i = 0; i < 16; ++i) {
                    L2ItemInstance pi = this._paperdoll[i];
                    if (pi == null) continue;
                    mask |= pi.getItem().getItemMask();
                }
                this._wearedMask = mask;
                for (PaperdollListener listener : this._paperdollListeners) {
                    if (listener == null) continue;
                    listener.notifyUnequiped(slot, old);
                }
                old.updateDatabase();
            }
            if (item != null) {
                this._paperdoll[slot] = item;
                item.setLocation(this.getEquipLocation(), slot);
                item.setLastChange(2);
                this._wearedMask |= item.getItem().getItemMask();
                for (PaperdollListener listener : this._paperdollListeners) {
                    if (listener == null) continue;
                    listener.notifyEquiped(slot, item);
                }
                item.updateDatabase();
            }
        }
        return old;
    }

    public int getWearedMask() {
        return this._wearedMask;
    }

    public int getSlotFromItem(L2ItemInstance item) {
        int slot = -1;
        int location = item.getLocationSlot();
        switch (location) {
            case 0: {
                slot = 1;
                break;
            }
            case 2: {
                slot = 4;
                break;
            }
            case 1: {
                slot = 2;
                break;
            }
            case 4: {
                slot = 8;
                break;
            }
            case 6: {
                slot = 16;
                break;
            }
            case 5: {
                slot = 32;
                break;
            }
            case 18: {
                slot = 65536;
                break;
            }
            case 20: {
                slot = 262144;
                break;
            }
            case 21: {
                slot = 524288;
                break;
            }
            case 8: {
                slot = 64;
                break;
            }
            case 9: {
                slot = 128;
                break;
            }
            case 10: {
                slot = 256;
                break;
            }
            case 11: {
                slot = 512;
                break;
            }
            case 12: {
                slot = item.getItem().getBodyPart();
                break;
            }
            case 13: {
                slot = 2048;
                break;
            }
            case 15: {
                slot = 8192;
                break;
            }
            case 14: {
                slot = 4096;
                break;
            }
            case 16: {
                slot = 16384;
                break;
            }
            case 23: {
                slot = 0x200000;
                break;
            }
            case 22: {
                slot = 0x100000;
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                slot = 0x400000;
                break;
            }
            case 30: {
                slot = 0x10000000;
            }
        }
        return slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance[] unEquipItemInBodySlotAndRecord(int slot) {
        ChangeRecorder recorder = this.newRecorder();
        try {
            this.unEquipItemInBodySlot(slot);
            if (this.getOwner() instanceof L2PcInstance) {
                ((L2PcInstance)this.getOwner()).refreshExpertisePenalty();
            }
        }
        finally {
            this.removePaperdollListener(recorder);
        }
        return recorder.getChangedItems();
    }

    public L2ItemInstance unEquipItemInSlot(int pdollSlot) {
        switch (pdollSlot) {
            case 21: {
                this.setPaperdollItem(18, null);
                this.setPaperdollItem(20, null);
                break;
            }
            case 16: {
                this.setPaperdollItem(10, null);
                this.setPaperdollItem(9, null);
            }
        }
        return this.setPaperdollItem(pdollSlot, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance[] unEquipItemInSlotAndRecord(int slot) {
        ChangeRecorder recorder = this.newRecorder();
        try {
            this.unEquipItemInSlot(slot);
            if (this.getOwner() instanceof L2PcInstance) {
                ((L2PcInstance)this.getOwner()).refreshExpertisePenalty();
            }
        }
        finally {
            this.removePaperdollListener(recorder);
        }
        return recorder.getChangedItems();
    }

    private void unEquipItemInBodySlot(int slot) {
        if (Config.DEBUG) {
            _log.fine("--- unequip body slot:" + slot);
        }
        int pdollSlot = -1;
        switch (slot) {
            case 4: {
                pdollSlot = 2;
                break;
            }
            case 2: {
                pdollSlot = 1;
                break;
            }
            case 8: {
                pdollSlot = 4;
                break;
            }
            case 16: {
                pdollSlot = 6;
                break;
            }
            case 32: {
                pdollSlot = 5;
                break;
            }
            case 65536: {
                pdollSlot = 18;
                break;
            }
            case 262144: {
                pdollSlot = 20;
                break;
            }
            case 524288: {
                this.setPaperdollItem(18, null);
                this.setPaperdollItem(20, null);
                pdollSlot = 21;
                break;
            }
            case 64: {
                pdollSlot = 8;
                break;
            }
            case 128: {
                pdollSlot = 9;
                break;
            }
            case 256: {
                pdollSlot = 10;
                break;
            }
            case 512: {
                pdollSlot = 11;
                break;
            }
            case 1024: 
            case 32768: {
                pdollSlot = 12;
                break;
            }
            case 2048: {
                pdollSlot = 13;
                break;
            }
            case 8192: {
                pdollSlot = 15;
                break;
            }
            case 4096: {
                pdollSlot = 14;
                break;
            }
            case 1: {
                pdollSlot = 0;
                break;
            }
            case 16384: {
                this.setPaperdollItem(10, null);
                this.setPaperdollItem(9, null);
                pdollSlot = 16;
                break;
            }
            case 0x200000: {
                pdollSlot = 23;
                break;
            }
            case 0x100000: {
                pdollSlot = 22;
                break;
            }
            case 0x10000000: {
                pdollSlot = 30;
            }
        }
        if (pdollSlot >= 0) {
            this.setPaperdollItem(pdollSlot, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2ItemInstance[] equipItemAndRecord(L2ItemInstance item) {
        ChangeRecorder recorder = this.newRecorder();
        try {
            this.equipItem(item);
        }
        finally {
            this.removePaperdollListener(recorder);
        }
        return recorder.getChangedItems();
    }

    public void equipItem(L2ItemInstance item) {
        L2PcInstance player;
        if (this.getOwner() instanceof L2PcInstance && ((L2PcInstance)this.getOwner()).getPrivateStoreType() != 0) {
            return;
        }
        if (this.getOwner() instanceof L2PcInstance && !(player = (L2PcInstance)this.getOwner()).isGM() && !player.isHero() && item.isHeroItem()) {
            return;
        }
        int targetSlot = item.getItem().getBodyPart();
        switch (targetSlot) {
            case 16384: {
                if (this.setPaperdollItem(10, null) != null) {
                    this.setPaperdollItem(9, null);
                    this.setPaperdollItem(10, null);
                } else {
                    this.setPaperdollItem(9, null);
                }
                this.setPaperdollItem(9, item);
                this.setPaperdollItem(16, item);
                break;
            }
            case 256: {
                L2ItemInstance old1;
                if (!(item.getItem() instanceof L2EtcItem && item.getItem().getItemType() == L2EtcItemType.ARROW || (old1 = this.setPaperdollItem(16, null)) == null)) {
                    this.setPaperdollItem(9, null);
                }
                this.setPaperdollItem(10, null);
                this.setPaperdollItem(10, item);
                break;
            }
            case 128: {
                if (this._paperdoll[16] != null) {
                    this.setPaperdollItem(16, null);
                    this.setPaperdollItem(10, null);
                    this.setPaperdollItem(9, null);
                } else {
                    this.setPaperdollItem(9, null);
                }
                this.setPaperdollItem(9, item);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                if (this._paperdoll[2] == null) {
                    this.setPaperdollItem(2, item);
                    break;
                }
                if (this._paperdoll[1] == null) {
                    this.setPaperdollItem(1, item);
                    break;
                }
                this.setPaperdollItem(2, null);
                this.setPaperdollItem(2, item);
                break;
            }
            case 16: 
            case 32: 
            case 48: {
                if (this._paperdoll[5] == null) {
                    this.setPaperdollItem(5, item);
                    break;
                }
                if (this._paperdoll[6] == null) {
                    this.setPaperdollItem(6, item);
                    break;
                }
                this.setPaperdollItem(5, null);
                this.setPaperdollItem(5, item);
                break;
            }
            case 8: {
                this.setPaperdollItem(4, item);
                break;
            }
            case 32768: {
                this.setPaperdollItem(12, null);
                this.setPaperdollItem(13, null);
                this.setPaperdollItem(12, item);
                break;
            }
            case 1024: {
                this.setPaperdollItem(12, item);
                break;
            }
            case 2048: {
                L2ItemInstance chest = this.getPaperdollItem(12);
                if (chest != null && chest.getItem().getBodyPart() == 32768) {
                    this.setPaperdollItem(12, null);
                }
                this.setPaperdollItem(13, null);
                this.setPaperdollItem(13, item);
                break;
            }
            case 4096: {
                this.setPaperdollItem(14, item);
                break;
            }
            case 512: {
                this.setPaperdollItem(11, item);
                break;
            }
            case 64: {
                this.setPaperdollItem(8, item);
                break;
            }
            case 65536: {
                if (this.setPaperdollItem(21, null) != null) {
                    this.setPaperdollItem(21, null);
                    this.setPaperdollItem(18, null);
                    this.setPaperdollItem(20, null);
                } else {
                    this.setPaperdollItem(18, null);
                }
                this.setPaperdollItem(18, item);
                break;
            }
            case 262144: {
                if (this.setPaperdollItem(21, null) != null) {
                    this.setPaperdollItem(21, null);
                    this.setPaperdollItem(18, null);
                    this.setPaperdollItem(20, null);
                } else {
                    this.setPaperdollItem(20, null);
                }
                this.setPaperdollItem(20, item);
                break;
            }
            case 524288: {
                if (this.setPaperdollItem(18, null) != null) {
                    this.setPaperdollItem(18, null);
                    this.setPaperdollItem(20, null);
                } else {
                    this.setPaperdollItem(20, null);
                }
                this.setPaperdollItem(21, item);
                break;
            }
            case 1: {
                this.setPaperdollItem(0, item);
                break;
            }
            case 8192: {
                this.setPaperdollItem(15, item);
                break;
            }
            case 0x200000: {
                this.setPaperdollItem(23, item);
                break;
            }
            case 0x100000: {
                this.setPaperdollItem(22, item);
                break;
            }
            case 0x400000: {
                this.equipTalisman(item);
                break;
            }
            case 0x10000000: {
                this.setPaperdollItem(30, item);
                break;
            }
            default: {
                _log.warning("Unknown body slot " + targetSlot + " for Item ID:" + item.getItemId());
            }
        }
    }

    @Override
    protected void refreshWeight() {
        long weight = 0L;
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getItem() == null) continue;
            weight += (long)item.getItem().getWeight() * item.getCount();
        }
        this._totalWeight = (int)Math.min(weight, Integer.MAX_VALUE);
    }

    public int getTotalWeight() {
        return this._totalWeight;
    }

    public L2ItemInstance findArrowForBow(L2Item bow) {
        if (bow == null) {
            return null;
        }
        L2ItemInstance arrow = null;
        switch (bow.getItemGradeSPlus()) {
            default: {
                arrow = this.getItemByItemId(17);
                break;
            }
            case 1: {
                arrow = this.getItemByItemId(1341);
                arrow = arrow != null ? arrow : this.getItemByItemId(22067);
                break;
            }
            case 2: {
                arrow = this.getItemByItemId(1342);
                arrow = arrow != null ? arrow : this.getItemByItemId(22068);
                break;
            }
            case 3: {
                arrow = this.getItemByItemId(1343);
                arrow = arrow != null ? arrow : this.getItemByItemId(22069);
                break;
            }
            case 4: {
                arrow = this.getItemByItemId(1344);
                arrow = arrow != null ? arrow : this.getItemByItemId(22070);
                break;
            }
            case 5: {
                arrow = this.getItemByItemId(1345);
                arrow = arrow != null ? arrow : this.getItemByItemId(22071);
            }
        }
        return arrow;
    }

    public L2ItemInstance findBoltForCrossBow(L2Item crossbow) {
        L2ItemInstance bolt = null;
        switch (crossbow.getItemGradeSPlus()) {
            default: {
                bolt = this.getItemByItemId(9632);
                break;
            }
            case 1: {
                bolt = this.getItemByItemId(9633);
                bolt = bolt != null ? bolt : this.getItemByItemId(22144);
                break;
            }
            case 2: {
                bolt = this.getItemByItemId(9634);
                bolt = bolt != null ? bolt : this.getItemByItemId(22145);
                break;
            }
            case 3: {
                bolt = this.getItemByItemId(9635);
                bolt = bolt != null ? bolt : this.getItemByItemId(22146);
                break;
            }
            case 4: {
                bolt = this.getItemByItemId(9636);
                bolt = bolt != null ? bolt : this.getItemByItemId(22147);
                break;
            }
            case 5: {
                bolt = this.getItemByItemId(9637);
                bolt = bolt != null ? bolt : this.getItemByItemId(22148);
            }
        }
        return bolt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT object_id, item_id, count, enchant_level, loc, loc_data, custom_type1, custom_type2, mana_left, time FROM items WHERE owner_id=? AND (loc=? OR loc=?) ORDER BY loc_data");
            statement.setInt(1, this.getOwnerId());
            statement.setString(2, this.getBaseLocation().name());
            statement.setString(3, this.getEquipLocation().name());
            ResultSet inv = statement.executeQuery();
            while (inv.next()) {
                L2PcInstance player;
                L2ItemInstance item = L2ItemInstance.restoreFromDb(this.getOwnerId(), inv);
                if (item == null) continue;
                if (this.getOwner() instanceof L2PcInstance && !(player = (L2PcInstance)this.getOwner()).isGM() && !player.isHero() && item.isHeroItem()) {
                    item.setLocation(L2ItemInstance.ItemLocation.INVENTORY);
                }
                L2World.getInstance().storeObject(item);
                if (item.isStackable() && this.getItemByItemId(item.getItemId()) != null) {
                    this.addItem("Restore", item, this.getOwner().getActingPlayer(), null);
                    continue;
                }
                this.addItem(item);
            }
            inv.close();
            statement.close();
            this.refreshWeight();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore inventory: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public int getMaxTalismanCount() {
        return (int)this.getOwner().getStat().calcStat(Stats.TALISMAN_SLOTS, 0.0, null, null);
    }

    private void equipTalisman(L2ItemInstance item) {
        int i;
        if (this.getMaxTalismanCount() == 0) {
            return;
        }
        for (i = 24; i < 24 + this.getMaxTalismanCount(); ++i) {
            if (this._paperdoll[i] == null || this.getPaperdollItemId(i) != item.getItemId()) continue;
            this.setPaperdollItem(i, item);
            return;
        }
        for (i = 24; i < 24 + this.getMaxTalismanCount(); ++i) {
            if (this._paperdoll[i] != null) continue;
            this.setPaperdollItem(i, item);
            return;
        }
        this.setPaperdollItem(24, item);
    }

    public int getCloakStatus() {
        return (int)this.getOwner().getStat().calcStat(Stats.CLOAK_SLOT, 0.0, null, null);
    }

    public void reloadEquippedItems() {
        for (L2ItemInstance item : this._paperdoll) {
            if (item == null) continue;
            int slot = item.getLocationSlot();
            for (PaperdollListener listener : this._paperdollListeners) {
                if (listener == null) continue;
                listener.notifyUnequiped(slot, item);
                listener.notifyEquiped(slot, item);
            }
        }
    }

    final class BraceletListener
    implements PaperdollListener {
        BraceletListener() {
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item) {
            if (item.getItem().getBodyPart() == 0x100000) {
                Inventory.this.unEquipItemInSlot(24);
                Inventory.this.unEquipItemInSlot(25);
                Inventory.this.unEquipItemInSlot(26);
                Inventory.this.unEquipItemInSlot(27);
                Inventory.this.unEquipItemInSlot(28);
                Inventory.this.unEquipItemInSlot(29);
            }
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item) {
        }
    }

    final class ArmorSetListener
    implements PaperdollListener {
        ArmorSetListener() {
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item) {
            if (!(Inventory.this.getOwner() instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance player = (L2PcInstance)Inventory.this.getOwner();
            L2ItemInstance chestItem = Inventory.this.getPaperdollItem(12);
            if (chestItem == null) {
                return;
            }
            L2ArmorSet armorSet = ArmorSetsTable.getInstance().getSet(chestItem.getItemId());
            if (armorSet == null) {
                return;
            }
            boolean update = false;
            boolean updateTimeStamp = false;
            if (armorSet.containItem(slot, item.getItemId())) {
                if (armorSet.containAll(player)) {
                    int skillId6;
                    String[] skills = armorSet.getSkills();
                    if (skills != null) {
                        for (String skillInfo : skills) {
                            int skillId = 0;
                            int skillLvl = 0;
                            String[] skill = skillInfo.split("-");
                            if (skill == null || skill.length != 2) continue;
                            try {
                                skillId = Integer.parseInt(skill[0]);
                                skillLvl = Integer.parseInt(skill[1]);
                            }
                            catch (NumberFormatException e) {
                                ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + skillInfo + ".");
                            }
                            if (skillId <= 0 || skillLvl <= 0) continue;
                            L2Skill itemSkill = SkillTable.getInstance().getInfo(skillId, skillLvl);
                            if (itemSkill != null) {
                                player.addSkill(itemSkill, false);
                                if (itemSkill.isActive()) {
                                    int equipDelay;
                                    if ((player.getReuseTimeStamp().isEmpty() || !player.getReuseTimeStamp().containsKey((Object)itemSkill.getReuseHashCode())) && (equipDelay = itemSkill.getEquipDelay()) > 0) {
                                        player.addTimeStamp(itemSkill, itemSkill.getEquipDelay());
                                        player.disableSkill(itemSkill, itemSkill.getEquipDelay());
                                    }
                                    updateTimeStamp = true;
                                }
                                update = true;
                                continue;
                            }
                            ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + skillInfo + ".");
                        }
                    }
                    if (armorSet.containShield(player)) {
                        L2Skill shieldSkill = SkillTable.getInstance().getInfo(armorSet.getShieldSkillId(), 1);
                        if (shieldSkill != null) {
                            player.addSkill(shieldSkill, false);
                            update = true;
                        } else {
                            ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + armorSet.getShieldSkillId() + ".");
                        }
                    }
                    if (armorSet.isEnchanted6(player) && (skillId6 = armorSet.getEnchant6skillId()) > 0) {
                        L2Skill skille = SkillTable.getInstance().getInfo(skillId6, 1);
                        if (skille != null) {
                            player.addSkill(skille, false);
                            update = true;
                        } else {
                            ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + armorSet.getEnchant6skillId() + ".");
                        }
                    }
                }
            } else if (armorSet.containShield(item.getItemId()) && armorSet.containAll(player)) {
                L2Skill shieldSkill = SkillTable.getInstance().getInfo(armorSet.getShieldSkillId(), 1);
                if (shieldSkill != null) {
                    player.addSkill(shieldSkill, false);
                    update = true;
                } else {
                    ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + armorSet.getShieldSkillId() + ".");
                }
            }
            if (update) {
                player.sendSkillList();
                if (updateTimeStamp) {
                    player.sendPacket(new SkillCoolTime(player));
                }
            }
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item) {
            if (!(Inventory.this.getOwner() instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance player = (L2PcInstance)Inventory.this.getOwner();
            boolean remove = false;
            String[] skills = null;
            int shieldSkill = 0;
            int skillId6 = 0;
            if (slot == 12) {
                L2ArmorSet armorSet = ArmorSetsTable.getInstance().getSet(item.getItemId());
                if (armorSet == null) {
                    return;
                }
                remove = true;
                skills = armorSet.getSkills();
                shieldSkill = armorSet.getShieldSkillId();
                skillId6 = armorSet.getEnchant6skillId();
            } else {
                L2ItemInstance chestItem = Inventory.this.getPaperdollItem(12);
                if (chestItem == null) {
                    return;
                }
                L2ArmorSet armorSet = ArmorSetsTable.getInstance().getSet(chestItem.getItemId());
                if (armorSet == null) {
                    return;
                }
                if (armorSet.containItem(slot, item.getItemId())) {
                    remove = true;
                    skills = armorSet.getSkills();
                    shieldSkill = armorSet.getShieldSkillId();
                    skillId6 = armorSet.getEnchant6skillId();
                } else if (armorSet.containShield(item.getItemId())) {
                    remove = true;
                    shieldSkill = armorSet.getShieldSkillId();
                }
            }
            if (remove) {
                L2Skill skill;
                if (skills != null) {
                    for (String skillInfo : skills) {
                        int skillId = 0;
                        int skillLvl = 0;
                        String[] skill2 = skillInfo.split("-");
                        if (skill2 == null || skill2.length != 2) continue;
                        try {
                            skillId = Integer.parseInt(skill2[0]);
                            skillLvl = Integer.parseInt(skill2[1]);
                        }
                        catch (NumberFormatException e) {
                            ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + skillInfo + ".");
                        }
                        if (skillId <= 0 || skillLvl <= 0) continue;
                        L2Skill itemSkill = SkillTable.getInstance().getInfo(skillId, skillLvl);
                        if (itemSkill != null) {
                            player.removeSkill(itemSkill, false, itemSkill.isPassive());
                            continue;
                        }
                        ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + skillInfo + ".");
                    }
                }
                if (shieldSkill != 0) {
                    skill = SkillTable.getInstance().getInfo(shieldSkill, 1);
                    if (skill != null) {
                        player.removeSkill(skill, false, skill.isPassive());
                    } else {
                        ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + shieldSkill + ".");
                    }
                }
                if (skillId6 != 0) {
                    skill = SkillTable.getInstance().getInfo(skillId6, 1);
                    if (skill != null) {
                        player.removeSkill(skill, false, skill.isPassive());
                    } else {
                        ItemContainer._log.warning("Inventory.ArmorSetListener: Incorrect skill: " + skillId6 + ".");
                    }
                }
                player.checkItemRestriction();
                player.sendSkillList();
            }
        }
    }

    final class ItemSkillsListener
    implements PaperdollListener {
        ItemSkillsListener() {
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item) {
            if (!(Inventory.this.getOwner() instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance player = (L2PcInstance)Inventory.this.getOwner();
            L2Item it = item.getItem();
            boolean update = false;
            if (it instanceof L2Weapon) {
                SkillHolder[] skills;
                L2Skill enchant4Skill;
                if (item.isAugmented()) {
                    item.getAugmentation().removeBonus(player);
                }
                item.removeElementAttrBonus(player);
                if (item.getEnchantLevel() >= 4 && (enchant4Skill = ((L2Weapon)it).getEnchant4Skill()) != null) {
                    player.removeSkill(enchant4Skill, false, enchant4Skill.isPassive());
                    update = true;
                }
                if ((skills = ((L2Weapon)it).getSkills()) != null) {
                    for (SkillHolder skillInfo : skills) {
                        if (skillInfo == null) continue;
                        L2Skill itemSkill = skillInfo.getSkill();
                        if (itemSkill != null) {
                            player.removeSkill(itemSkill, false, itemSkill.isPassive());
                            update = true;
                            continue;
                        }
                        ItemContainer._log.warning("Inventory.ItemSkillsListener.Weapon: Incorrect skill: " + skillInfo + ".");
                    }
                }
            } else if (it instanceof L2Armor) {
                SkillHolder[] skills;
                L2Skill enchant4Skill;
                if (item.isAugmented()) {
                    item.getAugmentation().removeBonus(player);
                }
                item.removeElementAttrBonus(player);
                if (item.getEnchantLevel() >= 4 && (enchant4Skill = ((L2Armor)it).getEnchant4Skill()) != null) {
                    player.removeSkill(enchant4Skill, false, enchant4Skill.isPassive());
                    update = true;
                }
                if ((skills = ((L2Armor)it).getSkills()) != null) {
                    for (SkillHolder skillInfo : skills) {
                        if (skillInfo == null) continue;
                        L2Skill itemSkill = skillInfo.getSkill();
                        if (itemSkill != null) {
                            player.removeSkill(itemSkill, false, itemSkill.isPassive());
                            update = true;
                            continue;
                        }
                        ItemContainer._log.warning("Inventory.ItemSkillsListener.Armor: Incorrect skill: " + skillInfo + ".");
                    }
                }
            }
            if (update) {
                player.sendSkillList();
            }
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item) {
            if (!(Inventory.this.getOwner() instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance player = (L2PcInstance)Inventory.this.getOwner();
            L2Item it = item.getItem();
            boolean update = false;
            boolean updateTimeStamp = false;
            if (it instanceof L2Weapon) {
                SkillHolder[] skills;
                L2Skill enchant4Skill;
                if (item.isAugmented()) {
                    item.getAugmentation().applyBonus(player);
                }
                item.updateElementAttrBonus(player);
                if (item.getEnchantLevel() >= 4 && (enchant4Skill = ((L2Weapon)it).getEnchant4Skill()) != null) {
                    player.addSkill(enchant4Skill, false);
                    update = true;
                }
                if ((skills = ((L2Weapon)it).getSkills()) != null) {
                    for (SkillHolder skillInfo : skills) {
                        if (skillInfo == null) continue;
                        L2Skill itemSkill = skillInfo.getSkill();
                        if (itemSkill != null) {
                            player.addSkill(itemSkill, false);
                            if (itemSkill.isActive()) {
                                int equipDelay;
                                if ((player.getReuseTimeStamp().isEmpty() || !player.getReuseTimeStamp().containsKey((Object)itemSkill.getReuseHashCode())) && (equipDelay = itemSkill.getEquipDelay()) > 0) {
                                    player.addTimeStamp(itemSkill, equipDelay);
                                    player.disableSkill(itemSkill, equipDelay);
                                }
                                updateTimeStamp = true;
                            }
                            update = true;
                            continue;
                        }
                        ItemContainer._log.warning("Inventory.ItemSkillsListener.Weapon: Incorrect skill: " + skillInfo + ".");
                    }
                }
            } else if (it instanceof L2Armor) {
                SkillHolder[] skills;
                L2Skill enchant4Skill;
                if (item.isAugmented()) {
                    item.getAugmentation().applyBonus(player);
                }
                item.updateElementAttrBonus(player);
                if (item.getEnchantLevel() >= 4 && (enchant4Skill = ((L2Armor)it).getEnchant4Skill()) != null) {
                    player.addSkill(enchant4Skill, false);
                    update = true;
                }
                if ((skills = ((L2Armor)it).getSkills()) != null) {
                    for (SkillHolder skillInfo : skills) {
                        if (skillInfo == null) continue;
                        L2Skill itemSkill = skillInfo.getSkill();
                        if (itemSkill != null) {
                            player.addSkill(itemSkill, false);
                            if (itemSkill.isActive()) {
                                int equipDelay;
                                if ((player.getReuseTimeStamp().isEmpty() || !player.getReuseTimeStamp().containsKey((Object)itemSkill.getReuseHashCode())) && (equipDelay = itemSkill.getEquipDelay()) > 0) {
                                    player.addTimeStamp(itemSkill, itemSkill.getEquipDelay());
                                    player.disableSkill(itemSkill, itemSkill.getEquipDelay());
                                }
                                updateTimeStamp = true;
                            }
                            update = true;
                            continue;
                        }
                        ItemContainer._log.warning("Inventory.ItemSkillsListener.Armor: Incorrect skill: " + skillInfo + ".");
                    }
                }
            }
            if (update) {
                player.sendSkillList();
                if (updateTimeStamp) {
                    player.sendPacket(new SkillCoolTime(player));
                }
            }
        }
    }

    final class StatsListener
    implements PaperdollListener {
        StatsListener() {
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item) {
            if (slot == 16) {
                return;
            }
            Inventory.this.getOwner().removeStatsOwner(item);
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item) {
            if (slot == 16) {
                return;
            }
            Inventory.this.getOwner().addStatFuncs(item.getStatFuncs(Inventory.this.getOwner()));
        }
    }

    final class BowListener
    implements PaperdollListener {
        BowListener() {
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item) {
            L2ItemInstance arrow;
            if (slot != 16) {
                return;
            }
            assert (null == Inventory.this.getPaperdollItem(16));
            if (item.getItemType() == L2WeaponType.BOW && (arrow = Inventory.this.getPaperdollItem(10)) != null) {
                Inventory.this.setPaperdollItem(10, null);
            }
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item) {
            L2ItemInstance arrow;
            if (slot != 16) {
                return;
            }
            assert (item == Inventory.this.getPaperdollItem(16));
            if (item.getItemType() == L2WeaponType.BOW && (arrow = Inventory.this.findArrowForBow(item.getItem())) != null) {
                Inventory.this.setPaperdollItem(10, arrow);
            }
        }
    }

    final class CrossBowListener
    implements PaperdollListener {
        CrossBowListener() {
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item) {
            L2ItemInstance bolts;
            if (slot != 9) {
                return;
            }
            assert (null == Inventory.this.getPaperdollItem(9));
            if (item.getItemType() == L2WeaponType.CROSSBOW && (bolts = Inventory.this.getPaperdollItem(10)) != null) {
                Inventory.this.setPaperdollItem(10, null);
            }
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item) {
            L2ItemInstance bolts;
            if (slot != 9) {
                return;
            }
            assert (item == Inventory.this.getPaperdollItem(9));
            if (item.getItemType() == L2WeaponType.CROSSBOW && (bolts = Inventory.this.findBoltForCrossBow(item.getItem())) != null) {
                Inventory.this.setPaperdollItem(10, bolts);
            }
        }
    }

    public static final class ChangeRecorder
    implements PaperdollListener {
        private final Inventory _inventory;
        private final List<L2ItemInstance> _changed;

        ChangeRecorder(Inventory inventory) {
            this._inventory = inventory;
            this._changed = new FastList();
            this._inventory.addPaperdollListener(this);
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item) {
            if (!this._changed.contains(item)) {
                this._changed.add(item);
            }
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item) {
            if (!this._changed.contains(item)) {
                this._changed.add(item);
            }
        }

        public L2ItemInstance[] getChangedItems() {
            return this._changed.toArray(new L2ItemInstance[this._changed.size()]);
        }
    }

    final class FormalWearListener
    implements PaperdollListener {
        FormalWearListener() {
        }

        @Override
        public void notifyUnequiped(int slot, L2ItemInstance item) {
            if (Inventory.this.getOwner() == null || !(Inventory.this.getOwner() instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance owner = (L2PcInstance)Inventory.this.getOwner();
            if (item.getItemId() == 6408) {
                owner.setIsWearingFormalWear(false);
            }
        }

        @Override
        public void notifyEquiped(int slot, L2ItemInstance item) {
            if (Inventory.this.getOwner() == null || !(Inventory.this.getOwner() instanceof L2PcInstance)) {
                return;
            }
            L2PcInstance owner = (L2PcInstance)Inventory.this.getOwner();
            if (item.getItemId() == 6408) {
                owner.setIsWearingFormalWear(true);
            } else if (!owner.isWearingFormalWear()) {
                return;
            }
        }
    }

    public static interface PaperdollListener {
        public void notifyEquiped(int var1, L2ItemInstance var2);

        public void notifyUnequiped(int var1, L2ItemInstance var2);
    }
}

