/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.zone.L2SpawnZone;

public class L2CastleZone
extends L2SpawnZone {
    private int _castleId;
    private Castle _castle = null;

    public L2CastleZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("castleId")) {
            this._castleId = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (this.getCastle() != null) {
            character.setInsideZone((byte)10, true);
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (this.getCastle() != null) {
            character.setInsideZone((byte)10, false);
        }
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    public void banishForeigners(int owningClanId) {
        for (L2Character temp : this._characterList.values()) {
            if (!(temp instanceof L2PcInstance) || ((L2PcInstance)temp).getClanId() == owningClanId) continue;
            ((L2PcInstance)temp).teleToLocation(MapRegionTable.TeleportWhereType.Town);
        }
    }

    public int getCastleId() {
        return this._castleId;
    }

    private final Castle getCastle() {
        if (this._castle == null) {
            this._castle = CastleManager.getInstance().getCastleById(this._castleId);
        }
        return this._castle;
    }
}

