/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExRotation;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public class AnswerCoupleAction
extends L2GameClientPacket {
    private static final String _S__3D_SOCIALACTION = "[C] D0:7A AnswerCoupleAction";
    private int _charObjId;
    private int _actionId;
    private int _answer;

    @Override
    protected void readImpl() {
        this._actionId = this.readD();
        this._answer = this.readD();
        this._charObjId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        L2PcInstance target = L2World.getInstance().getPlayer(this._charObjId);
        if (activeChar == null || target == null) {
            return;
        }
        if (target.getMultiSocialTarget() != activeChar.getObjectId() || target.getMultiSociaAction() != this._actionId) {
            return;
        }
        if (this._answer == 0) {
            target.setMultiSocialAction(0, 0);
            target.sendPacket(SystemMessageId.COUPLE_ACTION_DENIED);
        } else if (this._answer == 1) {
            double distance = activeChar.getPlanDistanceSq(target);
            if (distance > 2000.0 || distance < 70.0) {
                activeChar.sendPacket(SystemMessageId.TARGET_DO_NOT_MEET_LOC_REQUIREMENTS);
                target.sendPacket(SystemMessageId.TARGET_DO_NOT_MEET_LOC_REQUIREMENTS);
                return;
            }
            int heading = Util.calculateHeadingFrom(activeChar, target);
            activeChar.broadcastPacket(new ExRotation(activeChar.getObjectId(), heading));
            activeChar.setHeading(heading);
            heading = Util.calculateHeadingFrom(target, activeChar);
            target.setHeading(heading);
            target.broadcastPacket(new ExRotation(target.getObjectId(), heading));
            activeChar.broadcastPacket(new SocialAction(activeChar.getObjectId(), this._actionId));
            target.broadcastPacket(new SocialAction(this._charObjId, this._actionId));
        } else if (this._answer == -1) {
            SystemMessage sm = new SystemMessage(SystemMessageId.C1_IS_SET_TO_REFUSE_COUPLE_ACTIONS);
            sm.addPcName(activeChar);
            target.sendPacket(sm);
        }
    }

    @Override
    public String getType() {
        return _S__3D_SOCIALACTION;
    }
}

