/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class Logout
extends L2GameClientPacket {
    private static final String _C__09_LOGOUT = "[C] 09 Logout";
    private static final Logger _log = Logger.getLogger(Logout.class.getName());
    protected static final Logger _logAccounting = Logger.getLogger("accounting");

    @Override
    protected void readImpl() {
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (player.isFlying()) {
            player.sendPacket(new SystemMessage(SystemMessageId.NO_LOGOUT_HERE));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.getActiveEnchantItem() != null || player.getActiveEnchantAttrItem() != null) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isLocked()) {
            _log.warning("Player " + player.getName() + " tried to logout during class change.");
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!(!AttackStanceTaskManager.getInstance().getAttackStanceTask(player) || player.isGM() && Config.GM_RESTART_FIGHTING)) {
            if (Config.DEBUG) {
                _log.fine("Player " + player.getName() + " tried to logout while fighting");
            }
            player.sendPacket(new SystemMessage(SystemMessageId.CANT_LOGOUT_WHILE_FIGHTING));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.atEvent) {
            player.sendMessage("A superior power doesn't allow you to leave the event");
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isFestivalParticipant()) {
            if (SevenSignsFestival.getInstance().isFestivalInitialized()) {
                player.sendMessage("\u796d\u5178\u306b\u53c2\u52a0\u4e2d\u306f\u30ed\u30b0\u30a2\u30a6\u30c8\u3067\u304d\u307e\u305b\u3093\u3002");
                player.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            L2Party playerParty = player.getParty();
            if (playerParty != null) {
                player.getParty().broadcastToPartyMembers(SystemMessage.sendString(player.getName() + " has been removed from the upcoming festival."));
            }
        }
        player.removeFromBossZone();
        LogRecord record = new LogRecord(Level.INFO, "Disconnected");
        record.setParameters(new Object[]{this.getClient()});
        _logAccounting.log(record);
        player.logout();
    }

    @Override
    public String getType() {
        return _C__09_LOGOUT;
    }
}

