/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Logger;

public final class RequestBlock
extends L2GameClientPacket {
    private static final String _C__A0_REQUESTBLOCK = "[C] A0 RequestBlock";
    private static Logger _log = Logger.getLogger(L2PcInstance.class.getName());
    private static final int BLOCK = 0;
    private static final int UNBLOCK = 1;
    private static final int BLOCKLIST = 2;
    private static final int ALLBLOCK = 3;
    private static final int ALLUNBLOCK = 4;
    private String _name;
    private int _type;

    @Override
    protected void readImpl() {
        this._type = this.readD();
        if (this._type == 0 || this._type == 1) {
            this._name = this.readS();
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        int targetId = CharNameTable.getInstance().getIdByName(this._name);
        int targetAL = CharNameTable.getInstance().getAccessLevelById(targetId);
        if (activeChar == null) {
            return;
        }
        switch (this._type) {
            case 0: 
            case 1: {
                if (targetId <= 0) {
                    activeChar.sendPacket(new SystemMessage(SystemMessageId.FAILED_TO_REGISTER_TO_IGNORE_LIST));
                    return;
                }
                if (targetAL > 0) {
                    activeChar.sendPacket(new SystemMessage(SystemMessageId.YOU_MAY_NOT_IMPOSE_A_BLOCK_ON_GM));
                    return;
                }
                if (activeChar.getObjectId() == targetId) {
                    return;
                }
                if (this._type == 0) {
                    BlockList.addToBlockList(activeChar, targetId);
                    break;
                }
                BlockList.removeFromBlockList(activeChar, targetId);
                break;
            }
            case 2: {
                BlockList.sendListToOwner(activeChar);
                break;
            }
            case 3: {
                activeChar.sendPacket(new SystemMessage(SystemMessageId.MESSAGE_REFUSAL_MODE));
                BlockList.setBlockAll(activeChar, true);
                break;
            }
            case 4: {
                activeChar.sendPacket(new SystemMessage(SystemMessageId.MESSAGE_ACCEPTANCE_MODE));
                BlockList.setBlockAll(activeChar, false);
                break;
            }
            default: {
                _log.info("Unknown 0x0a block type: " + this._type);
            }
        }
    }

    @Override
    public String getType() {
        return _C__A0_REQUESTBLOCK;
    }
}

