/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.Elementals;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExAttributeEnchantResult;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;

public class RequestExEnchantItemAttribute
extends L2GameClientPacket {
    private static final String D0_35_REQUEST_EX_ENCHANT_ITEM_ATTRIBUTE = "[C] D0:35 RequestExEnchantItemAttribute";
    private int _objectId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
    }

    @Override
    protected void runImpl() {
        int newPower;
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (this._objectId == -1) {
            player.setActiveEnchantAttrItem(null);
            player.sendPacket(new SystemMessage(SystemMessageId.ELEMENTAL_ENHANCE_CANCELED));
            return;
        }
        if (!player.isOnline()) {
            player.setActiveEnchantAttrItem(null);
            return;
        }
        if (player.getPrivateStoreType() != 0) {
            player.sendPacket(new SystemMessage(SystemMessageId.CANNOT_ADD_ELEMENTAL_POWER_WHILE_OPERATING_PRIVATE_STORE_OR_WORKSHOP));
            player.setActiveEnchantAttrItem(null);
            return;
        }
        if (player.getActiveRequester() != null) {
            player.cancelActiveTrade();
            player.setActiveEnchantAttrItem(null);
            player.sendMessage("Enchanting items is not allowed during a trade.");
            return;
        }
        L2ItemInstance item = player.getInventory().getItemByObjectId(this._objectId);
        L2ItemInstance stone = player.getActiveEnchantAttrItem();
        if (item == null || stone == null) {
            player.setActiveEnchantAttrItem(null);
            return;
        }
        if (item.getLocation() != L2ItemInstance.ItemLocation.INVENTORY && item.getLocation() != L2ItemInstance.ItemLocation.PAPERDOLL) {
            player.setActiveEnchantAttrItem(null);
            return;
        }
        if (item.isWear()) {
            Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to enchant a weared Item", Config.DEFAULT_PUNISH);
            return;
        }
        if (item.getItem().getItemType() == L2WeaponType.ROD || item.isShadowItem() || item.isPvp() || item.isHeroItem() || item.isTimeLimitedItem() || item.getItemId() >= 7816 && item.getItemId() <= 7831 || item.getItem().getItemType() == L2WeaponType.NONE || item.getItem().getItemGradeSPlus() != 5 || item.getItem().getBodyPart() == 8192 || item.getItem().getBodyPart() == 0x100000 || item.getItem().getBodyPart() == 1 || item.getItem().getBodyPart() == 0x10000000 || item.getItem().getBodyPart() == 8 || item.getItem().getBodyPart() == 2 || item.getItem().getBodyPart() == 16 || item.getItem().getElementals() != null) {
            player.sendPacket(new SystemMessage(SystemMessageId.ELEMENTAL_ENHANCE_REQUIREMENT_NOT_SUFFICIENT));
            player.setActiveEnchantAttrItem(null);
            return;
        }
        switch (item.getLocation()) {
            case INVENTORY: 
            case PAPERDOLL: {
                if (item.getOwnerId() == player.getObjectId()) break;
                player.setActiveEnchantAttrItem(null);
                return;
            }
            default: {
                player.setActiveEnchantAttrItem(null);
                Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to use enchant Exploit!", Config.DEFAULT_PUNISH);
                return;
            }
        }
        int stoneId = stone.getItemId();
        byte elementToAdd = Elementals.getItemElement(stoneId);
        if (item.isArmor()) {
            elementToAdd = Elementals.getOppositeElement(elementToAdd);
        }
        byte opositeElement = Elementals.getOppositeElement(elementToAdd);
        Elementals oldElement = item.getElemental(elementToAdd);
        int elementValue = oldElement == null ? 0 : oldElement.getValue();
        int limit = this.getLimit(item, stoneId);
        int powerToAdd = this.getPowerToAdd(stoneId, elementValue, item);
        if (item.isWeapon() && oldElement != null && oldElement.getElement() != elementToAdd && oldElement.getElement() != -2 || item.isArmor() && item.getElemental(elementToAdd) == null && item.getElementals() != null && item.getElementals().length >= 3) {
            player.sendPacket(new SystemMessage(SystemMessageId.ANOTHER_ELEMENTAL_POWER_ALREADY_ADDED));
            player.setActiveEnchantAttrItem(null);
            return;
        }
        if (item.isArmor() && item.getElementals() != null) {
            for (Elementals elm : item.getElementals()) {
                if (elm.getElement() != opositeElement) continue;
                player.setActiveEnchantAttrItem(null);
                Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to add oposite attribute to item!", Config.DEFAULT_PUNISH);
                return;
            }
        }
        if ((newPower = elementValue + powerToAdd) > limit) {
            newPower = limit;
            powerToAdd = limit - elementValue;
        }
        if (powerToAdd <= 0) {
            player.sendPacket(new SystemMessage(SystemMessageId.ELEMENTAL_ENHANCE_CANCELED));
            player.setActiveEnchantAttrItem(null);
            return;
        }
        if (!player.destroyItem("AttrEnchant", stone, 1L, (L2Object)player, true)) {
            player.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_ITEMS));
            Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to attribute enchant with a stone he doesn't have", Config.DEFAULT_PUNISH);
            player.setActiveEnchantAttrItem(null);
            return;
        }
        if (Rnd.get(100) < Config.ENCHANT_CHANCE_ELEMENT) {
            SystemMessage sm;
            byte realElement;
            byte by = realElement = item.isArmor() ? opositeElement : elementToAdd;
            if (item.getEnchantLevel() == 0) {
                sm = item.isArmor() ? new SystemMessage(SystemMessageId.THE_S2_ATTRIBUTE_WAS_SUCCESSFULLY_BESTOWED_ON_S1_RES_TO_S3_INCREASED) : new SystemMessage(SystemMessageId.ELEMENTAL_POWER_S2_SUCCESSFULLY_ADDED_TO_S1);
                sm.addItemName(item);
                sm.addElemntal(realElement);
                if (item.isArmor()) {
                    sm.addElemntal(Elementals.getOppositeElement(realElement));
                }
            } else {
                sm = item.isArmor() ? new SystemMessage(SystemMessageId.THE_S3_ATTRIBUTE_BESTOWED_ON_S1_S2_RESISTANCE_TO_S4_INCREASED) : new SystemMessage(SystemMessageId.ELEMENTAL_POWER_S3_SUCCESSFULLY_ADDED_TO_S1_S2);
                sm.addNumber(item.getEnchantLevel());
                sm.addItemName(item);
                sm.addElemntal(realElement);
                if (item.isArmor()) {
                    sm.addElemntal(Elementals.getOppositeElement(realElement));
                }
            }
            player.sendPacket(sm);
            item.setElementAttr(elementToAdd, newPower);
            if (item.isEquipped()) {
                item.updateElementAttrBonus(player);
            }
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(item);
            player.sendPacket(iu);
        } else {
            player.sendPacket(new SystemMessage(SystemMessageId.FAILED_ADDING_ELEMENTAL_POWER));
        }
        player.sendPacket(new ExAttributeEnchantResult(powerToAdd));
        player.sendPacket(new UserInfo(player));
        player.sendPacket(new ExBrExtraUserInfo(player));
        player.setActiveEnchantAttrItem(null);
    }

    public int getLimit(L2ItemInstance item, int sotneId) {
        Elementals.ElementalItems elementItem = Elementals.getItemElemental(sotneId);
        if (elementItem == null) {
            return 0;
        }
        if (item.isWeapon()) {
            return Elementals.WEAPON_VALUES[elementItem._type._maxLevel];
        }
        return Elementals.ARMOR_VALUES[elementItem._type._maxLevel];
    }

    public int getPowerToAdd(int stoneId, int oldValue, L2ItemInstance item) {
        if (Elementals.getItemElement(stoneId) != -1) {
            if (item.isWeapon()) {
                if (oldValue == 0) {
                    return 20;
                }
                return 5;
            }
            if (item.isArmor()) {
                return 6;
            }
        }
        return 0;
    }

    @Override
    public String getType() {
        return D0_35_REQUEST_EX_ENCHANT_ITEM_ATTRIBUTE;
    }
}

