/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.cache.CrestCache;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RequestExSetPledgeCrestLarge
extends L2GameClientPacket {
    private static final String _C__D0_11_REQUESTEXSETPLEDGECRESTLARGE = "[C] D0:11 RequestExSetPledgeCrestLarge";
    static Logger _log = Logger.getLogger(RequestExSetPledgeCrestLarge.class.getName());
    private int _length;
    private byte[] _data;

    @Override
    protected void readImpl() {
        this._length = this.readD();
        if (this._length > 2176) {
            return;
        }
        this._data = new byte[this._length];
        this.readB(this._data);
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Clan clan = activeChar.getClan();
        if (clan == null) {
            return;
        }
        if (this._length < 0) {
            activeChar.sendMessage("File transfer error.");
            return;
        }
        if (this._length > 2176) {
            activeChar.sendMessage("The insignia file size is greater than 2176 bytes.");
            return;
        }
        boolean updated = false;
        int crestLargeId = -1;
        if ((activeChar.getClanPrivileges() & 0x80) == 128) {
            if (this._length == 0 || this._data == null) {
                if (clan.getCrestLargeId() == 0) {
                    return;
                }
                crestLargeId = 0;
                activeChar.sendMessage("The insignia has been removed.");
                updated = true;
            } else {
                if (clan.getHasCastle() == 0 && clan.getHasHideout() == 0) {
                    activeChar.sendMessage("Only a clan that owns a clan hall or a castle can get their emblem displayed on clan related items");
                    return;
                }
                crestLargeId = IdFactory.getInstance().getNextId();
                if (!CrestCache.getInstance().savePledgeCrestLarge(crestLargeId, this._data)) {
                    _log.log(Level.INFO, "Error saving large crest for clan " + clan.getName() + " [" + clan.getClanId() + "]");
                    return;
                }
                activeChar.sendPacket(new SystemMessage(SystemMessageId.CLAN_EMBLEM_WAS_SUCCESSFULLY_REGISTERED));
                updated = true;
            }
        }
        if (updated && crestLargeId != -1) {
            clan.changeLargeCrest(crestLargeId);
        }
    }

    @Override
    public String getType() {
        return _C__D0_11_REQUESTEXSETPLEDGECRESTLARGE;
    }
}

