/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Manor;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2ManorManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.item.L2Item;

public class RequestProcureCropList
extends L2GameClientPacket {
    private static final String _C__D0_09_REQUESTPROCURECROPLIST = "[C] D0:09 RequestProcureCropList";
    private static final int BATCH_LENGTH = 20;
    private Crop[] _items = null;

    @Override
    protected void readImpl() {
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 20 != this._buf.remaining()) {
            return;
        }
        this._items = new Crop[count];
        for (int i = 0; i < count; ++i) {
            int objId = this.readD();
            int itemId = this.readD();
            int manorId = this.readD();
            long cnt = this.readQ();
            if (objId < 1 || itemId < 1 || manorId < 0 || cnt < 0L) {
                this._items = null;
                return;
            }
            this._items[i] = new Crop(objId, itemId, manorId, cnt);
        }
    }

    @Override
    protected void runImpl() {
        if (this._items == null) {
            return;
        }
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        L2Object manager = player.getTarget();
        if (!(manager instanceof L2ManorManagerInstance)) {
            manager = player.getLastFolkNPC();
        }
        if (!(manager instanceof L2ManorManagerInstance)) {
            return;
        }
        if (!player.isInsideRadius(manager, 150, false, false)) {
            return;
        }
        if (this._items == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        int castleId = ((L2ManorManagerInstance)manager).getCastle().getCastleId();
        int slots = 0;
        int weight = 0;
        for (Crop i : this._items) {
            if (!i.getCrop()) continue;
            L2Item template = ItemTable.getInstance().getTemplate(i.getReward());
            weight = (int)((long)weight + i.getCount() * (long)template.getWeight());
            if (!template.isStackable()) {
                slots = (int)((long)slots + i.getCount());
                continue;
            }
            if (player.getInventory().getItemByItemId(i.getItemId()) != null) continue;
            ++slots;
        }
        if (!player.getInventory().validateWeight(weight)) {
            this.sendPacket(new SystemMessage(SystemMessageId.WEIGHT_LIMIT_EXCEEDED));
            return;
        }
        if (!player.getInventory().validateCapacity(slots)) {
            this.sendPacket(new SystemMessage(SystemMessageId.SLOTS_FULL));
            return;
        }
        InventoryUpdate playerIU = new InventoryUpdate();
        for (Crop i : this._items) {
            SystemMessage sm;
            if (i.getReward() == 0) continue;
            long fee = i.getFee(castleId);
            long rewardPrice = ItemTable.getInstance().getTemplate(i.getReward()).getReferencePrice();
            if (rewardPrice == 0L) continue;
            long rewardItemCount = i.getPrice() / rewardPrice;
            if (rewardItemCount < 1L) {
                sm = new SystemMessage(SystemMessageId.FAILED_IN_TRADING_S2_OF_CROP_S1);
                sm.addItemName(i.getItemId());
                sm.addItemNumber(i.getCount());
                player.sendPacket(sm);
                continue;
            }
            if (player.getInventory().getAdena() < fee) {
                sm = new SystemMessage(SystemMessageId.FAILED_IN_TRADING_S2_OF_CROP_S1);
                sm.addItemName(i.getItemId());
                sm.addItemNumber(i.getCount());
                player.sendPacket(sm);
                sm = new SystemMessage(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
                player.sendPacket(sm);
                continue;
            }
            L2ItemInstance itemDel = null;
            L2ItemInstance itemAdd = null;
            L2ItemInstance item = player.getInventory().getItemByObjectId(i.getObjectId());
            if (item == null || item.getCount() < i.getCount() || (itemDel = player.getInventory().destroyItem("Manor", i.getObjectId(), i.getCount(), player, (Object)manager)) == null) continue;
            if (fee > 0L) {
                player.getInventory().reduceAdena("Manor", fee, player, manager);
            }
            i.setCrop();
            itemAdd = player.getInventory().addItem("Manor", i.getReward(), rewardItemCount, player, manager);
            if (itemAdd == null) continue;
            playerIU.addRemovedItem(itemDel);
            if (itemAdd.getCount() > rewardItemCount) {
                playerIU.addModifiedItem(itemAdd);
            } else {
                playerIU.addNewItem(itemAdd);
            }
            SystemMessage sm2 = new SystemMessage(SystemMessageId.TRADED_S2_OF_CROP_S1);
            sm2.addItemName(i.getItemId());
            sm2.addItemNumber(i.getCount());
            player.sendPacket(sm2);
            if (fee > 0L) {
                sm2 = new SystemMessage(SystemMessageId.S1_ADENA_HAS_BEEN_WITHDRAWN_TO_PAY_FOR_PURCHASING_FEES);
                sm2.addItemNumber(fee);
                player.sendPacket(sm2);
            }
            sm2 = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
            sm2.addItemName(i.getItemId());
            sm2.addItemNumber(i.getCount());
            player.sendPacket(sm2);
            if (fee > 0L) {
                sm2 = new SystemMessage(SystemMessageId.DISAPPEARED_ADENA);
                sm2.addItemNumber(fee);
                player.sendPacket(sm2);
            }
            sm2 = new SystemMessage(SystemMessageId.EARNED_S2_S1_S);
            sm2.addItemName(itemAdd);
            sm2.addItemNumber(rewardItemCount);
            player.sendPacket(sm2);
        }
        player.sendPacket(playerIU);
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
    }

    @Override
    public String getType() {
        return _C__D0_09_REQUESTPROCURECROPLIST;
    }

    private static class Crop {
        private final int _objectId;
        private final int _itemId;
        private final int _manorId;
        private final long _count;
        private int _reward = 0;
        private CastleManorManager.CropProcure _crop = null;

        public Crop(int obj, int id, int m, long num) {
            this._objectId = obj;
            this._itemId = id;
            this._manorId = m;
            this._count = num;
        }

        public int getObjectId() {
            return this._objectId;
        }

        public int getItemId() {
            return this._itemId;
        }

        public long getCount() {
            return this._count;
        }

        public int getReward() {
            return this._reward;
        }

        public long getPrice() {
            return this._crop.getPrice() * this._count;
        }

        public long getFee(int castleId) {
            if (this._manorId == castleId) {
                return 0L;
            }
            return this.getPrice() / 100L * 5L;
        }

        public boolean getCrop() {
            try {
                this._crop = CastleManager.getInstance().getCastleById(this._manorId).getCrop(this._itemId, 0);
            }
            catch (NullPointerException e) {
                return false;
            }
            if (this._crop == null || this._crop.getId() == 0 || this._crop.getPrice() == 0L || this._count == 0L) {
                return false;
            }
            if (this._count > this._crop.getAmount()) {
                return false;
            }
            if (99900000000L / this._count < this._crop.getPrice()) {
                return false;
            }
            this._reward = L2Manor.getInstance().getRewardItem(this._itemId, this._crop.getReward());
            return true;
        }

        public void setCrop() {
            this._crop.setAmount(this._crop.getAmount() - this._count);
            if (Config.ALT_MANOR_SAVE_ALL_ACTIONS) {
                CastleManager.getInstance().getCastleById(this._manorId).updateCrop(this._itemId, this._crop.getAmount(), 0);
            }
        }
    }
}

