/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreManageListBuy;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreMsgBuy;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.util.Util;

public final class SetPrivateStoreListBuy
extends L2GameClientPacket {
    private static final String _C__91_SETPRIVATESTORELISTBUY = "[C] 91 SetPrivateStoreListBuy";
    private static final int BATCH_LENGTH = 40;
    private Item[] _items = null;

    @Override
    protected void readImpl() {
        int count = this.readD();
        if (count < 1 || count > Config.MAX_ITEM_IN_PACKET || count * 40 != this._buf.remaining()) {
            return;
        }
        this._items = new Item[count];
        for (int i = 0; i < count; ++i) {
            int itemId = this.readD();
            this.readD();
            long cnt = this.readQ();
            long price = this.readQ();
            if (itemId < 1 || cnt < 1L || price < 0L) {
                this._items = null;
                return;
            }
            this.readD();
            this.readD();
            this.readD();
            this.readD();
            this._items[i] = new Item(itemId, cnt, price);
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (this._items == null) {
            player.setPrivateStoreType(0);
            player.broadcastUserInfo();
            return;
        }
        if (!player.getAccessLevel().allowTransaction()) {
            player.sendPacket(new SystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
            return;
        }
        if (AttackStanceTaskManager.getInstance().getAttackStanceTask(player) || player.isInDuel()) {
            player.sendPacket(new SystemMessage(SystemMessageId.CANT_OPERATE_PRIVATE_STORE_DURING_COMBAT));
            player.sendPacket(new PrivateStoreManageListBuy(player));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isInsideZone((byte)14)) {
            player.sendPacket(new PrivateStoreManageListBuy(player));
            player.sendPacket(new SystemMessage(SystemMessageId.NO_PRIVATE_STORE_HERE));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        TradeList tradeList = player.getBuyList();
        tradeList.clear();
        if (this._items.length > player.getPrivateBuyStoreLimit()) {
            player.sendPacket(new PrivateStoreManageListBuy(player));
            player.sendPacket(new SystemMessage(SystemMessageId.YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED));
            return;
        }
        long totalCost = 0L;
        for (Item i : this._items) {
            if (!i.addToTradeList(tradeList)) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to set price more than " + 99900000000L + " adena in Private Store - Buy.", Config.DEFAULT_PUNISH);
                return;
            }
            if ((totalCost += i.getCost()) <= 99900000000L) continue;
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to set total price more than " + 99900000000L + " adena in Private Store - Buy.", Config.DEFAULT_PUNISH);
            return;
        }
        if (totalCost > player.getAdena()) {
            player.sendPacket(new PrivateStoreManageListBuy(player));
            player.sendPacket(new SystemMessage(SystemMessageId.THE_PURCHASE_PRICE_IS_HIGHER_THAN_MONEY));
            return;
        }
        player.sitDown();
        player.setPrivateStoreType(3);
        player.broadcastUserInfo();
        player.broadcastPacket(new PrivateStoreMsgBuy(player));
    }

    @Override
    public String getType() {
        return _C__91_SETPRIVATESTORELISTBUY;
    }

    private static class Item {
        private final int _itemId;
        private final long _count;
        private final long _price;

        public Item(int id, long num, long pri) {
            this._itemId = id;
            this._count = num;
            this._price = pri;
        }

        public boolean addToTradeList(TradeList list) {
            if (99900000000L / this._count < this._price) {
                return false;
            }
            list.addItemByItemId(this._itemId, this._count, this._price);
            return true;
        }

        public long getCost() {
            return this._count * this._price;
        }
    }
}

