/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills;

import com.l2jserver.Config;
import com.l2jserver.gameserver.Item;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.skills.DocumentItem;
import com.l2jserver.gameserver.skills.DocumentSkill;
import com.l2jserver.gameserver.templates.item.L2Armor;
import com.l2jserver.gameserver.templates.item.L2EtcItem;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javolution.util.FastList;

public class SkillsEngine {
    protected final Logger _log = Logger.getLogger(SkillsEngine.class.getName());

    public static SkillsEngine getInstance() {
        return SingletonHolder._instance;
    }

    private SkillsEngine() {
    }

    private List<File> hashFiles(String dirname) {
        FastList hash = new FastList();
        File dir = new File(Config.DATAPACK_ROOT, dirname);
        if (!dir.exists()) {
            this._log.warning("Dir " + dir.getAbsolutePath() + " not exists");
            return hash;
        }
        for (File f : dir.listFiles()) {
            if (!f.getName().endsWith(".xml") || f.getName().startsWith("custom")) continue;
            hash.add(f);
        }
        File customfile = new File(Config.DATAPACK_ROOT, dirname + "/custom.xml");
        if (customfile.exists()) {
            hash.add(customfile);
        }
        return hash;
    }

    private List<L2Skill> loadSkills(File file) {
        if (file == null) {
            this._log.warning("Skill file not found.");
            return null;
        }
        DocumentSkill doc = new DocumentSkill(file);
        doc.parse();
        return doc.getSkills();
    }

    public void loadAllSkills(TIntObjectHashMap<L2Skill> allSkills) {
        int count = 0;
        for (File file : this.hashFiles("data/stats/skills")) {
            List<L2Skill> s = this.loadSkills(file);
            if (s == null) continue;
            for (L2Skill skill : s) {
                allSkills.put(SkillTable.getSkillHashCode(skill), (Object)skill);
                ++count;
            }
        }
        this._log.info("SkillsEngine: Loaded " + count + " Skill templates from XML files.");
    }

    public List<L2Armor> loadArmors(Map<Integer, Item> armorData) {
        FastList list = new FastList();
        for (L2Item item : this.loadData(armorData, this.hashFiles("data/stats/armor"))) {
            list.add((L2Armor)item);
        }
        return list;
    }

    public List<L2Weapon> loadWeapons(Map<Integer, Item> weaponData) {
        FastList list = new FastList();
        for (L2Item item : this.loadData(weaponData, this.hashFiles("data/stats/weapon"))) {
            list.add((L2Weapon)item);
        }
        return list;
    }

    public List<L2EtcItem> loadItems(Map<Integer, Item> itemData) {
        FastList list = new FastList();
        FastList xmlItem = new FastList();
        for (L2Item l2Item : this.loadData(itemData, this.hashFiles("data/stats/etcitem"))) {
            list.add((L2EtcItem)l2Item);
            xmlItem.add(l2Item.getItemId());
        }
        for (Item item : itemData.values()) {
            if (xmlItem.contains(item.id)) continue;
            list.add(new L2EtcItem((L2EtcItemType)item.type, item.set));
        }
        return list;
    }

    private List<L2Item> loadData(Map<Integer, Item> itemData, List<File> files) {
        FastList list = new FastList();
        for (File f : files) {
            DocumentItem document = new DocumentItem(itemData, f);
            document.parse();
            list.addAll(document.getItemList());
        }
        return list;
    }

    private static class SingletonHolder {
        protected static final SkillsEngine _instance = new SkillsEngine();

        private SingletonHolder() {
        }
    }
}

