/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.templates.item;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.Elementals;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.conditions.Condition;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javolution.util.FastList;

public abstract class L2Item {
    public static final int TYPE1_WEAPON_RING_EARRING_NECKLACE = 0;
    public static final int TYPE1_SHIELD_ARMOR = 1;
    public static final int TYPE1_ITEM_QUESTITEM_ADENA = 4;
    public static final int TYPE2_WEAPON = 0;
    public static final int TYPE2_SHIELD_ARMOR = 1;
    public static final int TYPE2_ACCESSORY = 2;
    public static final int TYPE2_QUEST = 3;
    public static final int TYPE2_MONEY = 4;
    public static final int TYPE2_OTHER = 5;
    public static final int TYPE2_PET_WOLF = 6;
    public static final int TYPE2_PET_HATCHLING = 7;
    public static final int TYPE2_PET_STRIDER = 8;
    public static final int TYPE2_PET_BABY = 9;
    public static final int TYPE2_PET_EVOLVEDWOLF = 10;
    public static final int SLOT_NONE = 0;
    public static final int SLOT_UNDERWEAR = 1;
    public static final int SLOT_R_EAR = 2;
    public static final int SLOT_L_EAR = 4;
    public static final int SLOT_LR_EAR = 6;
    public static final int SLOT_NECK = 8;
    public static final int SLOT_R_FINGER = 16;
    public static final int SLOT_L_FINGER = 32;
    public static final int SLOT_LR_FINGER = 48;
    public static final int SLOT_HEAD = 64;
    public static final int SLOT_R_HAND = 128;
    public static final int SLOT_L_HAND = 256;
    public static final int SLOT_GLOVES = 512;
    public static final int SLOT_CHEST = 1024;
    public static final int SLOT_LEGS = 2048;
    public static final int SLOT_FEET = 4096;
    public static final int SLOT_BACK = 8192;
    public static final int SLOT_LR_HAND = 16384;
    public static final int SLOT_FULL_ARMOR = 32768;
    public static final int SLOT_HAIR = 65536;
    public static final int SLOT_ALLDRESS = 131072;
    public static final int SLOT_HAIR2 = 262144;
    public static final int SLOT_HAIRALL = 524288;
    public static final int SLOT_R_BRACELET = 0x100000;
    public static final int SLOT_L_BRACELET = 0x200000;
    public static final int SLOT_DECO = 0x400000;
    public static final int SLOT_BELT = 0x10000000;
    public static final int SLOT_WOLF = -100;
    public static final int SLOT_HATCHLING = -101;
    public static final int SLOT_STRIDER = -102;
    public static final int SLOT_BABYPET = -103;
    public static final int SLOT_GREATWOLF = -104;
    public static final int SLOT_MULTI_ALLWEAPON = 16512;
    public static final int MATERIAL_STEEL = 0;
    public static final int MATERIAL_FINE_STEEL = 1;
    public static final int MATERIAL_BLOOD_STEEL = 2;
    public static final int MATERIAL_BRONZE = 3;
    public static final int MATERIAL_SILVER = 4;
    public static final int MATERIAL_GOLD = 5;
    public static final int MATERIAL_MITHRIL = 6;
    public static final int MATERIAL_ORIHARUKON = 7;
    public static final int MATERIAL_PAPER = 8;
    public static final int MATERIAL_WOOD = 9;
    public static final int MATERIAL_CLOTH = 10;
    public static final int MATERIAL_LEATHER = 11;
    public static final int MATERIAL_BONE = 12;
    public static final int MATERIAL_HORN = 13;
    public static final int MATERIAL_DAMASCUS = 14;
    public static final int MATERIAL_ADAMANTAITE = 15;
    public static final int MATERIAL_CHRYSOLITE = 16;
    public static final int MATERIAL_CRYSTAL = 17;
    public static final int MATERIAL_LIQUID = 18;
    public static final int MATERIAL_SCALE_OF_DRAGON = 19;
    public static final int MATERIAL_DYESTUFF = 20;
    public static final int MATERIAL_COBWEB = 21;
    public static final int MATERIAL_SEED = 21;
    public static final int CRYSTAL_NONE = 0;
    public static final int CRYSTAL_D = 1;
    public static final int CRYSTAL_C = 2;
    public static final int CRYSTAL_B = 3;
    public static final int CRYSTAL_A = 4;
    public static final int CRYSTAL_S = 5;
    public static final int CRYSTAL_S80 = 6;
    public static final int CRYSTAL_S84 = 7;
    private static final int[] crystalItemId = new int[]{0, 1458, 1459, 1460, 1461, 1462, 1462, 1462};
    private static final int[] crystalEnchantBonusArmor = new int[]{0, 11, 6, 11, 19, 25, 25, 25};
    private static final int[] crystalEnchantBonusWeapon = new int[]{0, 90, 45, 67, 144, 250, 250, 250};
    private final int _itemId;
    private final String _name;
    private final int _type1;
    private final int _type2;
    private final int _weight;
    private final boolean _crystallizable;
    private final boolean _stackable;
    private final int _materialType;
    private final int _crystalType;
    private final int _duration;
    private final int _time;
    private final int _bodyPart;
    private final int _referencePrice;
    private final int _crystalCount;
    private final boolean _sellable;
    private final boolean _dropable;
    private final boolean _destroyable;
    private final boolean _tradeable;
    private final boolean _depositable;
    private final boolean _common;
    private final boolean _heroItem;
    private final boolean _pvpItem;
    protected final Enum _type;
    protected Elementals[] _elementals = null;
    protected FuncTemplate[] _funcTemplates;
    protected EffectTemplate[] _effectTemplates;
    protected L2Skill[] _skills;
    protected List<Condition> _preConditions = new FastList();
    protected static final Func[] _emptyFunctionSet = new Func[0];
    protected static final L2Effect[] _emptyEffectSet = new L2Effect[0];
    protected static final Logger _log = Logger.getLogger(L2Item.class.getName());

    protected L2Item(Enum<?> type, StatsSet set) {
        this._type = type;
        this._itemId = set.getInteger("item_id");
        this._name = set.getString("name").intern();
        this._type1 = set.getInteger("type1");
        this._type2 = set.getInteger("type2");
        this._weight = set.getInteger("weight");
        this._crystallizable = set.getBool("crystallizable");
        this._stackable = set.getBool("stackable", false);
        this._materialType = set.getInteger("material");
        this._crystalType = set.getInteger("crystal_type", 0);
        this._duration = set.getInteger("duration");
        this._time = set.getInteger("time");
        this._bodyPart = set.getInteger("bodypart");
        this._referencePrice = set.getInteger("price");
        this._crystalCount = set.getInteger("crystal_count", 0);
        this._sellable = set.getBool("sellable", true);
        this._dropable = set.getBool("dropable", true);
        this._destroyable = set.getBool("destroyable", true);
        this._tradeable = set.getBool("tradeable", true);
        this._depositable = set.getBool("depositable", true);
        this._common = this._itemId >= 12006 && this._itemId <= 12361 || this._itemId >= 11605 && this._itemId <= 12308;
        this._heroItem = this._itemId >= 6611 && this._itemId <= 6621 || this._itemId >= 9388 && this._itemId <= 9390 || this._itemId == 6842;
        this._pvpItem = this._itemId >= 10667 && this._itemId <= 10792 || this._itemId >= 10793 && this._itemId <= 10835 || this._itemId >= 12852 && this._itemId <= 12977 || this._itemId >= 14363 && this._itemId <= 14519 || this._itemId >= 14520 && this._itemId <= 14525 || this._itemId == 14528 || this._itemId == 14529 || this._itemId == 14558;
    }

    public Enum getItemType() {
        return this._type;
    }

    public final int getDuration() {
        return this._duration;
    }

    public final int getTime() {
        return this._time;
    }

    public final int getItemId() {
        return this._itemId;
    }

    public abstract int getItemMask();

    public final int getMaterialType() {
        return this._materialType;
    }

    public final int getType2() {
        return this._type2;
    }

    public final int getWeight() {
        return this._weight;
    }

    public final boolean isCrystallizable() {
        return this._crystallizable;
    }

    public final int getCrystalType() {
        return this._crystalType;
    }

    public final int getCrystalItemId() {
        return crystalItemId[this._crystalType];
    }

    public final int getItemGrade() {
        return this.getCrystalType();
    }

    public final int getItemGradeSPlus() {
        switch (this.getItemGrade()) {
            case 6: 
            case 7: {
                return 5;
            }
        }
        return this.getItemGrade();
    }

    public final int getCrystalCount() {
        return this._crystalCount;
    }

    public final int getCrystalCount(int enchantLevel) {
        if (enchantLevel > 3) {
            switch (this._type2) {
                case 1: 
                case 2: {
                    return this._crystalCount + crystalEnchantBonusArmor[this.getCrystalType()] * (3 * enchantLevel - 6);
                }
                case 0: {
                    return this._crystalCount + crystalEnchantBonusWeapon[this.getCrystalType()] * (2 * enchantLevel - 3);
                }
            }
            return this._crystalCount;
        }
        if (enchantLevel > 0) {
            switch (this._type2) {
                case 1: 
                case 2: {
                    return this._crystalCount + crystalEnchantBonusArmor[this.getCrystalType()] * enchantLevel;
                }
                case 0: {
                    return this._crystalCount + crystalEnchantBonusWeapon[this.getCrystalType()] * enchantLevel;
                }
            }
            return this._crystalCount;
        }
        return this._crystalCount;
    }

    public final String getName() {
        return this._name;
    }

    public final Elementals[] getElementals() {
        return this._elementals;
    }

    public Elementals getElemental(byte attribute) {
        for (Elementals elm : this._elementals) {
            if (elm.getElement() != attribute) continue;
            return elm;
        }
        return null;
    }

    public void setElementals(Elementals element) {
        if (this._elementals == null) {
            this._elementals = new Elementals[1];
            this._elementals[0] = element;
        } else {
            Elementals elm = this.getElemental(element.getElement());
            if (elm != null) {
                elm.setValue(element.getValue());
            } else {
                elm = element;
                Elementals[] array = new Elementals[this._elementals.length + 1];
                System.arraycopy(this._elementals, 0, array, 0, this._elementals.length);
                array[this._elementals.length] = elm;
                this._elementals = array;
            }
        }
    }

    public final int getBodyPart() {
        return this._bodyPart;
    }

    public final int getType1() {
        return this._type1;
    }

    public final boolean isStackable() {
        return this._stackable;
    }

    public boolean isConsumable() {
        return false;
    }

    public boolean isEquipable() {
        return this.getBodyPart() != 0 && !(this.getItemType() instanceof L2EtcItemType);
    }

    public final int getReferencePrice() {
        return this.isConsumable() ? (int)((float)this._referencePrice * Config.RATE_CONSUMABLE_COST) : this._referencePrice;
    }

    public final boolean isSellable() {
        return this._sellable;
    }

    public final boolean isDropable() {
        return this._dropable;
    }

    public final boolean isDestroyable() {
        return this._destroyable;
    }

    public final boolean isTradeable() {
        return this._tradeable;
    }

    public final boolean isDepositable() {
        return this._depositable;
    }

    public final boolean isCommon() {
        return this._common;
    }

    public final boolean isHeroItem() {
        return this._heroItem;
    }

    public final boolean isPvpItem() {
        return this._pvpItem;
    }

    public boolean isForHatchling() {
        return this._type2 == 7;
    }

    public boolean isForStrider() {
        return this._type2 == 8;
    }

    public boolean isForWolf() {
        return this._type2 == 6;
    }

    public boolean isForEvolvedWolf() {
        return this._type2 == 10;
    }

    public boolean isForBabyPet() {
        return this._type2 == 9;
    }

    public Func[] getStatFuncs(L2ItemInstance instance, L2Character player) {
        if (this._funcTemplates == null || this._funcTemplates.length == 0) {
            return _emptyFunctionSet;
        }
        ArrayList<Func> funcs = new ArrayList<Func>(this._funcTemplates.length);
        Env env = new Env();
        env.player = player;
        env.target = player;
        env.item = instance;
        for (FuncTemplate t : this._funcTemplates) {
            Func f = t.getFunc(env, this);
            if (f == null) continue;
            funcs.add(f);
        }
        if (funcs.isEmpty()) {
            return _emptyFunctionSet;
        }
        return funcs.toArray(new Func[funcs.size()]);
    }

    public L2Effect[] getEffects(L2ItemInstance instance, L2Character player) {
        if (this._effectTemplates == null || this._effectTemplates.length == 0) {
            return _emptyEffectSet;
        }
        ArrayList<L2Effect> effects = new ArrayList<L2Effect>(this._effectTemplates.length);
        Env env = new Env();
        env.player = player;
        env.target = player;
        env.item = instance;
        for (EffectTemplate et : this._effectTemplates) {
            L2Effect e = et.getEffect(env);
            if (e == null) continue;
            e.scheduleEffect();
            effects.add(e);
        }
        if (effects.isEmpty()) {
            return _emptyEffectSet;
        }
        return effects.toArray(new L2Effect[effects.size()]);
    }

    public void attach(FuncTemplate f) {
        switch (f.stat) {
            case FIRE_RES: 
            case FIRE_POWER: {
                this.setElementals(new Elementals(0, (int)f.lambda.calc(null)));
                break;
            }
            case WATER_RES: 
            case WATER_POWER: {
                this.setElementals(new Elementals(1, (int)f.lambda.calc(null)));
                break;
            }
            case WIND_RES: 
            case WIND_POWER: {
                this.setElementals(new Elementals(2, (int)f.lambda.calc(null)));
                break;
            }
            case EARTH_RES: 
            case EARTH_POWER: {
                this.setElementals(new Elementals(3, (int)f.lambda.calc(null)));
                break;
            }
            case HOLY_RES: 
            case HOLY_POWER: {
                this.setElementals(new Elementals(4, (int)f.lambda.calc(null)));
                break;
            }
            case DARK_RES: 
            case DARK_POWER: {
                this.setElementals(new Elementals(5, (int)f.lambda.calc(null)));
            }
        }
        if (this._funcTemplates == null) {
            this._funcTemplates = new FuncTemplate[]{f};
        } else {
            int len = this._funcTemplates.length;
            FuncTemplate[] tmp = new FuncTemplate[len + 1];
            System.arraycopy(this._funcTemplates, 0, tmp, 0, len);
            tmp[len] = f;
            this._funcTemplates = tmp;
        }
    }

    public void attach(EffectTemplate effect) {
        if (this._effectTemplates == null) {
            this._effectTemplates = new EffectTemplate[]{effect};
        } else {
            int len = this._effectTemplates.length;
            EffectTemplate[] tmp = new EffectTemplate[len + 1];
            System.arraycopy(this._effectTemplates, 0, tmp, 0, len);
            tmp[len] = effect;
            this._effectTemplates = tmp;
        }
    }

    public void attach(L2Skill skill) {
        if (this._skills == null) {
            this._skills = new L2Skill[]{skill};
        } else {
            int len = this._skills.length;
            L2Skill[] tmp = new L2Skill[len + 1];
            System.arraycopy(this._skills, 0, tmp, 0, len);
            tmp[len] = skill;
            this._skills = tmp;
        }
    }

    public final void attach(Condition c) {
        if (!this._preConditions.contains(c)) {
            this._preConditions.add(c);
        }
    }

    public final L2Skill[] getItemSkills() {
        return this._skills;
    }

    public boolean checkCondition(L2Character activeChar, L2Object target, boolean sendMessage) {
        if (activeChar.isGM() && !Config.GM_ITEM_RESTRICTION) {
            return true;
        }
        Env env = new Env();
        env.player = activeChar;
        if (target instanceof L2Character) {
            env.target = (L2Character)target;
        }
        for (Condition preCondition : this._preConditions) {
            if (preCondition == null) {
                return true;
            }
            if (preCondition.test(env)) continue;
            if (activeChar instanceof L2SummonInstance) {
                ((L2SummonInstance)activeChar).getOwner().sendPacket(new SystemMessage(SystemMessageId.PET_CANNOT_USE_ITEM));
                return false;
            }
            if (sendMessage) {
                String msg = preCondition.getMessage();
                int msgId = preCondition.getMessageId();
                if (msg != null) {
                    activeChar.sendMessage(msg);
                } else if (msgId != 0) {
                    SystemMessage sm = new SystemMessage(msgId);
                    if (preCondition.isAddName()) {
                        sm.addItemName(this._itemId);
                    }
                    activeChar.sendPacket(sm);
                }
            }
            return false;
        }
        return true;
    }

    public boolean isQuestItem() {
        return this.getType2() == 3;
    }

    public String toString() {
        return this._name + "(" + this._itemId + ")";
    }
}

