/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.individual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

import javolution.util.FastList;
import ai.group_template.L2AttackableAIScript;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.Earthquake;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.SpecialCamera;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.util.Rnd;

/**
 * 
 * This class ... control for sequence of fight against Antharas.
 * 
 * @version $Revision: $ $Date: $
 * @author L2J_JP SANDMAN
 */
public class Antharas extends L2AttackableAIScript
{
	// config
	@SuppressWarnings("unused") private static final int FWA_ACTIVITYTIMEOFANTHARAS = 120;
	//private static final int FWA_APPTIMEOFANTHARAS = 1800000;
	private static final int FWA_INACTIVITYTIME = 900000;
	private static final boolean FWA_OLDANTHARAS = false;
	private static final boolean FWA_MOVEATRANDOM = true;
	private static final boolean FWA_DOSERVEREARTHQUAKE = true;
	private static final int FWA_LIMITOFWEAK = 45;
	private static final int FWA_LIMITOFNORMAL = 63;
	
	private static final int FWA_MAXMOBS = 10; // this includes Antharas itself
	private static final int FWA_INTERVALOFMOBSWEAK = 180000;
	private static final int FWA_INTERVALOFMOBSNORMAL = 150000;
	private static final int FWA_INTERVALOFMOBSSTRONG = 120000;
	private static final int FWA_PERCENTOFBEHEMOTH = 60;
	private static final int FWA_SELFDESTRUCTTIME = 15000;
	// Location of teleport cube.
	private final int _teleportCubeId = 31859;
	private final int _teleportCubeLocation[][] = { { 177615, 114941, -7709, 0 } };
	
	protected List<L2Spawn> _teleportCubeSpawn = new FastList<L2Spawn>();
	protected List<L2Npc> _teleportCube = new FastList<L2Npc>();
	
 //	// Spawn data of monsters.
 //	protected TIntObjectHashMap<L2Spawn> _monsterSpawn = new TIntObjectHashMap<L2Spawn>();
	
	// Instance of monsters.
	protected List<L2Npc> _monsters = new FastList<L2Npc>();
	protected L2GrandBossInstance _antharas = null;
	
	// monstersId
	private static final int ANTHARASOLDID = 29019;
	private static final int ANTHARASWEAKID = 29066;
	private static final int ANTHARASNORMALID = 29067;
	private static final int ANTHARASSTRONGID = 29068;
//	private static final int BEHEMOTH_DRAGON = 29069;	//[JOJO]
//	private static final int DRAGON_BOMBER = 29076;		//[JOJO]

	// items
	private static final int ANTHARAS_CIRCLET = 8568;	//[JOJO]
	
	// Tasks.
	protected ScheduledFuture<?> _cubeSpawnTask = null;
	protected ScheduledFuture<?> _monsterSpawnTask = null;
	protected ScheduledFuture<?> _activityCheckTask = null;
	protected ScheduledFuture<?> _socialTask = null;
	protected ScheduledFuture<?> _mobiliseTask = null;
	protected ScheduledFuture<?> _mobsSpawnTask = null;
	protected ScheduledFuture<?> _selfDestructionTask = null;
	protected ScheduledFuture<?> _moveAtRandomTask = null;
	protected ScheduledFuture<?> _movieTask = null;
	
	//Antharas Status Tracking :
	private static final byte DORMANT = 0;		//Antharas is spawned and no one has entered yet. Entry is unlocked
	private static final byte WAITING = 1;		//Antharas is spawend and someone has entered, triggering a 30 minute window for additional people to enter
	//before he unleashes his attack. Entry is unlocked
	private static final byte FIGHTING = 2;		//Antharas is engaged in battle, annihilating his foes. Entry is locked
	private static final byte DEAD = 3;			//Antharas has been killed. Entry is locked
	
	protected static long _LastAction = 0;
	
	protected static L2BossZone _Zone;
	
	public static void main(String[] args)
	{
		// now call the constructor (starts up the ai)
		new Antharas(-1,"antharas","ai");
	}
	
	// Boss: Antharas
	public Antharas(int id,String name,String descr)
	{
		super(id,name,descr);
		int[] mob = {ANTHARASOLDID,ANTHARASWEAKID,ANTHARASNORMALID,ANTHARASSTRONGID,29069,29070,29071,29072,29073,29074,29075,29076};
		this.registerMobs(mob);
		init();
	}
	
	// Initialize
	private void init()
	{
		_Zone = GrandBossManager.getInstance().getZone(179700,113800,-7709);
			
		// Setting spawn data of teleport cube.
		try
		{
			L2NpcTemplate Cube = NpcTable.getInstance().getTemplate(_teleportCubeId);
			L2Spawn spawnDat;
			for (int[] element : _teleportCubeLocation)
			{
				spawnDat = new L2Spawn(Cube);
				spawnDat.setAmount(1);
				spawnDat.setLocx(element[0]);
				spawnDat.setLocy(element[1]);
				spawnDat.setLocz(element[2]);
				spawnDat.setHeading(element[3]);
				spawnDat.stopRespawn();	//[JOJO]
				spawnDat.setLocation(0);
			//	SpawnTable.getInstance().addNewSpawn(spawnDat, false);	//-[JOJO]
				_teleportCubeSpawn.add(spawnDat);
			}
		}
		catch (Exception e)
		{
			_log.warning(e.getMessage());
		}
		int status = GrandBossManager.getInstance().getBossStatus(ANTHARASOLDID);
		if (FWA_OLDANTHARAS || status == WAITING)
		{
			StatsSet info = GrandBossManager.getInstance().getStatsSet(ANTHARASOLDID);
			long respawnTime = info.getLong("respawn_time");
			if (status == DEAD && respawnTime <= System.currentTimeMillis())
			{
				// the time has already expired while the server was offline. Immediately spawn antharas in his cave.
				// also, the status needs to be changed to DORMANT
				GrandBossManager.getInstance().setBossStatus(ANTHARASOLDID,DORMANT);
				status = DORMANT;
			}
			else if (status == FIGHTING)
			{
				int loc_x = info.getInteger("loc_x");
				int loc_y = info.getInteger("loc_y");
				int loc_z = info.getInteger("loc_z") - 20;
				int heading = info.getInteger("heading");
				int hp = info.getInteger("currentHP");
				int mp = info.getInteger("currentMP");
				_antharas = (L2GrandBossInstance) addSpawn(ANTHARASOLDID,loc_x,loc_y,loc_z,heading,false,0);
				GrandBossManager.getInstance().addBoss(_antharas);
				_antharas.setCurrentHpMp(hp,mp);
				_LastAction = System.currentTimeMillis();
				// Start repeating timer to check for inactivity
				_activityCheckTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new CheckActivity(), 60000, 60000);
			}
			else if (status == DEAD)
			{
				ThreadPoolManager.getInstance().scheduleGeneral(new UnlockAntharas(ANTHARASOLDID), respawnTime - System.currentTimeMillis());
				_log.info("AI script: Next spawn date of Anthras is " + GrandBossManager.respawnTimeFormat(info) + ".");
			}
			else
			{
				setAntharasSpawnTask();
			}
		}
		else
		{
			int statusWeak = GrandBossManager.getInstance().getBossStatus(ANTHARASWEAKID);
			int statusNormal = GrandBossManager.getInstance().getBossStatus(ANTHARASNORMALID);
			int statusStrong = GrandBossManager.getInstance().getBossStatus(ANTHARASSTRONGID);
			int antharasId = 0;
			if (statusWeak == FIGHTING || statusWeak == DEAD)
			{
				antharasId = ANTHARASWEAKID;
				status = statusWeak;
			}
			else if (statusNormal == FIGHTING || statusNormal == DEAD)
			{
				antharasId = ANTHARASNORMALID;
				status = statusNormal;
			}
			else if (statusStrong == FIGHTING || statusStrong == DEAD)
			{
				antharasId = ANTHARASSTRONGID;
				status = statusStrong;
			}
			if (antharasId != 0 && status == FIGHTING)
			{
				StatsSet info = GrandBossManager.getInstance().getStatsSet(antharasId);
				int loc_x = info.getInteger("loc_x");
				int loc_y = info.getInteger("loc_y");
				int loc_z = info.getInteger("loc_z") - 20;
				int heading = info.getInteger("heading");
				int hp = info.getInteger("currentHP");
				int mp = info.getInteger("currentMP");
				_antharas = (L2GrandBossInstance) addSpawn(antharasId,loc_x,loc_y,loc_z,heading,false,0);
				GrandBossManager.getInstance().addBoss(_antharas);
				_antharas.setCurrentHpMp(hp,mp);
				_LastAction = System.currentTimeMillis();
				// Start repeating timer to check for inactivity
				_activityCheckTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new CheckActivity(), 60000, 60000);
			}
			else if (antharasId != 0 && status == DEAD)
			{
				StatsSet info = GrandBossManager.getInstance().getStatsSet(antharasId);
				long respawnTime = info.getLong("respawn_time");
				if (respawnTime <= System.currentTimeMillis())
				{
					// the time has already expired while the server was offline. Immediately spawn antharas in his cave.
					// also, the status needs to be changed to DORMANT
					GrandBossManager.getInstance().setBossStatus(antharasId,DORMANT);
					status = DORMANT;
				}
				else
				{
					ThreadPoolManager.getInstance().scheduleGeneral(new UnlockAntharas(antharasId), respawnTime - System.currentTimeMillis());
					_log.info("AI script: Next spawn date of Anthras is " + GrandBossManager.respawnTimeFormat(info) + ".");
				}
			}
		}
	}
	
	// Do spawn teleport cube.
	public void spawnCube()
	{
		if (_mobsSpawnTask != null)
		{
			_mobsSpawnTask.cancel(true);
			_mobsSpawnTask = null;
		}
		if (_selfDestructionTask != null)
		{
			_selfDestructionTask.cancel(true);
			_selfDestructionTask = null;
		}
		if (_activityCheckTask != null)
		{
			_activityCheckTask.cancel(false);
			_activityCheckTask = null;
		}
		
		for (L2Spawn spawnDat : _teleportCubeSpawn)
		{
			_teleportCube.add(spawnDat.doSpawn());
		}
	}
	
	// Setting Antharas spawn task.
	public void setAntharasSpawnTask()	// <- scripts/teleports/6000_GrandBossTeleporters/__init__.py
	{
		if (_monsterSpawnTask == null)
		{
			synchronized(this)
			{
				if (_monsterSpawnTask == null)
				{
					GrandBossManager.getInstance().setBossStatus(ANTHARASOLDID,WAITING);
					Config.Antharas_Wait_Time = Math.max(180000, Config.Antharas_Wait_Time);	//[JOJO]
					_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new AntharasSpawn(-3), Config.Antharas_Wait_Time - 180000);	//[JOJO]
				//	_monsterSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new AntharasSpawn(1),Config.Antharas_Wait_Time);
					Broadcast.announceToOnlinePlayers("nA^X" + (Config.Antharas_Wait_Time / 60000) + "ɖڊo߂܂B");	//[JOJO]
				}
			}
		}
	}
	
	private void startMinionSpawns(int antharasId)
	{
		int intervalOfMobs;
		
		// Interval of minions is decided by the type of Antharas
		// that invaded the lair.
		switch (antharasId)
		{
			case ANTHARASWEAKID:
				intervalOfMobs = FWA_INTERVALOFMOBSWEAK;
				break;
			case ANTHARASNORMALID:
				intervalOfMobs = FWA_INTERVALOFMOBSNORMAL;
				break;
			default:
				intervalOfMobs = FWA_INTERVALOFMOBSSTRONG;
				break;
		}
		
		// Spawn mobs.
		_mobsSpawnTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new MobsSpawn(), intervalOfMobs, intervalOfMobs);
	}
	
	// Do spawn Antharas.
	private class AntharasSpawn implements Runnable
	{
		private int _taskId;
		private Collection<L2Character> _players = _Zone.getCharactersInside().values();
		
		AntharasSpawn(int taskId)
		{
			_taskId = taskId;
		}
		
		public void run()
		{
			int npcId;
			L2Spawn antharasSpawn = null;
			
			switch (_taskId)
			{
			//[JOJO]-------------------------------------------------
			case -3:
				_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new AntharasSpawn(-2), 60000);
				screenMessage("3O");
				break;
			case -2:
				_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new AntharasSpawn(-1), 60000);
				screenMessage("2O");
				break;
			case -1:
				_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new AntharasSpawn(0), 60000);
				screenMessage("1O");
				_Zone.broadcastPacket(new Earthquake(179700,113800,-7709,40,15));
				break;
			//-------------------------------------------------------
			case 0: // Spawn.
				// Strength of Antharas is decided by the number of players that
				// invaded the lair.
				_monsterSpawnTask.cancel(false);
				_monsterSpawnTask = null;
				if (FWA_OLDANTHARAS)
					npcId = 29019; // old
				else if (_players.size() <= FWA_LIMITOFWEAK)
					npcId = 29066; // weak
				else if (_players.size() > FWA_LIMITOFNORMAL)
					npcId = 29068; // strong
				else
					npcId = 29067; // normal
				
				// Do spawn.
				//[JOJO]-------------------------------------------------
				try
				{
					antharasSpawn = new L2Spawn(NpcTable.getInstance().getTemplate(npcId));
				}
				catch (Exception e)
				{
					_log.warning(e.getMessage());
					break;
				}
				antharasSpawn.setLocx(185452);
				antharasSpawn.setLocy(114835);
				antharasSpawn.setLocz(-8221);
				antharasSpawn.setHeading(0);
				antharasSpawn.setAmount(1);
				antharasSpawn.stopRespawn();
				//-------------------------------------------------------
				_antharas = (L2GrandBossInstance) antharasSpawn.doSpawn();
				GrandBossManager.getInstance().addBoss(_antharas);
				
				_monsters.add(_antharas);
			//	_antharas.setIsImmobilized(true);
				
				GrandBossManager.getInstance().setBossStatus(ANTHARASOLDID,DORMANT);
				GrandBossManager.getInstance().setBossStatus(npcId,FIGHTING);
				_LastAction = System.currentTimeMillis();
				// Start repeating timer to check for inactivity
				_activityCheckTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new CheckActivity(), 60000, 60000);
				_Zone.broadcastPacket(new PlaySound(1, "BS02_A", 1, _antharas.getObjectId(), 185452, 114835, -8221));	//[JOJO]
				screenMessage("o");	//[JOJO]
				
				// Setting 1st time of minions spawn task.
				if (!FWA_OLDANTHARAS)
				{
					startMinionSpawns(npcId);
				}

				// Set next task.
				if (_socialTask != null)
				{
					_socialTask.cancel(true);
					_socialTask = null;
				}
			//	_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new AntharasSpawn(1), 16);
				//[JOJO]-------------------------------------------------
				_socialTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new AntharasSpawn(1), 2000, 2000);
				_antharas.setIsInSocialAction(true);
				_antharas.setIsImmobilized(false);
				_antharas.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(181911, 114835, -7678, 0));
				//-------------------------------------------------------
				break;
				
			//[JOJO]-------------------------------------------------
			case 1: // "antharas_has_arrived"
				{
					int dx = Math.abs(_antharas.getX() - 181911);
					int dy = Math.abs(_antharas.getY() - 114835);
					if (dx <= 50 && dy <= 50)
					{
						// Set next task.
						if (_socialTask != null)
							_socialTask.cancel(true);
						_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new AntharasSpawn(2), 16);
						_antharas.setXYZ(181911, 114835, -7678);
						_antharas.setIsImmobilized(true);
						_antharas.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
					}
					else
					{
						// Retry - scheduleGeneralAtFixedRate(new AntharasSpawn(1), 2000, 2000)
						_antharas.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(181911, 114835, -7678, 0));
					}
				}
				break;
			//-------------------------------------------------------
				
			case 2:
				// Set camera.
				broadcastPacket(new SpecialCamera(_antharas.getObjectId(),700,13,-19,0,20000,0,0,1,0));
				
				// Set next task.
				if (_socialTask != null)
				{
					_socialTask.cancel(true);
					_socialTask = null;
				}
				_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new AntharasSpawn(3), 3000);
				break;
				
			case 3:
				// Do social.
				broadcastPacket(new SpecialCamera(_antharas.getObjectId(),700,13,0,6000,20000,0,0,1,0));
				// Set next task.
				if (_socialTask != null)
				{
					_socialTask.cancel(true);
					_socialTask = null;
				}
				_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new AntharasSpawn(4), 10000);
				break;
			case 4:
				broadcastPacket(new SpecialCamera(_antharas.getObjectId(),3700,0,-3,0,10000,0,0,1,0));
				// Set next task.
				if (_socialTask != null)
				{
					_socialTask.cancel(true);
					_socialTask = null;
				}
				_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new AntharasSpawn(5), 200);
				break;
				
			case 5:
				// Do social.
				broadcastPacket(new SpecialCamera(_antharas.getObjectId(),1100,0,-3,22000,30000,0,0,1,0));
				// Set next task.
				if (_socialTask != null)
				{
					_socialTask.cancel(true);
					_socialTask = null;
				}
				_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new AntharasSpawn(6), 10800);
				break;
				
			case 6:
				// Set camera.
				broadcastPacket(new SpecialCamera(_antharas.getObjectId(),1100,0,-3,300,7000,0,0,1,0));
				// Set next task.
				if (_socialTask != null)
				{
					_socialTask.cancel(true);
					_socialTask = null;
				}
				_socialTask = ThreadPoolManager.getInstance().scheduleGeneral(new AntharasSpawn(7), 1900);
				break;
				
			case 7:
				_antharas.setIsInSocialAction(false);	//[JOJO]
				_antharas.abortCast();
				
				_mobiliseTask = ThreadPoolManager.getInstance().scheduleGeneral(new SetMobilised(_antharas), 16);
				
				// Move at random.
				if (FWA_MOVEATRANDOM)
				{
					L2CharPosition pos = new L2CharPosition(177915, 114941, -7707, 0);
				//	L2CharPosition pos = new L2CharPosition(Rnd.get(175000,178500), Rnd.get(112400, 116000), -7707, 0);
					_moveAtRandomTask = ThreadPoolManager.getInstance().scheduleGeneral(new MoveAtRandom(_antharas, pos), /*[JOJO]*/20000/*500*/);
				}
				
				if (_socialTask != null)
				{
					_socialTask.cancel(true);
					_socialTask = null;
				}
				
				Broadcast.announceToOnlinePlayers("nA^Xoꂵ܂B");	//[JOJO]
				announce("A^X" + (FWA_INACTIVITYTIME / 60000) + "ԍUȂłƁAɖ߂Ă܂܂B");	//[JOJO]
				break;
			}
		}
	}
	
	private void broadcastPacket(L2GameServerPacket mov)
	{
		if (_Zone != null)
		{
			for (L2Character characters : _Zone.getCharactersInside().values())
			{
				if (characters instanceof L2PcInstance)
					characters.sendPacket(mov);
			}
		}
	}
	
	// Do spawn Behemoth or Bomber.
	private class MobsSpawn implements Runnable
	{
		public MobsSpawn()
		{
		}
		
		public void run()
		{
			L2NpcTemplate template1;
			L2Spawn tempSpawn;
			boolean isBehemoth = Rnd.get(100) < FWA_PERCENTOFBEHEMOTH;
			try
			{
				int mobNumber = (isBehemoth ? 2 : 3);
				// Set spawn.
				for(int i = 0; i < mobNumber; i++)
				{
					if (_monsters.size() >= FWA_MAXMOBS)
						break;
					int npcId;
					if (isBehemoth)
						npcId = 29069;
					else
						npcId = Rnd.get(29070, 29076);
					template1 = NpcTable.getInstance().getTemplate(npcId);
					tempSpawn = new L2Spawn(template1);
					// allocates it at random in the lair of Antharas.
					int tried = 0;
					boolean notFound = true;
					int x = 175000;
					int y = 112400;
					int dt = (_antharas.getX() - x) * (_antharas.getX() - x) + (_antharas.getY() - y) * (_antharas.getY() - y);
					while (tried++ < 25 && notFound)
					{
						int rx = Rnd.get(175000, 179900);
						int ry = Rnd.get(112400, 116000);
						int rdt = (_antharas.getX() - rx) * (_antharas.getX() - rx) + (_antharas.getY() - ry) * (_antharas.getY() - ry);
						if (GeoData.getInstance().canSeeTarget(_antharas.getX(), _antharas.getY(), -7704, rx, ry, -7704))
							if (rdt < dt)
							{
								x = rx;
								y = ry;
								dt = rdt;
								if (rdt <= 900000)
									notFound = false;
							}
					}
					tempSpawn.setLocx(x);
					tempSpawn.setLocy(y);
					tempSpawn.setLocz(-7704);
					tempSpawn.setHeading(0);
					tempSpawn.setAmount(1);
					tempSpawn.stopRespawn();	//[JOJO]
				//	SpawnTable.getInstance().addNewSpawn(tempSpawn, false);	//-[JOJO]
					// Do spawn.
					_monsters.add(tempSpawn.doSpawn());
				}
			}
			catch (Exception e)
			{
				_log.warning(e.getMessage());
			}
		}
	}
	
	@Override
	public String onAggroRangeEnter (L2Npc npc, L2PcInstance player, boolean isPet)
	{
		switch (npc.getNpcId())
		{
			case 29070:
			case 29071:
			case 29072:
			case 29073:
			case 29074:
			case 29075:
			case 29076:
				if (_selfDestructionTask == null && !npc.isDead())
					_selfDestructionTask = ThreadPoolManager.getInstance().scheduleGeneral(new SelfDestructionOfBomber(npc), FWA_SELFDESTRUCTTIME);
				break;
		}
		return super.onAggroRangeEnter(npc, player, isPet);
	}
	
	// Do self destruction.
	private class SelfDestructionOfBomber implements Runnable
	{
		private L2Npc _bomber;
		
		public SelfDestructionOfBomber(L2Npc bomber)
		{
			_bomber = bomber;
		}
		
		public void run()
		{
			L2Skill skill = null;
			switch (_bomber.getNpcId())
			{
				case 29070:
				case 29071:
				case 29072:
				case 29073:
				case 29074:
				case 29075:
					skill = SkillTable.getInstance().getInfo(5097, 1);
					break;
				case 29076:
					skill = SkillTable.getInstance().getInfo(5094, 1);
					break;
			}
			
			_bomber.doCast(skill);
			_selfDestructionTask.cancel(false);
			_selfDestructionTask = null;
		}
	}
	
	@Override
	public String onSpellFinished(L2Npc npc, L2PcInstance player, L2Skill skill)
	{
		if (npc.isInvul())
		{
			return null;
		}
		else if (skill != null && (skill.getId() == 5097 || skill.getId() == 5094))
		{
			switch (npc.getNpcId())
			{
				case 29070:
				case 29071:
				case 29072:
				case 29073:
				case 29074:
				case 29075:
				case 29076:
					npc.doDie(npc);
					break;
			}
		}
		return super.onSpellFinished(npc, player, skill);
	}
	
	// At end of activity time.
	private class CheckActivity implements Runnable
	{
		public void run()
		{
			long temp = (System.currentTimeMillis() - _LastAction);
			if (temp > FWA_INACTIVITYTIME)
			{
				GrandBossManager.getInstance().setBossStatus(_antharas.getNpcId(),DORMANT);
				setUnspawn();
			}
			//[JOJO]-------------------------------------------------
			else if (FWA_MOVEATRANDOM && temp >= 60000 && _antharas != null)
			{
				CtrlIntention a = _antharas.getAI().getIntention();
				if (a == CtrlIntention.AI_INTENTION_ACTIVE
				 || a == CtrlIntention.AI_INTENTION_IDLE) //move at random.
						moveAtRandom();
			}
			//-------------------------------------------------------
		}
	}
	
	// Clean Antharas's lair.
	public void setUnspawn()
	{
		// Eliminate players.
		_Zone.oustAllPlayers();
		
		// Not executed tasks is canceled.
		if (_cubeSpawnTask != null)
		{
			_cubeSpawnTask.cancel(true);
			_cubeSpawnTask = null;
		}
		if (_monsterSpawnTask != null)
		{
			_monsterSpawnTask.cancel(true);
			_monsterSpawnTask = null;
		}
		if (_activityCheckTask != null)
		{
			_activityCheckTask.cancel(false);
			_activityCheckTask = null;
		}
		if (_socialTask != null)
		{
			_socialTask.cancel(true);
			_socialTask = null;
		}
		if (_mobiliseTask != null)
		{
			_mobiliseTask.cancel(true);
			_mobiliseTask = null;
		}
		if (_mobsSpawnTask != null)
		{
			_mobsSpawnTask.cancel(true);
			_mobsSpawnTask = null;
		}
		if (_selfDestructionTask != null)
		{
			_selfDestructionTask.cancel(true);
			_selfDestructionTask = null;
		}
		if (_moveAtRandomTask != null)
		{
			_moveAtRandomTask.cancel(true);
			_moveAtRandomTask = null;
		}
		
		// Delete monsters.
		for (L2Npc mob : _monsters)
		{
			mob.getSpawn().stopRespawn();
			mob.deleteMe();
		}
		_monsters.clear();
		
		// Delete teleport cube.
		for (L2Npc cube : _teleportCube)
		{
			cube.getSpawn().stopRespawn();
			cube.deleteMe();
		}
		_teleportCube.clear();
	}
	
	// Do spawn teleport cube.
	private class CubeSpawn implements Runnable
	{
		private int _type;
		
		CubeSpawn(int type)
		{
			_type = type;
		}
		
		public void run()
		{
			if (_type == 0)
			{
				spawnCube();
				_cubeSpawnTask.cancel(false);
				_cubeSpawnTask = null;
				_cubeSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new CubeSpawn(1), 1800000);
				screenMessage("");	//[JOJO]
				announce((1800000 / 60000) + "ȓɃA^X̐ދĂB");	//[JOJO]
			}
			else
			{
				setUnspawn();
				_cubeSpawnTask.cancel(false);
				_cubeSpawnTask = null;
			}
		}
	}
	
	// UnLock Antharas.
	private class UnlockAntharas implements Runnable
	{
		private int _bossId;
		
		public UnlockAntharas(int bossId)
		{
			_bossId = bossId;
		}
		
		public void run()
		{
			GrandBossManager.getInstance().setBossStatus(_bossId,DORMANT);
			if (FWA_DOSERVEREARTHQUAKE)
				for(L2PcInstance p : L2World.getInstance().getAllPlayers().values())
					p.broadcastPacket(new Earthquake(185708,114298,-8221,20,10));
		}
	}
	
	// Action is enabled the boss.
	private class SetMobilised implements Runnable
	{
		private L2GrandBossInstance _boss;
		
		public SetMobilised(L2GrandBossInstance boss)
		{
			_boss = boss;
		}
		
		public void run()
		{
			_boss.setIsImmobilized(false);
			
			// When it is possible to act, a social action is canceled.
			if (_socialTask != null)
			{
				_socialTask.cancel(true);
				_socialTask = null;
			}
		}
	}
	
	//[JOJO]-------------------------------------------------
	// Move at random on after Antharas appears.
	private void moveAtRandom()
	{
		if (FWA_MOVEATRANDOM)
		{
			L2Npc npc = _antharas;
			double radius, angle;
			if (Rnd.get(4) == 0)
				_Zone.broadcastPacket(new SocialAction(npc.getObjectId(), Rnd.get(1, 3)));
			else if ((radius = com.l2jserver.gameserver.util.Util.calculateDistance(npc.getX(), npc.getY(), npc.getZ(), 177915, 114941, -7707, true) - 2300) > 0)
			{
				_Zone.updateKnownList(npc);
				radius += 100 + Rnd.get(500);
				angle = Math.atan2(114941 - npc.getY(), 177915 - npc.getX());
				int x = npc.getX() + (int)(radius * Math.cos(angle));
				int y = npc.getY() + (int)(radius * Math.sin(angle));
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(x, y, -7707, 0));
			}
			else
			{
				_Zone.updateKnownList(npc);
				radius = Rnd.get(2300);
				angle = Rnd.get() * 6.283185307179586476925286766559D;
				int x = 177915 + (int)(radius * Math.cos(angle));
				int y = 114941 + (int)(radius * Math.sin(angle));
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(x, y, -7707, 0));
			}
		}
	}
	//-------------------------------------------------------
	private class MoveAtRandom implements Runnable
	{
		private L2Npc _npc;
		private L2CharPosition _pos;
		
		public MoveAtRandom(L2Npc npc, L2CharPosition pos)
		{
			_npc = npc;
			_pos = pos;
		}
		
		public void run()
		{
			_npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, _pos);
		}
	}
	
	@Override
	public String onAttack (L2Npc npc, L2PcInstance attacker, int damage, boolean isPet)
	{
		if (npc.getNpcId() == 29019 || npc.getNpcId() == 29066 || npc.getNpcId() == 29067 || npc.getNpcId() == 29068)
		{
			_LastAction = System.currentTimeMillis();
			if (GrandBossManager.getInstance().getBossStatus(_antharas.getNpcId()) != FIGHTING)
			{
				_Zone.oustAllPlayers();
			}
			else if (!FWA_OLDANTHARAS && _mobsSpawnTask == null)
			{
				startMinionSpawns(npc.getNpcId());
			}
		}
		else if (npc.getNpcId() > 29069 && npc.getNpcId() < 29077 && npc.getCurrentHp() <= damage)
		{
			L2Skill skill = null;
			switch (npc.getNpcId())
			{
				case 29070:
				case 29071:
				case 29072:
				case 29073:
				case 29074:
				case 29075:
					skill = SkillTable.getInstance().getInfo(5097, 1);
					break;
				case 29076:
					skill = SkillTable.getInstance().getInfo(5094, 1);
					break;
			}
			
			npc.doCast(skill);
		}
		return super.onAttack(npc, attacker, damage, isPet);
	}
	
	@Override
	public String onKill (L2Npc npc, L2PcInstance killer, boolean isPet)
	{
		final int npcId = npc.getNpcId();
		if (npcId == 29019 || npcId == 29066 || npcId == 29067 || npcId == 29068)
		{
			_Zone.broadcastPacket(new PlaySound(1, "BS01_D", 1, npc.getObjectId(), npc.getX(), npc.getY(), npc.getZ()));
			_cubeSpawnTask = ThreadPoolManager.getInstance().scheduleGeneral(new CubeSpawn(0), 10000);
			GrandBossManager.getInstance().setBossStatus(npcId,DEAD);
			long respawnTime = (long)Config.Interval_Of_Antharas_Spawn + Rnd.get(Config.Random_Of_Antharas_Spawn);
			ThreadPoolManager.getInstance().scheduleGeneral(new UnlockAntharas(npcId), respawnTime);
			// also save the respawn time so that the info is maintained past reboots
			StatsSet info = GrandBossManager.getInstance().getStatsSet(npcId);
			info.set("respawn_time",(System.currentTimeMillis() + respawnTime));
			GrandBossManager.getInstance().setStatsSet(npcId,info);
			Broadcast.announceToOnlinePlayers("nA^XS܂B̕ "+GrandBossManager.respawnTimeFormat(info)+" łB");	//[JOJO]
			giveItemParty(ANTHARAS_CIRCLET, killer, npc);	//[JOJO]
			//[JOJO]-------------------------------------------------
			for (L2Npc mob : _monsters)
			{
				if (mob == npc)
					/* Do animation task. (See com.l2jserver.gameserver.taskmanager.DecayTaskManager) */;
				else
					mob.deleteMe();
			}
			_monsters.clear();
			//-------------------------------------------------------
		}
		else if (npcId == 29069)
		{
			int countHPHerb = Rnd.get(6, 18);
			int countMPHerb = Rnd.get(6, 18);
			for (int i = 0; i < countHPHerb; i++)
				((L2MonsterInstance)npc).dropItem(killer, 8602, 1);
			for (int i = 0; i < countMPHerb; i++)
				((L2MonsterInstance)npc).dropItem(killer, 8605, 1);
		}
		if (_monsters.contains(npc))
			_monsters.remove(npc);
		return super.onKill(npc,killer,isPet);
	}

	//[JOJO]-------------------------------------------------
	private void giveItemParty(int itemId, L2PcInstance player, L2Npc npc) //+[JOJO]
	{
		if (player != null)
		{
			for (L2PcInstance pc : this.getPartyMembers(player))
			{
				PcInventory inven = pc.getInventory();
				L2ItemInstance item;
				if ((item = inven.getItemByItemId(itemId)) == null || item.getCount() < 1)
				{
					pc.addItem("Quest", itemId, 1, npc, true);
					pc.broadcastPacket(new SystemMessage(SystemMessageId.ANNOUNCEMENT_C1_PICKED_UP_S2).addCharName(pc).addItemName(itemId));
				}
			}
		}
	}

	List<L2PcInstance> getPartyMembers(L2PcInstance player)	//[JOJO]
	{
		L2Party party;
		if ((party = player.getParty()) != null)
			return party.getPartyMembers();
		else
		{
			List<L2PcInstance> m = new ArrayList<L2PcInstance>(1);
			m.add(player);
			return m;
		}
	}

	private void screenMessage(String text) //+[JOJO]
	{
		_Zone.broadcastPacket(new ExShowScreenMessage(text,10000));
	}

	private void announce(String text) //+[JOJO]
	{
		_Zone.broadcastPacket(new CreatureSay(0, 10, "", text));
	}
	//-------------------------------------------------------
}