/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package events.LetterPiece;

import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;

/**
 * L2Day Collect Piece of Letters Event
 *
http://svn.l2jfree.com/svn/l2j-free/trunk/l2jfree-datapack/data/scripts/custom/5011_l2day/__init__.py
# ----------------------------------------------------------------------------------
#	        Created by DJ_WEST. (C) Reallite Labs (www.reallite.cs2.ru)  1.11.2005
#	        Official idea - NCSoft. Version: 1.0
#	        Beautified by Lizard
# ----------------------------------------------------------------------------------
 *
 * @author JOJO Rewrite java.
 */
public class LetterPiece extends Quest
{
	// Settings
	private static final String qn = "LetterPiece";	/*"5011_l2day"*/

	// [0] chance
	// [1] qty
	// [2...] item

//	/********************************************/
	/* 2009N6 5No[W                */
	private int[][] REWARDS_5YEAR = {
		{  1, 1,  6660 },	//1 NC[Ag O
		{  3, 1,  8762 },	//2 ŏ㋉ ̐΁Fx76
		{  5, 1,  8752 },	//3 ㋉@̐΁Fx76
		{  7, 2,  3959 },	//4 L2day jꂽXN[i2j
		{ 11, 2,  3958 },	//5 L2day jꂽA҃XN[i2j
		{ 13, 1, 13429,		//6 xA[ LbvFCxgp
		         13430,		//    sbO LbvFCxgp
		         13431 },	//    sG̖XqFCxgp
		{ 17, 2,   736 },	//7 A҃XN[2
	//	{ 17, 1, 13422 },	//7 A҃XN[2{bNX
		{ 19, 2,  7162 },	//8 2
	//	{ 19, 1, 13423 },	//8 2{bNX
		{ 24, 3, 10260,10261,10262,10263,10264,10265,10266,10267,10268,10269,10270 }, //9 W[X3{
	//	{ 24, 1, 13424 },	//9 W[X3{{bNX
	};
	private int[][] REWARDS_GRACIA = {
		{  1, 1,  6661 },	//1 ItF CAO
		{  3, 1,  8752 },	//2 ㋉@̐΁Fx76
		{  5, 1,  8742 },	//3  ̐΁Fx76
		{  7, 1,  3959 },	//4 L2day jꂽXN[i1j
		{ 11, 1,  3958 },	//5 L2day jꂽA҃XN[i1j
		{ 13, 1, 13429,		//6 xA[ LbvFCxgp
		         13430,		//    sbO LbvFCxgp
		         13431 },	//    sG̖XqFCxgp
		{ 17, 1,   736 },	//7 A҃XN[1
	//	{ 17, 1, 13425 },	//7 A҃XN[1{bNX
		{ 19, 1,  7162 },	//8 1
	//	{ 19, 1, 13426 },	//8 1{bNX
		{ 23, 2, 10260,10261,10262,10263,10264,10265,10266,10267,10268,10269,10270 }, //9 W[X2{
	//	{ 23, 1, 13427 },	//9 W[X2{{bNX
	};
	private int[][] REWARDS_LINEAGEII = {
		{  1, 1,  6662 },	//1 RA O
		{  3, 1,  8752 },	//2 ㋉@̐΁Fx76
		{  5, 1,  8742 },	//3  ̐΁Fx76
		{  7, 1,  3959 },	//4 L2day jꂽXN[i1j
		{ 11, 1,  3958 },	//5 L2day jꂽA҃XN[i1j
		{ 13, 1, 13429,		//6 xA[ LbvFCxgp
		         13430,		//    sbO LbvFCxgp
		         13431 },	//    sG̖XqFCxgp
		{ 17, 1,   736 },	//7 A҃XN[1
	//	{ 17, 1, 13425 },	//7 A҃XN[1{bNX
		{ 19, 1,  7162 },	//8 1
	//	{ 19, 1, 13426 },	//8 1{bNX
		{ 23, 1, 10260,10261,10262,10263,10264,10265,10266,10267,10268,10269,10270 }, //9 W[X1{
	//	{ 23, 1, 13428 },	//9 W[X1{{bNX
	};
//	/********************************************/

//	/********************************************/
//	/* 2007N12 t@[XgX[ o[W */
//	private int[][] REWARDS_LINEAGEII = {
//		{  1, 1, 6660 },	// 1 NC[Ag O
//		{  3, 1, 6662 },	// 2 RA O
//		{  5, 1, 8950 },	// 3 L2DayFꂳ̃Vy
//		{  7, 1, 8949 },	// 4 L2DayFtFA[̐Gp
//		{ 11, 1, 8947 },	// 5 L2DayFETM̎
//		{ 13, 1,  729 },	// 6 틭XN[FAO[h(1)
//		{ 17, 2,  947 },	// 7 틭XN[FBO[h(2)
//		{ 19, 3,  951 },	// 8 틭XN[FCO[h(3)
//		{ 23, 1, 3959 },	// 9 L2day jꂽXN[(1)
//		{ 27, 1, 3958 },	//10 L2day jꂽA҃XN[(1)
//		{ 29, 3, 3926,3927,3928,3929,3930,3931,3932,3933,3934,3935 } //11 L2Day ⏕@XN[...
//	};
//	private int[][] REWARDS_THRONE = {
//		{  1, 1, 6660 },	//1 NC[Ag O
//		{  3, 1, 6662 },	//2 RA O
//		{  5, 1, 8951 },	//3 L2DayF̃S[O
//		{  7, 1, 8948 },	//4 L2DayFVg̉H
//		{ 11, 2,  947 },	//5 틭XN[FBO[h(2)
//		{ 13, 3,  951 },	//6 틭XN[FCO[h(3)
//		{ 17, 4,  955 },	//7 틭XN[FDO[h(4)
//		{ 19, 1, 3959 },	//8 L2day jꂽXN[(1)
//		{ 23, 1, 3958 },	//9 L2day jꂽA҃XN[(1)
//		{ 27, 2, 3926,3927,3928,3929,3930,3931,3932,3933,3934,3935 } //10 L2Day ⏕@XN[...
//	};
//	/********************************************/

//	/********************************************/
//	/* 2005N12 NjN o[W         */
//	private int[][] REWARDS_LINEAGEII = {
//		{ 10, 5,  947 },	//1 틭XN[FBO[h(5)
//		{ 20, 3, 3959 },	//2 L2day jꂽXN[(3)
//		{ 30, 3, 3958 },	//3 L2day jꂽA҃XN[(3)
//		{ 40, 3, 3926,3927,3928,3929,3930,3931,3932,3933,3934,3935 } //4 L2DayXN3
//	};
//	private int[][] REWARDS_NCSOFT = {
//		{ 10, 5,  951 },	//1 틭XN[FCO[h(5)
//		{ 20, 2, 3959 },	//2 L2day jꂽXN[(2)
//		{ 30, 2, 3958 },	//3 L2day jꂽA҃XN[(2)
//		{ 40, 2, 3926,3927,3928,3929,3930,3931,3932,3933/*,3934*/,3935 } //4 L2DayXN2
//	};
//	private int[][] REWARDS_CHRONICLE = {
//		{ 10, 5,  955 },	//1 틭XN[FDO[h(5)
//		{ 20, 1, 3959 },	//2 L2day jꂽXN[(1)
//		{ 30, 1, 3958 },	//3 L2day jꂽA҃XN[(1)
//		{ 40, 1, 3926,3927,3928,3929/*,3930*/,3931,3932,3933/*,3934*/,3935 } //4 L2DayXN1
//	};
//	/********************************************/

	// QUEST ITEMS : Letters to form words
	@SuppressWarnings("unused")
	private static final int
	A  = 3875,
	C  = 3876,
	E  = 3877,
	F  = 3878,
	G  = 3879,
	H  = 3880,
	I  = 3881,
	L  = 3882,
	N  = 3883,
	O  = 3884,
	R  = 3885,
	S  = 3886,
	T  = 3887,
	II = 3888,
	Y  = 13417,
	_5 = 13418;

	private class ItemTable
	{
		final String name;
		final int[][] reword;
		final int[] ingredient;
		ItemTable(String name, int[][] reword, int[] ingredient)
		{
			this.name = name;
			this.reword = reword;
			this.ingredient = ingredient;
		}
	};
	private ItemTable[] itemTable = {
		new ItemTable("THRONE",    REWARDS_5YEAR,     new int[]{ T, 1, H, 1, R, 1, O, 1, N, 1, E, 1 }),
		new ItemTable("LINEAGEII", REWARDS_LINEAGEII, new int[]{ L, 1, I, 1, N, 1, E, 1, A, 1, G, 1, E, 1, II, 1 }),
		new ItemTable("GRACIA",    REWARDS_GRACIA,    new int[]{ G, 1, R, 1, A, 2, C, 1, I, 1 }),
//		new ItemTable("NCSOFT",    REWARDS_NCSOFT,    new int[]{ N, 1, C, 1, S, 1, O, 1, F, 1, T, 1 }),
//		new ItemTable("CHRONICLE", REWARDS_CHRONICLE, new int[]{ C, 1, H, 1, R, 1, O, 1, N, 1, I, 1, C, 1, L, 1, E, 1 }),
//		new ItemTable("5YEAR",     REWARDS_5YEAR,     new int[]{_5, 1, Y, 1, E, 1, A, 1, R, 1 }),
//		new ItemTable("FLAYER",    REWARDS_FLAYER,    new int[]{ F, 1, L, 1, A, 1, Y, 1, E, 1, R, 1 }),
//		new ItemTable("FRINTESSA", REWARDS_FRINTESSA, new int[]{ F, 1, R, 1, I, 1, N, 1, T, 1, E, 1, S, 2, A, 1 }),
//		new ItemTable("HALISHA",   REWARDS_HALISHA,   new int[]{ H, 2, A, 2, L, 1, I, 1, S, 1 }),
//		new ItemTable("ORFEN",     REWARDS_ORFEN,     new int[]{ O, 1, R, 1, F, 1, E, 1, N, 1 }),
//		new ItemTable("CHAOTIC",   REWARDS_CHAOTIC,   new int[]{ C, 1, H, 1, A, 1, O, 1, T, 1, I, 1, C, 1 }),
	};

	// doRequestedEvent
	private String do_RequestedEvent(String event, QuestState st, int[][] rewardTable, int[] ingredientTable)
	{
		for (int i = 0; i < ingredientTable.length; i += 2)
			if (st.getQuestItemsCount(ingredientTable[i+0]) < ingredientTable[i+1])
				return "no.htm";
		for (int i = 0; i < ingredientTable.length; i += 2)
			st.takeItems(ingredientTable[i+0], ingredientTable[i+1]);

		int total = 0;
		for (int[] a : rewardTable)
			total += a[0];
		int rnd = st.getRandom(total);
		for (int[] a : rewardTable) {
			// [0] chance
			// [1] qty
			// [2...] item
			/*static*/final int IX = 2;
			if ((rnd -= a[0]) < 0) {
				int qty = a[1];
				if (a.length - IX == 1) {
					st.giveItems(a[IX], qty);
				}
				else
				{
					while (--qty >= 0)
						st.giveItems(a[IX + st.getRandom(a.length - IX)], 1);
				}
				return "finish.htm";
			}
		}
		throw new RuntimeException();
	}

	// main code

	public LetterPiece(int id, String name, String descr)
	{
		super(id, name, descr);
		
		addStartNpc(31854);		//CxgǗl q[}
		addStartNpc(31855);		//CxgǗl Gt
		addStartNpc(31856);		//CxgǗl _[NGt
		addStartNpc(31857);		//CxgǗl h[t
		addStartNpc(31858);		//CxgǗl I[N
		addFirstTalkId(31854);	//CxgǗl q[}
		addFirstTalkId(31855);	//CxgǗl Gt
		addFirstTalkId(31856);	//CxgǗl _[NGt
		addFirstTalkId(31857);	//CxgǗl h[t
		addFirstTalkId(31858);	//CxgǗl I[N
		addTalkId(31854);		//CxgǗl q[}
		addTalkId(31855);		//CxgǗl Gt
		addTalkId(31856);		//CxgǗl _[NGt
		addTalkId(31857);		//CxgǗl h[t
		addTalkId(31858);		//CxgǗl I[N
	}

	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		if (event.length() == 0 || event.equals("0"))	// <a>ǂ</a>
			return npc.getNpcId()+".htm";				// 31854.htm`31858.htm
		QuestState st = player.getQuestState(getName());
		if (st != null) {
			String htmltext = event;
			for (ItemTable items : itemTable) {
				if (event.equals(items.name)) {
					htmltext = do_RequestedEvent(event, st, items.reword, items.ingredient);
					break;
				}
			}
			if (htmltext != event)
				st.exitQuest(false);
			return htmltext;
		}
		return null;
	}

	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			Quest q = QuestManager.getInstance().getQuest(getName());
			st = q.newQuestState(player);
		}
		return npc.getNpcId()+".htm";	// 31854.htm`31858.htm
	}

	// Quest class and state definition
	public static void main(String[] args)
	{
		new LetterPiece(-1, qn, "events");
	}
}