/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package events.MasterOfEnchanting;

/**
 * Author JOJO
 *   l2j-free q
 *   http://svn.l2jfree.com/svn/l2j-free/trunk/l2jfree-datapack/data/scripts/official_events/8021_MasterOfEnchanting/__init__.py
 *   r7350  2009/10/27 03:12:36
 *  
 * ֘A: AbstractEnchantPacket.java
	Character.properties  EnchantSafeMax Ȃ
	G`g[gɐݒ肵Ă +23 ܂ŎsȂ߁AQ[ɂȂȂ̂
	𑼂̃XN[Ƃ͕ʌɌ肷.
 */

/**
 * Author Psycho(killer1888) / L2jFree
 */

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;

import javolution.util.FastList;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.Util;

class MasterOfEnchanting extends Quest
{
	//-------------------- TO MODIFY --------------------//
	
	// Start and End date of the event, end date included for the event (Format: yyyy/MM/dd )
	// Retail: 2009/04/14 - 2009/04/28
	private static final String DATE_FORMAT    = "yyyy/MM/dd";
	private static final String EVENTSTARTDATE = "2009/04/14";
	private static final String EVENTENDDATE   = "2009/04/28";
	
	// Despawn Yogi at end date? Will start a check every 30 minutes to check if event is over and in case unspawn every npc.
	// Usefull if you don't have a server reboot everyday.
	// Note that their is no auto start for the event. If the server loads the script on the day or after the start day but
	// before end date, the event will be considered as started and will automatically spawn Yogi. It won't spawn them
	// by itself on midnight the starting day.
	private static final boolean AUTODESPAWN = true;
	
	// Prevents player under that level to get scrolls, to block people creating accounts and accounts on private servers.
	// Retail = 0
	private static final int ALLOWEDLEVELS = 0;
	
	// Rate drop adena. This will influence the scroll/staff prices on Master Yogi.
	// If RATEADENA = 0 it will use your actual server config for adena drop rate
	// If higher, it will multiply the prices by your value
	// Ratail would then be 1
	private static final int RATEADENA = 1;
	
	// As it subsists and it's a known fact that enchant exploit still exists, the script will log user that bring
	// Yogi staffs with equal or higher enchant value than this option. (So if you see lots of times a player bringing
	// a +23 Staff, you might consider checking how he did it...)
	// 0 to disable
	private static final int LOGVALUE = 0;
	
	// This option permits you to forbid access to the event to the ACCOUNTS listed in it. Do not use capital letters.
	// Usefull if you have doubts about player accounts using exploits.
	private static final String[] FORBIDDEN_ACCOUNTS = {"test"};
	
	//-------------------- END USER MODIFICATIONS --------------------//
	
	private static final String qn = "MasterOfEnchanting";

	// NPC
	private static final int YOGI   = 32599;	//R̐l }X^[M

	// ITEM
	private static final int STAFF  = 13539;	//}X^[M̃X^bt
	private static final int SCROLL = 13540;	//}X^[M̕틭XN[
 //	private static final int BOX    = 13541;	//M̃G`g
 //	private static final int CUBE   = 13542;	//M̃G`g܃L[u
	private static final int ADENA  = 57;

	// REWARDS
	private static final int[] FIRECRACKER           = {6406};	//6406 ԉ
	private static final int[] LFIRECRACKER          = {6407};	//6407 ԉ
	private static final int[] SHADOW_HAIR_ACCESSORY = {13074, 13075, 13076};
										//13074 eF}WVY nbg
										//13075 eF̃q[[}XN
										//13076 eFWuiC S[O
	private static final int[] EWD                   = {955};	//955 틭XN[FDO[h
	private static final int[] EAD                   = {956};	//956 hXN[FDO[h
	private static final int[] EWC                   = {951};	//951 틭XN[FCO[h
	private static final int[] EAC                   = {952};	//952 hXN[FCO[h
	private static final int[] EAB                   = {948};	//948 hXN[FBO[h
	private static final int[] EWA                   = {729};	//729 틭XN[FAO[h
	private static final int[] HAIR_ACCESSORY        = {13518, 13519, 13522};
										//13518 }WVY nbgFCxg
										//13519 ̃q[[}XNFCxg
										//13522 WuiC S[OFCxg
	private static final int[] S_ACCESSORY           = {13992};	//13992 SO[h ANZT[̔FCxg
	private static final int[] HIGH_LIFESTONE        = {8752};	// 8752 ㋉ ̐΁Fx76
	private static final int[] EWS                   = {959};	//  959 틭XN[FSO[h
	private static final int[] S_ARMOR               = {13991};	//13991 SO[h h̔FCxg
	private static final int[] S_WEAPON              = {13990};	//13990 SO[h ̔FCxg
	private static final int[] TOP_LIFESTONE         = {8762};	// 8762 ŏ㋉̐΁Fx76
	private static final int[] SOULCRY               = {9570, 9571, 9572};
										//9570 bh \E Xg[FXebv14
										//9571 u[ \E Xg[FXebv14
										//9572 O[ \E Xg[FXebv14
	private static final int[] S80_ARMOR             = {13989};	//13989 S80O[hh̔FCxg
	private static final int[] S80_WEAPON            = {13988};	//13988 S80O[h̔FCxg
	
	private static final int[] a1 = {1}, a2 = {2}, a3 = {3};	//amount
	
	private static final int[][][][] REWARDS = {
	{{FIRECRACKER, a1}},						//+4:ԉ 1
	{{FIRECRACKER, a2}, {LFIRECRACKER, a1}},	//+5:ԉ 2Aԉ 1
	{{FIRECRACKER, a3}, {LFIRECRACKER, a2}},	//+6:ԉ 3Aԉ 2
	{{SHADOW_HAIR_ACCESSORY, a1}},				//+7:ewAANZT[ 1
	{{EWD, a1}},								//+8:틭XN[FDO[h1
	{{EWD, a1}, {EAD, a1}},						//+9:EhXN[FDO[h eP
	{{EWC, a1}},								//+10:틭XN[FCO[h1
	{{EWC, a1}, {EAC, a1}},						//+11:EhXN[FCO[h e1
	{{EAB, a1}},								//+12:틭XN[FBO[h1
	{{EWA, a1}},								//+13:틭XN[FAO[h1
	{{HAIR_ACCESSORY, a1}},						//+14:wAANZT[ 1
	{{S_ACCESSORY, a1}},						//+15:SO[h ANZT[̔FCxgp 1
	{{HIGH_LIFESTONE, a1}},						//+16:ŏ㋉ ̐΁F76x 1
	{{EWS, a1}},								//+17:틭XN[FSO[h1
	{{S_ARMOR, a1}},							//+18:SO[h h̔FCxgp 1
	{{S_WEAPON, a1}},							//+19:SO[h ̔FCxgp 1
	{{SOULCRY, a1}},							//+20:\E Xg[FXebv14bhEO[Eu[̂ꂩ1
	{{{8762, 8752, 9570, 9571, 9572}, a1}},		//+21:ŏ㋉A㋉̐΁F76xA\EXg[FXebv14 bhEO[Eu[ ꂩ1
	{{S80_ARMOR, a1}},							//+22:S80O[h h̔ 1
	{{S80_WEAPON, a1}},							//+23:S80O[h ̔ 1
	};
	//TODO: 2010N - }X^[ MƌɃCxgI̒eiX܂ŏĂƂ炦
	// +24 UP CO 1
	// +25 NC[ Ag O 1
	// +26 oCE O 1
	
	private static final int[] TEXTS = {1600024, 1600023};
 //	private static final String[] TEXTS = {"Don't pass up the chance to win an S80 Weapon.", "Care to challenge fate and test your luck?"};
	
	private static final int RATE = RATEADENA != 0 ? RATEADENA : 1/*Config.RATE_DROP_ADENA*/;
	
	private long _EVENTSTARTDATE, _EVENTENDDATE;
	private List<L2Npc> _yogiSpawnList;

	private long checkRemainingTime(L2PcInstance player)
	{
		long currentTime = System.currentTimeMillis() / 1000;
		String account = player.getAccountName();
		String state = loadGlobalQuestVar(account);
		if (state.length() > 0) {
			long remainingTime = Long.valueOf(state) + 21600/*6H*/ - currentTime;
			if (remainingTime > 0)
				return remainingTime;
		}
		saveGlobalQuestVar(account, String.valueOf(currentTime));
		return 0;
	}
	
	private void rewardPlayer(QuestState st, int enchant)
	{
		st.takeItems(STAFF, -1);
		if (enchant > 23)
			enchant = 23;
		int[][][] rewardList = REWARDS[enchant-4];
		for (int[][] reward : rewardList) {
			int[] itemList = reward[0];
			int amount = reward[1][0];
			int item = itemList[Rnd.get(itemList.length)];
			st.giveItems(item, amount);
		}
		return;
	}

	public MasterOfEnchanting(int questId, String name, String descr)
	{
		super(questId, name, descr);

		addStartNpc(YOGI);
		addTalkId(YOGI);
		addSpawnId(YOGI);

		SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
		try
		{
			_EVENTSTARTDATE = format.parse(EVENTSTARTDATE).getTime();
			_EVENTENDDATE = format.parse(EVENTENDDATE).getTime();
			System.out.println("MasterOfEnchanting:210: " + Util.dateFormat(_EVENTSTARTDATE) + " - " + Util.dateFormat(_EVENTENDDATE)); // verify
		}
		catch (ParseException e)
		{
			e.printStackTrace();
		}

		long DATE = System.currentTimeMillis();
		if (DATE >= _EVENTSTARTDATE && DATE <=_EVENTENDDATE) {
			startQuestTimer("SpawnYogi", 30000, null, null);
			System.out.println("Master of Enchanting event is ON");
		} else {
			System.out.println("Master of Enchanting event is OFF");
		}
	}
	
	@SuppressWarnings("unused")
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		if (event == "Autochat") {
			npc.broadcastPacket(new NpcSay(npc.getObjectId(), 0, npc.getNpcId(), TEXTS[Rnd.get(TEXTS.length)]));
			return null;
		} else if (event == "SpawnYogi") {
			_yogiSpawnList = new FastList<L2Npc>();
			_yogiSpawnList.add(addSpawn(YOGI, 82941, 149318, -3473, 39138, false, 0, false, 0));
			_yogiSpawnList.add(addSpawn(YOGI, 148022, -55481, -2738, 34214, false, 0, false, 0));
			_yogiSpawnList.add(addSpawn(YOGI, 15776, 142872, -2710, 17423, false, 0, false, 0));
			_yogiSpawnList.add(addSpawn(YOGI, -14067, 123290, -3121, 18774, false, 0, false, 0));
			_yogiSpawnList.add(addSpawn(YOGI, 87015, -143229, -1296, 4092, false, 0, false, 0));
			_yogiSpawnList.add(addSpawn(YOGI, 117104, 77017, -2699, 32767, false, 0, false, 0));
			_yogiSpawnList.add(addSpawn(YOGI, 146772, 25906, -2017, 57344, false, 0, false, 0));
			_yogiSpawnList.add(addSpawn(YOGI, 43984, -47713, -801, 47497, false, 0, false, 0));
			_yogiSpawnList.add(addSpawn(YOGI, 82882, 53098, -1500, 17351, false, 0, false, 0));
			_yogiSpawnList.add(addSpawn(YOGI, -83127, 150941, -3133, 0, false, 0, false, 0));
			_yogiSpawnList.add(addSpawn(YOGI, 111333, 219424, -3550, 48247, false, 0, false, 0));
			if (AUTODESPAWN)
				startQuestTimer("DespawnYogi", 1800000, null, null);
			return null;
		} else if (event == "DespawnYogi") {
			long DATE = System.currentTimeMillis();
			if (DATE <= _EVENTENDDATE) {
				startQuestTimer("DespawnYogi", 1800000, null, null);
			} else {
				for (L2Npc yogi : _yogiSpawnList)
					yogi.decayMe();
				System.out.println("Master of Enchanting event is finished");
			}
			return null;
		}
		QuestState st = player.getQuestState(qn);
		if (st == null) st = newQuestState(player);
		String htmltext = event;
		int npcId = npc.getNpcId();
		if (npcId == YOGI) {
			if (event.equals("32599.htm")) {
				htmltext = st.showHtmlFile("32599.htm")
							.replace("Adena1", String.valueOf(1000 * RATE))
							.replace("Adena2", String.valueOf(6000 * RATE))
							.replace("Adena3", String.valueOf(77777 * RATE))
							.replace("Adena4", String.valueOf(777770 * RATE));
			} else if (event.equals("32599-01.htm")) {
				if (st.getQuestItemsCount(STAFF) >= 1 || st.getQuestItemsCount(ADENA) < 1000 * RATE) {
					htmltext = "32599-02.htm";
				} else {
					st.takeItems(ADENA, 1000 * RATE);
					st.giveItems(STAFF, 1);
				}
			} else if (event.equals("32599-03.htm")) {
				long remainingTime;
				if (st.getQuestItemsCount(ADENA) < 6000 * RATE) {
					htmltext = "32599-02.htm";
				} else if ((remainingTime = this.checkRemainingTime(player)) > 0) {
					htmltext = "32599-02.htm";
					player.sendPacket(SystemMessage.sendString("Remaining time: " + remainingTime + " seconds"));
				} else {
					st.takeItems(ADENA, 6000 * RATE);
					st.giveItems(SCROLL, 24);
				}
			} else if (event.equals("32599-05.htm")) {
				if (st.getQuestItemsCount(ADENA) < 77777 * RATE) {
					htmltext = "32599-02.htm";
				} else {
					st.takeItems(ADENA, 77777 * RATE);
					st.giveItems(SCROLL, 1);
				}
			} else if (event.equals("32599-06.htm")) {
				if (st.getQuestItemsCount(ADENA) < 777770 * RATE) {
					htmltext = "32599-02.htm";
				} else {
					st.takeItems(ADENA, 777770 * RATE);
					st.giveItems(SCROLL, 10);
				}
			} else if (event.equals("Rewards")) {
				String account = player.getAccountName();
				if (contains(FORBIDDEN_ACCOUNTS, account)) {
					player.sendPacket(SystemMessage.sendString("Your account is not allowed to participate in the event. Contact a GameMaster if you need explanations."));
					return "";
				}
				L2ItemInstance weapon = player.getInventory().getPaperdollItem(Inventory.PAPERDOLL_LRHAND);
				if (weapon != null) {
					int weaponId = weapon.getItemId();
					if (weaponId == STAFF && weapon.getEnchantLevel() > 3) {
						int enchant = weapon.getEnchantLevel();
						if (LOGVALUE > 0 && enchant >= LOGVALUE) {
							System.out.println("Master of Enchanting event: Player " + player.getName() + " brought a +" + enchant + " weapon");
						}
						this.rewardPlayer(st, enchant);
						htmltext = "32599-08.htm";
					} else {
						htmltext = "32599-07.htm";
					}
				} else {
					htmltext = "32599-07.htm";
				}
			}
		}
		return htmltext;
	}

	@SuppressWarnings("unused")
	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		String htmltext = "<html><body>You are either not on a quest that involves this NPC, or you don't meet this NPC's minimum quest requirements.</body></html>";
		QuestState st = player.getQuestState(qn);
		if (st == null) return htmltext;
		int npcId = npc.getNpcId();
		if (npcId == YOGI) {
			String account = player.getAccountName();
			if (contains(FORBIDDEN_ACCOUNTS, account)) {
				player.sendPacket(SystemMessage.sendString("Your account is not allowed to participate in the event. Contact a GameMaster if you need explanations."));
				return "";
			}
			if (ALLOWEDLEVELS > 0 && player.getLevel() < ALLOWEDLEVELS) {
				player.sendPacket(SystemMessage.sendString("Sorry, you may only take part of this event once you reached level " + ALLOWEDLEVELS));
				return "";
			}
			htmltext = st.showHtmlFile("32599.htm")
				.replace("Adena1", String.valueOf(1000 * RATE))
				.replace("Adena2", String.valueOf(6000 * RATE))
				.replace("Adena3", String.valueOf(77777 * RATE))
				.replace("Adena4", String.valueOf(777770 * RATE));
		}
		return htmltext;
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
	    startQuestTimer("Autochat", 60000, npc, null, true);
	    return null;
	}

	private static boolean contains(String[] array, String obj)
	{
		for (String f : array)
			if (f.equals(obj)) return true;
		return false;
	}

	public static void main(String[] args)
	{
		new MasterOfEnchanting(-1, qn, "events");
	}
}