﻿## Active Perl 5.8.8
##!/usr/local/bin/perl

# datapack_development language tool for Japanese.
# native2ascii
# *.java と *.py をまとめてnative2ascii処理します。
# 元のファイルを上書きします。

use utf8;
use warnings;
use strict;
use Encode;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $LogFile = UTF8(__FILE__);
   $LogFile =~ s!\.[^.\/\\]*$!.log!;
open LOG, '>:utf8', FS($LogFile)  or die "'$LogFile' $!";

if (@ARGV) {
	$_ = UTF8($_) foreach (@ARGV);
	my $buildDir = shift;
	$buildDir .= '/' unless $buildDir =~ m/[\/\\]$/;
	&start($buildDir);
} else {
	&start('./data/scripts/');
}

close LOG;
exit 0;

sub start {
	my ($subDir) = @_;

	print "[",$subDir,"]\n";
	opendir DIR, $subDir  or die "'$subDir' $!";
	my @files = readdir DIR;
	$_ = UTF8($_) foreach (@files);
	closedir DIR;

	foreach my $fileName (@files) {
		next if $fileName =~ m/^\./;
		next if $fileName =~ m/ /;

		my $targetPath = $subDir.$fileName;

		if (-d $targetPath) {

			&start($targetPath.'/');
			next;

		} elsif ($fileName =~ m/\.java$/
		      || $fileName =~ m/\.py$/) {
			open FILE, '<:encoding(cp932)', $targetPath  or die "'$targetPath' $!";
			read FILE, my $text, -s FILE;
			my $mtime = (stat FILE)[9];
			close FILE;
			my $original = $text;

			$text =~ s/([\x{0080}-\x{FFFF}])/sprintf '\\u%04x',ord($1)/eg;

			if ($text ne $original) {
				open FILE, '>:encoding(ascii)', $targetPath  or die "'$targetPath' $!";
				print FILE $text;
				close FILE;
				utime $mtime, $mtime, $targetPath;

				print    "+$targetPath\n";
				print LOG "$targetPath\n";
			}
		}
	}
}
