DROP TABLE IF EXISTS `armor`;
CREATE TABLE IF NOT EXISTS `armor` (
  `item_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(120) NOT NULL DEFAULT '',
  `additionalname` varchar(120) NOT NULL DEFAULT '',
  `bodypart` varchar(15) NOT NULL DEFAULT 'none',
  `crystallizable` enum('true','false') NOT NULL DEFAULT 'false',
  `armor_type` enum('none','light','heavy','magic','sigil','pet') NOT NULL DEFAULT 'none',
  `weight` smallint(4) NOT NULL DEFAULT '0',
  `material` varchar(15) NOT NULL DEFAULT 'wood',
  `crystal_type` enum('none','d','c','b','a','s','s80','s84') NOT NULL DEFAULT 'none',
  `avoid_modify` tinyint(2) NOT NULL DEFAULT '0',
  `duration` mediumint(5) NOT NULL DEFAULT '-1', -- duration in minutes for shadow items
  `time` mediumint(5) NOT NULL DEFAULT '-1',     -- duration in minutes for time limited items
  `p_def` smallint(3) NOT NULL DEFAULT '0',
  `m_def` smallint(3) NOT NULL DEFAULT '0',
  `mp_bonus` smallint(3) NOT NULL DEFAULT '0',
  `price` int(10) unsigned NOT NULL DEFAULT '0',
  `crystal_count` smallint(4) unsigned NOT NULL DEFAULT '0',
  `sellable` enum('true','false') NOT NULL DEFAULT 'false',
  `dropable` enum('true','false') NOT NULL DEFAULT 'false',
  `destroyable` enum('true','false') NOT NULL DEFAULT 'false',
  `tradeable` enum('true','false') NOT NULL DEFAULT 'false',
  `depositable` enum('true','false') NOT NULL DEFAULT 'false',
  `enchant4_skill` varchar(8) NOT NULL DEFAULT '0-0',
  `skill` varchar(70) DEFAULT '0-0;',
  PRIMARY KEY (`item_id`)
) DEFAULT CHARSET=utf8;

INSERT INTO `armor` VALUES
(21,'Shirt','','chest','false','light',4830,'cloth','none',0,-1,-1,36,1,0,113,0,'true','true','true','true','true','0-0','0-0;'),
(22,'Leather Shirt','','chest','false','light',4830,'leather','none',0,-1,-1,43,1,0,1870,0,'true','true','true','true','true','0-0','0-0;'),
(23,'Wooden Breastplate','','chest','false','light',4820,'wood','none',0,-1,-1,47,1,0,6120,0,'true','true','true','true','true','0-0','0-0;'),
(24,'Bone Breastplate','','chest','false','light',4770,'bone','none',0,-1,-1,50,1,0,15600,0,'true','true','true','true','true','0-0','0-0;'),
(25,'Piece Bone Breastplate','','chest','false','heavy',8970,'bone','none',0,-1,-1,62,1,0,24480,0,'true','true','true','true','true','0-0','0-0;'),
(26,'Bronze Breastplate','','chest','false','heavy',8920,'bronze','none',0,-1,-1,68,1,0,37820,0,'true','true','true','true','true','0-0','0-0;'),
(27,'Hard Leather Shirt','','chest','false','light',4720,'leather','none',0,-1,-1,53,1,0,28400,0,'true','true','true','true','true','0-0','0-0;'),
(28,'Pants','','legs','false','light',1740,'cloth','none',0,-1,-1,22,1,0,71,0,'true','true','true','true','true','0-0','0-0;'),
(29,'Leather Pants','','legs','false','light',1730,'leather','none',0,-1,-1,27,1,0,1170,0,'true','true','true','true','true','0-0','0-0;'),
(30,'Hard Leather Pants','','legs','false','light',1700,'leather','none',0,-1,-1,29,1,0,3820,0,'true','true','true','true','true','0-0','0-0;'),
(31,'Bone Gaiters','','legs','false','light',1680,'bone','none',0,-1,-1,32,1,0,9770,0,'true','true','true','true','true','0-0','0-0;'),
(32,'Piece Bone Gaiters','','legs','false','heavy',4020,'bone','none',0,-1,-1,39,1,0,15300,0,'true','true','true','true','true','0-0','0-0;'),
(33,'Hard Leather Gaiters','','legs','false','light',1610,'leather','none',0,-1,-1,33,1,0,17700,0,'true','true','true','true','true','0-0','0-0;'),
(34,'Bronze Gaiters','','legs','false','heavy',3960,'bronze','none',0,-1,-1,43,1,0,23600,0,'true','true','true','true','true','0-0','0-0;'),
(35,'Cloth Shoes','','feet','false','none',1320,'cloth','none',0,-1,-1,9,1,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(36,'Leather Sandals','','feet','false','none',1320,'leather','none',0,-1,-1,9,1,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(37,'Leather Shoes','','feet','false','none',1320,'leather','none',0,-1,-1,13,1,0,2040,0,'true','true','true','true','true','0-0','0-0;'),
(38,'Low Boots','','feet','false','none',1320,'leather','none',0,-1,-1,15,1,0,5210,0,'true','true','true','true','true','0-0','0-0;'),
(39,'Boots','','feet','false','none',1310,'cloth','none',0,-1,-1,17,1,0,9500,0,'true','true','true','true','true','0-0','0-0;'),
(40,'Leather Boots','','feet','true','none',1300,'leather','d',0,-1,-1,19,1,0,16100,30,'true','true','true','true','true','0-0','0-0;'),
(41,'Cloth Cap','','head','false','none',660,'cloth','none',0,-1,-1,13,1,0,42,0,'true','true','true','true','true','0-0','0-0;'),
(42,'Leather Cap','','head','false','none',660,'leather','none',0,-1,-1,16,1,0,700,0,'true','true','true','true','true','0-0','0-0;'),
(43,'Wooden Helmet','','head','false','none',660,'wood','none',0,-1,-1,19,1,0,3060,0,'true','true','true','true','true','0-0','0-0;'),
(44,'Leather Helmet','','head','false','none',650,'leather','none',0,-1,-1,23,1,0,7820,0,'true','true','true','true','true','0-0','0-0;'),
(45,'Bone Helmet','','head','true','none',640,'bone','d',0,-1,-1,29,1,0,24100,44,'true','true','true','true','true','0-0','0-0;'),
(46,'Bronze Helmet','','head','true','none',630,'bronze','d',0,-1,-1,33,1,0,38400,71,'true','true','true','true','true','0-0','0-0;'),
(47,'Helmet','','head','true','none',640,'fine_steel','d',0,-1,-1,37,1,0,58600,108,'true','true','true','true','true','0-0','0-0;'),
(48,'Short Gloves','','gloves','false','none',660,'cloth','none',0,-1,-1,9,1,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(49,'Gloves','','gloves','false','none',660,'cloth','none',0,-1,-1,13,1,0,2040,0,'true','true','true','true','true','0-0','0-0;'),
(50,'Leather Gloves','','gloves','false','none',650,'leather','none',0,-1,-1,15,0,0,5210,0,'true','true','true','true','true','0-0','0-0;'),
(51,'Bracer','','gloves','false','none',650,'leather','none',0,-1,-1,17,0,0,9500,0,'true','true','true','true','true','0-0','0-0;'),
(58,'Mithril Breastplate','','chest','true','heavy',8670,'mithril','d',0,-1,-1,95,0,0,141100,260,'true','true','true','true','true','0-0','0-0;'),
(59,'Mithril Gaiters','','legs','true','heavy',3830,'mithril','d',0,-1,-1,61,0,0,97600,180,'true','true','true','true','true','0-0','0-0;'),
(60,'Composite Armor','','fullarmor','true','heavy',10980,'fine_steel','c',0,-1,-1,224,0,0,1227000,491,'true','true','true','true','true','0-0','0-0;'),
(61,'Mithril Plate Gloves','','gloves','true','none',630,'mithril','d',0,-1,-1,29,0,0,75200,137,'true','true','true','true','true','0-0','0-0;'),
(62,'Mithril Boots','','feet','true','none',1230,'leather','c',0,-1,-1,32,0,0,97100,39,'true','true','true','true','true','0-0','0-0;'),
(63,'Gauntlets','','gloves','true','none',640,'cloth','d',0,-1,-1,24,0,0,39100,71,'true','true','true','true','true','0-0','0-0;'),
(64,'Composite Boots','','feet','true','none',1220,'fine_steel','c',0,-1,-1,36,0,0,188800,76,'true','true','true','true','true','0-0','0-0;'),
(112,'Apprentice\'s Earring','','rear,lear','false','none',150,'silver','none',0,-1,-1,0,11,0,38,0,'true','true','true','true','true','0-0','0-0;'),
(113,'Mystic\'s Earring','','rear,lear','false','none',150,'silver','none',0,-1,-1,0,13,0,620,0,'true','true','true','true','true','0-0','0-0;'),
(114,'Earring of Strength','','rear,lear','false','none',150,'gold','none',0,-1,-1,0,16,0,2700,0,'true','true','true','true','true','0-0','0-0;'),
(115,'Earring of Wisdom','','rear,lear','false','none',150,'gold','none',0,-1,-1,0,16,0,2700,0,'true','true','true','true','true','0-0','0-0;'),
(116,'Magic Ring','','rfinger,lfinger','false','none',150,'gold','none',0,-1,-1,0,7,0,25,0,'true','true','true','true','true','0-0','0-0;'),
(117,'Ring of Mana','','rfinger,lfinger','true','none',150,'silver','b',0,-1,-1,0,34,0,310600,53,'true','true','true','true','true','0-0','0-0;'),
(118,'Necklace of Magic','','neck','false','none',150,'silver','none',0,-1,-1,0,15,0,51,0,'true','true','true','true','true','0-0','0-0;'),
(119,'Necklace of Binding','','neck','true','none',150,'adamantaite','c',0,-1,-1,0,64,0,434400,174,'true','true','true','true','true','0-0','0-0;'),
(347,'Ring Mail Breastplate','','chest','true','heavy',8820,'steel','d',0,-1,-1,77,0,0,64210,119,'true','true','true','true','true','0-0','0-0;'),
(348,'Scale Mail','','chest','true','heavy',8720,'steel','d',0,-1,-1,87,0,0,102500,189,'true','true','true','true','true','0-0','0-0;'),
(349,'Compound Scale Mail','','chest','true','heavy',8620,'fine_steel','d',0,-1,-1,95,0,0,141100,260,'true','true','true','true','true','0-0','0-0;'),
(350,'Dwarven Scale Mail','','chest','true','heavy',8540,'fine_steel','d',0,-1,-1,95,0,0,141100,260,'true','true','true','true','true','0-0','0-0;'),
(351,'Blast Plate','','chest','true','heavy',8420,'fine_steel','d',0,-1,-1,97,0,0,156200,288,'true','true','true','true','true','0-0','0-0;'),
(352,'Brigandine Tunic','','chest','true','heavy',8320,'fine_steel','d',0,-1,-1,103,0,0,229700,424,'true','true','true','true','true','0-0','0-0;'),
(353,'Half Plate Armor','','chest','true','heavy',8220,'fine_steel','d',0,-1,-1,111,0,0,300800,555,'true','true','true','true','true','0-0','0-0;'),
(354,'Chain Mail Shirt','','chest','true','heavy',8120,'fine_steel','c',0,-1,-1,120,0,0,388600,155,'true','true','true','true','true','0-0','0-0;'),
(355,'Dwarven Chain Mail Shirt','','chest','true','heavy',8070,'fine_steel','c',0,-1,-1,129,0,0,495500,198,'true','true','true','true','true','0-0','0-0;'),
(356,'Full Plate Armor','','fullarmor','true','heavy',10480,'fine_steel','c',0,-1,-1,239,0,0,1788000,715,'true','true','true','true','true','0-0','0-0;'),
(357,'Zubei\'s Breastplate','','chest','true','heavy',7970,'mithril','b',0,-1,-1,157,0,0,1596000,213,'true','true','true','true','true','0-0','0-0;'),
(358,'Blue Wolf Breastplate','','chest','true','heavy',7820,'oriharukon','b',0,-1,-1,166,0,0,2475000,330,'true','true','true','true','true','0-0','0-0;'),
(359,'Shining Dragon Armor','','fullarmor','true','heavy',6400,'mithril','b',0,-1,-1,301,0,0,5788000,902,'true','true','true','true','true','0-0','0-0;'),
(360,'Armor of Victory','','chest','true','heavy',3360,'oriharukon','b',0,-1,-1,175,0,0,2475000,429,'true','true','true','true','true','0-0','0-0;'),
(361,'Breastplate of Valor','','chest','true','heavy',3360,'blood_steel','b',0,-1,-1,185,0,0,3562000,617,'true','true','true','true','true','0-0','0-0;'),
(362,'Glorious Armor','','fullarmor','true','heavy',6720,'fine_steel','b',0,-1,-1,284,0,0,4022000,628,'true','true','true','true','true','0-0','0-0;'),
(363,'Red Flame Armor','','fullarmor','true','heavy',6400,'blood_steel','b',0,-1,-1,301,0,0,5788000,902,'true','true','true','true','true','0-0','0-0;'),
(364,'Elven Crystal Breastplate','','chest','true','heavy',2400,'crystal','b',0,-1,-1,175,0,0,2475000,429,'true','true','true','true','true','0-0','0-0;'),
(365,'Dark Crystal Breastplate','','chest','true','heavy',7700,'crystal','a',0,-1,-1,171,0,0,3562000,285,'true','true','true','true','true','0-0','0-0;'),
(366,'Implosion Armor','','fullarmor','true','heavy',6080,'damascus','b',0,-1,-1,284,0,0,4022000,628,'true','true','true','true','true','0-0','0-0;'),
(367,'Dark Dragon Armor','','fullarmor','true','heavy',5760,'damascus','b',0,-1,-1,301,0,0,5788000,902,'true','true','true','true','true','0-0','0-0;'),
(368,'Elven Vagian Armor','','fullarmor','true','heavy',2400,'mithril','b',0,-1,-1,284,0,0,4022000,628,'true','true','true','true','true','0-0','0-0;'),
(369,'Dark Vagian Armor','','fullarmor','true','heavy',2400,'mithril','b',0,-1,-1,301,0,0,5788000,902,'true','true','true','true','true','0-0','0-0;'),
(370,'Complete Set of Plate Armor','','fullarmor','true','heavy',6400,'fine_steel','b',0,-1,-1,284,0,0,4022000,628,'true','true','true','true','true','0-0','0-0;'),
(371,'Hell Plate','','fullarmor','true','heavy',6400,'blood_steel','b',0,-1,-1,301,0,0,5788000,902,'true','true','true','true','true','0-0','0-0;'),
(372,'Art of Plate','','fullarmor','true','heavy',6720,'chrysolite','b',0,-1,-1,284,0,0,4022000,628,'true','true','true','true','true','0-0','0-0;'),
(373,'Masterpiece Armor','','fullarmor','true','heavy',5600,'oriharukon','b',0,-1,-1,301,0,0,5788000,902,'true','true','true','true','true','0-0','0-0;'),
(374,'Armor of Nightmare','','fullarmor','true','heavy',9580,'blood_steel','a',0,-1,-1,293,0,0,8804000,704,'true','true','true','true','true','0-0','0-0;'),
(375,'Dragon Scale Mail','','chest','true','heavy',7620,'scale_of_dragon','s',0,-1,-1,198,0,0,8291000,525,'false','false','true','false','true','0-0','0-0;'),
(376,'Iron Plate Gaiters','','legs','true','heavy',3820,'steel','d',0,-1,-1,48,0,0,40100,74,'true','true','true','true','true','0-0','0-0;'),
(377,'Scale Gaiters','','legs','true','heavy',3860,'fine_steel','d',0,-1,-1,54,0,0,64100,118,'true','true','true','true','true','0-0','0-0;'),
(378,'Compound Scale Gaiters','','legs','true','heavy',3770,'fine_steel','d',0,-1,-1,61,0,0,97600,180,'true','true','true','true','true','0-0','0-0;'),
(379,'Dwarven Scale Gaiters','','legs','true','heavy',3840,'fine_steel','d',0,-1,-1,61,0,0,97600,180,'true','true','true','true','true','0-0','0-0;'),
(380,'Plate Gaiters','','legs','true','heavy',3770,'fine_steel','d',0,-1,-1,70,0,0,188000,347,'true','true','true','true','true','0-0','0-0;'),
(381,'Chain Gaiters','','legs','true','heavy',3680,'fine_steel','c',0,-1,-1,75,0,0,242900,97,'true','true','true','true','true','0-0','0-0;'),
(382,'Dwarven Chain Gaiters','','legs','true','heavy',3620,'fine_steel','c',0,-1,-1,80,0,0,309700,124,'true','true','true','true','true','0-0','0-0;'),
(383,'Zubei\'s Gaiters','','legs','true','heavy',3570,'mithril','b',0,-1,-1,98,0,0,997700,133,'true','true','true','true','true','0-0','0-0;'),
(384,'Wolf Gaiters','','legs','true','heavy',2560,'oriharukon','b',0,-1,-1,109,0,0,1547100,268,'true','true','true','true','true','0-0','0-0;'),
(385,'Gaiters of Victory','','legs','true','heavy',2240,'oriharukon','b',0,-1,-1,109,0,0,1547100,268,'true','true','true','true','true','0-0','0-0;'),
(386,'Gaiters of Valor','','legs','true','heavy',2240,'blood_steel','b',0,-1,-1,116,0,0,2226000,385,'true','true','true','true','true','0-0','0-0;'),
(387,'Elven Crystal Gaiters','','legs','true','heavy',2240,'crystal','b',0,-1,-1,109,0,0,1547100,268,'true','true','true','true','true','0-0','0-0;'),
(388,'Dark Crystal Gaiters','','legs','true','heavy',3320,'crystal','a',0,-1,-1,107,0,0,2226000,178,'true','true','true','true','true','0-0','0-0;'),
(389,'Dragon Scale Gaiters','','legs','true','heavy',3260,'scale_of_dragon','s',0,-1,-1,122,0,0,4640000,299,'false','false','true','false','true','0-0','0-0;'),
(390,'Cotton Shirt','','chest','false','light',4770,'cloth','none',0,-1,-1,50,0,0,15600,0,'true','true','true','true','true','0-0','0-0;'),
(391,'Puma Skin Shirt','','chest','true','light',4700,'leather','d',0,-1,-1,58,0,0,48200,89,'true','true','true','true','true','0-0','0-0;'),
(392,'Lion Skin Shirt','','chest','true','light',4580,'leather','d',0,-1,-1,65,0,0,76900,142,'true','true','true','true','true','0-0','0-0;'),
(393,'Mithril Banded Mail','','chest','true','light',4570,'mithril','d',0,-1,-1,73,0,0,117000,216,'true','true','true','true','true','0-0','0-0;'),
(394,'Reinforced Leather Shirt','','chest','true','light',4570,'leather','d',0,-1,-1,73,0,0,117000,216,'true','true','true','true','true','0-0','0-0;'),
(395,'Manticore Skin Shirt','','chest','true','light',4520,'leather','d',0,-1,-1,77,0,0,172000,318,'true','true','true','true','true','0-0','0-0;'),
(396,'Salamander Skin Mail','','fullarmor','true','light',6100,'leather','d',0,-1,-1,136,0,0,366600,677,'true','true','true','true','true','0-0','0-0;'),
(397,'Mithril Shirt','','chest','true','light',4470,'mithril','c',0,-1,-1,90,0,0,291000,116,'true','true','true','true','true','0-0','0-0;'),
(398,'Plated Leather','','chest','true','light',4450,'leather','c',0,-1,-1,94,0,0,343000,137,'true','true','true','true','true','0-0','0-0;'),
(399,'Rind Leather Armor','','chest','true','light',4420,'leather','c',0,-1,-1,97,0,0,372000,149,'true','true','true','true','true','0-0','0-0;'),
(400,'Theca Leather Armor','','chest','true','light',4370,'leather','c',0,-1,-1,106,0,0,635000,254,'true','true','true','true','true','0-0','0-0;'),
(401,'Drake Leather Armor','','fullarmor','true','light',5800,'leather','c',0,-1,-1,179,0,0,1341000,536,'true','true','true','true','true','0-0','0-0;'),
(402,'Chain Mail of Silence','','fullarmor','true','light',3200,'damascus','b',0,-1,-1,213,0,0,3017000,470,'true','true','true','true','true','0-0','0-0;'),
(403,'Gust Chain Mail','','fullarmor','true','light',2720,'blood_steel','b',0,-1,-1,225,0,0,4341000,677,'true','true','true','true','true','0-0','0-0;'),
(404,'Prairie Leather Armor','','chest','true','light',8000,'leather','b',0,-1,-1,131,0,0,1857000,321,'true','true','true','true','true','0-0','0-0;'),
(405,'Leather Armor of the Underworld','','chest','true','light',8000,'leather','b',0,-1,-1,139,0,0,2671000,462,'true','true','true','true','true','0-0','0-0;'),
(406,'Leather Suit of Concentration','','fullarmor','true','light',2400,'leather','b',0,-1,-1,213,0,0,3017000,470,'true','true','true','true','true','0-0','0-0;'),
(407,'Ace\'s Leather Armor','','fullarmor','true','light',2400,'leather','b',0,-1,-1,225,0,0,4341000,677,'true','true','true','true','true','0-0','0-0;'),
(408,'Guardian\'s Leather Armor','','chest','true','light',8000,'leather','b',0,-1,-1,131,0,0,1857000,321,'true','true','true','true','true','0-0','0-0;'),
(409,'Marksman\'s Leather Armor','','chest','true','light',4300,'leather','b',0,-1,-1,139,0,0,2671000,462,'true','true','true','true','true','0-0','0-0;'),
(410,'Unicorn Leather Armor','','fullarmor','true','light',1280,'leather','a',0,-1,-1,238,0,0,6603000,618,'true','true','true','true','true','0-0','0-0;'),
(411,'Dragon Leather Armor','','fullarmor','true','light',4950,'leather','s',0,-1,-1,237,0,0,9047000,525,'false','false','true','false','true','0-0','0-0;'),
(412,'Cotton Pants','','legs','false','light',1630,'cloth','none',0,-1,-1,32,0,0,9770,0,'true','true','true','true','true','0-0','0-0;'),
(413,'Puma Skin Gaiters','','legs','true','light',1600,'leather','d',0,-1,-1,36,0,0,30100,56,'true','true','true','true','true','0-0','0-0;'),
(414,'Lion Skin Gaiters','','legs','true','light',1570,'leather','d',0,-1,-1,41,0,0,48000,89,'true','true','true','true','true','0-0','0-0;'),
(415,'Mithril Banded Gaiters','','legs','true','light',1580,'mithril','d',0,-1,-1,46,0,0,73200,135,'true','true','true','true','true','0-0','0-0;'),
(416,'Reinforced Leather Gaiters','','legs','true','light',1570,'leather','d',0,-1,-1,46,0,0,73200,135,'true','true','true','true','true','0-0','0-0;'),
(417,'Manticore Skin Gaiters','','legs','true','light',1550,'leather','d',0,-1,-1,48,0,0,107700,199,'true','true','true','true','true','0-0','0-0;'),
(418,'Plated Leather Gaiters','','legs','true','light',1560,'leather','c',0,-1,-1,59,0,0,214500,86,'true','true','true','true','true','0-0','0-0;'),
(419,'Rind Leather Gaiters','','legs','true','light',1550,'leather','c',0,-1,-1,60,0,0,232300,93,'true','true','true','true','true','0-0','0-0;'),
(420,'Theca Leather Gaiters','','legs','true','light',1530,'leather','c',0,-1,-1,66,0,0,396700,159,'true','true','true','true','true','0-0','0-0;'),
(421,'Prairie Leather Gaiters','','legs','true','light',4800,'leather','b',0,-1,-1,82,0,0,1160300,201,'true','true','true','true','true','0-0','0-0;'),
(422,'Gaiters of the Underworld','','legs','true','light',4800,'leather','b',0,-1,-1,87,0,0,1670000,289,'true','true','true','true','true','0-0','0-0;'),
(423,'Guardian\'s Leather Gaiters','','legs','true','light',4800,'leather','b',0,-1,-1,82,0,0,1160300,201,'true','true','true','true','true','0-0','0-0;'),
(424,'Marksman\'s Leather Gaiters','','legs','true','light',1490,'leather','b',0,-1,-1,87,0,0,1670000,289,'true','true','true','true','true','0-0','0-0;'),
(425,'Apprentice\'s Tunic','','chest','false','magic',2150,'cloth','none',0,-1,-1,17,0,19,20,0,'false','false','true','false','true','0-0','0-0;'),
(426,'Tunic','','chest','false','magic',2150,'cloth','none',0,-1,-1,18,0,24,113,0,'true','true','true','true','true','0-0','0-0;'),
(427,'Cotton Robe','','fullarmor','false','magic',2750,'cotton','none',0,-1,-1,35,0,61,3040,0,'true','true','true','true','true','0-0','0-0;'),
(428,'Feriotic Tunic','','chest','false','magic',2140,'cloth','none',0,-1,-1,21,0,38,1870,0,'true','true','true','true','true','0-0','0-0;'),
(429,'Leather Tunic','','chest','false','magic',2110,'leather','none',0,-1,-1,25,0,52,6120,0,'true','true','true','true','true','0-0','0-0;'),
(430,'Robe of Devotion','','fullarmor','false','magic',2650,'cloth','none',0,-1,-1,49,0,109,25400,0,'true','true','true','true','true','0-0','0-0;'),
(431,'Robe of Magic','','fullarmor','false','magic',2600,'cloth','none',0,-1,-1,56,0,140,46090,0,'true','true','true','true','true','0-0','0-0;'),
(432,'Cursed Tunic','','chest','true','magic',2090,'cloth','d',0,-1,-1,39,0,106,48200,89,'true','true','true','true','true','0-0','0-0;'),
(433,'Elven Tunic','','chest','true','magic',2080,'cloth','d',0,-1,-1,43,0,126,76900,142,'true','true','true','true','true','0-0','0-0;'),
(434,'White Tunic','','chest','true','magic',2040,'cloth','d',0,-1,-1,43,0,126,76900,142,'true','true','true','true','true','0-0','0-0;'),
(435,'Mystic\'s Tunic','','chest','true','magic',2030,'cloth','d',0,-1,-1,43,0,126,76900,142,'true','true','true','true','true','0-0','0-0;'),
(436,'Tunic of Knowledge','','chest','true','magic',2020,'cloth','d',0,-1,-1,49,0,147,117000,216,'true','true','true','true','true','0-0','0-0;'),
(437,'Mithril Tunic','','chest','true','magic',2010,'mithril','d',0,-1,-1,52,0,169,172000,318,'true','true','true','true','true','0-0','0-0;'),
(438,'Sage\'s Rag','','fullarmor','true','magic',2580,'cloth','d',0,-1,-1,90,0,320,366600,677,'true','true','true','true','true','0-0','0-0;'),
(439,'Karmian Tunic','','chest','true','magic',1980,'cloth','c',0,-1,-1,60,0,225,291000,116,'true','true','true','true','true','0-0','0-0;'),
(440,'Robe of Seal','','fullarmor','true','magic',2500,'cloth','c',0,-1,-1,105,0,413,603900,242,'true','true','true','true','true','0-0','0-0;'),
(441,'Demon\'s Tunic','','chest','true','magic',1990,'cloth','c',0,-1,-1,69,0,284,566000,226,'true','true','true','true','true','0-0','0-0;'),
(442,'Divine Tunic','','chest','true','magic',1980,'cloth','c',0,-1,-1,74,0,314,825000,330,'true','true','true','true','true','0-0','0-0;'),
(443,'Tunic of Mana','','chest','true','magic',2000,'cloth','b',0,-1,-1,87,0,377,1857000,321,'true','true','true','true','true','0-0','0-0;'),
(444,'Sage\'s Robe','','fullarmor','true','magic',1600,'cloth','b',0,-1,-1,150,0,665,4341000,677,'true','true','true','true','true','0-0','0-0;'),
(445,'Paradia Tunic','','chest','true','magic',1990,'cloth','b',0,-1,-1,87,0,377,1857000,321,'true','true','true','true','true','0-0','0-0;'),
(446,'Inferno Tunic','','chest','true','magic',1880,'cloth','b',0,-1,-1,92,0,409,2671000,462,'true','true','true','true','true','0-0','0-0;'),
(447,'Tunic of Solar Eclipse','','chest','true','magic',1960,'cloth','b',0,-1,-1,87,0,377,1857000,321,'true','true','true','true','true','0-0','0-0;'),
(448,'Robe of Black Ore','','fullarmor','true','magic',1600,'cloth','b',0,-1,-1,150,0,665,4341000,677,'true','true','true','true','true','0-0','0-0;'),
(449,'Tunic of Summoning','','chest','true','magic',1950,'cloth','b',0,-1,-1,87,0,377,1857000,321,'true','true','true','true','true','0-0','0-0;'),
(450,'Otherworldly Robe','','fullarmor','true','magic',1600,'cloth','b',0,-1,-1,150,0,665,4341000,677,'true','true','true','true','true','0-0','0-0;'),
(451,'Elemental Tunic','','chest','true','magic',1970,'cloth','b',0,-1,-1,87,0,377,1857000,321,'true','true','true','true','true','0-0','0-0;'),
(452,'Tunic of Phantom','','chest','true','magic',1890,'cloth','b',0,-1,-1,92,0,409,2671000,462,'true','true','true','true','true','0-0','0-0;'),
(453,'Tunic of Grace','','chest','true','magic',1930,'cloth','b',0,-1,-1,87,0,377,1857000,321,'true','true','true','true','true','0-0','0-0;'),
(454,'Robe of Holy Spirit','','fullarmor','true','magic',1600,'cloth','b',0,-1,-1,150,0,665,4341000,677,'true','true','true','true','true','0-0','0-0;'),
(455,'Phoenix Tunic','','chest','true','magic',1950,'cloth','b',0,-1,-1,87,0,377,1857000,321,'true','true','true','true','true','0-0','0-0;'),
(456,'Cerberus Tunic','','chest','true','magic',1870,'cloth','b',0,-1,-1,92,0,409,2671000,462,'true','true','true','true','true','0-0','0-0;'),
(457,'Tunic of Aid','','chest','true','magic',1910,'cloth','b',0,-1,-1,87,0,377,1857000,321,'true','true','true','true','true','0-0','0-0;'),
(458,'Robe of Blessing','','fullarmor','true','magic',1600,'cloth','b',0,-1,-1,150,0,665,4341000,677,'true','true','true','true','true','0-0','0-0;'),
(459,'Dasparion\'s Robe','','fullarmor','true','magic',1200,'cloth','a',0,-1,-1,158,0,718,6603000,618,'true','true','true','true','true','0-0','0-0;'),
(460,'The Robe','','fullarmor','true','magic',2300,'cloth','s',0,-1,-1,158,0,773,9047000,525,'false','false','true','false','true','0-0','0-0;'),
(461,'Apprentice\'s Stockings','','legs','false','magic',1100,'cloth','none',0,-1,-1,10,0,10,4,0,'false','false','true','false','true','0-0','0-0;'),
(462,'Stockings','','legs','false','magic',1080,'cloth','none',0,-1,-1,11,0,15,71,0,'true','true','true','true','true','0-0','0-0;'),
(463,'Feriotic Stockings','','legs','false','magic',1070,'cloth','none',0,-1,-1,13,0,23,1170,0,'true','true','true','true','true','0-0','0-0;'),
(464,'Leather Stockings','','legs','false','magic',1020,'leather','none',0,-1,-1,16,0,33,3820,0,'true','true','true','true','true','0-0','0-0;'),
(465,'Cursed Stockings','','legs','true','magic',1020,'cloth','d',0,-1,-1,24,0,66,30100,56,'true','true','true','true','true','0-0','0-0;'),
(466,'Elven Stockings','','legs','true','magic',1010,'cloth','d',0,-1,-1,27,0,79,48000,89,'true','true','true','true','true','0-0','0-0;'),
(467,'Dark Stockings','','legs','true','magic',1000,'cloth','d',0,-1,-1,27,0,79,48000,89,'true','true','true','true','true','0-0','0-0;'),
(468,'Mystic\'s Stockings','','legs','true','magic',990,'cloth','d',0,-1,-1,27,0,79,48000,89,'true','true','true','true','true','0-0','0-0;'),
(469,'Stockings of Knowledge','','legs','true','magic',1000,'cloth','d',0,-1,-1,30,0,92,73200,135,'true','true','true','true','true','0-0','0-0;'),
(470,'Mithril Stockings','','legs','true','magic',980,'mithril','d',0,-1,-1,32,0,105,107700,199,'true','true','true','true','true','0-0','0-0;'),
(471,'Karmian Stockings','','legs','true','magic',970,'cloth','c',0,-1,-1,37,0,141,182100,73,'true','true','true','true','true','0-0','0-0;'),
(472,'Demon\'s Stockings','','legs','true','magic',980,'cloth','c',0,-1,-1,43,0,177,354000,142,'true','true','true','true','true','0-0','0-0;'),
(473,'Divine Stockings','','legs','true','magic',960,'cloth','c',0,-1,-1,46,0,196,515800,206,'true','true','true','true','true','0-0','0-0;'),
(474,'Stockings of Mana','','legs','true','magic',2400,'cloth','b',0,-1,-1,55,0,236,1160300,201,'true','true','true','true','true','0-0','0-0;'),
(475,'Paradia Stockings','','legs','true','magic',1600,'cloth','b',0,-1,-1,55,0,236,1160300,201,'true','true','true','true','true','0-0','0-0;'),
(476,'Inferno Stockings','','legs','true','magic',1600,'cloth','b',0,-1,-1,58,0,256,1670000,289,'true','true','true','true','true','0-0','0-0;'),
(477,'Stockings of Solar Eclipse','','legs','true','magic',2400,'cloth','b',0,-1,-1,55,0,236,1160300,201,'true','true','true','true','true','0-0','0-0;'),
(478,'Stockings of Summoning','','legs','true','magic',2400,'cloth','b',0,-1,-1,55,0,236,1160300,201,'true','true','true','true','true','0-0','0-0;'),
(479,'Elemental Stockings','','legs','true','magic',1600,'cloth','b',0,-1,-1,55,0,236,1160300,201,'true','true','true','true','true','0-0','0-0;'),
(480,'Stockings of Phantom','','legs','true','magic',1600,'cloth','b',0,-1,-1,58,0,256,1670000,289,'true','true','true','true','true','0-0','0-0;'),
(481,'Stockings of Grace','','legs','true','magic',2400,'cloth','b',0,-1,-1,55,0,236,1160300,201,'true','true','true','true','true','0-0','0-0;'),
(482,'Phoenix Stockings','','legs','true','magic',2400,'cloth','b',0,-1,-1,55,0,236,1160300,201,'true','true','true','true','true','0-0','0-0;'),
(483,'Cerberus Stockings','','legs','true','magic',6400,'cloth','b',0,-1,-1,58,0,256,1670000,289,'true','true','true','true','true','0-0','0-0;'),
(484,'Stockings of Aid','','legs','true','magic',2400,'cloth','b',0,-1,-1,55,0,236,1160300,201,'true','true','true','true','true','0-0','0-0;'),
(485,'Tattoo of Power','','underwear','false','light',4200,'dyestuff','none',0,-1,-1,53,0,0,28400,0,'true','true','true','true','true','0-0','0-0;'),
(486,'Tattoo of Fire','','underwear','true','light',4050,'dyestuff','d',0,-1,-1,73,0,0,117000,276,'true','true','true','true','true','0-0','0-0;'),
(487,'Tattoo of Resolve','','underwear','true','light',4000,'dyestuff','d',0,-1,-1,73,0,0,117000,276,'true','true','true','true','true','0-0','0-0;'),
(488,'Tattoo of Flame','','underwear','true','light',800,'dyestuff','b',0,-1,-1,139,0,0,2671000,462,'true','true','true','true','true','0-0','0-0;'),
(489,'Tattoo of Bravery','','underwear','true','light',4100,'dyestuff','c',0,-1,-1,110,0,0,825000,428,'true','true','true','true','true','0-0','0-0;'),
(490,'Tattoo of Blood','','underwear','true','light',3800,'dyestuff','a',0,-1,-1,132,0,0,2671000,277,'true','true','true','true','true','0-0','0-0;'),
(491,'Tattoo of Absolute','','underwear','true','light',800,'dyestuff','a',0,-1,-1,146,0,0,4064000,422,'true','true','true','true','true','0-0','0-0;'),
(492,'Tattoo of Soul','','underwear','true','light',4150,'dyestuff','d',0,-1,-1,65,0,0,76900,181,'true','true','true','true','true','0-0','0-0;'),
(493,'Tattoo of Avadon','','underwear','true','light',4000,'dyestuff','b',0,-1,-1,117,0,0,1197000,208,'true','true','true','true','true','0-0','0-0;'),
(494,'Tattoo of Doom','','underwear','true','light',4100,'dyestuff','b',0,-1,-1,125,0,0,1857000,321,'true','true','true','true','true','0-0','0-0;'),
(495,'Tattoo of Pledge','','underwear','true','light',4000,'dyestuff','b',0,-1,-1,124,0,0,1197000,208,'true','true','true','true','true','0-0','0-0;'),
(496,'Tattoo of Divine','','underwear','true','light',4100,'dyestuff','b',0,-1,-1,131,0,0,1857000,321,'true','true','true','true','true','0-0','0-0;'),
(497,'Chain Helmet','','head','true','none',620,'fine_steel','c',0,-1,-1,45,0,0,112800,59,'true','true','true','true','true','0-0','0-0;'),
(498,'Steel Plate Helmet','','head','true','none',610,'fine_steel','c',0,-1,-1,49,0,0,158200,82,'true','true','true','true','true','0-0','0-0;'),
(499,'Mithril Helmet','','head','true','none',240,'mithril','c',0,-1,-1,58,0,0,412600,214,'true','true','true','true','true','0-0','0-0;'),
(500,'Great Helmet','','head','true','none',610,'fine_steel','c',0,-1,-1,51,0,0,185800,74,'true','true','true','true','true','0-0','0-0;'),
(501,'Armet','','head','true','none',580,'chrysolite','b',0,-1,-1,62,0,0,795800,4,'true','true','true','true','true','0-0','0-0;'),
(502,'Close Helmet','','head','true','none',570,'oriharukon','a',0,-1,-1,64,0,0,1198000,3,'true','true','true','true','true','0-0','0-0;'),
(503,'Zubei\'s Helmet','','head','true','none',590,'mithril','b',0,-1,-1,62,0,0,598600,80,'true','true','true','true','true','0-0','0-0;'),
(504,'Dragon Helmet','','head','true','none',550,'bone','s',0,-1,-1,77,0,0,2784000,179,'false','false','true','false','true','0-0','0-0;'),
(505,'Wolf Helmet','','head','true','none',580,'oriharukon','b',0,-1,-1,66,0,0,928300,161,'true','true','true','true','true','0-0','0-0;'),
(506,'Shining Dragon Helmet','','head','true','none',880,'mithril','b',0,-1,-1,67,0,0,1336000,232,'true','true','true','true','true','0-0','0-0;'),
(507,'Helmet of Victory','','head','true','none',640,'oriharukon','b',0,-1,-1,66,0,0,928300,161,'true','true','true','true','true','0-0','0-0;'),
(508,'Helmet of Valor','','head','true','none',720,'blood_steel','b',0,-1,-1,67,0,0,1336000,232,'true','true','true','true','true','0-0','0-0;'),
(509,'Glorious Helmet','','head','true','none',800,'fine_steel','a',0,-1,-1,65,0,0,1566000,3,'true','true','true','true','true','0-0','0-0;'),
(510,'Red Flame Helmet','','head','true','none',960,'blood_steel','a',0,-1,-1,71,0,0,2032000,3,'true','true','true','true','true','0-0','0-0;'),
(511,'Elven Crystal Helmet','','head','true','none',580,'crystal','b',0,-1,-1,66,0,0,928300,161,'true','true','true','true','true','0-0','0-0;'),
(512,'Dark Crystal Helmet','','head','true','none',570,'crystal','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','0-0;'),
(513,'Implosion Helmet','','head','true','none',480,'damascus','b',0,-1,-1,66,0,0,928300,161,'true','true','true','true','true','0-0','0-0;'),
(514,'Dark Dragon Helmet','','head','true','none',400,'damascus','b',0,-1,-1,67,0,0,1336000,232,'true','true','true','true','true','0-0','0-0;'),
(515,'Elven Vagian Helm','','head','true','none',560,'mithril','a',0,-1,-1,65,0,0,1566000,3,'true','true','true','true','true','0-0','0-0;'),
(516,'Dark Vagian Helm','','head','true','none',560,'mithril','a',0,-1,-1,71,0,0,2032000,3,'true','true','true','true','true','0-0','0-0;'),
(517,'Composite Helmet','','head','true','none',610,'fine_steel','c',0,-1,-1,54,0,0,283200,113,'true','true','true','true','true','0-0','0-0;'),
(518,'Hell Helm','','head','true','none',320,'blood_steel','a',0,-1,-1,71,0,0,2032000,3,'true','true','true','true','true','0-0','0-0;'),
(519,'Art of Helmet','','head','true','none',400,'chrysolite','b',0,-1,-1,66,0,0,928300,161,'true','true','true','true','true','0-0','0-0;'),
(520,'Masterpiece Helm','','head','true','none',400,'oriharukon','a',0,-1,-1,71,0,0,2032000,3,'true','true','true','true','true','0-0','0-0;'),
(521,'Helmet of Silence','','head','true','none',320,'damascus','b',0,-1,-1,66,0,0,928300,161,'true','true','true','true','true','0-0','0-0;'),
(522,'Gust Helmet','','head','true','none',570,'blood_steel','b',0,-1,-1,67,0,0,1336000,232,'true','true','true','true','true','0-0','0-0;'),
(523,'Prairie Helmet','','head','true','none',480,'leather','b',0,-1,-1,66,0,0,928300,161,'true','true','true','true','true','0-0','0-0;'),
(524,'Helm of the Underworld','','head','true','none',320,'damascus','b',0,-1,-1,67,0,0,1336000,232,'true','true','true','true','true','0-0','0-0;'),
(525,'Helmet of Concentration','','head','true','none',320,'oriharukon','b',0,-1,-1,66,0,0,928300,161,'true','true','true','true','true','0-0','0-0;'),
(526,'Ace\'s Helmet','','head','true','none',320,'oriharukon','b',0,-1,-1,67,0,0,1336000,232,'true','true','true','true','true','0-0','0-0;'),
(527,'Guardian\'s Helmet','','head','true','none',240,'mithril','b',0,-1,-1,66,0,0,928300,161,'true','true','true','true','true','0-0','0-0;'),
(528,'Marksman Helmet','','head','true','none',240,'leather','b',0,-1,-1,67,0,0,1336000,232,'true','true','true','true','true','0-0','0-0;'),
(529,'Cap of Mana','','head','true','none',320,'cloth','c',0,-1,-1,58,0,0,412600,214,'true','true','true','true','true','0-0','0-0;'),
(530,'Sage\'s Cap','','head','true','none',320,'cloth','b',0,-1,-1,62,0,0,598600,103,'true','true','true','true','true','0-0','0-0;'),
(531,'Paradia Hood','','head','true','none',320,'cloth','c',0,-1,-1,58,0,0,412600,214,'true','true','true','true','true','0-0','0-0;'),
(532,'Inferno Hood','','head','true','none',320,'cloth','b',0,-1,-1,62,0,0,598600,103,'true','true','true','true','true','0-0','0-0;'),
(533,'Hood of Solar Eclipse','','head','true','none',320,'cloth','c',0,-1,-1,58,0,0,412600,214,'true','true','true','true','true','0-0','0-0;'),
(534,'Hood of Black Ore','','head','true','none',320,'cloth','b',0,-1,-1,62,0,0,598600,103,'true','true','true','true','true','0-0','0-0;'),
(535,'Hood of Summoning','','head','true','none',320,'cloth','c',0,-1,-1,58,0,0,412600,214,'true','true','true','true','true','0-0','0-0;'),
(536,'Otherworldly Hood','','head','true','none',320,'cloth','b',0,-1,-1,62,0,0,598600,103,'true','true','true','true','true','0-0','0-0;'),
(537,'Elemental Hood','','head','true','none',320,'cloth','c',0,-1,-1,58,0,0,412600,214,'true','true','true','true','true','0-0','0-0;'),
(538,'Hood of Phantom','','head','true','none',320,'cloth','b',0,-1,-1,62,0,0,598600,103,'true','true','true','true','true','0-0','0-0;'),
(539,'Hood of Grace','','head','true','none',320,'cloth','c',0,-1,-1,58,0,0,412600,214,'true','true','true','true','true','0-0','0-0;'),
(540,'Hood of Holy Spirit','','head','true','none',320,'cloth','b',0,-1,-1,62,0,0,598600,103,'true','true','true','true','true','0-0','0-0;'),
(541,'Phoenix Hood','','head','true','none',590,'cloth','c',0,-1,-1,58,0,0,412600,214,'true','true','true','true','true','0-0','0-0;'),
(542,'Cerberus Hood','','head','true','none',320,'cloth','b',0,-1,-1,62,0,0,598600,103,'true','true','true','true','true','0-0','0-0;'),
(543,'Hood of Aid','','head','true','none',320,'cloth','c',0,-1,-1,58,0,0,412600,214,'true','true','true','true','true','0-0','0-0;'),
(544,'Hood of Blessing','','head','true','none',320,'cloth','b',0,-1,-1,62,0,0,598600,103,'true','true','true','true','true','0-0','0-0;'),
(545,'Flame Helm','','head','true','none',400,'cloth','c',0,-1,-1,58,0,0,412600,214,'true','true','true','true','true','0-0','0-0;'),
(546,'Helm of Bravery','','head','true','none',400,'cloth','b',0,-1,-1,62,0,0,598600,103,'true','true','true','true','true','0-0','0-0;'),
(547,'Tallum Helm','','head','true','none',570,'cloth','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','0-0;'),
(548,'Absolute Helm','','head','true','none',400,'cloth','b',0,-1,-1,62,0,0,598600,103,'true','true','true','true','true','0-0','0-0;'),
(549,'Helm of Avadon','','head','true','none',400,'cloth','c',0,-1,-1,58,0,0,412600,214,'true','true','true','true','true','0-0','0-0;'),
(550,'Helm of Doom','','head','true','none',400,'cloth','b',0,-1,-1,62,0,0,598600,103,'true','true','true','true','true','0-0','0-0;'),
(551,'Helmet of Pledge','','head','true','none',400,'chrysolite','c',0,-1,-1,58,0,0,412600,214,'true','true','true','true','true','0-0','0-0;'),
(552,'Divine Helm','','head','true','none',400,'cloth','b',0,-1,-1,62,0,0,598600,103,'true','true','true','true','true','0-0','0-0;'),
(553,'Iron Boots','','feet','true','none',1280,'fine_steel','d',0,-1,-1,24,0,0,39100,71,'true','true','true','true','true','0-0','0-0;'),
(554,'Zubei\'s Boots','','feet','true','none',1180,'mithril','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','0-0;'),
(555,'Dragon Boots','','feet','true','none',1110,'leather','a',0,-1,-1,48,0,0,1355000,140,'false','false','true','false','true','0-0','0-0;'),
(556,'Wolf Boots','','feet','true','none',1180,'oriharukon','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(557,'Shining Dragon Boots','','feet','true','none',1150,'mithril','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(558,'Boots of Victory','','feet','true','none',1180,'oriharukon','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(559,'Boots of Valor','','feet','true','none',1150,'blood_steel','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(560,'Glorious Boots','','feet','true','none',1180,'fine_steel','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(561,'Red Flame Boots','','feet','true','none',1120,'blood_steel','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(562,'Elven Crystal Boots','','feet','true','none',1180,'crystal','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(563,'Dark Crystal Boots','','feet','true','none',1110,'crystal','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(564,'Implosion Boots','','feet','true','none',1150,'damascus','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(565,'Dark Dragon Boots','','feet','true','none',1130,'damascus','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(566,'Elven Vagian Boots','','feet','true','none',1150,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(567,'Dark Vagian Boots','','feet','true','none',1130,'mithril','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(568,'Composite Boots','','feet','true','none',200,'fine_steel','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(569,'Hell Boots','','feet','true','none',1130,'blood_steel','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(570,'Art of Boots','','feet','true','none',1150,'chrysolite','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(571,'Masterpiece Boots','','feet','true','none',1130,'oriharukon','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(572,'Boots of Silence','','feet','true','none',1190,'damascus','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(573,'Gust Boots','','feet','true','none',1120,'blood_steel','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(574,'Prairie Boots','','feet','true','none',1140,'leather','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(575,'Boots of the Underworld','','feet','true','none',1110,'leather','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(576,'Boots of Concentration','','feet','true','none',1170,'oriharukon','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(577,'Ace\'s Boots','','feet','true','none',1150,'oriharukon','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(578,'Guardian\'s Boots','','feet','true','none',1180,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(579,'Marksman Boots','','feet','true','none',1150,'leather','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(580,'Boots of Mana','','feet','true','none',1180,'leather','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(581,'Sage\'s Boots','','feet','true','none',1150,'leather','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(582,'Paradia Boots','','feet','true','none',1140,'chrysolite','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(583,'Majestic Boots','','feet','true','none',1110,'blood_steel','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(584,'Boots of Solar Eclipse','','feet','true','none',1180,'blood_steel','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(585,'Boots of Black Ore','','feet','true','none',1200,'damascus','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(586,'Boots of Summoning','','feet','true','none',1170,'leather','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(587,'Otherworldly Boots','','feet','true','none',1200,'adamantaite','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(588,'Elemental Boots','','feet','true','none',1130,'mithril','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(589,'Boots of Phantom','','feet','true','none',1120,'oriharukon','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(590,'Boots of Grace','','feet','true','none',1130,'mithril','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(591,'Boots of Holy Spirit','','feet','true','none',1200,'chrysolite','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(592,'Phoenix Boots','','feet','true','none',1120,'blood_steel','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(593,'Cerberus Boots','','feet','true','none',1120,'damascus','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(594,'Boots of Aid','','feet','true','none',1200,'leather','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(595,'Boots of Blessing','','feet','true','none',1160,'adamantaite','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(596,'Flame Boots','','feet','true','none',1020,'blood_steel','b',0,-1,-1,45,0,0,890000,154,'true','true','true','true','true','0-0','0-0;'),
(597,'Boots of Bravery','','feet','true','none',1050,'chrysolite','b',0,-1,-1,45,0,0,890000,154,'true','true','true','true','true','0-0','0-0;'),
(598,'Blood Boots','','feet','true','none',1130,'blood_steel','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(599,'Absolute Boots','','feet','true','none',1130,'mithril','b',0,-1,-1,45,0,0,890000,154,'true','true','true','true','true','0-0','0-0;'),
(600,'Avadon Boots','','feet','true','none',1170,'damascus','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','0-0;'),
(601,'Boots of Doom','','feet','true','none',1130,'mithril','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(602,'Boots of Pledge','','feet','true','none',1130,'chrysolite','b',0,-1,-1,45,0,0,890000,154,'true','true','true','true','true','0-0','0-0;'),
(603,'Divine Boots','','feet','true','none',1200,'adamantaite','c',0,-1,-1,39,0,0,275100,143,'true','true','true','true','true','0-0','0-0;'),
(604,'Crafted Leather Gloves','','gloves','true','none',650,'leather','d',0,-1,-1,19,0,0,16100,30,'true','true','true','true','true','0-0','0-0;'),
(605,'Leather Gauntlets','','gloves','true','none',640,'leather','d',0,-1,-1,22,0,0,25600,47,'true','true','true','true','true','0-0','0-0;'),
(606,'Rip Gauntlets','','gloves','true','none',630,'leather','d',0,-1,-1,27,0,0,57400,106,'true','true','true','true','true','0-0','0-0;'),
(607,'Ogre Power Gauntlets','','gloves','true','none',620,'fine_steel','d',0,-1,-1,29,0,0,75200,139,'true','true','true','true','true','0-0','0-0;'),
(608,'Mithril Gauntlets','','gloves','true','none',600,'mithril','c',0,-1,-1,36,0,0,188800,76,'true','true','true','true','true','0-0','0-0;'),
(609,'Gauntlets of Ghost','','gloves','true','none',1920,'blood_steel','c',0,-1,-1,39,0,0,275100,143,'true','true','true','true','true','0-0','0-0;'),
(610,'Saint Knight\'s Gauntlets','','gloves','true','none',6400,'oriharukon','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(611,'Soul Leech Gauntlets','','gloves','true','none',4800,'blood_steel','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(612,'Zubei\'s Gauntlets','','gloves','true','none',590,'mithril','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','0-0;'),
(613,'Sand Dragon Gloves','','gloves','true','none',3200,'damascus','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(614,'Knight\'s Cloak','','back','true','none',240,'cloth','d',0,-1,-1,7,0,0,20900,38,'true','true','true','true','true','0-0','0-0;'),
(615,'Cobweb Cloak','','back','true','none',240,'cobweb','d',0,-1,-1,8,0,0,33300,60,'true','true','true','true','true','0-0','0-0;'),
(616,'Cloak of Magic','','back','true','none',240,'cloth','d',0,-1,-1,11,0,0,74700,135,'true','true','true','true','true','0-0','0-0;'),
(617,'Mithril Cloak','','back','true','none',240,'mithril','d',0,-1,-1,11,0,0,97800,177,'true','true','true','true','true','0-0','0-0;'),
(618,'Cloak of Self Protection','','back','true','none',240,'cloth','c',0,-1,-1,13,0,0,161000,64,'true','true','true','true','true','0-0','0-0;'),
(619,'(Not In Use) Ancient Cloak','','back','true','none',230,'cloth','c',0,-1,-1,15,0,0,245000,98,'true','true','true','true','true','0-0','0-0;'),
(620,'Cloak of Protection','','back','true','none',230,'cloth','c',0,-1,-1,16,0,0,358000,143,'true','true','true','true','true','0-0','0-0;'),
(621,'Cloak of Hell','','back','true','none',220,'cloth','b',0,-1,-1,18,0,0,804000,107,'true','true','true','true','true','0-0','0-0;'),
(622,'(Not In Use) Holy Spirit\'s Cloak','','back','true','none',220,'cloth','a',0,-1,-1,18,0,0,1160000,92,'true','true','true','true','true','0-0','0-0;'),
(623,'Divine Cloak','','back','true','none',220,'cloth','a',0,-1,-1,19,0,0,1760000,141,'true','true','true','true','true','0-0','0-0;'),
(624,'Cloak of Invisibility','','back','false','none',260,'cloth','none',0,-1,-1,2,0,0,37,0,'true','false','true','true','true','0-0','0-0;'),
(675,'Silk Yarn Undergarment Set','','underwear','false','none',170,'cloth','none',0,-1,-1,6,0,0,1330,0,'true','true','true','true','true','0-0','0-0;'),
(676,'Pure White Undergarment Set','','underwear','false','none',160,'cloth','none',0,-1,-1,9,0,0,6150,0,'true','true','true','true','true','0-0','0-0;'),
(677,'One-Piece Swimsuit','','underwear','true','none',150,'cloth','d',0,-1,-1,10,0,0,10400,18,'true','true','true','true','true','0-0','0-0;'),
(678,'Bikini Set','','underwear','true','none',150,'cloth','d',0,-1,-1,11,0,0,16700,30,'true','true','true','true','true','0-0','0-0;'),
(679,'Cursed Undergarment Set','','underwear','true','none',150,'cloth','d',0,-1,-1,12,0,0,25400,46,'true','true','true','true','true','0-0','0-0;'),
(680,'Mithril Undergarment Set','','underwear','true','none',140,'mithril','c',0,-1,-1,16,0,0,63100,25,'true','true','true','true','true','0-0','0-0;'),
(681,'Fascination Undergarment Set','','underwear','true','none',140,'cloth','c',0,-1,-1,17,0,0,80500,32,'true','true','true','true','true','0-0','0-0;'),
(682,'Demon\'s Undergarment Set','','underwear','true','none',140,'cloth','c',0,-1,-1,19,0,0,179000,71,'true','true','true','true','true','0-0','0-0;'),
(683,'Holy Undergarment Set','','underwear','true','none',140,'cloth','b',0,-1,-1,22,0,0,402000,53,'true','true','true','true','true','0-0','0-0;'),
(684,'Underwear of Rule','','underwear','true','none',140,'cloth','a',0,-1,-1,24,0,0,880000,70,'true','true','true','true','true','0-0','0-0;'),
(685,'Crystal Swimsuit Set','','underwear','true','none',130,'crystal','s',0,-1,-1,26,0,0,1310000,65,'true','true','true','true','true','0-0','0-0;'),
(845,'Cat\'s Eye Earring','','rear,lear','false','none',150,'silver','none',0,-1,-1,0,19,0,6840,0,'true','true','true','true','true','0-0','0-0;'),
(846,'Coral Earring','','rear,lear','false','none',150,'silver','none',0,-1,-1,0,21,0,12300,0,'true','true','true','true','true','0-0','0-0;'),
(847,'Red Crescent Earring','','rear,lear','true','none',150,'silver','d',0,-1,-1,0,24,0,20700,38,'true','true','true','true','true','0-0','0-0;'),
(848,'Enchanted Earring','','rear,lear','true','none',150,'silver','d',0,-1,-1,0,27,0,32800,61,'true','true','true','true','true','0-0','0-0;'),
(849,'Tiger\'s Eye Earring','','rear,lear','true','none',150,'silver','d',0,-1,-1,0,30,0,49400,91,'true','true','true','true','true','0-0','0-0;'),
(850,'Elven Earring','','rear,lear','true','none',150,'silver','d',0,-1,-1,0,34,0,71900,133,'true','true','true','true','true','0-0','0-0;'),
(851,'Omen Beast\'s Eye Earring','','rear,lear','true','none',150,'silver','d',0,-1,-1,0,36,0,93300,172,'true','true','true','true','true','0-0','0-0;'),
(852,'Moonstone Earring','','rear,lear','true','none',150,'silver','c',0,-1,-1,0,39,0,119300,48,'true','true','true','true','true','0-0','0-0;'),
(853,'Earring of Protection','','rear,lear','true','none',150,'silver','c',0,-1,-1,0,42,0,150500,60,'true','true','true','true','true','0-0','0-0;'),
(854,'Earring of Binding','','rear,lear','true','none',150,'silver','c',0,-1,-1,0,45,0,226600,91,'true','true','true','true','true','0-0','0-0;'),
(855,'Nassen\'s Earring','','rear,lear','true','none',150,'silver','c',0,-1,-1,0,48,0,325800,130,'true','true','true','true','true','0-0','0-0;'),
(856,'Adamantite Earring','','rear,lear','true','none',150,'silver','b',0,-1,-1,0,51,0,465900,62,'true','true','true','true','true','0-0','0-0;'),
(857,'Blessed Earring','','rear,lear','true','none',150,'silver','c',0,-1,-1,0,48,0,325800,170,'true','true','true','true','true','0-0','0-0;'),
(858,'Tateossian Earring','','rear,lear','true','none',150,'silver','s',0,-1,-1,0,71,31,3270000,157,'true','true','true','true','true','0-0','0-0;'),
(859,'Earring of Mana','','rear,lear','true','none',150,'silver','b',0,-1,-1,0,51,0,465900,80,'true','true','true','true','true','0-0','0-0;'),
(860,'Sage\'s Earring','','rear,lear','true','none',150,'silver','b',0,-1,-1,0,54,0,711000,123,'true','true','true','true','true','0-0','0-0;'),
(861,'Paradia Earring','','rear,lear','true','none',150,'silver','b',0,-1,-1,0,54,0,711000,123,'true','true','true','true','true','0-0','0-0;'),
(862,'Majestic Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,63,25,1498000,120,'true','true','true','true','true','0-0','0-0;'),
(863,'Earring of Solar Eclipse','','rear,lear','true','none',150,'silver','b',0,-1,-1,0,51,0,465900,80,'true','true','true','true','true','0-0','0-0;'),
(864,'Earring of Black Ore','','rear,lear','true','none',150,'silver','b',0,-1,-1,0,54,0,711000,95,'true','true','true','true','true','0-0','0-0;'),
(865,'Earring of Summoning','','rear,lear','true','none',150,'silver','b',0,-1,-1,0,51,0,465900,80,'true','true','true','true','true','0-0','0-0;'),
(866,'Otherworldly Earring','','rear,lear','true','none',150,'silver','b',0,-1,-1,0,54,0,711000,123,'true','true','true','true','true','0-0','0-0;'),
(867,'Elemental Earring','','rear,lear','true','none',150,'silver','b',0,-1,-1,0,54,0,711000,123,'true','true','true','true','true','0-0','0-0;'),
(868,'Earring of Phantom','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,60,0,1498000,156,'true','true','true','true','true','0-0','0-0;'),
(869,'Earring of Grace','','rear,lear','true','none',150,'silver','b',0,-1,-1,0,51,0,465900,80,'true','true','true','true','true','0-0','0-0;'),
(870,'Earring of Holy Spirit','','rear,lear','true','none',150,'silver','b',0,-1,-1,0,54,0,711000,123,'true','true','true','true','true','0-0','0-0;'),
(871,'Phoenix Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,60,20,1005000,80,'true','true','true','true','true','0-0','0-0;'),
(872,'Cerberus Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,60,0,1498000,156,'true','true','true','true','true','0-0','0-0;'),
(873,'Earring of Aid','','rear,lear','true','none',150,'silver','b',0,-1,-1,0,51,0,465900,80,'true','true','true','true','true','0-0','0-0;'),
(874,'Earring of Blessing','','rear,lear','true','none',150,'silver','b',0,-1,-1,0,51,0,465900,80,'true','true','true','true','true','0-0','0-0;'),
(875,'Ring of Knowledge','','rfinger,lfinger','false','none',150,'gold','none',0,-1,-1,0,9,0,420,0,'true','true','true','true','true','0-0','0-0;'),
(876,'Ring of Anguish','','rfinger,lfinger','false','none',150,'gold','none',0,-1,-1,0,11,0,1800,0,'true','true','true','true','true','0-0','0-0;'),
(877,'Ring of Wisdom','','rfinger,lfinger','false','none',150,'gold','none',0,-1,-1,0,12,0,4560,0,'true','true','true','true','true','0-0','0-0;'),
(878,'Blue Coral Ring','','rfinger,lfinger','false','none',150,'gold','none',0,-1,-1,0,14,0,8200,0,'true','true','true','true','true','0-0','0-0;'),
(879,'Enchanted Ring','','rfinger,lfinger','true','none',150,'gold','d',0,-1,-1,0,18,0,21800,40,'true','true','true','true','true','0-0','0-0;'),
(880,'Black Pearl Ring','','rfinger,lfinger','true','none',150,'gold','d',0,-1,-1,0,20,0,33000,61,'true','true','true','true','true','0-0','0-0;'),
(881,'Elven Ring','','rfinger,lfinger','true','none',150,'gold','d',0,-1,-1,0,22,0,47900,88,'true','true','true','true','true','0-0','0-0;'),
(882,'Mithril Ring','','rfinger,lfinger','true','none',150,'gold','d',0,-1,-1,0,24,0,62200,115,'true','true','true','true','true','0-0','0-0;'),
(883,'Aquastone Ring','','rfinger,lfinger','true','none',150,'gold','c',0,-1,-1,0,26,0,79500,32,'true','true','true','true','true','0-0','0-0;'),
(884,'Ring of Protection','','rfinger,lfinger','true','none',150,'gold','c',0,-1,-1,0,28,0,100300,40,'true','true','true','true','true','0-0','0-0;'),
(885,'Ring of Ages','','rfinger,lfinger','true','none',150,'gold','c',0,-1,-1,0,30,0,151100,60,'true','true','true','true','true','0-0','0-0;'),
(886,'Ring of Binding','','rfinger,lfinger','true','none',150,'gold','c',0,-1,-1,0,32,0,217200,87,'true','true','true','true','true','0-0','0-0;'),
(887,'Adamantite Ring','','rfinger,lfinger','true','none',150,'gold','b',0,-1,-1,0,34,0,310600,41,'true','true','true','true','true','0-0','0-0;'),
(888,'Blessed Ring','','rfinger,lfinger','true','none',150,'gold','c',0,-1,-1,0,32,0,217200,112,'true','true','true','true','true','0-0','0-0;'),
(889,'Tateossian Ring','','rfinger,lfinger','true','none',150,'gold','s',0,-1,-1,0,48,21,2180000,105,'true','true','true','true','true','0-0','0-0;'),
(890,'Ring of Devotion','','rfinger,lfinger','true','none',150,'gold','d',0,-1,-1,0,16,0,13800,25,'true','true','true','true','true','0-0','0-0;'),
(891,'Sage\'s Ring','','rfinger,lfinger','true','none',150,'gold','b',0,-1,-1,0,36,0,474000,82,'true','true','true','true','true','0-0','0-0;'),
(892,'Paradia Ring','','rfinger,lfinger','true','none',150,'gold','b',0,-1,-1,0,36,0,474000,82,'true','true','true','true','true','0-0','0-0;'),
(893,'Majestic Ring','','rfinger,lfinger','true','none',150,'gold','a',0,-1,-1,0,42,17,999000,80,'true','true','true','true','true','0-0','0-0;'),
(894,'Ring of Solar Eclipse','','rfinger,lfinger','true','none',150,'gold','b',0,-1,-1,0,34,0,310600,53,'true','true','true','true','true','0-0','0-0;'),
(895,'Ring of Black Ore','','rfinger,lfinger','true','none',150,'gold','b',0,-1,-1,0,36,0,474000,63,'true','true','true','true','true','0-0','0-0;'),
(896,'Ring of Summoning','','rfinger,lfinger','true','none',150,'gold','b',0,-1,-1,0,34,0,310600,53,'true','true','true','true','true','0-0','0-0;'),
(897,'Otherworldly Ring','','rfinger,lfinger','true','none',150,'gold','b',0,-1,-1,0,36,0,474000,82,'true','true','true','true','true','0-0','0-0;'),
(898,'Elemental Ring','','rfinger,lfinger','true','none',150,'gold','b',0,-1,-1,0,36,0,474000,82,'true','true','true','true','true','0-0','0-0;'),
(899,'Ring of Phantom','','rfinger,lfinger','true','none',150,'gold','a',0,-1,-1,0,40,0,999000,104,'true','true','true','true','true','0-0','0-0;'),
(900,'Ring of Grace','','rfinger,lfinger','true','none',150,'gold','b',0,-1,-1,0,34,0,310600,53,'true','true','true','true','true','0-0','0-0;'),
(901,'Ring of Holy Spirit','','rfinger,lfinger','true','none',150,'gold','b',0,-1,-1,0,36,0,474000,82,'true','true','true','true','true','0-0','0-0;'),
(902,'Phoenix Ring','','rfinger,lfinger','true','none',150,'gold','a',0,-1,-1,0,40,13,670000,54,'true','true','true','true','true','0-0','0-0;'),
(903,'Cerberus Ring','','rfinger,lfinger','true','none',150,'gold','a',0,-1,-1,0,40,0,999000,104,'true','true','true','true','true','0-0','0-0;'),
(904,'Ring of Aid','','rfinger,lfinger','true','none',150,'gold','b',0,-1,-1,0,34,0,310600,53,'true','true','true','true','true','0-0','0-0;'),
(905,'Ring of Blessing','','rfinger,lfinger','true','none',150,'gold','b',0,-1,-1,0,34,0,310600,53,'true','true','true','true','true','0-0','0-0;'),
(906,'Necklace of Knowledge','','neck','false','none',150,'silver','none',0,-1,-1,0,18,0,830,0,'true','true','true','true','true','0-0','0-0;'),
(907,'Necklace of Anguish','','neck','false','none',150,'silver','none',0,-1,-1,0,21,0,3600,0,'true','true','true','true','true','0-0','0-0;'),
(908,'Necklace of Wisdom','','neck','false','none',150,'silver','none',0,-1,-1,0,25,0,9120,0,'true','true','true','true','true','0-0','0-0;'),
(909,'Blue Diamond Necklace','','neck','false','none',150,'silver','none',0,-1,-1,0,28,0,16400,0,'true','true','true','true','true','0-0','0-0;'),
(910,'Necklace of Devotion','','neck','true','none',150,'silver','d',0,-1,-1,0,32,0,27600,51,'true','true','true','true','true','0-0','0-0;'),
(911,'Enchanted Necklace','','neck','true','none',150,'silver','d',0,-1,-1,0,36,0,43700,81,'true','true','true','true','true','0-0','0-0;'),
(912,'Near Forest Necklace','','neck','true','none',150,'silver','d',0,-1,-1,0,40,0,65900,122,'true','true','true','true','true','0-0','0-0;'),
(913,'Elven Necklace','','neck','true','none',150,'silver','d',0,-1,-1,0,45,0,95800,177,'true','true','true','true','true','0-0','0-0;'),
(914,'Necklace of Darkness','','neck','true','none',150,'silver','d',0,-1,-1,0,48,0,124400,230,'true','true','true','true','true','0-0','0-0;'),
(915,'Aquastone Necklace','','neck','true','none',150,'silver','c',0,-1,-1,0,52,0,159000,64,'true','true','true','true','true','0-0','0-0;'),
(916,'Necklace of Protection','','neck','true','none',150,'silver','c',0,-1,-1,0,56,0,200600,80,'true','true','true','true','true','0-0','0-0;'),
(917,'Necklace of Mermaid','','neck','true','none',150,'silver','c',0,-1,-1,0,60,0,302100,121,'true','true','true','true','true','0-0','0-0;'),
(918,'Adamantite Necklace','','neck','true','none',150,'silver','b',0,-1,-1,0,68,0,621200,83,'true','true','true','true','true','0-0','0-0;'),
(919,'Blessed Necklace','','neck','true','none',150,'silver','c',0,-1,-1,0,64,0,434400,226,'true','true','true','true','true','0-0','0-0;'),
(920,'Tateossian Necklace','','neck','true','none',150,'silver','s',0,-1,-1,0,95,42,4361000,209,'true','true','true','true','true','0-0','0-0;'),
(921,'Necklace of Mana','','neck','true','none',150,'silver','b',0,-1,-1,0,68,0,621200,107,'true','true','true','true','true','0-0','0-0;'),
(922,'Sage\'s Necklace','','neck','true','none',150,'silver','b',0,-1,-1,0,72,0,948000,164,'true','true','true','true','true','0-0','0-0;'),
(923,'Paradia Necklace','','neck','true','none',150,'silver','b',0,-1,-1,0,72,0,948000,164,'true','true','true','true','true','0-0','0-0;'),
(924,'Majestic Necklace','','neck','true','none',150,'silver','a',0,-1,-1,0,85,33,1998000,160,'true','true','true','true','true','0-0','0-0;'),
(925,'Necklace of Solar Eclipse','','neck','true','none',150,'silver','b',0,-1,-1,0,68,0,621200,107,'true','true','true','true','true','0-0','0-0;'),
(926,'Necklace of Black Ore','','neck','true','none',150,'silver','b',0,-1,-1,0,72,0,948000,126,'true','true','true','true','true','0-0','0-0;'),
(927,'Necklace of Summoning','','neck','true','none',150,'silver','b',0,-1,-1,0,68,0,621200,107,'true','true','true','true','true','0-0','0-0;'),
(928,'Otherworldly Necklace','','neck','true','none',150,'silver','b',0,-1,-1,0,72,0,948000,164,'true','true','true','true','true','0-0','0-0;'),
(929,'Elemental Necklace','','neck','true','none',150,'silver','b',0,-1,-1,0,72,0,948000,164,'true','true','true','true','true','0-0','0-0;'),
(930,'Necklace of Phantom','','neck','true','none',150,'silver','a',0,-1,-1,0,80,0,1998000,208,'true','true','true','true','true','0-0','0-0;'),
(931,'Necklace of Grace','','neck','true','none',150,'silver','b',0,-1,-1,0,68,0,621200,107,'true','true','true','true','true','0-0','0-0;'),
(932,'Necklace of Holy Spirit','','neck','true','none',150,'silver','b',0,-1,-1,0,72,0,948000,164,'true','true','true','true','true','0-0','0-0;'),
(933,'Phoenix Necklace','','neck','true','none',150,'silver','a',0,-1,-1,0,80,26,1340000,107,'true','true','true','true','true','0-0','0-0;'),
(934,'Cerberus Necklace','','neck','true','none',150,'silver','a',0,-1,-1,0,80,0,1998000,208,'true','true','true','true','true','0-0','0-0;'),
(935,'Necklace of Aid','','neck','true','none',150,'silver','b',0,-1,-1,0,68,0,621200,107,'true','true','true','true','true','0-0','0-0;'),
(936,'Necklace of Blessing','','neck','true','none',150,'silver','b',0,-1,-1,0,68,0,621200,107,'true','true','true','true','true','0-0','0-0;'),
(990,'Mandragora Essence','','gloves','false','none',60,'cloth','none',0,-1,-1,9,0,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(991,'Royen\'s Key','','gloves','false','none',60,'cloth','none',0,-1,-1,9,0,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(992,'Shilen\'s 1st Mark','','gloves','false','none',60,'cloth','none',0,-1,-1,9,0,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(993,'Shilen\'s 2nd Mark','','gloves','false','none',60,'cloth','none',0,-1,-1,9,0,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(994,'Eye of Abyss','','gloves','false','none',60,'cloth','none',0,-1,-1,9,0,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(995,'Wanted Poster','','gloves','false','none',60,'cloth','none',0,-1,-1,9,0,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(996,'Alex\'s Dagger','','gloves','false','none',60,'cloth','none',0,-1,-1,9,0,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(997,'Pinter\'s Bill','','gloves','false','none',60,'cloth','none',0,-1,-1,9,0,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(998,'Book of Aklantoth - Part 1','','gloves','false','none',60,'cloth','none',0,-1,-1,9,0,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(999,'Book of Aklantoth - Part 2','','gloves','false','none',60,'cloth','none',0,-1,-1,9,0,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(1000,'Book of Aklantoth - Part 3','','gloves','false','none',60,'cloth','none',0,-1,-1,9,0,0,28,0,'true','true','true','true','true','0-0','0-0;'),
(1100,'Cotton Tunic','','chest','false','magic',2120,'cloth','none',0,-1,-1,21,0,38,1870,0,'true','true','true','true','true','0-0','0-0;'),
(1101,'Tunic of Devotion','','chest','false','magic',2090,'cloth','none',0,-1,-1,30,0,67,15600,0,'true','true','true','true','true','0-0','0-0;'),
(1102,'Tunic of Magic','','chest','false','magic',2080,'cloth','none',0,-1,-1,34,0,86,28400,0,'true','true','true','true','true','0-0','0-0;'),
(1103,'Cotton Stockings','','legs','false','magic',1060,'cloth','none',0,-1,-1,13,0,23,1170,0,'true','true','true','true','true','0-0','0-0;'),
(1104,'Stockings of Devotion','','legs','false','magic',1040,'cloth','none',0,-1,-1,19,0,42,9770,0,'true','true','true','true','true','0-0','0-0;'),
(1105,'Stockings of Magic','','legs','false','magic',1030,'cloth','none',0,-1,-1,21,0,54,17700,0,'true','true','true','true','true','0-0','0-0;'),
(1119,'Short Leather Gloves','','gloves','false','none',660,'leather','none',0,-1,-1,11,0,0,470,0,'true','true','true','true','true','0-0','0-0;'),
(1120,'Pa\'agrian Hand','','gloves','true','none',1600,'leather','c',0,-1,-1,34,0,0,123900,64,'true','true','true','true','true','0-0','0-0;'),
(1121,'Apprentice\'s Shoes','','feet','false','none',1320,'leather','none',0,-1,-1,8,0,0,5,0,'true','true','true','true','true','0-0','0-0;'),
(1122,'Cotton Shoes','','feet','false','none',1320,'leather','none',0,-1,-1,11,0,0,470,0,'true','true','true','true','true','0-0','0-0;'),
(1123,'Blue Buckskin Boots','','feet','true','none',1300,'leather','d',0,-1,-1,22,0,0,25600,47,'true','true','true','true','true','0-0','0-0;'),
(1124,'Boots of Power','','feet','true','none',1250,'leather','d',0,-1,-1,27,0,0,57400,106,'true','true','true','true','true','0-0','0-0;'),
(1125,'Assault Boots','','feet','true','none',1240,'leather','d',0,-1,-1,29,0,0,75200,139,'true','true','true','true','true','0-0','0-0;'),
(1126,'Crimson Boots','','feet','true','none',1210,'leather','c',0,-1,-1,34,0,0,123900,50,'true','true','true','true','true','0-0','0-0;'),
(1127,'Forgotten Boots','','feet','true','none',4000,'leather','c',0,-1,-1,36,0,0,188800,98,'true','true','true','true','true','0-0','0-0;'),
(1128,'Adamantite Boots','','feet','true','none',4000,'adamantaite','c',0,-1,-1,39,0,0,275100,143,'true','true','true','true','true','0-0','0-0;'),
(1129,'Crude Leather Shoes','','feet','false','none',1320,'leather','none',0,-1,-1,11,0,0,470,0,'true','true','true','true','true','0-0','0-0;'),
(1146,'Squire\'s Shirt','','chest','false','light',3301,'cloth','none',0,-1,-1,33,0,0,20,0,'false','false','true','false','true','0-0','0-0;'),
(1147,'Squire\'s Pants','','legs','false','light',1750,'cloth','none',0,-1,-1,20,0,0,4,0,'false','false','true','false','true','0-0','0-0;'),
(1148,'Hard Leather Helmet','','head','false','none',640,'leather','none',0,-1,-1,26,0,0,14200,0,'true','true','true','true','true','0-0','0-0;'),
(1149,'Shining Circlet','','head','true','none',600,'steel','c',0,-1,-1,54,0,0,283200,113,'true','true','true','true','true','0-0','0-0;'),
(1308,'Compound Scale Mail','','chest','false','heavy',1400,'fine_steel','none',0,-1,-1,51,0,0,190200,0,'false','true','true','false','true','0-0','0-0;'),
(1309,'Mithril Breastplate','','chest','false','heavy',1000,'mithril','none',0,-1,-1,51,0,0,190200,0,'false','true','true','false','true','0-0','0-0;'),
(1310,'Tunic of Magic','','chest','false','magic',150,'cloth','none',0,-1,-1,51,0,96,37300,0,'false','true','true','false','true','0-0','0-0;'),
(1311,'Puma Skin Shirt','','chest','false','light',300,'leather','none',0,-1,-1,51,0,0,76900,0,'false','true','true','false','true','0-0','0-0;'),
(1312,'White Tunic','','chest','false','magic',150,'cloth','none',0,-1,-1,51,0,142,106000,0,'false','true','true','false','true','0-0','0-0;'),
(1313,'Compound Scale Gaiters','','legs','false','heavy',1000,'fine_steel','none',0,-1,-1,32,0,0,130800,0,'false','true','true','false','true','0-0','0-0;'),
(1314,'Mithril Gaiters','','legs','false','heavy',600,'mithril','none',0,-1,-1,32,0,0,130800,0,'false','true','true','false','true','0-0','0-0;'),
(1315,'Stockings of Magic','','legs','false','magic',150,'cloth','none',0,-1,-1,32,0,60,23300,0,'false','true','true','false','true','0-0','0-0;'),
(1316,'Puma Skin Gaiters','','legs','false','light',400,'leather','none',0,-1,-1,32,0,0,43000,0,'false','true','true','false','true','0-0','0-0;'),
(1317,'Dark Stockings','','legs','false','magic',150,'cloth','none',0,-1,-1,32,0,79,48000,0,'false','true','true','false','true','0-0','0-0;'),
(1318,'Gloves','','gloves','false','none',80,'cloth','none',0,-1,-1,14,0,0,2520,0,'false','true','true','false','true','0-0','0-0;'),
(1319,'Leather Gloves','','gloves','false','none',100,'leather','none',0,-1,-1,14,0,0,6100,0,'false','true','true','false','true','0-0','0-0;'),
(1320,'Crafted Leather Gloves','','gloves','false','none',100,'leather','none',0,-1,-1,14,0,0,22900,0,'false','true','true','false','true','0-0','0-0;'),
(1321,'Rip Gauntlets','','gloves','false','none',150,'leather','none',0,-1,-1,14,0,0,75200,0,'false','true','true','false','true','0-0','0-0;'),
(1322,'Bracer','','gloves','false','none',80,'leather','none',0,-1,-1,14,0,0,12400,0,'false','true','true','false','true','0-0','0-0;'),
(1323,'Leather Shoes','','feet','false','none',120,'leather','none',0,-1,-1,14,0,0,2520,0,'false','true','true','false','true','0-0','0-0;'),
(1324,'Low Boots','','feet','false','none',150,'leather','none',0,-1,-1,14,0,0,6100,0,'false','true','true','false','true','0-0','0-0;'),
(1325,'Leather Boots','','feet','false','none',250,'leather','none',0,-1,-1,14,0,0,22900,0,'false','true','true','false','true','0-0','0-0;'),
(1326,'Iron Boots','','feet','false','none',300,'fine_steel','none',0,-1,-1,14,0,0,57400,0,'false','true','true','false','true','0-0','0-0;'),
(1327,'Boots','','feet','false','none',200,'cloth','none',0,-1,-1,14,0,0,12400,0,'false','true','true','false','true','0-0','0-0;'),
(1506,'Necklace of Courage','','neck','false','none',150,'silver','none',0,-1,-1,0,15,0,51,0,'true','true','true','true','true','0-0','0-0;'),
(1507,'Necklace of Valor','','neck','false','none',150,'silver','none',0,-1,-1,0,21,0,3600,0,'true','true','true','true','true','0-0','0-0;'),
(1508,'Ring of Raccoon','','rfinger,lfinger','false','none',150,'gold','none',0,-1,-1,0,11,0,1800,0,'true','true','true','true','true','0-0','0-0;'),
(1509,'Ring of Firefly','','rfinger,lfinger','false','none',150,'gold','none',0,-1,-1,0,11,0,1800,0,'true','true','true','true','true','0-0','0-0;'),
(2376,'Avadon Breastplate','','chest','true','heavy',7920,'leather','b',0,-1,-1,157,0,0,1596000,213,'true','true','true','true','true','0-0','0-0;'),
(2377,'Mithril Scale Gaiters','','legs','true','heavy',3870,'leather','d',0,-1,-1,64,0,0,143600,265,'true','true','true','true','true','0-0','0-0;'),
(2378,'Brigandine Gaiters','','legs','true','heavy',3820,'leather','d',0,-1,-1,64,0,0,143600,265,'true','true','true','true','true','0-0','0-0;'),
(2379,'Avadon Gaiters','','legs','true','heavy',3520,'leather','b',0,-1,-1,98,0,0,997700,133,'true','true','true','true','true','0-0','0-0;'),
(2380,'Blue Wolf Gaiters','','legs','true','heavy',3370,'leather','b',0,-1,-1,104,0,0,1547100,206,'true','true','true','true','true','0-0','0-0;'),
(2381,'Doom Plate Armor','','fullarmor','true','heavy',9980,'leather','b',0,-1,-1,270,0,0,4022000,536,'true','true','true','true','true','0-0','0-0;'),
(2382,'Tallum Plate Armor','','fullarmor','true','heavy',9780,'leather','a',0,-1,-1,278,0,0,5788000,463,'true','true','true','true','true','0-0','0-0;'),
(2383,'Majestic Plate Armor','','fullarmor','true','heavy',9200,'leather','a',0,-1,-1,293,0,0,8804000,704,'true','true','true','true','true','0-0','0-0;'),
(2384,'Zubei\'s Leather Shirt','','chest','true','light',4330,'leather','b',0,-1,-1,117,0,0,1197000,160,'true','true','true','true','true','0-0','0-0;'),
(2385,'Dark Crystal Leather Armor','','chest','true','light',4300,'leather','a',0,-1,-1,128,0,0,2671000,214,'true','true','true','true','true','0-0','0-0;'),
(2386,'Wooden Gaiters','','legs','false','light',1670,'leather','none',0,-1,-1,29,0,0,3820,0,'true','true','true','true','true','0-0','0-0;'),
(2387,'Tempered Mithril Gaiters','','legs','true','light',1530,'leather','c',0,-1,-1,56,0,0,182100,73,'true','true','true','true','true','0-0','0-0;'),
(2388,'Zubei\'s Leather Gaiters','','legs','true','light',1480,'leather','b',0,-1,-1,73,0,0,748300,100,'true','true','true','true','true','0-0','0-0;'),
(2389,'Dark Crystal Leggings','','legs','true','light',1480,'leather','a',0,-1,-1,80,0,0,1670000,134,'true','true','true','true','true','0-0','0-0;'),
(2390,'Avadon Leather Armor','','fullarmor','true','light',5600,'leather','b',0,-1,-1,191,0,0,1946000,259,'true','true','true','true','true','0-0','0-0;'),
(2391,'Blue Wolf Leather Armor','','fullarmor','true','light',5500,'leather','b',0,-1,-1,202,0,0,3017000,402,'true','true','true','true','true','0-0','0-0;'),
(2392,'Leather Armor of Doom','','fullarmor','true','light',5500,'leather','b',0,-1,-1,202,0,0,3017000,402,'true','true','true','true','true','0-0','0-0;'),
(2393,'Tallum Leather Armor','','fullarmor','true','light',5400,'leather','a',0,-1,-1,209,0,0,4341000,347,'true','true','true','true','true','0-0','0-0;'),
(2394,'Nightmarish Leather Armor','','fullarmor','true','light',5300,'leather','a',0,-1,-1,220,0,0,6603000,528,'true','true','true','true','true','0-0','0-0;'),
(2395,'Majestic Leather Armor','','fullarmor','true','light',5350,'leather','a',0,-1,-1,220,0,0,6603000,528,'true','true','true','true','true','0-0','0-0;'),
(2396,'Elven Mithril Tunic','','chest','true','magic',720,'leather','d',0,-1,-1,54,0,169,172000,318,'true','true','true','true','true','0-0','0-0;'),
(2397,'Tunic of Zubei','','chest','true','magic',1960,'leather','b',0,-1,-1,78,0,345,1197000,160,'true','true','true','true','true','0-0','0-0;'),
(2398,'Blue Wolf Tunic','','chest','true','magic',1920,'leather','b',0,-1,-1,83,0,377,1857000,248,'true','true','true','true','true','0-0','0-0;'),
(2399,'Tunic of Doom','','chest','true','magic',1900,'leather','b',0,-1,-1,83,0,377,1857000,248,'true','true','true','true','true','0-0','0-0;'),
(2400,'Tallum Tunic','','chest','true','magic',1860,'leather','a',0,-1,-1,86,0,409,2671000,214,'true','true','true','true','true','0-0','0-0;'),
(2401,'Elven Mithril Stockings','','legs','true','magic',2400,'leather','d',0,-1,-1,34,0,105,107700,199,'true','true','true','true','true','0-0','0-0;'),
(2402,'Stockings of Zubei','','legs','true','magic',940,'leather','b',0,-1,-1,49,0,216,748300,100,'true','true','true','true','true','0-0','0-0;'),
(2403,'Blue Wolf Stockings','','legs','true','magic',920,'leather','b',0,-1,-1,52,0,236,1160300,155,'true','true','true','true','true','0-0','0-0;'),
(2404,'Stockings of Doom','','legs','true','magic',910,'leather','b',0,-1,-1,52,0,236,1160300,155,'true','true','true','true','true','0-0','0-0;'),
(2405,'Tallum Stockings','','legs','true','magic',920,'leather','a',0,-1,-1,53,0,256,1670000,134,'true','true','true','true','true','0-0','0-0;'),
(2406,'Avadon Robe','','fullarmor','true','magic',2540,'leather','b',0,-1,-1,127,0,561,1946000,259,'true','true','true','true','true','0-0','0-0;'),
(2407,'Dark Crystal Robe','','fullarmor','true','magic',2450,'leather','a',0,-1,-1,139,0,665,4341000,347,'true','true','true','true','true','0-0','0-0;'),
(2408,'Nightmare Robe','','fullarmor','true','magic',2300,'leather','a',0,-1,-1,147,0,718,6603000,528,'true','true','true','true','true','0-0','0-0;'),
(2409,'Majestic Robe','','fullarmor','true','magic',2330,'leather','a',0,-1,-1,147,0,718,6603000,528,'true','true','true','true','true','0-0','0-0;'),
(2410,'Nightmarish Tattoo','','underwear','true','light',3600,'leather','a',0,-1,-1,139,0,0,4064000,422,'true','true','true','true','true','0-0','0-0;'),
(2411,'Brigandine Helmet','','head','true','none',630,'leather','d',0,-1,-1,41,0,0,86100,159,'true','true','true','true','true','0-0','0-0;'),
(2412,'Plate Helmet','','head','true','none',630,'leather','d',0,-1,-1,44,0,0,112800,208,'true','true','true','true','true','0-0','0-0;'),
(2413,'Chain Hood','','head','true','none',620,'leather','c',0,-1,-1,47,0,0,145700,58,'true','true','true','true','true','0-0','0-0;'),
(2414,'Full Plate Helmet','','head','true','none',600,'leather','c',0,-1,-1,58,0,0,412600,165,'true','true','true','true','true','0-0','0-0;'),
(2415,'Avadon Circlet','','head','true','none',590,'leather','b',0,-1,-1,62,0,0,598600,80,'true','true','true','true','true','0-0','0-0;'),
(2416,'Blue Wolf Helmet','','head','true','none',580,'leather','b',0,-1,-1,66,0,0,928300,124,'true','true','true','true','true','0-0','0-0;'),
(2417,'Doom Helmet','','head','true','none',580,'leather','b',0,-1,-1,66,0,0,928300,124,'true','true','true','true','true','0-0','0-0;'),
(2418,'Helm of Nightmare','','head','true','none',560,'leather','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','0-0;'),
(2419,'Majestic Circlet','','head','true','none',550,'leather','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','0-0;'),
(2420,'Dragon Headgear','','head','true','none',540,'leather','s',0,-1,-1,77,0,0,2784000,179,'true','true','true','true','true','0-0','0-0;'),
(2421,'The Hood','','head','true','none',540,'leather','s',0,-1,-1,77,0,0,2784000,180,'true','true','true','true','true','0-0','0-0;'),
(2422,'Reinforced Leather Boots','','feet','true','none',1280,'leather','d',0,-1,-1,24,0,0,39100,72,'true','true','true','true','true','0-0','0-0;'),
(2423,'Boots of Knowledge','','feet','true','none',1270,'leather','d',0,-1,-1,24,0,0,39100,72,'true','true','true','true','true','0-0','0-0;'),
(2424,'Manticore Skin Boots','','feet','true','none',1260,'leather','d',0,-1,-1,27,0,0,57400,106,'true','true','true','true','true','0-0','0-0;'),
(2425,'Brigandine Boots','','feet','true','none',1250,'leather','d',0,-1,-1,27,0,0,57400,106,'true','true','true','true','true','0-0','0-0;'),
(2426,'Elven Mithril Boots','','feet','true','none',1250,'leather','d',0,-1,-1,27,0,0,57400,106,'true','true','true','true','true','0-0','0-0;'),
(2427,'Salamander Skin Boots','','feet','true','none',1230,'leather','d',0,-1,-1,29,0,0,75200,139,'true','true','true','true','true','0-0','0-0;'),
(2428,'Plate Boots','','feet','true','none',1240,'leather','d',0,-1,-1,29,0,0,75200,139,'true','true','true','true','true','0-0','0-0;'),
(2429,'Chain Boots','','feet','true','none',1220,'leather','c',0,-1,-1,32,0,0,97100,39,'true','true','true','true','true','0-0','0-0;'),
(2430,'Karmian Boots','','feet','true','none',1230,'leather','c',0,-1,-1,32,0,0,97100,39,'true','true','true','true','true','0-0','0-0;'),
(2431,'Plated Leather Boots','','feet','true','none',1220,'leather','c',0,-1,-1,32,0,0,97100,39,'true','true','true','true','true','0-0','0-0;'),
(2432,'Dwarven Chain Boots','','feet','true','none',1210,'leather','c',0,-1,-1,32,0,0,97100,39,'true','true','true','true','true','0-0','0-0;'),
(2433,'Boots of Seal','','feet','true','none',1220,'leather','c',0,-1,-1,32,0,0,97100,39,'true','true','true','true','true','0-0','0-0;'),
(2434,'Rind Leather Boots','','feet','true','none',1220,'leather','c',0,-1,-1,34,0,0,123900,50,'true','true','true','true','true','0-0','0-0;'),
(2435,'Demon\'s Boots','','feet','true','none',1220,'leather','c',0,-1,-1,36,0,0,188800,76,'true','true','true','true','true','0-0','0-0;'),
(2436,'Theca Leather Boots','','feet','true','none',1210,'leather','c',0,-1,-1,37,0,0,211600,85,'true','true','true','true','true','0-0','0-0;'),
(2437,'Drake Leather Boots','','feet','true','none',1210,'leather','c',0,-1,-1,39,0,0,275100,110,'true','true','true','true','true','0-0','0-0;'),
(2438,'Full Plate Boots','','feet','true','none',1200,'leather','c',0,-1,-1,39,0,0,275100,110,'true','true','true','true','true','0-0','0-0;'),
(2439,'Blue Wolf Boots','','feet','true','none',1130,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(2440,'Boots of Nightmare','','feet','true','none',1110,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(2441,'Dark Legion Boots','','feet','true','none',1120,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(2442,'Dasparion\'s Boots','','feet','true','none',1100,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(2443,'Dragon Leather Boots','','feet','true','none',1100,'leather','s',0,-1,-1,51,0,0,1856000,119,'true','true','true','true','true','0-0','0-0;'),
(2444,'The Boots','','feet','true','none',1100,'leather','s',0,-1,-1,51,0,0,1856000,119,'true','true','true','true','true','0-0','0-0;'),
(2445,'Dragon Scale Boots','','feet','true','none',1100,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(2446,'Reinforced Leather Gloves','','gloves','true','none',640,'leather','d',0,-1,-1,24,0,0,39100,72,'true','true','true','true','true','0-0','0-0;'),
(2447,'Gloves of Knowledge','','gloves','true','none',640,'leather','d',0,-1,-1,24,0,0,39100,72,'true','true','true','true','true','0-0','0-0;'),
(2448,'Manticore Skin Gloves','','gloves','true','none',630,'leather','d',0,-1,-1,27,0,0,57400,106,'true','true','true','true','true','0-0','0-0;'),
(2449,'Brigandine Gauntlets','','gloves','true','none',630,'leather','d',0,-1,-1,27,0,0,57400,106,'true','true','true','true','true','0-0','0-0;'),
(2450,'Mithril Gloves','','gloves','true','none',640,'leather','d',0,-1,-1,27,0,0,57400,106,'true','true','true','true','true','0-0','0-0;'),
(2451,'Sage\'s Worn Gloves','','gloves','true','none',630,'leather','d',0,-1,-1,29,0,0,75200,139,'true','true','true','true','true','0-0','0-0;'),
(2452,'Reinforced Mithril Gloves','','gloves','true','none',620,'leather','c',0,-1,-1,32,0,0,97100,39,'true','true','true','true','true','0-0','0-0;'),
(2453,'Chain Gloves','','gloves','true','none',620,'leather','c',0,-1,-1,32,0,0,97100,39,'true','true','true','true','true','0-0','0-0;'),
(2454,'Karmian Gloves','','gloves','true','none',620,'leather','c',0,-1,-1,32,0,0,97100,39,'true','true','true','true','true','0-0','0-0;'),
(2455,'Plated Leather Gloves','','gloves','true','none',610,'leather','c',0,-1,-1,33,0,0,114400,46,'true','true','true','true','true','0-0','0-0;'),
(2456,'Dwarven Chain Gloves','','gloves','true','none',600,'leather','c',0,-1,-1,34,0,0,123900,50,'true','true','true','true','true','0-0','0-0;'),
(2457,'Gloves of Seal','','gloves','true','none',620,'leather','c',0,-1,-1,34,0,0,123900,50,'true','true','true','true','true','0-0','0-0;'),
(2458,'Rind Leather Gloves','','gloves','true','none',600,'leather','c',0,-1,-1,34,0,0,123900,50,'true','true','true','true','true','0-0','0-0;'),
(2459,'Demon\'s Gloves','','gloves','true','none',610,'leather','c',0,-1,-1,36,0,0,188800,76,'true','true','true','true','true','0-0','0-0;'),
(2460,'Theca Leather Gloves','','gloves','true','none',600,'leather','c',0,-1,-1,37,0,0,211600,85,'true','true','true','true','true','0-0','0-0;'),
(2461,'Drake Leather Gloves','','gloves','true','none',600,'leather','c',0,-1,-1,39,0,0,275100,110,'true','true','true','true','true','0-0','0-0;'),
(2462,'Full Plate Gauntlets','','gloves','true','none',600,'leather','c',0,-1,-1,39,0,0,275100,110,'true','true','true','true','true','0-0','0-0;'),
(2463,'Divine Gloves','','gloves','true','none',610,'leather','c',0,-1,-1,39,0,0,275100,110,'true','true','true','true','true','0-0','0-0;'),
(2464,'Avadon Gloves','','gloves','true','none',590,'leather','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','0-0;'),
(2465,'Chain Gloves of Silence','','gloves','true','none',590,'leather','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(2466,'Guardian\'s Gloves','','gloves','true','none',590,'leather','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(2467,'Gloves of Blessing','','gloves','true','none',590,'leather','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(2468,'Blessed Gloves','','gloves','true','none',600,'leather','c',0,-1,-1,39,0,0,275100,143,'true','true','true','true','true','0-0','0-0;'),
(2469,'Gloves of the Underworld','','gloves','true','none',580,'leather','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(2470,'Gloves of Phantom','','gloves','true','none',560,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(2471,'Dark Legion Gloves','','gloves','true','none',560,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(2472,'Dark Crystal Gloves','','gloves','true','none',580,'leather','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(2473,'The Gloves','','gloves','true','none',540,'leather','s',0,-1,-1,51,0,0,1856000,119,'true','true','true','true','true','0-0','0-0;'),
(2474,'Dasparion\'s Gloves','','gloves','true','none',550,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(2475,'Doom Gloves','','gloves','true','none',580,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(2476,'Dragon Gauntlets','','gloves','true','none',540,'leather','s',0,-1,-1,52,0,0,1355000,131,'true','true','true','true','true','0-0','0-0;'),
(2477,'Dragon Leather Gloves','','gloves','true','none',540,'leather','s',0,-1,-1,51,0,0,1856000,119,'true','true','true','true','true','0-0','0-0;'),
(2478,'Tallum Gloves','','gloves','true','none',580,'leather','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(2479,'Gauntlets of Nightmare','','gloves','true','none',550,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(2480,'Elemental Gloves','','gloves','true','none',580,'leather','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(2481,'Gloves of Grace','','gloves','true','none',580,'leather','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(2482,'Majestic Gauntlets','','gloves','true','none',540,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(2483,'Gust Bracer','','gloves','true','none',580,'leather','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(2484,'Cerberus Gloves','','gloves','true','none',540,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(2485,'Implosion Gauntlets','','gloves','true','none',580,'leather','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(2486,'Paradia Gloves','','gloves','true','none',580,'leather','b',0,-1,-1,44,0,0,618800,107,'true','true','true','true','true','0-0','0-0;'),
(2487,'Blue Wolf Gloves','','gloves','true','none',590,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(2488,'Phoenix Gloves','','gloves','true','none',570,'leather','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(2489,'Gloves of Black Ore','','gloves','true','none',570,'leather','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(2490,'Cloak of Silence','','back','false','none',250,'leather','none',0,-1,-1,5,0,0,6770,0,'true','true','true','true','true','0-0','0-0;'),
(2491,'Golden Yarn Cloak','','back','false','none',250,'leather','none',0,-1,-1,5,0,0,12300,0,'true','true','true','true','true','0-0','0-0;'),
(2492,'Shadow Cloak','','back','true','none',240,'leather','c',0,-1,-1,12,0,0,126000,50,'true','true','true','true','true','0-0','0-0;'),
(2506,'Wolf\'s Leather Armor','','wolf','false','light',160,'leather','none',0,-1,-1,9,14,0,6120,0,'true','true','true','true','true','0-0','0-0;'),
(3891,'Wolf\'s Hide Armor','','wolf','false','light',160,'leather','none',0,-1,-1,13,16,0,15600,0,'true','true','true','true','true','0-0','0-0;'),
(3892,'Wolf\'s Hard Leather Mail','','wolf','false','light',160,'leather','none',0,-1,-1,16,18,0,28400,0,'true','true','true','true','true','0-0','0-0;'),
(3893,'Wolf\'s Wooden Armor','','wolf','false','light',160,'leather','none',0,-1,-1,19,20,0,48200,0,'true','true','true','true','true','0-0','0-0;'),
(3894,'Wolf\'s Ring Mail','','wolf','false','light',160,'leather','none',0,-1,-1,22,23,0,76900,0,'true','true','true','true','true','0-0','0-0;'),
(3895,'Wolf\'s Bone Armor','','wolf','false','light',160,'leather','none',0,-1,-1,26,26,0,117000,0,'true','true','true','true','true','0-0','0-0;'),
(3896,'Wolf\'s Scale Mail','','wolf','false','light',160,'leather','none',0,-1,-1,30,29,0,172000,0,'true','true','true','true','true','0-0','0-0;'),
(3897,'Wof\'s Bronze Armor','','wolf','false','light',160,'leather','none',0,-1,-1,33,31,0,226000,0,'true','true','true','true','true','0-0','0-0;'),
(3898,'Wolf\'s Plate Mail','','wolf','false','light',160,'leather','none',0,-1,-1,37,33,0,291000,0,'true','true','true','true','true','0-0','0-0;'),
(3899,'Wolf\'s Steel Armor','','wolf','false','light',160,'leather','none',0,-1,-1,40,36,0,372000,0,'true','true','true','true','true','0-0','0-0;'),
(3900,'Wolf\'s Luxury Plate','','wolf','false','light',160,'leather','none',0,-1,-1,43,38,0,566000,0,'true','true','true','true','true','0-0','0-0;'),
(3901,'Wolf\'s Mithril Armor','','wolf','false','light',160,'leather','none',0,-1,-1,47,41,0,825000,0,'true','true','true','true','true','0-0','0-0;'),
(3912,'Hatchling\'s Soft Leather','','hatchling','false','light',160,'leather','none',0,-1,-1,26,26,0,117000,0,'true','true','true','true','true','0-0','0-0;'),
(3913,'Hatchling\'s Scale Mail','','hatchling','false','light',160,'leather','none',0,-1,-1,29,29,0,172000,0,'true','true','true','true','true','0-0','0-0;'),
(3914,'Hatchling\'s Brigandine','','hatchling','false','light',160,'leather','none',0,-1,-1,31,31,0,226000,0,'true','true','true','true','true','0-0','0-0;'),
(3915,'Hatchling\'s Bronze Coat','','hatchling','false','light',160,'leather','none',0,-1,-1,33,33,0,291000,0,'true','true','true','true','true','0-0','0-0;'),
(3916,'Hatchling\'s Steel Coat','','hatchling','false','light',160,'leather','none',0,-1,-1,36,36,0,372000,0,'true','true','true','true','true','0-0','0-0;'),
(3917,'Hatchling\'s Shadowplate','','hatchling','false','light',160,'leather','none',0,-1,-1,38,38,0,566000,0,'true','true','true','true','true','0-0','0-0;'),
(3918,'Hatchling\'s Mithril Coat','','hatchling','false','light',160,'leather','none',0,-1,-1,41,41,0,825000,0,'true','true','true','true','true','0-0','0-0;'),
(4224,'Dream Armor','','chest','true','heavy',8920,'bronze','none',0,-1,-1,68,0,0,37820,0,'true','true','true','true','true','0-0','0-0;'),
(4225,'Dream Stockings','','legs','true','heavy',3960,'bronze','none',0,-1,-1,43,0,0,23600,0,'true','true','true','true','true','0-0','0-0;'),
(4226,'Dream Gloves','','gloves','true','none',650,'leather','none',0,-1,-1,17,0,0,9500,0,'true','true','true','true','true','0-0','0-0;'),
(4227,'Dream Boots','','feet','true','none',1310,'cloth','none',0,-1,-1,17,0,0,9500,0,'true','true','true','true','true','0-0','0-0;'),
(4228,'Ubiquitous Armor','','chest','true','heavy',8920,'bronze','none',0,-1,-1,68,0,0,37820,0,'true','true','true','true','true','0-0','0-0;'),
(4229,'Ubiquitous Stockings','','legs','true','heavy',3960,'bronze','none',0,-1,-1,43,0,0,23600,0,'true','true','true','true','true','0-0','0-0;'),
(4230,'Ubiquitous Gloves','','gloves','true','none',650,'leather','none',0,-1,-1,17,0,0,9500,0,'true','true','true','true','true','0-0','0-0;'),
(4231,'Ubiquitous Boots','','feet','true','none',1310,'cloth','none',0,-1,-1,17,0,0,9500,0,'true','true','true','true','true','0-0','0-0;'),
(4234,'Hatchling\'s Level 65 Armor','','hatchling','false','light',160,'leather','none',0,-1,-1,50,50,0,3132000,0,'true','true','true','true','true','0-0','0-0;'),
(4235,'Hatchling\'s Level 75 Armor','','hatchling','false','light',160,'leather','none',0,-1,-1,58,58,0,9586000,0,'true','true','true','true','true','0-0','0-0;'),
(4236,'Gara Item','','chest','false','light',160,'leather','none',0,-1,-1,58,58,0,9586000,0,'true','true','true','true','true','0-0','0-0;'),
(5170,'Mithril Panzer Coat','','strider','false','light',160,'leather','none',0,-1,-1,41,41,0,825000,0,'true','true','true','true','true','0-0','0-0;'),
(5171,'Brigadine Panzer Coat','','strider','false','light',160,'leather','none',0,-1,-1,44,44,0,1197000,0,'true','true','true','true','true','0-0','0-0;'),
(5172,'Draconic Panzer Coat','','strider','false','light',160,'leather','none',0,-1,-1,46,46,0,1857000,0,'true','true','true','true','true','0-0','0-0;'),
(5173,'Blood Panzer Coat','','strider','false','light',160,'leather','none',0,-1,-1,49,49,0,2671000,0,'true','true','true','true','true','0-0','0-0;'),
(5174,'Ophidian Panzer Coat','','strider','false','light',160,'leather','none',0,-1,-1,52,52,0,4064000,0,'true','true','true','true','true','0-0','0-0;'),
(5175,'Inferno Panzer Coat','','strider','false','light',160,'leather','none',0,-1,-1,54,54,0,5568000,0,'true','true','true','true','true','0-0','0-0;'),
(5182,'Hatchling\'s Gorgon Coat','','hatchling','false','light',160,'leather','none',0,-1,-1,44,44,0,1197000,0,'true','true','true','true','true','0-0','0-0;'),
(5183,'Hatchling\'s Ophidian Plate','','hatchling','false','light',160,'leather','none',0,-1,-1,46,46,0,1857000,0,'true','true','true','true','true','0-0','0-0;'),
(5184,'Hatchling\'s Crimson Plate','','hatchling','false','light',160,'leather','none',0,-1,-1,49,49,0,2671000,0,'true','true','true','true','true','0-0','0-0;'),
(5185,'Hatchling\'s Draconic Plate','','hatchling','false','light',160,'leather','none',0,-1,-1,52,52,0,4064000,0,'true','true','true','true','true','0-0','0-0;'),
(5186,'Hatchling\'s Inferno Plate','','hatchling','false','light',160,'leather','none',0,-1,-1,54,54,0,5568000,0,'true','true','true','true','true','0-0','0-0;'),
(5216,'Wolf Level 75 Armor','','wolf','false','light',160,'leather','none',0,-1,-1,71,58,0,9586000,0,'true','true','true','true','true','0-0','0-0;'),
(5287,'Sealed Dark Crystal breastplate','','chest','true','heavy',7700,'crystal','a',0,-1,-1,171,0,0,3562000,285,'true','true','true','true','true','0-0','0-0;'),
(5288,'Sealed Dark Crystal Gaiters','','legs','true','heavy',3320,'crystal','a',0,-1,-1,107,0,0,2226000,178,'true','true','true','true','true','0-0','0-0;'),
(5289,'Sealed Dark Crystal Helmet','','head','true','none',570,'crystal','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','0-0;'),
(5290,'Sealed Dark Crystal Gloves','','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5291,'Sealed Dark Crystal Boots','','feet','true','none',1110,'crystal','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5293,'Sealed Tallum Plate Armor','','fullarmor','true','heavy',9780,'leather','a',0,-1,-1,278,0,0,5788000,463,'true','true','true','true','true','0-0','0-0;'),
(5294,'Sealed Tallum Helmet','','head','true','none',570,'cloth','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','0-0;'),
(5295,'Sealed Tallum Gloves','','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5296,'Sealed Tallum Boots','','feet','true','none',1130,'blood_steel','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5297,'Sealed Dark Crystal Leather Armor','','chest','true','light',4300,'leather','a',0,-1,-1,128,0,0,2671000,214,'true','true','true','true','true','0-0','0-0;'),
(5298,'Sealed Dark Crystal Leggings','','legs','true','light',1480,'leather','a',0,-1,-1,80,0,0,1670000,134,'true','true','true','true','true','0-0','0-0;'),
(5299,'Sealed Gloves of the Underworld','','gloves','true','none',580,'leather','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(5300,'Sealed Boots of the Underworld','','feet','true','none',1110,'leather','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(5301,'Sealed Tallum Leather Armor','','fullarmor','true','light',5400,'leather','a',0,-1,-1,209,0,0,4341000,347,'true','true','true','true','true','0-0','0-0;'),
(5302,'Sealed Gust Bracer','','gloves','true','none',580,'leather','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(5303,'Sealed Gust Boots','','feet','true','none',1120,'blood_steel','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(5304,'Sealed Tallum Tunic','','chest','true','magic',1860,'leather','a',0,-1,-1,86,0,409,2671000,214,'true','true','true','true','true','0-0','0-0;'),
(5305,'Sealed Tallum Stockings','','legs','true','magic',920,'leather','a',0,-1,-1,53,0,256,1670000,134,'true','true','true','true','true','0-0','0-0;'),
(5306,'Sealed Gloves of Black Ore','','gloves','true','none',570,'leather','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(5307,'Sealed Red Flame Boots','','feet','true','none',1120,'blood_steel','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(5308,'Sealed Dark Crystal Robe','','fullarmor','true','magic',2450,'leather','a',0,-1,-1,139,0,665,4341000,347,'true','true','true','true','true','0-0','0-0;'),
(5309,'Sealed Phoenix Gloves','','gloves','true','none',570,'leather','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(5310,'Sealed Phoenix Boots','','feet','true','none',1120,'blood_steel','a',0,-1,-1,45,0,0,890000,92,'true','true','true','true','true','0-0','0-0;'),
(5311,'Sealed Armor of Nightmare','','fullarmor','true','heavy',9580,'blood_steel','a',0,-1,-1,293,0,0,8804000,704,'true','true','true','true','true','0-0','0-0;'),
(5312,'Sealed Helm of Nightmare','','head','true','none',560,'leather','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','0-0;'),
(5313,'Sealed Gauntlets of Nightmare','','gloves','true','none',550,'leather','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5314,'Sealed Boots of Nightmare','','feet','true','none',1110,'leather','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5316,'Sealed Majestic Plate Armor','','fullarmor','true','heavy',9200,'leather','a',0,-1,-1,293,0,0,8804000,704,'true','true','true','true','true','0-0','0-0;'),
(5317,'Sealed Majestic Circlet','','head','true','none',550,'leather','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','0-0;'),
(5318,'Sealed Majestic Gauntlets','','gloves','true','none',540,'leather','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5319,'Sealed Majestic Boots','','feet','true','none',1110,'blood_steel','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5320,'Sealed Leather Armor of Nightmare','','fullarmor','true','light',5300,'leather','a',0,-1,-1,220,0,0,6603000,528,'true','true','true','true','true','0-0','0-0;'),
(5321,'Sealed Dark Legion Gloves','','gloves','true','none',560,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(5322,'Sealed Dark Legion Boots','','feet','true','none',1120,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(5323,'Sealed Majestic Leather Armor','','fullarmor','true','light',5350,'leather','a',0,-1,-1,220,0,0,6603000,528,'true','true','true','true','true','0-0','0-0;'),
(5324,'Sealed Gloves of Phantom','','gloves','true','none',560,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(5325,'Sealed Boots of Phantom','','feet','true','none',1120,'oriharukon','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(5326,'Sealed Nightmare Robe','','fullarmor','true','magic',2300,'leather','a',0,-1,-1,147,0,718,6603000,528,'true','true','true','true','true','0-0','0-0;'),
(5327,'Sealed Cerberus Gloves','','gloves','true','none',540,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(5328,'Sealed Cerberus Boots','','feet','true','none',1120,'damascus','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(5329,'Sealed Majestic Robe','','fullarmor','true','magic',2330,'leather','a',0,-1,-1,147,0,718,6603000,528,'true','true','true','true','true','0-0','0-0;'),
(5330,'Sealed Dasparion\'s Gloves','','gloves','true','none',550,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(5331,'Sealed Dasparion\'s Boots','','feet','true','none',1100,'leather','a',0,-1,-1,48,0,0,1355000,140,'true','true','true','true','true','0-0','0-0;'),
(5576,'Sound Test Boots','','feet','false','none',50,'cloth','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(5590,'Squeaking Shoes','','feet','false','none',50,'cloth','none',0,-1,-1,0,0,0,1,0,'true','true','true','true','true','0-0','0-0;'),
(5709,'Sealed Zubei\'s Gauntlets','','gloves','true','none',590,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5710,'Zubei\'s Gauntlets','Heavy Armor','gloves','true','none',590,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5711,'Zubei\'s Gauntlets','Light Armor','gloves','true','none',590,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5712,'Zubei\'s Gauntlets','Robe','gloves','true','none',590,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5713,'Sealed Avadon Gloves','','gloves','true','none',590,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5714,'Avadon Gloves','Heavy Armor','gloves','true','none',590,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5715,'Avadon Gloves','Light Armor','gloves','true','none',590,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5716,'Avadon Gloves','Robe','gloves','true','none',590,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5717,'Sealed Blue Wolf Gloves','','gloves','true','none',590,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5718,'Blue Wolf Gloves','Heavy Armor','gloves','true','none',590,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5719,'Blue Wolf Gloves','Light Armor','gloves','true','none',590,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5720,'Blue Wolf Gloves','Robe','gloves','true','none',590,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5721,'Sealed Doom Gloves','','gloves','true','none',580,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5722,'Doom Gloves','Heavy Armor','gloves','true','none',580,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5723,'Doom Gloves','Light Armor','gloves','true','none',580,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5724,'Doom Gloves','Robe','gloves','true','none',580,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5725,'Sealed Zubei\'s Boots','','feet','true','none',1180,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5726,'Zubei\'s Boots','Heavy Armor','feet','true','none',1180,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5727,'Zubei\'s Boots','Light Armor','feet','true','none',1180,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5728,'Zubei\'s Boots','Robe','feet','true','none',1180,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5729,'Sealed Avadon Boots','','feet','true','none',1180,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5730,'Avadon Boots','Heavy Armor','feet','true','none',1180,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5731,'Avadon Boots','Light Armor','feet','true','none',1180,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5732,'Avadon Boots','Robe','feet','true','none',1180,'mithril','b',0,-1,-1,41,0,0,399100,69,'true','true','true','true','true','0-0','0-0;'),
(5733,'Sealed Blue Wolf Boots','','feet','true','none',1130,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5734,'Blue Wolf Boots','Heavy Armor','feet','true','none',1130,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5735,'Blue Wolf Boots','Light Armor','feet','true','none',1130,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5736,'Blue Wolf Boots','Robe','feet','true','none',1130,'leather','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5737,'Sealed Boots of Doom','','feet','true','none',1130,'mithril','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5738,'Doom Boots','Heavy Armor','feet','true','none',1130,'mithril','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5739,'Doom Boots','Light Armor','feet','true','none',1130,'mithril','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5740,'Doom Boots','Robe','feet','true','none',1130,'mithril','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(5765,'Dark Crystal Gloves','Heavy Armor','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5766,'Dark Crystal Gloves','Light Armor','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5767,'Dark Crystal Gloves','Robe','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5768,'Tallum Gloves','Heavy Armor','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5769,'Tallum Gloves','Light Armor','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5770,'Tallum Gloves','Robe','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5771,'Gauntlets of Nightmare','Heavy Armor','gloves','true','none',550,'leather','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5772,'Gauntlets of Nightmare','Light Armor','gloves','true','none',550,'leather','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5773,'Gauntlets of Nightmare','Robe','gloves','true','none',550,'leather','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5774,'Majestic Gauntlets','Heavy Armor','gloves','true','none',540,'leather','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5775,'Majestic Gauntlets','Light Armor','gloves','true','none',540,'leather','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5776,'Majestic Gauntlets','Robe','gloves','true','none',540,'leather','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5777,'Dark Crystal Boots','Heavy Armor','feet','true','none',1110,'crystal','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5778,'Dark Crystal Boots','Light Armor','feet','true','none',1110,'crystal','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5779,'Dark Crystal Boots','Robe','feet','true','none',1110,'crystal','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5780,'Tallum Boots','Heavy Armor','feet','true','none',1130,'blood_steel','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5781,'Tallum Boots','Light Armor','feet','true','none',1130,'blood_steel','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5782,'Tallum Boots','Robe','feet','true','none',1130,'blood_steel','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(5783,'Boots of Nightmare','Heavy Armor','feet','true','none',1110,'leather','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5784,'Boots of Nightmare','Light Armor','feet','true','none',1110,'leather','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5785,'Boots of Nightmare','Robe','feet','true','none',1110,'leather','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5786,'Majestic Boots','Heavy Armor','feet','true','none',1110,'blood_steel','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5787,'Majestic Boots','Light Armor','feet','true','none',1110,'blood_steel','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5788,'Majestic Boots','Robe','feet','true','none',1110,'blood_steel','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(5808,'Party Mask','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(6323,'Sealed Phoenix Necklace','','neck','true','none',150,'silver','a',0,-1,-1,0,76,0,1340000,107,'true','true','true','true','true','0-0','0-0;'),
(6324,'Sealed Phoenix Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,57,0,1005000,80,'true','true','true','true','true','0-0','0-0;'),
(6325,'Sealed Phoenix Ring','','rfinger,lfinger','true','none',150,'gold','a',0,-1,-1,0,38,0,670000,54,'true','true','true','true','true','0-0','0-0;'),
(6326,'Sealed Majestic Necklace','','neck','true','none',150,'silver','a',0,-1,-1,0,80,0,1998000,160,'true','true','true','true','true','0-0','0-0;'),
(6327,'Sealed Majestic Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,60,0,1498000,120,'true','true','true','true','true','0-0','0-0;'),
(6328,'Sealed Majestic Ring','','rfinger,lfinger','true','none',150,'silver','a',0,-1,-1,0,40,0,999000,80,'true','true','true','true','true','0-0','0-0;'),
(6373,'Imperial Crusader Breastplate','','chest','true','heavy',7620,'scale_of_dragon','s',0,-1,-1,205,0,0,12781000,613,'true','true','true','true','true','0-0','0-0;'),
(6374,'Imperial Crusader Gaiters','','legs','true','heavy',3260,'scale_of_dragon','s',0,-1,-1,128,0,0,7988000,383,'true','true','true','true','true','0-0','0-0;'),
(6375,'Imperial Crusader Gauntlets','','gloves','true','none',540,'leather','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(6376,'Imperial Crusader Boots','','feet','true','none',1110,'leather','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(6378,'Imperial Crusader Helmet','','head','true','none',550,'bone','s',0,-1,-1,83,0,0,4793000,230,'true','true','true','true','true','0-0','0-0;'),
(6379,'Draconic Leather Armor','','fullarmor','true','light',4950,'leather','s',0,-1,-1,249,0,0,15577000,748,'true','true','true','true','true','0-0','0-0;'),
(6380,'Draconic Leather Gloves','','gloves','true','none',540,'leather','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(6381,'Draconic Leather Boots','','feet','true','none',1110,'leather','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(6382,'Draconic Leather Helmet','','head','true','none',550,'bone','s',0,-1,-1,83,0,0,4793000,230,'true','true','true','true','true','0-0','0-0;'),
(6383,'Major Arcana Robe','','fullarmor','true','magic',2300,'cloth','s',0,-1,-1,166,0,866,15577000,748,'true','true','true','true','true','0-0','0-0;'),
(6384,'Major Arcana Gloves','','gloves','true','none',540,'leather','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(6385,'Major Arcana Boots','','feet','true','none',1110,'leather','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(6386,'Major Arcana Circlet','','head','true','none',550,'bone','s',0,-1,-1,83,0,0,4793000,230,'true','true','true','true','true','0-0','0-0;'),
(6394,'Red Party Mask','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(6408,'Formal Wear','','fullarmor','false','heavy',1000,'cloth','none',0,-1,-1,0,0,0,5000000,0,'true','true','true','true','true','0-0','0-0;'),
(6656,'Earring of Antharas','','rear,lear','true','none',150,'gold','s',0,-1,-1,0,71,31,3700000,178,'true','true','true','true','true','0-0','3558-1;'),
(6657,'Necklace of Valakas','','neck','true','none',150,'gold','s',0,-1,-1,0,95,42,4940000,237,'true','true','true','true','true','0-0','3557-1;'),
(6658,'Ring of Baium','','rfinger,lfinger','true','none',150,'gold','s',0,-1,-1,0,48,21,1730000,83,'true','true','true','true','true','0-0','3561-1;'),
(6659,'Zaken\'s Earring','','rear,lear','true','none',150,'gold','s',0,-1,-1,0,71,31,2590000,124,'true','true','true','true','true','0-0','3559-1;'),
(6660,'Ring of Queen Ant','','rfinger,lfinger','true','none',150,'gold','b',0,-1,-1,0,48,21,616000,82,'true','true','true','true','true','0-0','3562-1;'),
(6661,'Earring of Orfen','','rear,lear','true','none',150,'gold','a',0,-1,-1,0,71,31,1300000,104,'true','true','true','true','true','0-0','3560-1;'),
(6662,'Ring of Core','','rfinger,lfinger','true','none',150,'gold','a',0,-1,-1,0,48,21,870000,69,'true','true','true','true','true','0-0','3563-1;'),
(6674,'Sealed Imperial Crusader Breastplate','','chest','true','heavy',7620,'scale_of_dragon','s',0,-1,-1,193,0,0,12781000,613,'true','true','true','true','true','0-0','0-0;'),
(6675,'Sealed Imperial Crusader Gaiters','','legs','true','heavy',3260,'scale_of_dragon','s',0,-1,-1,121,0,0,7988000,383,'true','true','true','true','true','0-0','0-0;'),
(6676,'Sealed Imperial Crusader Gauntlet','','gloves','true','none',540,'leather','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(6677,'Sealed Imperial Crusader Boots','','feet','true','none',1110,'leather','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(6679,'Sealed Imperial Crusader Helmet','','head','true','none',550,'bone','s',0,-1,-1,83,0,0,4793000,230,'true','true','true','true','true','0-0','0-0;'),
(6680,'Sealed Draconic Leather Armor','','fullarmor','true','light',4950,'leather','s',0,-1,-1,236,0,0,15577000,748,'true','true','true','true','true','0-0','0-0;'),
(6681,'Sealed Draconic Leather Glove','','gloves','true','none',540,'leather','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(6682,'Sealed Draconic Leather Boots','','feet','true','none',1110,'leather','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(6683,'Sealed Draconic Leather Helmet','','head','true','none',550,'bone','s',0,-1,-1,83,0,0,4793000,230,'true','true','true','true','true','0-0','0-0;'),
(6684,'Sealed Major Arcana Robe','','fullarmor','true','magic',2300,'cloth','s',0,-1,-1,157,0,866,15577000,748,'true','true','true','true','true','0-0','0-0;'),
(6685,'Sealed Major Arcana Glove','','gloves','true','none',540,'leather','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(6686,'Sealed Major Arcana Boots','','feet','true','none',1110,'leather','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(6687,'Sealed Major Arcana Circlet','','head','true','none',550,'bone','s',0,-1,-1,83,0,0,4793000,230,'true','true','true','true','true','0-0','0-0;'),
(6724,'Sealed Tateossian Earring','','rear,lear','true','none',150,'silver','s',0,-1,-1,0,68,0,3270000,157,'true','true','true','true','true','0-0','0-0;'),
(6725,'Sealed Tateossian Ring','','rfinger,lfinger','true','none',150,'gold','s',0,-1,-1,0,46,0,2180000,105,'true','true','true','true','true','0-0','0-0;'),
(6726,'Sealed Tateossian Necklace','','neck','true','none',150,'silver','s',0,-1,-1,0,91,0,4361000,209,'true','true','true','true','true','0-0','0-0;'),
(6834,'Circlet of Innadril','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','false','true','false','true','0-0','3633-1;'),
(6835,'Circlet of Dion','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','false','true','false','true','0-0','3633-1;'),
(6836,'Circlet of Goddard','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','false','true','false','true','0-0','3633-2;'),
(6837,'Circlet of Oren','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','false','true','false','true','0-0','3633-1;'),
(6838,'Circlet of Gludio','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','false','true','false','true','0-0','3633-1;'),
(6839,'Circlet of Giran','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','false','true','false','true','0-0','3633-1;'),
(6840,'Circlet of Aden','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','false','true','false','true','0-0','3633-2;'),
(6841,'The Lord\'s Crown','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3632-1;3633-2;'),
(6842,'Wings of Destiny Circlet','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(6843,'Cat Ear','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(6844,'Lady\'s Hair Pin','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(6845,'Pirate\'s Eye Patch','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(6846,'Monocle','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(7059,'Golden Festival Mask','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(7060,'Tateossian Hairband','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','false','true','true','true','0-0','0-0;'),
(7680,'Raccoon Ears','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(7681,'Outlaw\'s Eyepatch','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(7682,'Maiden\'s Hairpin','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(7683,'Rabbit Ears','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(7694,'Noblesse Tiara','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(7695,'Forget-me-not Hairpin','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(7696,'Daisy Hairpin','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(7836,'Santa\'s Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','false','true','true','true','0-0','0-0;'),
(7837,'Sayha\'s White Mask','','face','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'false','false','true','true','true','0-0','0-0;'),
(7839,'Gran Kain\'s Black Mask','','face','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'false','false','true','true','true','0-0','0-0;'),
(7840,'Rabbit Ears (Event)','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(7841,'Racoon Ears (Event)','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(7842,'Cat Ears (Event)','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(7843,'Pirate\'s Eyepatch (Event)','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(7844,'Monocle (Event)','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(7845,'Outlaw\'s Eyepatch (Event)','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(7846,'Lady\'s Hairpin (Event)','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(7847,'Noblewoman\'s Hairpin (Event)','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(7848,'Forget-me-not Hairpin (Event)','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(7849,'Daisy Hairpin (Event)','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(7850,'Clan Oath Helm','','head','true','none',640,'fine_steel','d',0,-1,-1,37,0,0,58600,108,'true','true','true','true','true','0-0','0-0;'),
(7851,'Clan Oath Armor','','fullarmor','true','heavy',9870,'fine_steel','d',0,-1,-1,158,0,0,253900,469,'true','true','true','true','true','0-0','0-0;'),
(7852,'Clan Oath Gauntlets','Heavy Armor','gloves','true','none',640,'fine_steel','d',0,-1,-1,24,0,0,39100,72,'true','true','true','true','true','0-0','0-0;'),
(7853,'Clan Oath Sabaton','Heavy Armor','feet','true','none',1280,'fine_steel','d',0,-1,-1,24,0,0,39100,72,'true','true','true','true','true','0-0','0-0;'),
(7854,'Clan Oath Brigandine','','fullarmor','true','light',5400,'leather','d',0,-1,-1,119,0,0,190400,352,'true','true','true','true','true','0-0','0-0;'),
(7855,'Clan Oath Leather Gloves','Light Armor','gloves','true','none',640,'leather','d',0,-1,-1,24,0,0,39100,72,'true','true','true','true','true','0-0','0-0;'),
(7856,'Clan Oath Boots','Light Armor','feet','true','none',1280,'leather','d',0,-1,-1,24,0,0,39100,72,'true','true','true','true','true','0-0','0-0;'),
(7857,'Clan Oath Aketon','','fullarmor','true','magic',2450,'cloth','d',0,-1,-1,79,0,239,190400,357,'true','true','true','true','true','0-0','0-0;'),
(7858,'Clan Oath Padded Gloves','Robe','gloves','true','none',640,'cloth','d',0,-1,-1,24,0,0,39100,72,'true','true','true','true','true','0-0','0-0;'),
(7859,'Clan Oath Sandals','Robe','feet','true','none',1280,'cloth','d',0,-1,-1,24,0,0,39100,72,'true','true','true','true','true','0-0','0-0;'),
(7860,'Apella Helm','','head','true','none',570,'fine_steel','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','0-0;'),
(7861,'Apella Plate Armor','','fullarmor','true','heavy',9780,'leather','a',0,-1,-1,278,0,0,5788000,463,'true','true','true','true','true','0-0','0-0;'),
(7862,'Apella Gauntlet','Heavy Armor','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(7863,'Apella Solleret','Heavy Armor','feet','true','none',1130,'blood_steel','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(7864,'Apella Brigandine','','fullarmor','true','light',5400,'leather','a',0,-1,-1,209,0,0,4341000,347,'true','true','true','true','true','0-0','0-0;'),
(7865,'Apella Leather Gloves','Light Armor','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(7866,'Apella Boots','Light Armor','feet','true','none',1130,'blood_steel','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(7867,'Apella Doublet','','fullarmor','true','magic',2450,'leather','a',0,-1,-1,139,0,665,4341000,347,'true','true','true','true','true','0-0','0-0;'),
(7868,'Apella Silk Gloves','Robe','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(7869,'Apella Sandals','Robe','feet','true','none',1130,'blood_steel','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(7870,'Sealed Apella Helm','','head','true','none',570,'cloth','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','0-0;'),
(7871,'Sealed Apella Plate Armor','','fullarmor','true','heavy',9780,'leather','a',0,-1,-1,278,0,0,5788000,463,'true','true','true','true','true','0-0','0-0;'),
(7872,'Sealed Apella Gauntlet','','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(7873,'Sealed Apella Solleret','','feet','true','none',1130,'blood_steel','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(7874,'Sealed Apella Brigandine','','fullarmor','true','light',5400,'leather','a',0,-1,-1,209,0,0,4341000,347,'true','true','true','true','true','0-0','0-0;'),
(7875,'Sealed Apella Leather Gloves','','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(7876,'Sealed Apella Boots','','feet','true','none',1130,'blood_steel','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(7877,'Sealed Apella Doublet','','fullarmor','true','magic',2450,'leather','a',0,-1,-1,139,0,665,4341000,347,'true','true','true','true','true','0-0','0-0;'),
(7878,'Sealed Apella Silk Gloves','','gloves','true','none',580,'leather','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(7879,'Sealed Apella Sandals','','feet','true','none',1130,'blood_steel','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(8177,'Raid Challenger\'s Circlet','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(8178,'Raid Adventurer\'s Circlet','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(8179,'Raid Master\'s Circlet','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(8180,'Circlet of Ice Fairy Sirra','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(8181,'Academy Circlet','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'false','false','true','false','true','0-0','0-0;'),
(8182,'Circlet of Rune','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','false','true','false','true','0-0','3633-2;'),
(8183,'Circlet of Schuttgart','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','false','true','false','true','0-0','3633-2;'),
(8184,'Party Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(8185,'Feathered Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(8186,'Artisan\'s Goggles','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(8187,'Demon Horns','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8188,'Little Angel Wings','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(8189,'Fairy Antennae','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(8191,'Frintezza\'s Necklace','','neck','true','none',150,'gold','a',0,-1,-1,0,95,42,3450000,230,'true','true','true','true','true','0-0','3604-1;'),
(8541,'Little Harness','','babypet','false','light',160,'leather','none',0,-1,-1,10,25,0,200000,0,'true','true','true','true','true','0-0','0-0;'),
(8552,'Mask of Spirits','','face','false','none',10,'paper','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8557,'Blue Party Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8558,'Eva\'s Mark (Event)','','face','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(8559,'Diadem','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8560,'Teddy Bear Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8561,'Piggy Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8562,'Jester Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8563,'Wizard Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8564,'Dapper Cap','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8565,'Romantic Chapeau','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8566,'Iron Circlet','','face','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(8567,'Valakas Slayer Circlet','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8568,'Antharas Slayer Circlet','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8569,'Half Face Mask','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8660,'Demon Horns','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8661,'Mask of Spirits','','face','false','none',10,'paper','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8662,'Fairy Antennae (Event)','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(8910,'Black Feather Mask (Event)','','hairall','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(8911,'Black Half-Mask (Event)','','face','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8912,'Single Stem Flower','','hair','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8913,'Butterfly Hairpin','','hair','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8914,'Luxurious Gold Circlet','','hairall','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8915,'Luxurious Silver Circlet','','hairall','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8916,'Eye Patch','','face','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8917,'Goddess Circlet','','hairall','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8918,'Leather Cap','','hairall','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8919,'First Mate\'s Hat','','hairall','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(8920,'Angel Halo','','hairall','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8921,'Demon Circlet','','hairall','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8922,'Pirate Hat','','hairall','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8923,'Scar','','face','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8936,'Santa\'s Antlers','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8947,'L2 Day: Rabbit Ears','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8948,'L2 Day: Little Angel Wings','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8949,'L2 Day: Fairy Antennae','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8950,'L2 Day: Feathered Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(8951,'L2 Day: Artisan\'s Goggles','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9030,'Shadow Item: Bronze Breastplate','','chest','false','heavy',2973,'bronze','none',0,600,-1,68,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9031,'Shadow Item: Bronze Gaiters','','legs','false','heavy',1320,'bronze','none',0,600,-1,43,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9032,'Shadow Item: Hard Leather Shirt','','chest','false','light',1573,'leather','none',0,600,-1,53,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9033,'Shadow Item: Hard Leather Gaiters','','legs','false','light',537,'leather','none',0,600,-1,33,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9034,'Shadow Item: Tunic of Magic','','chest','false','magic',693,'cloth','none',0,600,-1,34,0,86,0,0,'false','false','true','false','true','0-0','0-0;'),
(9035,'Shadow Item: Stockings of Magic','','legs','false','magic',343,'cloth','none',0,600,-1,21,0,54,0,0,'false','false','true','false','true','0-0','0-0;'),
(9037,'Shadow Item: Hard Leather Helmet','','head','false','none',213,'leather','none',0,600,-1,26,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9038,'Shadow Item: Boots','','feet','false','none',437,'cloth','none',0,600,-1,17,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9039,'Shadow Item: Bracer','','gloves','false','none',217,'leather','none',0,600,-1,17,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9040,'Shadow Item: Mithril Breastplate','','chest','false','heavy',2890,'mithril','d',0,600,-1,95,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9041,'Shadow Item: Mithril Gaiters','','legs','false','heavy',1277,'mithril','d',0,600,-1,61,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9042,'Shadow Item: Gauntlet','','gloves','false','none',213,'cloth','d',0,600,-1,24,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9043,'Shadow Item: Iron Boots','','feet','false','none',427,'fine_steel','d',0,600,-1,24,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9045,'Shadow Item: Reinforced Leather Shirt','','chest','false','light',1523,'leather','d',0,600,-1,73,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9046,'Shadow Item: Reinforced Leather Gaiters','','legs','false','light',523,'leather','d',0,600,-1,46,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9047,'Shadow Item: Reinforced Leather Gloves','','gloves','false','none',213,'leather','d',0,600,-1,24,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9048,'Shadow Item: Reinforced Leather Boots','','feet','false','none',427,'leather','d',0,600,-1,24,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9049,'Shadow Item: Tunic of Knowledge','','chest','false','magic',673,'cloth','d',0,600,-1,49,0,147,0,0,'false','false','true','false','true','0-0','0-0;'),
(9050,'Shadow Item: Stockings of Knowledge','','legs','false','magic',333,'cloth','d',0,600,-1,30,0,92,0,0,'false','false','true','false','true','0-0','0-0;'),
(9051,'Shadow Item: Gloves of Knowledge','','gloves','false','none',213,'leather','d',0,600,-1,24,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9052,'Shadow Item: Boots of Knowledge','','feet','false','none',423,'leather','d',0,600,-1,24,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9053,'Shadow Item: Helmet','','head','false','none',213,'fine_steel','d',0,600,-1,37,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9054,'Shadow Item: Composite Armor','','fullarmor','false','heavy',3660,'fine_steel','c',0,600,-1,224,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9055,'Shadow Item: Composite Boots','','feet','false','none',407,'fine_steel','c',0,600,-1,36,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9057,'Shadow Item: Composite Helmet','','head','false','none',203,'fine_steel','c',0,600,-1,54,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9058,'Shadow Item: Theca Leather Armor','','chest','false','light',1457,'leather','c',0,600,-1,106,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9059,'Shadow Item: Theca Leather Gaiters','','legs','false','light',510,'leather','c',0,600,-1,66,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9060,'Shadow Item: Theca Leather Boots','','feet','false','none',403,'leather','c',0,600,-1,37,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9061,'Shadow Item: Theca Leather Gloves','','gloves','false','none',200,'leather','c',0,600,-1,37,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9062,'Shadow Item: Demon\'s Tunic','','chest','false','magic',663,'cloth','c',0,600,-1,69,0,284,0,0,'false','false','true','false','true','0-0','0-0;'),
(9063,'Shadow Item: Demon\'s Stockings','','legs','false','magic',327,'cloth','c',0,600,-1,43,0,177,0,0,'false','false','true','false','true','0-0','0-0;'),
(9064,'Shadow Item: Demon\'s Boots','','feet','false','none',407,'leather','c',0,600,-1,36,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9065,'Shadow Item: Demon\'s Gloves','','gloves','false','none',203,'leather','c',0,600,-1,36,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9066,'Shadow Item: Shining Circlet','','head','false','none',200,'steel','c',0,600,-1,54,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9067,'Shadow Item: Zubei\'s Breastplate','','chest','false','heavy',2657,'mithril','b',0,600,-1,157,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9068,'Shadow Item: Zubei\'s Gaiters','','legs','false','heavy',1190,'mithril','b',0,600,-1,98,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9069,'Shadow Item: Zubei\'s Helmet','','head','false','none',197,'mithril','b',0,600,-1,62,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9071,'Shadow Item: Zubei\'s Gauntlet','','gloves','false','none',197,'mithril','b',0,600,-1,41,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9072,'Shadow Item: Zubei\'s Boots','','feet','false','none',393,'mithril','b',0,600,-1,41,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9073,'Shadow Item: Zubei\'s Leather Shirt','','chest','false','light',1443,'leather','b',0,600,-1,117,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9074,'Shadow Item: Zubei\'s Leather Gaiters','','legs','false','light',493,'leather','b',0,600,-1,73,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9075,'Shadow Item: Zubei\'s Gauntlet','','gloves','false','none',197,'mithril','b',0,600,-1,41,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9076,'Shadow Item: Zubei\'s Boots','','feet','false','none',393,'mithril','b',0,600,-1,41,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9077,'Shadow Item: Tunic of Zubei','','chest','false','magic',653,'leather','b',0,600,-1,78,0,345,0,0,'false','false','true','false','true','0-0','0-0;'),
(9078,'Shadow Item: Stockings of Zubei','','legs','false','magic',313,'leather','b',0,600,-1,49,0,216,0,0,'false','false','true','false','true','0-0','0-0;'),
(9079,'Shadow Item: Zubei\'s Gauntlet','','gloves','false','none',197,'mithril','b',0,600,-1,41,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9080,'Shadow Item: Zubei\'s Boots','','feet','false','none',393,'mithril','b',0,600,-1,41,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9081,'Shadow Item: Dark Crystal Breastplate','','chest','false','heavy',2567,'crystal','a',0,600,-1,171,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9082,'Shadow Item: Dark Crystal Gaiters','','legs','false','heavy',1107,'crystal','a',0,600,-1,107,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9083,'Shadow Item: Dark Crystal Helmet','','head','false','none',190,'crystal','a',0,600,-1,69,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9085,'Shadow Item: Dark Crystal Gloves','','gloves','false','none',193,'leather','a',0,600,-1,46,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9086,'Shadow Item: Dark Crystal Boots','','feet','false','none',370,'crystal','a',0,600,-1,46,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9087,'Shadow Item: Dark Crystal Leather Armor','','chest','true','light',1433,'leather','a',0,600,-1,128,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9088,'Shadow Item: Dark Crystal Leggings','','legs','true','light',493,'leather','a',0,600,-1,80,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9089,'Shadow Item: Dark Crystal Gloves','','gloves','true','none',193,'leather','a',0,600,-1,46,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9090,'Shadow Item: Dark Crystal Boots','','feet','true','none',370,'crystal','a',0,600,-1,46,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9091,'Shadow Item: Dark Crystal Robe','','fullarmor','false','magic',817,'leather','a',0,600,-1,139,0,665,0,0,'false','false','true','false','true','0-0','0-0;'),
(9092,'Shadow Item: Dark Crystal Gloves','','gloves','false','none',193,'leather','a',0,600,-1,46,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9093,'Shadow Item: Dark Crystal Boots','','feet','false','none',370,'crystal','a',0,600,-1,46,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9094,'Shadow Item: Majestic Plate Armor','','fullarmor','false','heavy',3067,'leather','a',0,600,-1,293,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9095,'Shadow Item: Majestic Circlet','','head','false','none',183,'leather','a',0,600,-1,73,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9096,'Shadow Item: Majestic Gauntlet','','gloves','false','none',180,'leather','a',0,600,-1,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9097,'Shadow Item: Majestic Boots','','feet','false','none',370,'blood_steel','a',0,600,-1,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9098,'Shadow Item: Majestic Leather Armor','','fullarmor','false','light',1783,'leather','a',0,600,-1,220,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9099,'Shadow Item: Majestic Gauntlet','','gloves','false','none',180,'leather','a',0,600,-1,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9100,'Shadow Item: Majestic Boots','','feet','false','none',370,'blood_steel','a',0,600,-1,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9101,'Shadow Item: Majestic Robe','','fullarmor','false','magic',777,'leather','a',0,600,-1,147,0,718,0,0,'false','false','true','false','true','0-0','0-0;'),
(9102,'Shadow Item: Majestic Gauntlet','','gloves','false','none',180,'leather','a',0,600,-1,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9103,'Shadow Item: Majestic Boots','','feet','false','none',370,'blood_steel','a',0,600,-1,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9128,'Shadow Item: Mithril Gauntlet','','gloves','false','none',200,'mithril','c',0,600,-1,36,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9138,'Santa\'s Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9145,'Little Angel Wings (Event)','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9158,'Golden Circlet of Redemption','','hairall','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9159,'Silver Circlet of Salvation','','hairall','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9160,'Pig Wrangler\'s Cap','','hairall','false','none',10,'steel','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9177,'Shadow Item - Teddy Bear Hat','Resurrection','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3160-5;'),
(9178,'Shadow Item - Piggy Hat','Resurrection','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3160-5;'),
(9179,'Shadow Item - Jester Hat','Resurrection','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3160-5;'),
(9180,'Shadow Item - Wizard Hat','Resurrection','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3160-5;'),
(9181,'Shadow Item - Dapper Cap','Resurrection','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3160-5;'),
(9182,'Shadow Item - Romantic Chapeau','Resurrection','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3160-5;'),
(9183,'Shadow Item - Iron Circlet','Resurrection','face','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3160-5;'),
(9184,'Shadow Item - Teddy Bear Hat','Escape','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3146-1;'),
(9185,'Shadow Item - Piggy Hat','Escape','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3146-1;'),
(9186,'Shadow Item - Jester Hat','Escape','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3146-1;'),
(9187,'Shadow Item - Wizard Hat','Escape','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3146-1;'),
(9188,'Shadow Item - Dapper Cap','Escape','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3146-1;'),
(9189,'Shadow Item - Romantic Chapeau','Escape','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3146-1;'),
(9190,'Shadow Item - Iron Circlet','Escape','face','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3146-1;'),
(9191,'Shadow Item - Teddy Bear Hat','Big Head','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3203-1;'),
(9192,'Shadow Item - Piggy Hat','Big Head','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3203-1;'),
(9193,'Shadow Item - Jester Hat','Big Head','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3203-1;'),
(9194,'Shadow Item - Wizard Hat','Big Head','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3203-1;'),
(9195,'Shadow Item - Dapper Cap','Big Head','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3203-1;'),
(9196,'Shadow Item - Romantic Chapeau','Big Head','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3203-1;'),
(9197,'Shadow Item - Iron Circlet','Big Head','face','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3203-1;'),
(9198,'Shadow Item - Teddy Bear Hat','Firework','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3156-1;'),
(9199,'Shadow Item - Piggy Hat','Firework','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3156-1;'),
(9200,'Shadow Item - Jester Hat','Firework','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3156-1;'),
(9201,'Shadow Item - Wizard Hat','Firework','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3156-1;'),
(9202,'Shadow Item - Dapper Cap','Firework','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3156-1;'),
(9203,'Shadow Item - Romantic Chapeau','Firework','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3156-1;'),
(9204,'Shadow Item - Iron Circlet','Firework','face','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3156-1;'),
(9208,'Phantom Mask (Event)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9391,'Human Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9392,'Elven Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9393,'Dark Elven Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9394,'Orcish Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9395,'Dwarven Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9396,'Kamaelic Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9397,'Shield Master Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9398,'Bard Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9399,'Force Master Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9400,'Weapon Master Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9401,'Dagger Master Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9402,'Bow Master Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9403,'Wizard Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9404,'Summoner Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9405,'Healer Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9406,'Enchanter Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9407,'Weapon Master Circlet (Kamael only)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9408,'Bow Master Circlet (Kamael only)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9409,'Black Phantom Mask (Event)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9410,'Human Veteran\'s Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9411,'Elven Veteran\'s Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9412,'Dark Elven Veteran\'s Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9413,'Orcish Veteran\'s Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9414,'Dwarf Veteran\'s Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9415,'Kamaelic Veteran\'s Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9416,'Dynasty Breast Plate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'true','true','true','true','true','0-0','0-0;'),
(9417,'Dynasty Breast Plate','Shield Master','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'true','true','true','true','true','0-0','0-0;'),
(9418,'Dynasty Breast Plate','Weapon Master','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'true','true','true','true','true','0-0','0-0;'),
(9419,'Dynasty Breast Plate','Force Master','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'true','true','true','true','true','0-0','0-0;'),
(9420,'Dynasty Breast Plate','Bard','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'true','true','true','true','true','0-0','0-0;'),
(9421,'Dynasty Gaiter','','legs','true','heavy',3210,'wood','s80',0,-1,-1,141,0,0,15248000,731,'true','true','true','true','true','0-0','0-0;'),
(9422,'Dynasty Helmet','','head','true','none',530,'wood','s80',0,-1,-1,92,0,0,9149000,439,'true','true','true','true','true','0-0','0-0;'),
(9423,'Dynasty Gauntlet','Heavy Armor','gloves','true','none',520,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(9424,'Dynasty Boots','Heavy Armor','feet','true','none',1090,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(9425,'Dynasty Leather Armor','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(9426,'Dynasty Leather Armor','Dagger Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(9427,'Dynasty Leather Armor','Bow Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(9428,'Dynasty Leather Leggings','','legs','true','light',1370,'wood','s80',0,-1,-1,106,0,0,11436000,549,'true','true','true','true','true','0-0','0-0;'),
(9429,'Dynasty Leather Helmet','','head','true','none',530,'wood','s80',0,-1,-1,92,0,0,9149000,439,'true','true','true','true','true','0-0','0-0;'),
(9430,'Dynasty Leather Gloves','Light Armor','gloves','true','none',520,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(9431,'Dynasty Leather Boots','Light Armor','feet','true','none',1090,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(9432,'Dynasty Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(9433,'Dynasty Tunic','Healer','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(9434,'Dynasty Tunic','Enchanter','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(9435,'Dynasty Tunic','Summoner','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(9436,'Dynasty Tunic','Wizard','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(9437,'Dynasty Stockings','','legs','true','magic',860,'wood','s80',0,-1,-1,71,0,370,11436000,549,'true','true','true','true','true','0-0','0-0;'),
(9438,'Dynasty Circlet','','head','true','none',530,'wood','s80',0,-1,-1,92,0,0,9149000,439,'true','true','true','true','true','0-0','0-0;'),
(9439,'Dynasty Gloves','Robe','gloves','true','none',520,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(9440,'Dynasty Shoes','Robe','feet','true','none',1090,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(9452,'Sealed Dynasty Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,71,0,4032000,194,'true','true','true','true','true','0-0','0-0;'),
(9453,'Sealed Dynasty Necklace','','neck','true','none',150,'wood','s80',0,-1,-1,0,95,0,5376000,258,'true','true','true','true','true','0-0','0-0;'),
(9454,'Sealed Dynasty Ring','','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,53,0,2688000,129,'true','true','true','true','true','0-0','0-0;'),
(9455,'Dynasty Earrings','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,79,35,5956000,285,'true','true','true','true','true','0-0','0-0;'),
(9456,'Dynasty Necklace','','neck','true','none',150,'wood','s80',0,-1,-1,0,106,46,7942000,381,'true','true','true','true','true','0-0','0-0;'),
(9457,'Dynasty Ring','','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,60,23,3971000,190,'true','true','true','true','true','0-0','0-0;'),
(9458,'Dynasty Earrings','Stun Resistance','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,27,35,5956000,285,'true','true','true','true','true','0-0','3367-1;'),
(9459,'Dynasty Necklace','Stun Resistance','neck','true','none',150,'wood','s80',0,-1,-1,0,36,46,7942000,381,'true','true','true','true','true','0-0','3365-1;'),
(9460,'Dynasty Ring','Stun Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,18,23,3971000,190,'true','true','true','true','true','0-0','3366-1;'),
(9461,'Dynasty Earrings','Poison Resistance','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,27,35,5956000,285,'true','true','true','true','true','0-0','3379-1;'),
(9462,'Dynasty Necklace','Poison Resistance','neck','true','none',150,'wood','s80',0,-1,-1,0,36,46,7942000,381,'true','true','true','true','true','0-0','3377-1;'),
(9463,'Dynasty Ring','Poison Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,18,23,3971000,190,'true','true','true','true','true','0-0','3378-1;'),
(9464,'Dynasty Earrings','Bleeding Resistance','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,27,35,5956000,285,'true','true','true','true','true','0-0','3373-1;'),
(9465,'Dynasty Necklace','Bleeding Resistance','neck','true','none',150,'wood','s80',0,-1,-1,0,36,46,7942000,381,'true','true','true','true','true','0-0','3371-1;'),
(9466,'Dynasty Ring','Bleeding Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,18,23,3971000,190,'true','true','true','true','true','0-0','3372-1;'),
(9467,'Dynasty Earrings','Sleep Resistance','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,27,35,5956000,285,'true','true','true','true','true','0-0','3397-1;'),
(9468,'Dynasty Necklace','Sleep Resistance','neck','true','none',150,'wood','s80',0,-1,-1,0,36,46,7942000,381,'true','true','true','true','true','0-0','3395-1;'),
(9469,'Dynasty Ring','Sleep Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,18,23,3971000,190,'true','true','true','true','true','0-0','3396-1;'),
(9470,'Dynasty Earrings','Paralysis Resistance','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,27,35,5956000,285,'true','true','true','true','true','0-0','3385-1;'),
(9471,'Dynasty Necklace','Paralysis Resistance','neck','true','none',150,'wood','s80',0,-1,-1,0,36,46,7942000,381,'true','true','true','true','true','0-0','3383-1;'),
(9472,'Dynasty Ring','Paralysis Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,18,23,3971000,190,'true','true','true','true','true','0-0','3384-1;'),
(9473,'Dynasty Earrings','Hold Resistance','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,27,35,5956000,285,'true','true','true','true','true','0-0','3391-1;'),
(9474,'Dynasty Necklace','Hold Resistance','neck','true','none',150,'wood','s80',0,-1,-1,0,36,46,7942000,381,'true','true','true','true','true','0-0','3389-1;'),
(9475,'Dynasty Ring','Hold Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,18,23,3971000,190,'true','true','true','true','true','0-0','3390-1;'),
(9476,'Dynasty Earrings','Fear Resistance','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,27,35,5956000,285,'true','true','true','true','true','0-0','3403-1;'),
(9477,'Dynasty Necklace','Fear Resistance','neck','true','none',150,'wood','s80',0,-1,-1,0,36,46,7942000,381,'true','true','true','true','true','0-0','3401-1;'),
(9478,'Dynasty Ring','Fear Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,18,23,3971000,190,'true','true','true','true','true','0-0','3402-1;'),
(9479,'Dynasty Earrings (not used)','Darkness Resistance','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,27,35,5956000,285,'true','true','true','true','true','0-0','0-0;'),
(9480,'Dynasty Necklace (not used)','Darkness Resistance','neck','true','none',150,'wood','s80',0,-1,-1,0,36,46,7942000,381,'true','true','true','true','true','0-0','0-0;'),
(9481,'Dynasty Ring (not used)','Darkness Resistance','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,18,23,3971000,190,'true','true','true','true','true','0-0','0-0;'),
(9514,'Sealed Dynasty Breast Plate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,214,0,0,24398000,1171,'true','true','true','true','true','0-0','0-0;'),
(9515,'Sealed Dynasty Gaiter','','legs','true','heavy',3210,'wood','s80',0,-1,-1,134,0,0,15248000,731,'true','true','true','true','true','0-0','0-0;'),
(9516,'Sealed Dynasty Helmet','','head','true','none',530,'wood','s80',0,-1,-1,92,0,0,9149000,439,'true','true','true','true','true','0-0','0-0;'),
(9517,'Sealed Dynasty Gauntlets','','gloves','true','none',520,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(9518,'Sealed Dynasty Boots','','feet','true','none',1090,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(9519,'Sealed Dynasty Leather Armor','','chest','true','light',4180,'wood','s80',0,-1,-1,161,0,0,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(9520,'Sealed Dynasty Leather Leggings','','legs','true','light',1370,'wood','s80',0,-1,-1,100,0,0,11436000,549,'true','true','true','true','true','0-0','0-0;'),
(9521,'Sealed Dynasty Leather Helmet','','head','true','none',530,'wood','s80',0,-1,-1,92,0,0,9149000,439,'true','true','true','true','true','0-0','0-0;'),
(9522,'Sealed Dynasty Leather Gloves','','gloves','true','none',520,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(9523,'Sealed Dynasty Leather Boots','','feet','true','none',1090,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(9524,'Sealed Dynasty Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,107,0,592,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(9525,'Sealed Dynasty Stockings','','legs','true','magic',860,'wood','s80',0,-1,-1,67,0,370,11436000,549,'true','true','true','true','true','0-0','0-0;'),
(9526,'Sealed Dynasty Circlet','','head','true','none',530,'wood','s80',0,-1,-1,92,0,0,9149000,439,'true','true','true','true','true','0-0','0-0;'),
(9527,'Sealed Dynasty Gloves','','gloves','true','none',520,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(9528,'Sealed Dynasty Shoes','','feet','true','none',1090,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(9577,'Cotton Shirt','','underwear','false','none',130,'wood','none',0,-1,-1,6,0,0,1300,0,'true','true','true','true','true','0-0','0-0;'),
(9578,'Linen Shirt','','underwear','true','none',130,'wood','d',0,-1,-1,12,0,0,25000,39,'true','true','true','true','true','0-0','0-0;'),
(9579,'Silk Shirt','','underwear','true','none',130,'wood','c',0,-1,-1,17,0,0,80000,27,'true','true','true','true','true','0-0','0-0;'),
(9580,'Thin Leather Shirt','','underwear','true','none',130,'wood','b',0,-1,-1,21,0,0,260000,29,'true','true','true','true','true','0-0','0-0;'),
(9581,'Scale Shirt','','underwear','true','none',130,'wood','a',0,-1,-1,23,0,0,588000,39,'true','true','true','true','true','0-0','0-0;'),
(9582,'Mithril Shirt','','underwear','true','none',130,'wood','s',0,-1,-1,28,0,0,1800000,86,'true','true','true','true','true','0-0','0-0;'),
(9583,'Striped Cotton Shirt','','underwear','false','none',130,'wood','none',0,-1,-1,8,0,0,6100,0,'true','true','true','true','true','0-0','0-0;'),
(9584,'Striped Linen Shirt','','underwear','true','none',130,'wood','d',0,-1,-1,14,0,0,49000,75,'true','true','true','true','true','0-0','0-0;'),
(9585,'Striped Silk Shirt','','underwear','true','none',130,'wood','c',0,-1,-1,19,0,0,180000,60,'true','true','true','true','true','0-0','0-0;'),
(9586,'Thin Striped Leather Shirt','','underwear','true','none',130,'wood','b',0,-1,-1,22,0,0,400000,44,'true','true','true','true','true','0-0','0-0;'),
(9587,'Striped Scale Shirt','','underwear','true','none',130,'wood','a',0,-1,-1,26,0,0,880000,59,'true','true','true','true','true','0-0','0-0;'),
(9588,'Striped Mithril Shirt','','underwear','true','none',130,'wood','s',0,-1,-1,30,0,0,2540000,122,'true','true','true','true','true','0-0','0-0;'),
(9589,'Iron Bracelet','','rbracelet','true','none',150,'wood','c',0,-1,-1,0,0,0,216000,72,'true','true','true','true','true','0-0','3322-1;'),
(9590,'Bronze Bracelet','','rbracelet','true','none',150,'wood','b',0,-1,-1,0,0,0,480000,53,'true','true','true','true','true','0-0','3323-1;'),
(9591,'Steel Bracelet','','rbracelet','true','none',150,'wood','a',0,-1,-1,0,0,0,1140000,76,'true','true','true','true','true','0-0','3324-1;'),
(9592,'Mithril Bracelet','','rbracelet','true','none',150,'wood','s',0,-1,-1,0,0,0,3556000,171,'true','true','true','true','true','0-0','3325-1;'),
(9605,'Agathion Seal Bracelet - Rainbow Clan Hall','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,7000000,0,'false','false','true','false','true','0-0','3267-1;3269-1;5414-1;'),
(9606,'Agathion Seal Bracelet - Wild Beast Reserve','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,7000000,0,'false','false','true','false','true','0-0','3267-1;3270-1;5413-1;'),
(9607,'Agathion Seal Bracelet - Gludio','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,30000000,0,'false','false','true','false','true','0-0','3267-1;3268-1;5415-1;'),
(9608,'Agathion Seal Bracelet - Dion','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,30000000,0,'false','false','true','false','true','0-0','3267-1;3268-1;5415-1;'),
(9609,'Agathion Seal Bracelet - Giran','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,30000000,0,'false','false','true','false','true','0-0','3267-1;3268-1;5415-1;'),
(9610,'Agathion Seal Bracelet - Oren','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,30000000,0,'false','false','true','false','true','0-0','3267-1;3268-1;5415-1;'),
(9611,'Agathion Seal Bracelet - Aden','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,30000000,0,'false','false','true','false','true','0-0','3267-1;3268-1;5415-1;'),
(9612,'Agathion Seal Bracelet - Innadril','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,30000000,0,'false','false','true','false','true','0-0','3267-1;3268-1;5415-1;'),
(9613,'Agathion Seal Bracelet - Goddard','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,30000000,0,'false','false','true','false','true','0-0','3267-1;3268-1;5415-1;'),
(9614,'Agathion Seal Bracelet - Rune','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,30000000,0,'false','false','true','false','true','0-0','3267-1;3268-1;5415-1;'),
(9615,'Agathion Seal Bracelet - Schuttgart','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,30000000,0,'false','false','true','false','true','0-0','3267-1;3268-1;5415-1;'),
(9662,'Great Wolf Scale Armor','','greatwolf','false','light',160,'wood','none',0,-1,-1,112,14,0,1877000,0,'true','true','true','true','true','0-0','0-0;'),
(9663,'Great Wolf Bronze Armor','','greatwolf','false','light',160,'wood','none',0,-1,-1,124,14,0,3620000,0,'true','true','true','true','true','0-0','0-0;'),
(9664,'Great Wolf Plate Armor','','greatwolf','false','light',160,'wood','none',0,-1,-1,136,14,0,7126000,0,'true','true','true','true','true','0-0','0-0;'),
(9665,'Great Wolf Mithril Armor','','greatwolf','false','light',160,'wood','none',0,-1,-1,148,14,0,12563000,0,'true','true','true','true','true','0-0','0-0;'),
(9666,'Great Wolf Oriharukon Armor','','greatwolf','false','light',160,'wood','none',0,-1,-1,160,14,0,24236000,0,'true','true','true','true','true','0-0','0-0;'),
(9667,'Great Wolf Orichalcum Armor','','greatwolf','false','light',160,'wood','none',0,-1,-1,171,14,0,48879000,0,'true','true','true','true','true','0-0','0-0;'),
(9669,'Native Helmet','','head','false','none',70,'wood','none',0,-1,-1,33,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9670,'Native Tunic','','chest','false','light',4720,'wood','none',0,-1,-1,53,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9671,'Native Pants','','legs','false','light',1700,'wood','none',0,-1,-1,29,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(9677,'Ring of Wind Mastery','','rfinger,lfinger','false','none',150,'wood','b',0,-1,-1,0,36,0,616000,0,'true','true','true','true','true','0-0','0-0;'),
(9820,'Shadow Item: Clan Oath Helm','','head','false','none',210,'wood','d',0,300,-1,37,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9821,'Shadow Item: Clan Oath Armor','','fullarmor','false','heavy',3290,'wood','d',0,300,-1,158,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9822,'Shadow Item: Clan Oath Gauntlets','Heavy Armor','gloves','false','none',210,'wood','d',0,300,-1,24,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9823,'Shadow Item: Clan Oath Sabaton','Heavy Armor','feet','false','none',430,'wood','d',0,300,-1,24,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9824,'Shadow Item: Clan Oath Brigandine','','fullarmor','false','light',1800,'wood','d',0,300,-1,119,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9825,'Shadow Item: Clan Oath Leather Gloves','Light Armor','gloves','false','none',210,'wood','d',0,300,-1,24,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9826,'Shadow Item: Clan Oath Boots','Light Armor','feet','false','none',430,'wood','d',0,300,-1,24,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9827,'Shadow Item: Clan Oath Aketon','','fullarmor','false','magic',820,'wood','d',0,300,-1,79,0,239,0,0,'false','false','true','false','true','0-0','0-0;'),
(9828,'Shadow Item: Clan Oath Padded Gloves','Robe','gloves','false','none',210,'wood','d',0,300,-1,24,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9829,'Shadow Item: Clan Oath Sandals','Robe','feet','false','none',430,'wood','d',0,300,-1,24,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9830,'Improved Apella Helm','','head','true','none',570,'wood','a',0,-1,-1,73,0,0,2030000,163,'true','true','true','true','true','0-0','0-0;'),
(9831,'Improved Apella Plate Armor','','fullarmor','true','heavy',9780,'wood','a',0,-1,-1,293,0,0,8804000,704,'true','true','true','true','true','0-0','0-0;'),
(9832,'Improved Apella Gauntlet','Heavy Armor','gloves','true','none',580,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(9833,'Improved Apella Solleret','Heavy Armor','feet','true','none',1130,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(9834,'Improved Apella Brigandine','','fullarmor','true','light',5400,'wood','a',0,-1,-1,220,0,0,6603000,526,'true','true','true','true','true','0-0','0-0;'),
(9835,'Improved Apella Leather Gloves','Light Armor','gloves','true','none',580,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(9836,'Improved Apella Boots','Light Armor','feet','true','none',1130,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(9837,'Improved Apella Doublet','','fullarmor','true','magic',2450,'wood','a',0,-1,-1,147,0,718,6603000,526,'true','true','true','true','true','0-0','0-0;'),
(9838,'Improved Apella Silk Gloves','Robe','gloves','true','none',580,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(9839,'Improved Apella Sandals','Robe','feet','true','none',1130,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(9883,'Teddy Bear Hat','Big Head','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3265-1;'),
(9884,'Piggy Hat','Big Head','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3265-1;'),
(9885,'Jester Hat','Big Head','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3265-1;'),
(9886,'Wizard Hat','Big Head','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3265-1;'),
(9887,'Dapper Cap','Big Head','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3265-1;'),
(9888,'Romantic Chapeau','Big Head','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3265-1;'),
(9889,'Iron Circlet','Big Head','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3265-1;'),
(9890,'Teddy Bear Hat','Firework','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3266-1;'),
(9891,'Piggy Hat','Firework','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3266-1;'),
(9892,'Jester Hat','Firework','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3266-1;'),
(9893,'Wizard Hat','Firework','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3266-1;'),
(9894,'Dapper Cap','Firework','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3266-1;'),
(9895,'Romantic Chapeau','Firework','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3266-1;'),
(9896,'Iron Circlet','Firework','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','3266-1;'),
(9899,'Weight Loss Ring','','rfinger,lfinger','false','none',150,'wood','none',0,-1,-1,0,24,0,25,0,'true','true','true','true','true','0-0','3406-1;'),
(9900,'Quiet Footsteps Ring','','rfinger,lfinger','false','none',150,'wood','none',0,400,-1,0,0,0,25,0,'true','true','true','true','true','0-0','0-0;'),
(9909,'Agathion Seal Bracelet','','lbracelet','false','none',150,'wood','none',0,700,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;3361-1;5458-1;'),
(9913,'Talisman_Test','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(9914,'Blue Talisman of Power','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3271-1;'),
(9915,'Blue Talisman of Wild Magic','','talisman','false','none',150,'wood','none',0,75,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3277-1;'),
(9916,'Blue Talisman of Defense','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3272-1;'),
(9917,'Red Talisman of Minimum Clarity','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3281-1;'),
(9918,'Red Talisman of Maximum Clarity','','talisman','false','none',150,'wood','none',0,74,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3282-1;'),
(9919,'Blue Talisman of Reflection','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3410-1;'),
(9920,'Blue Talisman of Invisibility','','talisman','false','none',150,'wood','none',0,64,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3280-1;'),
(9921,'Blue Talisman - Shield Protection','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3274-1;'),
(9922,'Black Talisman - Mending','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3286-1;'),
(9923,'Black Talisman - Escape','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3289-1;'),
(9924,'Blue Talisman of Healing','','talisman','false','none',150,'wood','none',0,64,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3283-1;'),
(9925,'Red Talisman of Recovery','','talisman','false','none',150,'wood','none',0,64,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3273-1;'),
(9926,'Blue Talisman of Defense','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3285-1;'),
(9927,'Blue Talisman of Magic Defense','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3276-1;'),
(9928,'Red Talisman of Mental Regeneration','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3278-1;'),
(9929,'Blue Talisman of Protection','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3275-1;'),
(9930,'Blue Talisman of Evasion','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3321-1;'),
(9931,'Red Talisman of Meditation','','talisman','false','none',150,'wood','none',0,74,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3279-1;'),
(9932,'Blue Talisman - Divine Protection','','talisman','false','none',150,'wood','none',0,74,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3284-1;'),
(9933,'Yellow Talisman of Power','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3293-1;'),
(9934,'Yellow Talisman of Violent Haste','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3301-1;'),
(9935,'Yellow Talisman of Arcane Defense','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3296-1;'),
(9936,'Yellow Talisman of Arcane Power','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3294-1;'),
(9937,'Yellow Talisman of Arcane Haste','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3302-1;'),
(9938,'Yellow Talisman of Accuracy','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3297-1;'),
(9939,'Yellow Talisman of Defense','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3295-1;'),
(9940,'Yellow Talisman of Alacrity','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3313-1;'),
(9941,'Yellow Talisman of Speed','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3300-1;'),
(9942,'Yellow Talisman of Critical Reduction','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3317-1;'),
(9943,'Yellow Talisman of Critical Power','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3299-1;'),
(9944,'Yellow Talisman of Critical Dodging','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3316-1;'),
(9945,'Yellow Talisman of Evasion','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3298-1;'),
(9946,'Yellow Talisman of Healing','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3312-1;'),
(9947,'Yellow Talisman of CP Regeneration','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3311-1;'),
(9948,'Yellow Talisman of Physical Regeneration','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3310-1;'),
(9949,'Yellow Talisman of Mental Regeneration','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3320-1;'),
(9950,'Grey Talisman of Weight Training','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3314-1;'),
(9951,'Grey Talisman of Mid-Grade Fishing','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3315-1;'),
(9952,'Orange Talisman - Hot Springs CP Potion','','talisman','false','none',150,'wood','none',0,64,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3332-1;'),
(9953,'Orange Talisman - Elixir of Life','','talisman','false','none',150,'wood','none',0,64,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3333-1;'),
(9954,'Orange Talisman - Elixir of Mental Strength','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3334-1;'),
(9955,'Black Talisman of Vocalization','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3291-1;'),
(9956,'Black Talisman of Arcane Freedom','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3288-1;'),
(9957,'Black Talisman of Physical Freedom','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3287-1;'),
(9958,'Black Talisman of Rescue','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3290-1;'),
(9959,'Black Talisman of Free Speech','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3292-1;'),
(9960,'White Talisman of Bravery','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3306-1;'),
(9961,'White Talisman of Motion','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3307-1;'),
(9962,'White Talisman of Grounding','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3305-1;'),
(9963,'White Talisman of Attention','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3304-1;'),
(9964,'White Talisman of Bandages','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3303-1;'),
(9965,'White Talisman of Protection','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3309-1;'),
(9966,'White Talisman of Freedom','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3308-1;'),
(10018,'Agathion Seal Bracelet - Fortress','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;3361-1;5458-1;'),
(10019,'Ring Mail Breastplate','','chest','false','heavy',8820,'wood','d',0,-1,-1,77,0,0,64210,151,'false','false','true','false','true','0-0','0-0;'),
(10020,'Iron Plate Gaiters','','legs','false','heavy',3820,'wood','d',0,-1,-1,48,0,0,40100,94,'false','false','true','false','true','0-0','0-0;'),
(10021,'Puma Skin Shirt','','chest','false','light',4700,'wood','d',0,-1,-1,58,0,0,48200,113,'false','false','true','false','true','0-0','0-0;'),
(10022,'Puma Skin Gaiters','','legs','false','light',1600,'wood','d',0,-1,-1,36,0,0,30100,71,'false','false','true','false','true','0-0','0-0;'),
(10023,'Cursed Tunic','','chest','false','magic',2090,'wood','d',0,-1,-1,39,0,106,48200,113,'false','false','true','false','true','0-0','0-0;'),
(10024,'Cursed Stockings','','legs','false','magic',1020,'wood','d',0,-1,-1,24,0,66,30100,71,'false','false','true','false','true','0-0','0-0;'),
(10119,'Dynasty Sigil','','lhand','true','sigil',930,'wood','s80',-8,-1,-1,15,0,0,6404000,307,'true','true','true','true','true','0-0','8311-1;'),
(10120,'Sealed Dynasty Sigil','','lhand','true','sigil',930,'wood','s80',-8,-1,-1,15,0,0,6404000,307,'true','true','true','true','true','0-0','0-0;'),
(10121,'Sealed Arcana Sigil','','lhand','true','sigil',940,'wood','s',-8,-1,-1,13,0,0,3355000,161,'true','true','true','true','true','0-0','0-0;'),
(10122,'Red Crescent Earring','','rear,lear','false','none',150,'silver','d',0,-1,-1,0,24,0,20700,48,'false','false','true','false','true','0-0','0-0;'),
(10123,'Necklace of Devotion','','neck','false','none',150,'silver','d',0,-1,-1,0,32,0,27600,65,'false','false','true','false','true','0-0','0-0;'),
(10124,'Ring of Devotion','','rfinger,lfinger','false','none',150,'gold','d',0,-1,-1,0,16,0,13800,32,'false','false','true','false','true','0-0','0-0;'),
(10126,'Dynasty Leather Armor','Force Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(10127,'Dynasty Leather Armor','Weapon Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(10139,'Agathion Bracelet','','lbracelet','false','none',150,'wood','none',0,700,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;3269-1;5414-1;'),
(10140,'Blessed Ring of Escape','','rfinger,lfinger','false','none',150,'wood','none',0,250,-1,0,24,0,0,0,'true','true','true','true','true','0-0','3408-1;'),
(10141,'Grey Talisman - Yeti Transform','','talisman','false','none',150,'wood','none',0,70,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3335-1;'),
(10142,'Grey Talisman - Buffalo Transform','','talisman','false','none',150,'wood','none',0,70,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3336-1;'),
(10158,'Grey Talisman of Upper Grade Fishing','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3315-1;'),
(10168,'Dynasty Leather Armor','Enchanter','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(10169,'Enchanter Circlet (Kamael only)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10170,'Baylor\'s Earring','','rear,lear','true','none',150,'gold','s80',0,-1,-1,0,71,31,12185000,487,'true','true','true','true','true','0-0','0-0;'),
(10175,'Goblin Circlet (Event)','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10176,'White Half Mask','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10177,'Black Half Mask','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10207,'Enhanced Striped Scale Shirt','','underwear','true','none',130,'wood','a',0,-1,-1,26,0,0,88000,59,'true','true','true','true','true','0-0','0-0;'),
(10208,'Enhanced Striped Mithril Shirt','','underwear','true','none',130,'wood','s',0,-1,-1,30,0,70,2540000,122,'true','true','true','true','true','0-0','0-0;'),
(10209,'Enhanced Steel Bracelet','','rbracelet','true','none',150,'wood','a',0,-1,-1,0,0,60,1144000,76,'true','true','true','true','true','0-0','3324-1;'),
(10210,'Enhanced Mithril Bracelet','','rbracelet','true','none',150,'wood','s',0,-1,-1,0,0,120,3556000,170,'true','true','true','true','true','0-0','3325-1;'),
(10211,'Blessed Ring of Resurrection','','rfinger,lfinger','false','none',150,'wood','none',0,180,-1,0,24,0,0,0,'true','true','true','true','true','0-0','3409-1;'),
(10214,'Dynasty Leather Armor','Summoner','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(10227,'Dynasty Platinum Plate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'true','true','true','true','true','0-0','0-0;'),
(10228,'Dynasty Platinum Plate','Shield Master','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'true','true','true','true','true','0-0','0-0;'),
(10229,'Dynasty Platinum Plate','Weapon Master','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'true','true','true','true','true','0-0','0-0;'),
(10230,'Dynasty Platinum Plate','Force Master','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'true','true','true','true','true','0-0','0-0;'),
(10231,'Dynasty Platinum Plate','Bard','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'true','true','true','true','true','0-0','0-0;'),
(10232,'Dynasty Jewel Leather Mail','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(10233,'Dynasty Jewel Leather Mail','Dagger Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(10234,'Dynasty Jewel Leather Mail','Bow Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(10235,'Dynasty Silver Satin Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(10236,'Dynasty Silver Satin Tunic','Healer','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(10237,'Dynasty Silver Satin Tunic','Enchanter','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(10238,'Dynasty Silver Satin Tunic','Summoner','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(10239,'Dynasty Silver Satin Tunic','Wizard','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(10240,'Bird Nest','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10241,'Purple Viking Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10242,'Golden Viking Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10243,'Panda Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10244,'White Sheep Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10245,'Black Sheep Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10246,'Frog Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10247,'Fish Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10248,'Straw Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10249,'Chicken Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10250,'Adventurer Hat (Event)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10251,'Medieval Party Mask','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10273,'Wolf Summoning Bracelet','','lbracelet','false','none',150,'wood','none',0,200,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10314,'Beleth\'s Ring','','rfinger,lfinger','true','none',150,'wood','s',0,-1,-1,0,48,21,2400000,152,'true','true','true','true','true','0-0','3649-1;'),
(10315,'Shadow Item - Purple Viking Circlet','','hairall','false','none',10,'wood','none',0,500,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10316,'Agathion Seal Bracelet - Little Angel','Firecracker','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3423-1;3267-1;5535-1;5538-1;'),
(10317,'Agathion Seal Bracelet - Little Angel','Big Head','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3423-1;3267-1;5535-1;5539-1;'),
(10318,'Agathion Seal Bracelet - Little Angel','Escape','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3423-1;3267-1;5535-1;5540-1;'),
(10319,'Agathion Seal Bracelet - Little Angel','Resurrection','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3423-1;3267-1;5535-1;5541-1;'),
(10320,'Agathion Seal Bracelet - Little Angel','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3423-1;3267-1;5535-1;'),
(10321,'Shadow Item - Golden Viking Circlet','','hairall','false','none',10,'wood','none',0,500,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10322,'Agathion Seal Bracelet - Little Devil','Firecracker','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3424-1;3267-1;5536-1;5542-1;'),
(10323,'Agathion Seal Bracelet - Little Devil','Big Head','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3424-1;3267-1;5536-1;5543-1;'),
(10324,'Agathion Seal Bracelet - Little Devil','Escape','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3424-1;3267-1;5536-1;5544-1;'),
(10325,'Agathion Seal Bracelet - Little Devil','Resurrection','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3424-1;3267-1;5536-1;5545-1;'),
(10326,'Agathion Seal Bracelet - Little Devil','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3424-1;3267-1;5536-1;'),
(10416,'Blue Talisman - Explosion','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3428-1;'),
(10417,'Blue Talisman - Magic Explosion','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3437-1;'),
(10418,'White Talisman - Storm','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3431-1;'),
(10419,'White Talisman - Darkness','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3430-1;'),
(10420,'White Talisman - Water','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3432-1;'),
(10421,'White Talisman - Fire','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3433-1;'),
(10422,'White Talisman - Light','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3435-1;'),
(10423,'Blue Talisman - Self-Destruction','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3436-1;'),
(10424,'Blue Talisman - Greater Healing','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3438-1;'),
(10470,'Shadow Item - Red Crescent','','rear,lear','false','none',150,'wood','d',0,180,-1,0,24,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10471,'Shadow Item - Ring of Devotion','','rfinger,lfinger','false','none',150,'wood','d',0,180,-1,0,16,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10472,'Shadow Item - Necklace of Devotion','','neck','false','none',150,'wood','d',0,180,-1,0,32,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10487,'Dynasty Jeweled Leather Armor','Force Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(10488,'Dynasty Jeweled Leather Armor','Weapon Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(10489,'Dynasty Jeweled Leather Armor','Enchanter','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(10490,'Dynasty Jeweled Leather Armor','Summoner','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(10491,'Silk Shirt','HP','underwear','true','none',130,'wood','c',0,-1,-1,17,0,0,80000,27,'true','true','true','true','true','3439-1','0-0;'),
(10492,'Silk Shirt','MP','underwear','true','none',130,'wood','c',0,-1,-1,17,0,0,80000,27,'true','true','true','true','true','3440-1','0-0;'),
(10493,'Silk Shirt','CP','underwear','true','none',130,'wood','c',0,-1,-1,17,0,0,80000,27,'true','true','true','true','true','3441-1','0-0;'),
(10494,'Thin Leather Shirt','HP','underwear','true','none',130,'wood','b',0,-1,-1,21,0,0,260000,29,'true','true','true','true','true','3445-1','0-0;'),
(10495,'Thin Leather Shirt','MP','underwear','true','none',130,'wood','b',0,-1,-1,21,0,0,260000,29,'true','true','true','true','true','3446-1','0-0;'),
(10496,'Thin Leather Shirt','CP','underwear','true','none',130,'wood','b',0,-1,-1,21,0,0,260000,29,'true','true','true','true','true','3447-1','0-0;'),
(10497,'Scale Shirt','HP','underwear','true','none',130,'wood','a',0,-1,-1,23,0,0,588000,39,'true','true','true','true','true','3451-1','0-0;'),
(10498,'Scale Shirt','MP','underwear','true','none',130,'wood','a',0,-1,-1,23,0,0,588000,39,'true','true','true','true','true','3452-1','0-0;'),
(10499,'Scale Shirt','CP','underwear','true','none',130,'wood','a',0,-1,-1,23,0,0,588000,39,'true','true','true','true','true','3453-1','0-0;'),
(10500,'Mithril Shirt','HP','underwear','true','none',130,'wood','s',0,-1,-1,28,0,0,1800000,86,'true','true','true','true','true','3457-1','0-0;'),
(10501,'Mithril Shirt','MP','underwear','true','none',130,'wood','s',0,-1,-1,28,0,0,1800000,86,'true','true','true','true','true','3458-1','0-0;'),
(10502,'Mithril Shirt','CP','underwear','true','none',130,'wood','s',0,-1,-1,28,0,0,1800000,86,'true','true','true','true','true','3459-1','0-0;'),
(10503,'Striped Silk Shirt','HP','underwear','true','none',130,'wood','c',0,-1,-1,19,0,0,180000,60,'true','true','true','true','true','3463-1','0-0;'),
(10504,'Striped Silk Shirt','MP','underwear','true','none',130,'wood','c',0,-1,-1,19,0,0,180000,60,'true','true','true','true','true','3464-1','0-0;'),
(10505,'Striped Silk Shirt','CP','underwear','true','none',130,'wood','c',0,-1,-1,19,0,0,180000,60,'true','true','true','true','true','3465-1','0-0;'),
(10506,'Thin Striped Leather Shirt','HP','underwear','true','none',130,'wood','b',0,-1,-1,22,0,0,400000,44,'true','true','true','true','true','3469-1','0-0;'),
(10507,'Thin Striped Leather Shirt','MP','underwear','true','none',130,'wood','b',0,-1,-1,22,0,0,400000,44,'true','true','true','true','true','3470-1','0-0;'),
(10508,'Thin Striped Leather Shirt','CP','underwear','true','none',130,'wood','b',0,-1,-1,22,0,0,400000,44,'true','true','true','true','true','3471-1','0-0;'),
(10509,'Striped Scale Shirt','HP','underwear','true','none',130,'wood','a',0,-1,-1,26,0,0,880000,59,'true','true','true','true','true','3475-1','0-0;'),
(10510,'Striped Scale Shirt','MP','underwear','true','none',130,'wood','a',0,-1,-1,26,0,0,880000,59,'true','true','true','true','true','3476-1','0-0;'),
(10511,'Striped Scale Shirt','CP','underwear','true','none',130,'wood','a',0,-1,-1,26,0,0,880000,59,'true','true','true','true','true','3477-1','0-0;'),
(10512,'Striped Mithril Shirt','HP','underwear','true','none',130,'wood','s',0,-1,-1,30,0,0,2540000,122,'true','true','true','true','true','3481-1','0-0;'),
(10513,'Striped Mithril Shirt','MP','underwear','true','none',130,'wood','s',0,-1,-1,30,0,0,2540000,122,'true','true','true','true','true','3482-1','0-0;'),
(10514,'Striped Mithril Shirt','CP','underwear','true','none',130,'wood','s',0,-1,-1,30,0,0,2540000,122,'true','true','true','true','true','3483-1','0-0;'),
(10518,'Red Talisman - Life Force','','talisman','false','none',150,'wood','none',0,70,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3429-1;'),
(10519,'White Talisman -  Earth','','talisman','false','none',150,'wood','none',0,80,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3434-1;'),
(10533,'Blue Talisman - Attack Power','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3487-1;'),
(10534,'Blue Talisman - Shield Defense','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3488-1;'),
(10535,'Yellow Talisman - Defense Power','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3490-1;'),
(10536,'Yellow Talisman - Magic Power','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3489-1;'),
(10537,'Yellow Talisman - Evasion','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3491-1;'),
(10538,'Yellow Talisman - Healing Power','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3495-1;'),
(10539,'Yellow Talisman - CP Recovery Rate','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3494-1;'),
(10540,'Yellow Talisman - HP Recovery Rate','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3493-1;'),
(10541,'Yellow Talisman - Low Grade MP regeneration rate','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3497-1;'),
(10542,'Red Talisman - HP/CP Recovery','','talisman','false','none',150,'wood','none',0,64,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3496-1;'),
(10543,'Yellow Talisman - Speed','','talisman','false','none',150,'wood','none',0,60,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3492-1;'),
(10606,'Agathion Seal Bracelet - Rudolph','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3425-1;3267-1;5537-1;'),
(10613,'Bird Nest (Event)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10614,'White Wool Hat (Event)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10615,'Black Wool Hat (Event)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10616,'Straw Hat (Event)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10617,'Ant Hat','Year 2008','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','true','true','0-0','0-0;'),
(10618,'Ol Mahum Hat','Year 2008','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','true','true','0-0','0-0;'),
(10619,'Wolf Hat','Year 2008','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','true','true','0-0','0-0;'),
(10620,'Shadow Item - Ant Hat','Blessed Scroll of Escape','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10621,'Shadow Item - Ant Hat','Blessed Scroll of Resurrection','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10622,'Shadow Item - Ant Hat','Firecracker','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10623,'Shadow Item - Ant Hat','Big Head','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10624,'Shadow Item - Ol Mahum Hat','Blessed Scroll of Escape','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10625,'Shadow Item - Ol Mahum Hat','Blessed Scroll of Resurrection','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10626,'Shadow Item - Ol Mahum Hat','Firecracker','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10627,'Shadow Item - Ol Mahum Hat','Big Head','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10628,'Shadow Item - Wolf Hat','Blessed Scroll of Escape','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10629,'Shadow Item - Wolf Hat','Blessed Scroll of Resurrection','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10630,'Shadow Item - Wolf Hat','Firecracker','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10631,'Shadow Item - Wolf Hat','Big Head','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(10658,'Pet Accessory (not used)','','underwear','false','none',150,'wood','none',0,-1,-1,0,7,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(10659,'Agathion Summon Bracelet - Monkey','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8254-1;3267-1;'),
(10660,'Agathion Summon Bracelet - Griffin','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8255-1;3267-1;'),
(10793,'Armor of Nightmare {PvP}','','fullarmor','true','heavy',9580,'wood','a',0,-1,-1,293,0,0,8804000,704,'false','false','true','false','true','0-0','0-0;'),
(10794,'Majestic Plate Armor {PvP}','','fullarmor','true','heavy',9200,'wood','a',0,-1,-1,293,0,0,8804000,704,'false','false','true','false','true','0-0','0-0;'),
(10795,'Nightmarish Leather Armor {PvP}','','fullarmor','true','light',5300,'wood','a',0,-1,-1,220,0,0,6603000,528,'false','false','true','false','true','0-0','0-0;'),
(10796,'Majestic Leather Armor {PvP}','','fullarmor','true','light',5350,'wood','a',0,-1,-1,220,0,0,6603000,528,'false','false','true','false','true','0-0','0-0;'),
(10797,'Robe of Nightmare {PvP}','','fullarmor','true','magic',2300,'wood','a',0,-1,-1,147,0,718,6603000,528,'false','false','true','false','true','0-0','0-0;'),
(10798,'Majestic Robe {PvP}','','fullarmor','true','magic',2330,'wood','a',0,-1,-1,147,0,718,6603000,528,'false','false','true','false','true','0-0','0-0;'),
(10799,'Imperial Crusader Breastplate {PvP}','','chest','true','heavy',7620,'wood','s',0,-1,-1,205,0,0,12781000,613,'false','false','true','false','true','0-0','0-0;'),
(10800,'Draconic Leather Armor {PvP}','','fullarmor','true','light',4950,'wood','s',0,-1,-1,249,0,0,15577000,748,'false','false','true','false','true','0-0','0-0;'),
(10801,'Major Arcana Robe {PvP}','','fullarmor','true','magic',2300,'wood','s',0,-1,-1,166,0,866,15577000,748,'false','false','true','false','true','0-0','0-0;'),
(10802,'Dynasty Breastplate {PvP}','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'false','false','true','false','true','0-0','0-0;'),
(10803,'Dynasty Breastplate {PvP}','Shield Master','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'false','false','true','false','true','0-0','0-0;'),
(10804,'Dynasty Breastplate {PvP}','Weapon Master','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'false','false','true','false','true','0-0','0-0;'),
(10805,'Dynasty Breastplate {PvP}','Force Master','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'false','false','true','false','true','0-0','0-0;'),
(10806,'Dynasty Breastplate {PvP}','Bard','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'false','false','true','false','true','0-0','0-0;'),
(10807,'Dynasty Leather Armor {PvP}','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'false','false','true','false','true','0-0','0-0;'),
(10808,'Dynasty Leather Armor {PvP}','Dagger Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'false','false','true','false','true','0-0','0-0;'),
(10809,'Dynasty Leather Armor {PvP}','Bow Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'false','false','true','false','true','0-0','0-0;'),
(10810,'Dynasty Tunic {PvP}','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'false','false','true','false','true','0-0','0-0;'),
(10811,'Dynasty Tunic {PvP}','Healer','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'false','false','true','false','true','0-0','0-0;'),
(10812,'Dynasty Tunic {PvP}','Enchanter','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'false','false','true','false','true','0-0','0-0;'),
(10813,'Dynasty Tunic {PvP}','Summoner','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'false','false','true','false','true','0-0','0-0;'),
(10814,'Dynasty Tunic {PvP}','Wizard','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'false','false','true','false','true','0-0','0-0;'),
(10815,'Dynasty Leather Armor {PvP}','Force Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'false','false','true','false','true','0-0','0-0;'),
(10816,'Dynasty Leather Armor {PvP}','Weapon Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'false','false','true','false','true','0-0','0-0;'),
(10817,'Dynasty Leather Armor {PvP}','Enchanter','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'false','false','true','false','true','0-0','0-0;'),
(10818,'Dynasty Leather Armor {PvP}','Summoner','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'false','false','true','false','true','0-0','0-0;'),
(10819,'Dynasty Platinum Breastplate {PvP}','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'false','false','true','false','true','0-0','0-0;'),
(10820,'Dynasty Platinum Breastplate {PvP}','Shield Master','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'false','false','true','false','true','0-0','0-0;'),
(10821,'Dynasty Platinum Breastplate {PvP}','Weapon Master','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'false','false','true','false','true','0-0','0-0;'),
(10822,'Dynasty Platinum Breastplate {PvP}','Force Master','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'false','false','true','false','true','0-0','0-0;'),
(10823,'Dynasty Platinum Breastplate {PvP}','Bard','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'false','false','true','false','true','0-0','0-0;'),
(10824,'Dynasty Jewel Leather Armor {PvP}','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(10825,'Dynasty Jewel Leather Armor {PvP}','Dagger Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(10826,'Dynasty Jewel Leather Armor {PvP}','Bow Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(10827,'Dynasty Silver Satin Tunic {PvP}','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(10828,'Dynasty Silver Satin Tunic {PvP}','Healer','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(10829,'Dynasty Silver Satin Tunic {PvP}','Enchanter','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(10830,'Dynasty Silver Satin Tunic {PvP}','Summoner','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(10831,'Dynasty Silver Satin Tunic {PvP}','Wizard','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(10832,'Dynasty Jewel Leather Armor {PvP}','Force Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(10833,'Dynasty Jewel Leather Armor {PvP}','Weapon Master','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(10834,'Dynasty Jewel Leather Armor {PvP}','Enchanter','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(10835,'Dynasty Jewel Leather Armor {PvP}','Summoner','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(11349,'Sealed Zubei\'s Gauntlet','','gloves','true','none',590,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','0-0;'),
(11350,'Sealed Zubei\'s Boots','','feet','true','none',1180,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','0-0;'),
(11351,'Sealed Avadon Gloves','','gloves','true','none',590,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','0-0;'),
(11352,'Sealed Avadon Boots','','feet','true','none',1170,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','0-0;'),
(11353,'Zubei\'s Leather Gaiters','','legs','true','light',1480,'wood','b',0,-1,-1,73,0,0,748300,100,'true','true','true','true','true','0-0','3668-1;'),
(11354,'Zubei\'s Leather Shirt','','chest','true','light',4330,'wood','b',0,-1,-1,117,0,0,1197000,160,'true','true','true','true','true','0-0','3669-1;'),
(11355,'Zubei\'s Gaiters','','legs','true','heavy',3570,'wood','b',0,-1,-1,98,0,0,997700,133,'true','true','true','true','true','0-0','3672-1;'),
(11356,'Zubei\'s Gauntlet','Heavy Armor Use','gloves','true','none',590,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','3673-1;'),
(11357,'Zubei\'s Gauntlet','Light Armor Use','gloves','true','none',590,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','3670-1;'),
(11358,'Zubei\'s Gauntlet','Robe Use','gloves','true','none',590,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','3679-1;'),
(11359,'Zubei\'s Boots','Heavy Armor Use','feet','true','none',1180,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','3674-1;'),
(11360,'Zubei\'s Boots','Light Armor Use','feet','true','none',1180,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','3671-1;'),
(11361,'Zubei\'s Boots','Robe Use','feet','true','none',1180,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','3680-1;'),
(11363,'Zubei\'s Helmet','Heavy Armor Use','head','true','none',590,'wood','b',0,-1,-1,62,0,0,598600,80,'true','true','true','true','true','0-0','3675-1;'),
(11364,'Zubei\'s Breastplate','','chest','true','heavy',7970,'wood','b',0,-1,-1,157,0,0,1596000,213,'true','true','true','true','true','0-0','3676-1;'),
(11365,'Avadon Gloves','Heavy Armor Use','gloves','true','none',590,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','3682-1;'),
(11366,'Avadon Gloves','Light Armor Use','gloves','true','none',590,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','3689-1;'),
(11367,'Avadon Gloves','Robe Use','gloves','true','none',590,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','3693-1;'),
(11368,'Avadon Leather Armor','','fullarmor','true','light',5600,'wood','b',0,-1,-1,191,0,0,1946000,259,'true','true','true','true','true','0-0','3690-1;'),
(11369,'Avadon Robe','','fullarmor','true','magic',2540,'wood','b',0,-1,-1,127,0,561,1946000,259,'true','true','true','true','true','0-0','3694-1;'),
(11370,'Avadon Boots','Heavy Armor Use','feet','true','none',1180,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','3683-1;'),
(11371,'Avadon Boots','Light Armor Use','feet','true','none',1180,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','3691-1;'),
(11372,'Avadon Boots','Robe Use','feet','true','none',1180,'wood','b',0,-1,-1,41,0,0,399100,53,'true','true','true','true','true','0-0','3695-1;'),
(11373,'Avadon Circlet','Heavy Armor Use','head','true','none',590,'wood','b',0,-1,-1,62,0,0,598600,80,'true','true','true','true','true','0-0','3688-1;'),
(11375,'Avadon Gaiters','','legs','true','heavy',3520,'wood','b',0,-1,-1,98,0,0,9977000,133,'true','true','true','true','true','0-0','3685-1;'),
(11376,'Avadon Breastplate','','chest','true','heavy',7920,'wood','b',0,-1,-1,157,0,0,1596000,213,'true','true','true','true','true','0-0','3686-1;'),
(11377,'Tunic of Zubei','','chest','true','magic',1960,'wood','b',0,-1,-1,78,0,345,1197000,160,'true','true','true','true','true','0-0','3677-1;'),
(11378,'Stockings of Zubei','','legs','true','magic',940,'wood','b',0,-1,-1,49,0,216,748000,100,'true','true','true','true','true','0-0','3678-1;'),
(11379,'Doom Gloves','Heavy Armor Use','gloves','true','none',580,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','3696-0;'),
(11380,'Doom Gloves','Light Armor Use','gloves','true','none',580,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','3702-1;'),
(11381,'Doom Gloves','Robe Use','gloves','true','none',580,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','3705-1;'),
(11382,'Doom Boots','Heavy Armor Use','feet','true','none',1130,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','3697-1;'),
(11383,'Doom Boots','Light Armor Use','feet','true','none',1130,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','3703-1;'),
(11384,'Doom Boots','Robe Use','feet','true','none',1130,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','3706-1;'),
(11386,'Doom Plate Armor','','fullarmor','true','heavy',9980,'wood','b',0,-1,-1,270,0,0,4022000,536,'true','true','true','true','true','0-0','3698-1;'),
(11387,'Doom Helmet','Heavy Armor Use','head','true','none',580,'wood','b',0,-1,-1,66,0,0,928300,124,'true','true','true','true','true','0-0','3699-1;'),
(11388,'Leather Armor of Doom','','fullarmor','true','light',5500,'wood','b',0,-1,-1,202,0,0,3017000,402,'true','true','true','true','true','0-0','3701-1;'),
(11389,'Sealed Doom Gloves','','gloves','true','none',580,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(11390,'Sealed Boots of Doom','','feet','true','none',1130,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(11391,'Sealed Blue Wolf Boots','','feet','true','none',1130,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(11392,'Sealed Blue Wolf Gloves','','gloves','true','none',590,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','0-0;'),
(11393,'Tunic of Doom','','chest','true','magic',1900,'wood','b',0,-1,-1,83,0,377,1857000,248,'true','true','true','true','true','0-0','3707-1;'),
(11394,'Blue Wolf Gaiters','','legs','true','heavy',3370,'wood','b',0,-1,-1,104,0,0,1547100,206,'true','true','true','true','true','0-0','3711-1;'),
(11395,'Blue Wolf Leather Armor','','fullarmor','true','light',5500,'wood','b',0,-1,-1,202,0,0,3017000,402,'true','true','true','true','true','0-0','3715-1;'),
(11396,'Blue Wolf Boots','Heavy Armor Use','feet','true','none',1130,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','3712-1;'),
(11397,'Blue Wolf Boots','Light Armor Use','feet','true','none',1130,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','3716-1;'),
(11398,'Blue Wolf Boots','Robe Use','feet','true','none',1130,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','3719-1;'),
(11399,'Blue Wolf Gloves','Heavy Armor Use','gloves','true','none',590,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','3713-1;'),
(11400,'Blue Wolf Gloves','Light Armor Use','gloves','true','none',590,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','3717-1;'),
(11401,'Blue Wolf Gloves','Robe Use','gloves','true','none',590,'wood','b',0,-1,-1,44,0,0,618800,83,'true','true','true','true','true','0-0','3720-1;'),
(11402,'Blue Wolf Tunic','','chest','true','magic',1920,'wood','b',0,-1,-1,83,0,377,1857000,248,'true','true','true','true','true','0-0','3721-1;'),
(11403,'Blue Wolf Helmet','Heavy Armor Use','head','true','none',580,'wood','b',0,-1,-1,66,0,0,928300,124,'true','true','true','true','true','0-0','3714-1;'),
(11404,'Blue Wolf Stockings','','legs','true','magic',920,'wood','b',0,-1,-1,52,0,236,1160300,155,'true','true','true','true','true','0-0','3722-1;'),
(11405,'Blue Wolf Breastplate','','chest','true','heavy',7820,'wood','b',0,-1,-1,166,0,0,2475000,330,'true','true','true','true','true','0-0','3710-1;'),
(11406,'Stockings of Doom','','legs','true','magic',910,'wood','b',0,-1,-1,52,0,236,1160300,155,'true','true','true','true','true','0-0','3708-1;'),
(11407,'Dark Crystal Gaiters','','legs','true','heavy',3320,'wood','a',0,-1,-1,107,0,0,2226000,178,'true','true','true','true','true','0-0','3726-1;'),
(11408,'Dark Crystal Gloves','Heavy Armor Use','gloves','true','none',580,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','3727-1;'),
(11409,'Dark Crystal Gloves','Light Armor Use','gloves','true','none',580,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','3731-1;'),
(11410,'Dark Crystal Gloves','Robe Use','gloves','true','none',580,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','3735-1;'),
(11411,'Dark Crystal Leather Armor','','chest','true','light',4300,'wood','a',0,-1,-1,128,0,0,2671000,214,'true','true','true','true','true','0-0','3730-1;'),
(11412,'Dark Crystal Robe','','fullarmor','true','magic',2450,'wood','a',0,-1,-1,139,0,665,4341000,347,'true','true','true','true','true','0-0','3736-1;'),
(11413,'Dark Crystal Boots','Heavy Armor Use','feet','true','none',1110,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','3728-1;'),
(11414,'Dark Crystal Boots','Light Armor Use','feet','true','none',1110,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','3732-1;'),
(11415,'Dark Crystal Boots','Robe Use','feet','true','none',1110,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','3737-1;'),
(11417,'Dark Crystal Helmet','Heavy Armor Use','head','true','none',570,'wood','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','3724-1;'),
(11418,'Dark Crystal Breastplate','','chest','true','heavy',7700,'wood','a',0,-1,-1,171,0,0,3562000,285,'true','true','true','true','true','0-0','3725-1;'),
(11419,'Dark Crystal Leggings','','legs','true','light',1480,'wood','a',0,-1,-1,80,0,0,1670000,134,'true','true','true','true','true','0-0','3734-1;'),
(11420,'Sealed Dark Crystal Gaiters','','legs','true','heavy',3320,'wood','a',0,-1,-1,107,0,0,2226000,178,'true','true','true','true','true','0-0','0-0;'),
(11421,'Sealed Dark Crystal Gloves','','gloves','true','none',580,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(11422,'Sealed Dark Crystal Leather Armor','','chest','true','light',4300,'wood','a',0,-1,-1,128,0,0,2671000,214,'true','true','true','true','true','0-0','0-0;'),
(11423,'Sealed Dark Crystal Robe','','fullarmor','true','magic',2450,'wood','a',0,-1,-1,139,0,665,4341000,347,'true','true','true','true','true','0-0','0-0;'),
(11424,'Sealed Dark Crystal Boots','','feet','true','none',1110,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(11426,'Sealed Dark Crystal Helmet','Heavy Armor Use','head','true','none',570,'wood','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','0-0;'),
(11427,'Sealed Dark Crystal breastplate','','chest','true','heavy',7700,'wood','a',0,-1,-1,171,0,0,3562000,285,'true','true','true','true','true','0-0','0-0;'),
(11428,'Sealed Dark Crystal Leggings','','legs','true','light',1480,'wood','a',0,-1,-1,80,0,0,1670000,134,'true','true','true','true','true','0-0','0-0;'),
(11429,'Sealed Tallum Gloves','','gloves','true','none',580,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(11430,'Sealed Tallum Leather Armor','','fullarmor','true','light',5400,'wood','a',0,-1,-1,209,0,0,4341000,347,'true','true','true','true','true','0-0','0-0;'),
(11431,'Sealed Tallum Boots','','feet','true','none',1130,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','0-0;'),
(11432,'Sealed Tallum Tunic','','chest','true','magic',1860,'wood','a',0,-1,-1,86,0,409,2671000,214,'true','true','true','true','true','0-0','0-0;'),
(11433,'Sealed Tallum Plate Armor','','fullarmor','true','heavy',9780,'wood','a',0,-1,-1,278,0,0,5788000,463,'true','true','true','true','true','0-0','0-0;'),
(11434,'Sealed Tallum Helmet','Heavy Armor Use','head','true','none',570,'wood','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','0-0;'),
(11435,'Sealed Tallum Stockings','','legs','true','magic',920,'wood','a',0,-1,-1,53,0,256,1670000,134,'true','true','true','true','true','0-0','0-0;'),
(11436,'(Not In Use) Holy Spirit\'s Cloak','','back','true','none',220,'wood','a',0,-1,-1,18,0,0,1160000,92,'true','true','true','true','true','0-0','0-0;'),
(11437,'Tallum Gloves','Heavy Armor Use','gloves','true','none',580,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','3739-1;'),
(11438,'Tallum Gloves','Light Armor Use','gloves','true','none',580,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','3744-1;'),
(11439,'Tallum Gloves','Robe Use','gloves','true','none',580,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','3747-1;'),
(11440,'Tallum Leather Armor','','fullarmor','true','light',5400,'wood','a',0,-1,-1,209,0,0,4341000,347,'true','true','true','true','true','0-0','3743-1;'),
(11441,'Tallum Boots','Heavy Armor Use','feet','true','none',1130,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','3740-1;'),
(11442,'Tallum Boots','Light Armor Use','feet','true','none',1130,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','3745-1;'),
(11443,'Tallum Boots','Robe Use','feet','true','none',1130,'wood','a',0,-1,-1,46,0,0,890000,71,'true','true','true','true','true','0-0','3748-1;'),
(11444,'Tallum Tunic','','chest','true','magic',1860,'wood','a',0,-1,-1,86,0,409,2671000,214,'true','true','true','true','true','0-0','3749-1;'),
(11445,'Tallum Plate Armor','','fullarmor','true','heavy',9780,'wood','a',0,-1,-1,278,0,0,5788000,463,'true','true','true','true','true','0-0','3741-1;'),
(11446,'Tallum Helmet','Heavy Armor Use','head','true','none',570,'wood','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','3742-1;'),
(11447,'Tallum Stockings','','legs','true','magic',920,'wood','a',0,-1,-1,53,0,256,1670000,134,'true','true','true','true','true','0-0','3750-1;'),
(11448,'Majestic Gauntlet','Heavy Armor Use','gloves','true','none',540,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','3752-1;'),
(11449,'Majestic Gauntlet','Light Armor Use','gloves','true','none',540,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','3756-1;'),
(11450,'Majestic Gauntlet','Robe Use','gloves','true','none',540,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','3760-1;'),
(11451,'Majestic Leather Armor','','fullarmor','true','light',5350,'wood','a',0,-1,-1,220,0,0,6603000,528,'true','true','true','true','true','0-0','3757-1;'),
(11452,'Majestic Robe','','fullarmor','true','magic',2330,'wood','a',0,-1,-1,147,0,718,6603000,528,'true','true','true','true','true','0-0','3761-1;'),
(11453,'Majestic Boots','Heavy Armor Use','feet','true','none',1110,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','3755-1;'),
(11454,'Majestic Boots','Light Armor Use','feet','true','none',1110,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','3758-1;'),
(11455,'Majestic Boots','Robe Use','feet','true','none',1110,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','3762-1;'),
(11456,'Majestic Circlet','Heavy Armor Use','head','true','none',550,'wood','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','3753-1;'),
(11457,'Majestic Plate Armor','','fullarmor','true','heavy',9200,'wood','a',0,-1,-1,293,0,0,8804000,704,'true','true','true','true','true','0-0','3754-1;'),
(11458,'Sealed Majestic Gauntlet','','gloves','true','none',540,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(11459,'Sealed Majestic Leather Armor','','fullarmor','true','light',5350,'wood','a',0,-1,-1,220,0,0,6603000,528,'true','true','true','true','true','0-0','0-0;'),
(11460,'Sealed Majestic Robe','','fullarmor','true','magic',2330,'wood','a',0,-1,-1,147,0,718,6603000,528,'true','true','true','true','true','0-0','0-0;'),
(11461,'Sealed Majestic Boots','','feet','true','none',1110,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(11462,'Sealed Majestic Circlet','Heavy Armor Use','head','true','none',550,'wood','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','0-0;'),
(11463,'Sealed Majestic Plate Armor','','fullarmor','true','heavy',9200,'wood','a',0,-1,-1,293,0,0,8804000,704,'true','true','true','true','true','0-0','0-0;'),
(11464,'Sealed Armor of Nightmare','','fullarmor','true','heavy',9580,'wood','a',0,-1,-1,293,0,0,8804000,704,'true','true','true','true','true','0-0','0-0;'),
(11465,'Sealed Gauntlet of Nightmare','','gloves','true','none',550,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(11466,'Sealed Leather Armor of Nightmare','','fullarmor','true','light',5300,'wood','a',0,-1,-1,220,0,0,6603000,528,'true','true','true','true','true','0-0','0-0;'),
(11467,'Sealed Nightmare Robe','','fullarmor','true','magic',2300,'wood','a',0,-1,-1,147,0,718,6603000,528,'true','true','true','true','true','0-0','0-0;'),
(11468,'Sealed Boots of Nightmare','','feet','true','none',1110,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','0-0;'),
(11470,'Sealed Helm of Nightmare','Heavy Armor Use','head','true','none',560,'wood','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','0-0;'),
(11471,'Armor of Nightmare','','fullarmor','true','heavy',9580,'wood','a',0,-1,-1,293,0,0,8804000,704,'true','true','true','true','true','0-0','3764-1;'),
(11472,'Gauntlet of Nightmare','Heavy Armor Use','gloves','true','none',550,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','3765-1;'),
(11473,'Gauntlet of Nightmare','Light Armor Use','gloves','true','none',550,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','3769-1;'),
(11474,'Gauntlet of Nightmare','Robe Use','gloves','true','none',550,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','3771-1;'),
(11475,'Nightmarish Leather Armor','','fullarmor','true','light',5300,'wood','a',0,-1,-1,220,0,0,6603000,528,'true','true','true','true','true','0-0','3768-1;'),
(11476,'Nightmare Robe','','fullarmor','true','magic',2300,'wood','a',0,-1,-1,147,0,718,6603000,528,'true','true','true','true','true','0-0','3772-1;'),
(11477,'Boots of Nightmare','Heavy Armor Use','feet','true','none',1110,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','3766-1;'),
(11478,'Boots of Nightmare','Light Armor Use','feet','true','none',1110,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','3770-1;'),
(11479,'Boots of Nightmare','Robe Use','feet','true','none',1110,'wood','a',0,-1,-1,49,0,0,1355000,108,'true','true','true','true','true','0-0','3773-1;'),
(11481,'Helm of Nightmare','Heavy Armor Use','head','true','none',560,'wood','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','3767-1;'),
(11482,'Great Wolf Oriharukon Armor','','chest','false','light',160,'wood','none',0,-1,-1,160,14,0,24236000,0,'true','true','true','true','true','0-0','0-0;'),
(11483,'Draconic Leather Gloves','','gloves','true','none',540,'wood','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','3775-1;'),
(11484,'Draconic Leather Boots','','feet','true','none',1110,'wood','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','3776-1;'),
(11485,'Draconic Leather Armor','','fullarmor','true','light',4950,'wood','s',0,-1,-1,249,0,0,15577000,748,'true','true','true','true','true','0-0','3777-1;'),
(11486,'Draconic Leather Helmet','','head','true','none',550,'wood','s',0,-1,-1,83,0,0,4793000,230,'true','true','true','true','true','0-0','3778-1;'),
(11487,'Major Arcana Gloves','','gloves','true','none',540,'wood','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','3779-1;'),
(11488,'Major Arcana Robe','','fullarmor','true','magic',2300,'wood','s',0,-1,-1,166,0,866,15577000,748,'true','true','true','true','true','0-0','3780-1;'),
(11489,'Major Arcana Boots','','feet','true','none',1110,'wood','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','3781-1;'),
(11490,'Major Arcana Circlet','','head','true','none',550,'wood','s',0,-1,-1,83,0,0,4793000,230,'true','true','true','true','true','0-0','3782-1;'),
(11491,'Sealed Draconic Leather Gloves','','gloves','true','none',540,'wood','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(11492,'Sealed Draconic Leather Boots','','feet','true','none',1110,'wood','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(11493,'Sealed Draconic Leather Armor','','fullarmor','true','light',4950,'wood','s',0,-1,-1,236,0,0,15577000,748,'true','true','true','true','true','0-0','0-0;'),
(11494,'Sealed Draconic Leather Helmet','','head','true','none',550,'wood','s',0,-1,-1,83,0,0,4793000,230,'true','true','true','true','true','0-0','0-0;'),
(11495,'Sealed Major Arcana Gloves','','gloves','true','none',540,'wood','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(11496,'Sealed Major Arcana Robe','','fullarmor','true','magic',2300,'wood','s',0,-1,-1,157,0,866,15577000,748,'true','true','true','true','true','0-0','0-0;'),
(11497,'Sealed Major Arcana Boots','','feet','true','none',1110,'wood','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(11498,'Sealed Major Arcana Circlet','','head','true','none',550,'wood','s',0,-1,-1,83,0,0,4793000,230,'true','true','true','true','true','0-0','0-0;'),
(11499,'Sealed Imperial Crusader Gaiters','','legs','true','heavy',3260,'wood','s',0,-1,-1,121,0,0,7988000,383,'true','true','true','true','true','0-0','0-0;'),
(11500,'Sealed Imperial Crusader Gauntlet','','gloves','true','none',540,'wood','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(11501,'Sealed Imperial Crusader Boots','','feet','true','none',1110,'wood','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','0-0;'),
(11503,'Sealed Imperial Crusader Helmet','','head','true','none',550,'wood','s',0,-1,-1,83,0,0,4793000,230,'true','true','true','true','true','0-0','0-0;'),
(11504,'Sealed Imperial Crusader Breastplate','','chest','true','heavy',7620,'wood','s',0,-1,-1,193,0,0,12781000,613,'true','true','true','true','true','0-0','0-0;'),
(11505,'Imperial Crusader Gaiters','','legs','true','heavy',3260,'wood','s',0,-1,-1,128,0,0,7988000,383,'true','true','true','true','true','0-0','3783-1;'),
(11506,'Imperial Crusader Gauntlet','','gloves','true','none',540,'wood','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','3784-1;'),
(11507,'Imperial Crusader Boots','','feet','true','none',1110,'wood','s',0,-1,-1,55,0,0,3195000,153,'true','true','true','true','true','0-0','3785-1;'),
(11509,'Imperial Crusader Helmet','','head','true','none',550,'wood','s',0,-1,-1,83,0,0,4793000,230,'true','true','true','true','true','0-0','3787-1;'),
(11510,'Imperial Crusader Breastplate','','chest','true','heavy',7620,'wood','s',0,-1,-1,205,0,0,12781000,613,'true','true','true','true','true','0-0','3788-1;'),
(11511,'Great Wolf Orichalcum Armor','','chest','false','light',160,'wood','none',0,-1,-1,171,14,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(11512,'Dynasty Gaiters','','legs','true','heavy',3210,'wood','s80',0,-1,-1,141,0,0,15248000,731,'true','true','true','true','true','0-0','3790-1;'),
(11513,'Dynasty Gauntlet','','gloves','true','none',520,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','3791-1;'),
(11514,'Dynasty Gloves','','gloves','true','none',520,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','3801-1;'),
(11515,'Dynasty Leather Gloves','','gloves','true','none',520,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','3866-1;'),
(11516,'Dynasty Leather Leggings','','legs','true','light',1370,'wood','s80',0,-1,-1,106,0,0,11436000,549,'true','true','true','true','true','0-0','3796-1;'),
(11517,'Dynasty Leather Armor','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','3795-1;'),
(11518,'Dynasty Leather Armor','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','3795-1;'),
(11519,'Dynasty Leather Armor','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','3795-1;'),
(11520,'Dynasty Leather Armor','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','3795-1;'),
(11521,'Dynasty Leather Armor','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','3795-1;'),
(11522,'Dynasty Leather Armor','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','3795-1;'),
(11523,'Dynasty Leather Armor','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,18298000,878,'true','true','true','true','true','0-0','3795-1;'),
(11524,'Dynasty Leather Boots','','feet','true','none',1090,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','3797-1;'),
(11525,'Dynasty Leather Helmet','','head','true','none',530,'wood','s80',0,-1,-1,92,0,0,9149000,439,'true','true','true','true','true','0-0','3798-1;'),
(11526,'Dynasty Boots','','feet','true','none',1090,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','3792-1;'),
(11527,'Dynasty Breastplate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'true','true','true','true','true','0-0','3789-1;'),
(11528,'Dynasty Breastplate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'true','true','true','true','true','0-0','3789-1;'),
(11529,'Dynasty Breastplate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'true','true','true','true','true','0-0','3789-1;'),
(11530,'Dynasty Breastplate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'true','true','true','true','true','0-0','3789-1;'),
(11531,'Dynasty Breastplate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,24398000,1171,'true','true','true','true','true','0-0','3789-1;'),
(11533,'Dynasty Shoes','','feet','true','none',1090,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','3802-1;'),
(11534,'Dynasty Silver Satin Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'true','true','true','true','true','0-0','3804-1;'),
(11535,'Dynasty Silver Satin Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'true','true','true','true','true','0-0','3804-1;'),
(11536,'Dynasty Silver Satin Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'true','true','true','true','true','0-0','3804-1;'),
(11537,'Dynasty Silver Satin Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'true','true','true','true','true','0-0','3804-1;'),
(11538,'Dynasty Silver Satin Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,25255000,1212,'true','true','true','true','true','0-0','3804-1;'),
(11539,'Dynasty Circlet','','head','true','none',530,'wood','s80',0,-1,-1,92,0,0,9149000,439,'true','true','true','true','true','0-0','3803-1;'),
(11540,'Dynasty Jewel Leather Mail','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','3805-1;'),
(11541,'Dynasty Jewel Leather Mail','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','3805-1;'),
(11542,'Dynasty Jewel Leather Mail','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','3805-1;'),
(11543,'Dynasty Jewel Leather Mail','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','3805-1;'),
(11544,'Dynasty Jewel Leather Mail','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','3805-1;'),
(11545,'Dynasty Jewel Leather Mail','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','3805-1;'),
(11546,'Dynasty Jewel Leather Mail','','chest','true','light',4180,'wood','s80',0,-1,-1,170,0,0,25255000,1212,'true','true','true','true','true','0-0','3805-1;'),
(11547,'Dynasty Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'true','true','true','true','true','0-0','3799-1;'),
(11548,'Dynasty Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'true','true','true','true','true','0-0','3799-1;'),
(11549,'Dynasty Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'true','true','true','true','true','0-0','3799-1;'),
(11550,'Dynasty Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'true','true','true','true','true','0-0','3799-1;'),
(11551,'Dynasty Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,113,0,592,18298000,878,'true','true','true','true','true','0-0','3799-1;'),
(11552,'Dynasty Platinum Plate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'true','true','true','true','true','0-0','3806-1;'),
(11553,'Dynasty Platinum Plate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'true','true','true','true','true','0-0','3806-1;'),
(11554,'Dynasty Platinum Plate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'true','true','true','true','true','0-0','3806-1;'),
(11555,'Dynasty Platinum Plate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'true','true','true','true','true','0-0','3806-1;'),
(11556,'Dynasty Platinum Plate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,226,0,0,33673000,1616,'true','true','true','true','true','0-0','3806-1;'),
(11557,'Dynasty Helmet','','head','true','none',530,'wood','s80',0,-1,-1,92,0,0,9149000,439,'true','true','true','true','true','0-0','3794-1;'),
(11558,'Dynasty Stockings','','legs','true','magic',860,'wood','s80',0,-1,-1,71,0,370,11436000,549,'true','true','true','true','true','0-0','3800-1;'),
(11559,'Sealed Dynasty Gaiters','','legs','true','heavy',3210,'wood','s80',0,-1,-1,134,0,0,15248000,731,'true','true','true','true','true','0-0','0-0;'),
(11560,'Sealed Dynasty Gauntlet','','gloves','true','none',520,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(11561,'Sealed Dynasty Gloves','','gloves','true','none',520,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(11562,'Sealed Dynasty Leather Gloves','','gloves','true','none',520,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(11563,'Sealed Dynasty Leather Leggings','','legs','true','light',1370,'wood','s80',0,-1,-1,100,0,0,11436000,549,'true','true','true','true','true','0-0','0-0;'),
(11564,'Sealed Dynasty Leather Armor','','chest','true','light',4180,'wood','s80',0,-1,-1,161,0,0,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(11565,'Sealed Dynasty Leather Boots','','feet','true','none',1090,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(11566,'Sealed Dynasty Leather Helmet','','head','true','none',530,'wood','s80',0,-1,-1,92,0,0,9149000,439,'true','true','true','true','true','0-0','0-0;'),
(11567,'Sealed Dynasty Boots','','feet','true','none',1090,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(11568,'Sealed Dynasty Breastplate','','chest','true','heavy',7570,'wood','s80',0,-1,-1,214,0,0,24398000,1171,'true','true','true','true','true','0-0','0-0;'),
(11570,'Sealed Dynasty Shoes','','feet','true','none',1090,'wood','s80',0,-1,-1,61,0,0,6099000,293,'true','true','true','true','true','0-0','0-0;'),
(11571,'Sealed Dynasty Circlet','','head','true','none',530,'wood','s80',0,-1,-1,92,0,0,9149000,439,'true','true','true','true','true','0-0','0-0;'),
(11572,'Sealed Dynasty Tunic','','chest','true','magic',1780,'wood','s80',0,-1,-1,107,0,592,18298000,878,'true','true','true','true','true','0-0','0-0;'),
(11573,'Sealed Dynasty Helmet','','head','true','none',530,'wood','s80',0,-1,-1,92,0,0,9149000,439,'true','true','true','true','true','0-0','0-0;'),
(11574,'Sealed Dynasty Stockings','','legs','true','magic',860,'wood','s80',0,-1,-1,67,0,370,11436000,549,'true','true','true','true','true','0-0','0-0;'),
(11575,'Adamantite Earring','','rear,lear','true','none',150,'wood','b',0,-1,-1,0,51,0,465900,62,'true','true','true','true','true','0-0','3807-1;'),
(11576,'Adamantite Necklace','','neck','true','none',150,'wood','b',0,-1,-1,0,68,0,621200,83,'true','true','true','true','true','0-0','3808-1;'),
(11577,'Adamantite Ring','','rfinger,lfinger','true','none',150,'wood','b',0,-1,-1,0,34,0,310600,41,'true','true','true','true','true','0-0','3809-1;'),
(11578,'Earring of Black Ore','','rear,lear','true','none',150,'wood','b',0,-1,-1,0,54,0,711000,95,'true','true','true','true','true','0-0','3810-1;'),
(11579,'Necklace of Black Ore','','neck','true','none',150,'wood','b',0,-1,-1,0,72,0,948000,126,'true','true','true','true','true','0-0','3811-1;'),
(11580,'Ring of Black Ore','','rfinger,lfinger','true','none',150,'wood','b',0,-1,-1,0,36,0,474000,63,'true','true','true','true','true','0-0','3812-1;'),
(11581,'Sealed Phoenix Necklace','','neck','true','none',150,'wood','a',0,-1,-1,0,76,0,1340000,107,'true','true','true','true','true','0-0','0-0;'),
(11582,'Sealed Phoenix Ring','','rfinger,lfinger','true','none',150,'wood','a',0,-1,-1,0,38,0,670000,54,'true','true','true','true','true','0-0','0-0;'),
(11583,'Sealed Phoenix Earring','','rear,lear','true','none',150,'wood','a',0,-1,-1,0,57,0,1005000,80,'true','true','true','true','true','0-0','0-0;'),
(11584,'Phoenix Necklace','','neck','true','none',150,'wood','a',0,-1,-1,0,80,26,1340000,107,'true','true','true','true','true','0-0','3813-1;'),
(11585,'Phoenix Ring','','rfinger,lfinger','true','none',150,'wood','a',0,-1,-1,0,40,13,670000,54,'true','true','true','true','true','0-0','3814-1;'),
(11586,'Phoenix Earring','','rear,lear','true','none',150,'wood','a',0,-1,-1,0,60,20,1005000,80,'true','true','true','true','true','0-0','3815-1;'),
(11587,'Majestic Necklace','','neck','true','none',150,'wood','a',0,-1,-1,0,85,33,1998000,160,'true','true','true','true','true','0-0','3816-1;'),
(11588,'Majestic Ring','','rfinger,lfinger','true','none',150,'wood','a',0,-1,-1,0,42,17,999000,80,'true','true','true','true','true','0-0','3817-1;'),
(11589,'Majestic Earring','','rear,lear','true','none',150,'wood','a',0,-1,-1,0,63,25,1498000,120,'true','true','true','true','true','0-0','3818-1;'),
(11590,'Sealed Majestic Necklace','','neck','true','none',150,'wood','a',0,-1,-1,0,80,0,1998000,160,'true','true','true','true','true','0-0','0-0;'),
(11591,'Sealed Majestic Ring','','rfinger,lfinger','true','none',150,'wood','a',0,-1,-1,0,40,0,999000,80,'true','true','true','true','true','0-0','0-0;'),
(11592,'Sealed Majestic Earring','','rear,lear','true','none',150,'wood','a',0,-1,-1,0,60,0,1498000,120,'true','true','true','true','true','0-0','0-0;'),
(11593,'Sealed Tateossian Necklace','','neck','true','none',150,'wood','s',0,-1,-1,0,91,0,4361000,209,'true','true','true','true','true','0-0','0-0;'),
(11594,'Sealed Tateossian Ring','','rfinger,lfinger','true','none',150,'wood','s',0,-1,-1,0,46,0,2180000,105,'true','true','true','true','true','0-0','0-0;'),
(11595,'Sealed Tateossian Earring','','rear,lear','true','none',150,'wood','s',0,-1,-1,0,68,0,3270000,157,'true','true','true','true','true','0-0','0-0;'),
(11596,'Tateossian Necklace','','neck','true','none',150,'wood','s',0,-1,-1,0,95,42,4361000,209,'true','true','true','true','true','0-0','3819-1;'),
(11597,'Tateossian Ring','','rfinger,lfinger','true','none',150,'wood','s',0,-1,-1,0,48,21,2180000,105,'true','true','true','true','true','0-0','3820-1;'),
(11598,'Tateossian Earring','','rear,lear','true','none',150,'wood','s',0,-1,-1,0,71,31,3270000,157,'true','true','true','true','true','0-0','3821-1;'),
(11599,'Dynasty Necklace','','neck','true','none',150,'wood','s80',0,-1,-1,0,106,46,7942000,258,'true','true','true','true','true','0-0','3822-1;'),
(11600,'Dynasty Ring','','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,60,23,3971000,129,'true','true','true','true','true','0-0','3823-1;'),
(11601,'Dynasty Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,79,35,5956000,194,'true','true','true','true','true','0-0','3824-1;'),
(11602,'Sealed Dynasty Necklace','','neck','true','none',150,'wood','s80',0,-1,-1,0,95,0,5376000,258,'true','true','true','true','true','0-0','0-0;'),
(11603,'Sealed Dynasty Ring','','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,53,0,2688000,129,'true','true','true','true','true','0-0','0-0;'),
(11604,'Sealed Dynasty Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,71,0,4032000,194,'true','true','true','true','true','0-0','0-0;'),
(12006,'Common Item - Leather Boots','','feet','true','none',433,'wood','d',0,-1,-1,19,0,0,890,2,'true','true','true','true','true','0-0','0-0;'),
(12007,'Common Item - Crafted Leather Gloves','','gloves','true','none',217,'wood','d',0,-1,-1,19,0,0,890,2,'true','true','true','true','true','0-0','0-0;'),
(12008,'Common Item - Ring Mail Breastplate','','chest','true','heavy',2940,'wood','d',0,-1,-1,77,0,0,3560,6,'true','true','true','true','true','0-0','0-0;'),
(12009,'Common Item - Bone Helmet','','head','true','none',213,'wood','d',0,-1,-1,29,0,0,1340,2,'true','true','true','true','true','0-0','0-0;'),
(12010,'Common Item - Cursed Tunic','','chest','true','magic',697,'wood','d',0,-1,-1,39,0,106,2670,5,'true','true','true','true','true','0-0','0-0;'),
(12011,'Common Item - Cursed Stockings','','legs','true','magic',340,'wood','d',0,-1,-1,24,0,66,1670,3,'true','true','true','true','true','0-0','0-0;'),
(12012,'Common Item - Iron Plate Gaiters','','legs','true','heavy',1273,'wood','d',0,-1,-1,48,0,0,2230,4,'true','true','true','true','true','0-0','0-0;'),
(12014,'Common Item - Puma Skin Gaiters','','legs','true','light',533,'wood','d',0,-1,-1,36,0,0,1670,3,'true','true','true','true','true','0-0','0-0;'),
(12015,'Common Item - Puma Skin Shirt','','chest','true','light',1567,'wood','d',0,-1,-1,58,0,0,2670,5,'true','true','true','true','true','0-0','0-0;'),
(12016,'Common Item - Leather Gauntlet','','gloves','true','none',213,'wood','d',0,-1,-1,22,0,0,1350,2,'true','true','true','true','true','0-0','0-0;'),
(12017,'Common Item - Dark Stockings','','legs','true','magic',333,'wood','d',0,-1,-1,27,0,79,2520,5,'true','true','true','true','true','0-0','0-0;'),
(12018,'Common Item - Mystic\'s Tunic','','chest','true','magic',677,'wood','d',0,-1,-1,43,0,126,4040,7,'true','true','true','true','true','0-0','0-0;'),
(12019,'Common Item - Mystic\'s Stockings','','legs','true','magic',330,'wood','d',0,-1,-1,27,0,79,2520,5,'true','true','true','true','true','0-0','0-0;'),
(12020,'Common Item - Lion Skin Gaiters','','legs','true','light',523,'wood','d',0,-1,-1,41,0,0,2520,5,'true','true','true','true','true','0-0','0-0;'),
(12021,'Common Item - Lion Skin Shirt','','chest','true','light',1527,'wood','d',0,-1,-1,65,0,0,4040,7,'true','true','true','true','true','0-0','0-0;'),
(12022,'Common Item - White Tunic','','chest','true','magic',680,'wood','d',0,-1,-1,43,0,126,4040,7,'true','true','true','true','true','0-0','0-0;'),
(12023,'Common Item - Scale Gaiters','','legs','true','heavy',1287,'wood','d',0,-1,-1,54,0,0,3360,6,'true','true','true','true','true','0-0','0-0;'),
(12024,'Common Item - Scale Mail','','chest','true','heavy',2907,'wood','d',0,-1,-1,87,0,0,5380,10,'true','true','true','true','true','0-0','0-0;'),
(12026,'Common Item - Elven Tunic','','chest','true','magic',693,'wood','d',0,-1,-1,43,0,126,4040,7,'true','true','true','true','true','0-0','0-0;'),
(12027,'Common Item - Elven Stockings','','legs','true','magic',337,'wood','d',0,-1,-1,27,0,79,2520,5,'true','true','true','true','true','0-0','0-0;'),
(12028,'Common Item - Bronze Helmet','','head','true','none',210,'wood','d',0,-1,-1,33,0,0,2020,4,'true','true','true','true','true','0-0','0-0;'),
(12029,'Common Item - Blue Buckskin Boots','','feet','true','none',433,'wood','d',0,-1,-1,22,0,0,1350,2,'true','true','true','true','true','0-0','0-0;'),
(12030,'Common Item - Dwarven Scale Mail','','chest','true','heavy',2847,'wood','d',0,-1,-1,95,0,0,7160,13,'true','true','true','true','true','0-0','0-0;'),
(12031,'Common Item - Mithril Breastplate','','chest','true','heavy',2890,'wood','d',0,-1,-1,95,0,0,7160,13,'true','true','true','true','true','0-0','0-0;'),
(12032,'Common Item - Compound Scale Mail','','chest','true','heavy',2873,'wood','d',0,-1,-1,95,0,0,7160,13,'true','true','true','true','true','0-0','0-0;'),
(12033,'Common Item - Iron Boots','','feet','true','none',427,'wood','d',0,-1,-1,24,0,0,1960,4,'true','true','true','true','true','0-0','0-0;'),
(12034,'Common Item - Reinforced Leather Gaiters','','legs','true','light',523,'wood','d',0,-1,-1,46,0,0,3680,7,'true','true','true','true','true','0-0','0-0;'),
(12035,'Common Item - Reinforced Leather Boots','','feet','true','none',427,'wood','d',0,-1,-1,24,0,0,1960,4,'true','true','true','true','true','0-0','0-0;'),
(12036,'Common Item - Reinforced Leather Shirt','','chest','true','light',1523,'wood','d',0,-1,-1,73,0,0,5890,11,'true','true','true','true','true','0-0','0-0;'),
(12037,'Common Item - Reinforced Leather Gloves','','gloves','true','none',213,'wood','d',0,-1,-1,24,0,0,1960,4,'true','true','true','true','true','0-0','0-0;'),
(12038,'Common Item - Gauntlet','','gloves','true','none',213,'wood','d',0,-1,-1,24,0,0,1960,4,'true','true','true','true','true','0-0','0-0;'),
(12039,'Common Item - Dwarven Scale Gaiters','','legs','true','heavy',1280,'wood','d',0,-1,-1,61,0,0,4910,9,'true','true','true','true','true','0-0','0-0;'),
(12040,'Common Item - Linen Shirt','','underwear','true','none',43,'wood','d',0,-1,-1,12,0,0,4910,39,'true','true','true','true','true','0-0','0-0;'),
(12041,'Common Item - Mithril Gaiters','','legs','true','heavy',1277,'wood','d',0,-1,-1,61,0,0,4910,9,'true','true','true','true','true','0-0','0-0;'),
(12042,'Common Item - Mithril Banded Gaiters','','legs','true','light',527,'wood','d',0,-1,-1,46,0,0,3680,7,'true','true','true','true','true','0-0','0-0;'),
(12043,'Common Item - Mithril Banded Mail','','chest','true','light',1523,'wood','d',0,-1,-1,73,0,0,5890,11,'true','true','true','true','true','0-0','0-0;'),
(12044,'Common Item - Blast Plate','','chest','true','heavy',2807,'wood','d',0,-1,-1,97,0,0,7860,14,'true','true','true','true','true','0-0','0-0;'),
(12045,'Common Item - Boots of Knowledge','','feet','true','none',423,'wood','d',0,-1,-1,24,0,0,1960,4,'true','true','true','true','true','0-0','0-0;'),
(12046,'Common Item - Gloves of Knowledge','','gloves','true','none',213,'wood','d',0,-1,-1,24,0,0,1960,4,'true','true','true','true','true','0-0','0-0;'),
(12047,'Common Item - Tunic of Knowledge','','chest','true','magic',673,'wood','d',0,-1,-1,49,0,147,5890,11,'true','true','true','true','true','0-0','0-0;'),
(12048,'Common Item - Stockings of Knowledge','','legs','true','magic',333,'wood','d',0,-1,-1,30,0,92,3680,7,'true','true','true','true','true','0-0','0-0;'),
(12049,'Common Item - Compound Scale Gaiters','','legs','true','heavy',1257,'wood','d',0,-1,-1,61,0,0,4910,9,'true','true','true','true','true','0-0','0-0;'),
(12050,'Common Item - Helmet','','head','true','none',213,'wood','d',0,-1,-1,37,0,0,2950,5,'true','true','true','true','true','0-0','0-0;'),
(12052,'Common Item - Manticore Skin Gaiters','','legs','true','light',517,'wood','d',0,-1,-1,48,0,0,5220,9,'true','true','true','true','true','0-0','0-0;'),
(12053,'Common Item - Manticore Skin Boots','','feet','true','none',420,'wood','d',0,-1,-1,27,0,0,2780,5,'true','true','true','true','true','0-0','0-0;'),
(12054,'Common Item - Manticore Skin Shirt','','chest','true','light',1507,'wood','d',0,-1,-1,77,0,0,8350,15,'true','true','true','true','true','0-0','0-0;'),
(12055,'Common Item - Manticore Skin Gloves','','gloves','true','none',210,'wood','d',0,-1,-1,27,0,0,2780,5,'true','true','true','true','true','0-0','0-0;'),
(12056,'Common Item - Mithril Scale Gaiters','','legs','true','heavy',1290,'wood','d',0,-1,-1,64,0,0,6960,13,'true','true','true','true','true','0-0','0-0;'),
(12057,'Common Item - Mithril Tunic','','chest','true','magic',670,'wood','d',0,-1,-1,52,0,169,8350,15,'true','true','true','true','true','0-0','0-0;'),
(12058,'Common Item - Mithril Stockings','','legs','true','magic',327,'wood','d',0,-1,-1,32,0,105,5220,9,'true','true','true','true','true','0-0','0-0;'),
(12059,'Common Item - Brigandine','','chest','true','heavy',2773,'wood','d',0,-1,-1,103,0,0,11100,20,'true','true','true','true','true','0-0','0-0;'),
(12060,'Common Item - Brigandine Gaiters','','legs','true','heavy',1273,'wood','d',0,-1,-1,64,0,0,6960,13,'true','true','true','true','true','0-0','0-0;'),
(12061,'Common Item - Brigandine Gauntlet','','gloves','true','none',210,'wood','d',0,-1,-1,27,0,0,2780,5,'true','true','true','true','true','0-0','0-0;'),
(12062,'Common Item - Brigandine Boots','','feet','true','none',417,'wood','d',0,-1,-1,27,0,0,2780,5,'true','true','true','true','true','0-0','0-0;'),
(12064,'Common Item - Brigandine Helmet','','head','true','none',210,'wood','d',0,-1,-1,41,0,0,4170,8,'true','true','true','true','true','0-0','0-0;'),
(12065,'Common Item - Elven Mithril Gloves','','gloves','true','none',213,'wood','d',0,-1,-1,27,0,0,2780,5,'true','true','true','true','true','0-0','0-0;'),
(12066,'Common Item - Elven Mithril Boots','','feet','true','none',417,'wood','d',0,-1,-1,27,0,0,2780,5,'true','true','true','true','true','0-0','0-0;'),
(12067,'Common Item - Striped Linen Shirt','','underwear','true','none',43,'wood','d',0,-1,-1,14,0,0,6960,75,'true','true','true','true','true','0-0','0-0;'),
(12068,'Common Item - Rip Gauntlet','','gloves','true','none',210,'wood','d',0,-1,-1,27,0,0,2780,5,'true','true','true','true','true','0-0','0-0;'),
(12070,'Common Item - Boots of Power','','feet','true','none',417,'wood','d',0,-1,-1,27,0,0,2780,5,'true','true','true','true','true','0-0','0-0;'),
(12071,'Common Item - Assault Boots','','feet','true','none',413,'wood','d',0,-1,-1,29,0,0,3560,6,'true','true','true','true','true','0-0','0-0;'),
(12072,'Common Item - Mithril Gloves','','gloves','true','none',210,'wood','d',0,-1,-1,29,0,0,3560,6,'true','true','true','true','true','0-0','0-0;'),
(12074,'Common Item - Salamander Skin Mail','','fullarmor','true','light',2033,'wood','d',0,-1,-1,136,0,0,17300,31,'true','true','true','true','true','0-0','0-0;'),
(12075,'Common Item - Salamander Skin Boots','','feet','true','none',410,'wood','d',0,-1,-1,29,0,0,3560,6,'true','true','true','true','true','0-0','0-0;'),
(12076,'Common Item - Ogre Power Gauntlet','','gloves','true','none',207,'wood','d',0,-1,-1,29,0,0,3560,6,'true','true','true','true','true','0-0','0-0;'),
(12077,'Common Item - Plate Boots','','feet','true','none',413,'wood','d',0,-1,-1,29,0,0,3560,6,'true','true','true','true','true','0-0','0-0;'),
(12079,'Common Item - Plate Helmet','','head','true','none',210,'wood','d',0,-1,-1,44,0,0,5340,10,'true','true','true','true','true','0-0','0-0;'),
(12080,'Common Item - Plate Gaiters','','legs','true','heavy',1257,'wood','d',0,-1,-1,70,0,0,8890,16,'true','true','true','true','true','0-0','0-0;'),
(12081,'Common Item - Half Plate Armor','','chest','true','heavy',2740,'wood','d',0,-1,-1,111,0,0,14200,26,'true','true','true','true','true','0-0','0-0;'),
(12082,'Common Item - Sage\'s Worn Gloves','','gloves','true','none',210,'wood','d',0,-1,-1,29,0,0,3560,6,'true','true','true','true','true','0-0','0-0;'),
(12083,'Common Item - Sage\'s Rag','','fullarmor','true','magic',860,'wood','d',0,-1,-1,90,0,320,17300,31,'true','true','true','true','true','0-0','0-0;'),
(12084,'Common Item - Tempered Mithril Gaiters','','legs','true','light',510,'wood','c',0,-1,-1,56,0,0,8430,3,'true','true','true','true','true','0-0','0-0;'),
(12085,'Common Item - Tempered Mithril Boots','','feet','true','none',410,'wood','c',0,-1,-1,32,0,0,4500,2,'true','true','true','true','true','0-0','0-0;'),
(12086,'Common Item - Tempered Mithril Shirt','','chest','true','light',1490,'wood','c',0,-1,-1,90,0,0,13500,5,'true','true','true','true','true','0-0','0-0;'),
(12087,'Common Item - Reinforced Mithril Gloves','','gloves','true','none',207,'wood','c',0,-1,-1,32,0,0,4500,2,'true','true','true','true','true','0-0','0-0;'),
(12088,'Common Item - Dwarven Chain Boots','','feet','true','none',403,'wood','c',0,-1,-1,32,0,0,4500,2,'true','true','true','true','true','0-0','0-0;'),
(12089,'Common Item - Boots of Seal','','feet','true','none',407,'wood','c',0,-1,-1,32,0,0,4500,2,'true','true','true','true','true','0-0','0-0;'),
(12090,'Common Item - Chain Hood','','head','true','none',207,'wood','c',0,-1,-1,47,0,0,6750,3,'true','true','true','true','true','0-0','0-0;'),
(12092,'Common Item - Chain Gloves','','gloves','true','none',207,'wood','c',0,-1,-1,32,0,0,4500,2,'true','true','true','true','true','0-0','0-0;'),
(12093,'Common Item - Chain Boots','','feet','true','none',407,'wood','c',0,-1,-1,32,0,0,4500,2,'true','true','true','true','true','0-0','0-0;'),
(12094,'Common Item - Chain Gaiters','','legs','true','heavy',1227,'wood','c',0,-1,-1,75,0,0,11200,4,'true','true','true','true','true','0-0','0-0;'),
(12095,'Common Item - Chain Mail Shirt','','chest','true','heavy',2707,'wood','c',0,-1,-1,120,0,0,18000,7,'true','true','true','true','true','0-0','0-0;'),
(12097,'Common Item - Karmian Gloves','','gloves','true','none',207,'wood','c',0,-1,-1,32,0,0,4500,2,'true','true','true','true','true','0-0','0-0;'),
(12098,'Common Item - Karmian Boots','','feet','true','none',410,'wood','c',0,-1,-1,32,0,0,4500,2,'true','true','true','true','true','0-0','0-0;'),
(12099,'Common Item - Karmian Tunic','','chest','true','magic',660,'wood','c',0,-1,-1,60,0,225,13500,5,'true','true','true','true','true','0-0','0-0;'),
(12100,'Common Item - Karmian Stockings','','legs','true','magic',323,'wood','c',0,-1,-1,37,0,141,8430,3,'true','true','true','true','true','0-0','0-0;'),
(12101,'Common Item - Plate Leather Boots','','feet','true','none',407,'wood','c',0,-1,-1,32,0,0,4500,2,'true','true','true','true','true','0-0','0-0;'),
(12103,'Common Item - Plate Leather Gaiters','','legs','true','light',520,'wood','c',0,-1,-1,59,0,0,11200,4,'true','true','true','true','true','0-0','0-0;'),
(12104,'Common Item - Plate Leather Gloves','','gloves','true','none',203,'wood','c',0,-1,-1,33,0,0,4500,2,'true','true','true','true','true','0-0','0-0;'),
(12105,'Common Item - Plate Leather Armor','','chest','true','light',1483,'wood','c',0,-1,-1,94,0,0,18000,7,'true','true','true','true','true','0-0','0-0;'),
(12106,'Common Item - Great Helmet','','head','true','none',203,'wood','c',0,-1,-1,51,0,0,8420,3,'true','true','true','true','true','0-0','0-0;'),
(12108,'Common Item - Dwarven Chain Gloves','','gloves','true','none',200,'wood','c',0,-1,-1,34,0,0,5620,2,'true','true','true','true','true','0-0','0-0;'),
(12109,'Common Item - Dwarven Chain Gaiters','','legs','true','heavy',1207,'wood','c',0,-1,-1,80,0,0,14000,6,'true','true','true','true','true','0-0','0-0;'),
(12110,'Common Item - Dwarven Chain Mail Shirt','','chest','true','heavy',2690,'wood','c',0,-1,-1,129,0,0,22500,9,'true','true','true','true','true','0-0','0-0;'),
(12111,'Common Item - Rind Leather Gaiters','','legs','true','light',517,'wood','c',0,-1,-1,60,0,0,10500,4,'true','true','true','true','true','0-0','0-0;'),
(12112,'Common Item - Rind Leather Gloves','','gloves','true','none',200,'wood','c',0,-1,-1,34,0,0,5620,2,'true','true','true','true','true','0-0','0-0;'),
(12113,'Common Item - Rind Leather Armor','','chest','true','light',1473,'wood','c',0,-1,-1,97,0,0,16800,7,'true','true','true','true','true','0-0','0-0;'),
(12114,'Common Item - Rind Leather Boots','','feet','true','none',407,'wood','c',0,-1,-1,34,0,0,5620,2,'true','true','true','true','true','0-0','0-0;'),
(12115,'Common Item - Robe of Seal','','fullarmor','true','magic',833,'wood','c',0,-1,-1,105,0,413,27400,11,'true','true','true','true','true','0-0','0-0;'),
(12116,'Common Item - Gloves of Seal','','gloves','true','none',207,'wood','c',0,-1,-1,34,0,0,5620,2,'true','true','true','true','true','0-0','0-0;'),
(12117,'Common Item - Silk Shirt','','underwear','true','none',43,'wood','c',0,-1,-1,17,0,0,14000,27,'true','true','true','true','true','0-0','0-0;'),
(12118,'Common Item - Crimson Boots','','feet','true','none',403,'wood','c',0,-1,-1,34,0,0,5620,2,'true','true','true','true','true','0-0','0-0;'),
(12119,'Common Item - Mithril Gauntlet','','gloves','true','none',200,'wood','c',0,-1,-1,36,0,0,10400,4,'true','true','true','true','true','0-0','0-0;'),
(12120,'Common Item - Shining Circlet','','head','true','none',200,'wood','c',0,-1,-1,54,0,0,15600,6,'true','true','true','true','true','0-0','0-0;'),
(12121,'Common Item - Demon\'s Boots','','feet','true','none',407,'wood','c',0,-1,-1,36,0,0,10400,4,'true','true','true','true','true','0-0','0-0;'),
(12122,'Common Item - Demon\'s Gloves','','gloves','true','none',203,'wood','c',0,-1,-1,36,0,0,10400,4,'true','true','true','true','true','0-0','0-0;'),
(12123,'Common Item - Demon\'s Tunic','','chest','true','magic',663,'wood','c',0,-1,-1,69,0,284,31200,12,'true','true','true','true','true','0-0','0-0;'),
(12124,'Common Item - Demon\'s Stockings','','legs','true','magic',327,'wood','c',0,-1,-1,43,0,177,19500,8,'true','true','true','true','true','0-0','0-0;'),
(12125,'Common Item - Composite Boots','','feet','true','none',407,'wood','c',0,-1,-1,36,0,0,10400,4,'true','true','true','true','true','0-0','0-0;'),
(12127,'Common Item - Composite Helmet','','head','true','none',203,'wood','c',0,-1,-1,54,0,0,15600,6,'true','true','true','true','true','0-0','0-0;'),
(12128,'Common Item - Composite Armor','','fullarmor','true','heavy',3660,'wood','c',0,-1,-1,224,0,0,67700,27,'true','true','true','true','true','0-0','0-0;'),
(12130,'Common Item - Theca Leather Gaiters','','legs','true','light',510,'wood','c',0,-1,-1,66,0,0,21000,8,'true','true','true','true','true','0-0','0-0;'),
(12131,'Common Item - Theca Leather Gloves','','gloves','true','none',200,'wood','c',0,-1,-1,37,0,0,11200,4,'true','true','true','true','true','0-0','0-0;'),
(12132,'Common Item - Theca Leather Boots','','feet','true','none',403,'wood','c',0,-1,-1,37,0,0,11200,4,'true','true','true','true','true','0-0','0-0;'),
(12133,'Common Item - Theca Leather Armor','','chest','true','light',1457,'wood','c',0,-1,-1,106,0,0,33600,13,'true','true','true','true','true','0-0','0-0;'),
(12134,'Common Item - Drake Leather Gloves','','gloves','true','none',200,'wood','c',0,-1,-1,39,0,0,16300,7,'true','true','true','true','true','0-0','0-0;'),
(12135,'Common Item - Drake Leather Armor','','fullarmor','true','light',1933,'wood','c',0,-1,-1,179,0,0,79500,32,'true','true','true','true','true','0-0','0-0;'),
(12136,'Common Item - Drake Leather Boots','','feet','true','none',403,'wood','c',0,-1,-1,39,0,0,16300,7,'true','true','true','true','true','0-0','0-0;'),
(12137,'Common Item - Divine Gloves','','gloves','true','none',203,'wood','c',0,-1,-1,39,0,0,16300,7,'true','true','true','true','true','0-0','0-0;'),
(12138,'Common Item - Divine Tunic','','chest','true','magic',660,'wood','c',0,-1,-1,74,0,314,48900,20,'true','true','true','true','true','0-0','0-0;'),
(12139,'Common Item - Divine Stockings','','legs','true','magic',320,'wood','c',0,-1,-1,46,0,196,30600,12,'true','true','true','true','true','0-0','0-0;'),
(12140,'Common Item - Stripe Silk Shirt','','underwear','true','none',43,'wood','c',0,-1,-1,19,0,0,40800,60,'true','true','true','true','true','0-0','0-0;'),
(12141,'Common Item - Full Plate Gauntlet','','gloves','true','none',200,'wood','c',0,-1,-1,39,0,0,16300,7,'true','true','true','true','true','0-0','0-0;'),
(12142,'Common Item - Full Plate Boots','','feet','true','none',400,'wood','c',0,-1,-1,39,0,0,16300,7,'true','true','true','true','true','0-0','0-0;'),
(12144,'Common Item - Full Plate Armor','','fullarmor','true','heavy',3493,'wood','c',0,-1,-1,239,0,0,106000,42,'true','true','true','true','true','0-0','0-0;'),
(12145,'Common Item - Full Plate Helmet','','head','true','none',200,'wood','c',0,-1,-1,58,0,0,24500,10,'true','true','true','true','true','0-0','0-0;'),
(12146,'Common Item - Sealed Zubei\'s Gauntlet','','gloves','true','none',197,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12147,'Common Item - Sealed Zubei\'s Boots','','feet','true','none',393,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12148,'Common Item - Sealed Avadon Gloves','','gloves','true','none',197,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12149,'Common Item - Sealed Avadon Boots','','feet','true','none',390,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12150,'Common Item - Zubei\'s Leather Gaiters','','legs','true','light',493,'wood','b',0,-1,-1,73,0,0,39100,5,'true','true','true','true','true','0-0','0-0;'),
(12151,'Common Item - Zubei\'s Leather Shirt','','chest','true','light',1443,'wood','b',0,-1,-1,117,0,0,62600,8,'true','true','true','true','true','0-0','0-0;'),
(12152,'Common Item - Zubei\'s Gaiters','','legs','true','heavy',1190,'wood','b',0,-1,-1,98,0,0,52200,7,'true','true','true','true','true','0-0','0-0;'),
(12153,'Common Item - Zubei\'s Gauntlet','Heavy Armor Use','gloves','true','none',197,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12154,'Common Item - Zubei\'s Gauntlet','Tans Armor Use','gloves','true','none',197,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12155,'Common Item - Zubei\'s Gauntlet','Robe Use','gloves','true','none',197,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12156,'Common Item - Zubei\'s Boots','Heavy Armor Use','feet','true','none',393,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12157,'Common Item - Zubei\'s Boots','Tans Armor Use','feet','true','none',393,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12158,'Common Item - Zubei\'s Boots','Robe Use','feet','true','none',393,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12160,'Common Item - Zubei\'s Helmet','','head','true','none',197,'wood','b',0,-1,-1,62,0,0,31300,4,'true','true','true','true','true','0-0','0-0;'),
(12161,'Common Item - Zubei\'s Breastplate','','chest','true','heavy',2657,'wood','b',0,-1,-1,157,0,0,83500,11,'true','true','true','true','true','0-0','0-0;'),
(12162,'Common Item - Avadon Gloves','Heavy Armor Use','gloves','true','none',197,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12163,'Common Item - Avadon Gloves','Tans Armor Use','gloves','true','none',197,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12164,'Common Item - Avadon Gloves','Robe Use','gloves','true','none',197,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12165,'Common Item - Avadon Leather Armor','','fullarmor','true','light',1867,'wood','b',0,-1,-1,191,0,0,102000,14,'true','true','true','true','true','0-0','0-0;'),
(12166,'Common Item - Avadon Robe','','fullarmor','true','magic',847,'wood','b',0,-1,-1,127,0,561,102000,14,'true','true','true','true','true','0-0','0-0;'),
(12167,'Common Item - Avadon Boots','Heavy Armor Use','feet','true','none',393,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12168,'Common Item - Avadon Boots','Tans Armor Use','feet','true','none',393,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12169,'Common Item - Avadon Boots','Robe Use','feet','true','none',393,'wood','b',0,-1,-1,41,0,0,20900,3,'true','true','true','true','true','0-0','0-0;'),
(12170,'Common Item - Avadon Circlet','','head','true','none',197,'wood','b',0,-1,-1,62,0,0,31300,4,'true','true','true','true','true','0-0','0-0;'),
(12172,'Common Item - Avadon Plate Gaiters','','legs','true','heavy',1173,'wood','b',0,-1,-1,98,0,0,52200,7,'true','true','true','true','true','0-0','0-0;'),
(12173,'Common Item - Avadon Breastplate','','chest','true','heavy',2640,'wood','b',0,-1,-1,157,0,0,83500,11,'true','true','true','true','true','0-0','0-0;'),
(12174,'Common Item - Thin Leather Shirt','','underwear','true','none',43,'wood','b',0,-1,-1,21,0,0,52200,29,'true','true','true','true','true','0-0','0-0;'),
(12175,'Common Item - Tunic of Zubei','','chest','true','magic',653,'wood','b',0,-1,-1,78,0,345,62600,8,'true','true','true','true','true','0-0','0-0;'),
(12176,'Common Item - Stockings of Zubei','','legs','true','magic',313,'wood','b',0,-1,-1,49,0,216,39100,5,'true','true','true','true','true','0-0','0-0;'),
(12177,'Common Item - Doom Gloves','Heavy Armor Use','gloves','true','none',193,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12178,'Common Item - Doom Gloves','Tans Armor Use','gloves','true','none',193,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12179,'Common Item - Doom Gloves','Robe Use','gloves','true','none',193,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12180,'Common Item - Doom Boots','Heavy Armor Use','feet','true','none',377,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12181,'Common Item - Doom Boots','Tans Armor Use','feet','true','none',377,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12182,'Common Item - Doom Boots','Robe Use','feet','true','none',377,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12184,'Common Item - Doom Plate Armor','','fullarmor','true','heavy',3327,'wood','b',0,-1,-1,270,0,0,244000,33,'true','true','true','true','true','0-0','0-0;'),
(12185,'Common Item - Doom Helmet','','head','true','none',193,'wood','b',0,-1,-1,66,0,0,56300,8,'true','true','true','true','true','0-0','0-0;'),
(12186,'Common Item - Leather Armor of Doom','','fullarmor','true','light',1833,'wood','b',0,-1,-1,202,0,0,183000,24,'true','true','true','true','true','0-0','0-0;'),
(12187,'Common Item - Sealed Doom Gloves','','gloves','true','none',193,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12188,'Common Item - Sealed Doom Boots','','feet','true','none',377,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12189,'Common Item - Sealed Blue Wolf Boots','','feet','true','none',377,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12190,'Common Item - Sealed Blue Wolf Gloves','','gloves','true','none',197,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12191,'Common Item - Thin Stripe Leather Shirt','','underwear','true','none',43,'wood','b',0,-1,-1,22,0,0,93900,44,'true','true','true','true','true','0-0','0-0;'),
(12192,'Common Item - Tunic of Doom','','chest','true','magic',633,'wood','b',0,-1,-1,83,0,377,112700,15,'true','true','true','true','true','0-0','0-0;'),
(12193,'Common Item - Blue Wolf Gaiters','','legs','true','heavy',1123,'wood','b',0,-1,-1,104,0,0,93900,13,'true','true','true','true','true','0-0','0-0;'),
(12194,'Common Item - Blue Wolf Leather Armor','','fullarmor','true','light',1833,'wood','b',0,-1,-1,202,0,0,183000,24,'true','true','true','true','true','0-0','0-0;'),
(12195,'Common Item - Blue Wolf Boots','Heavy Armor Use','feet','true','none',377,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12196,'Common Item - Blue Wolf Boots','Tans Armor Use','feet','true','none',377,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12197,'Common Item - Blue Wolf Boots','Robe Use','feet','true','none',377,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12198,'Common Item - Blue Wolf Gloves','Heavy Armor Use','gloves','true','none',197,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12199,'Common Item - Blue Wolf Gloves','Tans Armor Use','gloves','true','none',197,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12200,'Common Item - Blue Wolf Gloves','Robe Use','gloves','true','none',197,'wood','b',0,-1,-1,44,0,0,37600,5,'true','true','true','true','true','0-0','0-0;'),
(12201,'Common Item - Blue Wolf Tunic','','chest','true','magic',640,'wood','b',0,-1,-1,83,0,377,112700,15,'true','true','true','true','true','0-0','0-0;'),
(12202,'Common Item - Blue Wolf Helmet','','head','true','none',193,'wood','b',0,-1,-1,66,0,0,56300,8,'true','true','true','true','true','0-0','0-0;'),
(12203,'Common Item - Blue Wolf Stockings','','legs','true','magic',307,'wood','b',0,-1,-1,52,0,236,70400,9,'true','true','true','true','true','0-0','0-0;'),
(12204,'Common Item - Blue Wolf Breastplate','','chest','true','heavy',2607,'wood','b',0,-1,-1,166,0,0,150200,20,'true','true','true','true','true','0-0','0-0;'),
(12205,'Common Item - Stockings of Doom','','legs','true','magic',303,'wood','b',0,-1,-1,52,0,236,70400,9,'true','true','true','true','true','0-0','0-0;'),
(12206,'Common Item - Dark Crystal Gaiters','','legs','true','heavy',1107,'wood','a',0,-1,-1,107,0,0,115000,9,'true','true','true','true','true','0-0','0-0;'),
(12207,'Common Item - Dark Crystal Gloves','Heavy Armor Use','gloves','true','none',193,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12208,'Common Item - Dark Crystal Gloves','Tans Armor Use','gloves','true','none',193,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12209,'Common Item - Dark Crystal Gloves','Robe Use','gloves','true','none',193,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12210,'Common Item - Dark Crystal Leather Armor','','chest','true','light',1433,'wood','a',0,-1,-1,128,0,0,137700,11,'true','true','true','true','true','0-0','0-0;'),
(12211,'Common Item - Dark Crystal Robe','','fullarmor','true','magic',817,'wood','a',0,-1,-1,139,0,665,224000,18,'true','true','true','true','true','0-0','0-0;'),
(12212,'Common Item - Dark Crystal Boots','Heavy Armor Use','feet','true','none',370,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12213,'Common Item - Dark Crystal Boots','Tans Armor Use','feet','true','none',370,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12214,'Common Item - Dark Crystal Boots','Robe Use','feet','true','none',370,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12216,'Common Item - Dark Crystal Helmet','','head','true','none',190,'wood','a',0,-1,-1,69,0,0,68800,6,'true','true','true','true','true','0-0','0-0;'),
(12217,'Common Item - Dark Crystal Breastplate','','chest','true','heavy',2567,'wood','a',0,-1,-1,171,0,0,183500,15,'true','true','true','true','true','0-0','0-0;'),
(12218,'Common Item - Dark Crystal Leggings','','legs','true','light',493,'wood','a',0,-1,-1,80,0,0,86000,7,'true','true','true','true','true','0-0','0-0;'),
(12219,'Common Item - Barbed Shirt','','underwear','true','none',43,'wood','a',0,-1,-1,23,0,0,115000,39,'true','true','true','true','true','0-0','0-0;'),
(12220,'Common Item - Sealed Dark Crystal Gaiters','','legs','true','heavy',1107,'wood','a',0,-1,-1,107,0,0,115000,9,'true','true','true','true','true','0-0','0-0;'),
(12221,'Common Item - Sealed Dark Crystal Gloves','','gloves','true','none',193,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12222,'Common Item - Sealed Dark Crystal Leather Armor','','chest','true','light',1433,'wood','a',0,-1,-1,128,0,0,137700,11,'true','true','true','true','true','0-0','0-0;'),
(12223,'Common Item - Sealed Dark Crystal Robe','','fullarmor','true','magic',817,'wood','a',0,-1,-1,139,0,665,224000,18,'true','true','true','true','true','0-0','0-0;'),
(12224,'Common Item - Sealed Dark Crystal Boots','','feet','true','none',370,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12226,'Common Item - Sealed Dark Crystal Helmet','','head','true','none',190,'wood','a',0,-1,-1,69,0,0,68800,6,'true','true','true','true','true','0-0','0-0;'),
(12227,'Common Item - Sealed Dark Crystal Breastplate','','chest','true','heavy',2567,'wood','a',0,-1,-1,171,0,0,183500,15,'true','true','true','true','true','0-0','0-0;'),
(12228,'Common Item - Sealed Dark Crystal Leggings','','legs','true','light',493,'wood','a',0,-1,-1,80,0,0,86000,7,'true','true','true','true','true','0-0','0-0;'),
(12229,'Common Item - Sealed Tallum Gloves','','gloves','true','none',193,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12230,'Common Item - Sealed Tallum Leather Armor','','fullarmor','true','light',1800,'wood','a',0,-1,-1,209,0,0,224000,18,'true','true','true','true','true','0-0','0-0;'),
(12231,'Common Item - Sealed Tallum Boots','','feet','true','none',377,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12232,'Common Item - Sealed Tallum Tunic','','chest','true','magic',620,'wood','a',0,-1,-1,86,0,409,137700,11,'true','true','true','true','true','0-0','0-0;'),
(12233,'Common Item - Sealed Tallum Plate Armor','','fullarmor','true','heavy',3260,'wood','a',0,-1,-1,278,0,0,298000,24,'true','true','true','true','true','0-0','0-0;'),
(12234,'Common Item - Sealed Tallum Helmet','','head','true','none',190,'wood','a',0,-1,-1,69,0,0,68800,6,'true','true','true','true','true','0-0','0-0;'),
(12235,'Common Item - Sealed Tallum Stockings','','legs','true','magic',307,'wood','a',0,-1,-1,53,0,256,86000,7,'true','true','true','true','true','0-0','0-0;'),
(12236,'Common Item - Tallum Gloves','Heavy Armor Use','gloves','true','none',193,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12237,'Common Item - Tallum Gloves','Tans Armor Use','gloves','true','none',193,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12238,'Common Item - Tallum Gloves','Robe Use','gloves','true','none',193,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12239,'Common Item - Tallum Leather Armor','','fullarmor','true','light',1800,'wood','a',0,-1,-1,209,0,0,224000,18,'true','true','true','true','true','0-0','0-0;'),
(12240,'Common Item - Tallum Boots','Heavy Armor Use','feet','true','none',377,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12241,'Common Item - Tallum Boots','Tans Armor Use','feet','true','none',377,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12242,'Common Item - Tallum Boots','Robe Use','feet','true','none',377,'wood','a',0,-1,-1,46,0,0,45900,4,'true','true','true','true','true','0-0','0-0;'),
(12243,'Common Item - Tallum Tunic','','chest','true','magic',620,'wood','a',0,-1,-1,86,0,409,137700,11,'true','true','true','true','true','0-0','0-0;'),
(12244,'Common Item - Tallum Plate Armor','','fullarmor','true','heavy',3260,'wood','a',0,-1,-1,278,0,0,298000,24,'true','true','true','true','true','0-0','0-0;'),
(12245,'Common Item - Tallum Helmet','','head','true','none',190,'wood','a',0,-1,-1,69,0,0,68800,6,'true','true','true','true','true','0-0','0-0;'),
(12246,'Common Item - Tallum Stockings','','legs','true','magic',307,'wood','a',0,-1,-1,53,0,256,86000,7,'true','true','true','true','true','0-0','0-0;'),
(12247,'Common Item - Majestic Gauntlet','Heavy Armor Use','gloves','true','none',180,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12248,'Common Item - Majestic Gauntlet','Tans Armor Use','gloves','true','none',180,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12249,'Common Item - Majestic Gauntlet','Robe Use','gloves','true','none',180,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12250,'Common Item - Majestic Leather Armor','','fullarmor','true','light',1783,'wood','a',0,-1,-1,220,0,0,358000,29,'true','true','true','true','true','0-0','0-0;'),
(12251,'Common Item - Majestic Robe','','fullarmor','true','magic',777,'wood','a',0,-1,-1,147,0,718,358000,29,'true','true','true','true','true','0-0','0-0;'),
(12252,'Common Item - Majestic Boots','Heavy Armor Use','feet','true','none',370,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12253,'Common Item - Majestic Boots','Tans Armor Use','feet','true','none',370,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12254,'Common Item - Majestic Boots','Robe Use','feet','true','none',370,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12255,'Common Item - Majestic Circlet','','head','true','none',183,'wood','a',0,-1,-1,73,0,0,110200,9,'true','true','true','true','true','0-0','0-0;'),
(12256,'Common Item - Majestic Plate Armor','','fullarmor','true','heavy',3067,'wood','a',0,-1,-1,293,0,0,477000,38,'true','true','true','true','true','0-0','0-0;'),
(12257,'Common Item - Sealed Majestic Gauntlet','','gloves','true','none',180,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12258,'Common Item - Sealed Majestic Leather Armor','','fullarmor','true','light',1783,'wood','a',0,-1,-1,220,0,0,358000,29,'true','true','true','true','true','0-0','0-0;'),
(12259,'Common Item - Sealed Majestic Robe','','fullarmor','true','magic',777,'wood','a',0,-1,-1,147,0,718,358000,29,'true','true','true','true','true','0-0','0-0;'),
(12260,'Common Item - Sealed Majestic Boots','','feet','true','none',370,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12261,'Common Item - Sealed Majestic Circlet','','head','true','none',183,'wood','a',0,-1,-1,73,0,0,110200,9,'true','true','true','true','true','0-0','0-0;'),
(12262,'Common Item - Sealed Majestic Plate Armor','','fullarmor','true','heavy',3067,'wood','a',0,-1,-1,293,0,0,477000,38,'true','true','true','true','true','0-0','0-0;'),
(12263,'Common Item - Sealed Armor of Nightmare','','fullarmor','true','heavy',3193,'wood','a',0,-1,-1,293,0,0,477000,38,'true','true','true','true','true','0-0','0-0;'),
(12264,'Common Item - Sealed Gauntlet of Nightmare','','gloves','true','none',183,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12265,'Common Item - Sealed Leather Armor of Nightmare','','fullarmor','true','light',1767,'wood','a',0,-1,-1,220,0,0,358000,29,'true','true','true','true','true','0-0','0-0;'),
(12266,'Common Item - Sealed Nightmare Robe','','fullarmor','true','magic',767,'wood','a',0,-1,-1,147,0,718,358000,29,'true','true','true','true','true','0-0','0-0;'),
(12267,'Common Item - Sealed Boots of Nightmare','','feet','true','none',370,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12269,'Common Item - Sealed Helm of Nightmare','','head','true','none',187,'wood','a',0,-1,-1,73,0,0,110200,9,'true','true','true','true','true','0-0','0-0;'),
(12270,'Common Item - Armor of Nightmare','','fullarmor','true','heavy',3193,'wood','a',0,-1,-1,293,0,0,477000,38,'true','true','true','true','true','0-0','0-0;'),
(12271,'Common Item - Gauntlet of Nightmare','Heavy Armor Use','gloves','true','none',183,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12272,'Common Item - Gauntlet of Nightmare','Tans Armor Use','gloves','true','none',183,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12273,'Common Item - Gauntlet of Nightmare','Robe Use','gloves','true','none',183,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12274,'Common Item - Nightmarish Leather Armor','','fullarmor','true','light',1767,'wood','a',0,-1,-1,220,0,0,358000,29,'true','true','true','true','true','0-0','0-0;'),
(12275,'Common Item - Nightmare Robe','','fullarmor','true','magic',767,'wood','a',0,-1,-1,147,0,718,358000,29,'true','true','true','true','true','0-0','0-0;'),
(12276,'Common Item - Boots of Nightmare','Heavy Armor Use','feet','true','none',370,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12277,'Common Item - Boots of Nightmare','Tans Armor Use','feet','true','none',370,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12278,'Common Item - Boots of Nightmare','Robe Use','feet','true','none',370,'wood','a',0,-1,-1,49,0,0,73500,6,'true','true','true','true','true','0-0','0-0;'),
(12280,'Common Item - Helm of Nightmare','','head','true','none',187,'wood','a',0,-1,-1,73,0,0,110200,9,'true','true','true','true','true','0-0','0-0;'),
(12281,'Common Item - Stripe Barbed Shirt','','underwear','true','none',43,'wood','a',0,-1,-1,26,0,0,184000,59,'true','true','true','true','true','0-0','0-0;'),
(12282,'Common Item - Draconic Leather Gloves','','gloves','true','none',180,'wood','s',0,-1,-1,55,0,0,259800,12,'true','true','true','true','true','0-0','0-0;'),
(12283,'Common Item - Draconic Leather Boots','','feet','true','none',370,'wood','s',0,-1,-1,55,0,0,259800,12,'true','true','true','true','true','0-0','0-0;'),
(12284,'Common Item - Draconic Leather Armor','','fullarmor','true','light',1650,'wood','s',0,-1,-1,249,0,0,1267000,61,'true','true','true','true','true','0-0','0-0;'),
(12285,'Common Item - Draconic Leather Helmet','','head','true','none',183,'wood','s',0,-1,-1,83,0,0,389700,19,'true','true','true','true','true','0-0','0-0;'),
(12286,'Common Item - Major Arcana Gloves','','gloves','true','none',180,'wood','s',0,-1,-1,55,0,0,259800,12,'true','true','true','true','true','0-0','0-0;'),
(12287,'Common Item - Major Arcana Robe','','fullarmor','true','magic',767,'wood','s',0,-1,-1,166,0,866,1267000,61,'true','true','true','true','true','0-0','0-0;'),
(12288,'Common Item - Major Arcana Boots','','feet','true','none',370,'wood','s',0,-1,-1,55,0,0,259800,12,'true','true','true','true','true','0-0','0-0;'),
(12289,'Common Item - Major Arcana Circlet','','head','true','none',183,'wood','s',0,-1,-1,83,0,0,389700,19,'true','true','true','true','true','0-0','0-0;'),
(12290,'Common Item - Mithril Shirt','','underwear','true','none',43,'wood','s',0,-1,-1,28,0,0,650000,72,'true','true','true','true','true','0-0','0-0;'),
(12291,'Common Item - Sealed Draconic Leather Gloves','','gloves','true','none',180,'wood','s',0,-1,-1,55,0,0,259800,12,'true','true','true','true','true','0-0','0-0;'),
(12292,'Common Item - Sealed Draconic Leather Boots','','feet','true','none',370,'wood','s',0,-1,-1,55,0,0,259800,12,'true','true','true','true','true','0-0','0-0;'),
(12293,'Common Item - Sealed Draconic Leather Armor','','fullarmor','true','light',1650,'wood','s',0,-1,-1,236,0,0,1267000,61,'true','true','true','true','true','0-0','0-0;'),
(12294,'Common Item - Sealed Draconic Leather Helmet','','head','true','none',183,'wood','s',0,-1,-1,83,0,0,259800,12,'true','true','true','true','true','0-0','0-0;'),
(12295,'Common Item - Sealed Major Arcana Gloves','','gloves','true','none',180,'wood','s',0,-1,-1,55,0,0,259800,12,'true','true','true','true','true','0-0','0-0;'),
(12296,'Common Item - Sealed Major Arcana Robe','','fullarmor','true','magic',767,'wood','s',0,-1,-1,157,0,866,1267000,61,'true','true','true','true','true','0-0','0-0;'),
(12297,'Common Item - Sealed Major Arcana Boots','','feet','true','none',370,'wood','s',0,-1,-1,55,0,0,259800,12,'true','true','true','true','true','0-0','0-0;'),
(12298,'Common Item - Sealed Major Arcana Circlet','','head','true','none',183,'wood','s',0,-1,-1,83,0,0,389700,19,'true','true','true','true','true','0-0','0-0;'),
(12299,'Common Item - Sealed Imperial Crusader Gaiters','','legs','true','heavy',1087,'wood','s',0,-1,-1,121,0,0,650000,31,'true','true','true','true','true','0-0','0-0;'),
(12300,'Common Item - Sealed Imperial Crusader Gauntlet','','gloves','true','none',180,'wood','s',0,-1,-1,55,0,0,259800,12,'true','true','true','true','true','0-0','0-0;'),
(12301,'Common Item - Sealed Imperial Crusader Boots','','feet','true','none',370,'wood','s',0,-1,-1,55,0,0,259800,12,'true','true','true','true','true','0-0','0-0;'),
(12303,'Common Item - Sealed Imperial Crusader Helmet','','head','true','none',183,'wood','s',0,-1,-1,83,0,0,272800,13,'true','true','true','true','true','0-0','0-0;'),
(12304,'Common Item - Sealed Imperial Crusader Breastplate','','chest','true','heavy',2540,'wood','s',0,-1,-1,193,0,0,1039000,50,'true','true','true','true','true','0-0','0-0;'),
(12305,'Common Item - Imperial Crusader Gaiters','','legs','true','heavy',1087,'wood','s',0,-1,-1,128,0,0,650000,31,'true','true','true','true','true','0-0','0-0;'),
(12306,'Common Item - Imperial Crusader Gauntlet','','gloves','true','none',180,'wood','s',0,-1,-1,55,0,0,259800,12,'true','true','true','true','true','0-0','0-0;'),
(12307,'Common Item - Imperial Crusader Boots','','feet','true','none',370,'wood','s',0,-1,-1,55,0,0,259800,12,'true','true','true','true','true','0-0','0-0;'),
(12309,'Common Item - Imperial Crusader Helmet','','head','true','none',183,'wood','s',0,-1,-1,83,0,0,272800,13,'true','true','true','true','true','0-0','0-0;'),
(12310,'Common Item - Imperial Crusader Breastplate','','chest','true','heavy',2540,'wood','s',0,-1,-1,205,0,0,1039000,50,'true','true','true','true','true','0-0','0-0;'),
(12311,'Common Item - Red Crescent','','rear,lear','true','none',50,'wood','d',0,-1,-1,0,24,0,1150,2,'true','true','true','true','true','0-0','0-0;'),
(12312,'Common Item - Necklace of Devotion','','neck','true','none',50,'wood','d',0,-1,-1,0,32,0,1530,3,'true','true','true','true','true','0-0','0-0;'),
(12313,'Common Item - Ring of Devotion','','rfinger,lfinger','true','none',50,'wood','d',0,-1,-1,0,16,0,765,1,'true','true','true','true','true','0-0','0-0;'),
(12314,'Common Item - Enchanted Earring','','rear,lear','true','none',50,'wood','d',0,-1,-1,0,27,0,1720,3,'true','true','true','true','true','0-0','0-0;'),
(12315,'Common Item - Enchanted Necklace','','neck','true','none',50,'wood','d',0,-1,-1,0,36,0,2290,4,'true','true','true','true','true','0-0','0-0;'),
(12316,'Common Item - Enchanted Ring','','rfinger,lfinger','true','none',50,'wood','d',0,-1,-1,0,18,0,1150,2,'true','true','true','true','true','0-0','0-0;'),
(12317,'Common Item - Near Forest Necklace','','neck','true','none',50,'wood','d',0,-1,-1,0,40,0,3320,6,'true','true','true','true','true','0-0','0-0;'),
(12318,'Common Item - Tiger\'s Eye','','rear,lear','true','none',50,'wood','d',0,-1,-1,0,30,0,2490,5,'true','true','true','true','true','0-0','0-0;'),
(12319,'Common Item - Black Pearl Ring','','rfinger,lfinger','true','none',50,'wood','d',0,-1,-1,0,20,0,1660,3,'true','true','true','true','true','0-0','0-0;'),
(12320,'Common Item - Elven Necklace','','neck','true','none',50,'wood','d',0,-1,-1,0,45,0,4640,8,'true','true','true','true','true','0-0','0-0;'),
(12321,'Common Item - Elven Ring','','rfinger,lfinger','true','none',50,'wood','d',0,-1,-1,0,22,0,2320,4,'true','true','true','true','true','0-0','0-0;'),
(12322,'Common Item - Elven Earring','','rear,lear','true','none',50,'wood','d',0,-1,-1,0,34,0,3480,6,'true','true','true','true','true','0-0','0-0;'),
(12323,'Common Item - Mithril Ring','','rfinger,lfinger','true','none',50,'wood','d',0,-1,-1,0,24,0,2940,5,'true','true','true','true','true','0-0','0-0;'),
(12324,'Common Item - Necklace of Darkness','','neck','true','none',50,'wood','d',0,-1,-1,0,48,0,5880,11,'true','true','true','true','true','0-0','0-0;'),
(12325,'Common Item - Omen Beast\'s Eye','','rear,lear','true','none',50,'wood','d',0,-1,-1,0,36,0,4410,8,'true','true','true','true','true','0-0','0-0;'),
(12326,'Common Item - Moonstone Earring','','rear,lear','true','none',50,'wood','c',0,-1,-1,0,39,0,5520,2,'true','true','true','true','true','0-0','0-0;'),
(12327,'Common Item - Aquastone Necklace','','neck','true','none',50,'wood','c',0,-1,-1,0,52,0,7359,3,'true','true','true','true','true','0-0','0-0;'),
(12328,'Common Item - Aquastone Ring','','rfinger,lfinger','true','none',50,'wood','c',0,-1,-1,0,26,0,3679,1,'true','true','true','true','true','0-0','0-0;'),
(12329,'Common Item - Earring of Protection','','rear,lear','true','none',50,'wood','c',0,-1,-1,0,42,0,6819,3,'true','true','true','true','true','0-0','0-0;'),
(12330,'Common Item - Necklace of Protection','','neck','true','none',50,'wood','c',0,-1,-1,0,56,0,9090,4,'true','true','true','true','true','0-0','0-0;'),
(12331,'Common Item - Ring of Protection','','rfinger,lfinger','true','none',50,'wood','c',0,-1,-1,0,28,0,4550,2,'true','true','true','true','true','0-0','0-0;'),
(12332,'Common Item - Earring of Binding','','rear,lear','true','none',50,'wood','c',0,-1,-1,0,45,0,12499,5,'true','true','true','true','true','0-0','0-0;'),
(12333,'Common Item - Ring of Ages','','rfinger,lfinger','true','none',50,'wood','c',0,-1,-1,0,30,0,8330,3,'true','true','true','true','true','0-0','0-0;'),
(12334,'Common Item - Necklace of Mermaid','','neck','true','none',50,'wood','c',0,-1,-1,0,60,0,16700,7,'true','true','true','true','true','0-0','0-0;'),
(12335,'Common Item - Nassen\'s Earring','','rear,lear','true','none',50,'wood','c',0,-1,-1,0,48,0,19300,8,'true','true','true','true','true','0-0','0-0;'),
(12336,'Common Item - Necklace of Binding','','neck','true','none',50,'wood','c',0,-1,-1,0,64,0,25699,10,'true','true','true','true','true','0-0','0-0;'),
(12337,'Common Item - Ring of Binding','','rfinger,lfinger','true','none',50,'wood','c',0,-1,-1,0,32,0,12899,5,'true','true','true','true','true','0-0','0-0;'),
(12338,'Common Item - Adamantite Earring','','rear,lear','true','none',50,'wood','b',0,-1,-1,0,51,0,24400,3,'true','true','true','true','true','0-0','0-0;'),
(12339,'Common Item - Adamantite Necklace','','neck','true','none',50,'wood','b',0,-1,-1,0,68,0,32500,4,'true','true','true','true','true','0-0','0-0;'),
(12340,'Common Item - Adamantite Ring','','rfinger,lfinger','true','none',50,'wood','b',0,-1,-1,0,34,0,16200,2,'true','true','true','true','true','0-0','0-0;'),
(12341,'Common Item - Earring of Black Ore','','rear,lear','true','none',50,'wood','b',0,-1,-1,0,54,0,43100,6,'true','true','true','true','true','0-0','0-0;'),
(12342,'Common Item - Necklace of Black Ore','','neck','true','none',50,'wood','b',0,-1,-1,0,72,0,57500,7,'true','true','true','true','true','0-0','0-0;'),
(12343,'Common Item - Ring of Black Ore','','rfinger,lfinger','true','none',50,'wood','b',0,-1,-1,0,36,0,28800,4,'true','true','true','true','true','0-0','0-0;'),
(12344,'Common Item - Sealed Phoenix Necklace','','neck','true','none',50,'wood','a',0,-1,-1,0,76,0,69000,5,'true','true','true','true','true','0-0','0-0;'),
(12345,'Common Item - Sealed Phoenix Earring','','rear,lear','true','none',50,'wood','a',0,-1,-1,0,57,0,51800,4,'true','true','true','true','true','0-0','0-0;'),
(12346,'Common Item - Sealed Phoenix Ring','','rfinger,lfinger','true','none',50,'wood','a',0,-1,-1,0,38,0,34500,3,'true','true','true','true','true','0-0','0-0;'),
(12347,'Common Item - Phoenix Necklace','','neck','true','none',50,'wood','a',0,-1,-1,0,80,26,69000,5,'true','true','true','true','true','0-0','0-0;'),
(12348,'Common Item - Phoenix Ring','','rfinger,lfinger','true','none',50,'wood','a',0,-1,-1,0,40,13,34500,3,'true','true','true','true','true','0-0','0-0;'),
(12349,'Common Item - Phoenix Earring','','rear,lear','true','none',50,'wood','a',0,-1,-1,0,60,20,51800,4,'true','true','true','true','true','0-0','0-0;'),
(12350,'Common Item - Sealed Majestic Necklace','','neck','true','none',50,'wood','a',0,-1,-1,0,80,0,108300,9,'true','true','true','true','true','0-0','0-0;'),
(12351,'Common Item - Sealed Majestic Ring','','rfinger,lfinger','true','none',50,'wood','a',0,-1,-1,0,40,0,54200,4,'true','true','true','true','true','0-0','0-0;'),
(12352,'Common Item - Sealed Majestic Earring','','rear,lear','true','none',50,'wood','a',0,-1,-1,0,60,0,81300,7,'true','true','true','true','true','0-0','0-0;'),
(12353,'Common Item - Majestic Necklace','','neck','true','none',50,'wood','a',0,-1,-1,0,85,33,108300,9,'true','true','true','true','true','0-0','0-0;'),
(12354,'Common Item - Majestic Ring','','rfinger,lfinger','true','none',50,'wood','a',0,-1,-1,0,42,17,54200,4,'true','true','true','true','true','0-0','0-0;'),
(12355,'Common Item - Majestic Earring','','rear,lear','true','none',50,'wood','a',0,-1,-1,0,63,25,81300,7,'true','true','true','true','true','0-0','0-0;'),
(12356,'Common Item - Sealed Tateossian Necklace','','neck','true','none',50,'wood','s',0,-1,-1,0,91,0,354600,17,'true','true','true','true','true','0-0','0-0;'),
(12357,'Common Item - Sealed Tateossian Ring','','rfinger,lfinger','true','none',50,'wood','s',0,-1,-1,0,46,0,177300,9,'true','true','true','true','true','0-0','0-0;'),
(12358,'Common Item - Sealed Tateossian Earring','','rear,lear','true','none',50,'wood','s',0,-1,-1,0,68,0,265900,13,'true','true','true','true','true','0-0','0-0;'),
(12359,'Common Item - Tateossian Necklace','','neck','true','none',50,'wood','s',0,-1,-1,0,95,42,354600,17,'true','true','true','true','true','0-0','0-0;'),
(12360,'Common Item - Tateossian Ring','','rfinger,lfinger','true','none',50,'wood','s',0,-1,-1,0,48,21,177300,9,'true','true','true','true','true','0-0','0-0;'),
(12361,'Common Item - Tateossian Earring','','rear,lear','true','none',50,'wood','s',0,-1,-1,0,71,31,265900,13,'true','true','true','true','true','0-0','0-0;'),
(12372,'Monkey Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(12373,'Pig Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(12740,'Baby Pet Scale Armor','','babypet','false','light',160,'wood','none',0,-1,-1,112,0,0,1877000,0,'true','true','true','true','true','0-0','0-0;'),
(12741,'Baby Pet Bronze Armor','','babypet','false','light',160,'wood','none',0,-1,-1,124,0,0,3620000,0,'true','true','true','true','true','0-0','0-0;'),
(12742,'Baby Pet Plate Armor','','babypet','false','light',160,'wood','none',0,-1,-1,136,0,0,7126000,0,'true','true','true','true','true','0-0','0-0;'),
(12743,'Baby Pet Mithril Armor','','babypet','false','light',160,'wood','none',0,-1,-1,148,0,0,12563000,0,'true','true','true','true','true','0-0','0-0;'),
(12744,'Baby Pet Oriharukon Armor','','babypet','false','light',160,'wood','none',0,-1,-1,160,0,0,24236000,0,'true','true','true','true','true','0-0','0-0;'),
(12745,'Baby Pet Orichalcum Armor','','babypet','false','light',160,'wood','none',0,-1,-1,171,0,0,48879000,0,'true','true','true','true','true','0-0','0-0;'),
(12746,'Crystal Pendant','','neck','false','none',150,'wood','none',0,-1,-1,0,22,0,3864,0,'true','true','true','true','true','0-0','0-0;'),
(12747,'Ruby Pendant','','neck','false','none',150,'wood','none',0,-1,-1,0,30,0,20181,0,'true','true','true','true','true','0-0','0-0;'),
(12748,'Sapphire Pendant','','neck','false','none',150,'wood','none',0,-1,-1,0,40,0,63897,0,'true','true','true','true','true','0-0','0-0;'),
(12749,'Diamond Pendant','','neck','false','none',150,'wood','none',0,-1,-1,0,52,0,156747,0,'true','true','true','true','true','0-0','0-0;'),
(12750,'Enria Pendant','','neck','false','none',150,'wood','none',0,-1,-1,0,66,0,462834,0,'true','true','true','true','true','0-0','0-0;'),
(12751,'Thons Pendant','','neck','false','none',150,'wood','none',0,-1,-1,0,80,0,1656980,0,'true','true','true','true','true','0-0','0-0;'),
(12752,'Asofe Pendant','','neck','false','none',150,'wood','none',0,-1,-1,0,94,0,5165599,0,'true','true','true','true','true','0-0','0-0;'),
(12766,'Gold Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(12767,'Silver Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,500000,0,'true','true','true','true','true','0-0','0-0;'),
(12779,'Agathion Seal Bracelet - Little Angel','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3423-1;5535-1;3267-1;'),
(12780,'Agathion Seal Bracelet - Little Devil','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3424-1;5536-1;3267-1;'),
(12781,'Ol Mahum Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(12782,'Kat the Cat Hat','30 day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(12783,'Feline Queen Hat','30 day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(12784,'Ant Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','true','true','0-0','0-0;'),
(12785,'Wolf Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','true','true','0-0','0-0;'),
(12786,'Monster Eye Hat','30 day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(12787,'Brown Bear Hat','30 day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(12788,'Fungus Hat','30 day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(12789,'Skull Hat','30 day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(12790,'Ornithomimus Hat','30 day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(12791,'Feline King Hat','30 day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(12792,'Kai the Cat Hat','30 day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(12811,'Arcana Sigil','','lhand','true','sigil',940,'silver','s',-8,-1,-1,13,0,0,3355000,161,'true','true','true','true','true','0-0','0-0;'),
(12812,'Dynasty Sigil','','lhand','true','sigil',930,'silver','s80',-8,-1,-1,15,0,0,4560000,221,'true','true','true','true','true','0-0','0-0;'),
(12813,'Vesper Sigil','','lhand','true','sigil',920,'silver','s84',-8,-1,-1,17,0,0,12250000,588,'true','true','true','true','true','0-0','0-0;'),
(12815,'Red Talisman - Max CP','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3664-1;'),
(12816,'Red Talisman - CP Regeneration','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3665-1;'),
(12817,'Yellow Talisman - Increase Force','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3666-1;'),
(12818,'Yellow Talisman - Damage Transition','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3667-1;'),
(12835,'Shadow Item - Teddy Bear Hat','','hairall','false','none',10,'wood','none',0,300,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(12836,'Shadow Item - Piggy Hat','','hairall','false','none',10,'wood','none',0,300,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(12837,'Shadow Item - Jester Hat','','hairall','false','none',10,'wood','none',0,300,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(12838,'Fish Hat (Event)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','true','true','0-0','0-0;'),
(12839,'Medieval Style Party Mask (Event)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(12978,'Zubei\'s Helmet','Light Armor Use','head','true','none',590,'wood','b',0,-1,-1,62,0,0,598600,80,'true','true','true','true','true','0-0','8233-1;'),
(12979,'Zubei\'s Helmet','Robe Use','head','true','none',590,'wood','b',0,-1,-1,62,0,0,598600,80,'true','true','true','true','true','0-0','8234-1;'),
(12980,'Avadon Circlet','Light Armor Use','head','true','none',590,'wood','b',0,-1,-1,62,0,0,598600,80,'true','true','true','true','true','0-0','3688-1;'),
(12981,'Avadon Circlet','Robe Use','head','true','none',590,'wood','b',0,-1,-1,62,0,0,598600,80,'true','true','true','true','true','0-0','3692-1;'),
(12982,'Doom Helmet','Light Armor Use','head','true','none',580,'wood','b',0,-1,-1,66,0,0,928300,124,'true','true','true','true','true','0-0','3704-1;'),
(12983,'Doom Helmet','Robe Use','head','true','none',580,'wood','b',0,-1,-1,66,0,0,928300,124,'true','true','true','true','true','0-0','3709-1;'),
(12984,'Blue Wolf Helmet','Light Armor Use','head','true','none',580,'wood','b',0,-1,-1,66,0,0,928300,124,'true','true','true','true','true','0-0','3718-1;'),
(12985,'Blue Wolf Helmet','Robe Use','head','true','none',580,'wood','b',0,-1,-1,66,0,0,928300,124,'true','true','true','true','true','0-0','3723-1;'),
(12986,'Dark Crystal Helmet','Light Armor Use','head','true','none',570,'wood','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','3733-1;'),
(12987,'Dark Crystal Helmet','Robe Use','head','true','none',570,'wood','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','3738-1;'),
(12988,'Tallum Helmet','Light Armor Use','head','true','none',570,'wood','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','3746-1;'),
(12989,'Tallum Helmet','Robe Use','head','true','none',570,'wood','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','3751-1;'),
(12990,'Majestic Circlet','Light Armor Use','head','true','none',550,'wood','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','3759-1;'),
(12991,'Majestic Circlet','Robe Use','head','true','none',550,'wood','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','3763-1;'),
(12992,'Helm of Nightmare','Light Armor Use','head','true','none',560,'wood','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','8235-1;'),
(12993,'Helm of Nightmare','Robe Use','head','true','none',560,'wood','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','8236-1;'),
(12994,'Sealed Dark Crystal Helmet','Light Armor Use','head','true','none',570,'wood','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','0-0;'),
(12995,'Sealed Dark Crystal Helmet','Robe Use','head','true','none',570,'wood','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','0-0;'),
(12996,'Sealed Tallum Helmet','Light Armor Use','head','true','none',570,'wood','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','0-0;'),
(12997,'Sealed Tallum Helmet','Robe Use','head','true','none',570,'wood','a',0,-1,-1,69,0,0,1336000,107,'true','true','true','true','true','0-0','0-0;'),
(12998,'Sealed Majestic Circlet','Light Armor Use','head','true','none',550,'wood','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','0-0;'),
(12999,'Sealed Majestic Circlet','Robe Use','head','true','none',550,'wood','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','0-0;'),
(13000,'Sealed Helm of Nightmare','Light Armor Use','head','true','none',560,'wood','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','0-0;'),
(13001,'Sealed Helm of Nightmare','Robe Use','head','true','none',560,'wood','a',0,-1,-1,73,0,0,2032000,163,'true','true','true','true','true','0-0','0-0;');

INSERT INTO `armor` VALUES
(13022,'Light Purple-Maned Horse Mounting Bracelet','7 day limited period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8247-1;'),
(13023,'Agathion of Love','30-day limited period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8245-1;3267-1;'),
(13024,'Sudden Agathion','30-day limited period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8257-1;5956-1;3267-1;'),
(13025,'Shiny Agathion','30-day limited period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8256-1;5955-1;3267-1;'),
(13026,'Sobbing Agathion','30-day limited period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8258-1;5957-1;3267-1;'),
(13050,'Tigress exclusive armor','','underwear','false','light',160,'wood','none',0,-1,-1,49,49,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13058,'Silenos Hair Accessory','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13074,'Shadow Item - Top Hat','','hairall','false','none',10,'wood','none',0,10080,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13075,'Shadow Item - Black Mask','','hairall','false','none',10,'wood','none',0,10080,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13076,'Shadow Item - Rider Goggles','','hairall','false','none',10,'wood','none',0,10080,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13078,'Arcana Sigil','','lhand','true','sigil',940,'wood','s',-8,-1,-1,13,0,0,3355000,161,'true','true','true','true','true','0-0','8310-1;'),
(13137,'Vesper Helmet','','head','true','none',530,'fine_steel','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(13138,'Vesper Leather Helmet','','head','true','none',530,'wood','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(13139,'Vesper Circlet','','head','true','none',530,'cloth','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(13140,'Vesper Noble Helmet','','head','true','none',530,'fine_steel','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(13141,'Vesper Noble Leather Helmet','','head','true','none',530,'wood','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(13142,'Vesper Noble Circlet','','head','true','none',530,'cloth','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(13143,'Sealed Vesper Helmet','','head','true','none',530,'fine_steel','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(13144,'Sealed Vesper Leather Helmet','','head','true','none',530,'wood','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(13145,'Sealed Vesper Circlet','','head','true','none',530,'cloth','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(13146,'Sealed Vesper Noble Helmet','','head','true','none',530,'fine_steel','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(13147,'Sealed Vesper Noble Leather Helmet','','head','true','none',530,'wood','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(13148,'Sealed Vesper Noble Circlet','','head','true','none',530,'cloth','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(13234,'Varka Karm (used by Varka Silenos)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13235,'Ketra Karm (used by Ketra Orcs)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13236,'AU Karm','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13237,'AR Karm','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13238,'AE Karm','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13239,'Kat the Cat Hat','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13240,'Feline Queen Hat','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13241,'Monster Eye Hat','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13242,'Brown Bear Hat','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13243,'Fungus Hat','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13244,'Skull Hat','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13245,'Ornithomimus Hat','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13246,'Feline King Hat','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13247,'Kai the Cat Hat','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13254,'Agathion of Love','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8245-1;3267-1;'),
(13260,'Gran Kain\'s Squeaking Shoes','10 hours limited period','feet','false','none',50,'wood','none',0,-1,600,0,0,0,0,0,'false','false','true','true','true','0-0','0-0;'),
(13293,'Pailaka Earring','','rear,lear','false','none',150,'wood','d',0,-1,-1,0,43,20,0,0,'false','false','true','false','true','0-0','0-0;'),
(13294,'Pailaka Ring','','rfinger,lfinger','false','none',150,'wood','d',0,-1,-1,0,29,15,0,0,'false','false','true','false','true','0-0','0-0;'),
(13295,'Pailaka Bracelet','','rbracelet','false','none',150,'wood','b',0,-1,-1,0,0,20,0,0,'false','false','true','false','true','0-0','3323-1;'),
(13296,'Pailaka Shirt','','underwear','false','none',130,'wood','a',0,-1,-1,28,0,40,0,0,'false','false','true','false','true','0-0','0-0;'),
(13308,'Light Purple-Maned Horse Mounting Bracelet (Event)','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8247-1;'),
(13309,'Agathion of Love (Event)','30-day limited period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8245-1;3267-1;'),
(13310,'Kat the Cat Hat (Event)','30-day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13311,'Feline Queen Hat (Event)','30-day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13312,'Monster Eye Hat (Event)','30-day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13313,'Brown Bear Hat (Event)','30-day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13314,'Fungus Hat (Event)','30-day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13315,'Skull Hat (Event)','30-day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13316,'Ornithomimus Hat (Event)','30-day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13317,'Feline King Hat (Event)','30-day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13318,'Kai the Cat Hat (Event)','30-day limited period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13325,'Kat the Cat Hat (Event)','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13326,'Feline Queen Hat (Event)','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13327,'Monster Eye Hat (Event)','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13328,'Brown Bear Hat (Event)','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13329,'Fungus Hat (Event)','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13330,'Skull Hat (Event)','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13331,'Ornithomimus Hat (Event)','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13332,'Feline King Hat (Event)','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13333,'Kai the Cat Hat (Event)','7-day Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13340,'Agathion of Love (Event)','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8245-1;3267-1;'),
(13389,'Kratei Barbed Shirt','CP','underwear','true','none',130,'wood','a',0,-1,-1,23,0,0,0,0,'false','false','true','false','true','3453-1','0-0;'),
(13390,'Kratei Mithril Shirt','CP','underwear','true','none',130,'wood','s',0,-1,-1,28,0,0,0,0,'false','false','true','false','true','3459-1','0-0;'),
(13391,'Kratei Striped Barbed Shirt','CP','underwear','true','none',130,'wood','a',0,-1,-1,26,0,0,0,0,'false','false','true','false','true','3477-1','0-0;'),
(13392,'Kratei Striped Mithril Shirt','CP','underwear','true','none',130,'wood','s',0,-1,-1,30,0,0,0,0,'true','true','true','true','true','3483-1','0-0;'),
(13393,'Shadow Item - Monkey Hat','','hairall','false','none',10,'wood','none',0,100,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13394,'Shadow Item - Pig Hat','','hairall','false','none',10,'wood','none',0,100,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13415,'Frog Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13416,'Chicken Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13429,'Teddy Bear Hat (Event)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13430,'Piggy Hat (Event)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13431,'Jester Hat (Event)','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13432,'Vesper Breastplate','','chest','true','heavy',7520,'fine_steel','s84',0,-1,-1,250,0,0,46668000,2240,'true','true','true','true','true','0-0','0-0;'),
(13433,'Vesper Leather Breastplate','','chest','true','light',4140,'wood','s84',0,-1,-1,187,0,0,35000000,1680,'true','true','true','true','true','0-0','0-0;'),
(13434,'Vesper Tunic','','chest','true','magic',1750,'cloth','s84',0,-1,-1,125,0,637,35000000,1680,'true','true','true','true','true','0-0','0-0;'),
(13435,'Vesper Noble Breastplate','','chest','true','heavy',7520,'fine_steel','s84',0,-1,-1,250,0,0,55840000,2680,'true','true','true','true','true','0-0','0-0;'),
(13436,'Vesper Noble Leather Breastplate','','chest','true','light',4140,'wood','s84',0,-1,-1,187,0,0,41880000,2010,'true','true','true','true','true','0-0','0-0;'),
(13437,'Vesper Noble Tunic','','chest','true','magic',1750,'cloth','s84',0,-1,-1,125,0,637,41880000,2010,'true','true','true','true','true','0-0','0-0;'),
(13438,'Vesper Gaiters','','legs','true','heavy',3170,'fine_steel','s84',0,-1,-1,156,0,0,29168000,1400,'true','true','true','true','true','0-0','0-0;'),
(13439,'Vesper Gauntlet','','gloves','true','none',510,'fine_steel','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(13440,'Vesper Boots','','feet','true','none',1070,'fine_steel','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(13441,'Vesper Leather Leggings','','legs','true','light',1320,'wood','s84',0,-1,-1,117,0,0,21876000,1050,'true','true','true','true','true','0-0','0-0;'),
(13442,'Vesper Leather Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(13443,'Vesper Leather Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(13444,'Vesper Stockings','','legs','true','magic',850,'cloth','s84',0,-1,-1,78,0,415,21876000,1050,'true','true','true','true','true','0-0','0-0;'),
(13445,'Vesper Gloves','','gloves','true','none',510,'cloth','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(13446,'Vesper Shoes','','feet','true','none',1070,'cloth','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(13448,'Vesper Noble Gaiters','','legs','true','heavy',3170,'fine_steel','s84',0,-1,-1,156,0,0,34900000,1675,'true','true','true','true','true','0-0','0-0;'),
(13449,'Vesper Noble Gauntlet','','gloves','true','none',510,'fine_steel','s84',0,-1,-1,68,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(13450,'Vesper Noble Boots','','feet','true','none',1070,'fine_steel','s84',0,-1,-1,68,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(13451,'Vesper Noble Leather Leggings','','legs','true','light',1320,'wood','s84',0,-1,-1,117,0,0,26175000,1256,'true','true','true','true','true','0-0','0-0;'),
(13452,'Vesper Noble Leather Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,13960000,510,'true','true','true','true','true','0-0','0-0;'),
(13453,'Vesper Noble Leather Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,13960000,510,'true','true','true','true','true','0-0','0-0;'),
(13454,'Vesper Noble Stockings','','legs','true','magic',850,'cloth','s84',0,-1,-1,78,0,415,26175000,1256,'true','true','true','true','true','0-0','0-0;'),
(13455,'Vesper Noble Gloves','','gloves','true','none',510,'cloth','s84',0,-1,-1,68,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(13456,'Vesper Noble Shoes','','feet','true','none',1070,'cloth','s84',0,-1,-1,68,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(13472,'Circlet of Innadril Valor','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13473,'Circlet of Aden Valor','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13474,'Circlet of Dion Valor','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13475,'Circlet of Dion Sniper','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13476,'Circlet of Innadril Sniper','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13477,'Circlet of Oren Sniper','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13478,'Circlet of Gludio Sage','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13479,'Circlet of Rune Sage','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13480,'Circlet of Giran Sage','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13481,'Circlet of Goddard Combat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13482,'Circlet of Schuttgart Combat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13483,'Circlet of Oren Combat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13484,'Circlet of Gludio Silence','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13485,'Circlet of Schuttgart Silence','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13486,'Circlet of Aden Unity','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13487,'Circlet of Rune Silence','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,2000000,0,'true','true','true','true','true','0-0','0-0;'),
(13488,'Birthday Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13489,'Halloween Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13490,'Arrow-Pierced Apple','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13491,'Popped-Out Eye','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13492,'Graduation Cap','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13493,'Refined Carnival Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13494,'Refined Angel Ring','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13495,'Refined Devil Horn','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13496,'Refined Pirate Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13497,'Refined Chick Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13498,'Refined Wizard Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13499,'Refined Jester Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13500,'Refined Black Feather Mask','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13501,'Refined Romantic Chapeau','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13502,'Refined Carnival Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13503,'Refined Medieval Style Party Mask','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13504,'Refined Dapper Cap','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13505,'Clownfish Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13506,'Improved Lord\'s Crown','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13507,'Circlet of Flames','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13508,'Circlet of Freeze','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13509,'Circlet of Storm','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13510,'Circlet of Earthquake','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13511,'Circlet of Darkness','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13512,'Circlet of Splendor','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13513,'Mining Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13514,'Improved Mining Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13515,'Search Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13516,'Improved Search Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13517,'Event - Raccoon Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13518,'Event - Top Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13519,'Event - Black Mask','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13520,'Event - Jindo Dog Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13521,'Event - Shaggy Dog Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13522,'Event - Rider Goggles','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13523,'Event - Lineage Souvenir Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(13526,'Test Belt','','belt','true','light',4830,'wood','none',0,-1,-1,36,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13527,'Test Cloak','','back','false','none',260,'wood','none',0,-1,-1,2,0,0,37,0,'true','true','true','true','true','0-0','0-0;'),
(13529,'Test Sigil','','lhand','false','sigil',1430,'wood','none',-8,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13543,'Agathion Summon Bracelet - Collection','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8251-1;5780-1;3267-1;'),
(13544,'Agathion Summon Bracelet - Boy Teddy Bear','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8259-1;5958-1;3267-1;'),
(13545,'Agathion Summon Bracelet - Girl Teddy Bear','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8260-1;5959-1;3267-1;'),
(13546,'Steam Sledge Mounting Bracelet','','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8261-1;'),
(13547,'Tawny-Maned Lion Mounting Bracelet','','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8262-1;'),
(13687,'Knight\'s Cloak','','back','false','none',220,'wood','s84',0,-1,-1,20,0,0,28671000,0,'false','false','true','false','true','0-0','0-0;'),
(13688,'Knight\'s Cloak - Light Armor exclusive','','back','false','none',220,'wood','s84',0,-1,-1,20,0,0,28671000,0,'false','false','true','false','true','0-0','0-0;'),
(13689,'Knight\'s Cloak - Robe exclusive','','back','false','none',220,'wood','s84',0,-1,-1,20,0,0,28671000,0,'false','false','true','false','true','0-0','0-0;'),
(13690,'Knight\'s Cloak - Kamael exclusive','','back','false','none',220,'wood','s84',0,-1,-1,20,0,0,28671000,0,'false','false','true','false','true','0-0','0-0;'),
(13740,'Gludio Water Protection Necklace','','neck','false','none',150,'wood','a',0,-1,-1,0,85,33,0,0,'false','false','true','false','true','0-0','8388-1;'),
(13741,'Dion Divinity Protection Necklace','','neck','false','none',150,'wood','a',0,-1,-1,0,85,33,0,0,'false','false','true','false','true','0-0','8389-1;'),
(13742,'Giran Wind Protection Necklace','','neck','false','none',150,'wood','a',0,-1,-1,0,85,33,0,0,'false','false','true','false','true','0-0','8390-1;'),
(13743,'Oren Darkness Protection Necklace','','neck','false','none',150,'wood','a',0,-1,-1,0,85,33,0,0,'false','false','true','false','true','0-0','8391-1;'),
(13744,'Aden Earth Protection Necklace','','neck','false','none',150,'wood','a',0,-1,-1,0,85,33,0,0,'false','false','true','false','true','0-0','8392-1;'),
(13745,'Innadril Water Protection Necklace','','neck','false','none',150,'wood','a',0,-1,-1,0,85,33,0,0,'false','false','true','false','true','0-0','8393-1;'),
(13746,'Goddard Fire Protection Necklace','','neck','false','none',150,'wood','a',0,-1,-1,0,85,33,0,0,'false','false','true','false','true','0-0','8394-1;'),
(13747,'Rune Fire Protection Necklace','','neck','false','none',150,'wood','a',0,-1,-1,0,85,33,0,0,'false','false','true','false','true','0-0','8395-1;'),
(13748,'Schuttgart Wind Protection Necklace','','neck','false','none',150,'wood','a',0,-1,-1,0,85,33,0,0,'false','false','true','false','true','0-0','8396-1;'),
(13751,'Warrior\'s T-shirt','','underwear','true','none',130,'wood','a',0,-1,-1,28,0,0,0,0,'false','false','true','false','true','8324-1','0-0;'),
(13752,'Olympiad Warrior\'s Ring','','rfinger,lfinger','true','none',150,'wood','a',0,-1,43200,0,42,21,0,0,'false','false','true','false','true','0-0','8292-1;'),
(13753,'Olympiad Warrior\'s Necklace','','neck','false','none',150,'wood','a',0,-1,43200,0,85,26,0,0,'false','false','true','false','true','0-0','8294-1;'),
(13754,'Olympiad Warrior\'s Earring','','rear,lear','false','none',150,'wood','a',0,-1,43200,0,63,31,0,0,'false','false','true','false','true','0-0','8293-1;'),
(13756,'Agathion Summon Bracelet - Knight','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8275-1;3267-1;'),
(13802,'Native\'s Hood','','head','false','none',70,'wood','none',0,-1,-1,33,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13803,'Native\'s Tunic','','chest','false','light',4720,'wood','none',0,-1,-1,53,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13804,'Native\'s Trousers','','legs','false','light',1700,'wood','none',0,-1,-1,29,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13805,'Guards of the Dawn Helmet','','head','true','none',70,'wood','none',0,-1,-1,33,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13806,'Guards of the Dawn Tunic','','chest','false','light',4720,'wood','none',0,-1,-1,53,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13807,'Guards of the Dawn Trousers','','legs','false','light',1700,'wood','none',0,-1,-1,29,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13885,'Sealed Arcana Sigil','','lhand','true','sigil',940,'wood','s',-8,-1,-1,13,0,0,3355000,161,'true','true','true','true','true','0-0','0-0;'),
(13886,'Sealed Dynasty Sigil','','lhand','true','sigil',930,'wood','s80',-8,-1,-1,15,0,0,6404000,307,'true','true','true','true','true','0-0','0-0;'),
(13887,'Sealed Vesper Sigil','','lhand','true','sigil',920,'wood','s84',-8,-1,-1,17,0,0,12250000,588,'true','true','true','true','true','0-0','0-0;'),
(13888,'Sealed Lord\'s Cloak','','back','false','none',220,'wood','s84',0,-1,-1,2,0,0,28671000,0,'true','true','true','true','true','0-0','0-0;'),
(13889,'Holy Spirit\'s Cloak - Kamael exclusive','','back','false','none',220,'wood','s84',0,-1,-1,20,0,0,28671000,0,'true','true','true','true','true','0-0','0-0;'),
(13890,'Holy Spirit\'s Cloak','','back','false','none',220,'wood','s84',0,-1,-1,20,0,0,28671000,0,'true','true','true','true','true','0-0','0-0;'),
(13891,'Holy Spirit\'s Cloak - Light Armor exclusive','','back','false','none',220,'wood','s84',0,-1,-1,20,0,0,28671000,0,'true','true','true','true','true','0-0','0-0;'),
(13892,'Holy Spirit\'s Cloak - Robe exclusive','','back','false','none',220,'wood','s84',0,-1,-1,20,0,0,28671000,0,'true','true','true','true','true','0-0','0-0;'),
(13894,'Cloth Belt','','belt','true','light',500,'wood','c',0,-1,-1,10,0,0,45100,18,'true','true','true','true','true','0-0','0-0;'),
(13895,'Leather Belt','','belt','true','light',480,'wood','b',0,-1,-1,11,0,0,165000,22,'true','true','true','true','true','0-0','0-0;'),
(13896,'Iron Belt','','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,371300,30,'true','true','true','true','true','0-0','0-0;'),
(13897,'Mithril Belt','','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,1917000,92,'true','true','true','true','true','0-0','0-0;'),
(13938,'Low-Grade Magic Pouch Cloth Belt','','belt','true','light',500,'wood','c',0,-1,-1,10,0,0,45100,18,'true','true','true','true','true','0-0','8290-3;'),
(13939,'Regular Magic Pouch Cloth Belt','','belt','true','light',500,'wood','c',0,-1,-1,10,0,0,45100,18,'true','true','true','true','true','0-0','8290-4;'),
(13940,'High-Grade Magic Pouch Cloth Belt','','belt','true','light',500,'wood','c',0,-1,-1,10,0,0,45100,18,'true','true','true','true','true','0-0','8290-5;'),
(13941,'Top-Grade Magic Pouch Cloth Belt','','belt','true','light',500,'wood','c',0,-1,-1,10,0,0,45100,18,'true','true','true','true','true','0-0','8290-6;'),
(13942,'Low-Grade Magic Pouch Leather Belt','','belt','true','light',480,'wood','b',0,-1,-1,11,0,0,165000,22,'true','true','true','true','true','0-0','8290-5;'),
(13943,'Regular Magic Pouch Leather Belt','','belt','true','light',480,'wood','b',0,-1,-1,11,0,0,165000,22,'true','true','true','true','true','0-0','8290-6;'),
(13944,'High-Grade Magic Pouch Leather Belt','','belt','true','light',480,'wood','b',0,-1,-1,11,0,0,165000,22,'true','true','true','true','true','0-0','8290-7;'),
(13945,'Top-Grade Magic Pouch Leather Belt','','belt','true','light',480,'wood','b',0,-1,-1,11,0,0,165000,22,'true','true','true','true','true','0-0','8290-8;'),
(13946,'Low-Grade Magic Pouch Iron Belt','','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,371300,30,'true','true','true','true','true','0-0','8290-7;'),
(13947,'Regular Magic Pouch Iron Belt','','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,371300,30,'true','true','true','true','true','0-0','8290-8;'),
(13948,'High-Grade Magic Pouch Iron Belt','','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,371300,30,'true','true','true','true','true','0-0','8290-9;'),
(13949,'Top-Grade Magic Pouch Iron Belt','','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,371300,30,'true','true','true','true','true','0-0','8290-10;'),
(13950,'Low-Grade Magic Pouch Mithril Belt','','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,1917000,92,'true','true','true','true','true','0-0','8290-9;'),
(13951,'Regular Magic Pouch Mithril Belt','','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,1917000,92,'true','true','true','true','true','0-0','8290-10;'),
(13952,'High-Grade Magic Pouch Mithril Belt','','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,1917000,92,'true','true','true','true','true','0-0','8290-11;'),
(13953,'Top-Grade Magic Pouch Mithril Belt','','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,1917000,92,'true','true','true','true','true','0-0','8290-12;'),
(13954,'Low-Grade Magic Pin Cloth Belt','','belt','true','light',500,'wood','c',0,-1,-1,10,0,0,45100,18,'true','true','true','true','true','0-0','8291-3;'),
(13955,'Regular Magic Pin Cloth Belt','','belt','true','light',500,'wood','c',0,-1,-1,10,0,0,45100,18,'true','true','true','true','true','0-0','8291-4;'),
(13956,'High-Grade Magic Pin Cloth Belt','','belt','true','light',500,'wood','c',0,-1,-1,10,0,0,45100,18,'true','true','true','true','true','0-0','8291-5;'),
(13957,'Top-Grade Magic Pin Cloth Belt','','belt','true','light',500,'wood','c',0,-1,-1,10,0,0,45100,18,'true','true','true','true','true','0-0','8291-6;'),
(13958,'Low-Grade Magic Pin Leather Belt','','belt','true','light',480,'wood','b',0,-1,-1,11,0,0,165000,22,'true','true','true','true','true','0-0','8291-5;'),
(13959,'Regular Magic Pin Leather Belt','','belt','true','light',480,'wood','b',0,-1,-1,11,0,0,165000,22,'true','true','true','true','true','0-0','8291-6;'),
(13960,'High-Grade Magic Pin Leather Belt','','belt','true','light',480,'wood','b',0,-1,-1,11,0,0,165000,22,'true','true','true','true','true','0-0','8291-7;'),
(13961,'Top-Grade Magic Pin Leather Belt','','belt','true','light',480,'wood','b',0,-1,-1,11,0,0,165000,22,'true','true','true','true','true','0-0','8291-8;'),
(13962,'Low-Grade Magic Pin Iron Belt','','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,371300,30,'true','true','true','true','true','0-0','8291-7;'),
(13963,'Regular Magic Pin Iron Belt','','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,371300,30,'true','true','true','true','true','0-0','8291-8;'),
(13964,'High-Grade Magic Pin Iron Belt','','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,371300,30,'true','true','true','true','true','0-0','8291-9;'),
(13965,'Top-Grade Magic Pin Iron Belt','','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,371300,30,'true','true','true','true','true','0-0','8291-10;'),
(13966,'Low-Grade Magic Pin Mithril Belt','','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,1917000,92,'true','true','true','true','true','0-0','8291-9;'),
(13967,'Regular Magic Pin Mithril Belt','','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,1917000,92,'true','true','true','true','true','0-0','8291-10;'),
(13968,'High-Grade Magic Pin Mithril Belt','','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,1917000,92,'true','true','true','true','true','0-0','8291-11;'),
(13969,'Top-Grade Magic Pin Mithril Belt','','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,1917000,92,'true','true','true','true','true','0-0','8291-12;'),
(13975,'Poison Bottle 1','','talisman','false','light',4830,'wood','c',0,-1,-1,36,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13976,'Poison Bottle 2','','talisman','false','light',4830,'wood','b',0,-1,-1,36,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(13977,'Poison Bottle 3','','talisman','false','light',4830,'wood','a',0,-1,-1,36,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(14027,'Collection Agathion Summon Bracelet','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8251-1;5780-3;3267-1;'),
(14053,'Gold-Maned Lion Mounting Bracelet','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8262-1;'),
(14054,'Steam Beatle Mounting Bracelet','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8261-1;'),
(14059,'Teddy Boy Agathion Bracelet','30-day limited period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8259-1;5958-1;3267-1;'),
(14060,'Teddy Girl Agathion Bracelet','30-day limited period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8260-1;5959-1;3267-1;'),
(14066,'Gold Maned Lion Mounting Bracelet (event)','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8262-1;'),
(14067,'Steam Beatle Mounting Bracelet (event)','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8261-1;'),
(14072,'Teddy Boy Agathion Bracelet (event)','30-day limited period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8259-1;5958-1;3267-1;'),
(14073,'Teddy Girl Agathion Bracelet (event)','30-day limited period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8260-1;5959-1;3267-1;'),
(14075,'Sudden Agathion (Event)','30-day limited period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8257-1;5956-1;3267-1;'),
(14076,'Shiny Agathion (Event)','30-day limited period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8256-1;5955-1;3267-1;'),
(14077,'Sobbing Agathion (Event)','30-day limited period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8258-1;5957-1;3267-1;'),
(14091,'Teddy Boy Agathion Bracelet','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8259-1;5958-1;3267-1;'),
(14092,'Teddy Girl Agathion Bracelet','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8260-1;5959-1;3267-1;'),
(14093,'Sudden Agathion','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8257-1;5956-1;3267-1;'),
(14094,'Shiny Agathion','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8256-1;5955-1;3267-1;'),
(14095,'Sobbing Agathion','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8258-1;5957-1;3267-1;'),
(14099,'Teddy Boy Agathion Bracelet (event)','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8259-1;5958-1;3267-1;'),
(14100,'Teddy Girl Agathion Bracelet (event)','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8260-1;5959-1;3267-1;'),
(14101,'Sudden Agathion (Event)','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8257-1;5956-1;3267-1;'),
(14102,'Shiny Agathion (Event)','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8256-1;5955-1;3267-1;'),
(14103,'Sobbing Agathion (Event)','7-day Limited Period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8258-1;5957-1;3267-1;'),
(14104,'Shadow Item - Collection Agathion Summon Bracelet','','lbracelet','false','none',150,'wood','none',0,600,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8251-1;5780-3;3267-1;'),
(14105,'Sealed Vesper Breastplate','','chest','true','heavy',7520,'fine_steel','s84',0,-1,-1,236,0,0,46668000,2240,'true','true','true','true','true','0-0','0-0;'),
(14106,'Sealed Vesper Leather Breastplate','','chest','true','light',4140,'wood','s84',0,-1,-1,177,0,0,35000000,1680,'true','true','true','true','true','0-0','0-0;'),
(14107,'Sealed Vesper Tunic','','chest','true','magic',1750,'cloth','s84',0,-1,-1,118,0,637,35000000,1680,'true','true','true','true','true','0-0','0-0;'),
(14108,'Sealed Vesper Gaiters','','legs','true','heavy',3170,'fine_steel','s84',0,-1,-1,148,0,0,29168000,1400,'true','true','true','true','true','0-0','0-0;'),
(14109,'Sealed Vesper Gauntlet','','gloves','true','none',510,'fine_steel','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(14110,'Sealed Vesper Boots','','feet','true','none',1070,'fine_steel','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(14112,'Sealed Vesper Leather Leggings','','legs','true','light',1320,'wood','s84',0,-1,-1,111,0,0,21876000,1050,'true','true','true','true','true','0-0','0-0;'),
(14113,'Sealed Vesper Leather Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(14114,'Sealed Vesper Leather Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(14115,'Sealed Vesper Stockings','','legs','true','magic',850,'cloth','s84',0,-1,-1,74,0,415,21876000,1050,'true','true','true','true','true','0-0','0-0;'),
(14116,'Sealed Vesper Gloves','','gloves','true','none',510,'cloth','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(14117,'Sealed Vesper Shoes','','feet','true','none',1070,'cloth','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(14160,'Sealed Vesper Earring','','rear,lear','true','none',150,'wood','s84',0,-1,-1,0,83,0,6986000,335,'true','true','true','true','true','0-0','0-0;'),
(14161,'Sealed Vesper Necklace','','neck','true','none',150,'wood','s84',0,-1,-1,0,110,0,9315000,447,'true','true','true','true','true','0-0','0-0;'),
(14162,'Sealed Vesper Ring','','rfinger,lfinger','true','none',150,'wood','s84',0,-1,-1,0,55,0,4658000,224,'true','true','true','true','true','0-0','0-0;'),
(14163,'Vesper Earring','','rear,lear','true','none',150,'gold','s84',0,-1,-1,0,94,37,11394000,547,'true','true','true','true','true','0-0','0-0;'),
(14164,'Vesper Necklace','','neck','true','none',150,'gold','s84',0,-1,-1,0,125,50,15192000,729,'true','true','true','true','true','0-0','0-0;'),
(14165,'Vesper Ring','','rfinger,lfinger','true','none',150,'gold','s84',0,-1,-1,0,62,25,7596000,365,'true','true','true','true','true','0-0','0-0;'),
(14520,'Vesper Breastplate {PvP}','','chest','false','heavy',7520,'fine_steel','s84',0,-1,-1,250,0,0,46668000,2240,'false','false','true','false','true','0-0','0-0;'),
(14521,'Vesper Leather Breastplate {PvP}','','chest','false','light',4140,'wood','s84',0,-1,-1,187,0,0,35000000,1680,'false','false','true','false','true','0-0','0-0;'),
(14522,'Vesper Tunic {PvP}','','chest','false','magic',1750,'cloth','s84',0,-1,-1,125,0,637,35000000,1680,'false','false','true','false','true','0-0','0-0;'),
(14523,'Vesper Noble Breastplate {PvP}','','chest','false','heavy',7520,'fine_steel','s84',0,-1,-1,250,0,0,55840000,2680,'false','false','true','false','true','0-0','0-0;'),
(14524,'Vesper Noble Leather Breastplate {PvP}','','chest','false','light',4140,'wood','s84',0,-1,-1,187,0,0,41880000,2010,'false','false','true','false','true','0-0','0-0;'),
(14525,'Vesper Noble Tunic {PvP}','','chest','false','magic',1750,'cloth','s84',0,-1,-1,125,0,637,41880000,2010,'false','false','true','false','true','0-0','0-0;'),
(14582,'Apella Combat Helmet','','head','false','none',570,'wood','a',0,-1,-1,73,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14583,'Apella Combat Armor','','fullarmor','false','heavy',9780,'wood','a',0,-1,-1,293,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14584,'Apella Combat Gauntlet','Heavy Armor Use','gloves','false','none',580,'wood','a',0,-1,-1,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14585,'Apella Combat Boots','Heavy Armor Use','feet','false','none',1130,'wood','a',0,-1,-1,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14586,'Apella Combat Clothes','','fullarmor','false','light',5400,'wood','a',0,-1,-1,220,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14587,'Apella Combat Leather Gloves','Tans Armor Use','gloves','false','none',580,'wood','a',0,-1,-1,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14588,'Apella Combat Shoes','Tans Armor Use','feet','false','none',1130,'wood','a',0,-1,-1,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14589,'Apella Combat Overcoat','','fullarmor','false','magic',2450,'wood','a',0,-1,-1,147,0,718,0,0,'false','false','true','false','true','0-0','0-0;'),
(14590,'Apella Combat Silk Gloves','Robe Use','gloves','false','none',580,'wood','a',0,-1,-1,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14591,'Apella Combat Sandals','Robe Use','feet','false','none',1130,'wood','a',0,-1,-1,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14592,'Gludio Earth Protection Ring','','rfinger,lfinger','false','none',150,'wood','a',0,-1,-1,0,42,17,0,0,'false','false','true','false','true','0-0','8379-1;'),
(14593,'Dion Water Protection Ring','','rfinger,lfinger','false','none',150,'wood','a',0,-1,-1,0,42,17,0,0,'false','false','true','false','true','0-0','8380-1;'),
(14594,'Giran Fire Protection Ring','','rfinger,lfinger','false','none',150,'wood','a',0,-1,-1,0,42,17,0,0,'false','false','true','false','true','0-0','8381-1;'),
(14595,'Oren Earth Protection Ring','','rfinger,lfinger','false','none',150,'wood','a',0,-1,-1,0,42,17,0,0,'false','false','true','false','true','0-0','8382-1;'),
(14596,'Aden Divinity Protection Ring','','rfinger,lfinger','false','none',150,'wood','a',0,-1,-1,0,42,17,0,0,'false','false','true','false','true','0-0','8383-1;'),
(14597,'Innadril Divinity Protection Ring','','rfinger,lfinger','false','none',150,'wood','a',0,-1,-1,0,42,17,0,0,'false','false','true','false','true','0-0','8384-1;'),
(14598,'Goddard Dark Protection Ring','','rfinger,lfinger','false','none',150,'wood','a',0,-1,-1,0,42,17,0,0,'false','false','true','false','true','0-0','8385-1;'),
(14599,'Rune Wind Protection Ring','','rfinger,lfinger','false','none',150,'wood','a',0,-1,-1,0,42,17,0,0,'false','false','true','false','true','0-0','8386-1;'),
(14600,'Schuttgart Dark Protection Ring','','rfinger,lfinger','false','none',150,'wood','a',0,-1,-1,0,42,17,0,0,'false','false','true','false','true','0-0','8387-1;'),
(14601,'Ancient Cloak - Kamael exclusive','Kamael Use','back','false','none',220,'wood','s80',0,-1,-1,20,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14602,'Ancient Cloak','','back','false','none',220,'wood','s80',0,-1,-1,20,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14604,'Red Talisman - Territory Guardian','','talisman','false','none',150,'wood','none',0,66,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8308-1;'),
(14605,'Red Talisman - Territory Guard','','talisman','false','none',150,'wood','none',0,66,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8309-1;'),
(14608,'Ancient Cloak - Light Armor exclusive','','back','false','none',220,'wood','s80',0,-1,-1,20,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14609,'Ancient Cloak','','back','false','none',220,'wood','s80',0,-1,-1,20,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14610,'Ancient Cloak - Robe exclusive','','back','false','none',220,'wood','s80',0,-1,-1,20,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14611,'Rudolph\'s Nose','','face','false','none',10,'wood','none',0,-1,20160,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(14613,'Rock-Paper-Scissors Santa Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(14617,'Agathion Seal Bracelet - Rudolph','','lbracelet','false','none',150,'wood','none',0,-1,20160,0,0,0,0,0,'false','false','true','false','true','0-0','3425-1;3267-1;5537-1;'),
(14664,'Gludio Protection Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,63,25,0,0,'false','false','true','false','true','0-0','8348-1;'),
(14665,'Dion Protection Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,63,25,0,0,'false','false','true','false','true','0-0','8349-1;'),
(14666,'Giran Protection Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,63,25,0,0,'false','false','true','false','true','0-0','8350-1;'),
(14667,'Oren Protection Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,63,25,0,0,'false','false','true','false','true','0-0','8351-1;'),
(14668,'Aden Protection Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,63,25,0,0,'false','false','true','false','true','0-0','8352-1;'),
(14669,'Innadril Protection Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,63,25,0,0,'false','false','true','false','true','0-0','8353-1;'),
(14670,'Goddard Protection Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,63,25,0,0,'false','false','true','false','true','0-0','8354-1;'),
(14671,'Rune Protection Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,63,25,0,0,'false','false','true','false','true','0-0','8355-1;'),
(14672,'Schuttgart Protection Earring','','rear,lear','true','none',150,'silver','a',0,-1,-1,0,63,25,0,0,'false','false','true','false','true','0-0','8356-1;'),
(14675,'Agathion Seal Bracelet - Saerom','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8314-1;3267-1;6124-1;'),
(14712,'Cow Hair Accessory','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(14746,'For Events - Refined Chick Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(14747,'For Events - Refined Black Feather Mask','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(14748,'For Events - Refined Carnival Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(14749,'Afro Perm Wig','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(14750,'Bamboo Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(14751,'Smart Glasses','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(14752,'For Events - Refined Medieval Style Party Mask','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14753,'Shadow Item - Refined Chick Hat','Escape','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14754,'Shadow Item - Refined Chick Hat','Big Head','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14755,'Shadow Item - Refined Chick Hat','Firework','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14756,'Shadow Item - Refined Black Feather Mask','Escape','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14757,'Shadow Item - Refined Black Feather Mask','Big Head','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14758,'Shadow Item - Refined Black Feather Mask','Firework','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14759,'Shadow Item - Refined Carnival Circlet','Escape','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14760,'Shadow Item - Refined Carnival Circlet','Big Head','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14761,'Shadow Item - Refined Carnival Circlet','Firework','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14762,'Shadow Item - Refined Medieval Style Party Mask','Escape','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14763,'Shadow Item - Refined Medieval Style Party Mask','Big Head','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14764,'Shadow Item - Refined Medieval Style Party Mask','Firework','hairall','false','none',10,'wood','none',0,360,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14771,'Kat the Cat Hat','14 day limited period','hairall','false','none',0,'wood','none',0,-1,20160,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14772,'Coronet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14773,'Suit','14 day limited period','none','false','magic',0,'wood','none',0,-1,20160,0,0,15,0,0,'false','false','false','false','false','0-0','0-0;'),
(14775,'Agathion Seal Bracelet - Love','14 day limited period','lbracelet','false','none',0,'wood','none',0,-1,20160,0,0,0,0,0,'false','false','true','false','false','0-0','8245-1;3267-1;'),
(14776,'Agathion Seal Bracelet - Juju','14 day limited period','lbracelet','false','none',0,'wood','none',0,-1,20160,0,0,0,0,0,'false','false','true','false','false','0-0','8327-1;3267-1;6136-1;'),
(14796,'Baguette\'s Sigil','','none','false','sigil',930,'wood','none',-8,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14798,'Afro Perm Wig - Black','','hairall','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14799,'Afro Perm Wig - Gold','','hairall','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14800,'Afro Perm Wig - Pink','','hairall','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14801,'Gludio Guard Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,79,35,0,0,'false','false','true','false','true','0-0','8348-2;'),
(14802,'Dion Guard Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,79,35,0,0,'false','false','true','false','true','0-0','8349-2;'),
(14803,'Giran Guard Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,79,35,0,0,'false','false','true','false','true','0-0','8350-2;'),
(14804,'Oren Guard Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,79,35,0,0,'false','false','true','false','true','0-0','8351-2;'),
(14805,'Aden Guard Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,79,35,0,0,'false','false','true','false','true','0-0','8352-2;'),
(14806,'Innadril Guard Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,79,35,0,0,'false','false','true','false','true','0-0','8353-2;'),
(14807,'Goddard Guard Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,79,35,0,0,'false','false','true','false','true','0-0','8354-2;'),
(14808,'Rune Guard Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,79,35,0,0,'false','false','true','false','true','0-0','8355-2;'),
(14809,'Schuttgart Guard Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,79,35,0,0,'false','false','true','false','true','0-0','8356-2;'),
(14810,'Blue Talisman - Buff Cancel','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14811,'Blue Talisman - Buff Steal','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14812,'Red Talisman - Territory Guard','','talisman','false','none',150,'wood','none',0,66,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14813,'Blue Talisman - Lord\'s Divine Protection','','talisman','false','none',150,'wood','none',0,74,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14814,'White Talisman -  All Resistance','','talisman','false','none',150,'wood','none',0,65,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(14922,'Low-grade Magic Rune Clip Iron Belt','HP Recovery','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8338-1;'),
(14923,'Ordinary Magic Rune Clip Iron Belt','HP Recovery','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8338-2;'),
(14924,'High-grade Magic Rune Clip Iron Belt','HP Recovery','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8338-3;'),
(14925,'Top-grade Magic Rune Clip Iron Belt','HP Recovery','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8338-4;'),
(14926,'Low-grade Magic Rune Clip Mithril Belt','HP Recovery','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8339-1;'),
(14927,'Ordinary Magic Rune Clip Mithril Belt','HP Recovery','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8339-2;'),
(14928,'High-grade Magic Rune Clip Mithril Belt','HP Recovery','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8339-3;'),
(14929,'Top-grade Magic Rune Clip Mithril Belt','HP Recovery','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8339-4;'),
(14930,'Low-grade Magic Rune Clip Iron Belt','MP Recovery','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8340-1;'),
(14931,'Ordinary Magic Rune Clip Iron Belt','MP Recovery','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8340-2;'),
(14932,'High-grade Magic Rune Clip Iron Belt','MP Recovery','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8340-3;'),
(14933,'Top-grade Magic Rune Clip Iron Belt','MP Recovery','belt','true','light',460,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8340-4;'),
(14934,'Low-grade Magic Rune Clip Mithril Belt','MP Recovery','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8341-1;'),
(14935,'Ordinary Magic Rune Clip Mithril Belt','MP Recovery','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8341-2;'),
(14936,'High-grade Magic Rune Clip Mithril Belt','MP Recovery','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8341-3;'),
(14937,'Top-grade Magic Rune Clip Mithril Belt','MP Recovery','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8341-4;'),
(14938,'Low-grade Magic Ornament Iron Belt','PvP Physical Attack','belt','true','light',440,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8342-1;'),
(14939,'Regular Magic Ornament Iron Belt','PvP Physical Attack','belt','true','light',440,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8342-2;'),
(14940,'High-grade Magic Ornament Iron Belt','PvP Physical Attack','belt','true','light',440,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8342-3;'),
(14941,'Top-grade Magic Ornament Iron Belt','PvP Physical Attack','belt','true','light',440,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8342-4;'),
(14942,'Low-grade Magic Ornament Iron Belt','PvP Skill Attack','belt','true','light',440,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8343-1;'),
(14943,'Regular Magic Ornament Iron Belt','PvP Skill Attack','belt','true','light',440,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8343-2;'),
(14944,'High-grade Magic Ornament Iron Belt','PvP Skill Attack','belt','true','light',440,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8343-3;'),
(14945,'Top-grade Magic Ornament Iron Belt','PvP Skill Attack','belt','true','light',440,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8343-4;'),
(14946,'Low-grade Magic Ornament Iron Belt','PVP Defense','belt','true','light',440,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8344-1;'),
(14947,'Regular Magic Ornament Iron Belt','PVP Defense','belt','true','light',440,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8344-2;'),
(14948,'High-grade Magic Ornament Iron Belt','PVP Defense','belt','true','light',440,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8344-3;'),
(14949,'Top-grade Magic Ornament Iron Belt','PVP Defense','belt','true','light',440,'wood','a',0,-1,-1,12,0,0,0,0,'true','true','true','true','true','0-0','8344-4;'),
(14950,'Low-grade Magic Ornament Mithril Belt','PvP Physical Attack','belt','false','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8345-1;'),
(14951,'Regular Magic Ornament Mithril Belt','PvP Physical Attack','belt','false','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8345-2;'),
(14952,'High-grade Magic Ornament Mithril Belt','PvP Physical Attack','belt','false','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8345-3;'),
(14953,'Top-grade Magic Ornament Mithril Belt','PvP Physical Attack','belt','false','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8345-4;'),
(14954,'Low-grade Magic Ornament Mithril Belt','PvP Skill Attack','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8346-1;'),
(14955,'Regular Magic Ornament Mithril Belt','PvP Skill Attack','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8346-2;'),
(14956,'High-grade Magic Ornament Mithril Belt','PvP Skill Attack','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8346-3;'),
(14957,'Top-grade Magic Ornament Mithril Belt','PvP Skill Attack','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8346-4;'),
(14958,'Low-grade Magic Ornament Mithril Belt','PVP Defense','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8347-1;'),
(14959,'Regular Magic Ornament Mithril Belt','PVP Defense','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8347-2;'),
(14960,'High-grade Magic Ornament Mithril Belt','PVP Defense','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8347-3;'),
(14961,'Top-grade Magic Ornament Mithril Belt','PVP Defense','belt','true','light',440,'wood','s',0,-1,-1,14,0,0,0,0,'true','true','true','true','true','0-0','8347-4;'),
(14962,'Gold Skeleton Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(14963,'Silver Skeleton Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(14964,'Red Skeleton Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(14965,'Black Skeleton Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(14966,'Majestic Earring of Friendship','30 day limited period','none','true','none',150,'wood','a',0,-1,43200,0,63,25,0,0,'false','false','false','false','false','0-0','0-0;'),
(14967,'Majestic Necklace of Friendship','30 day limited period','none','true','none',150,'wood','a',0,-1,43200,0,85,33,0,0,'false','false','false','false','false','0-0','0-0;'),
(14968,'Majestic Ring of Friendship','30 day limited period','none','true','none',150,'wood','a',0,-1,43200,0,42,17,0,0,'false','false','false','false','false','0-0','0-0;'),
(14969,'Friendship Earring of Black Ore','30 day limited period','none','true','none',150,'wood','b',0,-1,43200,0,54,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14970,'Friendship Necklace of Black Ore','30 day limited period','none','true','none',150,'wood','b',0,-1,43200,0,72,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14971,'Friendship Ring of Black Ore','30 day limited period','none','true','none',150,'wood','b',0,-1,43200,0,36,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14972,'Friendship Earring of Binding','30 day limited period','none','true','none',150,'wood','c',0,-1,43200,0,45,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14973,'Friendship Necklace of Binding','30 day limited period','none','true','none',150,'wood','c',0,-1,43200,0,64,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14974,'Friendship Ring of Binding','30 day limited period','none','true','none',150,'wood','c',0,-1,43200,0,32,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14975,'Elven Earring of Friendship','30 day limited period','none','true','none',150,'wood','d',0,-1,43200,0,34,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14976,'Elven Earring of Friendship','30 day limited period','none','true','none',150,'wood','d',0,-1,43200,0,45,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14977,'Elven Ring of Friendship','30 day limited period','none','true','none',150,'wood','d',0,-1,43200,0,22,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14978,'Dark Crystal Robe of Friendship','30 day limited period','none','true','magic',2450,'wood','a',0,-1,43200,139,0,665,0,0,'false','false','false','false','false','0-0','0-0;'),
(14979,'Dark Crystal Helmet of Friendship','30 day limited period','none','true','none',570,'wood','a',0,-1,43200,69,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14980,'Dark Crystal Gloves of Friendship - Robe','30 day limited period','none','true','none',580,'wood','a',0,-1,43200,46,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14981,'Dark Crystal Boots of Friendship - Robe','30 day limited period','none','true','none',1110,'wood','a',0,-1,43200,46,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14983,'Avadon Robe of Friendship','30 day limited period','none','true','magic',2540,'wood','b',0,-1,43200,127,0,561,0,0,'false','false','false','false','false','0-0','0-0;'),
(14984,'Avadon Circlet of Friendship','30 day limited period','none','true','none',590,'wood','b',0,-1,43200,62,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14985,'Avadon Gloves of Friendship - Robe','30 day limited period','none','true','none',590,'wood','b',0,-1,43200,41,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14986,'Avadon Boots of Friendship - Robe','30 day limited period','none','true','none',1180,'wood','b',0,-1,43200,41,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14988,'Karmian Tunic of Friendship','30 day limited period','none','true','magic',1980,'wood','c',0,-1,43200,60,0,225,0,0,'false','false','false','false','false','0-0','0-0;'),
(14989,'Karmian Stockings of Friendship','30 day limited period','none','true','magic',970,'wood','c',0,-1,43200,37,0,141,0,0,'false','false','false','false','false','0-0','0-0;'),
(14990,'Karmian Gloves of Friendship','30 day limited period','none','true','none',620,'wood','c',0,-1,43200,32,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14991,'Karmian Boots of Friendship','30 day limited period','none','true','none',1230,'wood','c',0,-1,43200,32,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14992,'Mithril Tunic of Friendship','30 day limited period','none','true','magic',2010,'wood','d',0,-1,43200,52,0,169,0,0,'false','false','false','false','false','0-0','0-0;'),
(14993,'Mithril Stockings of Friendship','30 day limited period','none','true','magic',980,'wood','d',0,-1,43200,32,0,105,0,0,'false','false','false','false','false','0-0','0-0;'),
(14994,'Elven Mithril Gloves of Friendship','30 day limited period','none','true','none',640,'wood','d',0,-1,43200,27,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14995,'Elven Mithril Boots of Friendship','30 day limited period','none','true','none',1250,'wood','d',0,-1,43200,27,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14996,'Dark Crystal Leather Armor of Friendship','30 day limited period','none','true','light',4300,'wood','a',0,-1,43200,128,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14997,'Dark Crystal Leggings of Friendship','30 day limited period','none','true','light',1480,'wood','a',0,-1,43200,80,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14998,'Dark Crystal Gloves of Friendship - Light Armor','30 day limited period','none','true','none',580,'wood','a',0,-1,43200,46,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(14999,'Dark Crystal Boots of Friendship - Light Armor','30 day limited period','none','true','none',1110,'wood','a',0,-1,43200,46,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15000,'Leather Armor of Doom of Friendship','30 day limited period','none','true','light',5500,'wood','b',0,-1,43200,202,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15001,'Doom Helmet of Friendship','30 day limited period','none','true','none',580,'wood','b',0,-1,43200,66,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15002,'Doom Gloves of Friendship - Heavy Armor','30 day limited period','none','true','none',580,'wood','b',0,-1,43200,44,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15003,'Doom Gloves of Friendship - Light Armor','30 day limited period','none','true','none',580,'wood','b',0,-1,43200,44,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15004,'Doom Boots of Friendship - Heavy Armor','30 day limited period','none','true','none',1130,'wood','b',0,-1,43200,44,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15005,'Doom Boots of Friendship - Light Armor','30 day limited period','none','true','none',1130,'wood','b',0,-1,43200,44,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15006,'Doom Plate Armor of Friendship','30 day limited period','none','true','heavy',9980,'wood','b',0,-1,43200,270,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15008,'Plate Leather Armor of Friendship','30 day limited period','none','true','light',4450,'wood','c',0,-1,43200,94,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15009,'Plate Leather Gaiters of Friendship','30 day limited period','none','true','light',1560,'wood','c',0,-1,43200,59,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15010,'Plate Leather Boots of Friendship','30 day limited period','none','true','none',1220,'wood','c',0,-1,43200,32,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15011,'Plate Leather Gloves of Friendship','30 day limited period','none','true','none',610,'wood','c',0,-1,43200,33,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15012,'Full Plate Helmet of Friendship','30 day limited period','none','true','none',600,'wood','c',0,-1,43200,58,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15013,'Full Plate Armor of Friendship','30 day limited period','none','true','heavy',10480,'wood','c',0,-1,43200,239,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15014,'Full Plate Boots of Friendship','30 day limited period','none','true','none',1200,'wood','c',0,-1,43200,39,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15015,'Full Plate Gauntlet of Friendship','30 day limited period','none','true','none',600,'wood','c',0,-1,43200,39,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15017,'Manticore Skin Shirt of Friendship','30 day limited period','none','true','light',4520,'wood','d',0,-1,43200,77,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15018,'Manticore Skin Gaiters of Friendship','30 day limited period','none','true','light',1550,'wood','d',0,-1,43200,48,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15019,'Manticore Skin Boots of Friendship','30 day limited period','none','true','none',1260,'wood','d',0,-1,43200,27,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15020,'Manticore Skin Gloves of Friendship','30 day limited period','none','true','none',630,'wood','d',0,-1,43200,27,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15021,'Brigandine of Friendship','30 day limited period','none','true','heavy',8320,'wood','d',0,-1,43200,103,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15022,'Brigandine Gaiters of Friendship','30 day limited period','none','true','heavy',3820,'wood','d',0,-1,43200,64,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15023,'Brigandine Helmet of Friendship','30 day limited period','none','true','none',630,'wood','d',0,-1,43200,41,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15024,'Brigandine Boots of Friendship','30 day limited period','none','true','none',1250,'wood','d',0,-1,43200,27,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15025,'Brigandine Gauntlet of Friendship','30 day limited period','none','true','none',630,'wood','d',0,-1,43200,27,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15027,'Friendship Armor of Nightmare','30 day limited period','none','true','heavy',9580,'wood','a',0,-1,43200,293,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15028,'Friendship Helm of Nightmare','30 day limited period','none','true','none',560,'wood','a',0,-1,43200,73,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15029,'Friendship Gauntlet of Nightmare - Heavy Armor','30 day limited period','none','true','none',550,'wood','a',0,-1,43200,49,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15030,'Friendship Boots of Nightmare - Heavy Armor','30 day limited period','none','true','none',1110,'wood','a',0,-1,43200,49,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15080,'Majestic Earring of Friendship','10 day limited period','none','true','none',150,'wood','a',0,-1,14400,0,63,25,0,0,'false','false','false','false','false','0-0','0-0;'),
(15081,'Majestic Necklace of Friendship','10 day limited period','none','true','none',150,'wood','a',0,-1,14400,0,85,33,0,0,'false','false','false','false','false','0-0','0-0;'),
(15082,'Majestic Ring of Friendship','10 day limited period','none','true','none',150,'wood','a',0,-1,14400,0,42,17,0,0,'false','false','false','false','false','0-0','0-0;'),
(15083,'Friendship Earring of Black Ore','10 day limited period','none','true','none',150,'wood','b',0,-1,14400,0,54,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15084,'Friendship Necklace of Black Ore','10 day limited period','none','true','none',150,'wood','b',0,-1,14400,0,72,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15085,'Friendship Ring of Black Ore','10 day limited period','none','true','none',150,'wood','b',0,-1,14400,0,36,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15086,'Friendship Earring of Binding','10 day limited period','none','true','none',150,'wood','c',0,-1,14400,0,45,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15087,'Friendship Necklace of Binding','10 day limited period','none','true','none',150,'wood','c',0,-1,14400,0,64,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15088,'Friendship Ring of Binding','10 day limited period','none','true','none',150,'wood','c',0,-1,14400,0,32,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15089,'Elven Earring of Friendship','10 day limited period','none','true','none',150,'wood','d',0,-1,14400,0,34,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15090,'Elven Earring of Friendship','10 day limited period','none','true','none',150,'wood','d',0,-1,14400,0,45,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15091,'Elven Ring of Friendship','10 day limited period','none','true','none',150,'wood','d',0,-1,14400,0,22,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15092,'Dark Crystal Robe of Friendship','10 day limited period','none','true','magic',2450,'wood','a',0,-1,14400,139,0,665,0,0,'false','false','false','false','false','0-0','0-0;'),
(15093,'Dark Crystal Helmet of Friendship','10 day limited period','none','true','none',570,'wood','a',0,-1,14400,69,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15094,'Dark Crystal Gloves of Friendship - Robe','10 day limited period','none','true','none',580,'wood','a',0,-1,14400,46,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15095,'Dark Crystal Boots of Friendship - Robe','10 day limited period','none','true','none',1110,'wood','a',0,-1,14400,46,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15097,'Avadon Robe of Friendship','10 day limited period','none','true','magic',2540,'wood','b',0,-1,14400,127,0,561,0,0,'false','false','false','false','false','0-0','0-0;'),
(15098,'Avadon Circlet of Friendship','10 day limited period','none','true','none',590,'wood','b',0,-1,14400,62,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15099,'Avadon Gloves of Friendship - Robe','10 day limited period','none','true','none',590,'wood','b',0,-1,14400,41,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15100,'Avadon Boots of Friendship - Robe','10 day limited period','none','true','none',1180,'wood','b',0,-1,14400,41,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15102,'Karmian Tunic of Friendship','10 day limited period','none','true','magic',1980,'wood','c',0,-1,14400,60,0,225,0,0,'false','false','false','false','false','0-0','0-0;'),
(15103,'Karmian Stockings of Friendship','10 day limited period','none','true','magic',970,'wood','c',0,-1,14400,37,0,141,0,0,'false','false','false','false','false','0-0','0-0;'),
(15104,'Karmian Gloves of Friendship','10 day limited period','none','true','none',620,'wood','c',0,-1,14400,32,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15105,'Karmian Boots of Friendship','10 day limited period','none','true','none',1230,'wood','c',0,-1,14400,32,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15106,'Mithril Tunic of Friendship','10 day limited period','none','true','magic',2010,'wood','d',0,-1,14400,52,0,169,0,0,'false','false','false','false','false','0-0','0-0;'),
(15107,'Mithril Stockings of Friendship','10 day limited period','none','true','magic',980,'wood','d',0,-1,14400,32,0,105,0,0,'false','false','false','false','false','0-0','0-0;'),
(15108,'Elven Mithril Gloves of Friendship','10 day limited period','none','true','none',640,'wood','d',0,-1,14400,27,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15109,'Elven Mithril Boots of Friendship','10 day limited period','none','true','none',1250,'wood','d',0,-1,14400,27,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15110,'Dark Crystal Leather Armor of Friendship','10 day limited period','none','true','light',4300,'wood','a',0,-1,14400,128,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15111,'Dark Crystal Leggings of Friendship','10 day limited period','none','true','light',1480,'wood','a',0,-1,14400,80,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15112,'Dark Crystal Gloves of Friendship - Light Armor','10 day limited period','none','true','none',580,'wood','a',0,-1,14400,46,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15113,'Dark Crystal Boots of Friendship - Light Armor','10 day limited period','none','true','none',1110,'wood','a',0,-1,14400,46,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15114,'Leather Armor of Doom of Friendship','10 day limited period','none','true','light',5500,'wood','b',0,-1,14400,202,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15115,'Doom Helmet of Friendship','10 day limited period','none','true','none',580,'wood','b',0,-1,14400,66,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15116,'Doom Gloves of Friendship - Heavy Armor','10 day limited period','none','true','none',580,'wood','b',0,-1,14400,44,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15117,'Doom Gloves of Friendship - Light Armor','10 day limited period','none','true','none',580,'wood','b',0,-1,14400,44,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15118,'Doom Boots of Friendship - Heavy Armor','10 day limited period','none','true','none',1130,'wood','b',0,-1,14400,44,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15119,'Doom Boots of Friendship - Light Armor','10 day limited period','none','true','none',1130,'wood','b',0,-1,14400,44,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15120,'Doom Plate Armor of Friendship','10 day limited period','none','true','heavy',9980,'wood','b',0,-1,14400,270,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15122,'Plate Leather Armor of Friendship','10 day limited period','none','true','light',4450,'wood','c',0,-1,14400,94,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15123,'Plate Leather Gaiters of Friendship','10 day limited period','none','true','light',1560,'wood','c',0,-1,14400,59,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15124,'Plate Leather Boots of Friendship','10 day limited period','none','true','none',1220,'wood','c',0,-1,14400,32,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15125,'Plate Leather Gloves of Friendship','10 day limited period','none','true','none',610,'wood','c',0,-1,14400,33,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15126,'Full Plate Helmet of Friendship','10 day limited period','none','true','none',600,'wood','c',0,-1,14400,58,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15127,'Full Plate Armor of Friendship','10 day limited period','none','true','heavy',10480,'wood','c',0,-1,14400,239,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15128,'Full Plate Boots of Friendship','10 day limited period','none','true','none',1200,'wood','c',0,-1,14400,39,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15129,'Full Plate Gauntlet of Friendship','10 day limited period','none','true','none',600,'wood','c',0,-1,14400,39,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15131,'Manticore Skin Shirt of Friendship','10 day limited period','none','true','light',4520,'wood','d',0,-1,14400,77,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15132,'Manticore Skin Gaiters of Friendship','10 day limited period','none','true','light',1550,'wood','d',0,-1,14400,48,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15133,'Manticore Skin Boots of Friendship','10 day limited period','none','true','none',1260,'wood','d',0,-1,14400,27,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15134,'Manticore Skin Gloves of Friendship','10 day limited period','none','true','none',630,'wood','d',0,-1,14400,27,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15135,'Brigandine of Friendship','10 day limited period','none','true','heavy',8320,'wood','d',0,-1,14400,103,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15136,'Brigandine Gaiters of Friendship','10 day limited period','none','true','heavy',3820,'wood','d',0,-1,14400,64,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15137,'Brigandine Helmet of Friendship','10 day limited period','none','true','none',630,'wood','d',0,-1,14400,41,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15138,'Brigandine Boots of Friendship','10 day limited period','none','true','none',1250,'wood','d',0,-1,14400,27,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15139,'Brigandine Gauntlet of Friendship','10 day limited period','none','true','none',630,'wood','d',0,-1,14400,27,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15141,'Friendship Armor of Nightmare','10 day limited period','none','true','heavy',9580,'wood','a',0,-1,14400,293,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15142,'Friendship Helm of Nightmare','10 day limited period','none','true','none',560,'wood','a',0,-1,14400,73,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15143,'Friendship Gauntlet of Nightmare - Heavy Armor','10 day limited period','none','true','none',550,'wood','a',0,-1,14400,49,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15144,'Friendship Boots of Nightmare - Heavy Armor','10 day limited period','none','true','none',1110,'wood','a',0,-1,14400,49,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15208,'Bracelet of Friendship','30 day limited period','none','false','none',0,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15220,'Agathion Seal Bracelet - Oink Oink','10 day limited period','lbracelet','false','none',0,'wood','none',0,-1,14400,0,0,0,0,0,'false','false','true','false','false','0-0','8328-1;3267-1;6197-1;'),
(15221,'Puffy Hat of Friendship','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(15282,'Gludio Water Royal Guard Necklace','','neck','false','none',150,'wood','s80',0,-1,-1,0,106,46,0,0,'false','false','true','false','true','0-0','8388-2;'),
(15283,'Dion Divinity Royal Guard Necklace','','neck','false','none',150,'wood','s80',0,-1,-1,0,106,46,0,0,'false','false','true','false','true','0-0','8389-2;'),
(15284,'Giran Wind Royal Guard Necklace','','neck','false','none',150,'wood','s80',0,-1,-1,0,106,46,0,0,'false','false','true','false','true','0-0','8390-2;'),
(15285,'Oren Darkness Royal Guard Necklace','','neck','false','none',150,'wood','s80',0,-1,-1,0,106,46,0,0,'false','false','true','false','true','0-0','8391-2;'),
(15286,'Aden Earth Royal Guard Necklace','','neck','false','none',150,'wood','s80',0,-1,-1,0,106,46,0,0,'false','false','true','false','true','0-0','8392-2;'),
(15287,'Innadril Water Royal Guard Necklace','','neck','false','none',150,'wood','s80',0,-1,-1,0,106,46,0,0,'false','false','true','false','true','0-0','8393-2;'),
(15288,'Goddard Fire Royal Guard Necklace','','neck','false','none',150,'wood','s80',0,-1,-1,0,106,46,0,0,'false','false','true','false','true','0-0','8394-2;'),
(15289,'Rune Fire Royal Guard Necklace','','neck','false','none',150,'wood','s80',0,-1,-1,0,106,46,0,0,'false','false','true','false','true','0-0','8395-2;'),
(15290,'Schuttgart Wind Royal Guard Necklace','','neck','false','none',150,'wood','s80',0,-1,-1,0,106,46,0,0,'false','false','true','false','true','0-0','8396-2;'),
(15291,'Gludio Earth Royal Guard Ring','','rfinger,lfinger','false','none',150,'wood','s80',0,-1,-1,0,60,23,0,0,'false','false','true','false','true','0-0','8379-2;'),
(15292,'Dion Water Royal Guard Ring','','rfinger,lfinger','false','none',150,'wood','s80',0,-1,-1,0,60,23,0,0,'false','false','true','false','true','0-0','8380-2;'),
(15293,'Giran Fire Royal Guard Ring','','rfinger,lfinger','false','none',150,'wood','s80',0,-1,-1,0,60,23,0,0,'false','false','true','false','true','0-0','8381-2;'),
(15294,'Oren Earth Royal Guard Ring','','rfinger,lfinger','false','none',150,'wood','s80',0,-1,-1,0,60,23,0,0,'false','false','true','false','true','0-0','8382-2;'),
(15295,'Aden Divinity Royal Guard Ring','','rfinger,lfinger','false','none',150,'wood','s80',0,-1,-1,0,60,23,0,0,'false','false','true','false','true','0-0','8383-2;'),
(15296,'Innadril Divinity Royal Guard Ring','','rfinger,lfinger','false','none',150,'wood','s80',0,-1,-1,0,60,23,0,0,'false','false','true','false','true','0-0','8384-2;'),
(15297,'Goddard Dark Royal Guard Ring','','rfinger,lfinger','false','none',150,'wood','s80',0,-1,-1,0,60,23,0,0,'false','false','true','false','true','0-0','8385-2;'),
(15298,'Rune Wind Royal Guard Ring','','rfinger,lfinger','false','none',150,'wood','s80',0,-1,-1,0,60,23,0,0,'false','false','true','false','true','0-0','8386-2;'),
(15299,'Schuttgart Dark Royal Guard Ring','','rfinger,lfinger','false','none',150,'wood','s80',0,-1,-1,0,60,23,0,0,'false','false','true','false','true','0-0','8387-2;'),
(15312,'Dawn\'s Bracelet','','lbracelet','true','none',15,'wood','s',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','8337-1;'),
(15351,'Seal Removal Bracelet_Towbat','','none','false','none',5,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15383,'Weaver\'s Multi-colored Clothes','7 day limited period','none','false','none',0,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15384,'Weaver\'s Multi-colored Clothes','30 day limited period','none','false','none',0,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15385,'Weaver\'s Multi-colored Clothes','60 day limited period','none','false','none',0,'wood','none',0,-1,86400,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15386,'Weaver\'s Multi-colored Clothes','90 day limited period','none','false','none',0,'wood','none',0,-1,129600,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15387,'Weaver\'s Multi-colored Clothes','Permanent Use','none','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15388,'Weaver\'s Multi-colored Clothes (Event)','7 day limited period','none','false','none',0,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15389,'Weaver\'s Multi-colored Clothes (Event)','30 day limited period','none','false','none',0,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15390,'Weaver\'s Multi-colored Clothes (Event)','60 day limited period','none','false','none',0,'wood','none',0,-1,86400,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15391,'Weaver\'s Multi-colored Clothes (Event)','90 day limited period','none','false','none',0,'wood','none',0,-1,129600,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15392,'Weaver\'s Multi-colored Clothes (Event)','Permanent Use','none','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15393,'Vitality Belt','7 day limited period','none','false','light',0,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15394,'Vitality Belt','30 day limited period','none','false','light',0,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15395,'Vitality Belt','60 day limited period','none','false','light',0,'wood','none',0,-1,86400,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15396,'Vitality Belt','90 day limited period','none','false','light',0,'wood','none',0,-1,129600,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15397,'Vitality Belt','Permanent Use','none','false','light',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15398,'Vitality Belt (Event)','7 day limited period','none','false','light',0,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15399,'Vitality Belt (Event)','30 day limited period','none','false','light',0,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15400,'Vitality Belt (Event)','60 day limited period','none','false','light',0,'wood','none',0,-1,86400,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15401,'Vitality Belt (Event)','90 day limited period','none','false','light',0,'wood','none',0,-1,129600,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15402,'Vitality Belt (Event)','Permanent Use','none','false','light',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15428,'Sixth Anniversary Party Earring - Event','30 day limited period','none','false','none',150,'wood','a',0,-1,43200,0,63,31,0,0,'false','false','false','false','false','0-0','0-0;'),
(15429,'Sixth Anniversary Party Belt - Event','7 day limited period','none','false','light',0,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15441,'Red Flare Valakas Hair Accessory','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15442,'Jack O\'Lantern Mask','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15443,'Super Strong Giant\'s Mask','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15444,'Silent Scream\'s Mask','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15445,'Wrathful Spirit\'s Mask','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15446,'Unrotten Corpse\'s Mask','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15447,'Planet X235 Alien\'s Mask','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15448,'Golden Jack O\'Lantern Mask','Permanent Use','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15449,'Shiny Planet X235 Alien\'s Mask','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15450,'Shiny Super Strong Giant\'s Mask','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15451,'Shiny Silent Scream\'s Mask','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15452,'Shiny Wrathful Spirit\'s Mask','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15453,'Shiny Unrotten Corpse\'s Mask','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15464,'Golden Jack O\'Lantern Mask','7 day limited period','none','false','none',0,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(15473,'Beast Handler\'s Whip','','lbracelet','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8362-1;8363-1;8364-1;8378-1;'),
(15484,'High-level Angel Circlet','','head','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(15572,'Elegia Helmet','','head','true','none',530,'wood','s84',0,-1,-1,110,0,0,25107000,1205,'true','true','true','true','true','0-0','0-0;'),
(15573,'Elegia Leather Helmet','','head','true','none',530,'wood','s84',0,-1,-1,110,0,0,25107000,1205,'true','true','true','true','true','0-0','0-0;'),
(15574,'Elegia Circlet','','head','true','none',530,'wood','s84',0,-1,-1,110,0,0,25107000,1205,'true','true','true','true','true','0-0','0-0;'),
(15575,'Elegia Breastplate','','chest','true','heavy',7520,'wood','s84',0,-1,-1,272,0,0,66953000,3214,'true','true','true','true','true','0-0','0-0;'),
(15576,'Elegia Leather Breastplate','','chest','true','light',4140,'wood','s84',0,-1,-1,204,0,0,50215000,2410,'true','true','true','true','true','0-0','0-0;'),
(15577,'Elegia Tunic','','chest','true','magic',1750,'wood','s84',0,-1,-1,136,0,661,50215000,2410,'true','true','true','true','true','0-0','0-0;'),
(15578,'Elegia Gaiter','','legs','true','heavy',3170,'wood','s84',0,-1,-1,170,0,0,41846000,2009,'true','true','true','true','true','0-0','0-0;'),
(15579,'Elegia Leather Legging','','legs','true','light',1320,'wood','s84',0,-1,-1,128,0,0,31384000,1506,'true','true','true','true','true','0-0','0-0;'),
(15580,'Elegia Stockings','','legs','true','magic',850,'wood','s84',0,-1,-1,85,0,439,31384000,1506,'true','true','true','true','true','0-0','0-0;'),
(15581,'Elegia Gauntlet','','gloves','true','none',510,'wood','s84',0,-1,-1,74,0,0,16738000,803,'true','true','true','true','true','0-0','0-0;'),
(15582,'Elegia Leather Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,74,0,0,16738000,803,'true','true','true','true','true','0-0','0-0;'),
(15583,'Elegia Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,74,0,0,16738000,803,'true','true','true','true','true','0-0','0-0;'),
(15584,'Elegia Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,74,0,0,16738000,803,'true','true','true','true','true','0-0','0-0;'),
(15585,'Elegia Leather Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,74,0,0,16738000,803,'true','true','true','true','true','0-0','0-0;'),
(15586,'Elegia Shoes','','feet','true','none',1070,'wood','s84',0,-1,-1,74,0,0,16738000,803,'true','true','true','true','true','0-0','0-0;'),
(15588,'Elegia Sigil','','lhand','true','sigil',920,'wood','s84',-8,-1,-1,21,0,0,17575000,844,'true','true','true','true','true','0-0','0-0;'),
(15589,'Vorpal Helmet','','head','true','none',530,'wood','s84',0,-1,-1,107,0,0,20940000,1005,'true','true','true','true','true','0-0','0-0;'),
(15590,'Vorpal Leather Helmet','','head','true','none',530,'wood','s84',0,-1,-1,107,0,0,20940000,1005,'true','true','true','true','true','0-0','0-0;'),
(15591,'Vorpal Circlet','','head','true','none',530,'wood','s84',0,-1,-1,107,0,0,20940000,1005,'true','true','true','true','true','0-0','0-0;'),
(15592,'Vorpal Breastplate','','chest','true','heavy',7520,'wood','s84',0,-1,-1,263,0,0,55840000,2680,'true','true','true','true','true','0-0','0-0;'),
(15593,'Vorpal Leather Breastplate','','chest','true','light',4140,'wood','s84',0,-1,-1,197,0,0,41880000,2010,'true','true','true','true','true','0-0','0-0;'),
(15594,'Vorpal Tunic','','chest','true','magic',1750,'wood','s84',0,-1,-1,132,0,649,41880000,2010,'true','true','true','true','true','0-0','0-0;'),
(15595,'Vorpal Gaiter','','legs','true','heavy',3170,'wood','s84',0,-1,-1,164,0,0,34900000,1675,'true','true','true','true','true','0-0','0-0;'),
(15596,'Vorpal Leather Legging','','legs','true','light',1320,'wood','s84',0,-1,-1,123,0,0,26175000,1256,'true','true','true','true','true','0-0','0-0;'),
(15597,'Vorpal Stockings','','legs','true','magic',850,'wood','s84',0,-1,-1,82,0,427,26175000,1256,'true','true','true','true','true','0-0','0-0;'),
(15598,'Vorpal Gauntlet','','gloves','true','none',510,'wood','s84',0,-1,-1,71,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(15599,'Vorpal Leather Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,71,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(15600,'Vorpal Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,71,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(15601,'Vorpal Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,71,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(15602,'Vorpal Leather Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,71,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(15603,'Vorpal Shoes','','feet','true','none',1070,'wood','s84',0,-1,-1,71,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(15605,'Vorpal Sigil','','lhand','true','sigil',920,'wood','s84',-8,-1,-1,19,0,0,14658000,704,'true','true','true','true','true','0-0','0-0;'),
(15606,'Moirai Helmet','','head','true','none',530,'wood','s80',0,-1,-1,96,0,0,12627000,606,'true','true','true','true','true','0-0','0-0;'),
(15607,'Moirai Leather Helmet','','head','true','none',530,'wood','s80',0,-1,-1,96,0,0,12627000,606,'true','true','true','true','true','0-0','0-0;'),
(15608,'Moirai Circlet','','head','true','none',530,'wood','s80',0,-1,-1,96,0,0,12627000,606,'true','true','true','true','true','0-0','0-0;'),
(15609,'Moirai Breastplate','','chest','true','heavy',7520,'wood','s80',0,-1,-1,238,0,0,33672000,1616,'true','true','true','true','true','0-0','0-0;'),
(15610,'Moirai Leather Breastplate','','chest','true','light',4140,'wood','s80',0,-1,-1,178,0,0,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(15611,'Moirai Tunic','','chest','true','magic',1750,'wood','s80',0,-1,-1,119,0,614,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(15612,'Moirai Gaiter','','legs','true','heavy',3170,'wood','s80',0,-1,-1,149,0,0,33673000,1010,'true','true','true','true','true','0-0','0-0;'),
(15613,'Moirai Leather Legging','','legs','true','light',1320,'wood','s80',0,-1,-1,111,0,0,15784000,758,'true','true','true','true','true','0-0','0-0;'),
(15614,'Moirai Stockings','','legs','true','magic',850,'wood','s80',0,-1,-1,74,0,392,15784000,758,'true','true','true','true','true','0-0','0-0;'),
(15615,'Moirai Gauntlet','','gloves','true','none',510,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(15616,'Moirai Leather Gloves','','gloves','true','none',510,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(15617,'Moirai Gloves','','gloves','true','none',510,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(15618,'Moirai Boots','','feet','true','none',1070,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(15619,'Moirai Leather Boots','','feet','true','none',1070,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(15620,'Moirai Shoes','','feet','true','none',1070,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(15622,'Moirai Sigil','','lhand','true','sigil',920,'wood','s80',-8,-1,-1,16,0,0,8833000,424,'true','true','true','true','true','0-0','0-0;'),
(15694,'Sealed Moirai Helmet','','head','true','none',530,'wood','s80',0,-1,-1,96,0,0,12627000,606,'true','true','true','true','true','0-0','0-0;'),
(15695,'Sealed Moirai Leather Helmet','','head','true','none',530,'wood','s80',0,-1,-1,96,0,0,12627000,606,'true','true','true','true','true','0-0','0-0;'),
(15696,'Sealed Moirai Circlet','','head','true','none',530,'wood','s80',0,-1,-1,96,0,0,12627000,606,'true','true','true','true','true','0-0','0-0;'),
(15697,'Sealed Moirai Breastplate','','chest','true','heavy',7520,'wood','s80',0,-1,-1,225,0,0,33672000,1616,'true','true','true','true','true','0-0','0-0;'),
(15698,'Sealed Moirai Leather Breastplate','','chest','true','light',4140,'wood','s80',0,-1,-1,169,0,0,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(15699,'Sealed Moirai Tunic','','chest','true','magic',1750,'wood','s80',0,-1,-1,112,0,614,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(15700,'Sealed Moirai Gaiter','','legs','true','heavy',3170,'wood','s80',0,-1,-1,141,0,0,33673000,1010,'true','true','true','true','true','0-0','0-0;'),
(15701,'Sealed Moirai Leather Legging','','legs','true','light',1320,'wood','s80',0,-1,-1,105,0,0,15784000,758,'true','true','true','true','true','0-0','0-0;'),
(15702,'Sealed Moirai Stockings','','legs','true','magic',850,'wood','s80',0,-1,-1,70,0,392,15784000,758,'true','true','true','true','true','0-0','0-0;'),
(15703,'Sealed Moirai Gauntlet','','gloves','true','none',510,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(15704,'Sealed Moirai Leather Gloves','','gloves','true','none',510,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(15705,'Sealed Moirai Gloves','','gloves','true','none',510,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(15706,'Sealed Moirai Boots','','feet','true','none',1070,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(15707,'Sealed Moirai Leather Boots','','feet','true','none',1070,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(15708,'Sealed Moirai Shoes','','feet','true','none',1070,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(15709,'Sealed Moirai Sigil','','lhand','true','sigil',920,'wood','s80',-8,-1,-1,16,0,0,8833000,424,'true','true','true','true','true','0-0','0-0;'),
(15717,'Elegia Ring','','rfinger,lfinger','true','none',150,'wood','s84',0,-1,-1,0,69,27,10897000,523,'true','true','true','true','true','0-0','0-0;'),
(15718,'Elegia Earring','','rear,lear','true','none',150,'wood','s84',0,-1,-1,0,104,39,16344000,785,'true','true','true','true','true','0-0','0-0;'),
(15719,'Elegia Necklace','','neck','true','none',150,'wood','s84',0,-1,-1,0,138,52,21795000,1046,'true','true','true','true','true','0-0','0-0;'),
(15720,'Vorpal Ring','','rfinger,lfinger','true','none',150,'wood','s84',0,-1,-1,0,65,26,9088000,436,'true','true','true','true','true','0-0','0-0;'),
(15721,'Vorpal Earring','','rear,lear','true','none',150,'wood','s84',0,-1,-1,0,98,38,13633000,654,'true','true','true','true','true','0-0','0-0;'),
(15722,'Vorpal Necklace','','neck','true','none',150,'wood','s84',0,-1,-1,0,131,51,18177000,872,'true','true','true','true','true','0-0','0-0;'),
(15723,'Moirai Ring','','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,61,24,5480000,263,'true','true','true','true','true','0-0','0-0;'),
(15724,'Moirai Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,86,36,8221000,395,'true','true','true','true','true','0-0','0-0;'),
(15725,'Moirai Necklace','','neck','true','none',150,'wood','s80',0,-1,-1,0,115,48,10961000,526,'true','true','true','true','true','0-0','0-0;'),
(15726,'Sealed Elegia Helmet','','head','true','none',530,'wood','s84',0,-1,-1,110,0,0,25107000,1205,'true','true','true','true','true','0-0','0-0;'),
(15727,'Sealed Elegia Leather Helmet','','head','true','none',530,'wood','s84',0,-1,-1,110,0,0,25107000,1205,'true','true','true','true','true','0-0','0-0;'),
(15728,'Sealed Elegia Circlet','','head','true','none',530,'wood','s84',0,-1,-1,110,0,0,25107000,1025,'true','true','true','true','true','0-0','0-0;'),
(15729,'Sealed Elegia Breastplate','','chest','true','heavy',7520,'wood','s84',0,-1,-1,257,0,0,66953000,3214,'true','true','true','true','true','0-0','0-0;'),
(15730,'Sealed Elegia Leather Breastplate','','chest','true','light',4140,'wood','s84',0,-1,-1,193,0,0,50215000,2410,'true','true','true','true','true','0-0','0-0;'),
(15731,'Sealed Elegia Tunic','','chest','true','magic',1750,'wood','s84',0,-1,-1,129,0,661,50215000,2410,'true','true','true','true','true','0-0','0-0;'),
(15732,'Sealed Elegia Gaiter','','legs','true','heavy',3170,'wood','s84',0,-1,-1,161,0,0,41846000,2009,'true','true','true','true','true','0-0','0-0;'),
(15733,'Sealed Elegia Leather Legging','','legs','true','light',1320,'wood','s84',0,-1,-1,121,0,0,31384000,1506,'true','true','true','true','true','0-0','0-0;'),
(15734,'Sealed Elegia Stockings','','legs','true','magic',850,'wood','s84',0,-1,-1,80,0,439,31384000,1506,'true','true','true','true','true','0-0','0-0;'),
(15735,'Sealed Elegia Gauntlet','','gloves','true','none',510,'wood','s84',0,-1,-1,74,0,0,16738000,803,'true','true','true','true','true','0-0','0-0;'),
(15736,'Sealed Elegia Leather Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,74,0,0,16738000,803,'true','true','true','true','true','0-0','0-0;'),
(15737,'Sealed Elegia Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,74,0,0,16738000,803,'true','true','true','true','true','0-0','0-0;'),
(15738,'Sealed Elegia Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,74,0,0,16738000,803,'true','true','true','true','true','0-0','0-0;'),
(15739,'Sealed Elegia Leather Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,74,0,0,16738000,803,'true','true','true','true','true','0-0','0-0;'),
(15740,'Sealed Elegia Shoes','','feet','true','none',1070,'wood','s84',0,-1,-1,74,0,0,16738000,803,'true','true','true','true','true','0-0','0-0;'),
(15742,'Sealed Elegia Sigil','','lhand','true','sigil',920,'wood','s84',-8,-1,-1,21,0,0,17575000,844,'true','true','true','true','true','0-0','0-0;'),
(15743,'Sealed Vorpal Helmet','','head','true','none',530,'wood','s84',0,-1,-1,107,0,0,20940000,1005,'true','true','true','true','true','0-0','0-0;'),
(15744,'Sealed Vorpal Leather Helmet','','head','true','none',530,'wood','s84',0,-1,-1,107,0,0,20940000,1005,'true','true','true','true','true','0-0','0-0;'),
(15745,'Sealed Vorpal Circlet','','head','true','none',530,'wood','s84',0,-1,-1,107,0,0,20940000,1005,'true','true','true','true','true','0-0','0-0;'),
(15746,'Sealed Vorpal Breastplate','','chest','true','heavy',7520,'wood','s84',0,-1,-1,249,0,0,55840000,2680,'true','true','true','true','true','0-0','0-0;'),
(15747,'Sealed Vorpal Leather Breastplate','','chest','true','light',4140,'wood','s84',0,-1,-1,187,0,0,41880000,2010,'true','true','true','true','true','0-0','0-0;'),
(15748,'Sealed Vorpal Tunic','','chest','true','magic',1750,'wood','s84',0,-1,-1,124,0,649,41880000,2010,'true','true','true','true','true','0-0','0-0;'),
(15749,'Sealed Vorpal Gaiter','','legs','true','heavy',3170,'wood','s84',0,-1,-1,156,0,0,34900000,1675,'true','true','true','true','true','0-0','0-0;'),
(15750,'Sealed Vorpal Leather Legging','','legs','true','light',1320,'wood','s84',0,-1,-1,117,0,0,26175000,1256,'true','true','true','true','true','0-0','0-0;'),
(15751,'Sealed Vorpal Stockings','','legs','true','magic',850,'wood','s84',0,-1,-1,78,0,427,26175000,1256,'true','true','true','true','true','0-0','0-0;'),
(15752,'Sealed Vorpal Gauntlet','','gloves','true','none',510,'wood','s84',0,-1,-1,71,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(15753,'Sealed Vorpal Leather Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,71,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(15754,'Sealed Vorpal Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,71,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(15755,'Sealed Vorpal Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,71,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(15756,'Sealed Vorpal Leather Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,71,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(15757,'Sealed Vorpal Shoes','','feet','true','none',1070,'wood','s84',0,-1,-1,71,0,0,13960000,670,'true','true','true','true','true','0-0','0-0;'),
(15759,'Sealed Vorpal Sigil','','lhand','true','sigil',920,'wood','s84',-8,-1,-1,19,0,0,14658000,704,'true','true','true','true','true','0-0','0-0;'),
(15760,'Sealed Elegia Ring','','rfinger,lfinger','true','none',150,'wood','s84',0,-1,-1,0,61,0,10897000,523,'true','true','true','true','true','0-0','0-0;'),
(15761,'Sealed Elegia Earring','','rear,lear','true','none',150,'wood','s84',0,-1,-1,0,92,0,16344000,785,'true','true','true','true','true','0-0','0-0;'),
(15762,'Sealed Elegia Necklace','','neck','true','none',150,'wood','s84',0,-1,-1,0,121,0,21795000,1046,'true','true','true','true','true','0-0','0-0;'),
(15763,'Sealed Vorpal Ring','','rfinger,lfinger','true','none',150,'wood','s84',0,-1,-1,0,57,0,9088000,436,'true','true','true','true','true','0-0','0-0;'),
(15764,'Sealed Vorpal Earring','','rear,lear','true','none',150,'wood','s84',0,-1,-1,0,86,0,13633000,654,'true','true','true','true','true','0-0','0-0;'),
(15765,'Sealed Vorpal Necklace','','neck','true','none',150,'wood','s84',0,-1,-1,0,115,0,18177000,872,'true','true','true','true','true','0-0','0-0;'),
(15766,'Sealed Moirai Ring','','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,53,0,5480000,263,'true','true','true','true','true','0-0','0-0;'),
(15767,'Sealed Moirai Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,76,0,8221000,395,'true','true','true','true','true','0-0','0-0;'),
(15768,'Sealed Moirai Necklace','','neck','true','none',150,'wood','s80',0,-1,-1,0,101,0,10961000,526,'true','true','true','true','true','0-0','0-0;'),
(16025,'Freya Necklace','','neck','true','none',150,'wood','s84',0,-1,-1,0,125,50,15192000,729,'true','true','true','true','true','0-0','8459-1;'),
(16026,'Blessed Freya Necklace','','neck','true','none',150,'wood','s84',0,-1,-1,0,132,50,15192000,729,'true','true','true','true','true','0-0','8460-1;'),
(16098,'Refined Black Skeleton Circlet','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,6000000,0,'true','true','true','true','true','0-0','0-0;'),
(16099,'Refined Orange Skeleton Circlet','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,6000000,0,'true','true','true','true','true','0-0','0-0;'),
(16100,'Refined Green Skeleton Circlet','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,6000000,0,'true','true','true','true','true','0-0','0-0;'),
(16101,'Refined Brown Skeleton Circlet','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,6000000,0,'true','true','true','true','true','0-0','0-0;'),
(16102,'Refined Shark Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,6000000,0,'true','true','true','true','true','0-0','0-0;'),
(16103,'Chic Gold Horn Cap','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(16104,'Chic Silver Horn Cap','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(16105,'Refined Penguin Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,6000000,0,'true','true','true','true','true','0-0','0-0;'),
(16106,'Refined Brown Turban','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,6000000,0,'true','true','true','true','true','0-0','0-0;'),
(16107,'Refined Yellow Turban','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,6000000,0,'true','true','true','true','true','0-0','0-0;'),
(16108,'Refined Turtle Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,6000000,0,'true','true','true','true','true','0-0','0-0;'),
(16109,'Refined Cow Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,6000000,0,'true','true','true','true','true','0-0','0-0;'),
(16168,'Vesper Breastplate {PvP}','','chest','true','heavy',7520,'wood','s84',0,-1,-1,272,0,0,66953000,3214,'false','false','true','false','true','0-0','0-0;'),
(16169,'Elegia Leather Breastplate {PvP}','','chest','true','light',4140,'wood','s84',0,-1,-1,204,0,0,50215000,2410,'false','false','true','false','true','0-0','0-0;'),
(16170,'Elegia Tunic {PvP}','','chest','true','magic',1750,'wood','s84',0,-1,-1,136,0,661,50215000,2410,'false','false','true','false','true','0-0','0-0;'),
(16171,'Vesper Breastplate {PvP}','','chest','true','heavy',7520,'wood','s84',0,-1,-1,263,0,0,55840000,2680,'false','false','true','false','true','0-0','0-0;'),
(16172,'Vesper Leather Breastplate {PvP}','','chest','true','light',4140,'wood','s84',0,-1,-1,197,0,0,41880000,2010,'false','false','true','false','true','0-0','0-0;'),
(16173,'Vesper Tunic {PvP}','','chest','true','magic',1750,'wood','s84',0,-1,-1,132,0,649,41880000,2010,'false','false','true','false','true','0-0','0-0;'),
(16174,'Moirai Breastplate {PvP}','','chest','true','heavy',7520,'wood','s80',0,-1,-1,238,0,0,33672000,1616,'false','false','true','false','true','0-0','0-0;'),
(16175,'Moirai Leather Breastplate {PvP}','','chest','true','light',4140,'wood','s80',0,-1,-1,178,0,0,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(16176,'Moirai Tunic {PvP}','','chest','true','magic',1750,'wood','s80',0,-1,-1,119,0,614,25255000,1212,'false','false','true','false','true','0-0','0-0;'),
(16289,'Moirai Helmet','','head','true','none',530,'wood','s80',0,-1,-1,96,0,0,12627000,606,'true','true','true','true','true','0-0','8418-1;'),
(16290,'Moirai Leather Helmet','','head','true','none',530,'wood','s80',0,-1,-1,96,0,0,12627000,606,'true','true','true','true','true','0-0','8424-1;'),
(16291,'Moirai Circlet','','head','true','none',530,'wood','s80',0,-1,-1,96,0,0,12627000,606,'true','true','true','true','true','0-0','8429-1;'),
(16292,'Moirai Breastplate','','chest','true','heavy',7520,'wood','s80',0,-1,-1,238,0,0,33672000,1616,'true','true','true','true','true','0-0','8419-1;'),
(16293,'Moirai Leather Breastplate','','chest','true','light',4140,'wood','s80',0,-1,-1,178,0,0,25255000,1212,'true','true','true','true','true','0-0','8425-1;'),
(16294,'Moirai Tunic','','chest','true','magic',1750,'wood','s80',0,-1,-1,119,0,614,25255000,1212,'true','true','true','true','true','0-0','8430-1;'),
(16295,'Moirai Gaiter','','legs','true','heavy',3170,'wood','s80',0,-1,-1,149,0,0,33673000,1010,'true','true','true','true','true','0-0','8420-1;'),
(16296,'Moirai Leather Legging','','legs','true','light',1320,'wood','s80',0,-1,-1,111,0,0,15784000,758,'true','true','true','true','true','0-0','8426-1;'),
(16297,'Moirai Stockings','','legs','true','magic',850,'wood','s80',0,-1,-1,74,0,392,15784000,758,'true','true','true','true','true','0-0','8431-1;'),
(16298,'Moirai Gauntlet','','gloves','true','none',510,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','8421-1;'),
(16299,'Moirai Leather Gloves','','gloves','true','none',510,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','8427-1;'),
(16300,'Moirai Gloves','','gloves','true','none',510,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','8432-1;'),
(16301,'Moirai Boots','','feet','true','none',1070,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','8422-1;'),
(16302,'Moirai Leather Boots','','feet','true','none',1070,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','8428-1;'),
(16303,'Moirai Shoes','','feet','true','none',1070,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','8433-1;'),
(16305,'Moirai Sigil','','lhand','true','sigil',920,'wood','s80',-8,-1,-1,16,0,0,8833000,424,'true','true','true','true','true','0-0','8434-1;'),
(16306,'Vesper Helmet','','head','true','none',530,'wood','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','8435-1;'),
(16307,'Vesper Leather Helmet','','head','true','none',530,'wood','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','8441-1;'),
(16308,'Vesper Circlet','','head','true','none',530,'wood','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','8446-1;'),
(16309,'Vesper Breastplate','','chest','true','heavy',7520,'wood','s84',0,-1,-1,250,0,0,55840000,2680,'true','true','true','true','true','0-0','8436-1;'),
(16310,'Vesper Leather Breastplate','','chest','true','light',4140,'wood','s84',0,-1,-1,187,0,0,41880000,2010,'true','true','true','true','true','0-0','8442-1;'),
(16311,'Vesper Tunic','','chest','true','magic',1750,'wood','s84',0,-1,-1,125,0,637,41880000,2010,'true','true','true','true','true','0-0','8447-1;'),
(16312,'Vesper Gaiter','','legs','true','heavy',3170,'wood','s84',0,-1,-1,156,0,0,29168000,1400,'true','true','true','true','true','0-0','8437-1;'),
(16313,'Vesper Leather Legging','','legs','true','light',1320,'wood','s84',0,-1,-1,117,0,0,21876000,1050,'true','true','true','true','true','0-0','8443-1;'),
(16314,'Vesper Stockings','','legs','true','magic',850,'wood','s84',0,-1,-1,78,0,415,21876000,1050,'true','true','true','true','true','0-0','8448-1;'),
(16315,'Vesper Gauntlet','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','8438-1;'),
(16316,'Vesper Leather Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','8444-1;'),
(16317,'Vesper Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','8449-1;'),
(16318,'Vesper Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','8439-1;'),
(16319,'Vesper Leather Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','8445-1;'),
(16320,'Vesper Shoes','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','8450-1;'),
(16322,'Vesper Sigil','','lhand','true','sigil',920,'wood','s84',-8,-1,-1,17,0,0,12250000,588,'true','true','true','true','true','0-0','8451-1;'),
(16323,'Sealed Moirai Helmet','','head','true','none',530,'wood','s80',0,-1,-1,96,0,0,12627000,606,'true','true','true','true','true','0-0','0-0;'),
(16324,'Sealed Moirai Leather Helmet','','head','true','none',530,'wood','s80',0,-1,-1,96,0,0,12627000,606,'true','true','true','true','true','0-0','0-0;'),
(16325,'Sealed Moirai Circlet','','head','true','none',530,'wood','s80',0,-1,-1,96,0,0,12627000,606,'true','true','true','true','true','0-0','0-0;'),
(16326,'Sealed Moirai Breastplate','','chest','true','heavy',7520,'wood','s80',0,-1,-1,225,0,0,33672000,1616,'true','true','true','true','true','0-0','0-0;'),
(16327,'Sealed Moirai Leather Breastplate','','chest','true','light',4140,'wood','s80',0,-1,-1,169,0,0,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(16328,'Sealed Moirai Tunic','','chest','true','magic',1750,'wood','s80',0,-1,-1,112,0,614,25255000,1212,'true','true','true','true','true','0-0','0-0;'),
(16329,'Sealed Moirai Gaiter','','legs','true','heavy',3170,'wood','s80',0,-1,-1,141,0,0,33673000,1010,'true','true','true','true','true','0-0','0-0;'),
(16330,'Sealed Moirai Leather Legging','','legs','true','light',1320,'wood','s80',0,-1,-1,105,0,0,15784000,758,'true','true','true','true','true','0-0','0-0;'),
(16331,'Sealed Moirai Stockings','','legs','true','magic',850,'wood','s80',0,-1,-1,70,0,392,15784000,758,'true','true','true','true','true','0-0','0-0;'),
(16332,'Sealed Moirai Gauntlet','','gloves','true','none',510,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(16333,'Sealed Moirai Leather Gloves','','gloves','true','none',510,'wood','s80',0,-1,-1,64,0,0,88418000,404,'true','true','true','true','true','0-0','0-0;'),
(16334,'Sealed Moirai Gloves','','gloves','true','none',510,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(16335,'Sealed Moirai Boots','','feet','true','none',1070,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(16336,'Sealed Moirai Leather Boots','','feet','true','none',1070,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(16337,'Sealed Moirai Shoes','','feet','true','none',1070,'wood','s80',0,-1,-1,64,0,0,8418000,404,'true','true','true','true','true','0-0','0-0;'),
(16339,'Sealed Moirai Sigil','','lhand','true','sigil',920,'wood','s80',-8,-1,-1,16,0,0,8833000,424,'true','true','true','true','true','0-0','0-0;'),
(16340,'Sealed Vesper Helmet','','head','true','none',530,'wood','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(16341,'Sealed Vesper Leather Helmet','','head','true','none',530,'wood','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(16342,'Sealed Vesper Circlet','','head','true','none',530,'wood','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(16343,'Sealed Vesper Breastplate','','chest','true','heavy',7520,'wood','s84',0,-1,-1,250,0,0,55840000,2680,'true','true','true','true','true','0-0','0-0;'),
(16344,'Sealed Vesper Leather Leather Breastplate','','chest','true','light',4140,'wood','s84',0,-1,-1,187,0,0,41880000,2010,'true','true','true','true','true','0-0','0-0;'),
(16345,'Sealed Vesper Tunic','','chest','true','magic',1750,'wood','s84',0,-1,-1,125,0,637,41880000,2010,'true','true','true','true','true','0-0','0-0;'),
(16346,'Sealed Vesper Gaiter','','legs','true','heavy',3170,'wood','s84',0,-1,-1,148,0,0,29168000,1400,'true','true','true','true','true','0-0','0-0;'),
(16347,'Sealed Vesper Leather Legging','','legs','true','light',1320,'wood','s84',0,-1,-1,111,0,0,21876000,1050,'true','true','true','true','true','0-0','0-0;'),
(16348,'Sealed Vesper Stockings','','legs','true','magic',850,'wood','s84',0,-1,-1,74,0,415,21876000,1050,'true','true','true','true','true','0-0','0-0;'),
(16349,'Sealed Vesper Gauntlet','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(16350,'Sealed Vesper Leather Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(16351,'Sealed Vesper Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(16352,'Sealed Vesper Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(16353,'Sealed Vesper Leather Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(16354,'Sealed Vesper Shoes','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(16356,'Sealed Vesper Sigil','','lhand','true','sigil',920,'wood','s84',-8,-1,-1,17,0,0,12250000,588,'true','true','true','true','true','0-0','0-0;'),
(16369,'Sealed Vesper Ring','','rfinger,lfinger','true','none',150,'wood','s84',0,-1,-1,0,55,0,4658000,224,'true','true','true','true','true','0-0','0-0;'),
(16370,'Sealed Vesper Earring','','rear,lear','true','none',150,'wood','s84',0,-1,-1,0,83,0,6986000,547,'true','true','true','true','true','0-0','0-0;'),
(16371,'Sealed Vesper Necklace','','neck','true','none',150,'wood','s84',0,-1,-1,0,110,0,9315000,729,'true','true','true','true','true','0-0','0-0;'),
(16372,'Sealed Moirai Ring','','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,53,0,5480000,263,'true','true','true','true','true','0-0','0-0;'),
(16373,'Sealed Moirai Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,76,0,8221000,395,'true','true','true','true','true','0-0','0-0;'),
(16374,'Sealed Moirai Necklace','','neck','true','none',150,'wood','s80',0,-1,-1,0,101,0,10961000,526,'true','true','true','true','true','0-0','0-0;'),
(16375,'Vesper Ring','','rfinger,lfinger','true','none',150,'wood','s84',0,-1,-1,0,62,25,4658000,224,'true','true','true','true','true','0-0','8457-1;'),
(16376,'Vesper Earring','','rear,lear','true','none',150,'wood','s84',0,-1,-1,0,94,37,6986000,547,'true','true','true','true','true','0-0','8455-1;'),
(16377,'Vesper Necklace','','neck','true','none',150,'wood','s84',0,-1,-1,0,125,50,9315000,729,'true','true','true','true','true','0-0','8456-1;'),
(16378,'Moirai Ring','','rfinger,lfinger','true','none',150,'wood','s80',0,-1,-1,0,61,24,5480000,263,'true','true','true','true','true','0-0','8454-1;'),
(16379,'Moirai Earring','','rear,lear','true','none',150,'wood','s80',0,-1,-1,0,86,36,8221000,395,'true','true','true','true','true','0-0','8452-1;'),
(16380,'Moirai Necklace','','neck','true','none',150,'wood','s80',0,-1,-1,0,115,48,10961000,526,'true','true','true','true','true','0-0','8453-1;'),
(16837,'Vesper Noble Helmet','','head','true','none',530,'wood','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(16838,'Vesper Noble Leather Helmet','','head','true','none',530,'wood','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(16839,'Vesper Noble Circlet','','head','true','none',530,'wood','s84',0,-1,-1,101,0,0,17500000,840,'true','true','true','true','true','0-0','0-0;'),
(16840,'Vesper Noble Breastplate','','chest','true','heavy',7520,'wood','s84',0,-1,-1,250,0,0,55840000,2680,'true','true','true','true','true','0-0','0-0;'),
(16841,'Vesper Noble Leather Breastplate','','chest','true','light',4140,'wood','s84',0,-1,-1,187,0,0,41880000,2010,'true','true','true','true','true','0-0','0-0;'),
(16842,'Vesper Noble Tunic','','chest','true','magic',1750,'wood','s84',0,-1,-1,125,0,637,41880000,2010,'true','true','true','true','true','0-0','0-0;'),
(16843,'Vesper Noble Gaiter','','legs','true','heavy',3170,'wood','s84',0,-1,-1,156,0,0,29168000,1400,'true','true','true','true','true','0-0','0-0;'),
(16844,'Vesper Noble Leather Legging','','legs','true','light',1320,'wood','s84',0,-1,-1,117,0,0,21876000,1050,'true','true','true','true','true','0-0','0-0;'),
(16845,'Vesper Noble Stockings','','legs','true','magic',850,'wood','s84',0,-1,-1,78,0,415,21876000,1050,'true','true','true','true','true','0-0','0-0;'),
(16846,'Vesper Noble Gauntlet','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(16847,'Vesper Noble Leather Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(16848,'Vesper Noble Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(16849,'Vesper Noble Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(16850,'Vesper Noble Leather Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(16851,'Vesper Noble Shoes','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'true','true','true','true','true','0-0','0-0;'),
(16854,'Majestic Earring of Friendship','90 day limited period','rear,lear','true','none',150,'wood','a',0,-1,129600,0,63,25,0,0,'false','false','true','false','true','0-0','0-0;'),
(16855,'Majestic Necklace of Friendship','90 day limited period','neck','true','none',150,'wood','a',0,-1,129600,0,85,33,0,0,'false','false','true','false','true','0-0','0-0;'),
(16856,'Majestic Ring of Friendship','90 day limited period','rfinger,lfinger','true','none',150,'wood','a',0,-1,129600,0,42,17,0,0,'false','false','true','false','true','0-0','0-0;'),
(16857,'Friendship Earring of Black Ore','90 day limited period','rear,lear','true','none',150,'wood','b',0,-1,129600,0,54,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16858,'Friendship Necklace of Black Ore','90 day limited period','neck','true','none',150,'wood','b',0,-1,129600,0,72,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16859,'Friendship Ring of Black Ore','90 day limited period','rfinger,lfinger','true','none',150,'wood','b',0,-1,129600,0,36,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16860,'Friendship Earring of Binding','90 day limited period','rear,lear','true','none',150,'wood','c',0,-1,129600,0,45,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16861,'Friendship Necklace of Binding','90 day limited period','neck','true','none',150,'wood','c',0,-1,129600,0,64,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16862,'Friendship Ring of Binding','90 day limited period','rfinger,lfinger','true','none',150,'wood','c',0,-1,129600,0,32,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16863,'Elven Earring of Friendship','90 day limited period','rear,lear','true','none',150,'wood','d',0,-1,129600,0,34,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16864,'Elven Earring of Friendship','90 day limited period','rear,lear','true','none',150,'wood','d',0,-1,129600,0,45,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16865,'Elven Ring of Friendship','90 day limited period','rfinger,lfinger','true','none',150,'wood','d',0,-1,129600,0,22,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16866,'Dark Crystal Robe of Friendship','90 day limited period','fullarmor','true','magic',2450,'wood','a',0,-1,129600,139,0,665,0,0,'false','false','true','false','true','0-0','0-0;'),
(16867,'Dark Crystal Helmet of Friendship','90 day limited period','head','true','none',570,'wood','a',0,-1,129600,69,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16868,'Dark Crystal Gloves of Friendship - Robe','90 day limited period','gloves','true','none',580,'wood','a',0,-1,129600,46,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16869,'Dark Crystal Boots of Friendship - Robe','90 day limited period','feet','true','none',1110,'wood','a',0,-1,129600,46,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16871,'Avadon Robe of Friendship','90 day limited period','fullarmor','true','magic',2540,'wood','b',0,-1,129600,127,0,561,0,0,'false','false','true','false','true','0-0','0-0;'),
(16872,'Avadon Circlet of Friendship','90 day limited period','none','true','none',590,'wood','b',0,-1,129600,62,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16873,'Avadon Gloves of Friendship - Robe','90 day limited period','gloves','true','none',590,'wood','b',0,-1,129600,41,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16874,'Avadon Boots of Friendship - Robe','90 day limited period','feet','true','none',1180,'wood','b',0,-1,129600,41,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16876,'Karmian Tunic of Friendship','90 day limited period','chest','true','magic',1980,'wood','c',0,-1,129600,60,0,225,0,0,'false','false','true','false','true','0-0','0-0;'),
(16877,'Karmian Stockings of Friendship','90 day limited period','legs','true','magic',970,'wood','c',0,-1,129600,37,0,141,0,0,'false','false','true','false','true','0-0','0-0;'),
(16878,'Karmian Gloves of Friendship','90 day limited period','gloves','true','none',620,'wood','c',0,-1,129600,32,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16879,'Karmian Boots of Friendship','90 day limited period','feet','true','none',1230,'wood','c',0,-1,129600,32,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16880,'Mithril Tunic of Friendship','90 day limited period','chest','true','magic',2010,'wood','d',0,-1,129600,52,0,169,0,0,'false','false','true','false','true','0-0','0-0;'),
(16881,'Mithril Stockings of Friendship','90 day limited period','legs','true','magic',980,'wood','d',0,-1,129600,32,0,105,0,0,'false','false','true','false','true','0-0','0-0;'),
(16882,'Elven Mithril Gloves of Friendship','90 day limited period','gloves','true','none',640,'wood','d',0,-1,129600,27,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16883,'Elven Mithril Boots of Friendship','90 day limited period','feet','true','none',1250,'wood','d',0,-1,129600,27,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16884,'Dark Crystal Leather Armor of Friendship','90 day limited period','none','true','light',4300,'wood','a',0,-1,129600,128,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16885,'Dark Crystal Leggings of Friendship','90 day limited period','legs','true','light',1480,'wood','a',0,-1,129600,80,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16886,'Dark Crystal Gloves of Friendship - Light Armor','90 day limited period','gloves','true','none',580,'wood','a',0,-1,129600,46,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16887,'Dark Crystal Boots of Friendship - Light Armor','90 day limited period','feet','true','none',1110,'wood','a',0,-1,129600,46,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16888,'Leather Armor of Doom of Friendship','90 day limited period','fullarmor','true','light',5500,'wood','b',0,-1,129600,202,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16889,'Doom Helmet of Friendship','90 day limited period','head','true','none',580,'wood','b',0,-1,129600,66,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16890,'Doom Gloves of Friendship - Heavy Armor','90 day limited period','gloves','true','none',580,'wood','b',0,-1,129600,44,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16891,'Doom Gloves of Friendship - Light Armor','90 day limited period','gloves','true','none',580,'wood','b',0,-1,129600,44,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16892,'Doom Boots of Friendship - Heavy Armor','90 day limited period','feet','true','none',1130,'wood','b',0,-1,129600,44,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16893,'Doom Boots of Friendship - Light Armor','90 day limited period','feet','true','none',1130,'wood','b',0,-1,129600,44,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16894,'Doom Plate Armor of Friendship','90 day limited period','fullarmor','true','heavy',9980,'wood','b',0,-1,129600,270,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16896,'Plate Leather Armor of Friendship','90 day limited period','fullarmor','true','light',4450,'wood','c',0,-1,129600,94,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16897,'Plate Leather Gaiters of Friendship','90 day limited period','legs','true','light',1560,'wood','c',0,-1,129600,59,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16898,'Plate Leather Boots of Friendship','90 day limited period','feet','true','none',1220,'wood','c',0,-1,129600,32,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16899,'Plate Leather Gloves of Friendship','90 day limited period','gloves','true','none',610,'wood','c',0,-1,129600,33,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16900,'Full Plate Helmet of Friendship','90 day limited period','head','true','none',600,'wood','c',0,-1,129600,58,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16901,'Full Plate Armor of Friendship','90 day limited period','fullarmor','true','heavy',10480,'wood','c',0,-1,129600,239,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16902,'Full Plate Boots of Friendship','90 day limited period','feet','true','none',1200,'wood','c',0,-1,129600,39,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16903,'Full Plate Gauntlet of Friendship','90 day limited period','gloves','true','none',600,'wood','c',0,-1,129600,39,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16905,'Manticore Skin Shirt of Friendship','90 day limited period','none','true','light',4520,'wood','d',0,-1,129600,77,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16906,'Manticore Skin Gaiters of Friendship','90 day limited period','legs','true','light',1550,'wood','d',0,-1,129600,48,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16907,'Manticore Skin Boots of Friendship','90 day limited period','feet','true','none',1260,'wood','d',0,-1,129600,27,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16908,'Manticore Skin Gloves of Friendship','90 day limited period','gloves','true','none',630,'wood','d',0,-1,129600,27,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16909,'Brigandine of Friendship','90 day limited period','none','true','heavy',8320,'wood','d',0,-1,129600,103,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16910,'Brigandine Gaiters of Friendship','90 day limited period','legs','true','heavy',3820,'wood','d',0,-1,129600,64,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16911,'Brigandine Helmet of Friendship','90 day limited period','head','true','none',630,'wood','d',0,-1,129600,41,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16912,'Brigandine Boots of Friendship','90 day limited period','feet','true','none',1250,'wood','d',0,-1,129600,27,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16913,'Brigandine Gauntlet of Friendship','90 day limited period','gloves','true','none',630,'wood','d',0,-1,129600,27,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16915,'Friendship Armor of Nightmare','90 day limited period','fullarmor','true','heavy',9580,'wood','a',0,-1,129600,293,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16916,'Friendship Helm of Nightmare','90 day limited period','head','true','none',560,'wood','a',0,-1,129600,73,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16917,'Friendship Gauntlet of Nightmare - Heavy Armor','90 day limited period','gloves','true','none',550,'wood','a',0,-1,129600,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(16918,'Friendship Boots of Nightmare - Heavy Armor','90 day limited period','feet','true','none',1110,'wood','a',0,-1,129600,49,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(17004,'Agathion Seal Bracelet - Kid Rudolph','Event','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(17006,'Sealed Vesper Noble Breastplate','','chest','true','heavy',7520,'wood','s84',0,-1,-1,236,0,0,55840000,2680,'false','false','false','false','false','0-0','0-0;'),
(17007,'Sealed Vesper Noble Leather Breastplate','','chest','true','light',4140,'wood','s84',0,-1,-1,177,0,0,41880000,2010,'false','false','false','false','false','0-0','0-0;'),
(17008,'Sealed Vesper Noble Tunic','','chest','true','magic',1750,'wood','s84',0,-1,-1,118,0,637,41880000,2010,'false','false','false','false','false','0-0','0-0;'),
(17009,'Sealed Vesper Noble Gaiters','','legs','true','heavy',3170,'wood','s84',0,-1,-1,148,0,0,29168000,1400,'false','false','false','false','false','0-0','0-0;'),
(17010,'Sealed Vesper Noble Gauntlet','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'false','false','false','false','false','0-0','0-0;'),
(17011,'Sealed Vesper Noble Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'false','false','false','false','false','0-0','0-0;'),
(17012,'Sealed Vesper Noble Leather Leggings','','legs','true','light',1320,'wood','s84',0,-1,-1,111,0,0,21876000,1050,'false','false','false','false','false','0-0','0-0;'),
(17013,'Sealed Vesper Noble Leather Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'false','false','false','false','false','0-0','0-0;'),
(17014,'Sealed Vesper Noble Leather Boots','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'false','false','false','false','false','0-0','0-0;'),
(17015,'Sealed Vesper Noble Stockings','','legs','true','magic',850,'wood','s84',0,-1,-1,74,0,415,21876000,1050,'false','false','false','false','false','0-0','0-0;'),
(17016,'Sealed Vesper Noble Gloves','','gloves','true','none',510,'wood','s84',0,-1,-1,68,0,0,11667000,560,'false','false','false','false','false','0-0','0-0;'),
(17017,'Sealed Vesper Noble Shoes','','feet','true','none',1070,'wood','s84',0,-1,-1,68,0,0,11667000,560,'false','false','false','false','false','0-0','0-0;'),
(17033,'Circlet of Freeze - For Events','30 day limited period','none','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17049,'Shiny Bracelet','','none','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17050,'Shiny Couple Ring','','rfinger,lfinger','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17051,'Talisman - STR','','talisman','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(17052,'Talisman - DEX','','talisman','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(17053,'Talisman - CON','','talisman','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(17054,'Talisman - WIT','','talisman','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(17055,'Talisman - INT','','talisman','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(17056,'Talisman - MEN','','talisman','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(17057,'Talisman - Stun Resistance','','talisman','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(17058,'Talisman - Sleep Resistance','','talisman','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(17059,'Talisman - Hold Resistance','','talisman','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(17060,'Talisman - Paralyze Resistance','','talisman','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(17061,'Talisman - ALL STAT','','talisman','false','none',0,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(17141,'Ribbon Hairband','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17142,'Refined Wizard Hat','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17143,'Refined Jester Hat','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17144,'Refined Romantic Chapeau','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17145,'Refined Dapper Cap','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17146,'Refined Angel Ring','Promotion','rfinger,lfinger','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17147,'Popped-Out Eye','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17148,'Bird Nest','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17149,'Varka Karm (used by Varka Silenos)','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17150,'Ketra Karm (used by Ketra Orcs)','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17151,'Puffy Hat of Friendship','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17152,'Arrow-Pierced Apple','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17153,'Fish Hat','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17154,'Purple Viking Circlet','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17155,'Golden Viking Circlet','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17156,'White Sheep Hat','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(17157,'Black Sheep Hat','Promotion','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20006,'Agathion Seal Bracelet - Majo','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21000-1;3267-1;23000-1;'),
(20007,'Agathion Seal Bracelet - Gold Majo','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21001-1;3267-1;23001-1;'),
(20008,'Agathion Seal Bracelet - Black Majo','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21002-1;3267-1;23002-1;'),
(20009,'Agathion Seal Bracelet - Majo','Big Head 30 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','21000-1;23000-1;23004-1;3267-1;'),
(20010,'Agathion Seal Bracelet - Gold Majo','Resurrection 30 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','21001-1;23001-1;23005-1;3267-1;'),
(20011,'Agathion Seal Bracelet - Black Majo','Escape 30 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','21002-1;23002-1;23006-1;3267-1;'),
(20012,'Agathion Seal Bracelet - Plaipitak','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21003-1;3267-1;23003-1;'),
(20013,'Agathion Seal Bracelet - Plaipitak','Big Head 30 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','21003-1;23007-1;3267-1;23003-1;'),
(20014,'Agathion Seal Bracelet - Plaipitak','Resurrection 30 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','21003-1;23009-1;3267-1;23003-1;'),
(20015,'Agathion Seal Bracelet - Plaipitak','Escape 30 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','21003-1;23008-1;3267-1;23003-1;'),
(20016,'Horn-Rimmed Glasses','Agility','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(20017,'Afro Hair','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(20018,'Afro Hair','Big Head,Firework','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(20019,'Afro Hair','Wind Walk','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(20020,'Uniform Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(20021,'Assassin\'s Bamboo Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(20022,'Ruthless Tribe Mask','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(20023,'Ribbon Hairband','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(20024,'Visor','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(20029,'Light Purple-Maned Horse Mounting Bracelet','','lbracelet','false','none',30,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8247-1;'),
(20030,'Light Purple-Maned Horse Mounting Bracelet','30 Day Expiration Period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8247-1;'),
(20031,'Kat the Cat Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(20032,'Skull Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(20063,'Agathion Seal Bracelet - Baby Panda','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21008-1;3267-1;23010-1;'),
(20064,'Agathion Seal Bracelet - Bamboo Panda','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21009-1;3267-1;23011-1;'),
(20065,'Agathion Seal Bracelet - Sexy Panda','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21010-1;3267-1;23012-1;'),
(20066,'Agathion Seal Bracelet - Baby Panda','Big Head-15 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,21600,0,0,0,0,0,'false','false','true','false','true','0-0','21008-1;3267-1;23010-1;23013-1;'),
(20067,'Agathion Seal Bracelet - Bamboo Panda','Resurrection-15 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,21600,0,0,0,0,0,'false','false','true','false','true','0-0','21009-1;3267-1;23011-1;23014-1;'),
(20068,'Agathion Seal Bracelet - Sexy Panda','Escape-15 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,21600,0,0,0,0,0,'false','false','true','false','true','0-0','21010-1;3267-1;23012-1;23015-1;'),
(20083,'Afro Hair','Energy - 3 Hour Expiration Period','hairall','false','none',10,'wood','none',0,-1,180,0,0,0,0,0,'false','false','true','false','true','0-0','21011-1;'),
(20084,'Afro Hair','Energy - 3 Day Expiration Period','hairall','false','none',10,'wood','none',0,-1,4320,0,0,0,0,0,'false','false','true','false','true','0-0','21011-1;'),
(20085,'Afro Hair','Energy - 30 Day Expiration Period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','21011-1;'),
(20086,'Horn Rimmed Glasses','Energy - 3 Hour Expiration Period','face','false','none',10,'wood','none',0,-1,180,0,0,0,0,0,'false','false','true','false','true','0-0','21012-1;'),
(20087,'Horn Rimmed Glasses','Energy - 3 Day Expiration Period','face','false','none',10,'wood','none',0,-1,4320,0,0,0,0,0,'false','false','true','false','true','0-0','21012-1;'),
(20088,'Horn Rimmed Glasses','Energy - 30 Day Expiration Period','face','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','21012-1;'),
(20089,'Assassin\'s Bamboo Hat','Energy - 3 Hour Expiration Period','hairall','false','none',10,'wood','none',0,-1,180,0,0,0,0,0,'false','false','true','false','true','0-0','21013-1;'),
(20090,'Assassin\'s Bamboo Hat','Energy - 3 Day Expiration Period','hairall','false','none',10,'wood','none',0,-1,4320,0,0,0,0,0,'false','false','true','false','true','0-0','21013-1;'),
(20091,'Assassin\'s Bamboo Hat','Energy - 30 Day Expiration Period','hairall','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','21013-1;'),
(20094,'Agathion Seal Bracelet: Rudolph','Energy - 30 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','3425-1;3267-1;5537-1;23016-1;'),
(20095,'Santa Horn Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(20098,'Formal Dress - Event','1 hour Shadow time','fullarmor','false','magic',1000,'cloth','none',0,60,60,0,0,0,5000000,0,'true','true','true','true','true','0-0','0-0;'),
(20099,'Formal Dress - Event','7 Day Expiration Period','fullarmor','false','magic',1000,'cloth','none',0,-1,10080,0,0,0,5000000,0,'true','true','true','true','true','0-0','0-0;'),
(20100,'Saving Santa Hat','24 Hour Expiration Period','hairall','false','none',10,'wood','none',0,-1,1440,0,0,0,0,0,'false','false','true','false','true','0-0','21014-1;21015-1;21016-1;'),
(20200,'Agathion of Love','3 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,4320,0,0,0,0,0,'false','false','true','false','true','0-0','8245-1;23024-1;3267-1;'),
(20201,'Agathion of Love','7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','8245-1;23024-1;3267-1;'),
(20202,'Agathion of Love','15 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,21600,0,0,0,0,0,'false','false','true','false','true','0-0','8245-1;23024-1;3267-1;'),
(20203,'Agathion of Love','30 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','8245-1;23024-1;3267-1;'),
(20204,'Queen Ant\'s Ring (Event)','3 Day Expiration Period','rfinger,lfinger','false','none',150,'wood','b',0,-1,4320,0,48,21,0,0,'false','false','true','false','true','0-0','3562-1;'),
(20205,'Queen Ant\'s Ring (Event)','7 Day Expiration Period','rfinger,lfinger','false','none',150,'wood','b',0,-1,10080,0,48,21,0,0,'false','false','true','false','true','0-0','3562-1;'),
(20206,'Queen Ant\'s Ring (Event)','15 Day Expiration Period','rfinger,lfinger','false','none',150,'wood','b',0,-1,21600,0,48,21,0,0,'false','false','true','false','true','0-0','3562-1;'),
(20207,'Zaken\'s Earring (Event)','3 Day Expiration Period','rear,lear','false','none',150,'wood','s',0,-1,4320,0,71,31,0,0,'false','false','true','false','true','0-0','3559-1;'),
(20208,'Zaken\'s Earring (Event)','7 Day Expiration Period','rear,lear','false','none',150,'wood','s',0,-1,10080,0,71,31,0,0,'false','false','true','false','true','0-0','3559-1;'),
(20209,'Zaken\'s Earring (Event)','15 Day Expiration Period','rear,lear','false','none',150,'wood','s',0,-1,21600,0,71,31,0,0,'false','false','true','false','true','0-0','3559-1;'),
(20212,'Agathion Seal Bracelet - Charming Cupid','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21031-1;3267-1;23025-1;'),
(20213,'Agathion Seal Bracelet - Naughty Cupid','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21032-1;3267-1;23026-1;'),
(20221,'Agathion Seal Bracelet - White Maneki Neko','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21033-1;3267-1;23027-1;23046-1;'),
(20222,'Agathion Seal Bracelet - Black Maneki Neko','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21034-1;3267-1;23028-1;23047-1;'),
(20223,'Agathion Seal Bracelet - Brown Maneki Neko','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21035-1;3267-1;23029-1;23048-1;'),
(20224,'Agathion Seal Bracelet - White Maneki Neko','Resurrection - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21033-1;3267-1;23027-1;23046-1;23030-1;'),
(20225,'Agathion Seal Bracelet - Black Maneki Neko','Escape - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21034-1;3267-1;23028-1;23047-1;23031-1;'),
(20226,'Agathion Seal Bracelet - Brown Maneki Neko','Vitality - 7-day limited time','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21035-1;3267-1;23029-1;23048-1;23032-1;'),
(20230,'Agathion Seal Bracelet - One-Eyed Bat Drove','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21036-1;3267-1;23033-1;'),
(20231,'Agathion Seal Bracelet - One-Eyed Bat Drove','Resist Unholy - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21036-1;3267-1;23033-1;23034-1;'),
(20232,'Agathion Seal Bracelet - One-Eyed Bat Drove','Vitality - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21036-1;3267-1;23033-1;23035-1;'),
(20236,'Agathion Seal Bracelet - Pegasus','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21037-1;3267-1;23036-1;'),
(20237,'Agathion Seal Bracelet - Pegasus','Wind Walk - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21037-1;3267-1;23036-1;23037-1;'),
(20238,'Agathion Seal Bracelet - Pegasus','Escape - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21037-1;3267-1;23036-1;23038-1;'),
(20245,'Agathion Seal Bracelet - Yellow-Robed Tojigong','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21038-1;3267-1;23039-1;'),
(20246,'Agathion Seal Bracelet - Blue-Robed Tojigong','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21039-1;3267-1;23040-1;'),
(20247,'Agathion Seal Bracelet - Green-Robed Tojigong','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21040-1;3267-1;23041-1;'),
(20248,'Agathion Seal Bracelet - Yellow-Robed Tojigong','Greater Heal - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21038-1;3267-1;23039-1;23042-1;'),
(20249,'Agathion Seal Bracelet - Blue-Robed Tojigong','Reflect Damage - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21039-1;3267-1;23040-1;23043-1;'),
(20250,'Agathion Seal Bracelet - Green-Robed Tojigong','Mana Regeneration - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21040-1;3267-1;23041-1;23044-1;'),
(20252,'Agathion Seal Bracelet - Bugbear','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21041-1;3267-1;23045-1;'),
(20253,'Agathion of Love (Event)','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8245-1;3267-1;'),
(20275,'Gold Afro','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(20276,'Pink Afro','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(20297,'Agathion Seal Bracelet - Red Sumo Wrestler','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21043-1;3267-1;23049-1;'),
(20298,'Agathion Seal Bracelet - Red Sumo Wrestler','Death Whisper - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21043-1;3267-1;23049-1;23057-1;'),
(20299,'Agathion Seal Bracelet - Blue Sumo Wrestler','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21044-1;3267-1;23050-1;'),
(20300,'Agathion Seal Bracelet - Blue Sumo Wrestler','Wild Magic - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21044-1;3267-1;23050-1;23058-1;'),
(20301,'Agathion Seal Bracelet - Great Sumo Match','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21045-1;3267-1;23051-1;'),
(20302,'Agathion Seal Bracelet - Great Sumo Match','Big Head / Firework - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21045-1;3267-1;23051-1;23059-1;23060-1;'),
(20303,'Agathion Seal Bracelet - Button-Eyed Bear Doll','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21046-1;3267-1;23052-1;'),
(20304,'Agathion Seal Bracelet - Button-Eyed Bear Doll','Escape - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21046-1;3267-1;23052-1;23061-1;'),
(20305,'Agathion Seal Bracelet - Button-Eyed Bear Doll','Resurrection - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21046-1;3267-1;23052-1;23062-1;'),
(20306,'Agathion Seal Bracelet - Button-Eyed Bear Doll','Energy - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21046-1;3267-1;23052-1;23063-1;'),
(20307,'Agathion Seal Bracelet - God of Fortune','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21047-1;3267-1;23053-1;'),
(20308,'Agathion Seal Bracelet - God of Fortune','Energy - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21047-1;3267-1;23053-1;23064-1;'),
(20309,'Agathion Seal Bracelet - Dryad','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21048-1;3267-1;23054-1;'),
(20310,'Agathion Seal Bracelet - Wonboso','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21049-1;3267-1;23055-1;'),
(20311,'Agathion Seal Bracelet - Wonboso','Wind Walk - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21049-1;3267-1;23055-1;23065-1;'),
(20312,'Agathion Seal Bracelet - Daewoonso','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','21050-1;3267-1;23056-1;'),
(20313,'Agathion Seal Bracelet - Daewoonso','New Year\'s Gift - 7 Day Expiration Period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21050-1;3267-1;23056-1;23066-1;'),
(20321,'Goggle','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(20322,'Napoleon Hat','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(20323,'Horn Hairband','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(20324,'Black Gem Mask','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(20325,'Plastic Hair','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(20396,'Steam Beatle Mounting Bracelet','','lbracelet','false','none',30,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','8261-1;'),
(20399,'Laborer Hat','Blessed Body - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(20400,'Laborer Hat','Blessed Soul - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(20401,'Laborer Hat','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(20405,'Agathion Seal Bracelet - Majo','Big Head - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21000-1;3267-1;23000-1;'),
(20406,'Agathion Seal Bracelet - Gold Crown Majo','Resurrection - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21001-1;3267-1;23001-1;'),
(20407,'Agathion Seal Bracelet - Black Crown Majo','Escape - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21002-1;3267-1;23002-1;'),
(20408,'Agathion Seal Bracelet - Plaipitak','Big Head - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21003-1;23007-1;3267-1;23003-1;'),
(20409,'Agathion Seal Bracelet - Plaipitak','Resurrection - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21003-1;23009-1;3267-1;23003-1;'),
(20410,'Agathion Seal Bracelet - Plaipitak','Escape - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21003-1;23008-1;3267-1;23003-1;'),
(20411,'Agathion Seal Bracelet - Baby Panda','Big Head - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21008-1;3267-1;23010-1;23013-1;'),
(20412,'Agathion Seal Bracelet - Bamboo Panda','Resurrection - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21009-1;3267-1;23011-1;23014-1;'),
(20413,'Agathion Seal Bracelet - Sexy Panda','Escape - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21010-1;3267-1;23012-1;23015-1;'),
(20414,'Horn Rimmed Glasses','Agility - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20415,'Afro Hair','Big Head,Firework - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20416,'Afro Hair','Wind Walk - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20417,'Uniform Hat','Blessed Resurrection - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20418,'Assassin\'s Bamboo Hat','Wind Walk - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20419,'Ruthless Tribe Mask','Agility - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20420,'Ribbon Hairband','Reflect Damage - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20421,'Visor','Mana Regeneration - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20422,'Kat the Cat Hat','Greater Heal - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20423,'Skull Hat','Death Whisper - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20424,'Afro Hair - Gold','Agility - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20425,'Afro Hair - Pink','Wild Magic - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20426,'Goggles','Wind Walk - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20427,'Napoleon Hat','Mana Regeneration - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20428,'Horn Hairband','Reflect Damage - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20429,'Black Gem Mask','Energy - 7 days limited time','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21066-1;'),
(20430,'Plastic Hair','Blessed Escape - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20431,'Daisy Hairpin','Resist Unholy - 7 day limited period','hair','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20432,'Forget-me-not Hairpin','Wind Walk - 7 day limited period','hair','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20433,'Outlaw\'s Eyepatch','Death Whisper - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20434,'Pirate\'s eyepatch','Agility - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20435,'Monocle','Wild Magic - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20436,'Red Mask of Victory','Mana Regeneration - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20437,'Red Horn of Victory','Reflect Damage - 7 day limited period','hair','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20438,'Party Mask','Greater Heal - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20439,'Red Party Mask','Resist Unholy - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20440,'Cat Ear','Wind Walk - 7 day limited period','hair','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20441,'Noblewoman\'s hairpin','Death Whisper - 7 day limited period','hair','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20442,'Raccoon Ear','Agility - 7 day limited period','hair','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20443,'Rabbit Ear','Wild Magic - 7 day limited period','hair','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20444,'Little Angel Wings','Mana Regeneration - 7 day limited period','hair','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20445,'Fairy\'s Tentacle','Reflect Damage - 7 day limited period','hair','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20446,'Dandy\'s Chapeau','Greater Heal - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20447,'Artisan\'s Goggles','Energy - 7 days limited time','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21084-1;'),
(20448,'Light Purple Maned Horse Mounting Bracelet','7 day limited period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20449,'Steam Beatle Mounting Bracelet','7 day limited period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20495,'Agathion Seal Bracelet - Pomona','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','21085-1;3267-1;23067-1;'),
(20496,'Agathion Seal Bracelet - Pomona','Mental Shield - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21085-1;3267-1;23067-1;23068-1;'),
(20499,'Feline Queen Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20500,'Feline King Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20501,'Kai the Cat Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20535,'Steam Sledge Mounting Bracelet','30 day limited period','lbracelet','false','none',150,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20536,'Tawny Maned Lion Mounting Bracelet','30 day limited period','lbracelet','false','none',150,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','false','0-0','8262-1;'),
(20537,'Afro Hair','Energy - 7 days limited time','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21011-1;'),
(20538,'Horn Rimmed Glasses','Energy - 7 days limited time','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21012-1;'),
(20539,'Assassin\'s Bamboo Hat','Energy - 7 days limited time','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21013-1;'),
(20567,'Eva\'s Circlet (event)','3 day limited time','hairall','false','none',10,'wood','none',0,-1,4320,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20568,'Eva\'s Circlet','7 day limited time','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20569,'Eva\'s Circlet','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20591,'Agathion Seal Bracelet - Weaver','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','21091-1;3267-1;23076-1;'),
(20592,'Agathion Seal Bracelet - Weaver','Power of the Golden Calf - 24 hours limited period','lbracelet','false','none',150,'wood','none',0,-1,1440,0,0,0,0,0,'false','false','true','false','false','0-0','21091-1;3267-1;23076-1;23077-1;'),
(20593,'Agathion Seal Bracelet - Weaver','Power of the Golden Calf - 3 day limited period','lbracelet','false','none',150,'wood','none',0,-1,4320,0,0,0,0,0,'false','false','true','false','false','0-0','21091-1;3267-1;23076-1;23077-1;'),
(20594,'Summon of Love Bracelet (event)','24 hours limited period','none','false','none',0,'wood','none',0,-1,1440,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20601,'Anniversary Hat','Soul of Phoenix - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20613,'Headphone','Town Theme','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20614,'Headphone','Hero Theme','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20615,'Headphone','Park Theme','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20616,'Headphone','Town Theme - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20617,'Headphone','Hero Theme - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20618,'Headphone','Park Theme - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20621,'Agathion Seal Bracelet - Female Weaver','Flute Sound - 24 hours limited time','lbracelet','false','none',150,'wood','none',0,-1,1440,0,0,0,0,0,'false','false','true','false','false','0-0','21091-1;3267-1;23076-1;23078-1;'),
(20622,'Agathion Seal Bracelet - Female Weaver','Flute Sound - 3 day limited time','lbracelet','false','none',150,'wood','none',0,-1,4320,0,0,0,0,0,'false','false','true','false','false','0-0','21091-1;3267-1;23076-1;23078-1;'),
(20626,'Anniversary Hat','Resurrection - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20628,'Summon of Love Bracelet','7 day limited period','none','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20633,'Watermelon Hat','Ability of a Cool Watermelon - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(20634,'Watermelon Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(20642,'Standard Item - Mithril Gloves','','none','false','none',100,'wood','d',0,-1,-1,29,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20643,'Standard Item - Plate Boots','','none','false','none',100,'wood','d',0,-1,-1,29,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20645,'Standard Item - Plate Helmet','','none','false','none',100,'wood','d',0,-1,-1,44,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20646,'Standard Item - Plate Gaiters','','none','false','heavy',100,'wood','d',0,-1,-1,70,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20647,'Standard Item - Half Plate Armor','','none','false','heavy',100,'wood','d',0,-1,-1,111,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20648,'Standard Item - Salamander Skin Mail','','none','false','light',100,'wood','d',0,-1,-1,136,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20650,'Standard Item - Mithril Tunic','','none','false','magic',100,'wood','d',0,-1,-1,52,0,169,0,0,'false','false','false','false','false','0-0','0-0;'),
(20651,'Standard Item - Mithril Stockings','','none','false','magic',100,'wood','d',0,-1,-1,32,0,105,0,0,'false','false','false','false','false','0-0','0-0;'),
(20652,'Standard Item - Salamander Skin Boots','','none','false','none',100,'wood','d',0,-1,-1,29,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20653,'Standard Item - Ogre Power Gauntlet','','none','false','none',100,'wood','d',0,-1,-1,29,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20654,'Agathion Seal Bracelet - Chon-chon','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','21105-1;3267-1;23079-1;'),
(20655,'Agathion Seal Bracelet - Chon-chon','Great Warrior\'s Soul Power - 7 days limited time','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21105-1;3267-1;23079-1;23080-1;'),
(20656,'Agathion Seal Bracelet - Tang-tang','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','21106-1;3267-1;23081-1;'),
(20657,'Agathion Seal Bracelet - Tang-tang','Great Wizard\'s Soul Power - 7 days limited time','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21106-1;3267-1;23081-1;23082-1;'),
(20658,'Agthion Seal Bracelet - Dancing Lucky Kid','','none','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','21107-1;3267-1;23083-1;'),
(20659,'Agthion Seal Bracelet - Dancing Lucky Kid','Great Adventurer\'s Soul Power - 7 days limited time','none','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','false','false','false','0-0','21107-1;3267-1;23083-1;23084-1;'),
(20660,'Agathion Seal Bracelet - Monkey King','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','21108-1;3267-1;23085-1;'),
(20661,'Agathion Seal Bracelet - Monkey King','Great Wizard\'s Soul Power - 7 days limited time','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21108-1;3267-1;23085-1;23086-1;'),
(20662,'Agathion Seal Bracelet - Utanka Agathion','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','21109-1;3267-1;23087-1;'),
(20663,'Agathion Seal Bracelet - Utanka Agathion','Great Warrior\'s Soul Power - 7 days limited time','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21109-1;3267-1;23087-1;23088-1;'),
(20664,'Agathion Seal Bracelet - Bonus B Agathion','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','21110-1;3267-1;23089-1;'),
(20665,'Agathion Seal Bracelet - Bonus B Agathion','Great Adventurer\'s Soul Power - 7 days limited time','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21110-1;3267-1;23089-1;23090-1;'),
(20666,'Valkyrie Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20667,'Valkyrie Hat','Great Adventurer\'s Soul Power - 7 day limited time','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20668,'Tiger Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20669,'Tiger Hat','Great Warrior\'s Soul Power - 7 days limited time','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20670,'Maid\'s Hairband','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20671,'Maid Hairband','Great Wizard\'s Soul Power - 7 days limited time','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20672,'Baby Panda Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20673,'Baby Panda Hat','Blessed Escape - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20674,'Bamboo Panda Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20675,'Bamboo Panda Hat','Great Adventurer\'s Soul Power - 7 days limited time','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20676,'Sexy Panda Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20677,'Sexy Panda Hat','Blessed Resurrection - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20678,'Gate Keeper Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20679,'Gate Keeper Hat','Destroy Instinct - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20711,'Jack O\'Lantern Mask - Event','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20712,'Mask of Giant Hercules - Event','Blessing of Skooldy : Protection of Darkness - 2 Hour Limited Period','hairall','false','none',10,'wood','none',0,-1,120,0,0,0,0,0,'false','false','true','false','false','0-0','21122-1;'),
(20713,'Mask of Silent Scream - Event','Blessing of Skooldy : Protection of Darkness - 2 Hour Limited Period','hairall','false','none',10,'wood','none',0,-1,120,0,0,0,0,0,'false','false','true','false','false','0-0','21123-1;'),
(20714,'Spirit of Wrath Mask - Event','Blessing of Skooldy : Protection of Darkness - 2 Hour Limited Period','hairall','false','none',10,'wood','none',0,-1,120,0,0,0,0,0,'false','false','true','false','false','0-0','21124-1;'),
(20715,'Undecaying Corpse Mask - Event','Blessing of Skooldy : Protection of Darkness - 2 Hour Limited Period','hairall','false','none',10,'wood','none',0,-1,120,0,0,0,0,0,'false','false','true','false','false','0-0','21125-1;'),
(20716,'Planet X235 Alien Mask - Event','Blessing of Skooldy : Protection of Darkness - 2 Hour Limited Period','hairall','false','none',10,'wood','none',0,-1,120,0,0,0,0,0,'false','false','true','false','false','0-0','21126-1;'),
(20718,'Shiny Mask of Giant Hercules - Event','Blessing of Halloween - 4 hours Limited Period','hairall','false','none',10,'wood','none',0,-1,240,0,0,0,0,0,'false','false','true','false','false','0-0','21127-1;'),
(20719,'Shiny Mask of Silent Scream - Event','Blessing of Halloween - 4 hours Limited Period','hairall','false','none',10,'wood','none',0,-1,240,0,0,0,0,0,'false','false','true','false','false','0-0','21128-1;'),
(20720,'Shiny Spirit of Wrath Mask - Event','Blessing of Halloween - 4 hours Limited Period','hairall','false','none',10,'wood','none',0,-1,240,0,0,0,0,0,'false','false','true','false','false','0-0','21129-1;'),
(20721,'Shiny Undecaying Corpse Mask - Event','Blessing of Halloween - 4 hours Limited Period','hairall','false','none',10,'wood','none',0,-1,240,0,0,0,0,0,'false','false','true','false','false','0-0','21130-1;'),
(20722,'Shiny Planet X235 Alien Mask - Event','Blessing of Halloween - 4 hours Limited Period','hairall','false','none',10,'wood','none',0,-1,240,0,0,0,0,0,'false','false','true','false','false','0-0','21131-1;'),
(20723,'Golden Jack O\'Lantern Mask.','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20724,'Golden Jack O\'Lantern Mask.','Authority of Golden Jack O\'Lantern - 7 Days Limited Period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20725,'Red Flame of Valakas','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20726,'Agathion Seal Bracelet - Zombie','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','21133-1;3267-1;23117-1;'),
(20727,'Agathion Seal Bracelet - Zombie','Escape from Death - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21133-1;3267-1;23117-1;23118-1;'),
(20732,'Agathion Seal Bracelet - Baekyi Hwamae','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','21134-1;3267-1;23119-1;'),
(20733,'Agathion Seal Bracelet - Kwanwoo Hwamae','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','21135-1;3267-1;23120-1;'),
(20743,'Shiny Mask of Giant Hercules.','Blessing of Halloween - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21127-1;'),
(20744,'Shiny Mask of Silent Scream.','Blessing of Halloween - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21128-1;'),
(20745,'Shiny Spirit of Wrath Mast.','Blessing of Halloween - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21129-1;'),
(20746,'Shiny Undecaying Corpse Mask.','Blessing of Halloween - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21130-1;'),
(20747,'Shiny Planet X235 Alien Mask.','Blessing of Halloween - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','21131-1;'),
(20759,'Christmas Shirt','24 hours limited period','none','false','none',0,'wood','none',0,-1,1440,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20774,'Agathion Seal Bracelet - Guangong','Aura of Fury - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21142-1;23123-1;23124-1;'),
(20775,'Agathion Seal Bracelet - Gwanseum Nyang Nyang','Blessing of Mercy - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21143-1;23125-1;23126-1;'),
(20776,'Agathion Seal Bracelet - Blue Opera','Sword of Recovery - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21144-1;23127-1;23128-1;'),
(20777,'Agathion Seal Bracelet - Blue Opera','Sword of Lightning - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21145-1;23127-1;23129-1;'),
(20778,'Agathion Seal Bracelet - Red Opera','Spear of Flames - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21146-1;23130-1;23131-1;'),
(20779,'Agathion Seal Bracelet - Opera','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21147-1;23132-1;'),
(20780,'Agathion Seal Bracelet - Opera','Sword of Life - 30 day limited period','lbracelet','false','none',150,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21147-1;23132-1;23164-1;'),
(20781,'Agathion Seal Bracelet - Miss Chipao','Miss Chipao\'s Blessing - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21148-1;23133-1;23134-1;'),
(20782,'Agathion Seal Bracelet - Nepal Snow','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21149-1;23135-1;'),
(20783,'Agathion Seal Bracelet - Round Ball Snow','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21150-1;23137-1;'),
(20784,'Agathion Seal Bracelet - Ladder Snow','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21151-1;23139-1;'),
(20785,'Agathion Seal Bracelet - Nepal Snow','Snow\'s Haste - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21149-1;23135-1;23136-1;'),
(20786,'Agathion Seal Bracelet - Round Ball Snow','Snow\'s Acumen - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21150-1;23137-1;23138-1;'),
(20787,'Agathion Seal Bracelet - Ladder Snow','Snow\'s Wind Walk - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21151-1;23139-1;23140-1;'),
(20789,'Rocket Gun Hat','Continuous Fireworks','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','21152-1;'),
(20790,'Yellow Paper Hat','Blessed Body - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20791,'Pink Paper Mask Set','Blessed Soul - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20792,'Flavorful Cheese Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20793,'Sweet Cheese Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20794,'Flavorful Cheese Hat','Scent of Flavorful Cheese - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20795,'Sweet Cheese Hat','Scent of Sweet Cheese - 7 day limited period','hairall','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20818,'Soul Avatar Seal Bracelet - Iken','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21157-1;23141-1;'),
(20819,'Agathion Seal Bracelet - Iken','Prominent Outsider Adventurer\'s Ability - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21157-1;23141-1;23153-1;'),
(20820,'Soul Avatar Seal Bracelet - Lana','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21158-1;23142-1;'),
(20821,'Agathion Seal Bracelet - Lana','Prominent Outsider Adventurer\'s Ability - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21158-1;23142-1;23153-1;'),
(20822,'Soul Avatar Seal Bracelet - Gnosian','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21159-1;23143-1;'),
(20823,'Agathion Seal Bracelet - Gnocian','Prominent Outsider Adventurer\'s Ability - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21159-1;23143-1;23153-1;'),
(20824,'Soul Avatar Seal Bracelet - Orodriel','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21160-1;23144-1;'),
(20825,'Agathion Seal Bracelet - Orodriel','Prominent Outsider Adventurer\'s Ability - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21160-1;23144-1;23153-1;'),
(20826,'Soul Avatar Seal Bracelet - Lakinos','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21161-1;23145-1;'),
(20827,'Agathion Seal Bracelet - Lakinos','Prominent Outsider Adventurer\'s Ability - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21161-1;23145-1;23153-1;'),
(20828,'Soul Avatar Seal Bracelet - Mortia','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21162-1;23146-1;'),
(20829,'Agathion Seal Bracelet - Mortia','Prominent Outsider Adventurer\'s Ability - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21162-1;23146-1;23153-1;'),
(20830,'Soul Avatar Seal Bracelet - Heintz','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21163-1;23147-1;'),
(20831,'Agathion Seal Bracelet - Hayance','Prominent Outsider Adventurer\'s Ability - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21163-1;23147-1;23153-1;'),
(20832,'Soul Avatar Seal Bracelet - Meruril','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21164-1;23148-1;'),
(20833,'Agathion Seal Bracelet - Meruril','Prominent Outsider Adventurer\'s Ability - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21164-1;23148-1;23153-1;'),
(20834,'Soul Avatar Seal Bracelet - Taman Zu Rapatui','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21165-1;23149-1;'),
(20835,'Agathion Seal Bracelet - Taman ze Lapatui','Prominent Outsider Adventurer\'s Ability - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21165-1;23149-1;23153-1;'),
(20836,'Soul Avatar Seal Bracelet - Kaurin','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21166-1;23150-1;'),
(20837,'Agathion Seal Bracelet - Kaurin','Prominent Outsider Adventurer\'s Ability - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21166-1;23150-1;23153-1;'),
(20838,'Soul Avatar Seal Bracelet - Ahertbein','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21167-1;23151-1;'),
(20839,'Agathion Seal Bracelet - Ahertbein','Prominent Outsider Adventurer\'s Ability - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21167-1;23151-1;23153-1;'),
(20840,'Soul Avatar Seal Bracelet - Naonin','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21168-1;23152-1;'),
(20841,'Agathion Seal Bracelet - Naonin','Prominent Outsider Adventurer\'s Ability - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','3267-1;21168-1;23152-1;23153-1;'),
(20897,'Purple Paper Mask','Blessed Soul - 7 day limited period','face','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20900,'Santa Hat','14 day limited period','hairall','false','none',10,'wood','none',0,-1,20160,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20922,'Adventurer Hat','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20929,'Royal Crown of Vesper','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20930,'Royal Circlet of Vesper','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20931,'Noblesse Oblige','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20932,'Royal Crown of Vesper','30 day limited period','none','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20933,'Royal Circlet of Vesper','30 day limited period','none','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20934,'Noblesse Oblige','30 day limited period','none','false','none',10,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20935,'Royal Crown of Vesper','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20936,'Royal Circlet of Vesper','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20937,'Noblesse Oblige','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20938,'Jet Bike Mounting Bracelet','7 day limited period','lbracelet','false','none',30,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','true','0-0','21171-1;'),
(20939,'Jet Bike Mounting Bracelet','30 day limited period','lbracelet','false','none',30,'wood','none',0,-1,43200,0,0,0,0,0,'false','false','true','false','true','0-0','21171-1;'),
(20940,'Phoenix Agthion Seal Bracelet','Nirvana Rebirth - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','false','false','false','0-0','3267-1;21191-1;23171-1;23172-1;'),
(20941,'Phoenix Agthion Seal Bracelet','Oriental Phoenix - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','false','false','false','0-0','3267-1;21191-1;23171-1;23173-1;'),
(20942,'Fox Mask','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20943,'Fox Mask','Silent Move - 7 day limited period','none','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20944,'Paiwan Hat','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20945,'Paiwan Hat','Power of Guardian Deity - 7 day limited period','none','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20956,'Agathion Seal Bracelet - Frozen Corpse','Soul Stealth - 7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(20968,'Agathion Seal Bracelet - Guangong','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21142-1;23123-1;'),
(20970,'Agathion Seal Bracelet - Three-headed Dragon','Wind Walk','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21194-1;23181-1;23182-1;'),
(20973,'Opera Mask - Liu Bei','Buff of Virtue,Age of the Three Kingdoms','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20974,'Opera Mask - Guan Yu','Silence of Fidelity,Age of the Three Kingdoms','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20975,'Opera Mask - Zhang Fei','Vitality of Courage,Age of the Three Kingdoms','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20981,'Dragon Boat','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20982,'Dragon Boat','Haste - 7 day limited period','none','false','none',10,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(20983,'Agathion Seal Bracelet - Ball Trapping Gnosian','Soccer Ball of Cheers,Buff of Cheers','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21202-1;23183-1;23184-1;23201-1;'),
(20984,'Agathion Seal Bracelet - Ball Trapping Orodriel','Soccer Ball of Cheers,Buff of Cheers','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21203-1;23185-1;23186-1;23202-1;'),
(20985,'Agathion Seal Bracelet - Penalty Kick','Soccer Ball of Cheers,Buff of Cheers','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21204-1;23187-1;23188-1;23203-1;'),
(20986,'Agathion Seal Bracelet - Ball Trapping Gnosian','Soccer Ball of Cheers,Buff of Cheers','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21205-1;23189-1;23190-1;23204-1;'),
(20987,'Agathion Seal Bracelet - Ball Trapping Orodriel','Soccer Ball of Cheers,Buff of Cheers','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21206-1;23191-1;23192-1;23205-1;'),
(20988,'Agathion Seal Bracelet - Penalty Kick','Soccer Ball of Cheers,Buff of Cheers','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21207-1;23193-1;23194-1;23206-1;'),
(20989,'Agathion Seal Bracelet - Ball Trapping Gnosian','Soccer Ball of Cheers,Buff of Cheers','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21208-1;23195-1;23196-1;23207-1;'),
(20990,'Agathion Seal Bracelet - Ball Trapping Orodriel','Soccer Ball of Cheers,Buff of Cheers','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21209-1;23197-1;23198-1;23208-1;'),
(20991,'Agathion Seal Bracelet - Penalty Kick','Soccer Ball of Cheers,Buff of Cheers','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','3267-1;21210-1;23199-1;23200-1;23209-1;'),
(21009,'Soccer Ball Afro Hair - White','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(21010,'Soccer Ball Afro Hair - Blue','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(21011,'Soccer Ball Afro Hair - Red','Blessing of Victory','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(21012,'Mark of Victory - Korea','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(21013,'Mark of Victory - Japan','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(21014,'Mark of Cheers','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(21042,'Flag Hat','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(21043,'Flag Hat','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(21044,'Granny Tiger Hat','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(21045,'Mischievous Bee Hat','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(21046,'Agathion Seal Bracelet - Granny Tiger','7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21047,'Agathion Seal Bracelet - Granny Tiger','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21048,'Agathion Seal Bracelet - Flower Fairy Spirit','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21049,'Agathion Seal Bracelet - Cheerleader Orodriel','7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21050,'Agathion Seal Bracelet - Cheerleader Orodriel','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21051,'Agathion Seal Bracelet - Cheerleader Lana','7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21052,'Agathion Seal Bracelet - Cheerleader Lana','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21053,'Agathion Seal Bracelet - Cheerleader Naonin','7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21054,'Agathion Seal Bracelet - Cheerleader Naonin','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21055,'Agathion Seal Bracelet - Cheerleader Mortia','7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21056,'Agathion Seal Bracelet - Cheerleader Mortia','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21057,'Agathion Seal Bracelet - Cheerleader Kaurin','7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21058,'Agathion Seal Bracelet - Cheerleader Kaurin','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21059,'Agathion Seal Bracelet - Cheerleader Meruril','7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21060,'Agathion Seal Bracelet - Cheerleader Meruril','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21061,'Agathion Seal Bracelet - Handy','7 day limited period','lbracelet','false','none',150,'wood','none',0,-1,10080,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21062,'Agathion Seal Bracelet - Handy','','lbracelet','false','none',150,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21088,'Jet Bike Mounting Bracelet','','lbracelet','false','none',30,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','false','0-0','0-0;'),
(21090,'Plastic Hair','','none','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','false','false','false','0-0','0-0;'),
(22154,'Shadow Weapon - Wolf Hat','Blessed Escape','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(22155,'Shadow Weapon - Wolf Hat','Blessed Resurrection','hairall','false','none',10,'wood','none',0,1440,-1,0,0,0,0,0,'true','true','true','true','true','0-0','0-0;'),
(22156,'Daisy Hairpin','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22157,'Forget-me-not Hairpin','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22158,'Outlaw\'s Eyepatch','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22159,'Pirate\'s eyepatch','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22160,'Monocle','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22161,'Red Mask of Victory','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22162,'Red Horn of Victory','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22163,'Party Mask','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22164,'Red Party Mask','','face','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22165,'Cat Ear','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22166,'Noblewoman\'s hairpin','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22167,'Raccoon Ear','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22168,'Rabbit Ear','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22169,'Little Angel Wings','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22170,'Fairy\'s Tentacle','','hair','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22171,'Dandy\'s Chapeau','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;'),
(22172,'Artisan\'s Goggles','','hairall','false','none',10,'wood','none',0,-1,-1,0,0,0,0,0,'false','false','true','false','true','0-0','0-0;');

-- Just in case someone screws something up or misses something, these scripts will fix a few things.
UPDATE `armor` SET destroyable = "true" WHERE (bodypart = "face") or (bodypart = "hair") or (bodypart = "hairall");

UPDATE `armor` SET bodypart = "lbracelet", sellable = "false", dropable = "false", destroyable = "true", tradeable = "false" WHERE (name LIKE "%mounting%") or (name LIKE "%Agathion%");
UPDATE `armor` SET bodypart = "talisman", sellable = "false", dropable = "false", destroyable = "true", tradeable = "false" WHERE name LIKE "%Talisman%";

UPDATE `armor` SET time = "60" WHERE (additionalname LIKE '%1 hour%') or (additionalname LIKE '%1-hour%');
UPDATE `armor` SET time = "120" WHERE (additionalname LIKE '%2 hour%') or (additionalname LIKE '%2-hour%');
UPDATE `armor` SET time = "180" WHERE (additionalname LIKE '%3 hour%') or (additionalname LIKE '%3-hour%');
UPDATE `armor` SET time = "240" WHERE (additionalname LIKE '%4 hour%') or (additionalname LIKE '%4-hour%');
UPDATE `armor` SET time = "600" WHERE (additionalname LIKE '%10 hour%') or (additionalname LIKE '%10-hour%');
UPDATE `armor` SET time = "1440" WHERE (additionalname LIKE '%24 hour%') or (additionalname LIKE '%24-hour%');
UPDATE `armor` SET time = "4320" WHERE (additionalname LIKE '%3 Day%') or (additionalname LIKE '%3-Day%');
UPDATE `armor` SET time = "10080" WHERE (additionalname LIKE '%7 Day%') or (additionalname LIKE '%7-Day%');
UPDATE `armor` SET time = "14400" WHERE (additionalname LIKE '%10 Day%') or (additionalname LIKE '%10-Day%');
UPDATE `armor` SET time = "20160" WHERE (additionalname LIKE '%14 Day%') or (additionalname LIKE '%14-Day%');
UPDATE `armor` SET time = "21600" WHERE (additionalname LIKE '%15 Day%') or (additionalname LIKE '%15-Day%');
UPDATE `armor` SET time = "43200" WHERE (additionalname LIKE '%30 Day%') or (additionalname LIKE '%30-Day%');
UPDATE `armor` SET time = "86400" WHERE (additionalname LIKE '%60 Day%') or (additionalname LIKE '%60-Day%');
UPDATE `armor` SET time = "129600" WHERE (additionalname LIKE '%90 Day%') or (additionalname LIKE '%90-Day%');

-- PvP Armors can not be traded, or dropped, or shipped, or sold. Just like augmented items but with more restrictions.
UPDATE `armor` SET sellable = "false", dropable = "false", tradeable = "false" WHERE name LIKE '%{PvP}%';

-- Temp Fix for Pet Items
UPDATE `armor` SET armor_type = "pet" WHERE `item_id` = "2506";
UPDATE `armor` SET armor_type = "pet" WHERE `item_id` >= '3891' AND `item_id` <= '3918';
UPDATE `armor` SET armor_type = "pet" WHERE `item_id` = "4234";
UPDATE `armor` SET armor_type = "pet" WHERE `item_id` = "4235";
UPDATE `armor` SET armor_type = "pet" WHERE `item_id` >= '5170' AND `item_id` <= '5216';
UPDATE `armor` SET armor_type = "pet" WHERE `item_id` = "8541";
UPDATE `armor` SET armor_type = "pet" WHERE `item_id` >= '9662' AND `item_id` <= '9667';
UPDATE `armor` SET armor_type = "pet" WHERE `item_id` >= '12740' AND `item_id` <= '12752';