/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.datatables.GMSkillTable;
import com.l2jserver.gameserver.datatables.HeroSkillTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreeTable;
import com.l2jserver.gameserver.model.ChanceCondition;
import com.l2jserver.gameserver.model.IChanceSkillTrigger;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2ArtefactInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ChestInstance;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeFlagInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.BaseStats;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Formulas;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.skills.conditions.Condition;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.taskmanager.DecayTaskManager;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.item.L2Armor;
import com.l2jserver.gameserver.templates.item.L2ArmorType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javolution.util.FastList;

public abstract class L2Skill
implements IChanceSkillTrigger {
    protected static final Logger _log = Logger.getLogger(L2Skill.class.getName());
    private static final L2Object[] _emptyTargetList = new L2Object[0];
    public static final int SKILL_LUCKY = 194;
    public static final int SKILL_CREATE_COMMON = 1320;
    public static final int SKILL_CREATE_DWARVEN = 172;
    public static final int SKILL_CRYSTALLIZE = 248;
    public static final int SKILL_DIVINE_INSPIRATION = 1405;
    public static final int SKILL_CLAN_LUCK = 390;
    public static final boolean geoEnabled = Config.GEODATA > 0;
    public static final int COND_RUNNING = 1;
    public static final int COND_WALKING = 2;
    public static final int COND_SIT = 4;
    public static final int COND_BEHIND = 8;
    public static final int COND_CRIT = 16;
    public static final int COND_LOWHP = 32;
    public static final int COND_ROBES = 64;
    public static final int COND_CHARGES = 128;
    public static final int COND_SHIELD = 256;
    private static final Func[] _emptyFunctionSet = new Func[0];
    private static final L2Effect[] _emptyEffectSet = new L2Effect[0];
    private final int _id;
    private final int _level;
    private int _displayId;
    private final String _name;
    private final SkillOpType _operateType;
    private final boolean _magic;
    private final boolean _staticReuse;
    private final boolean _staticHitTime;
    private final int _mpConsume;
    private final int _mpInitialConsume;
    private final int _hpConsume;
    private final int _cpConsume;
    private final int _targetConsume;
    private final int _targetConsumeId;
    private final int _itemConsume;
    private final int _itemConsumeId;
    private final int _castRange;
    private final int _effectRange;
    private final int _abnormalLvl;
    private final int _negateLvl;
    private final int[] _negateId;
    private final L2SkillType[] _negateStats;
    private final int _maxNegatedEffects;
    private final boolean _stayAfterDeath;
    private final boolean _killByDOT;
    private final int _refId;
    private final int _hitTime;
    private final int[] _hitTimings;
    private final int _coolTime;
    private final int _reuseHashCode;
    private final int _reuseDelay;
    private final int _buffDuration;
    private final int _equipDelay;
    private final SkillTargetType _targetType;
    private final int _feed;
    private final double _power;
    private final double _pvpPower;
    private final int _magicLevel;
    private final int _levelDepend;
    private final boolean _ignoreResists;
    private final int _minChance;
    private final int _maxChance;
    private final boolean _isNeutral;
    private final int _skillRadius;
    private final L2SkillType _skillType;
    private final L2SkillType _effectType;
    private final int _effectAbnormalLvl;
    private final int _effectId;
    private final int _effectLvl;
    private final boolean _nextActionIsAttack;
    private final boolean _removedOnAnyActionExceptMove;
    private final boolean _removedOnDamage;
    private final boolean _isPotion;
    private final byte _element;
    private final int _elementPower;
    private final Stats _stat;
    private final BaseStats _saveVs;
    private final int _condition;
    private final int _conditionValue;
    private final boolean _overhit;
    private final int _weaponsAllowed;
    private final int _armorsAllowed;
    private final int _minPledgeClass;
    private final boolean _isOffensive;
    private final int _maxCharges;
    private final int _numCharges;
    private final int _triggeredId;
    private final int _triggeredLevel;
    private final String _chanceType;
    private final int _soulMaxConsume;
    private final int _soulConsume;
    private final int _numSouls;
    private final int _expNeeded;
    private final int _critChance;
    private final float _dependOnTargetBuff;
    private final int _transformId;
    private final int _transformDuration;
    private final int _afterEffectId;
    private final int _afterEffectLvl;
    private final boolean _isHeroSkill;
    private final boolean _isGMSkill;
    private final int _baseCritRate;
    private final int _lethalEffect1;
    private final int _lethalEffect2;
    private final boolean _directHpDmg;
    private final boolean _isDance;
    private final int _nextDanceCost;
    private final float _sSBoost;
    private final int _aggroPoints;
    protected List<Condition> _preCondition;
    protected List<Condition> _itemPreCondition;
    protected FuncTemplate[] _funcTemplates;
    protected EffectTemplate[] _effectTemplates;
    protected EffectTemplate[] _effectTemplatesSelf;
    protected ChanceCondition _chanceCondition = null;
    private final String _flyType;
    private final int _flyRadius;
    private final float _flyCourse;
    private final boolean _isDebuff;
    private final String _attribute;
    private final boolean _ignoreShield;
    private final boolean _isSuicideAttack;
    private final boolean _canBeReflected;
    private final boolean _canBeDispeled;
    private final boolean _isClanSkill;
    private final boolean _excludedFromCheck;
    private final boolean _simultaneousCast;

    protected L2Skill(StatsSet set) {
        int i;
        this._id = set.getInteger("skill_id");
        this._level = set.getInteger("level");
        this._refId = set.getInteger("referenceId", 0);
        this._displayId = set.getInteger("displayId", this._id);
        this._name = set.getString("name");
        this._operateType = set.getEnum("operateType", SkillOpType.class);
        this._magic = set.getBool("isMagic", false);
        this._staticReuse = set.getBool("staticReuse", false);
        this._staticHitTime = set.getBool("staticHitTime", false);
        this._isPotion = set.getBool("isPotion", false);
        this._mpConsume = set.getInteger("mpConsume", 0);
        this._mpInitialConsume = set.getInteger("mpInitialConsume", 0);
        this._hpConsume = set.getInteger("hpConsume", 0);
        this._cpConsume = set.getInteger("cpConsume", 0);
        this._targetConsume = set.getInteger("targetConsumeCount", 0);
        this._targetConsumeId = set.getInteger("targetConsumeId", 0);
        this._itemConsume = set.getInteger("itemConsumeCount", 0);
        this._itemConsumeId = set.getInteger("itemConsumeId", 0);
        this._afterEffectId = set.getInteger("afterEffectId", 0);
        this._afterEffectLvl = set.getInteger("afterEffectLvl", 1);
        this._castRange = set.getInteger("castRange", -1);
        this._effectRange = set.getInteger("effectRange", -1);
        this._abnormalLvl = set.getInteger("abnormalLvl", -1);
        this._effectAbnormalLvl = set.getInteger("effectAbnormalLvl", -1);
        this._negateLvl = set.getInteger("negateLvl", -1);
        this._attribute = set.getString("attribute", "").intern();
        String str = set.getString("negateStats", "");
        if (str == "") {
            this._negateStats = new L2SkillType[0];
        } else {
            String[] stats = str.split(" ");
            L2SkillType[] array = new L2SkillType[stats.length];
            for (i = 0; i < stats.length; ++i) {
                L2SkillType type = null;
                try {
                    type = Enum.valueOf(L2SkillType.class, stats[i]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SkillId: " + this._id + "Enum value of type " + L2SkillType.class.getName() + "required, but found: " + stats[i]);
                }
                array[i] = type;
            }
            this._negateStats = array;
        }
        String negateId = set.getString("negateId", null);
        if (negateId != null) {
            String[] valuesSplit = negateId.split(",");
            this._negateId = new int[valuesSplit.length];
            for (i = 0; i < valuesSplit.length; ++i) {
                this._negateId[i] = Integer.parseInt(valuesSplit[i]);
            }
        } else {
            this._negateId = new int[0];
        }
        this._maxNegatedEffects = set.getInteger("maxNegated", 0);
        this._stayAfterDeath = set.getBool("stayAfterDeath", false);
        this._killByDOT = set.getBool("killByDOT", false);
        this._isNeutral = set.getBool("neutral", false);
        this._hitTime = set.getInteger("hitTime", 0);
        String hitTimings = set.getString("hitTimings", null);
        if (hitTimings != null) {
            try {
                String[] valuesSplit = hitTimings.split(",");
                this._hitTimings = new int[valuesSplit.length];
                for (int i2 = 0; i2 < valuesSplit.length; ++i2) {
                    this._hitTimings[i2] = Integer.parseInt(valuesSplit[i2]);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("SkillId: " + this._id + " invalid hitTimings value: " + hitTimings + ", \"percent,percent,...percent\" required");
            }
        } else {
            this._hitTimings = new int[0];
        }
        this._coolTime = set.getInteger("coolTime", 0);
        this._isDebuff = set.getBool("isDebuff", false);
        this._feed = set.getInteger("feed", 0);
        String reuseHash = set.getString("sharedReuse", null);
        if (reuseHash != null) {
            try {
                String[] valuesSplit = reuseHash.split("-");
                this._reuseHashCode = SkillTable.getSkillHashCode(Integer.parseInt(valuesSplit[0]), Integer.parseInt(valuesSplit[1]));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("SkillId: " + this._id + " invalid sharedReuse value: " + reuseHash + ", \"skillId-skillLvl\" required");
            }
        } else {
            this._reuseHashCode = SkillTable.getSkillHashCode(this._id, this._level);
        }
        if (Config.ENABLE_MODIFY_SKILL_REUSE && Config.SKILL_REUSE_LIST.containsKey(this._id)) {
            if (Config.DEBUG) {
                _log.info("*** Skill " + this._name + " (" + this._level + ") changed reuse from " + set.getInteger("reuseDelay", 0) + " to " + Config.SKILL_REUSE_LIST.get(this._id) + " seconds.");
            }
            this._reuseDelay = Config.SKILL_REUSE_LIST.get(this._id);
        } else {
            this._reuseDelay = set.getInteger("reuseDelay", 0);
        }
        this._buffDuration = set.getInteger("buffDuration", 0);
        this._equipDelay = set.getInteger("equipDelay", 0);
        this._skillRadius = set.getInteger("skillRadius", 80);
        this._targetType = set.getEnum("target", SkillTargetType.class);
        this._power = set.getFloat("power", 0.0f);
        this._pvpPower = set.getFloat("pvpPower", (float)this.getPower());
        this._magicLevel = set.getInteger("magicLvl", SkillTreeTable.getInstance().getMinSkillLevel(this._id, this._level));
        this._levelDepend = set.getInteger("lvlDepend", 0);
        this._ignoreResists = set.getBool("ignoreResists", false);
        this._minChance = set.getInteger("minChance", 1);
        this._maxChance = set.getInteger("maxChance", 99);
        this._stat = set.getEnum("stat", Stats.class, null);
        this._ignoreShield = set.getBool("ignoreShld", false);
        this._skillType = set.getEnum("skillType", L2SkillType.class);
        this._effectType = set.getEnum("effectType", L2SkillType.class, null);
        this._effectId = set.getInteger("effectId", 0);
        this._effectLvl = set.getInteger("effectLevel", 0);
        this._nextActionIsAttack = set.getBool("nextActionAttack", false);
        this._removedOnAnyActionExceptMove = set.getBool("removedOnAnyActionExceptMove", false);
        this._removedOnDamage = set.getBool("removedOnDamage", this._skillType == L2SkillType.SLEEP);
        this._element = set.getByte("element", (byte)-1);
        this._elementPower = set.getInteger("elementPower", 0);
        this._saveVs = set.getEnum("saveVs", BaseStats.class, null);
        this._condition = set.getInteger("condition", 0);
        this._conditionValue = set.getInteger("conditionValue", 0);
        this._overhit = set.getBool("overHit", false);
        this._isSuicideAttack = set.getBool("isSuicideAttack", false);
        String weaponsAllowedString = set.getString("weaponsAllowed", null);
        if (weaponsAllowedString != null && !weaponsAllowedString.trim().isEmpty()) {
            int mask = 0;
            StringTokenizer st = new StringTokenizer(weaponsAllowedString, ",");
            while (st.hasMoreTokens()) {
                int old = mask;
                String item = st.nextToken().trim();
                if (ItemTable._weaponTypes.containsKey(item)) {
                    mask |= ItemTable._weaponTypes.get(item).mask();
                }
                if (ItemTable._armorTypes.containsKey(item)) {
                    mask |= ItemTable._armorTypes.get(item).mask();
                }
                if (old != mask) continue;
                _log.info("[weaponsAllowed] Unknown item type name: " + item);
            }
            this._weaponsAllowed = mask;
        } else {
            this._weaponsAllowed = 0;
        }
        this._armorsAllowed = set.getInteger("armorsAllowed", 0);
        this._minPledgeClass = set.getInteger("minPledgeClass", 0);
        this._isOffensive = set.getBool("offensive", this.isSkillTypeOffensive());
        this._maxCharges = set.getInteger("maxCharges", 0);
        this._numCharges = set.getInteger("numCharges", 0);
        this._triggeredId = set.getInteger("triggeredId", 0);
        this._triggeredLevel = set.getInteger("triggeredLevel", 0);
        this._chanceType = set.getString("chanceType", "").intern();
        if (this._chanceType != "" && !this._chanceType.isEmpty()) {
            this._chanceCondition = ChanceCondition.parse(set);
        }
        this._numSouls = set.getInteger("num_souls", 0);
        this._soulMaxConsume = set.getInteger("soulMaxConsumeCount", 0);
        this._soulConsume = set.getInteger("soulConsumeCount", 0);
        this._expNeeded = set.getInteger("expNeeded", 0);
        this._critChance = set.getInteger("critChance", 0);
        this._transformId = set.getInteger("transformId", 0);
        this._transformDuration = set.getInteger("transformDuration", 0);
        this._isHeroSkill = HeroSkillTable.isHeroSkill(this._id);
        this._isGMSkill = GMSkillTable.isGMSkill(this._id);
        this._baseCritRate = set.getInteger("baseCritRate", this._skillType == L2SkillType.PDAM || this._skillType == L2SkillType.BLOW ? 0 : -1);
        this._lethalEffect1 = set.getInteger("lethal1", 0);
        this._lethalEffect2 = set.getInteger("lethal2", 0);
        this._directHpDmg = set.getBool("dmgDirectlyToHp", false);
        this._isDance = set.getBool("isDance", false);
        this._nextDanceCost = set.getInteger("nextDanceCost", 0);
        this._sSBoost = set.getFloat("SSBoost", 0.0f);
        this._aggroPoints = set.getInteger("aggroPoints", 0);
        this._flyType = this.intern(set.getString("flyType", null));
        this._flyRadius = set.getInteger("flyRadius", 0);
        this._flyCourse = set.getFloat("flyCourse", 0.0f);
        this._canBeReflected = set.getBool("canBeReflected", true);
        this._canBeDispeled = set.getBool("canBeDispeled", true);
        this._isClanSkill = set.getBool("isClanSkill", false);
        this._excludedFromCheck = set.getBool("excludedFromCheck", false);
        this._dependOnTargetBuff = set.getFloat("dependOnTargetBuff", 0.0f);
        this._simultaneousCast = set.getBool("simultaneousCast", false);
    }

    private String intern(String s) {
        return s == null ? null : s.intern();
    }

    public abstract void useSkill(L2Character var1, L2Object[] var2);

    public final boolean isPotion() {
        return this._isPotion;
    }

    public final int getArmorsAllowed() {
        return this._armorsAllowed;
    }

    public final int getConditionValue() {
        return this._conditionValue;
    }

    public final L2SkillType getSkillType() {
        return this._skillType;
    }

    public final byte getElement() {
        return this._element;
    }

    public final int getElementPower() {
        return this._elementPower;
    }

    public final SkillTargetType getTargetType() {
        return this._targetType;
    }

    public final int getCondition() {
        return this._condition;
    }

    public final boolean isOverhit() {
        return this._overhit;
    }

    public final boolean killByDOT() {
        return this._killByDOT;
    }

    public final boolean isSuicideAttack() {
        return this._isSuicideAttack;
    }

    public final boolean allowOnTransform() {
        return this.isPassive();
    }

    public final double getPower(L2Character activeChar, L2Character target, boolean isPvP) {
        if (activeChar == null) {
            return this.getPower(isPvP);
        }
        switch (this._skillType) {
            case DEATHLINK: {
                return this.getPower(isPvP) * Math.pow(1.7165 - activeChar.getCurrentHp() / (double)activeChar.getMaxHp(), 2.0) * 0.577;
            }
            case FATAL: {
                return this.getPower(isPvP) * 3.5 * (1.0 - target.getCurrentHp() / (double)target.getMaxHp());
            }
        }
        return this.getPower(isPvP);
    }

    public final double getPower() {
        return this._power;
    }

    public final double getPower(boolean isPvP) {
        return isPvP ? this._pvpPower : this._power;
    }

    public final L2SkillType[] getNegateStats() {
        return this._negateStats;
    }

    public final int getAbnormalLvl() {
        return this._abnormalLvl;
    }

    public final int getNegateLvl() {
        return this._negateLvl;
    }

    public final int[] getNegateId() {
        return this._negateId;
    }

    public final int getMagicLevel() {
        return this._magicLevel;
    }

    public final int getMaxNegatedEffects() {
        return this._maxNegatedEffects;
    }

    public final int getLevelDepend() {
        return this._levelDepend;
    }

    public final boolean ignoreResists() {
        return this._ignoreResists;
    }

    public final int getMinChance() {
        return this._minChance;
    }

    public final int getMaxChance() {
        return this._maxChance;
    }

    public final boolean isRemovedOnAnyActionExceptMove() {
        return this._removedOnAnyActionExceptMove;
    }

    public final boolean isRemovedOnDamage() {
        return this._removedOnDamage;
    }

    public final int getEffectId() {
        return this._effectId;
    }

    public final int getEffectLvl() {
        return this._effectLvl;
    }

    public final int getEffectAbnormalLvl() {
        return this._effectAbnormalLvl;
    }

    public final L2SkillType getEffectType() {
        return this._effectType;
    }

    public final boolean nextActionIsAttack() {
        return this._nextActionIsAttack;
    }

    public final int getBuffDuration() {
        return this._buffDuration;
    }

    public final int getCastRange() {
        return this._castRange;
    }

    public final int getCpConsume() {
        return this._cpConsume;
    }

    public final int getEffectRange() {
        return this._effectRange;
    }

    public final int getHpConsume() {
        return this._hpConsume;
    }

    public final int getId() {
        return this._id;
    }

    public final boolean isDebuff() {
        return this._isDebuff;
    }

    public int getDisplayId() {
        return this._displayId;
    }

    public void setDisplayId(int id) {
        this._displayId = id;
    }

    public int getTriggeredId() {
        return this._triggeredId;
    }

    public int getTriggeredLevel() {
        return this._triggeredLevel;
    }

    public boolean triggerAnotherSkill() {
        return this._triggeredId > 1;
    }

    public final Stats getStat() {
        return this._stat;
    }

    public final BaseStats getSaveVs() {
        return this._saveVs;
    }

    public final int getTargetConsumeId() {
        return this._targetConsumeId;
    }

    public final int getTargetConsume() {
        return this._targetConsume;
    }

    public final int getItemConsume() {
        return this._itemConsume;
    }

    public final int getItemConsumeId() {
        return this._itemConsumeId;
    }

    public final int getLevel() {
        return this._level;
    }

    public final boolean isMagic() {
        return this._magic;
    }

    public final boolean isStaticReuse() {
        return this._staticReuse;
    }

    public final boolean isStaticHitTime() {
        return this._staticHitTime;
    }

    public final int getMpConsume() {
        return this._mpConsume;
    }

    public final int getMpInitialConsume() {
        return this._mpInitialConsume;
    }

    public final String getName() {
        return this._name;
    }

    public final int getReuseDelay() {
        return this._reuseDelay;
    }

    public final int getReuseHashCode() {
        return this._reuseHashCode;
    }

    public final int getEquipDelay() {
        return this._equipDelay;
    }

    public final int getHitTime() {
        return this._hitTime;
    }

    public final int getHitCounts() {
        return this._hitTimings.length;
    }

    public final int[] getHitTimings() {
        return this._hitTimings;
    }

    public final int getCoolTime() {
        return this._coolTime;
    }

    public final int getSkillRadius() {
        return this._skillRadius;
    }

    public final boolean isActive() {
        return this._operateType == SkillOpType.OP_ACTIVE;
    }

    public final boolean isPassive() {
        return this._operateType == SkillOpType.OP_PASSIVE;
    }

    public final boolean isToggle() {
        return this._operateType == SkillOpType.OP_TOGGLE;
    }

    public final boolean isChance() {
        return this._chanceCondition != null && this.isPassive();
    }

    public final boolean isDance() {
        return this._isDance;
    }

    public final int getNextDanceMpCost() {
        return this._nextDanceCost;
    }

    public final float getSSBoost() {
        return this._sSBoost;
    }

    public final int getAggroPoints() {
        return this._aggroPoints;
    }

    public final boolean useSoulShot() {
        switch (this.getSkillType()) {
            case PDAM: 
            case CHARGEDAM: 
            case BLOW: {
                return true;
            }
        }
        return false;
    }

    public final boolean useSpiritShot() {
        return this.isMagic();
    }

    public final boolean useFishShot() {
        return this.getSkillType() == L2SkillType.PUMPING || this.getSkillType() == L2SkillType.REELING;
    }

    public final int getWeaponsAllowed() {
        return this._weaponsAllowed;
    }

    public int getMinPledgeClass() {
        return this._minPledgeClass;
    }

    public final boolean isPvpSkill() {
        switch (this._skillType) {
            case DOT: 
            case BLEED: 
            case CONFUSION: 
            case POISON: 
            case DEBUFF: 
            case AGGDEBUFF: 
            case STUN: 
            case ROOT: 
            case FEAR: 
            case SLEEP: 
            case MDOT: 
            case MUTE: 
            case WEAKNESS: 
            case PARALYZE: 
            case CANCEL: 
            case MAGE_BANE: 
            case WARRIOR_BANE: 
            case BETRAY: 
            case DISARM: 
            case AGGDAMAGE: 
            case STEAL_BUFF: 
            case AGGREDUCE_CHAR: 
            case MANADAM: {
                return true;
            }
        }
        return false;
    }

    public final boolean isOffensive() {
        return this._isOffensive;
    }

    public final boolean isNeutral() {
        return this._isNeutral;
    }

    public final boolean isHeroSkill() {
        return this._isHeroSkill;
    }

    public final boolean isGMSkill() {
        return this._isGMSkill;
    }

    public final int getNumCharges() {
        return this._numCharges;
    }

    public final int getNumSouls() {
        return this._numSouls;
    }

    public final int getMaxSoulConsumeCount() {
        return this._soulMaxConsume;
    }

    public final int getSoulConsumeCount() {
        return this._soulConsume;
    }

    public final int getExpNeeded() {
        return this._expNeeded;
    }

    public final int getCritChance() {
        return this._critChance;
    }

    public final int getTransformId() {
        return this._transformId;
    }

    public final int getTransformDuration() {
        return this._transformDuration;
    }

    public final int getBaseCritRate() {
        return this._baseCritRate;
    }

    public final int getLethalChance1() {
        return this._lethalEffect1;
    }

    public final int getLethalChance2() {
        return this._lethalEffect2;
    }

    public final boolean getDmgDirectlyToHP() {
        return this._directHpDmg;
    }

    public final String getFlyType() {
        return this._flyType;
    }

    public final int getFlyRadius() {
        return this._flyRadius;
    }

    public final float getFlyCourse() {
        return this._flyCourse;
    }

    public final boolean isSkillTypeOffensive() {
        switch (this._skillType) {
            case DEATHLINK: 
            case FATAL: 
            case PDAM: 
            case CHARGEDAM: 
            case BLOW: 
            case DOT: 
            case BLEED: 
            case CONFUSION: 
            case POISON: 
            case DEBUFF: 
            case AGGDEBUFF: 
            case STUN: 
            case ROOT: 
            case FEAR: 
            case SLEEP: 
            case MDOT: 
            case MUTE: 
            case WEAKNESS: 
            case PARALYZE: 
            case CANCEL: 
            case MAGE_BANE: 
            case WARRIOR_BANE: 
            case BETRAY: 
            case DISARM: 
            case AGGDAMAGE: 
            case STEAL_BUFF: 
            case AGGREDUCE_CHAR: 
            case MANADAM: 
            case MDAM: 
            case CPDAM: 
            case CPDAMPERCENT: 
            case ERASE: 
            case DRAIN: 
            case CONFUSE_MOB_ONLY: 
            case DETECT_WEAKNESS: 
            case SOULSHOT: 
            case SPIRITSHOT: 
            case SPOIL: 
            case MANA_BY_LEVEL: 
            case SWEEP: 
            case DRAIN_SOUL: 
            case AGGREDUCE: 
            case AGGREMOVE: 
            case DELUXE_KEY_UNLOCK: 
            case SOW: 
            case HARVEST: 
            case INSTANT_JUMP: {
                return true;
            }
        }
        return this.isDebuff();
    }

    public final boolean is7Signs() {
        return this._id > 4360 && this._id < 4367;
    }

    public final boolean isStayAfterDeath() {
        return this._stayAfterDeath;
    }

    public final boolean getWeaponDependancy(L2Character activeChar) {
        if (this.getWeaponDependancy(activeChar, false)) {
            return true;
        }
        SystemMessage message = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
        message.addSkillName(this);
        activeChar.sendPacket(message);
        return false;
    }

    public final boolean getWeaponDependancy(L2Character activeChar, boolean chance) {
        int weaponsAllowed = this.getWeaponsAllowed();
        if (weaponsAllowed == 0) {
            return true;
        }
        int mask = 0;
        if (activeChar.getActiveWeaponItem() != null) {
            mask |= activeChar.getActiveWeaponItem().getItemType().mask();
        }
        if (activeChar.getSecondaryWeaponItem() != null && activeChar.getSecondaryWeaponItem() instanceof L2Armor) {
            mask |= ((L2ArmorType)activeChar.getSecondaryWeaponItem().getItemType()).mask();
        }
        return (mask & weaponsAllowed) != 0;
    }

    public boolean checkCondition(L2Character activeChar, L2Object target, boolean itemOrWeapon) {
        if (activeChar.isGM() && !Config.GM_SKILL_RESTRICTION) {
            return true;
        }
        if ((this.getCondition() & 0x100) != 0) {
            // empty if block
        }
        List<Condition> preCondition = this._preCondition;
        if (itemOrWeapon) {
            preCondition = this._itemPreCondition;
        }
        if (preCondition == null || preCondition.isEmpty()) {
            return true;
        }
        for (Condition cond : preCondition) {
            Env env = new Env();
            env.player = activeChar;
            if (target instanceof L2Character) {
                env.target = (L2Character)target;
            }
            env.skill = this;
            if (cond.test(env)) continue;
            String msg = cond.getMessage();
            int msgId = cond.getMessageId();
            if (msgId != 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(msgId);
                if (cond.isAddName()) {
                    sm.addSkillName(this._id);
                }
                activeChar.sendPacket(sm);
            } else if (msg != null) {
                activeChar.sendMessage(msg);
            }
            return false;
        }
        return true;
    }

    public final L2Object[] getTargetList(L2Character activeChar, boolean onlyFirst) {
        L2Character target = null;
        L2Object objTarget = activeChar.getTarget();
        if (objTarget instanceof L2Character) {
            target = (L2Character)objTarget;
        }
        return this.getTargetList(activeChar, onlyFirst, target);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final L2Object[] getTargetList(L2Character activeChar, boolean onlyFirst, L2Character target) {
        FastList targetList = new FastList();
        SkillTargetType targetType = this.getTargetType();
        L2SkillType skillType = this.getSkillType();
        switch (targetType) {
            case TARGET_ONE: {
                boolean canTargetSelf = false;
                switch (skillType) {
                    case BUFF: 
                    case HEAL: 
                    case HOT: 
                    case HEAL_PERCENT: 
                    case MANARECHARGE: 
                    case MANAHEAL: 
                    case NEGATE: 
                    case CANCEL_DEBUFF: 
                    case REFLECT: 
                    case COMBATPOINTHEAL: 
                    case BALANCE_LIFE: 
                    case HPMPCPHEAL_PERCENT: 
                    case HPMPHEAL_PERCENT: 
                    case HPCPHEAL_PERCENT: {
                        canTargetSelf = true;
                    }
                }
                if (target != null && !target.isDead() && (target != activeChar || canTargetSelf)) return new L2Character[]{target};
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
                return _emptyTargetList;
            }
            case TARGET_SELF: 
            case TARGET_GROUND: {
                return new L2Character[]{activeChar};
            }
            case TARGET_HOLY: {
                if (!(activeChar instanceof L2PcInstance) || !(target instanceof L2ArtefactInstance)) return _emptyTargetList;
                return new L2Character[]{target};
            }
            case TARGET_FLAGPOLE: {
                return new L2Character[]{activeChar};
            }
            case TARGET_PET: {
                target = activeChar.getPet();
                if (target == null || target.isDead()) return _emptyTargetList;
                return new L2Character[]{target};
            }
            case TARGET_SUMMON: {
                target = activeChar.getPet();
                if (target == null || target.isDead() || !(target instanceof L2SummonInstance)) return _emptyTargetList;
                return new L2Character[]{target};
            }
            case TARGET_OWNER_PET: {
                if (!(activeChar instanceof L2Summon) || (target = ((L2Summon)activeChar).getOwner()) == null || target.isDead()) return _emptyTargetList;
                return new L2Character[]{target};
            }
            case TARGET_CORPSE_PET: {
                if (!(activeChar instanceof L2PcInstance) || (target = activeChar.getPet()) == null || !target.isDead()) return _emptyTargetList;
                return new L2Character[]{target};
            }
            case TARGET_FRONT_AURA: 
            case TARGET_BEHIND_AURA: 
            case TARGET_AURA: {
                boolean srcInArena = activeChar.isInsideZone((byte)0) && !activeChar.isInsideZone((byte)2);
                L2PcInstance sourcePlayer = activeChar.getActingPlayer();
                Collection<L2Character> objs = activeChar.getKnownList().getKnownCharactersInRadius(this.getSkillRadius());
                if (this.getSkillType() == L2SkillType.DUMMY) {
                    if (onlyFirst) {
                        return new L2Character[]{activeChar};
                    }
                    targetList.add(activeChar);
                    for (L2Character obj : objs) {
                        if (obj != activeChar && obj != sourcePlayer && !(obj instanceof L2Npc) && !(obj instanceof L2Attackable)) continue;
                        targetList.add(obj);
                    }
                    return targetList.toArray(new L2Character[targetList.size()]);
                } else {
                    block48: for (L2Character obj : objs) {
                        if (!(obj instanceof L2Attackable) && !(obj instanceof L2Playable)) continue;
                        switch (targetType) {
                            case TARGET_FRONT_AURA: {
                                if (obj.isInFrontOf(activeChar)) break;
                                continue block48;
                            }
                            case TARGET_BEHIND_AURA: {
                                if (obj.isBehind(activeChar)) break;
                                continue block48;
                            }
                        }
                        if (!L2Skill.checkForAreaOffensiveSkills(activeChar, obj, this, srcInArena)) continue;
                        if (onlyFirst) {
                            return new L2Character[]{obj};
                        }
                        targetList.add(obj);
                    }
                }
                return targetList.toArray(new L2Character[targetList.size()]);
            }
            case TARGET_AREA_SUMMON: {
                target = activeChar.getPet();
                if (target == null || !(target instanceof L2SummonInstance) || target.isDead()) {
                    return _emptyTargetList;
                }
                if (onlyFirst) {
                    return new L2Character[]{target};
                }
                boolean srcInArena = activeChar.isInsideZone((byte)0) && !activeChar.isInsideZone((byte)2);
                Collection<L2Character> objs = target.getKnownList().getKnownCharacters();
                int radius = this.getSkillRadius();
                for (L2Character obj : objs) {
                    if (obj == null || obj == target || obj == activeChar || !Util.checkIfInRange(radius, target, obj, true) || !(obj instanceof L2Attackable) && !(obj instanceof L2Playable) || !L2Skill.checkForAreaOffensiveSkills(activeChar, obj, this, srcInArena)) continue;
                    targetList.add(obj);
                }
                if (!targetList.isEmpty()) return targetList.toArray(new L2Character[targetList.size()]);
                return _emptyTargetList;
            }
            case TARGET_FRONT_AREA: 
            case TARGET_BEHIND_AREA: 
            case TARGET_AREA: {
                L2Character origin;
                if ((target == null || target == activeChar || target.isAlikeDead()) && this.getCastRange() >= 0 || !(target instanceof L2Attackable) && !(target instanceof L2Playable)) {
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
                    return _emptyTargetList;
                }
                boolean srcInArena = activeChar.isInsideZone((byte)0) && !activeChar.isInsideZone((byte)2);
                int radius = this.getSkillRadius();
                if (this.getCastRange() >= 0) {
                    if (!L2Skill.checkForAreaOffensiveSkills(activeChar, target, this, srcInArena)) {
                        return _emptyTargetList;
                    }
                    if (onlyFirst) {
                        return new L2Character[]{target};
                    }
                    origin = target;
                    targetList.add(origin);
                } else {
                    origin = activeChar;
                }
                Collection<L2Character> objs = activeChar.getKnownList().getKnownCharacters();
                block50: for (L2Character obj : objs) {
                    if (!(obj instanceof L2Attackable) && !(obj instanceof L2Playable) || obj == origin || !Util.checkIfInRange(radius, origin, obj, true)) continue;
                    switch (targetType) {
                        case TARGET_FRONT_AREA: {
                            if (obj.isInFrontOf(activeChar)) break;
                            continue block50;
                        }
                        case TARGET_BEHIND_AREA: {
                            if (obj.isBehind(activeChar)) break;
                            continue block50;
                        }
                    }
                    if (!L2Skill.checkForAreaOffensiveSkills(activeChar, obj, this, srcInArena)) continue;
                    targetList.add(obj);
                }
                if (!targetList.isEmpty()) return targetList.toArray(new L2Character[targetList.size()]);
                return _emptyTargetList;
            }
            case TARGET_PARTY: {
                if (onlyFirst) {
                    return new L2Character[]{activeChar};
                }
                targetList.add(activeChar);
                int radius = this.getSkillRadius();
                L2PcInstance player = activeChar.getActingPlayer();
                if (activeChar instanceof L2Summon) {
                    if (L2Skill.addCharacter(activeChar, player, radius, false)) {
                        targetList.add(player);
                    }
                } else if (activeChar instanceof L2PcInstance && L2Skill.addSummon(activeChar, player, radius, false)) {
                    targetList.add(player.getPet());
                }
                if (!activeChar.isInParty()) return targetList.toArray(new L2Character[targetList.size()]);
                for (L2PcInstance partyMember : activeChar.getParty().getPartyMembers()) {
                    if (partyMember == null || partyMember == player) continue;
                    if (L2Skill.addCharacter(activeChar, partyMember, radius, false)) {
                        targetList.add(partyMember);
                    }
                    if (!L2Skill.addSummon(activeChar, partyMember, radius, false)) continue;
                    targetList.add(partyMember.getPet());
                }
                return targetList.toArray(new L2Character[targetList.size()]);
            }
            case TARGET_PARTY_MEMBER: {
                if (target != null && target == activeChar || target != null && activeChar.isInParty() && target.isInParty() && activeChar.getParty().getPartyLeaderOID() == target.getParty().getPartyLeaderOID() || target != null && activeChar instanceof L2PcInstance && target instanceof L2Summon && activeChar.getPet() == target || target != null && activeChar instanceof L2Summon && target instanceof L2PcInstance && activeChar == target.getPet()) {
                    if (target.isDead()) return _emptyTargetList;
                    return new L2Character[]{target};
                }
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
                return _emptyTargetList;
            }
            case TARGET_PARTY_OTHER: {
                if (target != null && target != activeChar && activeChar.isInParty() && target.isInParty() && activeChar.getParty().getPartyLeaderOID() == target.getParty().getPartyLeaderOID()) {
                    if (target.isDead()) return _emptyTargetList;
                    if (!(target instanceof L2PcInstance)) return new L2Character[]{target};
                    switch (this.getId()) {
                        case 426: {
                            if (((L2PcInstance)target).isMageClass()) return _emptyTargetList;
                            return new L2Character[]{target};
                        }
                        case 427: {
                            if (!((L2PcInstance)target).isMageClass()) return _emptyTargetList;
                            return new L2Character[]{target};
                        }
                    }
                    return new L2Character[]{target};
                }
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
                return _emptyTargetList;
            }
            case TARGET_CORPSE_ALLY: 
            case TARGET_ALLY: {
                int radius;
                boolean isCorpseType;
                if (!(activeChar instanceof L2Playable)) return targetList.toArray(new L2Character[targetList.size()]);
                L2PcInstance player = activeChar.getActingPlayer();
                if (player == null) {
                    return _emptyTargetList;
                }
                if (player.isInOlympiadMode()) {
                    return new L2Character[]{player};
                }
                boolean bl = isCorpseType = targetType == SkillTargetType.TARGET_CORPSE_ALLY;
                if (!isCorpseType) {
                    if (onlyFirst) {
                        return new L2Character[]{player};
                    }
                    targetList.add(player);
                }
                if (L2Skill.addSummon(activeChar, player, radius = this.getSkillRadius(), isCorpseType)) {
                    targetList.add(player.getPet());
                }
                if (player.getClan() == null) return targetList.toArray(new L2Character[targetList.size()]);
                Collection<L2PcInstance> objs = activeChar.getKnownList().getKnownPlayersInRadius(radius);
                for (L2PcInstance obj : objs) {
                    if (obj == null || (obj.getAllyId() == 0 || obj.getAllyId() != player.getAllyId()) && (obj.getClan() == null || obj.getClanId() != player.getClanId()) || player.isInDuel() && (player.getDuelId() != obj.getDuelId() || player.isInParty() && obj.isInParty() && player.getParty().getPartyLeaderOID() != obj.getParty().getPartyLeaderOID()) || !player.checkPvpSkill(obj, this) || !TvTEvent.checkForTvTSkill(player, obj, this)) continue;
                    if (!onlyFirst && L2Skill.addSummon(activeChar, obj, radius, isCorpseType)) {
                        targetList.add(obj.getPet());
                    }
                    if (!L2Skill.addCharacter(activeChar, obj, radius, isCorpseType) || isCorpseType && this.getSkillType() == L2SkillType.RESURRECT && obj.isInsideZone((byte)2) && !obj.isInSiege()) continue;
                    if (onlyFirst) {
                        return new L2Character[]{obj};
                    }
                    targetList.add(obj);
                }
                return targetList.toArray(new L2Character[targetList.size()]);
            }
            case TARGET_CORPSE_CLAN: 
            case TARGET_CLAN: {
                if (activeChar instanceof L2Playable) {
                    boolean isCorpseType;
                    L2PcInstance player = activeChar.getActingPlayer();
                    if (player == null) {
                        return _emptyTargetList;
                    }
                    if (player.isInOlympiadMode()) {
                        return new L2Character[]{player};
                    }
                    boolean bl = isCorpseType = targetType == SkillTargetType.TARGET_CORPSE_CLAN;
                    if (!isCorpseType) {
                        if (onlyFirst) {
                            return new L2Character[]{player};
                        }
                        targetList.add(player);
                    }
                    int radius = this.getSkillRadius();
                    L2Clan clan = player.getClan();
                    if (L2Skill.addSummon(activeChar, player, radius, isCorpseType)) {
                        targetList.add(player.getPet());
                    }
                    if (clan == null) return targetList.toArray(new L2Character[targetList.size()]);
                    for (L2ClanMember member : clan.getMembers()) {
                        L2PcInstance obj = member.getPlayerInstance();
                        if (obj == null || obj == player || player.isInDuel() && (player.getDuelId() != obj.getDuelId() || player.isInParty() && obj.isInParty() && player.getParty().getPartyLeaderOID() != obj.getParty().getPartyLeaderOID()) || !player.checkPvpSkill(obj, this) || !TvTEvent.checkForTvTSkill(player, obj, this)) continue;
                        if (!onlyFirst && L2Skill.addSummon(activeChar, obj, radius, isCorpseType)) {
                            targetList.add(obj.getPet());
                        }
                        if (!L2Skill.addCharacter(activeChar, obj, radius, isCorpseType) || isCorpseType && this.getSkillType() == L2SkillType.RESURRECT && obj.isInsideZone((byte)2) && !obj.isInSiege()) continue;
                        if (onlyFirst) {
                            return new L2Character[]{obj};
                        }
                        targetList.add(obj);
                    }
                    return targetList.toArray(new L2Character[targetList.size()]);
                } else {
                    if (!(activeChar instanceof L2Npc)) return targetList.toArray(new L2Character[targetList.size()]);
                    L2Npc npc = (L2Npc)activeChar;
                    if (npc.getFactionId() == null || npc.getFactionId().isEmpty()) {
                        return new L2Character[]{activeChar};
                    }
                    targetList.add(activeChar);
                    Collection<L2Object> objs = activeChar.getKnownList().getKnownObjects().values();
                    for (L2Object newTarget : objs) {
                        if (!(newTarget instanceof L2Npc) || !npc.getFactionId().equals(((L2Npc)newTarget).getFactionId()) || !Util.checkIfInRange(this.getCastRange(), activeChar, newTarget, true)) continue;
                        targetList.add((L2Npc)newTarget);
                    }
                }
                return targetList.toArray(new L2Character[targetList.size()]);
            }
            case TARGET_PARTY_CLAN: {
                if (onlyFirst) {
                    return new L2Character[]{activeChar};
                }
                L2PcInstance player = activeChar.getActingPlayer();
                if (player == null) {
                    return _emptyTargetList;
                }
                targetList.add(player);
                int radius = this.getSkillRadius();
                boolean hasClan = player.getClan() != null;
                boolean hasParty = player.isInParty();
                if (L2Skill.addSummon(activeChar, player, radius, false)) {
                    targetList.add(player.getPet());
                }
                if (!hasClan && !hasParty) {
                    return targetList.toArray(new L2Character[targetList.size()]);
                }
                Collection<L2PcInstance> objs = activeChar.getKnownList().getKnownPlayersInRadius(radius);
                for (L2PcInstance obj : objs) {
                    if (obj == null || player.isInOlympiadMode() && (!obj.isInOlympiadMode() || player.getOlympiadGameId() != obj.getOlympiadGameId() || player.getOlympiadSide() != obj.getOlympiadSide()) || player.isInDuel() && (player.getDuelId() != obj.getDuelId() || hasParty && obj.isInParty() && player.getParty().getPartyLeaderOID() != obj.getParty().getPartyLeaderOID()) || (!hasClan || obj.getClanId() != player.getClanId()) && (!hasParty || !obj.isInParty() || player.getParty().getPartyLeaderOID() != obj.getParty().getPartyLeaderOID()) || !player.checkPvpSkill(obj, this) || !TvTEvent.checkForTvTSkill(player, obj, this)) continue;
                    if (!onlyFirst && L2Skill.addSummon(activeChar, obj, radius, false)) {
                        targetList.add(obj.getPet());
                    }
                    if (!L2Skill.addCharacter(activeChar, obj, radius, false)) continue;
                    if (onlyFirst) {
                        return new L2Character[]{obj};
                    }
                    targetList.add(obj);
                }
                return targetList.toArray(new L2Character[targetList.size()]);
            }
            case TARGET_CORPSE_PLAYER: {
                if (target != null && target.isDead()) {
                    L2PcInstance player = activeChar instanceof L2PcInstance ? (L2PcInstance)activeChar : null;
                    L2PcInstance targetPlayer = target instanceof L2PcInstance ? (L2PcInstance)target : null;
                    L2PetInstance targetPet = target instanceof L2PetInstance ? (L2PetInstance)target : null;
                    if (player != null && (targetPlayer != null || targetPet != null)) {
                        boolean condGood = true;
                        if (this.getSkillType() == L2SkillType.RESURRECT) {
                            if (targetPlayer != null) {
                                if (targetPlayer.isInsideZone((byte)2) && !targetPlayer.isInSiege()) {
                                    condGood = false;
                                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_BE_RESURRECTED_DURING_SIEGE));
                                }
                                if (targetPlayer.isFestivalParticipant()) {
                                    condGood = false;
                                    activeChar.sendMessage("You may not resurrect participants in a festival.");
                                }
                                if (targetPlayer.isReviveRequested()) {
                                    if (targetPlayer.isRevivingPet()) {
                                        player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.MASTER_CANNOT_RES));
                                    } else {
                                        player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.RES_HAS_ALREADY_BEEN_PROPOSED));
                                    }
                                    condGood = false;
                                }
                            } else if (targetPet != null && targetPet.getOwner() != player && targetPet.getOwner().isReviveRequested()) {
                                if (targetPet.getOwner().isRevivingPet()) {
                                    player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.RES_HAS_ALREADY_BEEN_PROPOSED));
                                } else {
                                    player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_RES_PET2));
                                }
                                condGood = false;
                            }
                        }
                        if (condGood) {
                            if (onlyFirst) return new L2Character[]{target};
                            targetList.add(target);
                            return targetList.toArray(new L2Object[targetList.size()]);
                        }
                    }
                }
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
                return _emptyTargetList;
            }
            case TARGET_CORPSE_MOB: {
                boolean isSummon = target instanceof L2SummonInstance;
                if (!isSummon && !(target instanceof L2Attackable) || !target.isDead()) {
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
                    return _emptyTargetList;
                }
                switch (this.getSkillType()) {
                    case SUMMON: {
                        if (isSummon && ((L2SummonInstance)target).getOwner() != null && ((L2SummonInstance)target).getOwner().getObjectId() == activeChar.getObjectId()) {
                            return _emptyTargetList;
                        }
                    }
                    case DRAIN: {
                        if (!DecayTaskManager.getInstance().getTasks().containsKey(target) || System.currentTimeMillis() - DecayTaskManager.getInstance().getTasks().get(target) <= 4250L) break;
                        activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CORPSE_TOO_OLD_SKILL_NOT_USED));
                        return _emptyTargetList;
                    }
                }
                if (onlyFirst) return new L2Character[]{target};
                targetList.add(target);
                return targetList.toArray(new L2Object[targetList.size()]);
            }
            case TARGET_AREA_CORPSE_MOB: {
                if (!(target instanceof L2Attackable) || !target.isDead()) {
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
                    return _emptyTargetList;
                }
                if (onlyFirst) {
                    return new L2Character[]{target};
                }
                targetList.add(target);
                boolean srcInArena = activeChar.isInsideZone((byte)0) && !activeChar.isInsideZone((byte)2);
                int radius = this.getSkillRadius();
                Collection<L2Character> objs = activeChar.getKnownList().getKnownCharacters();
                for (L2Character obj : objs) {
                    if (!(obj instanceof L2Attackable) && !(obj instanceof L2Playable) || !Util.checkIfInRange(radius, target, obj, true) || !L2Skill.checkForAreaOffensiveSkills(activeChar, obj, this, srcInArena)) continue;
                    targetList.add(obj);
                }
                if (!targetList.isEmpty()) return targetList.toArray(new L2Character[targetList.size()]);
                return _emptyTargetList;
            }
            case TARGET_UNLOCKABLE: {
                if (!(target instanceof L2DoorInstance) && !(target instanceof L2ChestInstance)) {
                    return _emptyTargetList;
                }
                if (onlyFirst) return new L2Character[]{target};
                targetList.add(target);
                return targetList.toArray(new L2Object[targetList.size()]);
            }
            case TARGET_UNDEAD: {
                if (target instanceof L2Npc || target instanceof L2SummonInstance) {
                    if (!target.isUndead() || target.isDead()) {
                        activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
                        return _emptyTargetList;
                    }
                    if (onlyFirst) {
                        return new L2Character[]{target};
                    }
                    targetList.add(target);
                    return targetList.toArray(new L2Object[targetList.size()]);
                }
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
                return _emptyTargetList;
            }
            case TARGET_AREA_UNDEAD: {
                L2Character cha;
                int radius = this.getSkillRadius();
                if (this.getCastRange() >= 0 && (target instanceof L2Npc || target instanceof L2SummonInstance) && target.isUndead() && !target.isAlikeDead()) {
                    cha = target;
                    if (onlyFirst) return new L2Character[]{cha};
                    targetList.add(cha);
                } else {
                    cha = activeChar;
                }
                Collection<L2Character> objs = activeChar.getKnownList().getKnownCharacters();
                for (L2Character obj : objs) {
                    if (!Util.checkIfInRange(radius, cha, obj, true)) continue;
                    if (obj instanceof L2Npc) {
                        target = obj;
                    } else {
                        if (!(obj instanceof L2SummonInstance)) continue;
                        target = obj;
                    }
                    if (target.isAlikeDead() || !target.isUndead() || geoEnabled && !GeoData.getInstance().canSeeTarget((L2Object)activeChar, target)) continue;
                    if (onlyFirst) return new L2Character[]{obj};
                    targetList.add(obj);
                }
                if (!targetList.isEmpty()) return targetList.toArray(new L2Character[targetList.size()]);
                return _emptyTargetList;
            }
            case TARGET_ENEMY_SUMMON: {
                if (!(target instanceof L2Summon)) return _emptyTargetList;
                L2Summon targetSummon = (L2Summon)target;
                if ((!(activeChar instanceof L2PcInstance) || activeChar.getPet() == targetSummon || targetSummon.isDead() || targetSummon.getOwner().getPvpFlag() == 0 && targetSummon.getOwner().getKarma() <= 0) && (!targetSummon.getOwner().isInsideZone((byte)0) || !((L2PcInstance)activeChar).isInsideZone((byte)0)) && (!targetSummon.getOwner().isInDuel() || !((L2PcInstance)activeChar).isInDuel() || targetSummon.getOwner().getDuelId() != ((L2PcInstance)activeChar).getDuelId())) return _emptyTargetList;
                return new L2Character[]{targetSummon};
            }
            case TARGET_PARTY_NOTME: {
                if (onlyFirst) {
                    return new L2Character[]{activeChar};
                }
                L2PcInstance player = null;
                if (activeChar instanceof L2Summon) {
                    player = ((L2Summon)activeChar).getOwner();
                    targetList.add(player);
                } else if (activeChar instanceof L2PcInstance) {
                    player = (L2PcInstance)activeChar;
                    if (activeChar.getPet() != null) {
                        targetList.add(activeChar.getPet());
                    }
                }
                if (activeChar.getParty() == null) return targetList.toArray(new L2Character[targetList.size()]);
                FastList<L2PcInstance> partyList = activeChar.getParty().getPartyMembers();
                for (L2PcInstance partyMember : partyList) {
                    if (partyMember == null || partyMember == player || partyMember.isDead() || !Util.checkIfInRange(this.getSkillRadius(), activeChar, partyMember, true)) continue;
                    targetList.add(partyMember);
                    if (partyMember.getPet() == null || partyMember.getPet().isDead()) continue;
                    targetList.add(partyMember.getPet());
                }
                return targetList.toArray(new L2Character[targetList.size()]);
            }
            case TARGET_CLAN_MEMBER: {
                if (!(activeChar instanceof L2Npc)) return _emptyTargetList;
                L2Npc npc = (L2Npc)activeChar;
                if (npc.getFactionId() == null || npc.getFactionId().isEmpty()) {
                    return new L2Character[]{activeChar};
                }
                Collection<L2Object> objs = activeChar.getKnownList().getKnownObjects().values();
                for (L2Object newTarget : objs) {
                    if (!(newTarget instanceof L2Npc) || !npc.getFactionId().equals(((L2Npc)newTarget).getFactionId()) || !Util.checkIfInRange(this.getCastRange(), activeChar, newTarget, true) || ((L2Npc)newTarget).getFirstEffect(this) != null) continue;
                    targetList.add((L2Npc)newTarget);
                    break;
                }
                if (!targetList.isEmpty()) return targetList.toArray(new L2Character[targetList.size()]);
                targetList.add(npc);
                return targetList.toArray(new L2Character[targetList.size()]);
            }
        }
        activeChar.sendMessage("Target type of skill is not currently handled");
        return _emptyTargetList;
    }

    public final L2Object[] getTargetList(L2Character activeChar) {
        return this.getTargetList(activeChar, false);
    }

    public final L2Object getFirstOfTargetList(L2Character activeChar) {
        L2Object[] targets = this.getTargetList(activeChar, true);
        if (targets.length == 0) {
            return null;
        }
        return targets[0];
    }

    public static final boolean checkForAreaOffensiveSkills(L2Character caster, L2Character target, L2Skill skill, boolean sourceInArena) {
        if (target == null || target.isDead() || target == caster) {
            return false;
        }
        L2PcInstance player = caster.getActingPlayer();
        L2PcInstance targetPlayer = target.getActingPlayer();
        if (player != null) {
            if (targetPlayer != null) {
                if (targetPlayer == caster || targetPlayer == player) {
                    return false;
                }
                if (targetPlayer.inObserverMode()) {
                    return false;
                }
                if (skill.isOffensive() && player.getSiegeState() > 0 && player.isInsideZone((byte)2) && player.getSiegeState() == targetPlayer.getSiegeState() && player.getSiegeSide() == targetPlayer.getSiegeSide()) {
                    return false;
                }
                if (target.isInsideZone((byte)1)) {
                    return false;
                }
                if (player.isInParty() && targetPlayer.isInParty()) {
                    if (player.getParty().getPartyLeaderOID() == targetPlayer.getParty().getPartyLeaderOID()) {
                        return false;
                    }
                    if (player.getParty().getCommandChannel() != null && player.getParty().getCommandChannel() == targetPlayer.getParty().getCommandChannel()) {
                        return false;
                    }
                }
                if (!TvTEvent.checkForTvTSkill(player, targetPlayer, skill)) {
                    return false;
                }
                if (!(sourceInArena || targetPlayer.isInsideZone((byte)0) && !targetPlayer.isInsideZone((byte)2))) {
                    if (player.getAllyId() != 0 && player.getAllyId() == targetPlayer.getAllyId()) {
                        return false;
                    }
                    if (player.getClanId() != 0 && player.getClanId() == targetPlayer.getClanId()) {
                        return false;
                    }
                    if (!player.checkPvpSkill(targetPlayer, skill, caster instanceof L2Summon)) {
                        return false;
                    }
                }
            }
        } else if (caster instanceof L2Attackable && targetPlayer == null && target instanceof L2Attackable) {
            String casterEnemyClan = ((L2Attackable)caster).getEnemyClan();
            if (casterEnemyClan == null || casterEnemyClan.isEmpty()) {
                return false;
            }
            String targetClan = ((L2Attackable)target).getClan();
            if (targetClan == null || targetClan.isEmpty()) {
                return false;
            }
            if (!casterEnemyClan.equals(targetClan)) {
                return false;
            }
        }
        return !geoEnabled || GeoData.getInstance().canSeeTarget((L2Object)caster, target);
    }

    public static final boolean addSummon(L2Character caster, L2PcInstance owner, int radius, boolean isDead) {
        L2Summon summon = owner.getPet();
        if (summon == null) {
            return false;
        }
        return L2Skill.addCharacter(caster, summon, radius, isDead);
    }

    public static final boolean addCharacter(L2Character caster, L2Character target, int radius, boolean isDead) {
        if (isDead != target.isDead()) {
            return false;
        }
        return radius <= 0 || Util.checkIfInRange(radius, caster, target, true);
    }

    public final Func[] getStatFuncs(L2Effect effect, L2Character player) {
        if (this._funcTemplates == null) {
            return _emptyFunctionSet;
        }
        if (!(player instanceof L2Playable) && !(player instanceof L2Attackable)) {
            return _emptyFunctionSet;
        }
        ArrayList<Func> funcs = new ArrayList<Func>(this._funcTemplates.length);
        Env env = new Env();
        env.player = player;
        env.skill = this;
        for (FuncTemplate t : this._funcTemplates) {
            Func f = t.getFunc(env, this);
            if (f == null) continue;
            funcs.add(f);
        }
        if (funcs.isEmpty()) {
            return _emptyFunctionSet;
        }
        return funcs.toArray(new Func[funcs.size()]);
    }

    public boolean hasEffects() {
        return this._effectTemplates != null && this._effectTemplates.length > 0;
    }

    public EffectTemplate[] getEffectTemplates() {
        return this._effectTemplates;
    }

    public boolean hasSelfEffects() {
        return this._effectTemplatesSelf != null && this._effectTemplatesSelf.length > 0;
    }

    public final L2Effect[] getEffects(L2Character effector, L2Character effected, Env env) {
        if (!this.hasEffects() || this.isPassive()) {
            return _emptyEffectSet;
        }
        if (effected instanceof L2DoorInstance || effected instanceof L2SiegeFlagInstance) {
            return _emptyEffectSet;
        }
        if (effector != effected && (this.isOffensive() || this.isDebuff())) {
            if (effected.isInvul()) {
                return _emptyEffectSet;
            }
            if (effector instanceof L2PcInstance && ((L2PcInstance)effector).isGM() && !((L2PcInstance)effector).getAccessLevel().canGiveDamage()) {
                return _emptyEffectSet;
            }
        }
        ArrayList<L2Effect> effects = new ArrayList<L2Effect>(this._effectTemplates.length);
        if (env == null) {
            env = new Env();
        }
        env.skillMastery = Formulas.calcSkillMastery(effector, this);
        env.player = effector;
        env.target = effected;
        env.skill = this;
        for (EffectTemplate et : this._effectTemplates) {
            boolean success = true;
            if (et.effectPower > -1.0) {
                success = Formulas.calcEffectSuccess(effector, effected, et, this, env.shld, env.ss, env.sps, env.bss);
            }
            if (success) {
                L2Effect e = et.getEffect(env);
                if (e == null) continue;
                e.scheduleEffect();
                effects.add(e);
                continue;
            }
            if (!et.icon || !(effector instanceof L2PcInstance)) continue;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
            sm.addCharName(effected);
            sm.addSkillName(this);
            ((L2PcInstance)effector).sendPacket(sm);
        }
        if (effects.isEmpty()) {
            return _emptyEffectSet;
        }
        return effects.toArray(new L2Effect[effects.size()]);
    }

    public final L2Effect[] getEffects(L2Character effector, L2Character effected) {
        return this.getEffects(effector, effected, null);
    }

    public final L2Effect[] getEffects(L2CubicInstance effector, L2Character effected, Env env) {
        if (!this.hasEffects() || this.isPassive()) {
            return _emptyEffectSet;
        }
        if (effector.getOwner() != effected && (this.isDebuff() || this.isOffensive())) {
            if (effected.isInvul()) {
                return _emptyEffectSet;
            }
            if (effector.getOwner().isGM() && !effector.getOwner().getAccessLevel().canGiveDamage()) {
                return _emptyEffectSet;
            }
        }
        ArrayList<L2Effect> effects = new ArrayList<L2Effect>(this._effectTemplates.length);
        if (env == null) {
            env = new Env();
        }
        env.player = effector.getOwner();
        env.cubic = effector;
        env.target = effected;
        env.skill = this;
        for (EffectTemplate et : this._effectTemplates) {
            L2Effect e;
            boolean success = true;
            if (et.effectPower > -1.0) {
                success = Formulas.calcEffectSuccess(effector.getOwner(), effected, et, this, env.shld, env.ss, env.sps, env.bss);
            }
            if (!success || (e = et.getEffect(env)) == null) continue;
            e.scheduleEffect();
            effects.add(e);
        }
        if (effects.isEmpty()) {
            return _emptyEffectSet;
        }
        return effects.toArray(new L2Effect[effects.size()]);
    }

    public final L2Effect[] getEffectsSelf(L2Character effector) {
        if (!this.hasSelfEffects() || this.isPassive()) {
            return _emptyEffectSet;
        }
        ArrayList<L2Effect> effects = new ArrayList<L2Effect>(this._effectTemplatesSelf.length);
        for (EffectTemplate et : this._effectTemplatesSelf) {
            Env env = new Env();
            env.player = effector;
            env.target = effector;
            env.skill = this;
            L2Effect e = et.getEffect(env);
            if (e == null) continue;
            e.setSelfEffect();
            e.scheduleEffect();
            effects.add(e);
        }
        if (effects.isEmpty()) {
            return _emptyEffectSet;
        }
        return effects.toArray(new L2Effect[effects.size()]);
    }

    public final void attach(FuncTemplate f) {
        if (this._funcTemplates == null) {
            this._funcTemplates = new FuncTemplate[]{f};
        } else {
            int len = this._funcTemplates.length;
            FuncTemplate[] tmp = new FuncTemplate[len + 1];
            System.arraycopy(this._funcTemplates, 0, tmp, 0, len);
            tmp[len] = f;
            this._funcTemplates = tmp;
        }
    }

    public final void attach(EffectTemplate effect) {
        if (this._effectTemplates == null) {
            this._effectTemplates = new EffectTemplate[]{effect};
        } else {
            int len = this._effectTemplates.length;
            EffectTemplate[] tmp = new EffectTemplate[len + 1];
            System.arraycopy(this._effectTemplates, 0, tmp, 0, len);
            tmp[len] = effect;
            this._effectTemplates = tmp;
        }
    }

    public final void attachSelf(EffectTemplate effect) {
        if (this._effectTemplatesSelf == null) {
            this._effectTemplatesSelf = new EffectTemplate[]{effect};
        } else {
            int len = this._effectTemplatesSelf.length;
            EffectTemplate[] tmp = new EffectTemplate[len + 1];
            System.arraycopy(this._effectTemplatesSelf, 0, tmp, 0, len);
            tmp[len] = effect;
            this._effectTemplatesSelf = tmp;
        }
    }

    public final void attach(Condition c, boolean itemOrWeapon) {
        if (itemOrWeapon) {
            if (this._itemPreCondition == null) {
                this._itemPreCondition = new FastList();
            }
            this._itemPreCondition.add(c);
        } else {
            if (this._preCondition == null) {
                this._preCondition = new FastList();
            }
            this._preCondition.add(c);
        }
    }

    public String toString() {
        return "" + this._name + "[id=" + this._id + ",lvl=" + this._level + "]";
    }

    public int getFeed() {
        return this._feed;
    }

    public int getReferenceItemId() {
        return this._refId;
    }

    public final int getMaxCharges() {
        return this._maxCharges;
    }

    public int getAfterEffectId() {
        return this._afterEffectId;
    }

    public int getAfterEffectLvl() {
        return this._afterEffectLvl;
    }

    @Override
    public boolean triggersChanceSkill() {
        return this._triggeredId > 0 && this.isChance();
    }

    @Override
    public int getTriggeredChanceId() {
        return this._triggeredId;
    }

    @Override
    public int getTriggeredChanceLevel() {
        return this._triggeredLevel;
    }

    @Override
    public ChanceCondition getTriggeredChanceCondition() {
        return this._chanceCondition;
    }

    public String getAttributeName() {
        return this._attribute;
    }

    public boolean ignoreShield() {
        return this._ignoreShield;
    }

    public boolean canBeReflected() {
        return this._canBeReflected;
    }

    public boolean canBeDispeled() {
        return this._canBeDispeled;
    }

    public boolean isClanSkill() {
        return this._isClanSkill;
    }

    public boolean isExcludedFromCheck() {
        return this._excludedFromCheck;
    }

    public float getDependOnTargetBuff() {
        return this._dependOnTargetBuff;
    }

    public boolean isSimultaneousCast() {
        return this._simultaneousCast;
    }

    public static enum SkillTargetType {
        TARGET_NONE,
        TARGET_SELF,
        TARGET_ONE,
        TARGET_PARTY,
        TARGET_ALLY,
        TARGET_CLAN,
        TARGET_PET,
        TARGET_SUMMON,
        TARGET_AREA,
        TARGET_FRONT_AREA,
        TARGET_BEHIND_AREA,
        TARGET_AURA,
        TARGET_FRONT_AURA,
        TARGET_BEHIND_AURA,
        TARGET_CORPSE,
        TARGET_UNDEAD,
        TARGET_AREA_UNDEAD,
        TARGET_CORPSE_ALLY,
        TARGET_CORPSE_CLAN,
        TARGET_CORPSE_PLAYER,
        TARGET_CORPSE_PET,
        TARGET_AREA_CORPSE_MOB,
        TARGET_CORPSE_MOB,
        TARGET_UNLOCKABLE,
        TARGET_HOLY,
        TARGET_FLAGPOLE,
        TARGET_PARTY_MEMBER,
        TARGET_PARTY_OTHER,
        TARGET_PARTY_CLAN,
        TARGET_ENEMY_SUMMON,
        TARGET_OWNER_PET,
        TARGET_GROUND,
        TARGET_PARTY_NOTME,
        TARGET_AREA_SUMMON,
        TARGET_CLAN_MEMBER;

    }

    public static enum SkillOpType {
        OP_PASSIVE,
        OP_ACTIVE,
        OP_TOGGLE;

    }
}

