/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListDelete;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestWithdrawalPledge
extends L2GameClientPacket {
    private static final String _C__26_REQUESTWITHDRAWALPLEDGE = "[C] 26 RequestWithdrawalPledge";

    @Override
    protected void readImpl() {
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.getClan() == null) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_ARE_NOT_A_CLAN_MEMBER));
            return;
        }
        if (activeChar.isClanLeader()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CLAN_LEADER_CANNOT_WITHDRAW));
            return;
        }
        if (activeChar.isInCombat()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_CANNOT_LEAVE_DURING_COMBAT));
            return;
        }
        L2Clan clan = activeChar.getClan();
        clan.removeClanMember(activeChar.getObjectId(), System.currentTimeMillis() + (long)Config.ALT_CLAN_JOIN_DAYS * 86400000L);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_WITHDRAWN_FROM_THE_CLAN);
        sm.addString(activeChar.getName());
        clan.broadcastToOnlineMembers(sm);
        sm = null;
        clan.broadcastToOnlineMembers(new PledgeShowMemberListDelete(activeChar.getName()));
        activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_WITHDRAWN_FROM_CLAN));
        activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_MUST_WAIT_BEFORE_JOINING_ANOTHER_CLAN));
    }

    @Override
    public String getType() {
        return _C__26_REQUESTWITHDRAWALPLEDGE;
    }
}

