/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.async;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.ThreadPerTaskAsynchronousRunner;
import com.mchange.v2.io.IndentedWriter;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.util.ResourceClosedException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public final class ThreadPoolAsynchronousRunner
implements AsynchronousRunner {
    static final MLogger logger = MLog.getLogger(ThreadPoolAsynchronousRunner.class);
    static final int POLL_FOR_STOP_INTERVAL = 5000;
    static final int DFLT_DEADLOCK_DETECTOR_INTERVAL = 10000;
    static final int DFLT_INTERRUPT_DELAY_AFTER_APPARENT_DEADLOCK = 60000;
    static final int DFLT_MAX_INDIVIDUAL_TASK_TIME = 0;
    static final int DFLT_MAX_EMERGENCY_THREADS = 10;
    int deadlock_detector_interval;
    int interrupt_delay_after_apparent_deadlock;
    int max_individual_task_time;
    int num_threads;
    boolean daemon;
    HashSet managed;
    HashSet available;
    LinkedList pendingTasks;
    Timer myTimer;
    boolean should_cancel_timer;
    TimerTask deadlockDetector = new DeadlockDetector();
    TimerTask replacedThreadInterruptor = null;
    Map stoppedThreadsToStopDates = new HashMap();
    String threadLabel;

    private ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, int max_individual_task_time, int deadlock_detector_interval, int interrupt_delay_after_apparent_deadlock, Timer myTimer, boolean should_cancel_timer, String threadLabel) {
        this.num_threads = num_threads;
        this.daemon = daemon;
        this.max_individual_task_time = max_individual_task_time;
        this.deadlock_detector_interval = deadlock_detector_interval;
        this.interrupt_delay_after_apparent_deadlock = interrupt_delay_after_apparent_deadlock;
        this.myTimer = myTimer;
        this.should_cancel_timer = should_cancel_timer;
        this.threadLabel = threadLabel;
        this.recreateThreadsAndTasks();
        myTimer.schedule(this.deadlockDetector, deadlock_detector_interval, (long)deadlock_detector_interval);
    }

    private ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, int max_individual_task_time, int deadlock_detector_interval, int interrupt_delay_after_apparent_deadlock, Timer myTimer, boolean should_cancel_timer) {
        this(num_threads, daemon, max_individual_task_time, deadlock_detector_interval, interrupt_delay_after_apparent_deadlock, myTimer, should_cancel_timer, null);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, int max_individual_task_time, int deadlock_detector_interval, int interrupt_delay_after_apparent_deadlock, Timer myTimer, String threadLabel) {
        this(num_threads, daemon, max_individual_task_time, deadlock_detector_interval, interrupt_delay_after_apparent_deadlock, myTimer, false, threadLabel);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, int max_individual_task_time, int deadlock_detector_interval, int interrupt_delay_after_apparent_deadlock, Timer myTimer) {
        this(num_threads, daemon, max_individual_task_time, deadlock_detector_interval, interrupt_delay_after_apparent_deadlock, myTimer, false);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, int max_individual_task_time, int deadlock_detector_interval, int interrupt_delay_after_apparent_deadlock, String threadLabel) {
        this(num_threads, daemon, max_individual_task_time, deadlock_detector_interval, interrupt_delay_after_apparent_deadlock, new Timer(true), true, threadLabel);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, int max_individual_task_time, int deadlock_detector_interval, int interrupt_delay_after_apparent_deadlock) {
        this(num_threads, daemon, max_individual_task_time, deadlock_detector_interval, interrupt_delay_after_apparent_deadlock, new Timer(true), true);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, Timer sharedTimer, String threadLabel) {
        this(num_threads, daemon, 0, 10000, 60000, sharedTimer, false, threadLabel);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon, Timer sharedTimer) {
        this(num_threads, daemon, 0, 10000, 60000, sharedTimer, false);
    }

    public ThreadPoolAsynchronousRunner(int num_threads, boolean daemon) {
        this(num_threads, daemon, 0, 10000, 60000, new Timer(true), true);
    }

    public synchronized void postRunnable(Runnable r) {
        try {
            this.pendingTasks.add(r);
            this.notifyAll();
            if (logger.isLoggable(MLevel.FINEST)) {
                logger.log(MLevel.FINEST, this + ": Adding task to queue -- " + r);
            }
        }
        catch (NullPointerException e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "NullPointerException while posting Runnable -- Probably we're closed.", e);
            }
            throw new ResourceClosedException("Attempted to use a ThreadPoolAsynchronousRunner in a closed or broken state.");
        }
    }

    public synchronized int getThreadCount() {
        return this.managed.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean skip_remaining_tasks) {
        ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = this;
        synchronized (threadPoolAsynchronousRunner) {
            if (this.managed == null) {
                return;
            }
            this.deadlockDetector.cancel();
            if (this.should_cancel_timer) {
                this.myTimer.cancel();
            }
            this.myTimer = null;
            Iterator ii = this.managed.iterator();
            while (ii.hasNext()) {
                PoolThread stopMe = (PoolThread)ii.next();
                stopMe.gentleStop();
                if (!skip_remaining_tasks) continue;
                stopMe.interrupt();
            }
            this.managed = null;
            if (!skip_remaining_tasks) {
                ii = this.pendingTasks.iterator();
                while (ii.hasNext()) {
                    Runnable r = (Runnable)ii.next();
                    new Thread(r).start();
                    ii.remove();
                }
            }
            this.available = null;
            this.pendingTasks = null;
        }
    }

    public void close() {
        this.close(true);
    }

    public synchronized int getActiveCount() {
        return this.managed.size() - this.available.size();
    }

    public synchronized int getIdleCount() {
        return this.available.size();
    }

    public synchronized int getPendingTaskCount() {
        return this.pendingTasks.size();
    }

    public synchronized String getStatus() {
        return this.getMultiLineStatusString();
    }

    public synchronized String getStackTraces() {
        return this.getStackTraces(0);
    }

    private String getStackTraces(int initial_indent) {
        if (this.managed == null) {
            return null;
        }
        try {
            Method m = Thread.class.getMethod("getStackTrace", null);
            StringWriter sw = new StringWriter(2048);
            IndentedWriter iw = new IndentedWriter(sw);
            for (int i = 0; i < initial_indent; ++i) {
                iw.upIndent();
            }
            Iterator ii = this.managed.iterator();
            while (ii.hasNext()) {
                Object poolThread = ii.next();
                Object[] stackTraces = (Object[])m.invoke(poolThread, null);
                iw.println(poolThread);
                iw.upIndent();
                int len = stackTraces.length;
                for (int i = 0; i < len; ++i) {
                    iw.println(stackTraces[i]);
                }
                iw.downIndent();
            }
            for (int i = 0; i < initial_indent; ++i) {
                iw.downIndent();
            }
            iw.flush();
            String out = sw.toString();
            iw.close();
            return out;
        }
        catch (NoSuchMethodException e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine(this + ": strack traces unavailable because this is a pre-Java 1.5 VM.");
            }
            return null;
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, this + ": An Exception occurred while trying to extract PoolThread stack traces.", e);
            }
            return null;
        }
    }

    public synchronized String getMultiLineStatusString() {
        return this.getMultiLineStatusString(0);
    }

    private String getMultiLineStatusString(int initial_indent) {
        try {
            int i;
            StringWriter sw = new StringWriter(2048);
            IndentedWriter iw = new IndentedWriter(sw);
            for (i = 0; i < initial_indent; ++i) {
                iw.upIndent();
            }
            if (this.managed == null) {
                iw.print("[");
                iw.print(this);
                iw.println(" closed.]");
            } else {
                HashSet active = (HashSet)this.managed.clone();
                active.removeAll(this.available);
                iw.print("Managed Threads: ");
                iw.println(this.managed.size());
                iw.print("Active Threads: ");
                iw.println(active.size());
                iw.println("Active Tasks: ");
                iw.upIndent();
                Iterator ii = active.iterator();
                while (ii.hasNext()) {
                    PoolThread pt = (PoolThread)ii.next();
                    iw.print(pt.getCurrentTask());
                    iw.print(" (");
                    iw.print(pt.getName());
                    iw.println(')');
                }
                iw.downIndent();
                iw.println("Pending Tasks: ");
                iw.upIndent();
                int len = this.pendingTasks.size();
                for (int i2 = 0; i2 < len; ++i2) {
                    iw.println(this.pendingTasks.get(i2));
                }
                iw.downIndent();
            }
            for (i = 0; i < initial_indent; ++i) {
                iw.downIndent();
            }
            iw.flush();
            String out = sw.toString();
            iw.close();
            return out;
        }
        catch (IOException e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Huh? An IOException when working with a StringWriter?!?", e);
            }
            throw new RuntimeException("Huh? An IOException when working with a StringWriter?!? " + e);
        }
    }

    private void appendStatusString(StringBuffer sb) {
        if (this.managed == null) {
            sb.append("[closed]");
        } else {
            HashSet active = (HashSet)this.managed.clone();
            active.removeAll(this.available);
            sb.append("[num_managed_threads: ");
            sb.append(this.managed.size());
            sb.append(", num_active: ");
            sb.append(active.size());
            sb.append("; activeTasks: ");
            boolean first = true;
            Iterator ii = active.iterator();
            while (ii.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                PoolThread pt = (PoolThread)ii.next();
                sb.append(pt.getCurrentTask());
                sb.append(" (");
                sb.append(pt.getName());
                sb.append(')');
            }
            sb.append("; pendingTasks: ");
            int len = this.pendingTasks.size();
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.pendingTasks.get(i));
            }
            sb.append(']');
        }
    }

    private void recreateThreadsAndTasks() {
        if (this.managed != null) {
            Date aboutNow = new Date();
            Iterator ii = this.managed.iterator();
            while (ii.hasNext()) {
                PoolThread pt = (PoolThread)ii.next();
                pt.gentleStop();
                this.stoppedThreadsToStopDates.put(pt, aboutNow);
                this.ensureReplacedThreadsProcessing();
            }
        }
        this.managed = new HashSet();
        this.available = new HashSet();
        this.pendingTasks = new LinkedList();
        for (int i = 0; i < this.num_threads; ++i) {
            PoolThread t = new PoolThread(i, this.daemon);
            this.managed.add(t);
            this.available.add(t);
            t.start();
        }
    }

    private void processReplacedThreads() {
        long about_now = System.currentTimeMillis();
        Iterator ii = this.stoppedThreadsToStopDates.keySet().iterator();
        while (ii.hasNext()) {
            PoolThread pt = (PoolThread)ii.next();
            if (!pt.isAlive()) {
                ii.remove();
            } else {
                Date d = (Date)this.stoppedThreadsToStopDates.get(pt);
                if (about_now - d.getTime() > (long)this.interrupt_delay_after_apparent_deadlock) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, "Task " + pt.getCurrentTask() + " (in deadlocked PoolThread) failed to complete in maximum time " + this.interrupt_delay_after_apparent_deadlock + "ms. Trying interrupt().");
                    }
                    pt.interrupt();
                    ii.remove();
                }
            }
            if (!this.stoppedThreadsToStopDates.isEmpty()) continue;
            this.stopReplacedThreadsProcessing();
        }
    }

    private void ensureReplacedThreadsProcessing() {
        if (this.replacedThreadInterruptor == null) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("Apparently some threads have been replaced. Replacement thread processing enabled.");
            }
            this.replacedThreadInterruptor = new ReplacedThreadInterruptor();
            int replacedThreadProcessDelay = this.interrupt_delay_after_apparent_deadlock / 4;
            this.myTimer.schedule(this.replacedThreadInterruptor, replacedThreadProcessDelay, (long)replacedThreadProcessDelay);
        }
    }

    private void stopReplacedThreadsProcessing() {
        if (this.replacedThreadInterruptor != null) {
            this.replacedThreadInterruptor.cancel();
            this.replacedThreadInterruptor = null;
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("Apparently all replaced threads have either completed their tasks or been interrupted(). Replacement thread processing cancelled.");
            }
        }
    }

    private void shuttingDown(PoolThread pt) {
        if (this.managed != null && this.managed.contains(pt)) {
            this.managed.remove(pt);
            this.available.remove(pt);
            PoolThread replacement = new PoolThread(pt.getIndex(), this.daemon);
            this.managed.add(replacement);
            this.available.add(replacement);
            replacement.start();
        }
    }

    private void runInEmergencyThread(Runnable r) {
        Thread t = new Thread(r);
        t.start();
        if (this.max_individual_task_time > 0) {
            MaxIndividualTaskTimeEnforcer maxIndividualTaskTimeEnforcer = new MaxIndividualTaskTimeEnforcer(t, t + " [One-off emergency thread!!!]", r.toString());
            this.myTimer.schedule((TimerTask)maxIndividualTaskTimeEnforcer, this.max_individual_task_time);
        }
    }

    class ReplacedThreadInterruptor
    extends TimerTask {
        ReplacedThreadInterruptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
            synchronized (threadPoolAsynchronousRunner) {
                ThreadPoolAsynchronousRunner.this.processReplacedThreads();
            }
        }
    }

    class MaxIndividualTaskTimeEnforcer
    extends TimerTask {
        PoolThread pt;
        Thread interruptMe;
        String threadStr;
        String fixedTaskStr;

        MaxIndividualTaskTimeEnforcer(PoolThread pt) {
            this.pt = pt;
            this.interruptMe = pt;
            this.threadStr = pt.toString();
            this.fixedTaskStr = null;
        }

        MaxIndividualTaskTimeEnforcer(Thread interruptMe, String threadStr, String fixedTaskStr) {
            this.pt = null;
            this.interruptMe = interruptMe;
            this.threadStr = threadStr;
            this.fixedTaskStr = fixedTaskStr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String taskStr;
            if (this.fixedTaskStr != null) {
                taskStr = this.fixedTaskStr;
            } else if (this.pt != null) {
                ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
                synchronized (threadPoolAsynchronousRunner) {
                    taskStr = String.valueOf(this.pt.getCurrentTask());
                }
            } else {
                taskStr = "Unknown task?!";
            }
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("A task has exceeded the maximum allowable task time. Will interrupt() thread [" + this.threadStr + "], with current task: " + taskStr);
            }
            this.interruptMe.interrupt();
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("Thread [" + this.threadStr + "] interrupted.");
            }
        }
    }

    class DeadlockDetector
    extends TimerTask {
        LinkedList last = null;
        LinkedList current = null;

        DeadlockDetector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean run_stray_tasks = false;
            ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
            synchronized (threadPoolAsynchronousRunner) {
                if (ThreadPoolAsynchronousRunner.this.pendingTasks.size() == 0) {
                    this.last = null;
                    return;
                }
                this.current = (LinkedList)ThreadPoolAsynchronousRunner.this.pendingTasks.clone();
                if (this.current.equals(this.last)) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.warning(this + " -- APPARENT DEADLOCK!!! Creating emergency threads for unassigned pending tasks!");
                        StringWriter sw = new StringWriter(4096);
                        PrintWriter pw = new PrintWriter(sw);
                        pw.print(this);
                        pw.println(" -- APPARENT DEADLOCK!!! Complete Status: ");
                        pw.print(ThreadPoolAsynchronousRunner.this.getMultiLineStatusString(1));
                        pw.println("Pool thread stack traces:");
                        String stackTraces = ThreadPoolAsynchronousRunner.this.getStackTraces(1);
                        if (stackTraces == null) {
                            pw.println("\t[Stack traces of deadlocked task threads not available.]");
                        } else {
                            pw.println(stackTraces);
                        }
                        pw.flush();
                        logger.warning(sw.toString());
                        pw.close();
                    }
                    ThreadPoolAsynchronousRunner.this.recreateThreadsAndTasks();
                    run_stray_tasks = true;
                }
            }
            if (run_stray_tasks) {
                ThreadPerTaskAsynchronousRunner ar = new ThreadPerTaskAsynchronousRunner(10, ThreadPoolAsynchronousRunner.this.max_individual_task_time);
                Iterator ii = this.current.iterator();
                while (ii.hasNext()) {
                    ar.postRunnable((Runnable)ii.next());
                }
                ar.close(false);
                this.last = null;
            } else {
                this.last = this.current;
            }
            this.current = null;
        }
    }

    class PoolThread
    extends Thread {
        Runnable currentTask;
        boolean should_stop;
        int index;
        TimerTask maxIndividualTaskTimeEnforcer = null;

        PoolThread(int index, boolean daemon) {
            this.setName((ThreadPoolAsynchronousRunner.this.threadLabel == null ? this.getClass().getName() : ThreadPoolAsynchronousRunner.this.threadLabel) + "-#" + index);
            this.setDaemon(daemon);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        void gentleStop() {
            this.should_stop = true;
        }

        Runnable getCurrentTask() {
            return this.currentTask;
        }

        private void setMaxIndividualTaskTimeEnforcer() {
            this.maxIndividualTaskTimeEnforcer = new MaxIndividualTaskTimeEnforcer(this);
            ThreadPoolAsynchronousRunner.this.myTimer.schedule(this.maxIndividualTaskTimeEnforcer, ThreadPoolAsynchronousRunner.this.max_individual_task_time);
        }

        private void cancelMaxIndividualTaskTimeEnforcer() {
            this.maxIndividualTaskTimeEnforcer.cancel();
            this.maxIndividualTaskTimeEnforcer = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            while (true) {
                try {
                    Object myTask;
                    ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
                    synchronized (threadPoolAsynchronousRunner) {
                        while (!this.should_stop && ThreadPoolAsynchronousRunner.this.pendingTasks.size() == 0) {
                            ThreadPoolAsynchronousRunner.this.wait(5000L);
                        }
                        if (this.should_stop) {
                            return;
                        }
                        if (!ThreadPoolAsynchronousRunner.this.available.remove(this)) {
                            throw new InternalError("An unavailable PoolThread tried to check itself out!!!");
                        }
                        this.currentTask = myTask = (Runnable)ThreadPoolAsynchronousRunner.this.pendingTasks.remove(0);
                    }
                    try {
                        if (ThreadPoolAsynchronousRunner.this.max_individual_task_time > 0) {
                            this.setMaxIndividualTaskTimeEnforcer();
                        }
                        myTask.run();
                    }
                    catch (RuntimeException e) {
                        if (!logger.isLoggable(MLevel.WARNING)) continue;
                        logger.log(MLevel.WARNING, this + " -- caught unexpected Exception while executing posted task.", e);
                    }
                    finally {
                        if (this.maxIndividualTaskTimeEnforcer != null) {
                            this.cancelMaxIndividualTaskTimeEnforcer();
                        }
                        threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
                        synchronized (threadPoolAsynchronousRunner) {
                            if (this.should_stop) {
                                return;
                            }
                            if (ThreadPoolAsynchronousRunner.this.available != null && !ThreadPoolAsynchronousRunner.this.available.add(this)) {
                                throw new InternalError("An apparently available PoolThread tried to check itself in!!!");
                            }
                            this.currentTask = null;
                        }
                    }
                }
                catch (InterruptedException exc2) {
                    ThreadPoolAsynchronousRunner exc2 = ThreadPoolAsynchronousRunner.this;
                    synchronized (exc2) {
                        ThreadPoolAsynchronousRunner.this.shuttingDown(this);
                        return;
                    }
                }
                catch (RuntimeException re) {
                    if (!logger.isLoggable(MLevel.WARNING)) throw re;
                    logger.log(MLevel.WARNING, "An unexpected RuntimException is implicated in the closing of " + this, re);
                    throw re;
                }
                catch (Error err) {
                    if (!logger.isLoggable(MLevel.WARNING)) throw err;
                    logger.log(MLevel.WARNING, "An Error forced the closing of " + this + ". Will attempt to reconstruct, but this might mean that something bad is happening.", err);
                    throw err;
                }
            }
            finally {
                ThreadPoolAsynchronousRunner threadPoolAsynchronousRunner = ThreadPoolAsynchronousRunner.this;
                synchronized (threadPoolAsynchronousRunner) {
                    ThreadPoolAsynchronousRunner.this.shuttingDown(this);
                }
            }
        }
    }
}

