/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.instancemanager.DayNightSpawnManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.instance.L2RaidBossInstance;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class RaidBossSpawnManager {
    private static Logger _log = Logger.getLogger(RaidBossSpawnManager.class.getName());
    protected static Map<Integer, L2RaidBossInstance> _bosses;
    protected static Map<Integer, L2Spawn> _spawns;
    protected static Map<Integer, StatsSet> _storedInfo;
    protected static Map<Integer, ScheduledFuture<?>> _schedules;

    private RaidBossSpawnManager() {
        this.init();
    }

    public static RaidBossSpawnManager getInstance() {
        return SingletonHolder._instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        _bosses = new FastMap();
        _schedules = new FastMap();
        _storedInfo = new FastMap();
        _spawns = new FastMap();
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT * FROM raidboss_spawnlist ORDER BY boss_id");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template = this.getValidTemplate(rset.getInt("boss_id"));
                if (template != null) {
                    L2Spawn spawnDat = new L2Spawn(template);
                    spawnDat.setLocx(rset.getInt("loc_x"));
                    spawnDat.setLocy(rset.getInt("loc_y"));
                    spawnDat.setLocz(rset.getInt("loc_z"));
                    spawnDat.setAmount(rset.getInt("amount"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnMinDelay(rset.getInt("respawn_min_delay"));
                    spawnDat.setRespawnMaxDelay(rset.getInt("respawn_max_delay"));
                    long respawnTime = rset.getLong("respawn_time");
                    this.addNewSpawn(spawnDat, respawnTime, rset.getDouble("currentHP"), rset.getDouble("currentMP"), false);
                    continue;
                }
                _log.warning("RaidBossSpawnManager: Could not load raidboss #" + rset.getInt("boss_id") + " from DB");
            }
            _log.info("RaidBossSpawnManager: Loaded " + _bosses.size() + " Instances");
            _log.info("RaidBossSpawnManager: Scheduled " + _schedules.size() + " Instances");
            rset.close();
            statement.close();
        }
        catch (SQLException e) {
            _log.warning("RaidBossSpawnManager: Couldnt load raidboss_spawnlist table");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while initializing RaidBossSpawnManager: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void updateStatus(L2RaidBossInstance boss) {
        StatsSet info = _storedInfo.get(boss.getNpcId());
        if (info == null) {
            return;
        }
        boss.setRaidStatus(StatusEnum.DEAD);
        int RespawnMinDelay = boss.getSpawn().getRespawnMinDelay();
        int RespawnMaxDelay = boss.getSpawn().getRespawnMaxDelay();
        long respawn_delay = Rnd.get((int)((float)(RespawnMinDelay * 1000) * Config.RAID_MIN_RESPAWN_MULTIPLIER), (int)((float)(RespawnMaxDelay * 1000) * Config.RAID_MAX_RESPAWN_MULTIPLIER));
        long respawnTime = Calendar.getInstance().getTimeInMillis() + respawn_delay;
        info.set("currentHP", boss.getMaxHp());
        info.set("currentMP", boss.getMaxMp());
        info.set("respawnTime", respawnTime);
        String time = Util.dateFormat(respawnTime);
        Broadcast.announceToOnlinePlayers(boss.getName() + " \u304c\u6b7b\u4ea1\u3057\u307e\u3057\u305f\u3002\u6b21\u306e\u51fa\u73fe\u306f " + time + " \u3054\u308d\u3067\u3059\u3002");
        _log.info("RaidBossSpawnManager: Updated " + boss.getName() + " respawn time to " + time);
        if (!_schedules.containsKey(boss.getNpcId())) {
            ScheduledFuture<?> futureSpawn = ThreadPoolManager.getInstance().scheduleGeneral(new spawnSchedule(boss.getNpcId()), respawn_delay);
            _schedules.put(boss.getNpcId(), futureSpawn);
            this.updateDb(boss.getNpcId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewSpawn(L2Spawn spawnDat, long respawnTime, double currentHP, double currentMP, boolean storeInDb) {
        if (spawnDat == null) {
            return;
        }
        if (_spawns.containsKey(spawnDat.getNpcid())) {
            return;
        }
        int bossId = spawnDat.getNpcid();
        long time = Calendar.getInstance().getTimeInMillis();
        SpawnTable.getInstance().addNewSpawn(spawnDat, false);
        if (respawnTime == 0L || time > respawnTime) {
            L2RaidBossInstance raidboss = null;
            raidboss = bossId == 25328 ? DayNightSpawnManager.getInstance().handleBoss(spawnDat) : (L2RaidBossInstance)spawnDat.doSpawn();
            if (raidboss != null) {
                raidboss.setCurrentHp(currentHP);
                raidboss.setCurrentMp(currentMP);
                raidboss.setRaidStatus(StatusEnum.ALIVE);
                _bosses.put(bossId, raidboss);
                StatsSet info = new StatsSet();
                info.set("currentHP", currentHP);
                info.set("currentMP", currentMP);
                info.set("respawnTime", 0L);
                _storedInfo.put(bossId, info);
            }
        } else {
            long spawnTime = respawnTime - Calendar.getInstance().getTimeInMillis();
            ScheduledFuture<?> futureSpawn = ThreadPoolManager.getInstance().scheduleGeneral(new spawnSchedule(bossId), spawnTime);
            _schedules.put(bossId, futureSpawn);
        }
        _spawns.put(bossId, spawnDat);
        if (storeInDb) {
            Connection con = null;
            PreparedStatement statement = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement("INSERT INTO raidboss_spawnlist (boss_id,amount,loc_x,loc_y,loc_z,heading,respawn_time,currentHp,currentMp) VALUES(?,?,?,?,?,?,?,?,?)");
                statement.setInt(1, spawnDat.getNpcid());
                statement.setInt(2, spawnDat.getAmount());
                statement.setInt(3, spawnDat.getLocx());
                statement.setInt(4, spawnDat.getLocy());
                statement.setInt(5, spawnDat.getLocz());
                statement.setInt(6, spawnDat.getHeading());
                statement.setLong(7, respawnTime);
                statement.setDouble(8, currentHP);
                statement.setDouble(9, currentMP);
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "RaidBossSpawnManager: Could not store raidboss #" + bossId + " in the DB:" + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSpawn(L2Spawn spawnDat, boolean updateDb) {
        if (spawnDat == null) {
            return;
        }
        if (!_spawns.containsKey(spawnDat.getNpcid())) {
            return;
        }
        int bossId = spawnDat.getNpcid();
        SpawnTable.getInstance().deleteSpawn(spawnDat, false);
        _spawns.remove(bossId);
        if (_bosses.containsKey(bossId)) {
            _bosses.remove(bossId);
        }
        if (_schedules.containsKey(bossId)) {
            ScheduledFuture<?> f = _schedules.get(bossId);
            f.cancel(true);
            _schedules.remove(bossId);
        }
        if (_storedInfo.containsKey(bossId)) {
            _storedInfo.remove(bossId);
        }
        if (updateDb) {
            Connection con = null;
            PreparedStatement statement = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement("DELETE FROM raidboss_spawnlist WHERE boss_id=?");
                statement.setInt(1, bossId);
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "RaidBossSpawnManager: Could not remove raidboss #" + bossId + " from DB: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
    }

    private void updateDb(int bossId) {
        ArrayList<Integer> e = new ArrayList<Integer>(1);
        e.add(bossId);
        this.updateDb(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDb(Collection<Integer> bossIdList) {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("UPDATE raidboss_spawnlist SET respawn_time = ?, currentHP = ?, currentMP = ? WHERE boss_id = ?");
            for (Integer bossId : bossIdList) {
                StatsSet info;
                L2RaidBossInstance boss;
                if (bossId == null || (boss = _bosses.get(bossId)) == null || (info = _storedInfo.get(bossId)) == null) continue;
                if (boss.getRaidStatus() == StatusEnum.ALIVE) {
                    info.set("currentHP", boss.getCurrentHp());
                    info.set("currentMP", boss.getCurrentMp());
                    info.set("respawnTime", 0L);
                }
                try {
                    statement.setLong(1, info.getLong("respawnTime"));
                    statement.setDouble(2, info.getDouble("currentHP"));
                    statement.setDouble(3, info.getDouble("currentMP"));
                    statement.setInt(4, bossId);
                    statement.executeUpdate();
                    statement.clearParameters();
                }
                catch (SQLException e) {
                    _log.log(Level.WARNING, "RaidBossSpawnManager: Couldnt update raidboss_spawnlist table " + e.getMessage(), e);
                }
            }
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "SQL error while updating RaidBoss spawn to database: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public String[] getAllRaidBossStatus() {
        String[] msg = new String[_bosses == null ? 0 : _bosses.size()];
        if (_bosses == null) {
            msg[0] = "None";
            return msg;
        }
        int index = 0;
        for (int i : _bosses.keySet()) {
            L2RaidBossInstance boss = _bosses.get(i);
            msg[index++] = boss.getName() + ": " + boss.getRaidStatus().name();
        }
        return msg;
    }

    public String getRaidBossStatus(int bossId) {
        String msg = "RaidBoss Status....\n";
        if (_bosses == null) {
            msg = msg + "None";
            return msg;
        }
        if (_bosses.containsKey(bossId)) {
            L2RaidBossInstance boss = _bosses.get(bossId);
            msg = msg + boss.getName() + ": " + boss.getRaidStatus().name();
        }
        return msg;
    }

    public StatusEnum getRaidBossStatusId(int bossId) {
        if (_bosses.containsKey(bossId)) {
            return _bosses.get(bossId).getRaidStatus();
        }
        if (_schedules.containsKey(bossId)) {
            return StatusEnum.DEAD;
        }
        return StatusEnum.UNDEFINED;
    }

    public L2NpcTemplate getValidTemplate(int bossId) {
        L2NpcTemplate template = NpcTable.getInstance().getTemplate(bossId);
        if (template == null) {
            return null;
        }
        if (!template.type.equalsIgnoreCase("L2RaidBoss")) {
            return null;
        }
        return template;
    }

    public void notifySpawnNightBoss(L2RaidBossInstance raidboss) {
        StatsSet info = new StatsSet();
        info.set("currentHP", raidboss.getCurrentHp());
        info.set("currentMP", raidboss.getCurrentMp());
        info.set("respawnTime", 0L);
        raidboss.setRaidStatus(StatusEnum.ALIVE);
        _storedInfo.put(raidboss.getNpcId(), info);
        _log.info("Spawning Night Raid Boss " + raidboss.getName());
        _bosses.put(raidboss.getNpcId(), raidboss);
    }

    public boolean isDefined(int bossId) {
        return _spawns.containsKey(bossId);
    }

    public Map<Integer, L2RaidBossInstance> getBosses() {
        return _bosses;
    }

    public Map<Integer, L2Spawn> getSpawns() {
        return _spawns;
    }

    public void reloadBosses() {
        this.init();
    }

    public void cleanUp() {
        if (_schedules != null) {
            for (ScheduledFuture<?> f : _schedules.values()) {
                if (f == null) continue;
                f.cancel(true);
            }
        }
        this.updateDb(_storedInfo.keySet());
        _bosses.clear();
        _schedules.clear();
        _storedInfo.clear();
        _spawns.clear();
    }

    private static class SingletonHolder {
        protected static final RaidBossSpawnManager _instance = new RaidBossSpawnManager();

        private SingletonHolder() {
        }
    }

    private static class spawnSchedule
    implements Runnable {
        private final int bossId;

        public spawnSchedule(int npcId) {
            this.bossId = npcId;
        }

        @Override
        public void run() {
            L2RaidBossInstance raidboss = null;
            raidboss = this.bossId == 25328 ? DayNightSpawnManager.getInstance().handleBoss(_spawns.get(this.bossId)) : (L2RaidBossInstance)_spawns.get(this.bossId).doSpawn();
            if (raidboss != null) {
                raidboss.setRaidStatus(StatusEnum.ALIVE);
                StatsSet info = new StatsSet();
                info.set("currentHP", raidboss.getCurrentHp());
                info.set("currentMP", raidboss.getCurrentMp());
                info.set("respawnTime", 0L);
                _storedInfo.put(this.bossId, info);
                _log.info(raidboss.getName() + " \u304c\u51fa\u73fe\u3057\u307e\u3057\u305f\u3002");
                _bosses.put(this.bossId, raidboss);
            }
            _schedules.remove(this.bossId);
        }
    }

    public static enum StatusEnum {
        ALIVE,
        DEAD,
        UNDEFINED;

    }
}

