/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;

public class L2XmassTreeInstance
extends L2Npc {
    public static final int SPECIAL_TREE_ID = 13007;
    static final int[][] _buffs = new int[][]{{4262, 2}, {4263, 1}, {4264, 1}, {4265, 3}, {4266, 3}};
    protected ScheduledFuture<?> _aiTask;

    public L2XmassTreeInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2XmassTreeInstance);
        if (template.npcId == 13007 && !this.isInsideZone((byte)1)) {
            this._aiTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new XmassAI(this), 3000L, 3000L);
        }
    }

    @Override
    public void deleteMe() {
        if (this._aiTask != null) {
            this._aiTask.cancel(true);
        }
        this._aiTask = null;
        super.deleteMe();
    }

    @Override
    public int getDistanceToWatchObject(L2Object object) {
        return 900;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    protected class XmassAI
    implements Runnable {
        private L2XmassTreeInstance _caster;
        private int _buffIndex = 0;

        protected XmassAI(L2XmassTreeInstance caster) {
            this._caster = caster;
        }

        @Override
        public void run() {
            Collection<L2PcInstance> plrs = L2XmassTreeInstance.this.getKnownList().getKnownPlayersInRadius(L2XmassTreeInstance.this.getDistanceToWatchObject(null));
            for (L2PcInstance player : plrs) {
                if (player.isMovementDisabled() || player.getPkKills() > 5) continue;
                boolean done = false;
                if (player.getCurrentMp() < (double)(player.getMaxMp() * 8 / 10)) {
                    player.setCurrentMp(player.getCurrentMp() + (double)(player.getMaxMp() / player.getLevel()));
                    done = true;
                }
                if (player.getCurrentHp() < (double)(player.getMaxHp() * 8 / 10)) {
                    player.setCurrentHp(player.getCurrentHp() + (double)(player.getMaxHp() / player.getLevel()));
                    done = true;
                }
                if (done || player.isInvul()) continue;
                this._buffIndex %= _buffs.length;
                int[] b = _buffs[this._buffIndex++];
                this.handleCast(player, b[0], b[1]);
            }
        }

        protected boolean handleCast(L2PcInstance player, int skillId, int skillLevel) {
            L2Skill skill = SkillTable.getInstance().getInfo(skillId, skillLevel);
            if (player.getFirstEffect(skill) == null) {
                L2XmassTreeInstance.this.setTarget(player);
                L2XmassTreeInstance.this.doCast(skill);
                MagicSkillUse msu = new MagicSkillUse(this._caster, player, skillId, skillLevel, skill.getHitTime(), 0);
                L2XmassTreeInstance.this.broadcastPacket(msu);
                return true;
            }
            return false;
        }
    }
}

