/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.olympiad.AbstractOlympiadGame;
import com.l2jserver.gameserver.model.olympiad.CompetitionType;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.StatsSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javolution.util.FastList;
import javolution.util.FastMap;

public class OlympiadManager {
    private List<Integer> _nonClassBasedRegisters = new FastList().shared();
    private Map<Integer, List<Integer>> _classBasedRegisters = new FastMap().shared();
    private List<List<Integer>> _teamsBasedRegisters = new FastList().shared();

    private OlympiadManager() {
    }

    public static final OlympiadManager getInstance() {
        return SingletonHolder._instance;
    }

    public final List<Integer> getRegisteredNonClassBased() {
        return this._nonClassBasedRegisters;
    }

    public final Map<Integer, List<Integer>> getRegisteredClassBased() {
        return this._classBasedRegisters;
    }

    public final List<List<Integer>> getRegisteredTeamsBased() {
        return this._teamsBasedRegisters;
    }

    protected final List<List<Integer>> hasEnoughRegisteredClassed() {
        FastList result = null;
        for (Map.Entry<Integer, List<Integer>> classList : this._classBasedRegisters.entrySet()) {
            if (classList.getValue() == null || classList.getValue().size() < Config.ALT_OLY_CLASSED) continue;
            if (result == null) {
                result = new FastList();
            }
            result.add(classList.getValue());
        }
        return result;
    }

    protected final boolean hasEnoughRegisteredNonClassed() {
        return this._nonClassBasedRegisters.size() >= Config.ALT_OLY_NONCLASSED;
    }

    protected final boolean hasEnoughRegisteredTeams() {
        return this._teamsBasedRegisters.size() >= Config.ALT_OLY_TEAMS;
    }

    protected final void clearRegistered() {
        this._nonClassBasedRegisters.clear();
        this._classBasedRegisters.clear();
        this._teamsBasedRegisters.clear();
        AntiFeedManager.getInstance().clear(1);
    }

    public final boolean isRegistered(L2PcInstance noble) {
        return this.isRegistered(noble, noble, false);
    }

    private final boolean isRegistered(L2PcInstance noble, L2PcInstance player, boolean showMessage) {
        Integer objId = noble.getObjectId();
        for (List<Integer> team : this._teamsBasedRegisters) {
            if (team == null || !team.contains(objId)) continue;
            if (showMessage) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_NON_CLASS_LIMITED_EVENT_TEAMS);
                sm.addPcName(noble);
                player.sendPacket(sm);
            }
            return true;
        }
        if (this._nonClassBasedRegisters.contains(objId)) {
            if (showMessage) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_ON_THE_NON_CLASS_LIMITED_MATCH_WAITING_LIST);
                sm.addPcName(noble);
                player.sendPacket(sm);
            }
            return true;
        }
        List<Integer> classed = this._classBasedRegisters.get(noble.getBaseClass());
        if (classed != null && classed.contains(objId)) {
            if (showMessage) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_ON_THE_CLASS_MATCH_WAITING_LIST);
                sm.addPcName(noble);
                player.sendPacket(sm);
            }
            return true;
        }
        return false;
    }

    public final boolean isRegisteredInComp(L2PcInstance noble) {
        return this.isRegistered(noble, noble, false) || this.isInCompetition(noble, noble, false);
    }

    private final boolean isInCompetition(L2PcInstance noble, L2PcInstance player, boolean showMessage) {
        if (!Olympiad._inCompPeriod) {
            return false;
        }
        int i = OlympiadGameManager.getInstance().getNumberOfStadiums();
        while (--i >= 0) {
            AbstractOlympiadGame game = OlympiadGameManager.getInstance().getOlympiadTask(i).getGame();
            if (game == null || !game.containsParticipant(noble.getObjectId())) continue;
            if (!showMessage) {
                return true;
            }
            switch (game.getType()) {
                case CLASSED: {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_ON_THE_CLASS_MATCH_WAITING_LIST);
                    sm.addPcName(noble);
                    player.sendPacket(sm);
                    break;
                }
                case NON_CLASSED: {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_ON_THE_NON_CLASS_LIMITED_MATCH_WAITING_LIST);
                    sm.addPcName(noble);
                    player.sendPacket(sm);
                    break;
                }
                case TEAMS: {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_NON_CLASS_LIMITED_EVENT_TEAMS);
                    sm.addPcName(noble);
                    player.sendPacket(sm);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public final boolean registerNoble(L2PcInstance player, CompetitionType type) {
        if (!Olympiad._inCompPeriod) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_OLYMPIAD_GAME_IS_NOT_CURRENTLY_IN_PROGRESS);
            player.sendPacket(sm);
            return false;
        }
        if (Olympiad.getInstance().getMillisToCompEnd() < 600000L) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.GAME_REQUEST_CANNOT_BE_MADE);
            player.sendPacket(sm);
            return false;
        }
        switch (type) {
            case CLASSED: {
                if (!this.checkNoble(player, player)) {
                    return false;
                }
                FastList classed = this._classBasedRegisters.get(player.getBaseClass());
                if (classed != null) {
                    classed.add(player.getObjectId());
                } else {
                    classed = new FastList().shared();
                    classed.add(player.getObjectId());
                    this._classBasedRegisters.put(player.getBaseClass(), (List<Integer>)classed);
                }
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_CLASSIFIED_GAMES);
                player.sendPacket(sm);
                break;
            }
            case NON_CLASSED: {
                if (!this.checkNoble(player, player)) {
                    return false;
                }
                this._nonClassBasedRegisters.add(player.getObjectId());
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_NO_CLASS_GAMES);
                player.sendPacket(sm);
                break;
            }
            case TEAMS: {
                L2Party party = player.getParty();
                if (party == null || party.getMemberCount() != 3) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.PARTY_REQUIREMENTS_NOT_MET);
                    player.sendPacket(sm);
                    return false;
                }
                if (!party.isLeader(player)) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.ONLY_PARTY_LEADER_CAN_REQUEST_TEAM_MATCH);
                    player.sendPacket(sm);
                    return false;
                }
                int teamPoints = 0;
                ArrayList<Integer> team = new ArrayList<Integer>(party.getMemberCount());
                for (L2PcInstance noble : party.getPartyMembers()) {
                    if (!this.checkNoble(noble, player)) {
                        if (Config.L2JMOD_DUALBOX_CHECK_MAX_OLYMPIAD_PARTICIPANTS_PER_IP > 0) {
                            L2PcInstance unreg;
                            Iterator i$ = party.getPartyMembers().iterator();
                            while (i$.hasNext() && (unreg = (L2PcInstance)i$.next()) != noble) {
                                AntiFeedManager.getInstance().removePlayer(1, unreg);
                            }
                        }
                        return false;
                    }
                    team.add(noble.getObjectId());
                    teamPoints += Olympiad.getInstance().getNoblePoints(noble.getObjectId());
                }
                if (teamPoints < 10) {
                    player.sendMessage("Your team must have at least 10 points in total.");
                    if (Config.L2JMOD_DUALBOX_CHECK_MAX_OLYMPIAD_PARTICIPANTS_PER_IP > 0) {
                        for (L2PcInstance unreg : party.getPartyMembers()) {
                            AntiFeedManager.getInstance().removePlayer(1, unreg);
                        }
                    }
                    return false;
                }
                party.broadcastToPartyMembers(SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_REGISTERED_IN_A_WAITING_LIST_OF_TEAM_GAMES));
                this._teamsBasedRegisters.add(team);
                break;
            }
        }
        return true;
    }

    public final boolean unRegisterNoble(L2PcInstance noble) {
        if (!Olympiad._inCompPeriod) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_OLYMPIAD_GAME_IS_NOT_CURRENTLY_IN_PROGRESS);
            noble.sendPacket(sm);
            return false;
        }
        if (!noble.isNoble()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DOES_NOT_MEET_REQUIREMENTS_ONLY_NOBLESS_CAN_PARTICIPATE_IN_THE_OLYMPIAD);
            sm.addString(noble.getName());
            noble.sendPacket(sm);
            return false;
        }
        if (!this.isRegistered(noble, noble, false)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_NOT_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_A_GAME);
            noble.sendPacket(sm);
            return false;
        }
        if (this.isInCompetition(noble, noble, false)) {
            return false;
        }
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_BEEN_DELETED_FROM_THE_WAITING_LIST_OF_A_GAME);
        Integer objId = noble.getObjectId();
        if (this._nonClassBasedRegisters.remove(objId)) {
            if (Config.L2JMOD_DUALBOX_CHECK_MAX_OLYMPIAD_PARTICIPANTS_PER_IP > 0) {
                AntiFeedManager.getInstance().removePlayer(1, noble);
            }
            noble.sendPacket(sm);
            return true;
        }
        List<Integer> classed = this._classBasedRegisters.get(noble.getBaseClass());
        if (classed != null && classed.remove(objId)) {
            this._classBasedRegisters.remove(noble.getBaseClass());
            this._classBasedRegisters.put(noble.getBaseClass(), classed);
            if (Config.L2JMOD_DUALBOX_CHECK_MAX_OLYMPIAD_PARTICIPANTS_PER_IP > 0) {
                AntiFeedManager.getInstance().removePlayer(1, noble);
            }
            noble.sendPacket(sm);
            return true;
        }
        for (List<Integer> team : this._teamsBasedRegisters) {
            if (team == null || !team.contains(objId)) continue;
            this._teamsBasedRegisters.remove(team);
            ThreadPoolManager.getInstance().executeTask(new AnnounceUnregToTeam(team));
            return true;
        }
        return false;
    }

    public final void removeDisconnectedCompetitor(L2PcInstance player) {
        Integer objId;
        OlympiadGameTask task = OlympiadGameManager.getInstance().getOlympiadTask(player.getOlympiadGameId());
        if (task != null && task.isGameStarted()) {
            task.getGame().handleDisconnect(player);
        }
        if (this._nonClassBasedRegisters.remove(objId = Integer.valueOf(player.getObjectId()))) {
            return;
        }
        List<Integer> classed = this._classBasedRegisters.get(player.getBaseClass());
        if (classed != null && classed.remove(objId)) {
            return;
        }
        for (List<Integer> team : this._teamsBasedRegisters) {
            if (team == null || !team.contains(objId)) continue;
            this._teamsBasedRegisters.remove(team);
            ThreadPoolManager.getInstance().executeTask(new AnnounceUnregToTeam(team));
            return;
        }
    }

    private final boolean checkNoble(L2PcInstance noble, L2PcInstance player) {
        int points;
        if (!noble.isNoble()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DOES_NOT_MEET_REQUIREMENTS_ONLY_NOBLESS_CAN_PARTICIPATE_IN_THE_OLYMPIAD);
            sm.addPcName(noble);
            player.sendPacket(sm);
            return false;
        }
        if (noble.isSubClassActive()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CANT_JOIN_THE_OLYMPIAD_WITH_A_SUB_CLASS_CHARACTER);
            sm.addPcName(noble);
            player.sendPacket(sm);
            return false;
        }
        if (noble.isCursedWeaponEquipped()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CANNOT_JOIN_OLYMPIAD_POSSESSING_S2);
            sm.addPcName(noble);
            sm.addItemName(noble.getCursedWeaponEquippedId());
            player.sendPacket(sm);
            return false;
        }
        if (!noble.isInventoryUnder80(true)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CANNOT_PARTICIPATE_IN_OLYMPIAD_INVENTORY_SLOT_EXCEEDS_80_PERCENT);
            sm.addPcName(noble);
            player.sendPacket(sm);
            return false;
        }
        if (TvTEvent.isPlayerParticipant(noble.getObjectId())) {
            player.sendMessage("You can't join olympiad while participating on TvT Event.");
            return false;
        }
        if (this.isRegistered(noble, player, true)) {
            return false;
        }
        if (this.isInCompetition(noble, player, true)) {
            return false;
        }
        StatsSet statDat = Olympiad.getNobleStats(noble.getObjectId());
        if (statDat == null) {
            statDat = new StatsSet();
            statDat.set("class_id", noble.getBaseClass());
            statDat.set("char_name", noble.getName());
            statDat.set("olympiad_points", Olympiad.DEFAULT_POINTS);
            statDat.set("competitions_done", 0);
            statDat.set("competitions_won", 0);
            statDat.set("competitions_lost", 0);
            statDat.set("competitions_drawn", 0);
            statDat.set("to_save", true);
            Olympiad.updateNobleStats(noble.getObjectId(), statDat);
        }
        if ((points = Olympiad.getInstance().getNoblePoints(noble.getObjectId())) <= 0) {
            NpcHtmlMessage message = new NpcHtmlMessage(0);
            message.setFile(player.getHtmlPrefix(), "data/html/olympiad/noble_nopoints1.htm");
            player.sendPacket(message);
            return false;
        }
        if (Config.L2JMOD_DUALBOX_CHECK_MAX_OLYMPIAD_PARTICIPANTS_PER_IP > 0 && !AntiFeedManager.getInstance().tryAddPlayer(1, noble, Config.L2JMOD_DUALBOX_CHECK_MAX_OLYMPIAD_PARTICIPANTS_PER_IP)) {
            NpcHtmlMessage message = new NpcHtmlMessage(0);
            message.setFile(player.getHtmlPrefix(), "data/html/mods/OlympiadIPRestriction.htm");
            message.replace((CharSequence)"%max%", String.valueOf(AntiFeedManager.getInstance().getLimit(player, Config.L2JMOD_DUALBOX_CHECK_MAX_OLYMPIAD_PARTICIPANTS_PER_IP)));
            player.sendPacket(message);
            return false;
        }
        return true;
    }

    private static class SingletonHolder {
        protected static final OlympiadManager _instance = new OlympiadManager();

        private SingletonHolder() {
        }
    }

    private static final class AnnounceUnregToTeam
    implements Runnable {
        private final List<Integer> _team;

        public AnnounceUnregToTeam(List<Integer> t) {
            this._team = t;
        }

        @Override
        public final void run() {
            L2PcInstance teamMember;
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_BEEN_DELETED_FROM_THE_WAITING_LIST_OF_A_GAME);
            for (int objectId : this._team) {
                teamMember = L2World.getInstance().getPlayer(objectId);
                if (teamMember == null) continue;
                teamMember.sendPacket(sm);
                if (Config.L2JMOD_DUALBOX_CHECK_MAX_OLYMPIAD_PARTICIPANTS_PER_IP <= 0) continue;
                AntiFeedManager.getInstance().removePlayer(1, teamMember);
            }
            teamMember = null;
        }
    }
}

