/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.zone.L2ZoneType;

public class L2SwampZone
extends L2ZoneType {
    private int _move_bonus = -50;
    private int _castleId = 0;
    private Castle _castle = null;

    public L2SwampZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("move_bonus")) {
            this._move_bonus = Integer.parseInt(value);
        } else if (name.equals("castleId")) {
            this._castleId = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    private Castle getCastle() {
        if (this._castleId > 0 && this._castle == null) {
            this._castle = CastleManager.getInstance().getCastleById(this._castleId);
        }
        return this._castle;
    }

    @Override
    protected void onEnter(L2Character character) {
        if (this.getCastle() != null) {
            if (!this.getCastle().getSiege().getIsInProgress() || !this.getCastle().getSiege().isTrapsActive()) {
                return;
            }
            L2PcInstance player = character.getActingPlayer();
            if (player != null && player.isInSiege() && player.getSiegeState() == 2) {
                return;
            }
        }
        character.setInsideZone((byte)11, true);
        if (character instanceof L2PcInstance) {
            ((L2PcInstance)character).broadcastUserInfo();
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character.isInsideZone((byte)11)) {
            character.setInsideZone((byte)11, false);
            if (character instanceof L2PcInstance) {
                ((L2PcInstance)character).broadcastUserInfo();
            }
        }
    }

    public int getMoveBonus() {
        return this._move_bonus;
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }
}

