/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.AugmentationData;
import com.l2jserver.gameserver.model.L2Augmentation;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.AbstractRefinePacket;
import com.l2jserver.gameserver.network.serverpackets.ExVariationResult;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestRefine
extends AbstractRefinePacket {
    private static final String _C__D0_2C_REQUESTREFINE = "[C] D0:2C RequestRefine";
    private int _targetItemObjId;
    private int _refinerItemObjId;
    private int _gemStoneItemObjId;
    private long _gemStoneCount;

    @Override
    protected void readImpl() {
        this._targetItemObjId = this.readD();
        this._refinerItemObjId = this.readD();
        this._gemStoneItemObjId = this.readD();
        this._gemStoneCount = this.readQ();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2ItemInstance targetItem = activeChar.getInventory().getItemByObjectId(this._targetItemObjId);
        if (targetItem == null) {
            return;
        }
        L2ItemInstance refinerItem = activeChar.getInventory().getItemByObjectId(this._refinerItemObjId);
        if (refinerItem == null) {
            return;
        }
        L2ItemInstance gemStoneItem = activeChar.getInventory().getItemByObjectId(this._gemStoneItemObjId);
        if (gemStoneItem == null) {
            return;
        }
        if (!RequestRefine.isValid(activeChar, targetItem, refinerItem, gemStoneItem)) {
            activeChar.sendPacket(new ExVariationResult(0, 0, 0));
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.AUGMENTATION_FAILED_DUE_TO_INAPPROPRIATE_CONDITIONS));
            return;
        }
        AbstractRefinePacket.LifeStone ls = RequestRefine.getLifeStone(refinerItem.getItemId());
        if (ls == null) {
            return;
        }
        int lifeStoneLevel = ls.getLevel();
        int lifeStoneGrade = ls.getGrade();
        if (this._gemStoneCount != (long)RequestRefine.getGemStoneCount(targetItem.getItem().getItemGrade(), lifeStoneGrade)) {
            activeChar.sendPacket(new ExVariationResult(0, 0, 0));
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.AUGMENTATION_FAILED_DUE_TO_INAPPROPRIATE_CONDITIONS));
            return;
        }
        if (targetItem.isEquipped()) {
            L2ItemInstance[] unequiped = activeChar.getInventory().unEquipItemInSlotAndRecord(targetItem.getLocationSlot());
            InventoryUpdate iu = new InventoryUpdate();
            for (L2ItemInstance itm : unequiped) {
                iu.addModifiedItem(itm);
            }
            activeChar.sendPacket(iu);
            activeChar.broadcastUserInfo();
        }
        if (!activeChar.destroyItem("RequestRefine", refinerItem, 1L, null, false)) {
            return;
        }
        if (!activeChar.destroyItem("RequestRefine", gemStoneItem, this._gemStoneCount, null, false)) {
            return;
        }
        L2Augmentation aug = AugmentationData.getInstance().generateRandomAugmentation(lifeStoneLevel, lifeStoneGrade, targetItem.getItem().getBodyPart());
        targetItem.setAugmentation(aug);
        int stat12 = 0xFFFF & aug.getAugmentationId();
        int stat34 = aug.getAugmentationId() >> 16;
        activeChar.sendPacket(new ExVariationResult(stat12, stat34, 1));
        InventoryUpdate iu = new InventoryUpdate();
        iu.addModifiedItem(targetItem);
        activeChar.sendPacket(iu);
        StatusUpdate su = new StatusUpdate(activeChar);
        su.addAttribute(14, activeChar.getCurrentLoad());
        activeChar.sendPacket(su);
    }

    @Override
    public String getType() {
        return _C__D0_2C_REQUESTREFINE;
    }
}

