/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.CustomZoneManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.model.base.PlayerState;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.type.L2CastleZone;
import com.l2jserver.gameserver.model.zone.type.L2ClanHallZone;
import com.l2jserver.gameserver.model.zone.type.L2FortZone;
import com.l2jserver.gameserver.model.zone.type.L2MotherTreeZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.BaseStats;
import com.l2jserver.gameserver.skills.Calculator;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.skills.conditions.ConditionPlayerState;
import com.l2jserver.gameserver.skills.conditions.ConditionUsingItemType;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.skills.hitConditionBonus;
import com.l2jserver.gameserver.templates.chars.L2PcTemplate;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.item.L2Armor;
import com.l2jserver.gameserver.templates.item.L2ArmorType;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.StringUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Formulas {
    protected static final Logger _log = Logger.getLogger(L2Character.class.getName());
    private static final int HP_REGENERATE_PERIOD = 3000;
    public static final byte SHIELD_DEFENSE_FAILED = 0;
    public static final byte SHIELD_DEFENSE_SUCCEED = 1;
    public static final byte SHIELD_DEFENSE_PERFECT_BLOCK = 2;
    public static final byte SKILL_REFLECT_FAILED = 0;
    public static final byte SKILL_REFLECT_SUCCEED = 1;
    public static final byte SKILL_REFLECT_VENGEANCE = 2;
    private static final byte MELEE_ATTACK_RANGE = 40;
    private static double FRONT_MAX_ANGLE = 100.0;
    private static double BACK_MAX_ANGLE = 40.0;

    public static int getRegeneratePeriod(L2Character cha) {
        if (cha instanceof L2DoorInstance) {
            return 300000;
        }
        return 3000;
    }

    public static Calculator[] getStdNPCCalculators() {
        Calculator[] std = new Calculator[Stats.NUM_STATS];
        std[Stats.MAX_HP.ordinal()] = new Calculator();
        std[Stats.MAX_HP.ordinal()].addFunc(FuncMaxHpMul.getInstance());
        std[Stats.MAX_MP.ordinal()] = new Calculator();
        std[Stats.MAX_MP.ordinal()].addFunc(FuncMaxMpMul.getInstance());
        std[Stats.POWER_ATTACK.ordinal()] = new Calculator();
        std[Stats.POWER_ATTACK.ordinal()].addFunc(FuncPAtkMod.getInstance());
        std[Stats.MAGIC_ATTACK.ordinal()] = new Calculator();
        std[Stats.MAGIC_ATTACK.ordinal()].addFunc(FuncMAtkMod.getInstance());
        std[Stats.POWER_DEFENCE.ordinal()] = new Calculator();
        std[Stats.POWER_DEFENCE.ordinal()].addFunc(FuncPDefMod.getInstance());
        std[Stats.MAGIC_DEFENCE.ordinal()] = new Calculator();
        std[Stats.MAGIC_DEFENCE.ordinal()].addFunc(FuncMDefMod.getInstance());
        std[Stats.CRITICAL_RATE.ordinal()] = new Calculator();
        std[Stats.CRITICAL_RATE.ordinal()].addFunc(FuncAtkCritical.getInstance());
        std[Stats.MCRITICAL_RATE.ordinal()] = new Calculator();
        std[Stats.MCRITICAL_RATE.ordinal()].addFunc(FuncMAtkCritical.getInstance());
        std[Stats.ACCURACY_COMBAT.ordinal()] = new Calculator();
        std[Stats.ACCURACY_COMBAT.ordinal()].addFunc(FuncAtkAccuracy.getInstance());
        std[Stats.EVASION_RATE.ordinal()] = new Calculator();
        std[Stats.EVASION_RATE.ordinal()].addFunc(FuncAtkEvasion.getInstance());
        std[Stats.POWER_ATTACK_SPEED.ordinal()] = new Calculator();
        std[Stats.POWER_ATTACK_SPEED.ordinal()].addFunc(FuncPAtkSpeed.getInstance());
        std[Stats.MAGIC_ATTACK_SPEED.ordinal()] = new Calculator();
        std[Stats.MAGIC_ATTACK_SPEED.ordinal()].addFunc(FuncMAtkSpeed.getInstance());
        std[Stats.RUN_SPEED.ordinal()] = new Calculator();
        std[Stats.RUN_SPEED.ordinal()].addFunc(FuncMoveSpeed.getInstance());
        return std;
    }

    public static Calculator[] getStdDoorCalculators() {
        Calculator[] std = new Calculator[Stats.NUM_STATS];
        std[Stats.ACCURACY_COMBAT.ordinal()] = new Calculator();
        std[Stats.ACCURACY_COMBAT.ordinal()].addFunc(FuncAtkAccuracy.getInstance());
        std[Stats.EVASION_RATE.ordinal()] = new Calculator();
        std[Stats.EVASION_RATE.ordinal()].addFunc(FuncAtkEvasion.getInstance());
        std[Stats.POWER_DEFENCE.ordinal()] = new Calculator();
        std[Stats.POWER_DEFENCE.ordinal()].addFunc(FuncGatesPDefMod.getInstance());
        std[Stats.MAGIC_DEFENCE.ordinal()] = new Calculator();
        std[Stats.MAGIC_DEFENCE.ordinal()].addFunc(FuncGatesMDefMod.getInstance());
        return std;
    }

    public static void addFuncsToNewCharacter(L2Character cha) {
        if (cha instanceof L2PcInstance) {
            cha.addStatFunc(FuncMaxHpAdd.getInstance());
            cha.addStatFunc(FuncMaxHpMul.getInstance());
            cha.addStatFunc(FuncMaxCpAdd.getInstance());
            cha.addStatFunc(FuncMaxCpMul.getInstance());
            cha.addStatFunc(FuncMaxMpAdd.getInstance());
            cha.addStatFunc(FuncMaxMpMul.getInstance());
            cha.addStatFunc(FuncBowAtkRange.getInstance());
            cha.addStatFunc(FuncCrossBowAtkRange.getInstance());
            cha.addStatFunc(FuncPAtkMod.getInstance());
            cha.addStatFunc(FuncMAtkMod.getInstance());
            cha.addStatFunc(FuncPDefMod.getInstance());
            cha.addStatFunc(FuncMDefMod.getInstance());
            cha.addStatFunc(FuncAtkCritical.getInstance());
            cha.addStatFunc(FuncMAtkCritical.getInstance());
            cha.addStatFunc(FuncAtkAccuracy.getInstance());
            cha.addStatFunc(FuncAtkEvasion.getInstance());
            cha.addStatFunc(FuncPAtkSpeed.getInstance());
            cha.addStatFunc(FuncMAtkSpeed.getInstance());
            cha.addStatFunc(FuncMoveSpeed.getInstance());
            cha.addStatFunc(FuncHennaSTR.getInstance());
            cha.addStatFunc(FuncHennaDEX.getInstance());
            cha.addStatFunc(FuncHennaINT.getInstance());
            cha.addStatFunc(FuncHennaMEN.getInstance());
            cha.addStatFunc(FuncHennaCON.getInstance());
            cha.addStatFunc(FuncHennaWIT.getInstance());
        } else if (cha instanceof L2PetInstance) {
            cha.addStatFunc(FuncMaxHpMul.getInstance());
            cha.addStatFunc(FuncMaxMpMul.getInstance());
            cha.addStatFunc(FuncPAtkMod.getInstance());
            cha.addStatFunc(FuncMAtkMod.getInstance());
            cha.addStatFunc(FuncPDefMod.getInstance());
            cha.addStatFunc(FuncMDefMod.getInstance());
            cha.addStatFunc(FuncAtkCritical.getInstance());
            cha.addStatFunc(FuncMAtkCritical.getInstance());
            cha.addStatFunc(FuncAtkAccuracy.getInstance());
            cha.addStatFunc(FuncAtkEvasion.getInstance());
            cha.addStatFunc(FuncMoveSpeed.getInstance());
            cha.addStatFunc(FuncPAtkSpeed.getInstance());
            cha.addStatFunc(FuncMAtkSpeed.getInstance());
        } else if (cha instanceof L2Summon) {
            cha.addStatFunc(FuncMaxHpMul.getInstance());
            cha.addStatFunc(FuncMaxMpMul.getInstance());
            cha.addStatFunc(FuncPAtkMod.getInstance());
            cha.addStatFunc(FuncMAtkMod.getInstance());
            cha.addStatFunc(FuncPDefMod.getInstance());
            cha.addStatFunc(FuncMDefMod.getInstance());
            cha.addStatFunc(FuncAtkCritical.getInstance());
            cha.addStatFunc(FuncMAtkCritical.getInstance());
            cha.addStatFunc(FuncAtkAccuracy.getInstance());
            cha.addStatFunc(FuncAtkEvasion.getInstance());
            cha.addStatFunc(FuncMoveSpeed.getInstance());
            cha.addStatFunc(FuncPAtkSpeed.getInstance());
            cha.addStatFunc(FuncMAtkSpeed.getInstance());
        }
    }

    public static final double calcHpRegen(L2Character cha) {
        double init = cha.getTemplate().baseHpReg;
        double hpRegenMultiplier = cha.isRaid() ? Config.RAID_HP_REGEN_MULTIPLIER : Config.HP_REGEN_MULTIPLIER;
        double hpRegenBonus = 0.0;
        if (cha instanceof L2GrandBossInstance && ((L2GrandBossInstance)cha).getNpcId() == 29022 && CustomZoneManager.getInstance().isZakenWeakZone(cha)) {
            hpRegenMultiplier *= 0.75;
        }
        if (Config.L2JMOD_CHAMPION_ENABLE && cha.isChampion()) {
            hpRegenMultiplier *= (double)Config.L2JMOD_CHAMPION_HP_REGEN;
        }
        if (cha instanceof L2PcInstance) {
            L2PcInstance player = (L2PcInstance)cha;
            init += player.getLevel() > 10 ? (double)(player.getLevel() - 1) / 10.0 : 0.5;
            if (SevenSignsFestival.getInstance().isFestivalInProgress() && player.isFestivalParticipant()) {
                hpRegenMultiplier *= Formulas.calcFestivalRegenModifier(player);
            } else {
                double siegeModifier = Formulas.calcSiegeRegenModifer(player);
                if (siegeModifier > 0.0) {
                    hpRegenMultiplier *= siegeModifier;
                }
            }
            if (player.isInsideZone((byte)4) && player.getClan() != null && player.getClan().getHasHideout() > 0) {
                ClanHall clansHall;
                L2ClanHallZone zone = ZoneManager.getInstance().getZone(player, L2ClanHallZone.class);
                int posChIndex = zone == null ? -1 : zone.getClanHallId();
                int clanHallIndex = player.getClan().getHasHideout();
                if (clanHallIndex > 0 && clanHallIndex == posChIndex && (clansHall = ClanHallManager.getInstance().getClanHallById(clanHallIndex)) != null && clansHall.getFunction(3) != null) {
                    hpRegenMultiplier *= 1.0 + (double)clansHall.getFunction(3).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone((byte)10) && player.getClan() != null && player.getClan().getHasCastle() > 0) {
                Castle castle;
                L2CastleZone zone = ZoneManager.getInstance().getZone(player, L2CastleZone.class);
                int posCastleIndex = zone == null ? -1 : zone.getCastleId();
                int castleIndex = player.getClan().getHasCastle();
                if (castleIndex > 0 && castleIndex == posCastleIndex && (castle = CastleManager.getInstance().getCastleById(castleIndex)) != null && castle.getFunction(2) != null) {
                    hpRegenMultiplier *= 1.0 + (double)castle.getFunction(2).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone((byte)13) && player.getClan() != null && player.getClan().getHasFort() > 0) {
                Fort fort;
                L2FortZone zone = ZoneManager.getInstance().getZone(player, L2FortZone.class);
                int posFortIndex = zone == null ? -1 : zone.getFortId();
                int fortIndex = player.getClan().getHasFort();
                if (fortIndex > 0 && fortIndex == posFortIndex && (fort = FortManager.getInstance().getFortById(fortIndex)) != null && fort.getFunction(2) != null) {
                    hpRegenMultiplier *= 1.0 + (double)fort.getFunction(2).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone((byte)3)) {
                L2MotherTreeZone zone = ZoneManager.getInstance().getZone(player, L2MotherTreeZone.class);
                int hpBonus = zone == null ? 0 : zone.getHpRegenBonus();
                hpRegenBonus += (double)hpBonus;
            }
            if (player.isSitting()) {
                hpRegenMultiplier *= 1.5;
            } else if (!player.isMoving()) {
                hpRegenMultiplier *= 1.1;
            } else if (player.isRunning()) {
                hpRegenMultiplier *= 0.7;
            }
            init *= cha.getLevelMod() * BaseStats.CON.calcBonus(cha);
        } else if (cha instanceof L2PetInstance) {
            init = (double)((L2PetInstance)cha).getPetLevelData().getPetRegenHP() * Config.PET_HP_REGEN_MULTIPLIER;
        }
        if (init < 1.0) {
            init = 1.0;
        }
        return cha.calcStat(Stats.REGENERATE_HP_RATE, init, null, null) * hpRegenMultiplier + hpRegenBonus;
    }

    public static final double calcMpRegen(L2Character cha) {
        double init = cha.getTemplate().baseMpReg;
        double mpRegenMultiplier = cha.isRaid() ? Config.RAID_MP_REGEN_MULTIPLIER : Config.MP_REGEN_MULTIPLIER;
        double mpRegenBonus = 0.0;
        if (cha instanceof L2PcInstance) {
            L2ZoneType zone;
            L2PcInstance player = (L2PcInstance)cha;
            init += 0.3 * ((double)(player.getLevel() - 1) / 10.0);
            if (SevenSignsFestival.getInstance().isFestivalInProgress() && player.isFestivalParticipant()) {
                mpRegenMultiplier *= Formulas.calcFestivalRegenModifier(player);
            }
            if (player.isInsideZone((byte)3)) {
                zone = ZoneManager.getInstance().getZone(player, L2MotherTreeZone.class);
                int mpBonus = zone == null ? 0 : ((L2MotherTreeZone)zone).getMpRegenBonus();
                mpRegenBonus += (double)mpBonus;
            }
            if (player.isInsideZone((byte)4) && player.getClan() != null && player.getClan().getHasHideout() > 0) {
                ClanHall clansHall;
                zone = ZoneManager.getInstance().getZone(player, L2ClanHallZone.class);
                int posChIndex = zone == null ? -1 : ((L2ClanHallZone)zone).getClanHallId();
                int clanHallIndex = player.getClan().getHasHideout();
                if (clanHallIndex > 0 && clanHallIndex == posChIndex && (clansHall = ClanHallManager.getInstance().getClanHallById(clanHallIndex)) != null && clansHall.getFunction(4) != null) {
                    mpRegenMultiplier *= 1.0 + (double)clansHall.getFunction(4).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone((byte)10) && player.getClan() != null && player.getClan().getHasCastle() > 0) {
                Castle castle;
                zone = ZoneManager.getInstance().getZone(player, L2CastleZone.class);
                int posCastleIndex = zone == null ? -1 : ((L2CastleZone)zone).getCastleId();
                int castleIndex = player.getClan().getHasCastle();
                if (castleIndex > 0 && castleIndex == posCastleIndex && (castle = CastleManager.getInstance().getCastleById(castleIndex)) != null && castle.getFunction(3) != null) {
                    mpRegenMultiplier *= 1.0 + (double)castle.getFunction(3).getLvl() / 100.0;
                }
            }
            if (player.isInsideZone((byte)13) && player.getClan() != null && player.getClan().getHasFort() > 0) {
                Fort fort;
                zone = ZoneManager.getInstance().getZone(player, L2FortZone.class);
                int posFortIndex = zone == null ? -1 : ((L2FortZone)zone).getFortId();
                int fortIndex = player.getClan().getHasFort();
                if (fortIndex > 0 && fortIndex == posFortIndex && (fort = FortManager.getInstance().getFortById(fortIndex)) != null && fort.getFunction(3) != null) {
                    mpRegenMultiplier *= 1.0 + (double)fort.getFunction(3).getLvl() / 100.0;
                }
            }
            if (player.isSitting()) {
                mpRegenMultiplier *= 1.5;
            } else if (!player.isMoving()) {
                mpRegenMultiplier *= 1.1;
            } else if (player.isRunning()) {
                mpRegenMultiplier *= 0.7;
            }
            init *= cha.getLevelMod() * BaseStats.MEN.calcBonus(cha);
        } else if (cha instanceof L2PetInstance) {
            init = (double)((L2PetInstance)cha).getPetLevelData().getPetRegenMP() * Config.PET_MP_REGEN_MULTIPLIER;
        }
        if (init < 1.0) {
            init = 1.0;
        }
        return cha.calcStat(Stats.REGENERATE_MP_RATE, init, null, null) * mpRegenMultiplier + mpRegenBonus;
    }

    public static final double calcCpRegen(L2Character cha) {
        double init = cha.getTemplate().baseHpReg;
        double cpRegenMultiplier = Config.CP_REGEN_MULTIPLIER;
        double cpRegenBonus = 0.0;
        if (cha instanceof L2PcInstance) {
            L2PcInstance player = (L2PcInstance)cha;
            init += player.getLevel() > 10 ? (double)(player.getLevel() - 1) / 10.0 : 0.5;
            if (player.isSitting()) {
                cpRegenMultiplier *= 1.5;
            } else if (!player.isMoving()) {
                cpRegenMultiplier *= 1.1;
            } else if (player.isRunning()) {
                cpRegenMultiplier *= 0.7;
            }
        } else if (!cha.isMoving()) {
            cpRegenMultiplier *= 1.1;
        } else if (cha.isRunning()) {
            cpRegenMultiplier *= 0.7;
        }
        init *= cha.getLevelMod() * BaseStats.CON.calcBonus(cha);
        if (init < 1.0) {
            init = 1.0;
        }
        return cha.calcStat(Stats.REGENERATE_CP_RATE, init, null, null) * cpRegenMultiplier + cpRegenBonus;
    }

    public static final double calcFestivalRegenModifier(L2PcInstance activeChar) {
        int[] festivalInfo = SevenSignsFestival.getInstance().getFestivalForPlayer(activeChar);
        int oracle = festivalInfo[0];
        int festivalId = festivalInfo[1];
        if (festivalId < 0) {
            return 0.0;
        }
        int[] festivalCenter = oracle == 2 ? SevenSignsFestival.FESTIVAL_DAWN_PLAYER_SPAWNS[festivalId] : SevenSignsFestival.FESTIVAL_DUSK_PLAYER_SPAWNS[festivalId];
        double distToCenter = activeChar.getDistance(festivalCenter[0], festivalCenter[1]);
        if (Config.DEBUG) {
            _log.info("Distance: " + distToCenter + ", RegenMulti: " + distToCenter * 2.5 / 50.0);
        }
        return 1.0 - distToCenter * 5.0E-4;
    }

    public static final double calcSiegeRegenModifer(L2PcInstance activeChar) {
        if (activeChar == null || activeChar.getClan() == null) {
            return 0.0;
        }
        Siege siege = SiegeManager.getInstance().getSiege(activeChar.getPosition().getX(), activeChar.getPosition().getY(), activeChar.getPosition().getZ());
        if (siege == null || !siege.getIsInProgress()) {
            return 0.0;
        }
        L2SiegeClan siegeClan = siege.getAttackerClan(activeChar.getClan().getClanId());
        if (siegeClan == null || siegeClan.getFlag().isEmpty() || !Util.checkIfInRange(200, activeChar, siegeClan.getFlag().get(0), true)) {
            return 0.0;
        }
        return 1.5;
    }

    public static double calcBlowDamage(L2Character attacker, L2Character target, L2Skill skill, byte shld, boolean ss) {
        double graciaPhysSkillBonus;
        double defence = target.getPDef(attacker);
        switch (shld) {
            case 1: {
                defence += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        double power = skill.getPower();
        double damage = 0.0;
        double proximityBonus = 1.0;
        double d = graciaPhysSkillBonus = skill.isMagic() ? 1.0 : 1.10113;
        double ssboost = ss ? (skill.getSSBoost() > 0.0f ? (double)skill.getSSBoost() : 2.04) : 1.0;
        double pvpBonus = 1.0;
        if (attacker instanceof L2Playable && target instanceof L2Playable) {
            pvpBonus *= attacker.calcStat(Stats.PVP_PHYS_SKILL_DMG, 1.0, null, null);
            defence *= target.calcStat(Stats.PVP_PHYS_SKILL_DEF, 1.0, null, null);
        }
        if (Formulas.isBehind(attacker, target)) {
            proximityBonus = 1.2;
        } else if (Formulas.isInFrontOf(attacker, target)) {
            proximityBonus = 1.1;
        }
        damage += Formulas.calcValakasAttribute(attacker, target, skill);
        double element = Formulas.calcElemental(attacker, target, skill);
        damage = skill.getSSBoost() > 0.0f ? (damage += 70.0 * graciaPhysSkillBonus * ((double)attacker.getPAtk(target) + power) / defence * attacker.calcStat(Stats.CRITICAL_DAMAGE, 1.0, target, skill) * target.calcStat(Stats.CRIT_VULN, 1.0, target, skill) * ssboost * proximityBonus * element * pvpBonus + attacker.calcStat(Stats.CRITICAL_DAMAGE_ADD, 0.0, target, skill) * 6.1 * 70.0 / defence * graciaPhysSkillBonus) : (damage += 70.0 * graciaPhysSkillBonus * (power + (double)attacker.getPAtk(target) * ssboost) / defence * attacker.calcStat(Stats.CRITICAL_DAMAGE, 1.0, target, skill) * target.calcStat(Stats.CRIT_VULN, 1.0, target, skill) * proximityBonus * element * pvpBonus + attacker.calcStat(Stats.CRITICAL_DAMAGE_ADD, 0.0, target, skill) * 6.1 * 70.0 / defence * graciaPhysSkillBonus);
        damage += target.calcStat(Stats.CRIT_ADD_VULN, 0.0, target, skill) * 6.1;
        damage = target.calcStat(Stats.DAGGER_WPN_VULN, damage, target, null);
        damage *= attacker.getRandomDamageMultiplier();
        if (target instanceof L2Attackable && !target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Config.MIN_NPC_LVL_DMG_PENALTY && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
            int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
            damage = lvlDiff > Config.NPC_SKILL_DMG_PENALTY.size() ? (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(Config.NPC_SKILL_DMG_PENALTY.size())) : (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(lvlDiff));
        }
        return damage < 1.0 ? 1.0 : damage;
    }

    public static final double calcPhysDam(L2Character attacker, L2Character target, L2Skill skill, byte shld, boolean crit, boolean dual, boolean ss) {
        boolean isPvP = attacker instanceof L2Playable && target instanceof L2Playable;
        double damage = attacker.getPAtk(target);
        double defence = target.getPDef(attacker);
        damage += Formulas.calcValakasAttribute(attacker, target, skill);
        if (attacker instanceof L2Npc) {
            ss = ((L2Npc)attacker)._soulshotcharged;
            ((L2Npc)attacker)._soulshotcharged = false;
        }
        if (isPvP) {
            defence = skill == null ? (defence *= target.calcStat(Stats.PVP_PHYSICAL_DEF, 1.0, null, null)) : (defence *= target.calcStat(Stats.PVP_PHYS_SKILL_DEF, 1.0, null, null));
        }
        switch (shld) {
            case 1: {
                if (Config.ALT_GAME_SHIELD_BLOCKS) break;
                defence += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        if (ss) {
            damage *= 2.0;
        }
        if (skill != null) {
            double skillpower = skill.getPower(attacker, target, isPvP);
            float ssboost = skill.getSSBoost();
            if (ssboost <= 0.0f) {
                damage += skillpower;
            } else if (ssboost > 0.0f) {
                damage = ss ? (damage += (skillpower *= (double)ssboost)) : (damage += skillpower);
            }
        }
        L2Weapon weapon = attacker.getActiveWeaponItem();
        Stats stat = null;
        boolean isBow = false;
        if (weapon != null && !attacker.isTransformed()) {
            switch (weapon.getItemType()) {
                case BOW: {
                    isBow = true;
                    stat = Stats.BOW_WPN_VULN;
                    break;
                }
                case CROSSBOW: {
                    isBow = true;
                    stat = Stats.CROSSBOW_WPN_VULN;
                    break;
                }
                case BLUNT: {
                    stat = Stats.BLUNT_WPN_VULN;
                    break;
                }
                case DAGGER: {
                    stat = Stats.DAGGER_WPN_VULN;
                    break;
                }
                case DUAL: {
                    stat = Stats.DUAL_WPN_VULN;
                    break;
                }
                case DUALFIST: {
                    stat = Stats.DUALFIST_WPN_VULN;
                    break;
                }
                case ETC: {
                    stat = Stats.ETC_WPN_VULN;
                    break;
                }
                case FIST: {
                    stat = Stats.FIST_WPN_VULN;
                    break;
                }
                case POLE: {
                    stat = Stats.POLE_WPN_VULN;
                    break;
                }
                case SWORD: {
                    stat = Stats.SWORD_WPN_VULN;
                    break;
                }
                case BIGSWORD: {
                    stat = Stats.BIGSWORD_WPN_VULN;
                    break;
                }
                case BIGBLUNT: {
                    stat = Stats.BIGBLUNT_WPN_VULN;
                    break;
                }
                case DUALDAGGER: {
                    stat = Stats.DUALDAGGER_WPN_VULN;
                    break;
                }
                case RAPIER: {
                    stat = Stats.RAPIER_WPN_VULN;
                    break;
                }
                case ANCIENTSWORD: {
                    stat = Stats.ANCIENT_WPN_VULN;
                }
            }
        }
        if (attacker instanceof L2SummonInstance) {
            stat = Stats.PET_WPN_VULN;
        }
        if (crit) {
            damage = 2.0 * attacker.calcStat(Stats.CRITICAL_DAMAGE, 1.0, target, skill) * target.calcStat(Stats.CRIT_VULN, target.getTemplate().baseCritVuln, target, null) * (70.0 * damage / defence);
            damage += attacker.calcStat(Stats.CRITICAL_DAMAGE_ADD, 0.0, target, skill) * 70.0 / defence;
        } else {
            damage = 70.0 * damage / defence;
        }
        if (stat != null) {
            damage = target.calcStat(stat, damage, target, null);
        }
        damage *= attacker.getRandomDamageMultiplier();
        if (shld > 0 && Config.ALT_GAME_SHIELD_BLOCKS && (damage -= (double)target.getShldDef()) < 0.0) {
            damage = 0.0;
        }
        if (target instanceof L2Npc) {
            switch (((L2Npc)target).getTemplate().getRace()) {
                case BEAST: {
                    damage *= attacker.getPAtkMonsters(target);
                    break;
                }
                case ANIMAL: {
                    damage *= attacker.getPAtkAnimals(target);
                    break;
                }
                case PLANT: {
                    damage *= attacker.getPAtkPlants(target);
                    break;
                }
                case DRAGON: {
                    damage *= attacker.getPAtkDragons(target);
                    break;
                }
                case BUG: {
                    damage *= attacker.getPAtkInsects(target);
                    break;
                }
                case GIANT: {
                    damage *= attacker.getPAtkGiants(target);
                    break;
                }
                case MAGICCREATURE: {
                    damage *= attacker.getPAtkMagicCreatures(target);
                    break;
                }
            }
        }
        if (damage > 0.0 && damage < 1.0) {
            damage = 1.0;
        } else if (damage < 0.0) {
            damage = 0.0;
        }
        if (isPvP) {
            damage = skill == null ? (damage *= attacker.calcStat(Stats.PVP_PHYSICAL_DMG, 1.0, null, null)) : (damage *= attacker.calcStat(Stats.PVP_PHYS_SKILL_DMG, 1.0, null, null));
        }
        if (skill != null) {
            damage *= attacker.calcStat(Stats.PHYSICAL_SKILL_POWER, 1.0, null, null);
        }
        damage *= Formulas.calcElemental(attacker, target, skill);
        if (target instanceof L2Attackable) {
            damage = isBow ? (skill != null ? (damage *= attacker.calcStat(Stats.PVE_BOW_SKILL_DMG, 1.0, null, null)) : (damage *= attacker.calcStat(Stats.PVE_BOW_DMG, 1.0, null, null))) : (damage *= attacker.calcStat(Stats.PVE_PHYSICAL_DMG, 1.0, null, null));
            if (!target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Config.MIN_NPC_LVL_DMG_PENALTY && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
                int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
                damage = skill != null ? (lvlDiff > Config.NPC_SKILL_DMG_PENALTY.size() ? (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(Config.NPC_SKILL_DMG_PENALTY.size())) : (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(lvlDiff))) : (crit ? (lvlDiff > Config.NPC_CRIT_DMG_PENALTY.size() ? (damage *= (double)Config.NPC_CRIT_DMG_PENALTY.get(Config.NPC_CRIT_DMG_PENALTY.size())) : (damage *= (double)Config.NPC_CRIT_DMG_PENALTY.get(lvlDiff))) : (lvlDiff > Config.NPC_DMG_PENALTY.size() ? (damage *= (double)Config.NPC_DMG_PENALTY.get(Config.NPC_DMG_PENALTY.size())) : (damage *= (double)Config.NPC_DMG_PENALTY.get(lvlDiff))));
            }
        }
        return damage;
    }

    public static final double calcMagicDam(L2Character attacker, L2Character target, L2Skill skill, byte shld, boolean ss, boolean bss, boolean mcrit) {
        boolean isPvP = attacker instanceof L2Playable && target instanceof L2Playable;
        double mAtk = attacker.getMAtk(target, skill);
        double mDef = target.getMDef(attacker, skill);
        if (attacker instanceof L2Npc) {
            ss = ((L2Npc)attacker)._spiritshotcharged;
            ((L2Npc)attacker)._spiritshotcharged = false;
        }
        if (isPvP) {
            mDef = skill.isMagic() ? (mDef *= target.calcStat(Stats.PVP_MAGICAL_DEF, 1.0, null, null)) : (mDef *= target.calcStat(Stats.PVP_PHYS_SKILL_DEF, 1.0, null, null));
        }
        switch (shld) {
            case 1: {
                mDef += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        if (bss) {
            mAtk *= 4.0;
        } else if (ss) {
            mAtk *= 2.0;
        }
        double damage = 91.0 * Math.sqrt(mAtk) / mDef * skill.getPower(attacker, target, isPvP);
        if (Config.ALT_GAME_MAGICFAILURES && !Formulas.calcMagicSuccess(attacker, target, skill)) {
            SystemMessage sm;
            if (attacker instanceof L2PcInstance) {
                if (Formulas.calcMagicSuccess(attacker, target, skill) && target.getLevel() - attacker.getLevel() <= 9) {
                    if (skill.getSkillType() == L2SkillType.DRAIN) {
                        attacker.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.DRAIN_HALF_SUCCESFUL));
                    } else {
                        attacker.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ATTACK_FAILED));
                    }
                    damage /= 2.0;
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
                    sm.addCharName(target);
                    sm.addSkillName(skill);
                    attacker.sendPacket(sm);
                    damage = 1.0;
                }
            }
            if (target instanceof L2PcInstance) {
                if (skill.getSkillType() == L2SkillType.DRAIN) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.RESISTED_C1_DRAIN);
                    sm.addCharName(attacker);
                    target.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.RESISTED_C1_MAGIC);
                    sm.addCharName(attacker);
                    target.sendPacket(sm);
                }
            }
        } else if (mcrit) {
            damage = attacker instanceof L2PcInstance && target instanceof L2PcInstance ? (damage *= 2.5) : (damage *= 3.0);
            damage *= attacker.calcStat(Stats.MAGIC_CRIT_DMG, 1.0, null, null);
        }
        damage *= attacker.getRandomDamageMultiplier();
        if (isPvP) {
            damage = skill.isMagic() ? (damage *= attacker.calcStat(Stats.PVP_MAGICAL_DMG, 1.0, null, null)) : (damage *= attacker.calcStat(Stats.PVP_PHYS_SKILL_DMG, 1.0, null, null));
        }
        damage *= target.calcStat(Stats.MAGIC_DAMAGE_VULN, 1.0, null, null);
        damage *= Formulas.calcElemental(attacker, target, skill);
        if (target instanceof L2Attackable) {
            damage *= attacker.calcStat(Stats.PVE_MAGICAL_DMG, 1.0, null, null);
            if (!target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Config.MIN_NPC_LVL_DMG_PENALTY && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
                int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
                damage = lvlDiff > Config.NPC_SKILL_DMG_PENALTY.size() ? (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(Config.NPC_SKILL_DMG_PENALTY.size())) : (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(lvlDiff));
            }
        }
        return damage;
    }

    public static final double calcMagicDam(L2CubicInstance attacker, L2Character target, L2Skill skill, boolean mcrit, byte shld) {
        double mDef = target.getMDef(attacker.getOwner(), skill);
        switch (shld) {
            case 1: {
                mDef += (double)target.getShldDef();
                break;
            }
            case 2: {
                return 1.0;
            }
        }
        double damage = 91.0 / mDef * skill.getPower(target instanceof L2Playable);
        L2PcInstance owner = attacker.getOwner();
        if (Config.ALT_GAME_MAGICFAILURES && !Formulas.calcMagicSuccess(owner, target, skill)) {
            SystemMessage sm;
            if (Formulas.calcMagicSuccess(owner, target, skill) && target.getLevel() - skill.getMagicLevel() <= 9) {
                if (skill.getSkillType() == L2SkillType.DRAIN) {
                    owner.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.DRAIN_HALF_SUCCESFUL));
                } else {
                    owner.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ATTACK_FAILED));
                }
                damage /= 2.0;
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
                sm.addCharName(target);
                sm.addSkillName(skill);
                owner.sendPacket(sm);
                damage = 1.0;
            }
            if (target instanceof L2PcInstance) {
                if (skill.getSkillType() == L2SkillType.DRAIN) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.RESISTED_C1_DRAIN);
                    sm.addCharName(owner);
                    target.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.RESISTED_C1_MAGIC);
                    sm.addCharName(owner);
                    target.sendPacket(sm);
                }
            }
        } else if (mcrit) {
            damage *= 3.0;
        }
        damage *= target.calcStat(Stats.MAGIC_DAMAGE_VULN, 1.0, null, null);
        damage *= Formulas.calcElemental(owner, target, skill);
        if (target instanceof L2Attackable) {
            damage *= attacker.getOwner().calcStat(Stats.PVE_MAGICAL_DMG, 1.0, null, null);
            if (!target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Config.MIN_NPC_LVL_DMG_PENALTY && attacker.getOwner() != null && target.getLevel() - attacker.getOwner().getLevel() >= 2) {
                int lvlDiff = target.getLevel() - attacker.getOwner().getLevel() - 1;
                damage = lvlDiff > Config.NPC_SKILL_DMG_PENALTY.size() ? (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(Config.NPC_SKILL_DMG_PENALTY.size())) : (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(lvlDiff));
            }
        }
        return damage;
    }

    public static final boolean calcCrit(double rate, L2Character target) {
        boolean success;
        boolean bl = success = rate > (double)Rnd.get(1000);
        if (success) {
            if (target == null) {
                return true;
            }
            return Rnd.get((int)target.getStat().calcStat(Stats.CRIT_DAMAGE_EVASION, 100.0, null, null)) < 100;
        }
        return success;
    }

    public static final boolean calcBlow(L2Character activeChar, L2Character target, int chance) {
        return activeChar.calcStat(Stats.BLOW_RATE, (double)chance * (1.0 + (double)((activeChar.getDEX() - 20) / 100)), target, null) > (double)Rnd.get(100);
    }

    public static final double calcLethal(L2Character activeChar, L2Character target, int baseLethal, int magiclvl) {
        int delta;
        double chance = 0.0;
        chance = magiclvl > 0 ? ((delta = (magiclvl + activeChar.getLevel()) / 2 - 1 - target.getLevel()) >= -3 ? (double)baseLethal * ((double)activeChar.getLevel() / (double)target.getLevel()) : (delta < -3 && delta >= -9 ? (double)(-3 * (baseLethal / delta)) : (double)(baseLethal / 15))) : (double)baseLethal * ((double)activeChar.getLevel() / (double)target.getLevel());
        return 10.0 * activeChar.calcStat(Stats.LETHAL_RATE, chance, target, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean calcLethalHit(L2Character activeChar, L2Character target, L2Skill skill) {
        if (target.isRaid() || target instanceof L2DoorInstance || target instanceof L2Npc && ((L2Npc)target).getNpcId() == 35062) return false;
        if (skill.getLethalChance2() > 0 && (double)Rnd.get(1000) < Formulas.calcLethal(activeChar, target, skill.getLethalChance2(), skill.getMagicLevel())) {
            L2PcInstance player;
            if (target instanceof L2Npc) {
                target.reduceCurrentHp(target.getCurrentHp() - 1.0, activeChar, skill);
            } else if (!(!(target instanceof L2PcInstance) || (player = (L2PcInstance)target).isInvul() || activeChar instanceof L2PcInstance && ((L2PcInstance)activeChar).isGM() && !((L2PcInstance)activeChar).getAccessLevel().canGiveDamage())) {
                player.setCurrentHp(1.0);
                player.setCurrentCp(1.0);
                player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.LETHAL_STRIKE_SUCCESSFUL));
            }
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.LETHAL_STRIKE));
            return true;
        } else {
            L2PcInstance player;
            if (skill.getLethalChance1() <= 0 || !((double)Rnd.get(1000) < Formulas.calcLethal(activeChar, target, skill.getLethalChance1(), skill.getMagicLevel()))) return false;
            if (!(target instanceof L2PcInstance) || (player = (L2PcInstance)target).isInvul() || activeChar instanceof L2PcInstance && ((L2PcInstance)activeChar).isGM() && !((L2PcInstance)activeChar).getAccessLevel().canGiveDamage()) return true;
            player.setCurrentCp(1.0);
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CP_DISAPPEARS_WHEN_HIT_WITH_A_HALF_KILL_SKILL));
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CP_SIPHON));
        }
        return true;
    }

    public static final boolean calcMCrit(double mRate) {
        return mRate > (double)Rnd.get(1000);
    }

    public static final boolean calcAtkBreak(L2Character target, double dmg) {
        L2Weapon wpn;
        if (target.getFusionSkill() != null) {
            return true;
        }
        double init = 0.0;
        if (Config.ALT_GAME_CANCEL_CAST && target.isCastingNow()) {
            init = 15.0;
        }
        if (Config.ALT_GAME_CANCEL_BOW && target.isAttackingNow() && (wpn = target.getActiveWeaponItem()) != null && wpn.getItemType() == L2WeaponType.BOW) {
            init = 15.0;
        }
        if (target.isRaid() || target.isInvul() || init <= 0.0) {
            return false;
        }
        init += Math.sqrt(13.0 * dmg);
        double rate = target.calcStat(Stats.ATTACK_CANCEL, init -= BaseStats.MEN.calcBonus(target) * 100.0 - 100.0, null, null);
        if (rate > 99.0) {
            rate = 99.0;
        } else if (rate < 1.0) {
            rate = 1.0;
        }
        return (double)Rnd.get(100) < rate;
    }

    public static final int calcPAtkSpd(L2Character attacker, L2Character target, double rate) {
        if (rate < 2.0) {
            return 2700;
        }
        return (int)(470000.0 / rate);
    }

    public static final int calcAtkSpd(L2Character attacker, L2Skill skill, double skillTime) {
        if (skill.isMagic()) {
            return (int)(skillTime * 333.0 / (double)attacker.getMAtkSpd());
        }
        return (int)(skillTime * 333.0 / (double)attacker.getPAtkSpd());
    }

    public static boolean calcHitMiss(L2Character attacker, L2Character target) {
        int chance = (80 + 2 * (attacker.getAccuracy() - target.getEvasionRate(attacker))) * 10;
        chance = (int)((double)chance * hitConditionBonus.getConditionBonus(attacker, target));
        chance = Math.max(chance, 200);
        return (chance = Math.min(chance, 980)) < Rnd.get(1000);
    }

    public static boolean __calcHitMiss(L2Character attacker, L2Character target) {
        int chance;
        int delta = attacker.getAccuracy() - target.getEvasionRate(attacker);
        if (delta >= 10) {
            chance = 980;
        } else {
            switch (delta) {
                case 9: {
                    chance = 975;
                    break;
                }
                case 8: {
                    chance = 970;
                    break;
                }
                case 7: {
                    chance = 965;
                    break;
                }
                case 6: {
                    chance = 960;
                    break;
                }
                case 5: {
                    chance = 955;
                    break;
                }
                case 4: {
                    chance = 945;
                    break;
                }
                case 3: {
                    chance = 935;
                    break;
                }
                case 2: {
                    chance = 925;
                    break;
                }
                case 1: {
                    chance = 915;
                    break;
                }
                case 0: {
                    chance = 905;
                    break;
                }
                case -1: {
                    chance = 890;
                    break;
                }
                case -2: {
                    chance = 875;
                    break;
                }
                case -3: {
                    chance = 860;
                    break;
                }
                case -4: {
                    chance = 845;
                    break;
                }
                case -5: {
                    chance = 830;
                    break;
                }
                case -6: {
                    chance = 815;
                    break;
                }
                case -7: {
                    chance = 800;
                    break;
                }
                case -8: {
                    chance = 785;
                    break;
                }
                case -9: {
                    chance = 770;
                    break;
                }
                case -10: {
                    chance = 755;
                    break;
                }
                case -11: {
                    chance = 735;
                    break;
                }
                case -12: {
                    chance = 715;
                    break;
                }
                case -13: {
                    chance = 695;
                    break;
                }
                case -14: {
                    chance = 675;
                    break;
                }
                case -15: {
                    chance = 655;
                    break;
                }
                case -16: {
                    chance = 625;
                    break;
                }
                case -17: {
                    chance = 595;
                    break;
                }
                case -18: {
                    chance = 565;
                    break;
                }
                case -19: {
                    chance = 535;
                    break;
                }
                case -20: {
                    chance = 505;
                    break;
                }
                case -21: {
                    chance = 455;
                    break;
                }
                case -22: {
                    chance = 405;
                    break;
                }
                case -23: {
                    chance = 355;
                    break;
                }
                case -24: {
                    chance = 305;
                    break;
                }
                default: {
                    chance = 275;
                }
            }
            if (!attacker.isInFrontOfTarget() && (chance = attacker.isBehindTarget() ? (int)((double)chance * 1.2) : (int)((double)chance * 1.1)) > 980) {
                chance = 980;
            }
        }
        return chance < Rnd.get(1000);
    }

    public static byte calcShldUse(L2Character attacker, L2Character target, L2Skill skill, boolean sendSysMsg) {
        if (skill != null && skill.ignoreShield()) {
            return 0;
        }
        L2Item item = target.getSecondaryWeaponItem();
        if (item == null || !(item instanceof L2Armor) || ((L2Armor)item).getItemType() == L2ArmorType.SIGIL) {
            return 0;
        }
        double shldRate = target.calcStat(Stats.SHIELD_RATE, 0.0, attacker, null) * BaseStats.DEX.calcBonus(target);
        if (shldRate == 0.0) {
            return 0;
        }
        int degreeside = (int)target.calcStat(Stats.SHIELD_DEFENCE_ANGLE, 0.0, null, null) + 120;
        if (degreeside < 360 && !target.isFacing(attacker, degreeside)) {
            return 0;
        }
        byte shldSuccess = 0;
        L2Weapon at_weapon = attacker.getActiveWeaponItem();
        if (at_weapon != null && at_weapon.getItemType() == L2WeaponType.BOW) {
            shldRate *= 1.3;
        }
        if (shldRate > 0.0 && 100 - Config.ALT_PERFECT_SHLD_BLOCK < Rnd.get(100)) {
            shldSuccess = 2;
        } else if (shldRate > (double)Rnd.get(100)) {
            shldSuccess = 1;
        }
        if (sendSysMsg && target instanceof L2PcInstance) {
            L2PcInstance enemy = (L2PcInstance)target;
            switch (shldSuccess) {
                case 1: {
                    enemy.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SHIELD_DEFENCE_SUCCESSFULL));
                    break;
                }
                case 2: {
                    enemy.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOUR_EXCELLENT_SHIELD_DEFENSE_WAS_A_SUCCESS));
                }
            }
        }
        return shldSuccess;
    }

    public static byte calcShldUse(L2Character attacker, L2Character target, L2Skill skill) {
        return Formulas.calcShldUse(attacker, target, skill, true);
    }

    public static byte calcShldUse(L2Character attacker, L2Character target) {
        return Formulas.calcShldUse(attacker, target, null, true);
    }

    public static boolean calcMagicAffected(L2Character actor, L2Character target, L2Skill skill) {
        L2SkillType type = skill.getSkillType();
        double defence = 0.0;
        if (skill.isActive() && skill.isOffensive() && !skill.isNeutral()) {
            defence = target.getMDef(actor, skill);
        }
        double attack = (double)(2 * actor.getMAtk(target, skill)) * (1.0 + Formulas.calcSkillVulnerability(actor, target, skill) / 100.0);
        double d = (attack - defence) / (attack + defence);
        if (target.isRaid()) {
            switch (type) {
                case CONFUSION: 
                case MUTE: 
                case PARALYZE: 
                case ROOT: 
                case FEAR: 
                case SLEEP: 
                case STUN: 
                case DEBUFF: 
                case AGGDEBUFF: {
                    return d > 0.0 && Rnd.get(1000) == 1;
                }
            }
        }
        return (d += 0.5 * Rnd.nextGaussian()) > 0.0;
    }

    public static double calcSkillVulnerability(L2Character attacker, L2Character target, L2Skill skill) {
        double multiplier = 0.0;
        if (skill != null) {
            Stats stat = skill.getStat();
            if (stat != null) {
                switch (stat) {
                    case AGGRESSION: {
                        multiplier = target.getTemplate().baseAggressionVuln;
                        break;
                    }
                    case BLEED: {
                        multiplier = target.getTemplate().baseBleedVuln;
                        break;
                    }
                    case POISON: {
                        multiplier = target.getTemplate().basePoisonVuln;
                        break;
                    }
                    case STUN: {
                        multiplier = target.getTemplate().baseStunVuln;
                        break;
                    }
                    case ROOT: {
                        multiplier = target.getTemplate().baseRootVuln;
                        break;
                    }
                    case MOVEMENT: {
                        multiplier = target.getTemplate().baseMovementVuln;
                        break;
                    }
                    case CONFUSION: {
                        multiplier = target.getTemplate().baseConfusionVuln;
                        break;
                    }
                    case SLEEP: {
                        multiplier = target.getTemplate().baseSleepVuln;
                    }
                }
            }
            L2SkillType type = skill.getSkillType();
            switch (type) {
                case PDAM: 
                case MDAM: 
                case BLOW: 
                case DRAIN: 
                case CHARGEDAM: 
                case FATAL: 
                case DEATHLINK: 
                case CPDAM: 
                case MANADAM: 
                case CPDAMPERCENT: {
                    type = skill.getEffectType();
                }
            }
            multiplier = Formulas.calcSkillTypeVulnerability(multiplier, target, type);
        }
        return multiplier;
    }

    public static double calcSkillTypeVulnerability(double multiplier, L2Character target, L2SkillType type) {
        if (type != null) {
            switch (type) {
                case BLEED: {
                    multiplier = target.calcStat(Stats.BLEED_VULN, multiplier, target, null);
                    break;
                }
                case POISON: {
                    multiplier = target.calcStat(Stats.POISON_VULN, multiplier, target, null);
                    break;
                }
                case STUN: {
                    multiplier = target.calcStat(Stats.STUN_VULN, multiplier, target, null);
                    break;
                }
                case PARALYZE: {
                    multiplier = target.calcStat(Stats.PARALYZE_VULN, multiplier, target, null);
                    break;
                }
                case ROOT: {
                    multiplier = target.calcStat(Stats.ROOT_VULN, multiplier, target, null);
                    break;
                }
                case SLEEP: {
                    multiplier = target.calcStat(Stats.SLEEP_VULN, multiplier, target, null);
                    break;
                }
                case MUTE: 
                case FEAR: 
                case AGGDEBUFF: 
                case BETRAY: 
                case ERASE: {
                    multiplier = target.calcStat(Stats.DERANGEMENT_VULN, multiplier, target, null);
                    break;
                }
                case CONFUSION: 
                case CONFUSE_MOB_ONLY: {
                    multiplier = target.calcStat(Stats.CONFUSION_VULN, multiplier, target, null);
                    break;
                }
                case DEBUFF: {
                    multiplier = target.calcStat(Stats.DEBUFF_VULN, multiplier, target, null);
                    break;
                }
                case BUFF: {
                    multiplier = target.calcStat(Stats.BUFF_VULN, multiplier, target, null);
                    break;
                }
                case CANCEL: {
                    multiplier = target.calcStat(Stats.CANCEL_VULN, multiplier, target, null);
                    break;
                }
            }
        }
        return multiplier;
    }

    public static double calcSkillProficiency(L2Skill skill, L2Character attacker, L2Character target) {
        double multiplier = 0.0;
        if (skill != null) {
            L2SkillType type = skill.getSkillType();
            switch (type) {
                case PDAM: 
                case MDAM: 
                case BLOW: 
                case DRAIN: 
                case CHARGEDAM: 
                case FATAL: 
                case DEATHLINK: 
                case CPDAM: 
                case MANADAM: 
                case CPDAMPERCENT: {
                    type = skill.getEffectType();
                }
            }
            multiplier = Formulas.calcSkillTypeProficiency(multiplier, attacker, target, type);
        }
        return multiplier;
    }

    public static double calcSkillTypeProficiency(double multiplier, L2Character attacker, L2Character target, L2SkillType type) {
        if (type != null) {
            switch (type) {
                case BLEED: {
                    multiplier = attacker.calcStat(Stats.BLEED_PROF, multiplier, target, null);
                    break;
                }
                case POISON: {
                    multiplier = attacker.calcStat(Stats.POISON_PROF, multiplier, target, null);
                    break;
                }
                case STUN: {
                    multiplier = attacker.calcStat(Stats.STUN_PROF, multiplier, target, null);
                    break;
                }
                case PARALYZE: {
                    multiplier = attacker.calcStat(Stats.PARALYZE_PROF, multiplier, target, null);
                    break;
                }
                case ROOT: {
                    multiplier = attacker.calcStat(Stats.ROOT_PROF, multiplier, target, null);
                    break;
                }
                case SLEEP: {
                    multiplier = attacker.calcStat(Stats.SLEEP_PROF, multiplier, target, null);
                    break;
                }
                case MUTE: 
                case FEAR: 
                case AGGDEBUFF: 
                case BETRAY: 
                case ERASE: {
                    multiplier = attacker.calcStat(Stats.DERANGEMENT_PROF, multiplier, target, null);
                    break;
                }
                case CONFUSION: 
                case CONFUSE_MOB_ONLY: {
                    multiplier = attacker.calcStat(Stats.CONFUSION_PROF, multiplier, target, null);
                    break;
                }
                case DEBUFF: {
                    multiplier = attacker.calcStat(Stats.DEBUFF_PROF, multiplier, target, null);
                    break;
                }
                case CANCEL: {
                    multiplier = attacker.calcStat(Stats.CANCEL_PROF, multiplier, target, null);
                    break;
                }
            }
        }
        return multiplier;
    }

    public static double calcSkillStatModifier(L2Skill skill, L2Character target) {
        BaseStats saveVs = skill.getSaveVs();
        if (saveVs == null) {
            return 1.0;
        }
        return 1.0 / saveVs.calcBonus(target);
    }

    public static int calcLvlDependModifier(L2Character attacker, L2Character target, L2Skill skill) {
        if (skill.getLevelDepend() == 0) {
            return 0;
        }
        int attackerMod = skill.getMagicLevel() > 0 ? skill.getMagicLevel() : attacker.getLevel();
        int delta = attackerMod - target.getLevel();
        int deltamod = delta / 5;
        if ((deltamod *= 5) != delta) {
            deltamod = delta < 0 ? (deltamod -= 5) : (deltamod += 5);
        }
        return deltamod;
    }

    public static int calcElementModifier(L2Character attacker, L2Character target, L2Skill skill) {
        byte element = skill.getElement();
        if (element == -1) {
            return 0;
        }
        int result = skill.getElementPower();
        if (attacker.getAttackElement() == element) {
            result += attacker.getAttackElementValue(element);
        }
        if ((result -= target.getDefenseElementValue(element)) < 0) {
            return 0;
        }
        return Math.round((float)result / 10.0f);
    }

    public static boolean calcEffectSuccess(L2Character attacker, L2Character target, EffectTemplate effect, L2Skill skill, byte shld, boolean ss, boolean sps, boolean bss) {
        L2SkillType type = effect.effectType;
        int value = (int)effect.effectPower;
        if (type == null) {
            if (attacker.isDebug()) {
                attacker.sendDebugMessage(skill.getName() + " effect ignoring resists");
            }
            return Rnd.get(100) < value;
        }
        if (type.equals((Object)L2SkillType.CANCEL)) {
            return true;
        }
        if (shld == 2) {
            if (attacker.isDebug()) {
                attacker.sendDebugMessage(skill.getName() + " effect blocked by shield");
            }
            return false;
        }
        double statModifier = Formulas.calcSkillStatModifier(skill, target);
        int rate = (int)((double)value * statModifier);
        double mAtkModifier = 0.0;
        int ssModifier = 0;
        if (skill.isMagic()) {
            mAtkModifier = target.getMDef(target, skill);
            if (shld == 1) {
                mAtkModifier += (double)target.getShldDef();
            }
            ssModifier = bss ? 4 : (sps ? 2 : 1);
            mAtkModifier = 14.0 * Math.sqrt(ssModifier * attacker.getMAtk(target, skill)) / mAtkModifier;
            rate = (int)((double)rate * mAtkModifier);
        }
        double vulnModifier = Formulas.calcSkillTypeVulnerability(0.0, target, type);
        double profModifier = Formulas.calcSkillTypeProficiency(0.0, attacker, target, type);
        double res = vulnModifier + profModifier;
        double resMod = 1.0;
        if (res != 0.0) {
            if (res < 0.0) {
                resMod = 1.0 - 0.075 * res;
                resMod = 1.0 / resMod;
            } else {
                resMod = 1.0 + 0.02 * res;
            }
            rate = (int)((double)rate * resMod);
        }
        int elementModifier = Formulas.calcElementModifier(attacker, target, skill);
        rate += elementModifier;
        int deltamod = Formulas.calcLvlDependModifier(attacker, target, skill);
        if ((rate += deltamod) > skill.getMaxChance()) {
            rate = skill.getMaxChance();
        } else if (rate < skill.getMinChance()) {
            rate = skill.getMinChance();
        }
        if (attacker.isDebug() || Config.DEVELOPER) {
            StringBuilder stat = new StringBuilder(100);
            StringUtil.append(stat, skill.getName(), " eff.type:", type.toString(), " power:", String.valueOf(value), " stat:", String.format("%1.2f", statModifier), " res:", String.format("%1.2f", resMod), "(", String.format("%1.2f", profModifier), "/", String.format("%1.2f", vulnModifier), ") elem:", String.valueOf(elementModifier), " mAtk:", String.format("%1.2f", mAtkModifier), " ss:", String.valueOf(ssModifier), " lvl:", String.valueOf(deltamod), " total:", String.valueOf(rate));
            String result = stat.toString();
            if (attacker.isDebug()) {
                attacker.sendDebugMessage(result);
            }
            if (Config.DEVELOPER) {
                _log.info(result);
            }
        }
        return Rnd.get(100) < rate;
    }

    public static boolean calcSkillSuccess(L2Character attacker, L2Character target, L2Skill skill, byte shld, boolean ss, boolean sps, boolean bss) {
        boolean isPvP;
        boolean bl = isPvP = attacker instanceof L2Playable && target instanceof L2Playable;
        if (skill.ignoreResists()) {
            if (attacker.isDebug()) {
                attacker.sendDebugMessage(skill.getName() + " ignoring resists");
            }
            return (double)Rnd.get(100) < skill.getPower(isPvP);
        }
        if (shld == 2) {
            if (attacker.isDebug()) {
                attacker.sendDebugMessage(skill.getName() + " blocked by shield");
            }
            return false;
        }
        int value = (int)skill.getPower(isPvP);
        double statModifier = Formulas.calcSkillStatModifier(skill, target);
        int rate = (int)((double)value * statModifier);
        double mAtkModifier = 0.0;
        int ssModifier = 0;
        if (skill.isMagic()) {
            mAtkModifier = target.getMDef(target, skill);
            if (shld == 1) {
                mAtkModifier += (double)target.getShldDef();
            }
            ssModifier = bss ? 4 : (sps ? 2 : 1);
            mAtkModifier = 14.0 * Math.sqrt(ssModifier * attacker.getMAtk(target, skill)) / mAtkModifier;
            rate = (int)((double)rate * mAtkModifier);
        }
        double vulnModifier = Formulas.calcSkillVulnerability(attacker, target, skill);
        double profModifier = Formulas.calcSkillProficiency(skill, attacker, target);
        double res = vulnModifier + profModifier;
        double resMod = 1.0;
        if (res != 0.0) {
            if (res < 0.0) {
                resMod = 1.0 - 0.075 * res;
                resMod = 1.0 / resMod;
            } else {
                resMod = 1.0 + 0.02 * res;
            }
            rate = (int)((double)rate * resMod);
        }
        int elementModifier = Formulas.calcElementModifier(attacker, target, skill);
        rate += elementModifier;
        int deltamod = Formulas.calcLvlDependModifier(attacker, target, skill);
        if ((rate += deltamod) > skill.getMaxChance()) {
            rate = skill.getMaxChance();
        } else if (rate < skill.getMinChance()) {
            rate = skill.getMinChance();
        }
        if (attacker.isDebug() || Config.DEVELOPER) {
            StringBuilder stat = new StringBuilder(100);
            StringUtil.append(stat, skill.getName(), " type:", skill.getSkillType().toString(), " power:", String.valueOf(value), " stat:", String.format("%1.2f", statModifier), " res:", String.format("%1.2f", resMod), "(", String.format("%1.2f", profModifier), "/", String.format("%1.2f", vulnModifier), ") elem:", String.valueOf(elementModifier), " mAtk:", String.format("%1.2f", mAtkModifier), " ss:", String.valueOf(ssModifier), " lvl:", String.valueOf(deltamod), " total:", String.valueOf(rate));
            String result = stat.toString();
            if (attacker.isDebug()) {
                attacker.sendDebugMessage(result);
            }
            if (Config.DEVELOPER) {
                _log.info(result);
            }
        }
        return Rnd.get(100) < rate;
    }

    public static boolean calcCubicSkillSuccess(L2CubicInstance attacker, L2Character target, L2Skill skill, byte shld) {
        if (shld == 2) {
            return false;
        }
        L2SkillType type = skill.getSkillType();
        if (target.isRaid()) {
            switch (type) {
                case CONFUSION: 
                case MUTE: 
                case PARALYZE: 
                case ROOT: 
                case FEAR: 
                case SLEEP: 
                case STUN: 
                case DEBUFF: 
                case AGGDEBUFF: {
                    return false;
                }
            }
        }
        if (Formulas.calcSkillReflect(target, skill) != 0) {
            return false;
        }
        int value = (int)skill.getPower(target instanceof L2Playable);
        double statModifier = Formulas.calcSkillStatModifier(skill, target);
        int rate = (int)((double)value * statModifier);
        double mAtkModifier = 0.0;
        if (skill.isMagic()) {
            mAtkModifier = target.getMDef(attacker.getOwner(), skill);
            if (shld == 1) {
                mAtkModifier += (double)target.getShldDef();
            }
            mAtkModifier = Math.pow((double)attacker.getMAtk() / mAtkModifier, 0.2);
            rate += (int)(mAtkModifier * 100.0) - 100;
        }
        double vulnModifier = Formulas.calcSkillVulnerability(attacker.getOwner(), target, skill);
        double profModifier = Formulas.calcSkillProficiency(skill, attacker.getOwner(), target);
        double res = vulnModifier + profModifier;
        double resMod = 1.0;
        if (res != 0.0) {
            if (res < 0.0) {
                resMod = 1.0 - 0.075 * res;
                resMod = 1.0 / resMod;
            } else {
                resMod = 1.0 + 0.02 * res;
            }
            rate = (int)((double)rate * resMod);
        }
        int elementModifier = Formulas.calcElementModifier(attacker.getOwner(), target, skill);
        rate += elementModifier;
        int deltamod = Formulas.calcLvlDependModifier(attacker.getOwner(), target, skill);
        if ((rate += deltamod) > skill.getMaxChance()) {
            rate = skill.getMaxChance();
        } else if (rate < skill.getMinChance()) {
            rate = skill.getMinChance();
        }
        if (attacker.getOwner().isDebug() || Config.DEVELOPER) {
            StringBuilder stat = new StringBuilder(100);
            StringUtil.append(stat, skill.getName(), " type:", skill.getSkillType().toString(), " power:", String.valueOf(value), " stat:", String.format("%1.2f", statModifier), " res:", String.format("%1.2f", resMod), "(", String.format("%1.2f", profModifier), "/", String.format("%1.2f", vulnModifier), ") elem:", String.valueOf(elementModifier), " mAtk:", String.format("%1.2f", mAtkModifier), " lvl:", String.valueOf(deltamod), " total:", String.valueOf(rate));
            String result = stat.toString();
            if (attacker.getOwner().isDebug()) {
                attacker.getOwner().sendDebugMessage(result);
            }
            if (Config.DEVELOPER) {
                _log.info(result);
            }
        }
        return Rnd.get(100) < rate;
    }

    public static boolean calcMagicSuccess(L2Character attacker, L2Character target, L2Skill skill) {
        double failureModifier;
        double resModifier;
        int rate;
        int lvlDifference = target.getLevel() - (skill.getSkillType() == L2SkillType.SPOIL ? skill.getMagicLevel() : attacker.getLevel());
        double lvlModifier = Math.pow(1.3, lvlDifference);
        float targetModifier = 1.0f;
        if (target instanceof L2Attackable && !target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Config.MIN_NPC_LVL_MAGIC_PENALTY && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 3) {
            int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 2;
            targetModifier = lvlDiff > Config.NPC_SKILL_CHANCE_PENALTY.size() ? Config.NPC_SKILL_CHANCE_PENALTY.get(Config.NPC_SKILL_CHANCE_PENALTY.size()) : Config.NPC_SKILL_CHANCE_PENALTY.get(lvlDiff);
        }
        if ((rate = 100 - Math.round((float)(lvlModifier * (double)targetModifier * (resModifier = target.calcStat(Stats.MAGIC_SUCCESS_RES, 1.0, null, skill)) * (failureModifier = attacker.calcStat(Stats.MAGIC_FAILURE_RATE, 1.0, target, skill))))) > skill.getMaxChance()) {
            rate = skill.getMaxChance();
        } else if (rate < skill.getMinChance()) {
            rate = skill.getMinChance();
        }
        if (attacker.isDebug() || Config.DEVELOPER) {
            StringBuilder stat = new StringBuilder(100);
            StringUtil.append(stat, skill.getName(), " lvlDiff:", String.valueOf(lvlDifference), " lvlMod:", String.format("%1.2f", lvlModifier), " res:", String.format("%1.2f", resModifier), " fail:", String.format("%1.2f", failureModifier), " tgt:", String.valueOf(targetModifier), " total:", String.valueOf(rate));
            String result = stat.toString();
            if (attacker.isDebug()) {
                attacker.sendDebugMessage(result);
            }
            if (Config.DEVELOPER) {
                _log.info(result);
            }
        }
        return Rnd.get(100) < rate;
    }

    public static double calcManaDam(L2Character attacker, L2Character target, L2Skill skill, boolean ss, boolean bss) {
        if (attacker instanceof L2Npc) {
            ss = ((L2Npc)attacker)._spiritshotcharged;
            ((L2Npc)attacker)._spiritshotcharged = false;
        }
        double mAtk = attacker.getMAtk(target, skill);
        double mDef = target.getMDef(attacker, skill);
        boolean isPvP = attacker instanceof L2Playable && target instanceof L2Playable;
        double mp = target.getMaxMp();
        if (bss) {
            mAtk *= 4.0;
        } else if (ss) {
            mAtk *= 2.0;
        }
        double damage = Math.sqrt(mAtk) * skill.getPower(attacker, target, isPvP) * (mp / 97.0) / mDef;
        damage *= 1.0 + Formulas.calcSkillVulnerability(attacker, target, skill) / 100.0;
        if (target instanceof L2Attackable) {
            damage *= attacker.calcStat(Stats.PVE_MAGICAL_DMG, 1.0, null, null);
            if (!target.isRaid() && !target.isRaidMinion() && target.getLevel() >= Config.MIN_NPC_LVL_DMG_PENALTY && attacker.getActingPlayer() != null && target.getLevel() - attacker.getActingPlayer().getLevel() >= 2) {
                int lvlDiff = target.getLevel() - attacker.getActingPlayer().getLevel() - 1;
                damage = lvlDiff > Config.NPC_SKILL_DMG_PENALTY.size() ? (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(Config.NPC_SKILL_DMG_PENALTY.size())) : (damage *= (double)Config.NPC_SKILL_DMG_PENALTY.get(lvlDiff));
            }
        }
        return damage;
    }

    public static double calculateSkillResurrectRestorePercent(double baseRestorePercent, L2Character caster) {
        if (baseRestorePercent == 0.0 || baseRestorePercent == 100.0) {
            return baseRestorePercent;
        }
        double restorePercent = baseRestorePercent * BaseStats.WIT.calcBonus(caster);
        if (restorePercent - baseRestorePercent > 20.0) {
            restorePercent += 20.0;
        }
        restorePercent = Math.max(restorePercent, baseRestorePercent);
        restorePercent = Math.min(restorePercent, 90.0);
        return restorePercent;
    }

    public static boolean calcPhysicalSkillEvasion(L2Character target, L2Skill skill) {
        if (skill.isMagic() && skill.getSkillType() != L2SkillType.BLOW || skill.isDebuff()) {
            return false;
        }
        return (double)Rnd.get(100) < target.calcStat(Stats.P_SKILL_EVASION, 0.0, null, skill);
    }

    public static boolean calcSkillMastery(L2Character actor, L2Skill sk) {
        if (sk.getSkillType() == L2SkillType.FISHING) {
            return false;
        }
        double val = actor.getStat().calcStat(Stats.SKILL_MASTERY, 0.0, null, null);
        if (actor instanceof L2PcInstance) {
            val = ((L2PcInstance)actor).isMageClass() ? (val *= BaseStats.INT.calcBonus(actor)) : (val *= BaseStats.STR.calcBonus(actor));
        }
        return (double)Rnd.get(100) < val;
    }

    public static double calcValakasAttribute(L2Character attacker, L2Character target, L2Skill skill) {
        double calcPower = 0.0;
        double calcDefen = 0.0;
        if (skill != null && skill.getAttributeName().contains("valakas")) {
            calcPower = attacker.calcStat(Stats.VALAKAS, calcPower, target, skill);
            calcDefen = target.calcStat(Stats.VALAKAS_RES, calcDefen, target, skill);
        } else if ((calcPower = attacker.calcStat(Stats.VALAKAS, calcPower, target, skill)) > 0.0) {
            calcPower = attacker.calcStat(Stats.VALAKAS, calcPower, target, skill);
            calcDefen = target.calcStat(Stats.VALAKAS_RES, calcDefen, target, skill);
        }
        return calcPower - calcDefen;
    }

    public static double calcElemental(L2Character attacker, L2Character target, L2Skill skill) {
        int calcPower = 0;
        int calcDefen = 0;
        int calcTotal = 0;
        double result = 1.0;
        if (skill != null) {
            byte element = skill.getElement();
            if (element >= 0) {
                calcPower = skill.getElementPower();
                calcDefen = target.getDefenseElementValue(element);
                if (attacker.getAttackElement() == element) {
                    calcPower += attacker.getAttackElementValue(element);
                }
                if ((calcTotal = calcPower - calcDefen) > 0) {
                    result = calcTotal < 50 ? (result += (double)calcTotal * 0.003948) : (calcTotal < 150 ? 1.1974 : (calcTotal < 300 ? 1.3973 : 1.6963));
                }
                if (Config.DEVELOPER) {
                    _log.info(skill.getName() + ": " + calcPower + ", " + calcDefen + ", " + result);
                }
            }
        } else {
            byte element = attacker.getAttackElement();
            if (element >= 0) {
                calcTotal = Math.max(attacker.getAttackElementValue(element) - target.getDefenseElementValue(element), 0);
                result = calcTotal < 50 ? (result += (double)calcTotal * 0.003948) : (calcTotal < 150 ? 1.1974 : (calcTotal < 300 ? 1.3973 : 1.6963));
                if (Config.DEVELOPER) {
                    _log.info("Hit: " + calcPower + ", " + calcDefen + ", " + result);
                }
            }
        }
        return result;
    }

    public static byte calcSkillReflect(L2Character target, L2Skill skill) {
        if (skill.ignoreResists() || !skill.canBeReflected()) {
            return 0;
        }
        if (!(skill.isMagic() || skill.getCastRange() != -1 && skill.getCastRange() <= 40)) {
            return 0;
        }
        byte reflect = 0;
        switch (skill.getSkillType()) {
            case AGGDEBUFF: 
            case BUFF: 
            case HEAL_PERCENT: 
            case MANAHEAL_PERCENT: 
            case HOT: 
            case CPHOT: 
            case MPHOT: 
            case UNDEAD_DEFENSE: 
            case CONT: {
                return 0;
            }
            case PDAM: 
            case MDAM: 
            case BLOW: 
            case DRAIN: 
            case CHARGEDAM: 
            case FATAL: 
            case DEATHLINK: 
            case CPDAM: 
            case MANADAM: 
            case CPDAMPERCENT: {
                Stats stat = skill.isMagic() ? Stats.VENGEANCE_SKILL_MAGIC_DAMAGE : Stats.VENGEANCE_SKILL_PHYSICAL_DAMAGE;
                double venganceChance = target.getStat().calcStat(stat, 0.0, target, skill);
                if (!(venganceChance > (double)Rnd.get(100))) break;
                reflect = (byte)(reflect | 2);
            }
        }
        double reflectChance = target.calcStat(skill.isMagic() ? Stats.REFLECT_SKILL_MAGIC : Stats.REFLECT_SKILL_PHYSIC, 0.0, null, skill);
        if ((double)Rnd.get(100) < reflectChance) {
            reflect = (byte)(reflect | 1);
        }
        return reflect;
    }

    public static double calcFallDam(L2Character cha, int fallHeight) {
        if (!Config.ENABLE_FALLING_DAMAGE || fallHeight < 0) {
            return 0.0;
        }
        double damage = cha.calcStat(Stats.FALL, fallHeight * cha.getMaxHp() / 1000, null, null);
        return damage;
    }

    public static boolean calcBlowSuccess(L2Character activeChar, L2Character target, L2Skill skill) {
        int blowChance = skill.getBlowChance();
        if (blowChance == 0) {
            _log.log(Level.WARNING, "Skill " + skill.getId() + " - " + skill.getName() + " has 0 blow land chance, yet its a blow skill!");
            blowChance = 20;
        }
        if (Formulas.isBehind(target, activeChar)) {
            blowChance *= 2;
        } else if (Formulas.isInFrontOf(target, activeChar)) {
            if ((skill.getCondition() & 8) != 0) {
                return false;
            }
        } else {
            blowChance = (int)((double)blowChance * 1.5);
        }
        return activeChar.calcStat(Stats.BLOW_RATE, (double)blowChance * (1.0 + (double)activeChar.getDEX() / 100.0), target, null) > (double)Rnd.get(100);
    }

    public static boolean isInFrontOf(L2Character target, L2Character attacker) {
        if (target == null) {
            return false;
        }
        double angleTarget = Util.calculateAngleFrom(target, attacker);
        double angleChar = Util.convertHeadingToDegree(target.getHeading());
        double angleDiff = angleChar - angleTarget;
        if (angleDiff <= -360.0 + FRONT_MAX_ANGLE) {
            angleDiff += 360.0;
        }
        if (angleDiff >= 360.0 - FRONT_MAX_ANGLE) {
            angleDiff -= 360.0;
        }
        return Math.abs(angleDiff) <= FRONT_MAX_ANGLE;
    }

    public static boolean isBehind(L2Character target, L2Character attacker) {
        double angleTarget;
        if (target == null) {
            return false;
        }
        L2Character target1 = target;
        double angleChar = Util.calculateAngleFrom(attacker, target1);
        double angleDiff = angleChar - (angleTarget = Util.convertHeadingToDegree(target1.getHeading()));
        if (angleDiff <= -360.0 + BACK_MAX_ANGLE) {
            angleDiff += 360.0;
        }
        if (angleDiff >= 360.0 - BACK_MAX_ANGLE) {
            angleDiff -= 360.0;
        }
        return Math.abs(angleDiff) <= BACK_MAX_ANGLE;
    }

    static class FuncMaxMpMul
    extends Func {
        static final FuncMaxMpMul _fmmm_instance = new FuncMaxMpMul();

        static Func getInstance() {
            return _fmmm_instance;
        }

        private FuncMaxMpMul() {
            super(Stats.MAX_MP, 32, null);
        }

        @Override
        public void calc(Env env) {
            env.value *= BaseStats.MEN.calcBonus(env.player);
        }
    }

    static class FuncMaxMpAdd
    extends Func {
        static final FuncMaxMpAdd _fmma_instance = new FuncMaxMpAdd();

        static Func getInstance() {
            return _fmma_instance;
        }

        private FuncMaxMpAdd() {
            super(Stats.MAX_MP, 16, null);
        }

        @Override
        public void calc(Env env) {
            L2PcTemplate t = (L2PcTemplate)env.player.getTemplate();
            int lvl = env.player.getLevel() - t.classBaseLevel;
            double mpmod = t.lvlMpMod * (float)lvl;
            double mpmax = ((double)t.lvlMpAdd + mpmod) * (double)lvl;
            double mpmin = (double)(t.lvlMpAdd * (float)lvl) + mpmod;
            env.value += (mpmax + mpmin) / 2.0;
        }
    }

    static class FuncMaxCpMul
    extends Func {
        static final FuncMaxCpMul _fmcm_instance = new FuncMaxCpMul();

        static Func getInstance() {
            return _fmcm_instance;
        }

        private FuncMaxCpMul() {
            super(Stats.MAX_CP, 32, null);
        }

        @Override
        public void calc(Env env) {
            env.value *= BaseStats.CON.calcBonus(env.player);
        }
    }

    static class FuncMaxCpAdd
    extends Func {
        static final FuncMaxCpAdd _fmca_instance = new FuncMaxCpAdd();

        static Func getInstance() {
            return _fmca_instance;
        }

        private FuncMaxCpAdd() {
            super(Stats.MAX_CP, 16, null);
        }

        @Override
        public void calc(Env env) {
            L2PcTemplate t = (L2PcTemplate)env.player.getTemplate();
            int lvl = env.player.getLevel() - t.classBaseLevel;
            double cpmod = t.lvlCpMod * (float)lvl;
            double cpmax = ((double)t.lvlCpAdd + cpmod) * (double)lvl;
            double cpmin = (double)(t.lvlCpAdd * (float)lvl) + cpmod;
            env.value += (cpmax + cpmin) / 2.0;
        }
    }

    static class FuncMaxHpMul
    extends Func {
        static final FuncMaxHpMul _fmhm_instance = new FuncMaxHpMul();

        static Func getInstance() {
            return _fmhm_instance;
        }

        private FuncMaxHpMul() {
            super(Stats.MAX_HP, 32, null);
        }

        @Override
        public void calc(Env env) {
            env.value *= BaseStats.CON.calcBonus(env.player);
        }
    }

    static class FuncMaxHpAdd
    extends Func {
        static final FuncMaxHpAdd _fmha_instance = new FuncMaxHpAdd();

        static Func getInstance() {
            return _fmha_instance;
        }

        private FuncMaxHpAdd() {
            super(Stats.MAX_HP, 16, null);
        }

        @Override
        public void calc(Env env) {
            L2PcTemplate t = (L2PcTemplate)env.player.getTemplate();
            int lvl = env.player.getLevel() - t.classBaseLevel;
            double hpmod = t.lvlHpMod * (float)lvl;
            double hpmax = ((double)t.lvlHpAdd + hpmod) * (double)lvl;
            double hpmin = (double)(t.lvlHpAdd * (float)lvl) + hpmod;
            env.value += (hpmax + hpmin) / 2.0;
        }
    }

    static class FuncHennaWIT
    extends Func {
        static final FuncHennaWIT _fh_instance = new FuncHennaWIT();

        static Func getInstance() {
            return _fh_instance;
        }

        private FuncHennaWIT() {
            super(Stats.STAT_WIT, 16, null);
        }

        @Override
        public void calc(Env env) {
            L2PcInstance pc = (L2PcInstance)env.player;
            if (pc != null) {
                env.value += (double)pc.getHennaStatWIT();
            }
        }
    }

    static class FuncHennaCON
    extends Func {
        static final FuncHennaCON _fh_instance = new FuncHennaCON();

        static Func getInstance() {
            return _fh_instance;
        }

        private FuncHennaCON() {
            super(Stats.STAT_CON, 16, null);
        }

        @Override
        public void calc(Env env) {
            L2PcInstance pc = (L2PcInstance)env.player;
            if (pc != null) {
                env.value += (double)pc.getHennaStatCON();
            }
        }
    }

    static class FuncHennaMEN
    extends Func {
        static final FuncHennaMEN _fh_instance = new FuncHennaMEN();

        static Func getInstance() {
            return _fh_instance;
        }

        private FuncHennaMEN() {
            super(Stats.STAT_MEN, 16, null);
        }

        @Override
        public void calc(Env env) {
            L2PcInstance pc = (L2PcInstance)env.player;
            if (pc != null) {
                env.value += (double)pc.getHennaStatMEN();
            }
        }
    }

    static class FuncHennaINT
    extends Func {
        static final FuncHennaINT _fh_instance = new FuncHennaINT();

        static Func getInstance() {
            return _fh_instance;
        }

        private FuncHennaINT() {
            super(Stats.STAT_INT, 16, null);
        }

        @Override
        public void calc(Env env) {
            L2PcInstance pc = (L2PcInstance)env.player;
            if (pc != null) {
                env.value += (double)pc.getHennaStatINT();
            }
        }
    }

    static class FuncHennaDEX
    extends Func {
        static final FuncHennaDEX _fh_instance = new FuncHennaDEX();

        static Func getInstance() {
            return _fh_instance;
        }

        private FuncHennaDEX() {
            super(Stats.STAT_DEX, 16, null);
        }

        @Override
        public void calc(Env env) {
            L2PcInstance pc = (L2PcInstance)env.player;
            if (pc != null) {
                env.value += (double)pc.getHennaStatDEX();
            }
        }
    }

    static class FuncHennaSTR
    extends Func {
        static final FuncHennaSTR _fh_instance = new FuncHennaSTR();

        static Func getInstance() {
            return _fh_instance;
        }

        private FuncHennaSTR() {
            super(Stats.STAT_STR, 16, null);
        }

        @Override
        public void calc(Env env) {
            L2PcInstance pc = (L2PcInstance)env.player;
            if (pc != null) {
                env.value += (double)pc.getHennaStatSTR();
            }
        }
    }

    static class FuncMAtkSpeed
    extends Func {
        static final FuncMAtkSpeed _fas_instance = new FuncMAtkSpeed();

        static Func getInstance() {
            return _fas_instance;
        }

        private FuncMAtkSpeed() {
            super(Stats.MAGIC_ATTACK_SPEED, 32, null);
        }

        @Override
        public void calc(Env env) {
            env.value *= BaseStats.WIT.calcBonus(env.player);
        }
    }

    static class FuncPAtkSpeed
    extends Func {
        static final FuncPAtkSpeed _fas_instance = new FuncPAtkSpeed();

        static Func getInstance() {
            return _fas_instance;
        }

        private FuncPAtkSpeed() {
            super(Stats.POWER_ATTACK_SPEED, 32, null);
        }

        @Override
        public void calc(Env env) {
            env.value *= BaseStats.DEX.calcBonus(env.player);
        }
    }

    static class FuncMoveSpeed
    extends Func {
        static final FuncMoveSpeed _fms_instance = new FuncMoveSpeed();

        static Func getInstance() {
            return _fms_instance;
        }

        private FuncMoveSpeed() {
            super(Stats.RUN_SPEED, 48, null);
        }

        @Override
        public void calc(Env env) {
            env.value *= BaseStats.DEX.calcBonus(env.player);
        }
    }

    static class FuncMAtkCritical
    extends Func {
        static final FuncMAtkCritical _fac_instance = new FuncMAtkCritical();

        static Func getInstance() {
            return _fac_instance;
        }

        private FuncMAtkCritical() {
            super(Stats.MCRITICAL_RATE, 48, null);
        }

        @Override
        public void calc(Env env) {
            L2Character p = env.player;
            if (p instanceof L2Summon) {
                env.value = 8.0;
            } else if (p instanceof L2PcInstance && p.getActiveWeaponInstance() != null) {
                env.value *= BaseStats.WIT.calcBonus(p);
            }
        }
    }

    static class FuncAtkCritical
    extends Func {
        static final FuncAtkCritical _fac_instance = new FuncAtkCritical();

        static Func getInstance() {
            return _fac_instance;
        }

        private FuncAtkCritical() {
            super(Stats.CRITICAL_RATE, 9, null);
        }

        @Override
        public void calc(Env env) {
            env.value *= BaseStats.DEX.calcBonus(env.player);
            env.value *= 10.0;
            env.baseValue = env.value;
        }
    }

    static class FuncAtkEvasion
    extends Func {
        static final FuncAtkEvasion _fae_instance = new FuncAtkEvasion();

        static Func getInstance() {
            return _fae_instance;
        }

        private FuncAtkEvasion() {
            super(Stats.EVASION_RATE, 16, null);
        }

        @Override
        public void calc(Env env) {
            int level = env.player.getLevel();
            if (env.player instanceof L2PcInstance) {
                env.value += Math.sqrt(env.player.getDEX()) * 6.0;
                env.value += (double)level;
                if (level > 77) {
                    env.value += (double)(level - 77);
                }
                if (level > 69) {
                    env.value += (double)(level - 69);
                }
            } else {
                env.value += Math.sqrt(env.player.getDEX()) * 6.0;
                env.value += (double)level;
                if (level > 69) {
                    env.value += (double)(level - 69 + 2);
                }
            }
        }
    }

    static class FuncAtkAccuracy
    extends Func {
        static final FuncAtkAccuracy _faa_instance = new FuncAtkAccuracy();

        static Func getInstance() {
            return _faa_instance;
        }

        private FuncAtkAccuracy() {
            super(Stats.ACCURACY_COMBAT, 16, null);
        }

        @Override
        public void calc(Env env) {
            int level = env.player.getLevel();
            if (env.player instanceof L2PcInstance) {
                env.value += Math.sqrt(env.player.getDEX()) * 6.0;
                env.value += (double)level;
                if (level > 77) {
                    env.value += (double)(level - 77 + 1);
                }
                if (level > 69) {
                    env.value += (double)(level - 69);
                }
            } else {
                env.value += Math.sqrt(env.player.getDEX()) * 6.0;
                env.value += (double)level;
                if (level > 77) {
                    env.value += (double)(level - 76);
                }
                if (level > 69) {
                    env.value += (double)(level - 69);
                }
            }
        }
    }

    static class FuncCrossBowAtkRange
    extends Func {
        private static final FuncCrossBowAtkRange _fcb_instance = new FuncCrossBowAtkRange();

        static Func getInstance() {
            return _fcb_instance;
        }

        private FuncCrossBowAtkRange() {
            super(Stats.POWER_ATTACK_RANGE, 16, null);
            this.setCondition(new ConditionUsingItemType(L2WeaponType.CROSSBOW.mask()));
        }

        @Override
        public void calc(Env env) {
            if (!this.cond.test(env)) {
                return;
            }
            env.value += 360.0;
        }
    }

    static class FuncBowAtkRange
    extends Func {
        private static final FuncBowAtkRange _fbar_instance = new FuncBowAtkRange();

        static Func getInstance() {
            return _fbar_instance;
        }

        private FuncBowAtkRange() {
            super(Stats.POWER_ATTACK_RANGE, 16, null);
            this.setCondition(new ConditionUsingItemType(L2WeaponType.BOW.mask()));
        }

        @Override
        public void calc(Env env) {
            if (!this.cond.test(env)) {
                return;
            }
            env.value += 460.0;
        }
    }

    static class FuncGatesMDefMod
    extends Func {
        static final FuncGatesMDefMod _fmm_instance = new FuncGatesMDefMod();

        static Func getInstance() {
            return _fmm_instance;
        }

        private FuncGatesMDefMod() {
            super(Stats.MAGIC_DEFENCE, 32, null);
        }

        @Override
        public void calc(Env env) {
            if (SevenSigns.getInstance().getSealOwner(3) == 2) {
                env.value *= Config.ALT_SIEGE_DAWN_GATES_MDEF_MULT;
            } else if (SevenSigns.getInstance().getSealOwner(3) == 1) {
                env.value *= Config.ALT_SIEGE_DUSK_GATES_MDEF_MULT;
            }
        }
    }

    static class FuncGatesPDefMod
    extends Func {
        static final FuncGatesPDefMod _fmm_instance = new FuncGatesPDefMod();

        static Func getInstance() {
            return _fmm_instance;
        }

        private FuncGatesPDefMod() {
            super(Stats.POWER_DEFENCE, 32, null);
        }

        @Override
        public void calc(Env env) {
            if (SevenSigns.getInstance().getSealOwner(3) == 2) {
                env.value *= Config.ALT_SIEGE_DAWN_GATES_PDEF_MULT;
            } else if (SevenSigns.getInstance().getSealOwner(3) == 1) {
                env.value *= Config.ALT_SIEGE_DUSK_GATES_PDEF_MULT;
            }
        }
    }

    static class FuncPDefMod
    extends Func {
        static final FuncPDefMod _fmm_instance = new FuncPDefMod();

        static Func getInstance() {
            return _fmm_instance;
        }

        private FuncPDefMod() {
            super(Stats.POWER_DEFENCE, 32, null);
        }

        @Override
        public void calc(Env env) {
            if (env.player instanceof L2PcInstance) {
                L2ItemInstance chest;
                boolean hasMagePDef;
                L2PcInstance p = (L2PcInstance)env.player;
                boolean bl = hasMagePDef = p.getClassId().isMage() || p.getClassId().getId() == 49;
                if (p.getInventory().getPaperdollItem(1) != null) {
                    env.value -= 12.0;
                }
                if ((chest = p.getInventory().getPaperdollItem(6)) != null) {
                    env.value = env.value - (hasMagePDef ? 15.0 : 31.0);
                }
                if (p.getInventory().getPaperdollItem(11) != null || chest != null && chest.getItem().getBodyPart() == 32768) {
                    env.value = env.value - (hasMagePDef ? 8.0 : 18.0);
                }
                if (p.getInventory().getPaperdollItem(10) != null) {
                    env.value -= 8.0;
                }
                if (p.getInventory().getPaperdollItem(12) != null) {
                    env.value -= 7.0;
                }
                env.value *= env.player.getLevelMod();
            } else {
                float level = env.player.getLevel();
                env.value *= (double)((level + 89.0f) / 100.0f);
            }
        }
    }

    static class FuncMDefMod
    extends Func {
        static final FuncMDefMod _fmm_instance = new FuncMDefMod();

        static Func getInstance() {
            return _fmm_instance;
        }

        private FuncMDefMod() {
            super(Stats.MAGIC_DEFENCE, 32, null);
        }

        @Override
        public void calc(Env env) {
            float level = env.player.getLevel();
            if (env.player instanceof L2PcInstance) {
                L2PcInstance p = (L2PcInstance)env.player;
                if (p.getInventory().getPaperdollItem(14) != null) {
                    env.value -= 5.0;
                }
                if (p.getInventory().getPaperdollItem(13) != null) {
                    env.value -= 5.0;
                }
                if (p.getInventory().getPaperdollItem(9) != null) {
                    env.value -= 9.0;
                }
                if (p.getInventory().getPaperdollItem(8) != null) {
                    env.value -= 9.0;
                }
                if (p.getInventory().getPaperdollItem(4) != null) {
                    env.value -= 13.0;
                }
                env.value *= BaseStats.MEN.calcBonus(env.player) * env.player.getLevelMod();
            } else if (env.player instanceof L2PetInstance) {
                if (env.player.getInventory().getPaperdollObjectId(4) != 0) {
                    env.value *= BaseStats.MEN.calcBonus(env.player);
                    return;
                }
            } else {
                env.value *= BaseStats.MEN.calcBonus(env.player) * (double)((level + 89.0f) / 100.0f);
            }
        }
    }

    static class FuncMAtkMod
    extends Func {
        static final FuncMAtkMod _fma_instance = new FuncMAtkMod();

        static Func getInstance() {
            return _fma_instance;
        }

        private FuncMAtkMod() {
            super(Stats.MAGIC_ATTACK, 32, null);
        }

        @Override
        public void calc(Env env) {
            if (env.player instanceof L2PcInstance) {
                double intb = BaseStats.INT.calcBonus(env.player);
                double lvlb = env.player.getLevelMod();
                env.value *= lvlb * lvlb * (intb * intb);
            } else {
                float level = env.player.getLevel();
                double intb = BaseStats.INT.calcBonus(env.player);
                float lvlb = (level + 89.0f) / 100.0f;
                env.value *= (double)(lvlb * lvlb) * (intb * intb);
            }
        }
    }

    static class FuncPAtkMod
    extends Func {
        static final FuncPAtkMod _fpa_instance = new FuncPAtkMod();

        static Func getInstance() {
            return _fpa_instance;
        }

        private FuncPAtkMod() {
            super(Stats.POWER_ATTACK, 48, null);
        }

        @Override
        public void calc(Env env) {
            if (env.player instanceof L2PcInstance) {
                env.value *= BaseStats.STR.calcBonus(env.player) * env.player.getLevelMod();
            } else {
                float level = env.player.getLevel();
                env.value *= BaseStats.STR.calcBonus(env.player) * (double)((level + 89.0f) / 100.0f);
            }
        }
    }

    static class FuncMultRegenResting
    extends Func {
        static final FuncMultRegenResting[] _instancies = new FuncMultRegenResting[Stats.NUM_STATS];

        static Func getInstance(Stats stat) {
            int pos = stat.ordinal();
            if (_instancies[pos] == null) {
                FuncMultRegenResting._instancies[pos] = new FuncMultRegenResting(stat);
            }
            return _instancies[pos];
        }

        private FuncMultRegenResting(Stats pStat) {
            super(pStat, 32, null);
            this.setCondition(new ConditionPlayerState(PlayerState.RESTING, true));
        }

        @Override
        public void calc(Env env) {
            if (!this.cond.test(env)) {
                return;
            }
            env.value *= 1.45;
        }
    }

    static class FuncMultLevelMod
    extends Func {
        static final FuncMultLevelMod[] _instancies = new FuncMultLevelMod[Stats.NUM_STATS];

        static Func getInstance(Stats stat) {
            int pos = stat.ordinal();
            if (_instancies[pos] == null) {
                FuncMultLevelMod._instancies[pos] = new FuncMultLevelMod(stat);
            }
            return _instancies[pos];
        }

        private FuncMultLevelMod(Stats pStat) {
            super(pStat, 32, null);
        }

        @Override
        public void calc(Env env) {
            env.value *= env.player.getLevelMod();
        }
    }

    static class FuncAddLevel3
    extends Func {
        static final FuncAddLevel3[] _instancies = new FuncAddLevel3[Stats.NUM_STATS];

        static Func getInstance(Stats stat) {
            int pos = stat.ordinal();
            if (_instancies[pos] == null) {
                FuncAddLevel3._instancies[pos] = new FuncAddLevel3(stat);
            }
            return _instancies[pos];
        }

        private FuncAddLevel3(Stats pStat) {
            super(pStat, 16, null);
        }

        @Override
        public void calc(Env env) {
            env.value += (double)env.player.getLevel() / 3.0;
        }
    }
}

