## Active Perl 5.8.8
use utf8;
use warnings;
use strict;
binmode STDOUT,'encoding(cp932)';

open CSV, '<:utf8', 'temp/instantzonedata-j.txt'  or die $!;
my $mtime = (stat CSV)[9];

open TXT, '>:utf8', 'instancenames.xml'  or die $!;
print TXT '<?xml version="1.0" encoding="UTF-8"?>
<instances_list xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="instancenames.xsd">
';

<CSV>; # skip header
while (not eof CSV) {
	my $buf = <CSV>;
	chomp $buf;
	my @field = split /\t/, $buf;
	foreach (@field) {s/^[ua],//; s/\\0//; s/\\\\n/\\n/g}
	my ($instance_id,$instance_name) = ($field[0],$field[1]);
	print "$instance_id\r";
	print TXT '	<instance id="', (1+$instance_id), '" name="', $instance_name, '" />', "\n";
}
print TXT '</instances_list>';
close TXT;
utime $mtime,$mtime,'instantzonedata.txt';

close CSV;
print "\n";
