DROP TABLE IF EXISTS `clanhall_siege_guards`;
CREATE TABLE IF NOT EXISTS `clanhall_siege_guards` (
  `clanHallId` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `npcId` smallint(5) unsigned NOT NULL DEFAULT '0',
  `x` mediumint(6) NOT NULL DEFAULT '0',
  `y` mediumint(6) NOT NULL DEFAULT '0',
  `z` mediumint(6) NOT NULL DEFAULT '0',
  `heading` mediumint(6) NOT NULL DEFAULT '0',
  `respawnDelay` mediumint(5) NOT NULL DEFAULT '0',
  `isSiegeBoss` enum('false','true') NOT NULL DEFAULT 'false'
);

INSERT INTO `clanhall_siege_guards` VALUES
-- Devasted Castle
-- Front Gate
(34,35413,178222,-14944,-2200,16384,7200,'false'),
(34,35413,178255,-14944,-2200,16384,7200,'false'),
(34,35413,178288,-14944,-2200,16384,7200,'false'),
(34,35413,178321,-14944,-2200,16384,7200,'false'),
(34,35413,178354,-14944,-2200,16384,7200,'false'),
(34,35413,178387,-14944,-2200,16384,7200,'false'),
(34,35413,178420,-14944,-2200,16384,7200,'false'),
(34,35413,178454,-14944,-2200,16384,7200,'false'),
(34,35413,178222,-14924,-2200,16384,7200,'false'),
(34,35413,178255,-14924,-2200,16384,7200,'false'),
(34,35413,178288,-14924,-2200,16384,7200,'false'),
(34,35413,178321,-14924,-2200,16384,7200,'false'),
(34,35413,178354,-14924,-2200,16384,7200,'false'),
(34,35413,178387,-14924,-2200,16384,7200,'false'),
(34,35413,178420,-14924,-2200,16384,7200,'false'),
(34,35413,178454,-14924,-2200,16384,7200,'false'),
(34,35412,178222,-14904,-2200,16384,7200,'false'),
(34,35412,178255,-14904,-2200,16384,7200,'false'),
(34,35412,178288,-14904,-2200,16384,7200,'false'),
(34,35412,178321,-14904,-2200,16384,7200,'false'),
(34,35412,178354,-14904,-2200,16384,7200,'false'),
(34,35412,178387,-14904,-2200,16384,7200,'false'),
(34,35412,178420,-14904,-2200,16384,7200,'false'),
(34,35412,178454,-14904,-2200,16384,7200,'false'),
(34,35412,178222,-14884,-2200,16384,7200,'false'),
(34,35412,178255,-14884,-2200,16384,7200,'false'),
(34,35412,178288,-14884,-2200,16384,7200,'false'),
(34,35412,178321,-14884,-2200,16384,7200,'false'),
(34,35412,178354,-14884,-2200,16384,7200,'false'),
(34,35412,178387,-14884,-2200,16384,7200,'false'),
(34,35412,178420,-14884,-2200,16384,7200,'false'),
(34,35412,178454,-14884,-2200,16384,7200,'false'),
-- East Terrace
(34,35413,178801,-14975,-2080,16384,7200,'false'),
(34,35413,178822,-14936,-2080,16384,7200,'false'),
(34,35413,178843,-14897,-2080,16384,7200,'false'),
(34,35413,178865,-14857,-2080,16384,7200,'false'),
(34,35413,178886,-14818,-2080,16384,7200,'false'),
(34,35413,178908,-14778,-2080,16384,7200,'false'),
(34,35413,178929,-14739,-2080,16384,7200,'false'),
(34,35413,178951,-14699,-2080,16384,7200,'false'),
-- West Terrace
(34,35413,177834,-15015,-2210,16384,7200,'false'),
(34,35413,177803,-14971,-2210,16384,7200,'false'),
(34,35413,177772,-14927,-2210,16384,7200,'false'),
(34,35413,177741,-14883,-2210,16384,7200,'false'),
(34,35413,177711,-14838,-2210,16384,7200,'false'),
(34,35413,177680,-14794,-2210,16384,7200,'false'),
(34,35413,177649,-14750,-2210,16384,7200,'false'),
(34,35413,177619,-14705,-2210,16384,7200,'false'),
-- Area 2 (back wall of resistance)
(34,35413,178640,-18216,-2200,-16384,7200,'false'),
(34,35413,178661,-18218,-2200,-16384,7200,'false'),
(34,35413,178682,-18220,-2200,-16384,7200,'false'),
(34,35413,178703,-18222,-2200,-16384,7200,'false'),
(34,35413,178724,-18224,-2200,-16384,7200,'false'),
(34,35413,178745,-18226,-2200,-16384,7200,'false'),
(34,35413,178766,-18228,-2200,-16384,7200,'false'),
(34,35413,178788,-18229,-2200,-16384,7200,'false'),
(34,35414,178640,-18196,-2200,-16384,7200,'false'),
(34,35414,178661,-18198,-2200,-16384,7200,'false'),
(34,35414,178682,-18200,-2200,-16384,7200,'false'),
(34,35414,178703,-18202,-2200,-16384,7200,'false'),
(34,35414,178724,-18204,-2200,-16384,7200,'false'),
(34,35414,178745,-18206,-2200,-16384,7200,'false'),
(34,35414,178766,-18208,-2200,-16384,7200,'false'),
(34,35414,178788,-18209,-2200,-16384,7200,'false'),
(34,35412,178640,-18176,-2200,-16384,7200,'false'),
(34,35412,178661,-18178,-2200,-16384,7200,'false'),
(34,35412,178682,-18180,-2200,-16384,7200,'false'),
(34,35412,178703,-18182,-2200,-16384,7200,'false'),
(34,35412,178724,-18184,-2200,-16384,7200,'false'),
(34,35412,178745,-18186,-2200,-16384,7200,'false'),
(34,35412,178766,-18188,-2200,-16384,7200,'false'),
(34,35412,178788,-18189,-2200,-16384,7200,'false'),
-- Area 3
(34,35413,177335,-17128,-2200,16384,7200,'false'),
(34,35413,177305,-17128,-2200,16384,7200,'false'),
(34,35413,177276,-17128,-2200,16384,7200,'false'),
(34,35413,177246,-17128,-2200,16384,7200,'false'),
(34,35413,177217,-17128,-2200,16384,7200,'false'),
(34,35413,177187,-17128,-2200,16384,7200,'false'),
(34,35413,177158,-17128,-2200,16384,7200,'false'),
(34,35413,177129,-17128,-2200,16384,7200,'false'),
(34,35414,177335,-17148,-2200,16384,7200,'false'),
(34,35414,177305,-17148,-2200,16384,7200,'false'),
(34,35414,177276,-17148,-2200,16384,7200,'false'),
(34,35414,177246,-17148,-2200,16384,7200,'false'),
(34,35414,177217,-17148,-2200,16384,7200,'false'),
(34,35414,177187,-17148,-2200,16384,7200,'false'),
(34,35414,177158,-17148,-2200,16384,7200,'false'),
(34,35414,177129,-17148,-2200,16384,7200,'false'),
(34,35412,177335,-17168,-2200,16384,7200,'false'),
(34,35412,177305,-17168,-2200,16384,7200,'false'),
(34,35412,177276,-17168,-2200,16384,7200,'false'),
(34,35412,177246,-17168,-2200,16384,7200,'false'),
(34,35412,177217,-17168,-2200,16384,7200,'false'),
(34,35412,177187,-17168,-2200,16384,7200,'false'),
(34,35412,177158,-17168,-2200,16384,7200,'false'),
(34,35412,177129,-17168,-2200,16384,7200,'false'),
-- Region 1 (left)
(34,35413,177707,-15427,-2226,3000,7200,'false'),
(34,35413,177727,-15464,-2226,3000,7200,'false'),
(34,35413,177680,-15485,-2226,3000,7200,'false'),
(34,35413,177745,-15498,-2226,3000,7200,'false'),
(34,35413,177769,-15540,-2226,3000,7200,'false'),
(34,35413,177722,-15561,-2226,3000,7200,'false'),
(34,35413,177788,-15578,-2226,3000,7200,'false'),
(34,35413,177811,-15622,-2226,3000,7200,'false'),
(34,35413,177765,-15643,-2226,3000,7200,'false'),
(34,35413,177838,-15664,-2226,3000,7200,'false'),
(34,35413,177859,-15704,-2226,3000,7200,'false'),
(34,35413,177813,-15726,-2226,3000,7200,'false'),
(34,35413,177880,-15744,-2226,3000,7200,'false'),
(34,35413,177906,-15791,-2226,3000,7200,'false'),
(34,35413,177859,-15812,-2226,3000,7200,'false'),
(34,35411,177470,-15856,-2250,10000,7200,'false'),
(34,35411,177506,-15887,-2250,10000,7200,'false'),
(34,35411,177627,-15953,-2250,10000,7200,'false'),
(34,35411,177703,-15999,-2250,10000,7200,'false'),
(34,35411,177400,-15854,-2250,10000,7200,'false'),
(34,35411,177517,-15930,-2250,10000,7200,'false'),
(34,35411,177564,-15963,-2250,10000,7200,'false'),
(34,35411,177608,-15985,-2250,10000,7200,'false'),
(34,35411,177709,-16043,-2253,10000,7200,'false'),
(34,35411,177387,-15955,-2250,10000,7200,'false'),
(34,35411,177661,-16014,-2253,10000,7200,'false'),
(34,35411,177308,-15861,-2253,10000,7200,'false'),
(34,35411,177606,-16035,-2253,10000,7200,'false'),
(34,35411,177861,-16164,-2253,10000,7200,'false'),
(34,35411,177810,-16145,-2253,10000,7200,'false'),
(34,35411,177719,-15951,-2253,10000,7200,'false'),
(34,35411,177667,-15921,-2253,10000,7200,'false'),
(34,35415,177428,-15981,-2250,10000,7200,'false'),
(34,35415,177473,-16011,-2250,10000,7200,'false'),
(34,35415,177612,-16090,-2250,10000,7200,'false'),
(34,35415,177657,-16113,-2250,10000,7200,'false'),
(34,35415,177387,-15996,-2250,10000,7200,'false'),
(34,35415,177433,-16026,-2250,10000,7200,'false'),
(34,35415,177530,-16079,-2250,10000,7200,'false'),
(34,35415,177571,-16105,-2250,10000,7200,'false'),
(34,35415,177663,-16154,-2250,10000,7200,'false'),
-- Region 1 (right)
(34,35413,179009,-15201,-2221,40000,7200,'false'),
(34,35413,179052,-15226,-2221,40000,7200,'false'),
(34,35413,179073,-15203,-2221,40000,7200,'false'),
(34,35413,179101,-15253,-2221,40000,7200,'false'),
(34,35413,179144,-15271,-2221,40000,7200,'false'),
(34,35413,179164,-15247,-2221,40000,7200,'false'),
(34,35413,179189,-15286,-2221,40000,7200,'false'),
(34,35413,179226,-15309,-2221,40000,7200,'false'),
(34,35413,179246,-15285,-2221,40000,7200,'false'),
(34,35413,179260,-15341,-2221,40000,7200,'false'),
(34,35413,179302,-15372,-2221,40000,7200,'false'),
(34,35413,179322,-15349,-2221,40000,7200,'false'),
(34,35413,179341,-15406,-2221,40000,7200,'false'),
(34,35413,179391,-15439,-2221,40000,7200,'false'),
(34,35411,179327,-16101,-2253,25000,7200,'false'),
(34,35411,179426,-16009,-2253,25000,7200,'false'),
(34,35415,179491,-15981,-2256,25000,7200,'false'),
(34,35415,179503,-15925,-2256,25000,7200,'false'),
(34,35415,179544,-15882,-2256,25000,7200,'false'),
(34,35415,179570,-15901,-2256,25000,7200,'false'),
(34,35415,179279,-16219,-2256,25000,7200,'false'),
(34,35415,179370,-16196,-2256,25000,7200,'false'),
(34,35415,179408,-16158,-2256,25000,7200,'false'),
(34,35415,179562,-15984,-2256,25000,7200,'false'),
(34,35415,179599,-15943,-2256,25000,7200,'false'),
-- Region 2
(34,35411,179433,-16991,-2246,16384,1200,'false'),
(34,35411,179715,-17454,-2246,16384,1200,'false'),
(34,35411,179438,-16875,-2246,16384,1200,'false'),
(34,35411,179540,-16876,-2246,16384,1200,'false'),
(34,35411,179593,-16876,-2246,16384,1200,'false'),
(34,35411,179485,-17213,-2246,16384,1200,'false'),
(34,35411,179537,-17214,-2246,16384,1200,'false'),
(34,35411,179641,-17215,-2246,16384,1200,'false'),
(34,35411,179542,-17453,-2246,16384,1200,'false'),
(34,35411,179594,-17453,-2246,16384,1200,'false'),
(34,35411,179444,-16937,-2256,16384,1200,'false'),
(34,35411,179468,-17280,-2256,16384,1200,'false'),
(34,35411,179514,-17281,-2256,16384,1200,'false'),
(34,35411,179479,-17133,-2256,16384,1200,'false'),
(34,35411,179525,-17135,-2256,16384,1200,'false'),
(34,35415,179576,-17137,-2256,16384,1200,'false'),
(34,35415,179633,-17137,-2256,16384,1200,'false'),
(34,35415,179436,-17776,-2256,16384,1200,'false'),
(34,35415,179636,-17780,-2256,16384,1200,'false'),
(34,35415,179697,-17781,-2256,16384,1200,'false'),
(34,35415,179446,-17391,-2252,16384,1200,'false'),
(34,35415,179508,-17341,-2252,16384,1200,'false'),
(34,35415,179432,-17719,-2252,16384,1200,'false'),
(34,35415,179437,-17522,-2252,16384,1200,'false'),
(34,35415,179557,-17524,-2252,16384,1200,'false'),
(34,35415,179707,-17722,-2252,16384,1200,'false'),
(34,35415,179604,-17525,-2252,16384,1200,'false'),
(34,35415,179665,-17527,-2252,16384,1200,'false'),
(34,35415,179534,-17892,-2252,16384,1200,'false'),
(34,35415,179436,-17841,-2252,16384,1200,'false'),
(34,35415,179482,-17841,-2252,16384,1200,'false'),
(34,35415,179536,-17842,-2252,16384,1200,'false'),
(34,35415,179694,-17897,-2252,16384,1200,'false'),
(34,35415,179696,-17844,-2252,16384,1200,'false'),
-- Region 3
(34,35413,178578,-18383,-2250,0,7200,'false'),
(34,35413,178577,-18422,-2250,0,7200,'false'),
(34,35413,178576,-18461,-2250,0,7200,'false'),
(34,35413,178575,-18500,-2250,0,7200,'false'),
(34,35413,178574,-18539,-2250,0,7200,'false'),
(34,35413,178573,-18577,-2250,0,7200,'false'),
(34,35413,178571,-18618,-2250,0,7200,'false'),
(34,35413,178571,-18657,-2250,0,7200,'false'),
(34,35413,178571,-18697,-2250,0,7200,'false'),
(34,35413,178570,-18736,-2250,0,7200,'false'),
(34,35413,178530,-18382,-2250,0,7200,'false'),
(34,35413,178530,-18421,-2250,0,7200,'false'),
(34,35413,178528,-18461,-2250,0,7200,'false'),
(34,35413,178528,-18499,-2250,0,7200,'false'),
(34,35413,178526,-18538,-2250,0,7200,'false'),
(34,35413,178526,-18576,-2250,0,7200,'false'),
(34,35413,178524,-18618,-2250,0,7200,'false'),
(34,35413,178523,-18656,-2250,0,7200,'false'),
(34,35413,178523,-18696,-2250,0,7200,'false'),
(34,35413,178523,-18735,-2250,0,7200,'false'),
-- Region 4
(34,35413,178437,-16548,-2217,0,7200,'false'),
(34,35413,178437,-16587,-2217,0,7200,'false'),
(34,35413,178435,-16627,-2217,0,7200,'false'),
(34,35413,178435,-16665,-2217,0,7200,'false'),
(34,35413,178433,-16704,-2217,0,7200,'false'),
(34,35413,178433,-16742,-2217,0,7200,'false'),
(34,35413,178431,-16784,-2217,0,7200,'false'),
(34,35413,178431,-16822,-2217,0,7200,'false'),
(34,35413,178430,-16862,-2217,0,7200,'false'),
(34,35413,178430,-16901,-2217,0,7200,'false'),
(34,35413,178161,-16562,-2217,0,7200,'false'),
(34,35413,178160,-16600,-2217,0,7200,'false'),
(34,35413,178158,-16640,-2217,0,7200,'false'),
(34,35413,178158,-16679,-2217,0,7200,'false'),
(34,35413,178156,-16718,-2217,0,7200,'false'),
(34,35413,178156,-16756,-2217,0,7200,'false'),
(34,35413,178154,-16797,-2217,0,7200,'false'),
(34,35413,178154,-16836,-2217,0,7200,'false'),
(34,35413,178153,-16876,-2217,0,7200,'false'),
(34,35413,178153,-16914,-2217,0,7200,'false'),
(34,35413,177876,-16558,-2217,0,7200,'false'),
(34,35413,177876,-16597,-2217,0,7200,'false'),
(34,35413,177874,-16637,-2217,0,7200,'false'),
(34,35413,177873,-16675,-2217,0,7200,'false'),
(34,35413,177872,-16714,-2217,0,7200,'false'),
(34,35413,177871,-16752,-2217,0,7200,'false'),
(34,35413,177870,-16794,-2217,0,7200,'false'),
(34,35413,177869,-16832,-2217,0,7200,'false'),
(34,35413,177869,-16873,-2217,0,7200,'false'),
(34,35413,177868,-16911,-2217,0,7200,'false'),
(34,35411,178403,-16566,-2218,0,7200,'false'),
(34,35411,178398,-16781,-2218,0,7200,'false'),
(34,35411,178397,-16824,-2218,0,7200,'false'),
(34,35411,178395,-16865,-2218,0,7200,'false'),
(34,35411,178326,-16720,-2218,0,7200,'false'),
(34,35411,178324,-16762,-2218,0,7200,'false'),
(34,35411,178324,-16804,-2218,0,7200,'false'),
(34,35411,178122,-16672,-2218,0,7200,'false'),
(34,35411,178120,-16714,-2218,0,7200,'false'),
(34,35411,178122,-16759,-2218,0,7200,'false'),
(34,35411,178117,-16885,-2218,0,7200,'false'),
(34,35411,178061,-16738,-2218,0,7200,'false'),
(34,35411,178063,-16784,-2218,0,7200,'false'),
(34,35411,178060,-16826,-2218,0,7200,'false'),
(34,35411,178060,-16868,-2218,0,7200,'false'),
(34,35415,178366,-16582,-2217,0,7200,'false'),
(34,35415,178366,-16674,-2217,0,7200,'false'),
(34,35415,178366,-16721,-2217,0,7200,'false'),
(34,35415,178363,-16768,-2217,0,7200,'false'),
(34,35415,178290,-16550,-2217,0,7200,'false'),
(34,35415,178290,-16690,-2217,0,7200,'false'),
(34,35415,178288,-16783,-2217,0,7200,'false'),
(34,35415,178285,-16832,-2217,0,7200,'false'),
(34,35415,178095,-16736,-2217,0,7200,'false'),
(34,35415,178092,-16782,-2217,0,7200,'false'),
(34,35415,178090,-16878,-2217,0,7200,'false'),
(34,35415,178029,-16587,-2217,0,7200,'false'),
(34,35415,178029,-16727,-2217,0,7200,'false'),
(34,35415,178027,-16773,-2217,0,7200,'false'),
(34,35415,178027,-16820,-2217,0,7200,'false'),
-- Region 5
(34,35413,177466,-17397,-2207,32768,7200,'false'),
(34,35415,177440,-17380,-2215,32768,7200,'false'),
(34,35416,177501,-17384,-2219,32768,7200,'false'),
(34,35415,177439,-17426,-2215,32768,7200,'false'),
(34,35415,177438,-17472,-2215,32768,7200,'false'),
(34,35415,177436,-17605,-2215,32768,7200,'false'),
(34,35415,177432,-17791,-2215,32768,7200,'false'),
(34,35415,177431,-17836,-2215,32768,7200,'false'),
(34,35415,177559,-17708,-2215,32768,7200,'false'),
(34,35415,177558,-17755,-2215,32768,7200,'false'),
(34,35415,177564,-17425,-2215,32768,7200,'false'),
(34,35415,177561,-17563,-2215,32768,7200,'false'),
(34,35413,177466,-17445,-2207,32768,7200,'false'),
(34,35413,177466,-17537,-2207,32768,7200,'false'),
(34,35413,177466,-17627,-2207,32768,7200,'false'),
(34,35413,177466,-17716,-2207,32768,7200,'false'),
(34,35413,177467,-17809,-2207,32768,7200,'false'),
(34,35413,177603,-17446,-2207,32768,7200,'false'),
(34,35413,177603,-17539,-2207,32768,7200,'false'),
(34,35413,177604,-17628,-2207,32768,7200,'false'),
(34,35413,177604,-17718,-2207,32768,7200,'false'),
(34,35413,177601,-17811,-2207,32768,7200,'false'),
(34,35413,177693,-17447,-2207,32768,7200,'false'),
(34,35413,177693,-17539,-2207,32768,7200,'false'),
(34,35413,177693,-17629,-2207,32768,7200,'false'),
(34,35413,177693,-17718,-2207,32768,7200,'false'),
(34,35413,177694,-17811,-2207,32768,7200,'false'),
(34,35413,177396,-17452,-2207,32768,7200,'false'),
(34,35413,177396,-17545,-2207,32768,7200,'false'),
(34,35413,177397,-17634,-2207,32768,7200,'false'),
(34,35413,177397,-17723,-2207,32768,7200,'false'),
(34,35413,177398,-17817,-2207,32768,7200,'false'),
(34,35413,177749,-17446,-2207,32768,7200,'false'),
(34,35413,177749,-17538,-2207,32768,7200,'false'),
(34,35413,177750,-17628,-2207,32768,7200,'false'),
(34,35413,177750,-17717,-2207,32768,7200,'false'),
(34,35413,177751,-17810,-2207,32768,7200,'false'),
(34,35415,177531,-17399,-2215,32768,7200,'false'),
(34,35415,177527,-17537,-2215,32768,7200,'false'),
(34,35415,177527,-17578,-2215,32768,7200,'false'),
(34,35415,177524,-17763,-2215,32768,7200,'false'),
(34,35415,177523,-17810,-2215,32768,7200,'false'),
(34,35415,177636,-17516,-2215,32768,7200,'false'),
(34,35415,177635,-17603,-2215,32768,7200,'false'),
(34,35415,177633,-17740,-2215,32768,7200,'false'),
(34,35415,177632,-17788,-2215,32768,7200,'false'),
(34,35415,177631,-17835,-2215,32768,7200,'false'),
(34,35416,177501,-17424,-2219,32768,7200,'false'),
(34,35416,177500,-17469,-2219,32768,7200,'false'),
(34,35416,177496,-17645,-2219,32768,7200,'false'),
(34,35416,177496,-17686,-2219,32768,7200,'false'),
(34,35416,177666,-17508,-2219,32768,7200,'false'),
(34,35416,177664,-17559,-2219,32768,7200,'false'),
(34,35416,177664,-17599,-2219,32768,7200,'false'),
(34,35416,177662,-17644,-2219,32768,7200,'false'),
(34,35416,177662,-17685,-2219,32768,7200,'false'),
(34,35416,177661,-17818,-2219,32768,7200,'false'),
(34,35416,177728,-17377,-2219,32768,7200,'false'),
(34,35416,177725,-17503,-2219,32768,7200,'false'),
(34,35416,177724,-17553,-2219,32768,7200,'false'),
(34,35416,177724,-17594,-2219,32768,7200,'false'),
(34,35416,177722,-17728,-2219,32768,7200,'false'),
(34,35416,177722,-17768,-2219,32768,7200,'false'),
(34,35416,177721,-17813,-2219,32768,7200,'false'),
(34,35416,177567,-17376,-2219,32768,7200,'false'),
(34,35416,177560,-17849,-2219,32768,7200,'false'),
-- Region 6
(34,35410,178298,-17624,-2194,32768,7200,'true');

INSERT INTO `clanhall_siege_guards` VALUES
-- Partisan's Hideaway (Fortress of Resistance)
-- Mercury Monster
(21,35368,44525,108867,-2020,0,10800,'true'),
(21,35369,44545,108867,-2020,0,60,'false'),
(21,35369,44505,108867,-2020,0,60,'false'),
(21,35371,44535,108884,-2020,0,60,'false'),
(21,35371,44515,108884,-2020,0,60,'false'),
(21,35371,44515,108850,-2020,0,60,'false'),
(21,35371,44535,108850,-2020,0,60,'false'),
(21,35370,44565,108867,-2020,0,60,'false'),
(21,35370,44553,108895,-2020,0,60,'false'),
(21,35370,44535,108895,-2020,0,60,'false'),
(21,35370,44497,108895,-2020,0,60,'false'),
(21,35370,44485,108867,-2020,0,60,'false'),
(21,35370,44497,108839,-2020,0,60,'false'),
(21,35370,44525,108827,-2020,0,60,'false'),
(21,35370,44553,108839,-2020,0,60,'false'),
(21,35374,44812,109492,-1705,0,60,'false'),
(21,35373,44788,109492,-1705,0,60,'false'),
(21,35374,45236,108980,-1705,0,60,'false'),
(21,35373,45168,109020,-1705,0,60,'false'),
-- (21,35372,anywhere - total 15,0,60,'false'), TODO: needs support for random spawn by zone.
-- Monster Siege
-- (21,35375,45109,112124,-1900,0,10800,'true'), TODO: unknown usage for value 30%
-- (21,35375,47653,110816,-2110,0,10800,'true'), TODO: unknown usage for value 40%
-- (21,35375,47247,109396,-2000,0,10800,'true'), TODO: unknown usage for value 30%
(21,35382,50343,111282,-1970,0,60,'false'),
(21,35383,43129,108841,-1980,0,60,'false');

INSERT INTO `clanhall_siege_guards` VALUES
-- Bandit Stronghold
-- Battle Royale
(35,35429,83672,-17340,-1829,19048,1200,'false'),
(35,35428,83672,-17340,-1829,19048,1200,'false'),
(35,35430,83672,-17340,-1829,19048,1200,'false'),
(35,35431,83672,-17340,-1829,19048,1200,'false'),
(35,35432,83672,-17340,-1829,19048,1200,'false'),
(35,35429,83503,-15368,-1829,44976,1200,'false'),
(35,35428,83503,-15368,-1829,44976,1200,'false'),
(35,35430,83503,-15368,-1829,44976,1200,'false'),
(35,35431,83503,-15368,-1829,44976,1200,'false'),
(35,35432,83503,-15368,-1829,44976,1200,'false'),
(35,35429,82226,-15597,-1888,58792,1200,'false'),
(35,35428,82226,-15597,-1888,58792,1200,'false'),
(35,35430,82226,-15597,-1888,58792,1200,'false'),
(35,35431,82226,-15597,-1888,58792,1200,'false'),
(35,35432,82226,-15597,-1888,58792,1200,'false'),
(35,35429,82149,-17007,-1839,5432,1200,'false'),
(35,35428,82149,-17007,-1839,5432,1200,'false'),
(35,35430,82149,-17007,-1839,5432,1200,'false'),
(35,35431,82149,-17007,-1839,5432,1200,'false'),
(35,35432,82149,-17007,-1839,5432,1200,'false'),
(35,35429,84486,-16073,-1828,35816,1200,'false'),
(35,35428,84486,-16073,-1828,35816,1200,'false'),
(35,35430,84486,-16073,-1828,35816,1200,'false'),
(35,35431,84486,-16073,-1828,35816,1200,'false'),
(35,35432,84486,-16073,-1828,35816,1200,'false'),
-- Final
(35,35429,82095,-15769,-1888,60392,1200,'false'),
(35,35428,82095,-15769,-1888,60392,1200,'false'),
(35,35430,82095,-15769,-1888,60392,1200,'false'),
(35,35431,82095,-15769,-1888,60392,1200,'false'),
(35,35432,82095,-15769,-1888,60392,1200,'false'),
(35,35429,84244,-16982,-1852,27712,1200,'false'),
(35,35428,84244,-16982,-1852,27712,1200,'false'),
(35,35430,84244,-16982,-1852,27712,1200,'false'),
(35,35431,84244,-16982,-1852,27712,1200,'false'),
(35,35432,84244,-16982,-1852,27712,1200,'false');

INSERT INTO `clanhall_siege_guards` VALUES
-- Beast Farm
(63,35618,57058,-92275,-1360,57344,1200,'false'),
(63,35619,57058,-92275,-1360,57344,1200,'false'),
(63,35620,57058,-92275,-1360,57344,1200,'false'),
(63,35621,57058,-92275,-1360,57344,1200,'false'),
(63,35622,57058,-92275,-1360,57344,1200,'false'),
(63,35618,58071,-91756,-1360,47274,1200,'false'),
(63,35619,58071,-91756,-1360,47274,1200,'false'),
(63,35620,58071,-91756,-1360,47274,1200,'false'),
(63,35621,58071,-91756,-1360,47274,1200,'false'),
(63,35622,58071,-91756,-1360,47274,1200,'false'),
(63,35618,58800,-92560,-1360,34450,1200,'false'),
(63,35619,58800,-92560,-1360,34450,1200,'false'),
(63,35620,58800,-92560,-1360,34450,1200,'false'),
(63,35621,58800,-92560,-1360,34450,1200,'false'),
(63,35622,58800,-92560,-1360,34450,1200,'false'),
(63,35618,58297,-93503,-1361,21100,1200,'false'),
(63,35619,58297,-93503,-1361,21100,1200,'false'),
(63,35620,58297,-93503,-1361,21100,1200,'false'),
(63,35621,58297,-93503,-1361,21100,1200,'false'),
(63,35622,58297,-93503,-1361,21100,1200,'false'),
(63,35618,57215,-93306,-1359,8400,1200,'false'),
(63,35619,57215,-93306,-1359,8400,1200,'false'),
(63,35620,57215,-93306,-1359,8400,1200,'false'),
(63,35621,57215,-93306,-1359,8400,1200,'false'),
(63,35622,57215,-93306,-1359,8400,1200,'false'),
-- Beast Farm Final
(63,35618,56560,-92880,-1360,64000,1200,'false'),
(63,35619,56560,-92880,-1360,64000,1200,'false'),
(63,35620,56560,-92880,-1360,64000,1200,'false'),
(63,35621,56560,-92880,-1360,64000,1200,'false'),
(63,35622,56560,-92880,-1360,64000,1200,'false'),
(63,35618,58989,-93234,-1303,31000,1200,'false'),
(63,35619,58989,-93234,-1303,31000,1200,'false'),
(63,35620,58989,-93234,-1303,31000,1200,'false'),
(63,35621,58989,-93234,-1303,31000,1200,'false'),
(63,35622,58989,-93234,-1303,31000,1200,'false');
-- Beast Farm Pet
-- (63,16019,anywhere - total 2,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16023,anywhere - total 2,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16021,anywhere,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16019,anywhere - total 2,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16023,anywhere - total 2,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16021,anywhere,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16019,anywhere - total 2,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16023,anywhere - total 2,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16021,anywhere,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16019,anywhere - total 2,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16023,anywhere - total 2,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16021,anywhere,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16019,anywhere - total 2,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16023,anywhere - total 2,0,1800,'false'), TODO: needs support for random spawn by zone.
-- (63,16021,anywhere,0,1800,'false'); TODO: needs support for random spawn by zone.

INSERT INTO `clanhall_siege_guards` VALUES
-- Fortress of the Dead
(64,35634,57931,-29540,565,49152,7200,'false'),
(64,35634,57888,-29540,565,49152,7200,'false'),
(64,35634,57845,-29540,565,49152,7200,'false'),
(64,35634,57801,-29540,565,49152,7200,'false'),
(64,35634,57758,-29540,565,49152,7200,'false'),
(64,35634,58150,-29540,565,49152,7200,'false'),
(64,35634,58107,-29540,565,49152,7200,'false'),
(64,35634,58063,-29540,565,49152,7200,'false'),
(64,35634,58020,-29540,565,49152,7200,'false'),
(64,35634,57977,-29540,565,49152,7200,'false'),
(64,35634,57783,-29569,565,49152,7200,'false'),
(64,35634,57740,-29569,565,49152,7200,'false'),
(64,35634,58170,-29570,565,49152,7200,'false'),
(64,35634,58128,-29570,565,49152,7200,'false'),
(64,35633,57929,-29570,575,49152,7200,'false'),
(64,35633,57885,-29570,575,49152,7200,'false'),
(64,35633,57836,-29570,575,49152,7200,'false'),
(64,35633,58072,-29570,575,49152,7200,'false'),
(64,35633,58029,-29570,575,49152,7200,'false'),
(64,35633,57980,-29570,575,49152,7200,'false'),
(64,35633,57928,-29606,575,49152,7200,'false'),
(64,35633,57885,-29606,575,49152,7200,'false'),
(64,35633,57836,-29606,575,49152,7200,'false'),
(64,35633,58072,-29607,575,49152,7200,'false'),
(64,35633,58028,-29607,575,49152,7200,'false'),
(64,35633,57979,-29607,575,49152,7200,'false'),
(64,35633,57780,-29606,575,49152,7200,'false'),
(64,35633,57731,-29606,575,49152,7200,'false'),
(64,35633,58172,-29608,575,49152,7200,'false'),
(64,35633,58123,-29608,575,49152,7200,'false'),
(64,35634,58435,-29647,567,49152,7200,'false'),
(64,35634,58450,-29681,567,49152,7200,'false'),
(64,35634,58468,-29713,567,49152,7200,'false'),
(64,35634,58484,-29745,567,49152,7200,'false'),
(64,35634,58500,-29777,567,49152,7200,'false'),
(64,35634,58520,-29815,587,49152,7200,'false'),
(64,35634,58536,-29848,587,49152,7200,'false'),
(64,35634,58556,-29886,567,49152,7200,'false'),
(64,35634,57473,-29664,567,49152,7200,'false'),
(64,35634,57452,-29695,567,49152,7200,'false'),
(64,35634,57435,-29728,567,49152,7200,'false'),
(64,35634,57420,-29760,567,49152,7200,'false'),
(64,35634,57409,-29791,567,49152,7200,'false'),
(64,35634,57394,-29824,580,49152,7200,'false'),
(64,35634,57379,-29856,580,49152,7200,'false'),
(64,35634,57363,-29888,567,49152,7200,'false'),
(64,35634,57893,-26684,591,-88,7200,'false'),
(64,35634,57893,-26722,591,-88,7200,'false'),
(64,35634,57893,-26759,591,-88,7200,'false'),
(64,35634,57893,-26646,591,-88,7200,'false'),
(64,35634,57863,-26646,591,-88,7200,'false'),
(64,35634,57863,-26684,591,-88,7200,'false'),
(64,35634,57863,-26722,591,-88,7200,'false'),
(64,35634,57863,-26758,591,-88,7200,'false'),
(64,35635,57973,-26684,591,-88,7200,'false'),
(64,35635,57973,-26722,591,-88,7200,'false'),
(64,35635,57973,-26759,591,-88,7200,'false'),
(64,35635,57973,-26646,591,-88,7200,'false'),
(64,35635,57943,-26646,591,-88,7200,'false'),
(64,35635,57943,-26684,591,-88,7200,'false'),
(64,35635,57943,-26721,591,-88,7200,'false'),
(64,35635,57943,-26758,591,-88,7200,'false'),
(64,35633,58046,-26682,591,-88,7200,'false'),
(64,35633,58046,-26720,591,-88,7200,'false'),
(64,35633,58046,-26758,591,-88,7200,'false'),
(64,35633,58046,-26644,591,-88,7200,'false'),
(64,35633,58017,-26644,591,-88,7200,'false'),
(64,35633,58017,-26682,591,-88,7200,'false'),
(64,35633,58017,-26720,591,-88,7200,'false'),
(64,35633,58017,-26757,591,-88,7200,'false'),
(64,35634,58889,-26764,565,-88,7200,'false'),
(64,35634,58889,-26802,565,-88,7200,'false'),
(64,35634,58889,-26840,565,-88,7200,'false'),
(64,35634,58889,-26876,565,-88,7200,'false'),
(64,35634,58889,-26726,565,-88,7200,'false'),
(64,35634,58889,-26570,565,-88,7200,'false'),
(64,35634,58889,-26608,565,-88,7200,'false'),
(64,35634,58889,-26645,565,-88,7200,'false'),
(64,35634,58889,-26682,565,-88,7200,'false'),
(64,35634,58889,-26532,565,-88,7200,'false'),
(64,35634,58887,-26379,565,-88,7200,'false'),
(64,35634,58887,-26417,565,-88,7200,'false'),
(64,35634,58887,-26454,565,-88,7200,'false'),
(64,35634,58887,-26491,565,-88,7200,'false'),
(64,35634,58887,-26341,565,-88,7200,'false'),
(64,35632,56669,-26839,592,16384,7200,'false'),
(64,35634,56708,-26902,565,16448,7200,'false'),
(64,35634,56746,-26902,565,16448,7200,'false'),
(64,35634,56784,-26902,565,16448,7200,'false'),
(64,35634,56820,-26902,565,16448,7200,'false'),
(64,35634,56858,-26903,565,16448,7200,'false'),
(64,35634,56894,-26903,565,16448,7200,'false'),
(64,35634,56670,-26902,565,16448,7200,'false'),
(64,35634,56935,-26903,565,16448,7200,'false'),
(64,35634,57018,-26902,565,16448,7200,'false'),
(64,35634,57056,-26902,565,16448,7200,'false'),
(64,35634,57093,-26902,565,16448,7200,'false'),
(64,35634,57130,-26902,565,16448,7200,'false'),
(64,35634,57168,-26903,565,16448,7200,'false'),
(64,35634,57204,-26903,565,16448,7200,'false'),
(64,35634,56980,-26902,565,16448,7200,'false'),
(64,35634,56708,-26874,565,16448,7200,'false'),
(64,35634,56746,-26874,565,16448,7200,'false'),
(64,35634,56783,-26874,565,16448,7200,'false'),
(64,35634,56820,-26874,565,16448,7200,'false'),
(64,35634,56857,-26875,565,16448,7200,'false'),
(64,35634,56894,-26875,565,16448,7200,'false'),
(64,35634,56670,-26874,565,16448,7200,'false'),
(64,35634,56935,-26875,565,16448,7200,'false'),
(64,35634,57018,-26875,565,16448,7200,'false'),
(64,35634,57056,-26875,565,16448,7200,'false'),
(64,35634,57094,-26875,565,16448,7200,'false'),
(64,35634,57131,-26875,565,16448,7200,'false'),
(64,35634,57168,-26876,565,16448,7200,'false'),
(64,35634,57205,-26876,565,16448,7200,'false'),
(64,35634,56980,-26875,565,16448,7200,'false'),
(64,35632,56708,-26839,592,16384,7200,'false'),
(64,35632,56748,-26839,592,16384,7200,'false'),
(64,35632,56788,-26839,592,16384,7200,'false'),
(64,35632,56829,-26839,592,16384,7200,'false'),
(64,35632,56870,-26839,592,16384,7200,'false'),
(64,35632,56910,-26839,592,16384,7200,'false'),
(64,35632,56950,-26839,592,16384,7200,'false'),
(64,35632,56989,-26839,592,16384,7200,'false'),
(64,35632,57030,-26839,592,16384,7200,'false'),
(64,35632,56667,-26799,592,16384,7200,'false'),
(64,35632,56706,-26799,592,16384,7200,'false'),
(64,35632,56747,-26799,592,16384,7200,'false'),
(64,35632,56786,-26799,592,16384,7200,'false'),
(64,35632,56827,-26799,592,16384,7200,'false'),
(64,35636,56869,-26802,587,16384,7200,'false'),
(64,35636,56908,-26802,587,16384,7200,'false'),
(64,35636,56948,-26802,587,16384,7200,'false'),
(64,35636,56989,-26802,587,16384,7200,'false'),
(64,35636,57030,-26802,587,16384,7200,'false'),
(64,35636,57071,-26804,587,16384,7200,'false'),
(64,35636,57111,-26804,587,16384,7200,'false'),
(64,35636,57151,-26804,587,16384,7200,'false'),
(64,35636,57191,-26804,587,16384,7200,'false'),
(64,35636,57233,-26804,587,16384,7200,'false'),
(64,35636,57070,-26842,587,16384,7200,'false'),
(64,35636,57110,-26842,587,16384,7200,'false'),
(64,35636,57150,-26842,587,16384,7200,'false'),
(64,35636,57190,-26842,587,16384,7200,'false'),
(64,35636,57232,-26842,587,16384,7200,'false'),
(64,35634,57461,-28550,565,0,7200,'false'),
(64,35634,57461,-28503,565,0,7200,'false'),
(64,35634,57461,-28455,565,0,7200,'false'),
(64,35634,57461,-28408,565,0,7200,'false'),
(64,35634,57461,-28360,565,0,7200,'false'),
(64,35634,57461,-28791,565,0,7200,'false'),
(64,35634,57461,-28744,565,0,7200,'false'),
(64,35634,57461,-28696,565,0,7200,'false'),
(64,35634,57461,-28649,565,0,7200,'false'),
(64,35634,57461,-28601,565,0,7200,'false'),
(64,35632,57543,-28587,592,0,7200,'false'),
(64,35636,57605,-28901,587,0,7200,'false'),
(64,35632,57543,-28632,592,0,7200,'false'),
(64,35632,57543,-28678,592,0,7200,'false'),
(64,35632,57543,-28727,592,0,7200,'false'),
(64,35632,57543,-28775,592,0,7200,'false'),
(64,35632,57606,-28399,592,0,7200,'false'),
(64,35632,57543,-28398,592,0,7200,'false'),
(64,35632,57543,-28444,592,0,7200,'false'),
(64,35632,57543,-28494,592,0,7200,'false'),
(64,35632,57543,-28541,592,0,7200,'false'),
(64,35636,57605,-28856,587,0,7200,'false'),
(64,35636,57605,-28807,587,0,7200,'false'),
(64,35636,57605,-28761,587,0,7200,'false'),
(64,35636,57605,-28716,587,0,7200,'false'),
(64,35636,57605,-28668,587,0,7200,'false'),
(64,35636,57605,-28624,587,0,7200,'false'),
(64,35636,57605,-28575,587,0,7200,'false'),
(64,35636,57605,-28529,587,0,7200,'false'),
(64,35636,57605,-28483,587,0,7200,'false'),
(64,35632,57543,-28826,592,0,7200,'false'),
(64,35632,57545,-28882,592,0,7200,'false'),
(64,35632,57545,-28933,592,0,7200,'false'),
(64,35634,57462,-29031,565,0,7200,'false'),
(64,35634,57462,-28984,565,0,7200,'false'),
(64,35634,57462,-28937,565,0,7200,'false'),
(64,35634,57462,-28889,565,0,7200,'false'),
(64,35634,57462,-28841,565,0,7200,'false'),
(64,35632,57546,-28986,592,0,7200,'false'),
(64,35632,57606,-28984,592,0,7200,'false'),
(64,35632,58972,-28365,592,-24512,7200,'false'),
(64,35634,58879,-28217,565,-24440,7200,'false'),
(64,35634,58913,-28250,565,-24440,7200,'false'),
(64,35634,58948,-28284,565,-24440,7200,'false'),
(64,35634,58980,-28316,565,-24440,7200,'false'),
(64,35634,59015,-28349,565,-24440,7200,'false'),
(64,35634,59050,-28384,565,-24440,7200,'false'),
(64,35634,59084,-28417,565,-24440,7200,'false'),
(64,35634,59119,-28450,565,-24440,7200,'false'),
(64,35634,59151,-28481,565,-24440,7200,'false'),
(64,35634,59187,-28518,565,-24440,7200,'false'),
(64,35634,59222,-28552,565,-24440,7200,'false'),
(64,35634,59256,-28585,565,-24440,7200,'false'),
(64,35634,59291,-28619,565,-24440,7200,'false'),
(64,35634,59322,-28650,565,-24440,7200,'false'),
(64,35632,59166,-28557,592,-24512,7200,'false'),
(64,35636,58894,-28289,587,41088,7200,'false'),
(64,35636,58931,-28325,587,41088,7200,'false'),
(64,35636,59007,-28399,587,41088,7200,'false'),
(64,35636,59044,-28435,587,41088,7200,'false'),
(64,35636,59090,-28484,587,41088,7200,'false'),
(64,35636,59127,-28519,587,41088,7200,'false'),
(64,35636,59207,-28597,587,41088,7200,'false'),
(64,35636,59244,-28633,587,41088,7200,'false'),
(64,35634,56938,-27347,576,32768,7200,'false'),
(64,35634,56938,-27309,576,32768,7200,'false'),
(64,35634,56938,-27271,576,32768,7200,'false'),
(64,35634,56938,-27235,576,32768,7200,'false'),
(64,35634,56940,-27197,576,32768,7200,'false'),
(64,35634,56940,-27160,576,32768,7200,'false'),
(64,35634,56938,-27385,576,32768,7200,'false'),
(64,35634,56940,-27120,576,32768,7200,'false'),
(64,35635,56910,-27347,576,32768,7200,'false'),
(64,35635,56910,-27309,576,32768,7200,'false'),
(64,35635,56910,-27271,576,32768,7200,'false'),
(64,35635,56910,-27234,576,32768,7200,'false'),
(64,35635,56912,-27197,576,32768,7200,'false'),
(64,35635,56912,-27160,576,32768,7200,'false'),
(64,35635,56910,-27385,576,32768,7200,'false'),
(64,35635,56912,-27119,576,32768,7200,'false'),
(64,35633,56880,-27346,576,32768,7200,'false'),
(64,35633,56881,-27308,576,32768,7200,'false'),
(64,35633,56881,-27271,576,32768,7200,'false'),
(64,35633,56881,-27234,576,32768,7200,'false'),
(64,35633,56882,-27197,576,32768,7200,'false'),
(64,35633,56882,-27160,576,32768,7200,'false'),
(64,35633,56880,-27384,576,32768,7200,'false'),
(64,35633,56883,-27119,576,32768,7200,'false'),
(64,35632,59015,-27459,575,49152,7200,'false'),
(64,35632,59054,-27459,575,49152,7200,'false'),
(64,35632,59094,-27459,575,49152,7200,'false'),
(64,35632,59134,-27459,575,49152,7200,'false'),
(64,35632,59175,-27459,575,49152,7200,'false'),
(64,35632,59220,-27459,575,49152,7200,'false'),
(64,35632,59259,-27459,575,49152,7200,'false'),
(64,35632,59299,-27459,575,49152,7200,'false'),
(64,35632,59015,-27409,575,49152,7200,'false'),
(64,35632,59054,-27409,575,49152,7200,'false'),
(64,35632,59094,-27409,575,49152,7200,'false'),
(64,35632,59133,-27409,575,49152,7200,'false'),
(64,35632,59174,-27409,575,49152,7200,'false'),
(64,35632,59220,-27409,575,49152,7200,'false'),
(64,35632,59259,-27409,575,49152,7200,'false'),
(64,35632,59299,-27409,575,49152,7200,'false'),
(64,35636,59015,-27352,575,49152,7200,'false'),
(64,35636,59054,-27352,575,49152,7200,'false'),
(64,35636,59094,-27352,575,49152,7200,'false'),
(64,35636,59134,-27352,575,49152,7200,'false'),
(64,35636,59175,-27352,575,49152,7200,'false'),
(64,35636,59220,-27352,575,49152,7200,'false'),
(64,35636,59259,-27352,575,49152,7200,'false'),
(64,35636,59299,-27352,575,49152,7200,'false'),
(64,35636,59016,-27299,575,49152,7200,'false'),
(64,35636,59055,-27299,575,49152,7200,'false'),
(64,35636,59095,-27299,575,49152,7200,'false'),
(64,35636,59134,-27299,575,49152,7200,'false'),
(64,35636,59175,-27299,575,49152,7200,'false'),
(64,35636,59220,-27299,575,49152,7200,'false'),
(64,35636,59260,-27299,575,49152,7200,'false'),
(64,35636,59300,-27299,575,49152,7200,'false'),
(64,35637,57288,-27776,587,32768,7200,'false'),
(64,35636,57174,-27680,587,32768,7200,'false'),
(64,35636,57175,-27643,587,32768,7200,'false'),
(64,35636,57175,-27606,587,32768,7200,'false'),
(64,35636,57175,-27755,587,32768,7200,'false'),
(64,35636,57174,-27718,587,32768,7200,'false'),
(64,35634,57237,-27608,576,32768,7200,'false'),
(64,35634,57239,-27763,576,32768,7200,'false'),
(64,35636,57209,-27701,587,32768,7200,'false'),
(64,35636,57210,-27664,587,32768,7200,'false'),
(64,35636,57209,-27627,587,32768,7200,'false'),
(64,35636,57210,-27776,587,32768,7200,'false'),
(64,35636,57209,-27739,587,32768,7200,'false'),
(64,35634,57239,-27725,576,32768,7200,'false'),
(64,35634,57238,-27687,576,32768,7200,'false'),
(64,35634,57237,-27648,576,32768,7200,'false'),
(64,35634,57260,-27625,576,32768,7200,'false'),
(64,35634,57262,-27779,576,32768,7200,'false'),
(64,35634,57262,-27742,576,32768,7200,'false'),
(64,35634,57262,-27704,576,32768,7200,'false'),
(64,35634,57261,-27665,576,32768,7200,'false'),
(64,35637,57288,-27732,587,32768,7200,'false'),
(64,35637,57288,-27687,587,32768,7200,'false'),
(64,35637,57288,-27644,587,32768,7200,'false'),
(64,35637,57288,-27599,587,32768,7200,'false'),
(64,35637,57256,-27574,587,32768,7200,'false'),
(64,35637,57543,-27786,587,32768,1200,'false'),
(64,35636,57429,-27690,587,32768,1200,'false'),
(64,35636,57430,-27653,587,32768,1200,'false'),
(64,35636,57429,-27616,587,32768,1200,'false'),
(64,35636,57430,-27765,587,32768,1200,'false'),
(64,35636,57429,-27727,587,32768,1200,'false'),
(64,35634,57492,-27618,576,32768,1200,'false'),
(64,35634,57494,-27772,576,32768,1200,'false'),
(64,35636,57464,-27711,587,32768,1200,'false'),
(64,35636,57465,-27674,587,32768,1200,'false'),
(64,35636,57464,-27637,587,32768,1200,'false'),
(64,35636,57464,-27785,587,32768,1200,'false'),
(64,35636,57463,-27748,587,32768,1200,'false'),
(64,35634,57494,-27735,576,32768,1200,'false'),
(64,35634,57493,-27697,576,32768,1200,'false'),
(64,35634,57492,-27658,576,32768,1200,'false'),
(64,35634,57515,-27634,576,32768,1200,'false'),
(64,35634,57517,-27789,576,32768,1200,'false'),
(64,35634,57517,-27752,576,32768,1200,'false'),
(64,35634,57516,-27714,576,32768,1200,'false'),
(64,35634,57515,-27675,576,32768,1200,'false'),
(64,35637,57543,-27742,587,32768,1200,'false'),
(64,35637,57543,-27697,587,32768,1200,'false'),
(64,35637,57543,-27654,587,32768,1200,'false'),
(64,35637,57543,-27609,587,32768,1200,'false'),
(64,35637,57578,-27783,587,32768,1200,'false'),
(64,35637,57578,-27739,587,32768,1200,'false'),
(64,35637,57578,-27695,587,32768,1200,'false'),
(64,35637,57578,-27651,587,32768,1200,'false'),
(64,35637,57578,-27607,587,32768,1200,'false'),
(64,35637,57476,-27575,587,32768,1200,'false'),
(64,35637,57511,-27573,587,32768,1200,'false'),
(64,35637,57473,-27837,587,32768,1200,'false'),
(64,35637,57508,-27835,587,32768,1200,'false'),
(64,35629,58680,-27507,592,32768,7200,'true');

INSERT INTO `clanhall_siege_guards` VALUES
-- Rainbow Springs
(62,35596,151552,-127075,-2208,5896,60,'false'),
(62,35588,151557,-126987,-2224,0,7200,'false'),
-- (62,35593,anywhere - total 1,0,60,'false'), TODO: needs support for random spawn by zone.
-- (62,35594,anywhere - total 1,0,60,'false'), TODO: needs support for random spawn by zone.
-- (62,35595,anywhere - total 10,0,60,'false'), TODO: needs support for random spawn by zone.
(62,35597,153136,-125333,-2208,-16328,60,'false'),
(62,35589,153135,-125425,-2224,0,7200,'false'),
-- (62,35593,anywhere - total 1,0,60,'false'), TODO: needs support for random spawn by zone.
-- (62,35594,anywhere - total 1,0,60,'false'), TODO: needs support for random spawn by zone.
-- (62,35595,anywhere - total 10,0,60,'false'), TODO: needs support for random spawn by zone.
(62,35598,155660,-125753,-2208,-16496,60,'false'),
(62,35590,155661,-125844,-2224,0,7200,'false'),
-- (62,35593,anywhere - total 1,0,60,'false'), TODO: needs support for random spawn by zone.
-- (62,35594,anywhere - total 1,0,60,'false'), TODO: needs support for random spawn by zone.
-- (62,35595,anywhere - total 10,0,60,'false'), TODO: needs support for random spawn by zone.
(62,35599,153887,-127538,-2208,15992,60,'false'),
(62,35591,153888,-127444,-2224,0,7200,'false');
-- (62,35593,anywhere - total 1,0,60,'false'), TODO: needs support for random spawn by zone.
-- (62,35594,anywhere - total 1,0,60,'false'), TODO: needs support for random spawn by zone.
-- (62,35595,anywhere - total 10,0,60,'false'); TODO: needs support for random spawn by zone.