/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver.serverpackets;

import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.L2LoginClient;
import com.l2jserver.loginserver.serverpackets.L2LoginServerPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ServerList
extends L2LoginServerPacket {
    private List<ServerData> _servers = new ArrayList<ServerData>(GameServerTable.getInstance().getRegisteredGameServers().size());
    private int _lastServer;
    private Map<Integer, Integer> _charsOnServers;
    private Map<Integer, long[]> _charsToDelete;

    public ServerList(L2LoginClient client) {
        this._lastServer = client.getLastServer();
        for (GameServerTable.GameServerInfo gsi : GameServerTable.getInstance().getRegisteredGameServers().values()) {
            this._servers.add(new ServerData(client, gsi));
        }
        this._charsOnServers = client.getCharsOnServ();
        this._charsToDelete = client.getCharsWaitingDelOnServ();
    }

    public void write() {
        this.writeC(4);
        this.writeC(this._servers.size());
        this.writeC(this._lastServer);
        for (ServerData server : this._servers) {
            this.writeC(server._serverId);
            this.writeC(server._ip[0] & 0xFF);
            this.writeC(server._ip[1] & 0xFF);
            this.writeC(server._ip[2] & 0xFF);
            this.writeC(server._ip[3] & 0xFF);
            this.writeD(server._port);
            this.writeC(server._ageLimit);
            this.writeC(server._pvp ? 1 : 0);
            this.writeH(server._currentPlayers);
            this.writeH(server._maxPlayers);
            this.writeC(server._status == 4 ? 0 : 1);
            this.writeD(server._serverType);
            this.writeC(server._brackets ? 1 : 0);
        }
        this.writeH(0);
        if (this._charsOnServers != null) {
            this.writeC(this._charsOnServers.size());
            Iterator<Object> i$ = this._charsOnServers.keySet().iterator();
            while (i$.hasNext()) {
                int servId = (Integer)i$.next();
                this.writeC(servId);
                this.writeC(this._charsOnServers.get(servId));
                if (this._charsToDelete == null || !this._charsToDelete.containsKey(servId)) {
                    this.writeC(0);
                    continue;
                }
                this.writeC(this._charsToDelete.get(servId).length);
                for (long deleteTime : this._charsToDelete.get(servId)) {
                    this.writeD((int)((deleteTime - System.currentTimeMillis()) / 1000L));
                }
            }
        } else {
            this.writeC(0);
        }
    }

    class ServerData {
        protected byte[] _ip;
        protected int _port;
        protected int _ageLimit;
        protected boolean _pvp;
        protected int _currentPlayers;
        protected int _maxPlayers;
        protected boolean _brackets;
        protected boolean _clock;
        protected int _status;
        protected int _serverId;
        protected int _serverType;

        ServerData(L2LoginClient client, GameServerTable.GameServerInfo gsi) {
            try {
                this._ip = InetAddress.getByName(gsi.getServerAddress(client.getConnection().getInetAddress())).getAddress();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                this._ip = new byte[4];
                this._ip[0] = 127;
                this._ip[1] = 0;
                this._ip[2] = 0;
                this._ip[3] = 1;
            }
            this._port = gsi.getPort();
            this._pvp = gsi.isPvp();
            this._serverType = gsi.getServerType();
            this._currentPlayers = gsi.getCurrentPlayerCount();
            this._maxPlayers = gsi.getMaxPlayers();
            this._ageLimit = 0;
            this._brackets = gsi.isShowingBrackets();
            this._status = gsi.getStatus() != 5 ? gsi.getStatus() : (client.getAccessLevel() > 0 ? gsi.getStatus() : 4);
            this._serverId = gsi.getId();
        }
    }
}

