/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.AutoChatHandler;
import com.l2jserver.gameserver.model.AutoSpawnHandler;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SSQInfo;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class SevenSigns {
    protected static final Logger _log = Logger.getLogger(SevenSigns.class.getName());
    public static final String SEVEN_SIGNS_DATA_FILE = "config/signs.properties";
    public static final String SEVEN_SIGNS_HTML_PATH = "data/html/seven_signs/";
    public static final int CABAL_NULL = 0;
    public static final int CABAL_DUSK = 1;
    public static final int CABAL_DAWN = 2;
    public static final int SEAL_NULL = 0;
    public static final int SEAL_AVARICE = 1;
    public static final int SEAL_GNOSIS = 2;
    public static final int SEAL_STRIFE = 3;
    public static final int PERIOD_COMP_RECRUITING = 0;
    public static final int PERIOD_COMPETITION = 1;
    public static final int PERIOD_COMP_RESULTS = 2;
    public static final int PERIOD_SEAL_VALIDATION = 3;
    public static final int PERIOD_START_HOUR = 18;
    public static final int PERIOD_START_MINS = 0;
    public static final int PERIOD_START_DAY = 2;
    public static final int PERIOD_MINOR_LENGTH = 900000;
    public static final int PERIOD_MAJOR_LENGTH = 603900000;
    public static final int ANCIENT_ADENA_ID = 5575;
    public static final int RECORD_SEVEN_SIGNS_ID = 5707;
    public static final int CERTIFICATE_OF_APPROVAL_ID = 6388;
    public static final int RECORD_SEVEN_SIGNS_COST = 500;
    public static final int ADENA_JOIN_DAWN_COST = 50000;
    public static final int ORATOR_NPC_ID = 31094;
    public static final int PREACHER_NPC_ID = 31093;
    public static final int MAMMON_MERCHANT_ID = 31113;
    public static final int MAMMON_BLACKSMITH_ID = 31126;
    public static final int MAMMON_MARKETEER_ID = 31092;
    public static final int SPIRIT_IN_ID = 31111;
    public static final int SPIRIT_OUT_ID = 31112;
    public static final int LILITH_NPC_ID = 25283;
    public static final int ANAKIM_NPC_ID = 25286;
    public static final int CREST_OF_DAWN_ID = 31170;
    public static final int CREST_OF_DUSK_ID = 31171;
    public static final int SEAL_STONE_BLUE_ID = 6360;
    public static final int SEAL_STONE_GREEN_ID = 6361;
    public static final int SEAL_STONE_RED_ID = 6362;
    public static final int SEAL_STONE_BLUE_VALUE = 3;
    public static final int SEAL_STONE_GREEN_VALUE = 5;
    public static final int SEAL_STONE_RED_VALUE = 10;
    public static final int BLUE_CONTRIB_POINTS = 3;
    public static final int GREEN_CONTRIB_POINTS = 5;
    public static final int RED_CONTRIB_POINTS = 10;
    private final Calendar _nextPeriodChange = Calendar.getInstance();
    protected int _activePeriod;
    protected int _currentCycle;
    protected double _dawnStoneScore;
    protected double _duskStoneScore;
    protected int _dawnFestivalScore;
    protected int _duskFestivalScore;
    protected int _compWinner;
    protected int _previousWinner;
    protected Calendar _lastSave = Calendar.getInstance();
    private Map<Integer, StatsSet> _signsPlayerData = new FastMap();
    private Map<Integer, Integer> _signsSealOwners = new FastMap();
    private Map<Integer, Integer> _signsDuskSealTotals = new FastMap();
    private Map<Integer, Integer> _signsDawnSealTotals = new FastMap();
    private static AutoSpawnHandler.AutoSpawnInstance _merchantSpawn;
    private static AutoSpawnHandler.AutoSpawnInstance _blacksmithSpawn;
    private static AutoSpawnHandler.AutoSpawnInstance _spiritInSpawn;
    private static AutoSpawnHandler.AutoSpawnInstance _spiritOutSpawn;
    private static AutoSpawnHandler.AutoSpawnInstance _lilithSpawn;
    private static AutoSpawnHandler.AutoSpawnInstance _anakimSpawn;
    private static Map<Integer, AutoSpawnHandler.AutoSpawnInstance> _crestofdawnspawns;
    private static Map<Integer, AutoSpawnHandler.AutoSpawnInstance> _crestofduskspawns;
    private static Map<Integer, AutoSpawnHandler.AutoSpawnInstance> _oratorSpawns;
    private static Map<Integer, AutoSpawnHandler.AutoSpawnInstance> _preacherSpawns;
    private static Map<Integer, AutoSpawnHandler.AutoSpawnInstance> _marketeerSpawns;
    private static final String LOAD_DATA = "SELECT charId, cabal, seal, red_stones, green_stones, blue_stones, ancient_adena_amount, contribution_score FROM seven_signs";
    private static final String LOAD_STATUS = "SELECT * FROM seven_signs_status WHERE id=0";
    private static final String INSERT_PLAYER = "INSERT INTO seven_signs (charId, cabal, seal) VALUES (?,?,?)";
    private static final String UPDATE_PLAYER = "UPDATE seven_signs SET cabal=?, seal=?, red_stones=?, green_stones=?, blue_stones=?, ancient_adena_amount=?, contribution_score=? WHERE charId=?";
    private static final String UPDATE_STATUS = "UPDATE seven_signs_status SET current_cycle=?, active_period=?, previous_winner=?, dawn_stone_score=?, dawn_festival_score=?, dusk_stone_score=?, dusk_festival_score=?, avarice_owner=?, gnosis_owner=?, strife_owner=?, avarice_dawn_score=?, gnosis_dawn_score=?, strife_dawn_score=?, avarice_dusk_score=?, gnosis_dusk_score=?, strife_dusk_score=?, festival_cycle=?, accumulated_bonus0=?, accumulated_bonus1=?, accumulated_bonus2=?,accumulated_bonus3=?, accumulated_bonus4=?, date=? WHERE id=0";

    private SevenSigns() {
        try {
            this.restoreSevenSignsData();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "SevenSigns: Failed to load configuration: " + e.getMessage(), e);
        }
        _log.info("SevenSigns: Currently in the " + this.getCurrentPeriodName() + " period!");
        this.initializeSeals();
        if (this.isSealValidationPeriod()) {
            if (this.getCabalHighestScore() == 0) {
                _log.info("SevenSigns: The competition ended with a tie last week.");
            } else {
                _log.info("SevenSigns: The " + SevenSigns.getCabalName(this.getCabalHighestScore()) + " were victorious last week.");
            }
        } else if (this.getCabalHighestScore() == 0) {
            _log.info("SevenSigns: The competition, if the current trend continues, will end in a tie this week.");
        } else {
            _log.info("SevenSigns: The " + SevenSigns.getCabalName(this.getCabalHighestScore()) + " are in the lead this week.");
        }
        long milliToChange = 0L;
        if (this.isNextPeriodChangeInPast()) {
            _log.info("SevenSigns: Next period change was in the past (server was offline), changing periods now!");
        } else {
            this.setCalendarForNextPeriodChange();
            milliToChange = this.getMilliToPeriodChange();
        }
        SevenSignsPeriodChange sspc = new SevenSignsPeriodChange();
        ThreadPoolManager.getInstance().scheduleGeneral(sspc, milliToChange);
        _log.info("SevenSigns: Next period begins in " + Util.strMillTime(milliToChange));
    }

    private boolean isNextPeriodChangeInPast() {
        Calendar lastPeriodChange = Calendar.getInstance();
        switch (this.getCurrentPeriod()) {
            case 1: 
            case 3: {
                lastPeriodChange.set(7, 2);
                lastPeriodChange.set(11, 18);
                lastPeriodChange.set(12, 0);
                lastPeriodChange.set(13, 0);
                if (!Calendar.getInstance().before(lastPeriodChange)) break;
                lastPeriodChange.add(10, -168);
                break;
            }
            case 0: 
            case 2: {
                lastPeriodChange.setTimeInMillis(this._lastSave.getTimeInMillis() + 900000L);
            }
        }
        return this._lastSave.getTimeInMillis() > 7L && this._lastSave.before(lastPeriodChange);
    }

    public void spawnSevenSignsNPC() {
        block33: {
            block31: {
                block32: {
                    _merchantSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(31113, false);
                    _blacksmithSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(31126, false);
                    _marketeerSpawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31092);
                    _spiritInSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(31111, false);
                    _spiritOutSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(31112, false);
                    _lilithSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(25283, false);
                    _anakimSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(25286, false);
                    _crestofdawnspawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31170);
                    _crestofduskspawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31171);
                    _oratorSpawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31094);
                    _preacherSpawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31093);
                    if (!this.isSealValidationPeriod() && !this.isCompResultsPeriod()) break block31;
                    for (AutoSpawnHandler.AutoSpawnInstance spawnInst : _marketeerSpawns.values()) {
                        AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, true);
                    }
                    if (this.getSealOwner(2) == this.getCabalHighestScore() && this.getSealOwner(2) != 0) {
                        if (!Config.ANNOUNCE_MAMMON_SPAWN) {
                            _blacksmithSpawn.setBroadcast(false);
                        }
                        if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(_blacksmithSpawn.getObjectId(), true).isSpawnActive()) {
                            AutoSpawnHandler.getInstance().setSpawnActive(_blacksmithSpawn, true);
                        }
                        for (AutoSpawnHandler.AutoSpawnInstance spawnInst : _oratorSpawns.values()) {
                            if (AutoSpawnHandler.getInstance().getAutoSpawnInstance(spawnInst.getObjectId(), true).isSpawnActive()) continue;
                            AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, true);
                        }
                        for (AutoSpawnHandler.AutoSpawnInstance spawnInst : _preacherSpawns.values()) {
                            if (AutoSpawnHandler.getInstance().getAutoSpawnInstance(spawnInst.getObjectId(), true).isSpawnActive()) continue;
                            AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, true);
                        }
                        if (!AutoChatHandler.getInstance().getAutoChatInstance(31093, false).isActive() && !AutoChatHandler.getInstance().getAutoChatInstance(31094, false).isActive()) {
                            AutoChatHandler.getInstance().setAutoChatActive(true);
                        }
                    } else {
                        AutoSpawnHandler.getInstance().setSpawnActive(_blacksmithSpawn, false);
                        for (AutoSpawnHandler.AutoSpawnInstance spawnInst : _oratorSpawns.values()) {
                            AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
                        }
                        for (AutoSpawnHandler.AutoSpawnInstance spawnInst : _preacherSpawns.values()) {
                            AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
                        }
                        AutoChatHandler.getInstance().setAutoChatActive(false);
                    }
                    if (this.getSealOwner(1) != this.getCabalHighestScore() || this.getSealOwner(1) == 0) break block32;
                    if (!Config.ANNOUNCE_MAMMON_SPAWN) {
                        _merchantSpawn.setBroadcast(false);
                    }
                    if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(_merchantSpawn.getObjectId(), true).isSpawnActive()) {
                        AutoSpawnHandler.getInstance().setSpawnActive(_merchantSpawn, true);
                    }
                    if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(_spiritInSpawn.getObjectId(), true).isSpawnActive()) {
                        AutoSpawnHandler.getInstance().setSpawnActive(_spiritInSpawn, true);
                    }
                    if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(_spiritOutSpawn.getObjectId(), true).isSpawnActive()) {
                        AutoSpawnHandler.getInstance().setSpawnActive(_spiritOutSpawn, true);
                    }
                    switch (this.getCabalHighestScore()) {
                        case 2: {
                            if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(_lilithSpawn.getObjectId(), true).isSpawnActive()) {
                                AutoSpawnHandler.getInstance().setSpawnActive(_lilithSpawn, true);
                            }
                            AutoSpawnHandler.getInstance().setSpawnActive(_anakimSpawn, false);
                            for (AutoSpawnHandler.AutoSpawnInstance dawnCrest : _crestofdawnspawns.values()) {
                                if (AutoSpawnHandler.getInstance().getAutoSpawnInstance(dawnCrest.getObjectId(), true).isSpawnActive()) continue;
                                AutoSpawnHandler.getInstance().setSpawnActive(dawnCrest, true);
                            }
                            for (AutoSpawnHandler.AutoSpawnInstance duskCrest : _crestofduskspawns.values()) {
                                AutoSpawnHandler.getInstance().setSpawnActive(duskCrest, false);
                            }
                            break block33;
                        }
                        case 1: {
                            if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(_anakimSpawn.getObjectId(), true).isSpawnActive()) {
                                AutoSpawnHandler.getInstance().setSpawnActive(_anakimSpawn, true);
                            }
                            AutoSpawnHandler.getInstance().setSpawnActive(_lilithSpawn, false);
                            for (AutoSpawnHandler.AutoSpawnInstance duskCrest : _crestofduskspawns.values()) {
                                if (AutoSpawnHandler.getInstance().getAutoSpawnInstance(duskCrest.getObjectId(), true).isSpawnActive()) continue;
                                AutoSpawnHandler.getInstance().setSpawnActive(duskCrest, true);
                            }
                            for (AutoSpawnHandler.AutoSpawnInstance dawnCrest : _crestofdawnspawns.values()) {
                                AutoSpawnHandler.getInstance().setSpawnActive(dawnCrest, false);
                            }
                            break;
                        }
                    }
                    break block33;
                }
                AutoSpawnHandler.getInstance().setSpawnActive(_merchantSpawn, false);
                AutoSpawnHandler.getInstance().setSpawnActive(_lilithSpawn, false);
                AutoSpawnHandler.getInstance().setSpawnActive(_anakimSpawn, false);
                for (AutoSpawnHandler.AutoSpawnInstance dawnCrest : _crestofdawnspawns.values()) {
                    AutoSpawnHandler.getInstance().setSpawnActive(dawnCrest, false);
                }
                for (AutoSpawnHandler.AutoSpawnInstance duskCrest : _crestofduskspawns.values()) {
                    AutoSpawnHandler.getInstance().setSpawnActive(duskCrest, false);
                }
                AutoSpawnHandler.getInstance().setSpawnActive(_spiritInSpawn, false);
                AutoSpawnHandler.getInstance().setSpawnActive(_spiritOutSpawn, false);
                break block33;
            }
            AutoSpawnHandler.getInstance().setSpawnActive(_merchantSpawn, false);
            AutoSpawnHandler.getInstance().setSpawnActive(_blacksmithSpawn, false);
            AutoSpawnHandler.getInstance().setSpawnActive(_lilithSpawn, false);
            AutoSpawnHandler.getInstance().setSpawnActive(_anakimSpawn, false);
            for (AutoSpawnHandler.AutoSpawnInstance dawnCrest : _crestofdawnspawns.values()) {
                AutoSpawnHandler.getInstance().setSpawnActive(dawnCrest, false);
            }
            for (AutoSpawnHandler.AutoSpawnInstance duskCrest : _crestofduskspawns.values()) {
                AutoSpawnHandler.getInstance().setSpawnActive(duskCrest, false);
            }
            AutoSpawnHandler.getInstance().setSpawnActive(_spiritInSpawn, false);
            AutoSpawnHandler.getInstance().setSpawnActive(_spiritOutSpawn, false);
            for (AutoSpawnHandler.AutoSpawnInstance spawnInst : _oratorSpawns.values()) {
                AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
            }
            for (AutoSpawnHandler.AutoSpawnInstance spawnInst : _preacherSpawns.values()) {
                AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
            }
            for (AutoSpawnHandler.AutoSpawnInstance spawnInst : _marketeerSpawns.values()) {
                AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
            }
            AutoChatHandler.getInstance().setAutoChatActive(false);
        }
    }

    public static SevenSigns getInstance() {
        return SingletonHolder._instance;
    }

    public static long calcContributionScore(long blueCount, long greenCount, long redCount) {
        long contrib = blueCount * 3L;
        contrib += greenCount * 5L;
        return contrib += redCount * 10L;
    }

    public static long calcAncientAdenaReward(long blueCount, long greenCount, long redCount) {
        long reward = blueCount * 3L;
        reward += greenCount * 5L;
        return reward += redCount * 10L;
    }

    public static final String getCabalShortName(int cabal) {
        switch (cabal) {
            case 2: {
                return "dawn";
            }
            case 1: {
                return "dusk";
            }
        }
        return "No Cabal";
    }

    public static final String getCabalName(int cabal) {
        switch (cabal) {
            case 2: {
                return "Lords of Dawn";
            }
            case 1: {
                return "Revolutionaries of Dusk";
            }
        }
        return "No Cabal";
    }

    public static final String getCabalNameJA(int cabal) {
        switch (cabal) {
            case 2: {
                return "\u9ece\u660e\u306e\u541b\u4e3b\u9054";
            }
            case 1: {
                return "\u9ec4\u660f\u306e\u9769\u547d\u8ecd";
            }
        }
        return "\u306a\u3057";
    }

    public static final String getSealName(int seal, boolean shortName) {
        String sealName = !shortName ? "Seal of " : "";
        switch (seal) {
            case 1: {
                sealName = sealName + "Avarice";
                break;
            }
            case 2: {
                sealName = sealName + "Gnosis";
                break;
            }
            case 3: {
                sealName = sealName + "Strife";
            }
        }
        return sealName;
    }

    public static final String getSealNameJA(int seal, boolean shortName) {
        switch (seal) {
            case 1: {
                return "\u8caa\u6b32\u306e\u5c01\u5370";
            }
            case 2: {
                return "\u5553\u793a\u306e\u5c01\u5370";
            }
            case 3: {
                return "\u6226\u4e71\u306e\u5c01\u5370";
            }
        }
        throw new AssertionError();
    }

    public final int getCurrentCycle() {
        return this._currentCycle;
    }

    public final int getCurrentPeriod() {
        return this._activePeriod;
    }

    private final int getDaysToPeriodChange() {
        int numDays = this._nextPeriodChange.get(7) - 2;
        if (numDays < 0) {
            return 0 - numDays;
        }
        return 7 - numDays;
    }

    public final long getMilliToPeriodChange() {
        long currTimeMillis = System.currentTimeMillis();
        long changeTimeMillis = this._nextPeriodChange.getTimeInMillis();
        return changeTimeMillis - currTimeMillis;
    }

    protected void setCalendarForNextPeriodChange() {
        switch (this.getCurrentPeriod()) {
            case 1: 
            case 3: {
                int daysToChange = this.getDaysToPeriodChange();
                if (daysToChange == 7) {
                    if (this._nextPeriodChange.get(11) < 18) {
                        daysToChange = 0;
                    } else if (this._nextPeriodChange.get(11) == 18 && this._nextPeriodChange.get(12) < 0) {
                        daysToChange = 0;
                    }
                }
                if (daysToChange > 0) {
                    this._nextPeriodChange.add(5, daysToChange);
                }
                this._nextPeriodChange.set(11, 18);
                this._nextPeriodChange.set(12, 0);
                break;
            }
            case 0: 
            case 2: {
                this._nextPeriodChange.add(14, 900000);
            }
        }
        _log.info("SevenSigns: Next period change set to " + Util.dateFormat(this._nextPeriodChange.getTime()));
    }

    public final String getCurrentPeriodName() {
        String periodName = null;
        switch (this._activePeriod) {
            case 0: {
                periodName = "\u6e96\u5099\u671f\u9593";
                break;
            }
            case 1: {
                periodName = "\u7af6\u4e89\u671f\u9593";
                break;
            }
            case 2: {
                periodName = "\u96c6\u8a08\u671f\u9593";
                break;
            }
            case 3: {
                periodName = "\u5c01\u5370\u6709\u52b9\u671f\u9593";
            }
        }
        return periodName;
    }

    public final boolean isSealValidationPeriod() {
        return this._activePeriod == 3;
    }

    public final boolean isCompResultsPeriod() {
        return this._activePeriod == 2;
    }

    public boolean isDateInSealValidPeriod(Calendar date) {
        long tillDate;
        long nextPeriodChange = this.getMilliToPeriodChange();
        long nextQuestStart = 0L;
        long nextValidStart = 0L;
        for (tillDate = date.getTimeInMillis() - Calendar.getInstance().getTimeInMillis(); 1209600000L < tillDate; tillDate -= 1209600000L) {
        }
        while (tillDate < 0L) {
            tillDate += 1209600000L;
        }
        switch (this.getCurrentPeriod()) {
            case 0: {
                nextValidStart = nextPeriodChange + 603900000L;
                nextQuestStart = nextValidStart + 603900000L + 900000L;
                break;
            }
            case 1: {
                nextValidStart = nextPeriodChange;
                nextQuestStart = nextPeriodChange + 603900000L + 900000L;
                break;
            }
            case 2: {
                nextQuestStart = nextPeriodChange + 603900000L;
                nextValidStart = nextQuestStart + 603900000L + 900000L;
                break;
            }
            case 3: {
                nextQuestStart = nextPeriodChange;
                nextValidStart = nextPeriodChange + 603900000L + 900000L;
            }
        }
        return (nextQuestStart >= tillDate || tillDate >= nextValidStart) && (nextValidStart >= nextQuestStart || tillDate >= nextValidStart && nextQuestStart >= tillDate);
    }

    public final int getCurrentScore(int cabal) {
        double totalStoneScore = this._dawnStoneScore + this._duskStoneScore;
        switch (cabal) {
            case 0: {
                return 0;
            }
            case 2: {
                return Math.round((float)(this._dawnStoneScore / ((float)totalStoneScore == 0.0f ? 1.0 : totalStoneScore)) * 500.0f) + this._dawnFestivalScore;
            }
            case 1: {
                return Math.round((float)(this._duskStoneScore / ((float)totalStoneScore == 0.0f ? 1.0 : totalStoneScore)) * 500.0f) + this._duskFestivalScore;
            }
        }
        return 0;
    }

    public final double getCurrentStoneScore(int cabal) {
        switch (cabal) {
            case 0: {
                return 0.0;
            }
            case 2: {
                return this._dawnStoneScore;
            }
            case 1: {
                return this._duskStoneScore;
            }
        }
        return 0.0;
    }

    public final int getCurrentFestivalScore(int cabal) {
        switch (cabal) {
            case 0: {
                return 0;
            }
            case 2: {
                return this._dawnFestivalScore;
            }
            case 1: {
                return this._duskFestivalScore;
            }
        }
        return 0;
    }

    public final int getCabalHighestScore() {
        if (this.getCurrentScore(1) == this.getCurrentScore(2)) {
            return 0;
        }
        if (this.getCurrentScore(1) > this.getCurrentScore(2)) {
            return 1;
        }
        return 2;
    }

    public final int getSealOwner(int seal) {
        return this._signsSealOwners.get(seal);
    }

    public final int getSealProportion(int seal, int cabal) {
        if (cabal == 0) {
            return 0;
        }
        if (cabal == 1) {
            return this._signsDuskSealTotals.get(seal);
        }
        return this._signsDawnSealTotals.get(seal);
    }

    public final int getTotalMembers(int cabal) {
        int cabalMembers = 0;
        String cabalName = SevenSigns.getCabalShortName(cabal);
        for (StatsSet sevenDat : this._signsPlayerData.values()) {
            if (!sevenDat.getString("cabal").equals(cabalName)) continue;
            ++cabalMembers;
        }
        return cabalMembers;
    }

    public int getPlayerStoneContrib(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        int stoneCount = 0;
        stoneCount += currPlayer.getInteger("red_stones");
        stoneCount += currPlayer.getInteger("green_stones");
        return stoneCount += currPlayer.getInteger("blue_stones");
    }

    public int getPlayerContribScore(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        return currPlayer.getInteger("contribution_score");
    }

    public int getPlayerAdenaCollect(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        return currPlayer.getInteger("ancient_adena_amount");
    }

    public int getPlayerSeal(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        return currPlayer.getInteger("seal");
    }

    public int getPlayerCabal(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        String playerCabal = currPlayer.getString("cabal");
        if (playerCabal.equalsIgnoreCase("dawn")) {
            return 2;
        }
        if (playerCabal.equalsIgnoreCase("dusk")) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreSevenSignsData() {
        Connection con = null;
        PreparedStatement statement = null;
        ResultSet rset = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement(LOAD_DATA);
            rset = statement.executeQuery();
            StatsSet sevenDat = null;
            while (rset.next()) {
                int charObjId = rset.getInt("charId");
                sevenDat = new StatsSet();
                sevenDat.set("charId", charObjId);
                sevenDat.set("cabal", rset.getString("cabal"));
                sevenDat.set("seal", rset.getInt("seal"));
                sevenDat.set("red_stones", rset.getInt("red_stones"));
                sevenDat.set("green_stones", rset.getInt("green_stones"));
                sevenDat.set("blue_stones", rset.getInt("blue_stones"));
                sevenDat.set("ancient_adena_amount", rset.getDouble("ancient_adena_amount"));
                sevenDat.set("contribution_score", rset.getDouble("contribution_score"));
                if (Config.DEBUG) {
                    _log.info("SevenSigns: Loaded data from DB for char ID " + charObjId + " (" + sevenDat.getString("cabal") + ")");
                }
                this._signsPlayerData.put(charObjId, sevenDat);
            }
            rset.close();
            statement.close();
            statement = con.prepareStatement(LOAD_STATUS);
            rset = statement.executeQuery();
            while (rset.next()) {
                this._currentCycle = rset.getInt("current_cycle");
                this._activePeriod = rset.getInt("active_period");
                this._previousWinner = rset.getInt("previous_winner");
                this._dawnStoneScore = rset.getDouble("dawn_stone_score");
                this._dawnFestivalScore = rset.getInt("dawn_festival_score");
                this._duskStoneScore = rset.getDouble("dusk_stone_score");
                this._duskFestivalScore = rset.getInt("dusk_festival_score");
                this._signsSealOwners.put(1, rset.getInt("avarice_owner"));
                this._signsSealOwners.put(2, rset.getInt("gnosis_owner"));
                this._signsSealOwners.put(3, rset.getInt("strife_owner"));
                this._signsDawnSealTotals.put(1, rset.getInt("avarice_dawn_score"));
                this._signsDawnSealTotals.put(2, rset.getInt("gnosis_dawn_score"));
                this._signsDawnSealTotals.put(3, rset.getInt("strife_dawn_score"));
                this._signsDuskSealTotals.put(1, rset.getInt("avarice_dusk_score"));
                this._signsDuskSealTotals.put(2, rset.getInt("gnosis_dusk_score"));
                this._signsDuskSealTotals.put(3, rset.getInt("strife_dusk_score"));
                this._lastSave.setTimeInMillis(rset.getLong("date"));
            }
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "SevenSigns: Unable to load Seven Signs data from database: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSevenSignsData() {
        Connection con = null;
        PreparedStatement statement = null;
        if (Config.DEBUG) {
            _log.info("SevenSigns: Saving data to disk.");
        }
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement(UPDATE_PLAYER);
            for (StatsSet sevenDat : this._signsPlayerData.values()) {
                statement.setString(1, sevenDat.getString("cabal"));
                statement.setInt(2, sevenDat.getInteger("seal"));
                statement.setInt(3, sevenDat.getInteger("red_stones"));
                statement.setInt(4, sevenDat.getInteger("green_stones"));
                statement.setInt(5, sevenDat.getInteger("blue_stones"));
                statement.setDouble(6, sevenDat.getDouble("ancient_adena_amount"));
                statement.setDouble(7, sevenDat.getDouble("contribution_score"));
                statement.setInt(8, sevenDat.getInteger("charId"));
                statement.execute();
                if (!Config.DEBUG) continue;
                _log.info("SevenSigns: Updated data in database for char ID " + sevenDat.getInteger("charId") + " (" + sevenDat.getString("cabal") + ")");
            }
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "SevenSigns: Unable to save data to database: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveSevenSignsData(int objectId) {
        StatsSet sevenDat = this._signsPlayerData.get(objectId);
        if (sevenDat == null) {
            return;
        }
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement(UPDATE_PLAYER);
            statement.setString(1, sevenDat.getString("cabal"));
            statement.setInt(2, sevenDat.getInteger("seal"));
            statement.setInt(3, sevenDat.getInteger("red_stones"));
            statement.setInt(4, sevenDat.getInteger("green_stones"));
            statement.setInt(5, sevenDat.getInteger("blue_stones"));
            statement.setDouble(6, sevenDat.getDouble("ancient_adena_amount"));
            statement.setDouble(7, sevenDat.getDouble("contribution_score"));
            statement.setInt(8, sevenDat.getInteger("charId"));
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "SevenSigns: Unable to save data to database: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveSevenSignsStatus() {
        Connection con = null;
        PreparedStatement statement = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement(UPDATE_STATUS);
            statement.setInt(1, this._currentCycle);
            statement.setInt(2, this._activePeriod);
            statement.setInt(3, this._previousWinner);
            statement.setDouble(4, this._dawnStoneScore);
            statement.setInt(5, this._dawnFestivalScore);
            statement.setDouble(6, this._duskStoneScore);
            statement.setInt(7, this._duskFestivalScore);
            statement.setInt(8, this._signsSealOwners.get(1));
            statement.setInt(9, this._signsSealOwners.get(2));
            statement.setInt(10, this._signsSealOwners.get(3));
            statement.setInt(11, this._signsDawnSealTotals.get(1));
            statement.setInt(12, this._signsDawnSealTotals.get(2));
            statement.setInt(13, this._signsDawnSealTotals.get(3));
            statement.setInt(14, this._signsDuskSealTotals.get(1));
            statement.setInt(15, this._signsDuskSealTotals.get(2));
            statement.setInt(16, this._signsDuskSealTotals.get(3));
            statement.setInt(17, SevenSignsFestival.getInstance().getCurrentFestivalCycle());
            for (int i = 0; i < 5; ++i) {
                statement.setInt(18 + i, SevenSignsFestival.getInstance().getAccumulatedBonus(i));
            }
            this._lastSave = Calendar.getInstance();
            statement.setLong(23, this._lastSave.getTimeInMillis());
            statement.execute();
            statement.close();
            if (Config.DEBUG) {
                _log.info("SevenSigns: Updated data in database.");
            }
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "SevenSigns: Unable to save data to database: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    protected void resetPlayerData() {
        if (Config.DEBUG) {
            _log.info("SevenSigns: Resetting player data for new event period.");
        }
        for (StatsSet sevenDat : this._signsPlayerData.values()) {
            int charObjId = sevenDat.getInteger("charId");
            sevenDat.set("cabal", "");
            sevenDat.set("seal", 0);
            sevenDat.set("contribution_score", 0);
            this._signsPlayerData.put(charObjId, sevenDat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setPlayerInfo(int objectId, int chosenCabal, int chosenSeal) {
        Connection con = null;
        PreparedStatement statement = null;
        StatsSet currPlayerData = this._signsPlayerData.get(objectId);
        if (currPlayerData != null) {
            currPlayerData.set("cabal", SevenSigns.getCabalShortName(chosenCabal));
            currPlayerData.set("seal", chosenSeal);
            this._signsPlayerData.put(objectId, currPlayerData);
        } else {
            currPlayerData = new StatsSet();
            currPlayerData.set("charId", objectId);
            currPlayerData.set("cabal", SevenSigns.getCabalShortName(chosenCabal));
            currPlayerData.set("seal", chosenSeal);
            currPlayerData.set("red_stones", 0);
            currPlayerData.set("green_stones", 0);
            currPlayerData.set("blue_stones", 0);
            currPlayerData.set("ancient_adena_amount", 0);
            currPlayerData.set("contribution_score", 0);
            this._signsPlayerData.put(objectId, currPlayerData);
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement(INSERT_PLAYER);
                statement.setInt(1, objectId);
                statement.setString(2, SevenSigns.getCabalShortName(chosenCabal));
                statement.setInt(3, chosenSeal);
                statement.execute();
                statement.close();
                if (Config.DEBUG) {
                    _log.info("SevenSigns: Inserted data in DB for char ID " + currPlayerData.getInteger("charId") + " (" + currPlayerData.getString("cabal") + ")");
                }
            }
            catch (SQLException e) {
                _log.log(Level.SEVERE, "SevenSigns: Failed to save data: " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
        if ("dawn".equals(currPlayerData.getString("cabal"))) {
            this._signsDawnSealTotals.put(chosenSeal, this._signsDawnSealTotals.get(chosenSeal) + 1);
        } else {
            this._signsDuskSealTotals.put(chosenSeal, this._signsDuskSealTotals.get(chosenSeal) + 1);
        }
        if (!Config.ALT_SEVENSIGNS_LAZY_UPDATE) {
            this.saveSevenSignsStatus();
        }
        return chosenCabal;
    }

    public int getAncientAdenaReward(int objectId, boolean removeReward) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        int rewardAmount = currPlayer.getInteger("ancient_adena_amount");
        currPlayer.set("red_stones", 0);
        currPlayer.set("green_stones", 0);
        currPlayer.set("blue_stones", 0);
        currPlayer.set("ancient_adena_amount", 0);
        if (removeReward) {
            this._signsPlayerData.put(objectId, currPlayer);
            if (!Config.ALT_SEVENSIGNS_LAZY_UPDATE) {
                this.saveSevenSignsData(objectId);
                this.saveSevenSignsStatus();
            }
        }
        return rewardAmount;
    }

    public long addPlayerStoneContrib(int objectId, long blueCount, long greenCount, long redCount) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        long contribScore = SevenSigns.calcContributionScore(blueCount, greenCount, redCount);
        long totalAncientAdena = currPlayer.getLong("ancient_adena_amount") + SevenSigns.calcAncientAdenaReward(blueCount, greenCount, redCount);
        long totalContribScore = currPlayer.getLong("contribution_score") + contribScore;
        if (totalContribScore > (long)Config.ALT_MAXIMUM_PLAYER_CONTRIB) {
            return -1L;
        }
        currPlayer.set("red_stones", (long)currPlayer.getInteger("red_stones") + redCount);
        currPlayer.set("green_stones", (long)currPlayer.getInteger("green_stones") + greenCount);
        currPlayer.set("blue_stones", (long)currPlayer.getInteger("blue_stones") + blueCount);
        currPlayer.set("ancient_adena_amount", totalAncientAdena);
        currPlayer.set("contribution_score", totalContribScore);
        this._signsPlayerData.put(objectId, currPlayer);
        switch (this.getPlayerCabal(objectId)) {
            case 2: {
                this._dawnStoneScore += (double)contribScore;
                break;
            }
            case 1: {
                this._duskStoneScore += (double)contribScore;
            }
        }
        if (!Config.ALT_SEVENSIGNS_LAZY_UPDATE) {
            this.saveSevenSignsData(objectId);
            this.saveSevenSignsStatus();
        }
        return contribScore;
    }

    public void addFestivalScore(int cabal, int amount) {
        if (cabal == 1) {
            this._duskFestivalScore += amount;
            if (this._dawnFestivalScore >= amount) {
                this._dawnFestivalScore -= amount;
            }
        } else {
            this._dawnFestivalScore += amount;
            if (this._duskFestivalScore >= amount) {
                this._duskFestivalScore -= amount;
            }
        }
    }

    public void sendCurrentPeriodMsg(L2PcInstance player) {
        SystemMessage sm = null;
        switch (this.getCurrentPeriod()) {
            case 0: {
                sm = SystemMessage.getSystemMessage(SystemMessageId.PREPARATIONS_PERIOD_BEGUN);
                break;
            }
            case 1: {
                sm = SystemMessage.getSystemMessage(SystemMessageId.COMPETITION_PERIOD_BEGUN);
                break;
            }
            case 2: {
                sm = SystemMessage.getSystemMessage(SystemMessageId.RESULTS_PERIOD_BEGUN);
                break;
            }
            case 3: {
                sm = SystemMessage.getSystemMessage(SystemMessageId.VALIDATION_PERIOD_BEGUN);
            }
        }
        player.sendPacket(sm);
    }

    public void sendMessageToAll(SystemMessageId sysMsgId) {
        SystemMessage sm = SystemMessage.getSystemMessage(sysMsgId);
        Broadcast.toAllOnlinePlayers(sm);
    }

    protected void initializeSeals() {
        for (Integer currSeal : this._signsSealOwners.keySet()) {
            int sealOwner = this._signsSealOwners.get(currSeal);
            if (sealOwner != 0) {
                if (this.isSealValidationPeriod()) {
                    _log.info("SevenSigns: The " + SevenSigns.getCabalName(sealOwner) + " have won the " + SevenSigns.getSealName(currSeal, false) + ".");
                    continue;
                }
                _log.info("SevenSigns: The " + SevenSigns.getSealName(currSeal, false) + " is currently owned by " + SevenSigns.getCabalName(sealOwner) + ".");
                continue;
            }
            _log.info("SevenSigns: The " + SevenSigns.getSealName(currSeal, false) + " remains unclaimed.");
        }
    }

    protected void resetSeals() {
        this._signsDawnSealTotals.put(1, 0);
        this._signsDawnSealTotals.put(2, 0);
        this._signsDawnSealTotals.put(3, 0);
        this._signsDuskSealTotals.put(1, 0);
        this._signsDuskSealTotals.put(2, 0);
        this._signsDuskSealTotals.put(3, 0);
    }

    protected void calcNewSealOwners() {
        if (Config.DEBUG) {
            _log.info("SevenSigns: (Avarice) Dawn = " + this._signsDawnSealTotals.get(1) + ", Dusk = " + this._signsDuskSealTotals.get(1));
            _log.info("SevenSigns: (Gnosis) Dawn = " + this._signsDawnSealTotals.get(2) + ", Dusk = " + this._signsDuskSealTotals.get(2));
            _log.info("SevenSigns: (Strife) Dawn = " + this._signsDawnSealTotals.get(3) + ", Dusk = " + this._signsDuskSealTotals.get(3));
        }
        for (Integer currSeal : this._signsDawnSealTotals.keySet()) {
            int prevSealOwner = this._signsSealOwners.get(currSeal);
            int newSealOwner = 0;
            int dawnProportion = this.getSealProportion(currSeal, 2);
            int totalDawnMembers = this.getTotalMembers(2) == 0 ? 1 : this.getTotalMembers(2);
            int dawnPercent = Math.round((float)dawnProportion / (float)totalDawnMembers * 100.0f);
            int duskProportion = this.getSealProportion(currSeal, 1);
            int totalDuskMembers = this.getTotalMembers(1) == 0 ? 1 : this.getTotalMembers(1);
            int duskPercent = Math.round((float)duskProportion / (float)totalDuskMembers * 100.0f);
            block0 : switch (prevSealOwner) {
                case 0: {
                    switch (this.getCabalHighestScore()) {
                        case 0: {
                            newSealOwner = 0;
                            break;
                        }
                        case 2: {
                            if (dawnPercent >= 35) {
                                newSealOwner = 2;
                                break;
                            }
                            newSealOwner = 0;
                            break;
                        }
                        case 1: {
                            newSealOwner = duskPercent >= 35 ? 1 : 0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.getCabalHighestScore()) {
                        case 0: {
                            if (dawnPercent >= 10) {
                                newSealOwner = 2;
                                break;
                            }
                            newSealOwner = 0;
                            break;
                        }
                        case 2: {
                            if (dawnPercent >= 10) {
                                newSealOwner = 2;
                                break;
                            }
                            newSealOwner = 0;
                            break;
                        }
                        case 1: {
                            newSealOwner = duskPercent >= 35 ? 1 : (dawnPercent >= 10 ? 2 : 0);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.getCabalHighestScore()) {
                        case 0: {
                            if (duskPercent >= 10) {
                                newSealOwner = 1;
                                break block0;
                            }
                            newSealOwner = 0;
                            break block0;
                        }
                        case 2: {
                            if (dawnPercent >= 35) {
                                newSealOwner = 2;
                                break block0;
                            }
                            if (duskPercent >= 10) {
                                newSealOwner = 1;
                                break block0;
                            }
                            newSealOwner = 0;
                            break block0;
                        }
                        case 1: {
                            newSealOwner = duskPercent >= 10 ? 1 : 0;
                        }
                    }
                }
            }
            this._signsSealOwners.put(currSeal, newSealOwner);
            switch (currSeal) {
                case 1: {
                    if (newSealOwner == 2) {
                        this.sendMessageToAll(SystemMessageId.DAWN_OBTAINED_AVARICE);
                        break;
                    }
                    if (newSealOwner != 1) break;
                    this.sendMessageToAll(SystemMessageId.DUSK_OBTAINED_AVARICE);
                    break;
                }
                case 2: {
                    if (newSealOwner == 2) {
                        this.sendMessageToAll(SystemMessageId.DAWN_OBTAINED_GNOSIS);
                        break;
                    }
                    if (newSealOwner != 1) break;
                    this.sendMessageToAll(SystemMessageId.DUSK_OBTAINED_GNOSIS);
                    break;
                }
                case 3: {
                    if (newSealOwner == 2) {
                        this.sendMessageToAll(SystemMessageId.DAWN_OBTAINED_STRIFE);
                    } else if (newSealOwner == 1) {
                        this.sendMessageToAll(SystemMessageId.DUSK_OBTAINED_STRIFE);
                    }
                    CastleManager.getInstance().validateTaxes(newSealOwner);
                }
            }
        }
    }

    protected void teleLosingCabalFromDungeons(String compWinner) {
        Collection<L2PcInstance> pls = L2World.getInstance().getAllPlayers().values();
        for (L2PcInstance onlinePlayer : pls) {
            if (onlinePlayer == null) continue;
            StatsSet currPlayer = this._signsPlayerData.get(onlinePlayer.getObjectId());
            if (this.isSealValidationPeriod() || this.isCompResultsPeriod()) {
                if (onlinePlayer.isGM() || !onlinePlayer.isIn7sDungeon() || currPlayer.getString("cabal").equals(compWinner)) continue;
                onlinePlayer.teleToLocation(MapRegionTable.TeleportWhereType.Town);
                onlinePlayer.setIsIn7sDungeon(false);
                onlinePlayer.sendMessage("You have been teleported to the nearest town due to the beginning of the Seal Validation period.");
                continue;
            }
            if (onlinePlayer.isGM() || !onlinePlayer.isIn7sDungeon() || currPlayer.getString("cabal").isEmpty()) continue;
            onlinePlayer.teleToLocation(MapRegionTable.TeleportWhereType.Town);
            onlinePlayer.setIsIn7sDungeon(false);
            onlinePlayer.sendMessage("You have been teleported to the nearest town because you have not signed for any cabal.");
        }
    }

    public boolean checkIsDawnPostingTicket(int itemId) {
        if (itemId > 6114 && itemId < 6175) {
            return true;
        }
        if (itemId > 6801 && itemId < 6812) {
            return true;
        }
        if (itemId > 7997 && itemId < 8008) {
            return true;
        }
        if (itemId > 7940 && itemId < 7951) {
            return true;
        }
        if (itemId > 6294 && itemId < 6307) {
            return true;
        }
        if (itemId > 6831 && itemId < 6834) {
            return true;
        }
        if (itemId > 8027 && itemId < 8030) {
            return true;
        }
        return itemId > 7970 && itemId < 7973;
    }

    public boolean checkIsRookiePostingTicket(int itemId) {
        if (itemId > 6174 && itemId < 6295) {
            return true;
        }
        if (itemId > 6811 && itemId < 6832) {
            return true;
        }
        if (itemId > 7950 && itemId < 7971) {
            return true;
        }
        return itemId > 8007 && itemId < 8028;
    }

    public void giveCPMult(int StrifeOwner) {
        for (L2PcInstance character : L2World.getInstance().getAllPlayers().values()) {
            int cabal;
            if (character == null || (cabal = this.getPlayerCabal(character.getObjectId())) == 0) continue;
            if (cabal == StrifeOwner) {
                character.addSkill(SkillTable.FrequentSkill.THE_VICTOR_OF_WAR.getSkill());
                continue;
            }
            character.addSkill(SkillTable.FrequentSkill.THE_VANQUISHED_OF_WAR.getSkill());
        }
    }

    public void removeCPMult() {
        for (L2PcInstance character : L2World.getInstance().getAllPlayers().values()) {
            if (character == null) continue;
            character.removeSkill(SkillTable.FrequentSkill.THE_VICTOR_OF_WAR.getSkill());
            character.removeSkill(SkillTable.FrequentSkill.THE_VANQUISHED_OF_WAR.getSkill());
        }
    }

    public boolean checkSummonConditions(L2PcInstance activeChar) {
        if (activeChar == null) {
            return true;
        }
        if (this.isSealValidationPeriod() && this.getSealOwner(3) == 2 && this.getPlayerCabal(activeChar.getObjectId()) == 1) {
            activeChar.sendMessage("You cannot summon Siege Golem or Cannon while Seal of Strife posessed by Lords of Dawn.");
            return true;
        }
        return false;
    }

    private static class SingletonHolder {
        protected static final SevenSigns _instance = new SevenSigns();

        private SingletonHolder() {
        }
    }

    protected class SevenSignsPeriodChange
    implements Runnable {
        protected SevenSignsPeriodChange() {
        }

        @Override
        public void run() {
            int periodEnded = SevenSigns.this.getCurrentPeriod();
            ++SevenSigns.this._activePeriod;
            switch (periodEnded) {
                case 0: {
                    SevenSignsFestival.getInstance().startFestivalManager();
                    SevenSigns.this.sendMessageToAll(SystemMessageId.QUEST_EVENT_PERIOD_BEGUN);
                    break;
                }
                case 1: {
                    SevenSigns.this.sendMessageToAll(SystemMessageId.QUEST_EVENT_PERIOD_ENDED);
                    int compWinner = SevenSigns.this.getCabalHighestScore();
                    SevenSignsFestival.getInstance().getFestivalManagerSchedule().cancel(false);
                    SevenSignsFestival.getInstance().rewardHighestRanked();
                    SevenSigns.this.calcNewSealOwners();
                    switch (compWinner) {
                        case 2: {
                            SevenSigns.this.sendMessageToAll(SystemMessageId.DAWN_WON);
                            break;
                        }
                        case 1: {
                            SevenSigns.this.sendMessageToAll(SystemMessageId.DUSK_WON);
                        }
                    }
                    SevenSigns.this._previousWinner = compWinner;
                    break;
                }
                case 2: {
                    SevenSigns.this.initializeSeals();
                    SevenSigns.this.giveCPMult(SevenSigns.this.getSealOwner(3));
                    SevenSigns.this.sendMessageToAll(SystemMessageId.SEAL_VALIDATION_PERIOD_BEGUN);
                    Quest twQuest = QuestManager.getInstance().getQuest(TerritoryWarManager.qn);
                    if (twQuest != null) {
                        twQuest.startQuestTimer("setNextTWDate", 30000L, null, null);
                    }
                    _log.info("SevenSigns: The " + SevenSigns.getCabalName(SevenSigns.this._previousWinner) + " have won the competition with " + SevenSigns.this.getCurrentScore(SevenSigns.this._previousWinner) + " points!");
                    break;
                }
                case 3: {
                    SevenSigns.this._activePeriod = 0;
                    SevenSigns.this.sendMessageToAll(SystemMessageId.SEAL_VALIDATION_PERIOD_ENDED);
                    SevenSigns.this.removeCPMult();
                    SevenSigns.this.resetPlayerData();
                    SevenSigns.this.resetSeals();
                    ++SevenSigns.this._currentCycle;
                    SevenSignsFestival.getInstance().resetFestivalData(false);
                    SevenSigns.this._dawnStoneScore = 0.0;
                    SevenSigns.this._duskStoneScore = 0.0;
                    SevenSigns.this._dawnFestivalScore = 0;
                    SevenSigns.this._duskFestivalScore = 0;
                }
            }
            SevenSigns.this.saveSevenSignsData();
            SevenSigns.this.saveSevenSignsStatus();
            SevenSigns.this.teleLosingCabalFromDungeons(SevenSigns.getCabalShortName(SevenSigns.this.getCabalHighestScore()));
            SSQInfo ss = new SSQInfo();
            Broadcast.toAllOnlinePlayers(ss);
            SevenSigns.this.spawnSevenSignsNPC();
            _log.info("SevenSigns: The " + SevenSigns.this.getCurrentPeriodName() + " period has begun!");
            SevenSigns.this.setCalendarForNextPeriodChange();
            List<Castle> castles = CastleManager.getInstance().getCastles();
            for (Castle castle : castles) {
                castle.getSiege().correctSiegeDateTime();
            }
            SevenSignsPeriodChange sspc = new SevenSignsPeriodChange();
            ThreadPoolManager.getInstance().scheduleGeneral(sspc, SevenSigns.this.getMilliToPeriodChange());
        }
    }
}

