/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SummonItemsData;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2SummonItem;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantSummonInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeSummonInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.model.base.Experience;
import com.l2jserver.gameserver.network.serverpackets.PetItemList;
import com.l2jserver.gameserver.skills.l2skills.L2SkillSummon;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import gnu.trove.TIntIntHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CharSummonTable {
    private static Logger _log = Logger.getLogger(CharSummonTable.class.getName());
    private static final String INIT_SUMMONS = "SELECT ownerId, summonSkillId FROM character_summons";
    private static final String INIT_PET = "SELECT ownerId, item_obj_id FROM pets WHERE restore = 'true'";
    private static final String SAVE_SUMMON = "REPLACE INTO character_summons (ownerId,summonSkillId,curHp,curMp,time) VALUES (?,?,?,?,?)";
    private static final String LOAD_SUMMON = "SELECT curHp, curMp, time FROM character_summons WHERE ownerId = ? AND summonSkillId = ?";
    private static final String REMOVE_SUMMON = "DELETE FROM character_summons WHERE ownerId = ?";
    private static final TIntIntHashMap _servitors = new TIntIntHashMap();
    private static final TIntIntHashMap _pets = new TIntIntHashMap();

    public static CharSummonTable getInstance() {
        return SingletonHolder._instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        int refId;
        int ownerId;
        ResultSet rset;
        PreparedStatement statement;
        Connection con = null;
        if (Config.RESTORE_SERVITOR_ON_RECONNECT) {
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement(INIT_SUMMONS);
                rset = statement.executeQuery();
                while (rset.next()) {
                    ownerId = rset.getInt("ownerId");
                    refId = rset.getInt("summonSkillId");
                    _servitors.put(ownerId, refId);
                }
                rset.close();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error while loading saved summons", e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
        if (Config.RESTORE_PET_ON_RECONNECT) {
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement(INIT_PET);
                rset = statement.executeQuery();
                while (rset.next()) {
                    ownerId = rset.getInt("ownerId");
                    refId = rset.getInt("item_obj_id");
                    _pets.put(ownerId, refId);
                }
                rset.close();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error while loading saved summons", e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }
    }

    public TIntIntHashMap getServitors() {
        return _servitors;
    }

    public TIntIntHashMap getPets() {
        return _pets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSummon(L2SummonInstance summon) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(SAVE_SUMMON);
            statement.setInt(1, summon.getOwner().getObjectId());
            statement.setInt(2, summon.getReferenceSkill());
            statement.setInt(3, (int)Math.round(summon.getCurrentHp()));
            statement.setInt(4, (int)Math.round(summon.getCurrentMp()));
            statement.setInt(5, summon.getTimeRemaining());
            statement.execute();
            statement.close();
            _servitors.put(summon.getOwner().getObjectId(), summon.getReferenceSkill());
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed to store summon [SummonId: " + summon.getNpcId() + "] from Char [CharId: " + summon.getOwner().getObjectId() + "] data", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restoreServitor(L2PcInstance activeChar) {
        con = null;
        try {
            skillId = CharSummonTable._servitors.get(activeChar.getObjectId());
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT curHp, curMp, time FROM character_summons WHERE ownerId = ? AND summonSkillId = ?");
            statement.setInt(1, activeChar.getObjectId());
            statement.setInt(2, skillId);
            rset = statement.executeQuery();
lbl9:
            // 2 sources

            while (rset.next()) {
                curHp = rset.getInt("curHp");
                curMp = rset.getInt("curMp");
                time = rset.getInt("time");
                skill = (L2SkillSummon)SkillTable.getInstance().getInfo(skillId, activeChar.getSkillLevel(skillId));
                if (skill != null) ** GOTO lbl-1000
                this.removeServitor(activeChar);
                ** GOTO lbl25
            }
            ** GOTO lbl50
        }
        catch (SQLException e) {
            try {
                CharSummonTable._log.log(Level.WARNING, "[CharSummonTable]: Summon cannot be restored: ", e);
            }
            catch (Throwable var12_13) {
                L2DatabaseFactory.close(con);
                throw var12_13;
            }
lbl25:
            // 1 sources

            L2DatabaseFactory.close(con);
            return;
lbl-1000:
            // 1 sources

            {
                summonTemplate = NpcTable.getInstance().getTemplate(skill.getNpcId());
                if (summonTemplate != null) ** GOTO lbl-1000
                CharSummonTable._log.warning("[CharSummonTable] Summon attemp for nonexisting Skill ID:" + skillId);
            }
            L2DatabaseFactory.close(con);
            return;
lbl-1000:
            // 1 sources

            {
                summon = summonTemplate.type.equalsIgnoreCase("L2SiegeSummon") != false ? new L2SiegeSummonInstance(IdFactory.getInstance().getNextId(), summonTemplate, activeChar, skill) : new L2SummonInstance(IdFactory.getInstance().getNextId(), summonTemplate, activeChar, skill);
                summon.setName(summonTemplate.name);
                summon.setTitle(activeChar.getName());
                summon.setExpPenalty(skill.getExpPenalty());
                if (summon.getLevel() >= 87) {
                    summon.getStat().setExp(Experience.LEVEL[86]);
                    CharSummonTable._log.warning("Summon (" + summon.getName() + ") NpcID: " + summon.getNpcId() + " has a level above 86. Please rectify.");
                } else {
                    summon.getStat().setExp(Experience.LEVEL[summon.getLevel() % 87]);
                }
                summon.setCurrentHp(curHp);
                summon.setCurrentMp(curMp);
                summon.setHeading(activeChar.getHeading());
                summon.setRunning();
                if (!(summon instanceof L2MerchantSummonInstance)) {
                    activeChar.setPet(summon);
                }
                summon.setTimeRemaining(time);
                summon.spawnMe(activeChar.getX() + 20, activeChar.getY() + 20, activeChar.getZ());
                ** GOTO lbl9
lbl50:
                // 1 sources

                rset.close();
                statement.close();
            }
            L2DatabaseFactory.close(con);
            return;
            L2DatabaseFactory.close(con);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServitor(L2PcInstance activeChar) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(REMOVE_SUMMON);
            statement.setInt(1, activeChar.getObjectId());
            statement.execute();
            statement.close();
            _servitors.remove(activeChar.getObjectId());
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "[CharSummonTable]: Summon cannot be removed: ", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void restorePet(L2PcInstance activeChar) {
        L2ItemInstance item = activeChar.getInventory().getItemByObjectId(_pets.get(activeChar.getObjectId()));
        L2SummonItem sitem = SummonItemsData.getInstance().getSummonItem(item.getItemId());
        L2NpcTemplate npcTemplate = NpcTable.getInstance().getTemplate(sitem.getNpcId());
        if (npcTemplate == null) {
            return;
        }
        L2PetInstance petSummon = L2PetInstance.spawnPet(npcTemplate, activeChar, item);
        if (petSummon == null) {
            return;
        }
        petSummon.setShowSummonAnimation(true);
        petSummon.setTitle(activeChar.getName());
        if (!petSummon.isRespawned()) {
            petSummon.setCurrentHp(petSummon.getMaxHp());
            petSummon.setCurrentMp(petSummon.getMaxMp());
            petSummon.getStat().setExp(petSummon.getExpForThisLevel());
            petSummon.setCurrentFed(petSummon.getMaxFed());
        }
        petSummon.setRunning();
        if (!petSummon.isRespawned()) {
            petSummon.store();
        }
        activeChar.setPet(petSummon);
        petSummon.spawnMe(activeChar.getX() + 50, activeChar.getY() + 100, activeChar.getZ());
        petSummon.startFeed();
        item.setEnchantLevel(petSummon.getLevel());
        if (petSummon.getCurrentFed() <= 0) {
            petSummon.unSummon(activeChar);
        } else {
            petSummon.startFeed();
        }
        petSummon.setFollowStatus(true);
        petSummon.getOwner().sendPacket(new PetItemList(petSummon));
        petSummon.broadcastStatusUpdate();
    }

    private static class SingletonHolder {
        protected static final CharSummonTable _instance = new CharSummonTable();

        private SingletonHolder() {
        }
    }
}

