/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2PledgeSkillLearn;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2TransformSkillLearn;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.ClassId;
import gnu.trove.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class SkillTreeTable {
    private static Logger _log = Logger.getLogger(SkillTreeTable.class.getName());
    private Map<ClassId, Map<Integer, L2SkillLearn>> _skillTrees;
    private List<L2SkillLearn> _fishingSkillTrees;
    private List<L2SkillLearn> _expandDwarfCraftSkillTrees;
    private List<L2PledgeSkillLearn> _pledgeSkillTrees;
    private List<L2TransformSkillLearn> _TransformSkillTrees;
    private FastList<L2SkillLearn> _specialSkillTrees;
    private TIntObjectHashMap<int[]> _skillsByClassIdHashCodes;
    private TIntObjectHashMap<int[]> _skillsByRaceHashCodes;
    private int[] _allSkillsHashCodes;
    private boolean _loading = true;

    public static SkillTreeTable getInstance() {
        return SingletonHolder._instance;
    }

    private SkillTreeTable() {
        this.load();
    }

    public int getExpertiseLevel(int grade) {
        int skillHashCode;
        if (grade <= 0) {
            return 0;
        }
        Map<Integer, L2SkillLearn> learnMap = this.getSkillTrees().get((Object)ClassId.paladin);
        if (learnMap.containsKey(skillHashCode = SkillTable.getSkillHashCode(239, grade))) {
            return learnMap.get(skillHashCode).getMinLevel();
        }
        _log.severe("Expertise not found for grade " + grade);
        return 0;
    }

    public int getMinSkillLevel(int skillId, ClassId classId, int skillLvl) {
        int skillHashCode;
        Map<Integer, L2SkillLearn> map = this.getSkillTrees().get((Object)classId);
        if (map.containsKey(skillHashCode = SkillTable.getSkillHashCode(skillId, skillLvl))) {
            return map.get(skillHashCode).getMinLevel();
        }
        return 0;
    }

    public int getMinSkillLevel(int skillId, int skillLvl) {
        int skillHashCode = SkillTable.getSkillHashCode(skillId, skillLvl);
        for (Map<Integer, L2SkillLearn> map : this.getSkillTrees().values()) {
            if (!map.containsKey(skillHashCode)) continue;
            return map.get(skillHashCode).getMinLevel();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        this._loading = true;
        int classId = 0;
        int count = 0;
        Connection con = null;
        try {
            String name;
            int id;
            PreparedStatement statement;
            con = L2DatabaseFactory.getInstance().getConnection();
            try {
                statement = con.prepareStatement("SELECT * FROM class_list ORDER BY id");
                ResultSet classlist = statement.executeQuery();
                PreparedStatement statement2 = con.prepareStatement("SELECT class_id, skill_id, level, name, sp, min_level, learned_by_npc, learned_by_fs, is_transfer, is_autoget FROM skill_trees where class_id=? ORDER BY skill_id, level");
                while (classlist.next()) {
                    FastMap map = new FastMap();
                    int parentClassId = classlist.getInt("parent_id");
                    classId = classlist.getInt("id");
                    statement2.setInt(1, classId);
                    ResultSet skilltree = statement2.executeQuery();
                    statement2.clearParameters();
                    if (parentClassId != -1) {
                        Map<Integer, L2SkillLearn> parentMap = this.getSkillTrees().get((Object)ClassId.values()[parentClassId]);
                        map.putAll(parentMap);
                    }
                    int prevSkillId = -1;
                    while (skilltree.next()) {
                        int id2 = skilltree.getInt("skill_id");
                        int lvl = skilltree.getInt("level");
                        String name2 = skilltree.getString("name");
                        int minLvl = skilltree.getInt("min_level");
                        int cost = skilltree.getInt("sp");
                        boolean npc = skilltree.getBoolean("learned_by_npc");
                        boolean fs = skilltree.getBoolean("learned_by_fs");
                        boolean trans = skilltree.getBoolean("is_transfer");
                        boolean autoget = skilltree.getBoolean("is_autoget");
                        if (prevSkillId != id2) {
                            prevSkillId = id2;
                        }
                        L2SkillLearn skillLearn = new L2SkillLearn(id2, lvl, minLvl, name2, cost, 0, 0, npc, fs, trans, autoget);
                        map.put(SkillTable.getSkillHashCode(id2, lvl), skillLearn);
                    }
                    this.getSkillTrees().put(ClassId.values()[classId], (Map<Integer, L2SkillLearn>)map);
                    skilltree.close();
                    count += map.size();
                    _log.fine("SkillTreeTable: skill tree for class " + classId + " has " + map.size() + " skills");
                }
                classlist.close();
                statement.close();
                statement2.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error while creating skill tree (Class ID " + classId + "): " + e.getMessage(), e);
            }
            _log.info("SkillTreeTable: Loaded " + count + " skills.");
            try {
                this._fishingSkillTrees = new FastList();
                this._expandDwarfCraftSkillTrees = new FastList();
                statement = con.prepareStatement("SELECT skill_id, level, name, sp, min_level, costid, cost, is_for_dwarf, learned_by_npc, learned_by_fs FROM fishing_skill_trees ORDER BY skill_id, level");
                ResultSet skilltree2 = statement.executeQuery();
                int prevSkillId = -1;
                while (skilltree2.next()) {
                    id = skilltree2.getInt("skill_id");
                    int lvl = skilltree2.getInt("level");
                    name = skilltree2.getString("name");
                    int minLvl = skilltree2.getInt("min_level");
                    int cost = skilltree2.getInt("sp");
                    int costId = skilltree2.getInt("costid");
                    int costCount = skilltree2.getInt("cost");
                    boolean isDwarven = skilltree2.getBoolean("is_for_dwarf");
                    boolean npc = skilltree2.getBoolean("learned_by_npc");
                    boolean fs = skilltree2.getBoolean("learned_by_fs");
                    if (prevSkillId != id) {
                        prevSkillId = id;
                    }
                    L2SkillLearn skill = new L2SkillLearn(id, lvl, minLvl, name, cost, costId, costCount, npc, fs, false, false);
                    if (isDwarven) {
                        this._expandDwarfCraftSkillTrees.add(skill);
                        continue;
                    }
                    this._fishingSkillTrees.add(skill);
                }
                skilltree2.close();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error while creating fishing skill table: " + e.getMessage(), e);
            }
            try {
                this._pledgeSkillTrees = new FastList();
                statement = con.prepareStatement("SELECT skill_id, level, name, clan_lvl, repCost, itemId, itemCount FROM pledge_skill_trees ORDER BY skill_id, level");
                ResultSet skilltree4 = statement.executeQuery();
                int prevSkillId = -1;
                while (skilltree4.next()) {
                    id = skilltree4.getInt("skill_id");
                    int lvl = skilltree4.getInt("level");
                    name = skilltree4.getString("name");
                    int baseLvl = skilltree4.getInt("clan_lvl");
                    int sp = skilltree4.getInt("repCost");
                    int itemId = skilltree4.getInt("itemId");
                    int itemCount = skilltree4.getInt("itemCount");
                    if (prevSkillId != id) {
                        prevSkillId = id;
                    }
                    L2PledgeSkillLearn skill = new L2PledgeSkillLearn(id, lvl, baseLvl, name, sp, itemId, itemCount);
                    this._pledgeSkillTrees.add(skill);
                }
                skilltree4.close();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error while creating pledge skill table: " + e.getMessage(), e);
            }
            try {
                this._TransformSkillTrees = new FastList();
                statement = con.prepareStatement("SELECT race_id, skill_id, item_id, level, name, sp, min_level FROM transform_skill_trees ORDER BY race_id, skill_id, level");
                ResultSet skilltree5 = statement.executeQuery();
                int prevSkillId = -1;
                while (skilltree5.next()) {
                    int race_id = skilltree5.getInt("race_id");
                    int skill_id = skilltree5.getInt("skill_id");
                    int item_id = skilltree5.getInt("item_id");
                    int level = skilltree5.getInt("level");
                    String name3 = skilltree5.getString("name");
                    int sp = skilltree5.getInt("sp");
                    int min_level = skilltree5.getInt("min_level");
                    if (prevSkillId != skill_id) {
                        prevSkillId = skill_id;
                    }
                    L2TransformSkillLearn skill = new L2TransformSkillLearn(race_id, skill_id, item_id, level, name3, sp, min_level);
                    this._TransformSkillTrees.add(skill);
                }
                skilltree5.close();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error while creating Transformation skill table ", e);
            }
            try {
                this._specialSkillTrees = new FastList();
                statement = con.prepareStatement("SELECT skill_id, level, name, costid, cost, learned_by_npc, learned_by_fs FROM special_skill_trees ORDER BY skill_id, level");
                ResultSet skilltree6 = statement.executeQuery();
                int prevSkillId = -1;
                while (skilltree6.next()) {
                    id = skilltree6.getInt("skill_id");
                    int lvl = skilltree6.getInt("level");
                    String name4 = skilltree6.getString("name");
                    int costId = skilltree6.getInt("costid");
                    int costCount = skilltree6.getInt("cost");
                    boolean npc = skilltree6.getBoolean("learned_by_npc");
                    boolean fs = skilltree6.getBoolean("learned_by_fs");
                    if (prevSkillId != id) {
                        prevSkillId = id;
                    }
                    L2SkillLearn skill = new L2SkillLearn(id, lvl, 0, name4, 0, costId, costCount, npc, fs, false, false);
                    this._specialSkillTrees.add((Object)skill);
                }
                skilltree6.close();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error while creating special skill table: " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error while skill tables ", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this.generateCheckArrays();
        _log.info("FishingSkillTreeTable: Loaded " + this._fishingSkillTrees.size() + " general skills.");
        _log.info("DwarvenCraftSkillTreeTable: Loaded " + this._expandDwarfCraftSkillTrees.size() + " dwarven skills.");
        _log.info("PledgeSkillTreeTable: Loaded " + this._pledgeSkillTrees.size() + " pledge skills");
        _log.info("TransformSkillTreeTable: Loaded " + this._TransformSkillTrees.size() + " transform skills");
        _log.info("SpecialSkillTreeTable: Loaded " + this._specialSkillTrees.size() + " special skills");
        this._loading = false;
    }

    /*
     * Exception decompiling
     */
    private void generateCheckArrays() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundSuperForBase(org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance)" because "bindingSuperContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.getIterableIterType(LoopLivenessClash.java:35)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.LoopLivenessClash.detect(LoopLivenessClash.java:25)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:827)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<ClassId, Map<Integer, L2SkillLearn>> getSkillTrees() {
        if (this._skillTrees == null) {
            this._skillTrees = new FastMap();
        }
        return this._skillTrees;
    }

    public L2SkillLearn[] getAvailableSkills(L2PcInstance cha, ClassId classId) {
        FastList result = new FastList();
        Collection<L2SkillLearn> skills = this.getSkillTrees().get((Object)classId).values();
        if (skills == null) {
            _log.warning("Skilltree for class " + (Object)((Object)classId) + " is not defined !");
            return new L2SkillLearn[0];
        }
        L2Skill[] oldSkills = cha.getAllSkills();
        for (L2SkillLearn temp : skills) {
            if (!temp.isAutoGetSkill() && (!temp.isLearnedByNPC() || temp.isTransferSkill()) || temp.getMinLevel() > cha.getLevel()) continue;
            boolean knownSkill = false;
            for (int j = 0; j < oldSkills.length && !knownSkill; ++j) {
                if (oldSkills[j].getId() != temp.getId()) continue;
                knownSkill = true;
                if (oldSkills[j].getLevel() != temp.getLevel() - 1) continue;
                result.add(temp);
            }
            if (knownSkill || temp.getLevel() != 1) continue;
            result.add(temp);
        }
        return result.toArray(new L2SkillLearn[result.size()]);
    }

    public L2SkillLearn[] getAvailableSkills(L2PcInstance cha) {
        FastList result = new FastList();
        FastList skills = new FastList();
        skills.addAll(this._fishingSkillTrees);
        if (skills.size() == 0) {
            _log.warning("SkillTree for fishing is not defined !");
            return new L2SkillLearn[0];
        }
        if (cha.hasDwarvenCraft() && this._expandDwarfCraftSkillTrees != null) {
            skills.addAll(this._expandDwarfCraftSkillTrees);
        }
        L2Skill[] oldSkills = cha.getAllSkills();
        for (L2SkillLearn temp : skills) {
            if (!temp.isLearnedByNPC() || temp.getMinLevel() > cha.getLevel()) continue;
            boolean knownSkill = false;
            for (int j = 0; j < oldSkills.length && !knownSkill; ++j) {
                if (oldSkills[j].getId() != temp.getId()) continue;
                knownSkill = true;
                if (oldSkills[j].getLevel() != temp.getLevel() - 1) continue;
                result.add(temp);
            }
            if (knownSkill || temp.getLevel() != 1) continue;
            result.add(temp);
        }
        return result.toArray(new L2SkillLearn[result.size()]);
    }

    public L2SkillLearn[] getAvailableSpecialSkills(L2PcInstance cha) {
        FastList result = new FastList();
        FastList skills = new FastList();
        skills.addAll(this._specialSkillTrees);
        if (skills.size() == 0) {
            _log.warning("Skilltree for special is not defined !");
            return new L2SkillLearn[0];
        }
        L2Skill[] oldSkills = cha.getAllSkills();
        for (L2SkillLearn temp : skills) {
            boolean knownSkill = false;
            for (int j = 0; j < oldSkills.length && !knownSkill; ++j) {
                if (oldSkills[j].getId() != temp.getId()) continue;
                knownSkill = true;
                if (oldSkills[j].getLevel() != temp.getLevel() - 1) continue;
                result.add(temp);
            }
            if (knownSkill || temp.getLevel() != 1) continue;
            result.add(temp);
        }
        return result.toArray(new L2SkillLearn[result.size()]);
    }

    public L2TransformSkillLearn[] getAvailableTransformSkills(L2PcInstance cha) {
        FastList result = new FastList();
        List<L2TransformSkillLearn> skills = this._TransformSkillTrees;
        if (skills == null) {
            _log.warning("No Transform skills defined!");
            return new L2TransformSkillLearn[0];
        }
        L2Skill[] oldSkills = cha.getAllSkills();
        for (L2TransformSkillLearn temp : skills) {
            if (temp.getMinLevel() > cha.getLevel() || temp.getRace() != cha.getRace().ordinal() && temp.getRace() != -1) continue;
            boolean knownSkill = false;
            for (int j = 0; j < oldSkills.length && !knownSkill; ++j) {
                if (oldSkills[j].getId() != temp.getId()) continue;
                knownSkill = true;
                if (oldSkills[j].getLevel() != temp.getLevel() - 1) continue;
                result.add(temp);
            }
            if (knownSkill || temp.getLevel() != 1) continue;
            result.add(temp);
        }
        return result.toArray(new L2TransformSkillLearn[result.size()]);
    }

    public L2PledgeSkillLearn[] getAvailablePledgeSkills(L2PcInstance cha) {
        FastList result = new FastList();
        List<L2PledgeSkillLearn> skills = this._pledgeSkillTrees;
        if (skills == null) {
            _log.warning("No clan skills defined!");
            return new L2PledgeSkillLearn[0];
        }
        L2Skill[] oldSkills = cha.getClan().getAllSkills();
        for (L2PledgeSkillLearn temp : skills) {
            if (temp.getBaseLevel() > cha.getClan().getLevel()) continue;
            boolean knownSkill = false;
            for (int j = 0; j < oldSkills.length && !knownSkill; ++j) {
                if (oldSkills[j].getId() != temp.getId()) continue;
                knownSkill = true;
                if (oldSkills[j].getLevel() != temp.getLevel() - 1) continue;
                result.add(temp);
            }
            if (knownSkill || temp.getLevel() != 1) continue;
            result.add(temp);
        }
        return result.toArray(new L2PledgeSkillLearn[result.size()]);
    }

    public Collection<L2SkillLearn> getAllowedSkills(ClassId classId) {
        return this.getSkillTrees().get((Object)classId).values();
    }

    public int getMinLevelForNewSkill(L2PcInstance cha, ClassId classId) {
        int minLevel = 0;
        Collection<L2SkillLearn> skills = this.getSkillTrees().get((Object)classId).values();
        if (skills == null) {
            _log.warning("Skilltree for class " + (Object)((Object)classId) + " is not defined !");
            return minLevel;
        }
        for (L2SkillLearn temp : skills) {
            if (temp.getMinLevel() <= cha.getLevel() || temp.getSpCost() == 0 || minLevel != 0 && temp.getMinLevel() >= minLevel) continue;
            minLevel = temp.getMinLevel();
        }
        return minLevel;
    }

    public int getMinLevelForNewSkill(L2PcInstance cha) {
        int minLevel = 0;
        FastList skills = new FastList();
        skills.addAll(this._fishingSkillTrees);
        if (skills.size() == 0) {
            _log.warning("SkillTree for fishing is not defined !");
            return minLevel;
        }
        if (cha.hasDwarvenCraft() && this._expandDwarfCraftSkillTrees != null) {
            skills.addAll(this._expandDwarfCraftSkillTrees);
        }
        for (L2SkillLearn s : skills) {
            if (s.getMinLevel() <= cha.getLevel() || minLevel != 0 && s.getMinLevel() >= minLevel) continue;
            minLevel = s.getMinLevel();
        }
        return minLevel;
    }

    public int getMinLevelForNewTransformSkill(L2PcInstance cha) {
        int minLevel = 0;
        FastList skills = new FastList();
        skills.addAll(this._TransformSkillTrees);
        if (skills.size() == 0) {
            _log.warning("SkillTree for fishing is not defined !");
            return minLevel;
        }
        for (L2TransformSkillLearn s : skills) {
            if (s.getMinLevel() <= cha.getLevel() || s.getRace() != cha.getRace().ordinal() || minLevel != 0 && s.getMinLevel() >= minLevel) continue;
            minLevel = s.getMinLevel();
        }
        return minLevel;
    }

    public int getSkillCost(L2PcInstance player, L2Skill skill) {
        ClassId classId = player.getSkillLearningClassId();
        return this.getSkillCost(player, skill, classId);
    }

    public int getSkillCost(L2PcInstance player, L2Skill skill, ClassId classId) {
        L2SkillLearn skillLearn;
        int skillCost = 100000000;
        if (classId == null) {
            return skillCost;
        }
        int skillHashCode = SkillTable.getSkillHashCode(skill);
        if (this.getSkillTrees().get((Object)classId).containsKey(skillHashCode) && (skillLearn = this.getSkillTrees().get((Object)classId).get(skillHashCode)).getMinLevel() <= player.getLevel()) {
            skillCost = skillLearn.getSpCost();
            if (!player.getClassId().equalsOrChildOf(classId)) {
                return skillCost;
            }
        }
        return skillCost;
    }

    public L2SkillLearn getSkillLearnBySkillIdLevel(ClassId classId, int skillId, int skillLvl) {
        for (L2SkillLearn sl : this.getAllowedSkills(classId)) {
            if (sl.getId() != skillId || sl.getLevel() != skillLvl) continue;
            return sl;
        }
        return null;
    }

    public List<Integer> getAllAllowedSkillId(L2PcInstance player) {
        FastList skills = new FastList();
        for (L2SkillLearn tmp : this.getAllowedSkills(player.getClassId())) {
            if (!skills.contains((Object)tmp.getId())) continue;
            skills.add((Object)tmp.getId());
        }
        return skills;
    }

    public boolean isSkillAllowed(L2PcInstance player, L2Skill skill) {
        if (skill.isExcludedFromCheck()) {
            return true;
        }
        if (player.isGM() && skill.isGMSkill()) {
            return true;
        }
        if (this._loading) {
            return true;
        }
        int maxLvl = SkillTable.getInstance().getMaxLevel(skill.getId());
        int hashCode = SkillTable.getSkillHashCode(skill.getId(), Math.min(skill.getLevel(), maxLvl));
        if (Arrays.binarySearch((int[])this._skillsByClassIdHashCodes.get(player.getClassId().ordinal()), hashCode) >= 0) {
            return true;
        }
        if (Arrays.binarySearch((int[])this._skillsByRaceHashCodes.get(player.getRace().ordinal()), hashCode) >= 0) {
            return true;
        }
        return Arrays.binarySearch(this._allSkillsHashCodes, hashCode) >= 0;
    }

    public void reload() {
        this.load();
    }

    private static class SingletonHolder {
        protected static final SkillTreeTable _instance = new SkillTreeTable();

        private SingletonHolder() {
        }
    }
}

