/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2PetLevelData;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;

public class L2PetData {
    private TIntObjectHashMap<L2PetLevelData> _levelStats = new TIntObjectHashMap();
    private List<L2PetSkillLearn> _skills = new ArrayList<L2PetSkillLearn>();
    private int _load = 20000;
    private int _hungry_limit = 1;
    private int _minlvl = 127;
    private int[] _food = new int[0];

    public void addNewStat(L2PetLevelData data, int level) {
        if (this._minlvl > level) {
            this._minlvl = level;
        }
        this._levelStats.put(level, (Object)data);
    }

    public L2PetLevelData getPetLevelData(int petLevel) {
        return (L2PetLevelData)this._levelStats.get(petLevel);
    }

    public int getLoad() {
        return this._load;
    }

    public int getHungry_limit() {
        return this._hungry_limit;
    }

    public int getMinLevel() {
        return this._minlvl;
    }

    public int[] getFood() {
        return this._food;
    }

    public void set_load(int _load) {
        this._load = _load;
    }

    public void set_hungry_limit(int _hungry_limit) {
        this._hungry_limit = _hungry_limit;
    }

    public void set_food(int[] _food) {
        this._food = _food;
    }

    public void addNewSkill(int id, int lvl, int petLvl) {
        this._skills.add(new L2PetSkillLearn(id, lvl, petLvl));
    }

    public int getAvailableLevel(int skillId, int petLvl) {
        int lvl = 0;
        for (L2PetSkillLearn temp : this._skills) {
            if (temp.getId() != skillId) continue;
            if (temp.getLevel() == 0) {
                int maxLvl;
                if (petLvl < 70) {
                    lvl = petLvl / 10;
                    if (lvl <= 0) {
                        lvl = 1;
                    }
                } else {
                    lvl = 7 + (petLvl - 70) / 5;
                }
                if (lvl <= (maxLvl = SkillTable.getInstance().getMaxLevel(temp.getId()))) break;
                lvl = maxLvl;
                break;
            }
            if (temp.getMinLevel() > petLvl || temp.getLevel() <= lvl) continue;
            lvl = temp.getLevel();
        }
        return lvl;
    }

    public List<L2PetSkillLearn> getAvailableSkills() {
        return this._skills;
    }

    public static final class L2PetSkillLearn {
        private final int _id;
        private final int _level;
        private final int _minLevel;

        public L2PetSkillLearn(int id, int lvl, int minLvl) {
            this._id = id;
            this._level = lvl;
            this._minLevel = minLvl;
        }

        public int getId() {
            return this._id;
        }

        public int getLevel() {
            return this._level;
        }

        public int getMinLevel() {
            return this._minLevel;
        }
    }
}

