/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ItemsAutoDestroy;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2AttackableAI;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2FortSiegeGuardAI;
import com.l2jserver.gameserver.ai.L2SiegeGuardAI;
import com.l2jserver.gameserver.datatables.EventDroplist;
import com.l2jserver.gameserver.datatables.HerbDropTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2CommandChannel;
import com.l2jserver.gameserver.model.L2DropCategory;
import com.l2jserver.gameserver.model.L2DropData;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Manor;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.model.actor.knownlist.AttackableKnownList;
import com.l2jserver.gameserver.model.actor.status.AttackableStatus;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javolution.util.FastList;
import javolution.util.FastMap;

public class L2Attackable
extends L2Npc {
    private boolean _isRaid = false;
    private boolean _isRaidMinion = false;
    private boolean _champion = false;
    private FastMap<L2Character, AggroInfo> _aggroList = new FastMap().shared();
    private boolean _isReturningToSpawnPoint = false;
    private boolean _canReturnToSpawnPoint = true;
    private boolean _seeThroughSilentMove = false;
    private RewardItem[] _sweepItems;
    private RewardItem[] _harvestItems;
    private boolean _seeded;
    private int _seedType = 0;
    private int _seederObjId = 0;
    private boolean _overhit;
    private double _overhitDamage;
    private L2Character _overhitAttacker;
    private L2CommandChannel _firstCommandChannelAttacked = null;
    private CommandChannelTimer _commandChannelTimer = null;
    private long _commandChannelLastAttack = 0L;
    private boolean _absorbed;
    private FastMap<Integer, AbsorberInfo> _absorbersList = new FastMap().shared();
    private boolean _mustGiveExpSp;
    private boolean _isSpoil = false;
    private int _isSpoiledBy = 0;
    private int _onKillDelay = 5000;

    public final FastMap<L2Character, AggroInfo> getAggroList() {
        return this._aggroList;
    }

    public final boolean isReturningToSpawnPoint() {
        return this._isReturningToSpawnPoint;
    }

    public final void setisReturningToSpawnPoint(boolean value) {
        this._isReturningToSpawnPoint = value;
    }

    public final boolean canReturnToSpawnPoint() {
        return this._canReturnToSpawnPoint;
    }

    public final void setCanReturnToSpawnPoint(boolean value) {
        this._canReturnToSpawnPoint = value;
    }

    public boolean canSeeThroughSilentMove() {
        return this._seeThroughSilentMove;
    }

    public void setSeeThroughSilentMove(boolean val) {
        this._seeThroughSilentMove = val;
    }

    public L2Attackable(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2Attackable);
        this.setIsInvul(false);
        this._mustGiveExpSp = true;
    }

    @Override
    public AttackableKnownList getKnownList() {
        return (AttackableKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new AttackableKnownList(this));
    }

    @Override
    public AttackableStatus getStatus() {
        return (AttackableStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new AttackableStatus(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public L2CharacterAI getAI() {
        L2CharacterAI ai = this._ai;
        if (ai == null) {
            L2Attackable l2Attackable = this;
            synchronized (l2Attackable) {
                if (this._ai == null) {
                    this._ai = new L2AttackableAI(new L2Character.AIAccessor(this));
                }
                return this._ai;
            }
        }
        return ai;
    }

    @Deprecated
    public boolean getCondition2(L2Character target) {
        if (target instanceof L2NpcInstance || target instanceof L2DoorInstance) {
            return false;
        }
        if (target.isAlikeDead() || !this.isInsideRadius(target, this.getAggroRange(), false, false) || Math.abs(this.getZ() - target.getZ()) > 100) {
            return false;
        }
        return !target.isInvul();
    }

    public void useMagic(L2Skill skill) {
        if (skill == null || this.isAlikeDead()) {
            return;
        }
        if (skill.isPassive()) {
            return;
        }
        if (this.isCastingNow()) {
            return;
        }
        if (this.isSkillDisabled(skill)) {
            return;
        }
        if (this.getCurrentMp() < (double)(this.getStat().getMpConsume(skill) + this.getStat().getMpInitialConsume(skill))) {
            return;
        }
        if (this.getCurrentHp() <= (double)skill.getHpConsume()) {
            return;
        }
        if (skill.isMagic() ? this.isMuted() : this.isPhysicalMuted()) {
            return;
        }
        L2Object target = skill.getFirstOfTargetList(this);
        if (target == null) {
            return;
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_CAST, skill, target);
    }

    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, L2Skill skill) {
        this.reduceCurrentHp(damage, attacker, true, false, skill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, boolean awake, boolean isDOT, L2Skill skill) {
        if (this.isRaid() && !this.isMinion() && attacker != null && attacker.getParty() != null && attacker.getParty().isInCommandChannel() && attacker.getParty().getCommandChannel().meetRaidWarCondition(this)) {
            if (this._firstCommandChannelAttacked == null) {
                L2Attackable l2Attackable = this;
                synchronized (l2Attackable) {
                    if (this._firstCommandChannelAttacked == null) {
                        this._firstCommandChannelAttacked = attacker.getParty().getCommandChannel();
                        if (this._firstCommandChannelAttacked != null) {
                            this._commandChannelTimer = new CommandChannelTimer(this);
                            this._commandChannelLastAttack = System.currentTimeMillis();
                            ThreadPoolManager.getInstance().scheduleGeneral(this._commandChannelTimer, 10000L);
                            this._firstCommandChannelAttacked.broadcastToChannelMembers(new CreatureSay(0, 16, "", "You have looting rights!"));
                        }
                    }
                }
            } else if (attacker.getParty().getCommandChannel().equals(this._firstCommandChannelAttacked)) {
                this._commandChannelLastAttack = System.currentTimeMillis();
            }
        }
        if (this.isEventMob) {
            return;
        }
        if (attacker != null) {
            this.addDamage(attacker, (int)damage, skill);
        }
        if (this instanceof L2MonsterInstance) {
            L2MonsterInstance master = (L2MonsterInstance)this;
            if (master.hasMinions()) {
                master.getMinionList().onAssist(this, attacker);
            }
            if ((master = master.getLeader()) != null && master.hasMinions()) {
                master.getMinionList().onAssist(this, attacker);
            }
        }
        super.reduceCurrentHp(damage, attacker, awake, isDOT, skill);
    }

    public synchronized void setMustRewardExpSp(boolean value) {
        this._mustGiveExpSp = value;
    }

    public synchronized boolean getMustRewardExpSP() {
        return this._mustGiveExpSp;
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        try {
            L2PcInstance player = null;
            if (killer != null) {
                player = killer.getActingPlayer();
            }
            if (player != null && this.getTemplate().getEventQuests(Quest.QuestEventType.ON_KILL) != null) {
                for (Quest quest : this.getTemplate().getEventQuests(Quest.QuestEventType.ON_KILL)) {
                    ThreadPoolManager.getInstance().scheduleEffect(new OnKillNotifyTask(this, quest, player, killer instanceof L2Summon), this._onKillDelay);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
        return true;
    }

    @Override
    protected void calculateRewards(L2Character lastAttacker) {
        FastMap rewards = new FastMap().shared();
        try {
            RewardInfo reward;
            int damage;
            L2Character attacker;
            if (this.getAggroList().isEmpty()) {
                return;
            }
            L2PcInstance maxDealer = null;
            int maxDamage = 0;
            for (AggroInfo info : this.getAggroList().values()) {
                L2Character ddealer;
                if (info == null) continue;
                attacker = info.getAttacker();
                damage = info.getDamage();
                if (damage <= 1 || !Util.checkIfInRange(Config.ALT_PARTY_RANGE, this, ddealer = attacker instanceof L2SummonInstance || attacker instanceof L2PetInstance && ((L2PetInstance)attacker).getPetLevelData().getOwnerExpTaken() > 0 ? ((L2Summon)attacker).getOwner() : info.getAttacker(), true)) continue;
                reward = (RewardInfo)rewards.get((Object)ddealer);
                if (reward == null) {
                    reward = new RewardInfo(ddealer, damage);
                } else {
                    reward.addDamage(damage);
                }
                rewards.put((Object)ddealer, (Object)reward);
                if (ddealer.getActingPlayer() == null || reward._dmg <= maxDamage) continue;
                maxDealer = ddealer.getActingPlayer();
                maxDamage = reward._dmg;
            }
            this.doItemDrop(maxDealer != null && maxDealer.isOnline() ? maxDealer : lastAttacker);
            this.doEventDrop(lastAttacker);
            if (!this.getMustRewardExpSP()) {
                return;
            }
            if (!rewards.isEmpty()) {
                FastMap.Entry entry = rewards.head();
                FastMap.Entry end = rewards.tail();
                while ((entry = entry.getNext()) != end) {
                    int sp;
                    long exp;
                    int[] tmp;
                    int levelDiff;
                    L2Party attackerParty;
                    if (entry == null || (reward = (RewardInfo)entry.getValue()) == null) continue;
                    float penalty = 0.0f;
                    attacker = reward._attacker;
                    damage = reward._dmg;
                    if (attacker instanceof L2PetInstance) {
                        attackerParty = ((L2PetInstance)attacker).getParty();
                    } else if (attacker instanceof L2PcInstance) {
                        attackerParty = ((L2PcInstance)attacker).getParty();
                    } else {
                        return;
                    }
                    if (attacker instanceof L2PcInstance && ((L2PcInstance)attacker).getPet() instanceof L2SummonInstance) {
                        penalty = ((L2SummonInstance)((L2PcInstance)attacker).getPet()).getExpPenalty();
                    }
                    if (damage > this.getMaxHp()) {
                        damage = this.getMaxHp();
                    }
                    if (attackerParty == null) {
                        if (!attacker.getKnownList().knowsObject(this)) continue;
                        levelDiff = attacker.getLevel() - this.getLevel();
                        tmp = this.calculateExpAndSp(levelDiff, damage);
                        exp = tmp[0];
                        exp = (long)((float)exp * (1.0f - penalty));
                        sp = tmp[1];
                        if (Config.L2JMOD_CHAMPION_ENABLE && this.isChampion()) {
                            exp *= (long)Config.L2JMOD_CHAMPION_REWARDS;
                            sp *= Config.L2JMOD_CHAMPION_REWARDS;
                        }
                        if (attacker instanceof L2PcInstance) {
                            L2PcInstance player = (L2PcInstance)attacker;
                            if (this.isOverhit() && attacker == this.getOverhitAttacker()) {
                                player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.OVER_HIT));
                                exp += this.calculateOverhitExp(exp);
                            }
                        }
                        if (attacker.isDead()) continue;
                        long addexp = Math.round(attacker.calcStat(Stats.EXPSP_RATE, exp, null, null));
                        int addsp = (int)attacker.calcStat(Stats.EXPSP_RATE, sp, null, null);
                        if (attacker instanceof L2PcInstance) {
                            L2Skill skill;
                            L2PcInstance player = (L2PcInstance)attacker;
                            if (player.getSkillLevel(467) > 0 && (long)(skill = SkillTable.getInstance().getInfo(467, player.getSkillLevel(467))).getExpNeeded() <= addexp) {
                                player.absorbSoul(skill, this);
                            }
                            player.addExpAndSp(addexp, addsp, this.useVitalityRate());
                            if (addexp <= 0L) continue;
                            player.updateVitalityPoints(this.getVitalityPoints(damage), true, false);
                            continue;
                        }
                        attacker.addExpAndSp(addexp, addsp);
                        continue;
                    }
                    int partyDmg = 0;
                    float partyMul = 1.0f;
                    int partyLvl = 0;
                    FastList rewardedMembers = new FastList();
                    List<L2PcInstance> groupMembers = attackerParty.isInCommandChannel() ? attackerParty.getCommandChannel().getMembers() : attackerParty.getPartyMembers();
                    Iterator i$ = groupMembers.iterator();
                    while (i$.hasNext()) {
                        L2Summon summon;
                        L2PcInstance pl = (L2PcInstance)i$.next();
                        if (pl == null || pl.isDead()) continue;
                        RewardInfo reward2 = (RewardInfo)rewards.get((Object)pl);
                        if (reward2 != null) {
                            if (Util.checkIfInRange(Config.ALT_PARTY_RANGE, this, pl, true)) {
                                partyDmg += reward2._dmg;
                                rewardedMembers.add(pl);
                                if (pl.getLevel() > partyLvl) {
                                    partyLvl = attackerParty.isInCommandChannel() ? attackerParty.getCommandChannel().getLevel() : pl.getLevel();
                                }
                            }
                            rewards.remove((Object)pl);
                        } else if (Util.checkIfInRange(Config.ALT_PARTY_RANGE, this, pl, true)) {
                            rewardedMembers.add(pl);
                            if (pl.getLevel() > partyLvl) {
                                partyLvl = attackerParty.isInCommandChannel() ? attackerParty.getCommandChannel().getLevel() : pl.getLevel();
                            }
                        }
                        if ((summon = pl.getPet()) == null || !(summon instanceof L2PetInstance) || (reward2 = (RewardInfo)rewards.get((Object)summon)) == null) continue;
                        if (Util.checkIfInRange(Config.ALT_PARTY_RANGE, this, summon, true)) {
                            partyDmg += reward2._dmg;
                            rewardedMembers.add(summon);
                            if (summon.getLevel() > partyLvl) {
                                partyLvl = summon.getLevel();
                            }
                        }
                        rewards.remove((Object)summon);
                    }
                    if (partyDmg < this.getMaxHp()) {
                        partyMul = (float)partyDmg / (float)this.getMaxHp();
                    }
                    if (partyDmg > this.getMaxHp()) {
                        partyDmg = this.getMaxHp();
                    }
                    levelDiff = partyLvl - this.getLevel();
                    tmp = this.calculateExpAndSp(levelDiff, partyDmg);
                    exp = tmp[0];
                    sp = tmp[1];
                    if (Config.L2JMOD_CHAMPION_ENABLE && this.isChampion()) {
                        exp *= (long)Config.L2JMOD_CHAMPION_REWARDS;
                        sp *= Config.L2JMOD_CHAMPION_REWARDS;
                    }
                    exp = (long)((float)exp * partyMul);
                    sp = (int)((float)sp * partyMul);
                    if (attacker instanceof L2PcInstance) {
                        L2PcInstance player = (L2PcInstance)attacker;
                        if (this.isOverhit() && attacker == this.getOverhitAttacker()) {
                            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.OVER_HIT));
                            exp += this.calculateOverhitExp(exp);
                        }
                    }
                    if (partyDmg <= 0) continue;
                    attackerParty.distributeXpAndSp(exp, sp, (List<L2Playable>)rewardedMembers, partyLvl, partyDmg, this);
                }
            }
            rewards = null;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
    }

    @Override
    public void addAttackerToAttackByList(L2Character player) {
        if (player == null || player == this || this.getAttackByList().contains(player)) {
            return;
        }
        this.getAttackByList().add(player);
    }

    public void addDamage(L2Character attacker, int damage, L2Skill skill) {
        if (attacker == null) {
            return;
        }
        if (!this.isDead()) {
            try {
                L2PcInstance player = attacker.getActingPlayer();
                if (player != null) {
                    if (this.getTemplate().getEventQuests(Quest.QuestEventType.ON_ATTACK) != null) {
                        for (Quest quest : this.getTemplate().getEventQuests(Quest.QuestEventType.ON_ATTACK)) {
                            quest.notifyAttack(this, player, damage, attacker instanceof L2Summon, skill);
                        }
                    }
                } else {
                    this.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, attacker);
                    this.addDamageHate(attacker, damage, damage * 100 / (this.getLevel() + 7));
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public void addDamageHate(L2Character attacker, int damage, int aggro) {
        if (attacker == null) {
            return;
        }
        L2PcInstance targetPlayer = attacker.getActingPlayer();
        AggroInfo ai = (AggroInfo)this.getAggroList().get((Object)attacker);
        if (ai == null) {
            ai = new AggroInfo(attacker);
            this.getAggroList().put((Object)attacker, (Object)ai);
        }
        ai.addDamage(damage);
        if (targetPlayer == null || targetPlayer.getTrap() == null || !targetPlayer.getTrap().isTriggered()) {
            ai.addHate(aggro);
        }
        if (targetPlayer != null && aggro == 0) {
            if (this.getTemplate().getEventQuests(Quest.QuestEventType.ON_AGGRO_RANGE_ENTER) != null) {
                for (Quest quest : this.getTemplate().getEventQuests(Quest.QuestEventType.ON_AGGRO_RANGE_ENTER)) {
                    quest.notifyAggroRangeEnter(this, targetPlayer, attacker instanceof L2Summon);
                }
            }
        } else if (targetPlayer == null && aggro == 0) {
            aggro = 1;
            ai.addHate(1);
        }
        if (aggro > 0 && this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
    }

    public void reduceHate(L2Character target, int amount) {
        if (this.getAI() instanceof L2SiegeGuardAI || this.getAI() instanceof L2FortSiegeGuardAI) {
            this.stopHating(target);
            this.setTarget(null);
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
            return;
        }
        if (target == null) {
            L2Character mostHated = this.getMostHated();
            if (mostHated == null) {
                ((L2AttackableAI)this.getAI()).setGlobalAggro(-25);
                return;
            }
            for (L2Character aggroed : this.getAggroList().keySet()) {
                AggroInfo ai = (AggroInfo)this.getAggroList().get((Object)aggroed);
                if (ai == null) {
                    return;
                }
                ai.addHate(-amount);
            }
            amount = this.getHating(mostHated);
            if (amount <= 0) {
                ((L2AttackableAI)this.getAI()).setGlobalAggro(-25);
                this.clearAggroList();
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
                this.setWalking();
            }
            return;
        }
        AggroInfo ai = (AggroInfo)this.getAggroList().get((Object)target);
        if (ai == null) {
            return;
        }
        ai.addHate(-amount);
        if (ai.getHate() <= 0 && this.getMostHated() == null) {
            ((L2AttackableAI)this.getAI()).setGlobalAggro(-25);
            this.clearAggroList();
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            this.setWalking();
        }
    }

    public void stopHating(L2Character target) {
        if (target == null) {
            return;
        }
        AggroInfo ai = (AggroInfo)this.getAggroList().get((Object)target);
        if (ai != null) {
            ai.stopHate();
        }
    }

    public L2Character getMostHated() {
        if (this.getAggroList().isEmpty() || this.isAlikeDead()) {
            return null;
        }
        L2Character mostHated = null;
        int maxHate = 0;
        for (AggroInfo ai : this.getAggroList().values()) {
            if (ai == null || ai.checkHate(this) <= maxHate) continue;
            mostHated = ai.getAttacker();
            maxHate = ai.getHate();
        }
        return mostHated;
    }

    public List<L2Character> get2MostHated() {
        if (this.getAggroList().isEmpty() || this.isAlikeDead()) {
            return null;
        }
        L2Character mostHated = null;
        L2Character secondMostHated = null;
        int maxHate = 0;
        FastList result = new FastList();
        for (AggroInfo ai : this.getAggroList().values()) {
            if (ai == null || ai.checkHate(this) <= maxHate) continue;
            secondMostHated = mostHated;
            mostHated = ai.getAttacker();
            maxHate = ai.getHate();
        }
        result.add(mostHated);
        if (this.getAttackByList().contains(secondMostHated)) {
            result.add(secondMostHated);
        } else {
            result.add(null);
        }
        return result;
    }

    public List<L2Character> getHateList() {
        if (this.getAggroList().isEmpty() || this.isAlikeDead()) {
            return null;
        }
        FastList result = new FastList();
        for (AggroInfo ai : this.getAggroList().values()) {
            if (ai == null) continue;
            ai.checkHate(this);
            result.add(ai.getAttacker());
        }
        return result;
    }

    public int getHating(L2Character target) {
        L2PcInstance act;
        if (this.getAggroList().isEmpty() || target == null) {
            return 0;
        }
        AggroInfo ai = (AggroInfo)this.getAggroList().get((Object)target);
        if (ai == null) {
            return 0;
        }
        if (ai.getAttacker() instanceof L2PcInstance && ((act = (L2PcInstance)ai.getAttacker()).getAppearance().getInvisible() || ai.getAttacker().isInvul() || act.isSpawnProtected())) {
            this.getAggroList().remove((Object)target);
            return 0;
        }
        if (!ai.getAttacker().isVisible()) {
            this.getAggroList().remove((Object)target);
            return 0;
        }
        if (ai.getAttacker().isAlikeDead()) {
            ai.stopHate();
            return 0;
        }
        return ai.getHate();
    }

    private RewardItem calculateRewardItem(L2PcInstance lastAttacker, L2DropData drop, int levelModifier, boolean isSweep) {
        float dropChance = drop.getChance();
        int deepBlueDrop = 1;
        if ((!this.isRaid() && Config.DEEPBLUE_DROP_RULES || this.isRaid() && Config.DEEPBLUE_DROP_RULES_RAID) && levelModifier > 0) {
            deepBlueDrop = 3;
            if (drop.getItemId() == 57) {
                deepBlueDrop *= this.isRaid() && !this.isRaidMinion() ? (int)Config.RATE_DROP_ITEMS_BY_RAID : (int)Config.RATE_DROP_ITEMS;
            }
        }
        if (deepBlueDrop == 0) {
            deepBlueDrop = 1;
        }
        if (!this.isRaid() && Config.DEEPBLUE_DROP_RULES || this.isRaid() && Config.DEEPBLUE_DROP_RULES_RAID) {
            dropChance = (drop.getChance() - drop.getChance() * levelModifier / 100) / deepBlueDrop;
        }
        dropChance = Config.RATE_DROP_ITEMS_ID.get(drop.getItemId()) != 0.0f ? (dropChance *= Config.RATE_DROP_ITEMS_ID.get(drop.getItemId())) : (isSweep ? (dropChance *= Config.RATE_DROP_SPOIL) : (dropChance *= this.isRaid() && !this.isRaidMinion() ? Config.RATE_DROP_ITEMS_BY_RAID : Config.RATE_DROP_ITEMS));
        if (Config.L2JMOD_CHAMPION_ENABLE && this.isChampion()) {
            dropChance *= (float)Config.L2JMOD_CHAMPION_REWARDS;
        }
        if ((dropChance = (float)Math.round(dropChance)) < 1.0f) {
            dropChance = 1.0f;
        }
        int minCount = drop.getMinDrop();
        int maxCount = drop.getMaxDrop();
        int itemCount = 0;
        if (dropChance > 1000000.0f && !Config.PRECISE_DROP_CALCULATION) {
            int multiplier = (int)dropChance / 1000000;
            itemCount = minCount < maxCount ? (itemCount += Rnd.get(minCount * multiplier, maxCount * multiplier)) : (minCount == maxCount ? (itemCount += minCount * multiplier) : (itemCount += multiplier));
            dropChance %= 1000000.0f;
        }
        int random = Rnd.get(1000000);
        while ((float)random < dropChance) {
            itemCount = minCount < maxCount ? (itemCount += Rnd.get(minCount, maxCount)) : (minCount == maxCount ? (itemCount += minCount) : ++itemCount);
            dropChance -= 1000000.0f;
        }
        if (Config.L2JMOD_CHAMPION_ENABLE && (drop.getItemId() == 57 || drop.getItemId() >= 6360 && drop.getItemId() <= 6362) && this.isChampion()) {
            itemCount = (int)((float)itemCount * Config.L2JMOD_CHAMPION_ADENAS_REWARDS);
        }
        if (itemCount > 0) {
            return new RewardItem(drop.getItemId(), itemCount);
        }
        if (itemCount == 0 && Config.DEBUG) {
            _log.fine("Roll produced no drops.");
        }
        return null;
    }

    private RewardItem calculateCategorizedRewardItem(L2PcInstance lastAttacker, L2DropCategory categoryDrops, int levelModifier) {
        int basecategoryDropChance;
        if (categoryDrops == null) {
            return null;
        }
        int categoryDropChance = basecategoryDropChance = categoryDrops.getCategoryChance();
        int deepBlueDrop = 1;
        if ((!this.isRaid() && Config.DEEPBLUE_DROP_RULES || this.isRaid() && Config.DEEPBLUE_DROP_RULES_RAID) && levelModifier > 0) {
            deepBlueDrop = 3;
        }
        if (deepBlueDrop == 0) {
            deepBlueDrop = 1;
        }
        if (!this.isRaid() && Config.DEEPBLUE_DROP_RULES || this.isRaid() && Config.DEEPBLUE_DROP_RULES_RAID) {
            categoryDropChance = (categoryDropChance - categoryDropChance * levelModifier / 100) / deepBlueDrop;
        }
        categoryDropChance = (int)((float)categoryDropChance * (this.isRaid() && !this.isRaidMinion() ? Config.RATE_DROP_ITEMS_BY_RAID : Config.RATE_DROP_ITEMS));
        if (Config.L2JMOD_CHAMPION_ENABLE && this.isChampion()) {
            categoryDropChance *= Config.L2JMOD_CHAMPION_REWARDS;
        }
        if ((categoryDropChance = Math.round(categoryDropChance)) < 1) {
            categoryDropChance = 1;
        }
        if (Rnd.get(1000000) < categoryDropChance) {
            L2DropData drop = categoryDrops.dropOne(this.isRaid() && !this.isRaidMinion());
            if (drop == null) {
                return null;
            }
            int dropChance = drop.getChance();
            dropChance = Config.RATE_DROP_ITEMS_ID.get(drop.getItemId()) != 0.0f ? (int)((float)dropChance * Config.RATE_DROP_ITEMS_ID.get(drop.getItemId())) : (int)((float)dropChance * (this.isRaid() && !this.isRaidMinion() ? Config.RATE_DROP_ITEMS_BY_RAID : Config.RATE_DROP_ITEMS));
            if (Config.L2JMOD_CHAMPION_ENABLE && this.isChampion()) {
                dropChance *= Config.L2JMOD_CHAMPION_REWARDS;
            }
            if ((dropChance = Math.round(dropChance)) < 1000000) {
                dropChance = 1000000;
            }
            int min = drop.getMinDrop();
            int max = drop.getMaxDrop();
            int itemCount = 0;
            if (dropChance > 1000000 && !Config.PRECISE_DROP_CALCULATION) {
                int multiplier = dropChance / 1000000;
                itemCount = min < max ? (itemCount += Rnd.get(min * multiplier, max * multiplier)) : (min == max ? (itemCount += min * multiplier) : (itemCount += multiplier));
                dropChance %= 1000000;
            }
            int random = Rnd.get(1000000);
            while (random < dropChance) {
                itemCount = min < max ? (itemCount += Rnd.get(min, max)) : (min == max ? (itemCount += min) : ++itemCount);
                dropChance -= 1000000;
            }
            if (Config.L2JMOD_CHAMPION_ENABLE && (drop.getItemId() == 57 || drop.getItemId() >= 6360 && drop.getItemId() <= 6362) && this.isChampion()) {
                itemCount = (int)((float)itemCount * Config.L2JMOD_CHAMPION_ADENAS_REWARDS);
            }
            if (!Config.MULTIPLE_ITEM_DROP && !ItemTable.getInstance().getTemplate(drop.getItemId()).isStackable() && itemCount > 1) {
                itemCount = 1;
            }
            if (itemCount > 0) {
                return new RewardItem(drop.getItemId(), itemCount);
            }
            if (itemCount == 0 && Config.DEBUG) {
                _log.fine("Roll produced no drops.");
            }
        }
        return null;
    }

    private int calculateLevelModifierForDrop(L2PcInstance lastAttacker) {
        if (!this.isRaid() && Config.DEEPBLUE_DROP_RULES || this.isRaid() && Config.DEEPBLUE_DROP_RULES_RAID) {
            int highestLevel = lastAttacker.getLevel();
            if (!this.getAttackByList().isEmpty()) {
                for (L2Character atkChar : this.getAttackByList()) {
                    if (atkChar == null || atkChar.getLevel() <= highestLevel) continue;
                    highestLevel = atkChar.getLevel();
                }
            }
            if (highestLevel - 9 >= this.getLevel()) {
                return (highestLevel - (this.getLevel() + 8)) * 9;
            }
        }
        return 0;
    }

    private RewardItem calculateCategorizedHerbItem(L2PcInstance lastAttacker, L2DropCategory categoryDrops) {
        int basecategoryDropChance;
        if (categoryDrops == null) {
            return null;
        }
        int categoryDropChance = basecategoryDropChance = categoryDrops.getCategoryChance();
        switch (categoryDrops.getCategoryType()) {
            case 0: {
                if (Config.ENABLE_DROP_VITALITY_HERBS) {
                    categoryDropChance = (int)((float)categoryDropChance * Config.RATE_DROP_VITALITY_HERBS);
                    break;
                }
                return null;
            }
            case 1: {
                categoryDropChance = (int)((float)categoryDropChance * Config.RATE_DROP_HP_HERBS);
                break;
            }
            case 2: {
                categoryDropChance = (int)((float)categoryDropChance * Config.RATE_DROP_MP_HERBS);
                break;
            }
            case 3: {
                categoryDropChance = (int)((float)categoryDropChance * Config.RATE_DROP_SPECIAL_HERBS);
                break;
            }
            default: {
                categoryDropChance = (int)((float)categoryDropChance * Config.RATE_DROP_COMMON_HERBS);
            }
        }
        categoryDropChance = Math.round(categoryDropChance);
        if (categoryDropChance < 1) {
            categoryDropChance = 1;
        }
        if (Rnd.get(1000000) < categoryDropChance) {
            L2DropData drop = categoryDrops.dropOne(false);
            if (drop == null) {
                return null;
            }
            int dropChance = drop.getChance();
            switch (categoryDrops.getCategoryType()) {
                case 0: {
                    dropChance = (int)((float)dropChance * Config.RATE_DROP_VITALITY_HERBS);
                    break;
                }
                case 1: {
                    dropChance = (int)((float)dropChance * Config.RATE_DROP_HP_HERBS);
                    break;
                }
                case 2: {
                    dropChance = (int)((float)dropChance * Config.RATE_DROP_MP_HERBS);
                    break;
                }
                case 3: {
                    dropChance = (int)((float)dropChance * Config.RATE_DROP_SPECIAL_HERBS);
                    break;
                }
                default: {
                    dropChance = (int)((float)dropChance * Config.RATE_DROP_COMMON_HERBS);
                }
            }
            dropChance = Math.round(dropChance);
            if (dropChance < 1000000) {
                dropChance = 1000000;
            }
            int min = drop.getMinDrop();
            int max = drop.getMaxDrop();
            int itemCount = 0;
            if (dropChance > 1000000 && !Config.PRECISE_DROP_CALCULATION) {
                int multiplier = dropChance / 1000000;
                itemCount = min < max ? (itemCount += Rnd.get(min * multiplier, max * multiplier)) : (min == max ? (itemCount += min * multiplier) : (itemCount += multiplier));
                dropChance %= 1000000;
            }
            int random = Rnd.get(1000000);
            while (random < dropChance) {
                itemCount = min < max ? (itemCount += Rnd.get(min, max)) : (min == max ? (itemCount += min) : ++itemCount);
                dropChance -= 1000000;
            }
            if (itemCount > 0) {
                return new RewardItem(drop.getItemId(), itemCount);
            }
            if (itemCount == 0 && Config.DEBUG) {
                _log.fine("Roll produced no drops.");
            }
        }
        return null;
    }

    public void doItemDrop(L2Character mainDamageDealer) {
        this.doItemDrop(this.getTemplate(), mainDamageDealer);
    }

    public void doItemDrop(L2NpcTemplate npcTemplate, L2Character mainDamageDealer) {
        RewardItem item;
        if (mainDamageDealer == null) {
            return;
        }
        L2PcInstance player = mainDamageDealer.getActingPlayer();
        if (player == null) {
            return;
        }
        int levelModifier = this.calculateLevelModifierForDrop(player);
        CursedWeaponsManager.getInstance().checkDrop(this, player);
        if (npcTemplate.getDropData() != null) {
            for (L2DropCategory cat : npcTemplate.getDropData()) {
                SystemMessage sm;
                item = null;
                if (cat.isSweep()) {
                    if (!this.isSpoil()) continue;
                    FastList sweepList = new FastList();
                    for (L2DropData drop : cat.getAllDrops()) {
                        item = this.calculateRewardItem(player, drop, levelModifier, true);
                        if (item == null) continue;
                        if (Config.DEBUG) {
                            _log.fine("Item id to spoil: " + item.getItemId() + " amount: " + item.getCount());
                        }
                        sweepList.add((Object)item);
                    }
                    if (sweepList.isEmpty()) continue;
                    this._sweepItems = (RewardItem[])sweepList.toArray((Object[])new RewardItem[sweepList.size()]);
                    continue;
                }
                if (this.isSeeded()) {
                    L2DropData drop = cat.dropSeedAllowedDropsOnly();
                    if (drop == null) continue;
                    item = this.calculateRewardItem(player, drop, levelModifier, false);
                } else {
                    item = this.calculateCategorizedRewardItem(player, cat, levelModifier);
                }
                if (item == null) continue;
                if (Config.DEBUG) {
                    _log.fine("Item id to drop: " + item.getItemId() + " amount: " + item.getCount());
                }
                if (this.isFlying() || !this.isRaid() && Config.AUTO_LOOT || this.isRaid() && Config.AUTO_LOOT_RAIDS) {
                    player.doAutoLoot(this, item);
                } else {
                    this.dropItem(player, item);
                }
                if (!this.isRaid() || this.isRaidMinion()) continue;
                if (item.getItemId() == 57) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DIED_DROPPED_S2_ADENA);
                    sm.addCharName(this);
                    sm.addItemNumber(item.getCount());
                    this.broadcastPacket(sm);
                    continue;
                }
                sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DIED_DROPPED_S3_S2);
                sm.addCharName(this);
                sm.addItemName(item.getItemId());
                sm.addItemNumber(item.getCount());
                this.broadcastPacket(sm);
            }
        }
        if (Config.L2JMOD_CHAMPION_ENABLE && this.isChampion() && (Config.L2JMOD_CHAMPION_REWARD_LOWER_LVL_ITEM_CHANCE > 0 || Config.L2JMOD_CHAMPION_REWARD_HIGHER_LVL_ITEM_CHANCE > 0)) {
            int champqty = Rnd.get(Config.L2JMOD_CHAMPION_REWARD_QTY);
            RewardItem item2 = new RewardItem(Config.L2JMOD_CHAMPION_REWARD_ID, ++champqty);
            if (player.getLevel() <= this.getLevel() && Rnd.get(100) < Config.L2JMOD_CHAMPION_REWARD_LOWER_LVL_ITEM_CHANCE) {
                if (Config.AUTO_LOOT || this.isFlying()) {
                    player.addItem("ChampionLoot", item2.getItemId(), item2.getCount(), this, true);
                } else {
                    this.dropItem(player, item2);
                }
            } else if (player.getLevel() > this.getLevel() && Rnd.get(100) < Config.L2JMOD_CHAMPION_REWARD_HIGHER_LVL_ITEM_CHANCE) {
                if (Config.AUTO_LOOT || this.isFlying()) {
                    player.addItem("ChampionLoot", item2.getItemId(), item2.getCount(), this, true);
                } else {
                    this.dropItem(player, item2);
                }
            }
        }
        if (this.getTemplate().dropherbgroup > 0) {
            for (L2DropCategory cat : HerbDropTable.getInstance().getHerbDroplist(this.getTemplate().dropherbgroup)) {
                item = this.calculateCategorizedHerbItem(player, cat);
                if (item == null) continue;
                int count = item.getCount();
                if (count > 1) {
                    item._count = 1;
                    for (int i = 0; i < count; ++i) {
                        this.dropItem(player, item);
                    }
                    continue;
                }
                if (this.isFlying() || Config.AUTO_LOOT_HERBS) {
                    player.addItem("Loot", item.getItemId(), count, this, true);
                    continue;
                }
                this.dropItem(player, item);
            }
        }
    }

    public void doEventDrop(L2Character lastAttacker) {
        if (lastAttacker == null) {
            return;
        }
        L2PcInstance player = lastAttacker.getActingPlayer();
        if (player == null) {
            return;
        }
        if (player.getLevel() - this.getLevel() > 9) {
            return;
        }
        for (EventDroplist.DateDrop drop : EventDroplist.getInstance().getAllDrops()) {
            if (Rnd.get(1000000) >= drop.chance) continue;
            RewardItem item = new RewardItem(drop.items[Rnd.get(drop.items.length)], Rnd.get(drop.min, drop.max));
            if (Config.AUTO_LOOT || this.isFlying()) {
                player.doAutoLoot(this, item);
                continue;
            }
            this.dropItem(player, item);
        }
    }

    public L2ItemInstance dropItem(L2PcInstance mainDamageDealer, RewardItem item) {
        int randDropLim = 70;
        L2ItemInstance ditem = null;
        for (int i = 0; i < item.getCount(); ++i) {
            int newX = this.getX() + Rnd.get(-70, 70);
            int newY = this.getY() + Rnd.get(-70, 70);
            int newZ = Math.max(this.getZ(), mainDamageDealer.getZ()) + 20;
            if (ItemTable.getInstance().getTemplate(item.getItemId()) != null) {
                ditem = ItemTable.getInstance().createItem("Loot", item.getItemId(), item.getCount(), mainDamageDealer, this);
                ditem.getDropProtection().protect(mainDamageDealer);
                ditem.dropMe(this, newX, newY, newZ);
                if (!Config.LIST_PROTECTED_ITEMS.contains(item.getItemId()) && (Config.AUTODESTROY_ITEM_AFTER > 0 && ditem.getItemType() != L2EtcItemType.HERB || Config.HERB_AUTO_DESTROY_TIME > 0 && ditem.getItemType() == L2EtcItemType.HERB)) {
                    ItemsAutoDestroy.getInstance().addItem(ditem);
                }
                ditem.setProtected(false);
                if (!ditem.isStackable() && Config.MULTIPLE_ITEM_DROP) continue;
                break;
            }
            _log.log(Level.SEVERE, "Item doesn't exist so cannot be dropped. Item ID: " + item.getItemId());
        }
        return ditem;
    }

    public L2ItemInstance dropItem(L2PcInstance lastAttacker, int itemId, int itemCount) {
        return this.dropItem(lastAttacker, new RewardItem(itemId, itemCount));
    }

    public L2ItemInstance getActiveWeapon() {
        return null;
    }

    public boolean noTarget() {
        return this.getAggroList().isEmpty();
    }

    public boolean containsTarget(L2Character player) {
        return this.getAggroList().containsKey((Object)player);
    }

    public void clearAggroList() {
        this.getAggroList().clear();
        this._overhit = false;
        this._overhitDamage = 0.0;
        this._overhitAttacker = null;
    }

    public boolean isSweepActive() {
        return this._sweepItems != null;
    }

    public synchronized RewardItem[] takeSweep() {
        RewardItem[] sweep = this._sweepItems;
        this._sweepItems = null;
        return sweep;
    }

    public synchronized RewardItem[] takeHarvest() {
        RewardItem[] harvest = this._harvestItems;
        this._harvestItems = null;
        return harvest;
    }

    public void overhitEnabled(boolean status) {
        this._overhit = status;
    }

    public void setOverhitValues(L2Character attacker, double damage) {
        double overhitDmg = (this.getCurrentHp() - damage) * -1.0;
        if (overhitDmg < 0.0) {
            this.overhitEnabled(false);
            this._overhitDamage = 0.0;
            this._overhitAttacker = null;
            return;
        }
        this.overhitEnabled(true);
        this._overhitDamage = overhitDmg;
        this._overhitAttacker = attacker;
    }

    public L2Character getOverhitAttacker() {
        return this._overhitAttacker;
    }

    public double getOverhitDamage() {
        return this._overhitDamage;
    }

    public boolean isOverhit() {
        return this._overhit;
    }

    public void absorbSoul() {
        this._absorbed = true;
    }

    public boolean isAbsorbed() {
        return this._absorbed;
    }

    public void addAbsorber(L2PcInstance attacker) {
        AbsorberInfo ai = (AbsorberInfo)this._absorbersList.get((Object)attacker.getObjectId());
        if (ai == null) {
            ai = new AbsorberInfo(attacker.getObjectId(), this.getCurrentHp());
            this._absorbersList.put((Object)attacker.getObjectId(), (Object)ai);
        } else {
            ai._objId = attacker.getObjectId();
            ai._absorbedHP = this.getCurrentHp();
        }
        this.absorbSoul();
    }

    public void resetAbsorbList() {
        this._absorbed = false;
        this._absorbersList.clear();
    }

    public FastMap<Integer, AbsorberInfo> getAbsorbersList() {
        return this._absorbersList;
    }

    private int[] calculateExpAndSp(int diff, int damage) {
        if (diff < -5) {
            diff = -5;
        }
        double xp = (double)this.getExpReward() * (double)damage / (double)this.getMaxHp();
        if (Config.ALT_GAME_EXPONENT_XP != 0.0f) {
            xp *= Math.pow(2.0, (float)(-diff) / Config.ALT_GAME_EXPONENT_XP);
        }
        double sp = (double)this.getSpReward() * (double)damage / (double)this.getMaxHp();
        if (Config.ALT_GAME_EXPONENT_SP != 0.0f) {
            sp *= Math.pow(2.0, (float)(-diff) / Config.ALT_GAME_EXPONENT_SP);
        }
        if (Config.ALT_GAME_EXPONENT_XP == 0.0f && Config.ALT_GAME_EXPONENT_SP == 0.0f) {
            if (diff > 5) {
                double pow = Math.pow(0.8333333333333334, diff - 5);
                xp *= pow;
                sp *= pow;
            }
            if (xp <= 0.0) {
                xp = 0.0;
                sp = 0.0;
            } else if (sp <= 0.0) {
                sp = 0.0;
            }
        }
        int[] tmp = new int[]{(int)xp, (int)sp};
        return tmp;
    }

    public long calculateOverhitExp(long normalExp) {
        double overhitPercentage = this.getOverhitDamage() * 100.0 / (double)this.getMaxHp();
        if (overhitPercentage > 25.0) {
            overhitPercentage = 25.0;
        }
        double overhitExp = overhitPercentage / 100.0 * (double)normalExp;
        long bonusOverhit = Math.round(overhitExp);
        return bonusOverhit;
    }

    @Override
    public boolean isAttackable() {
        return true;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this.setSpoil(false);
        this.clearAggroList();
        this._harvestItems = null;
        this._seeded = false;
        this._seedType = 0;
        this._seederObjId = 0;
        this.overhitEnabled(false);
        this._sweepItems = null;
        this.resetAbsorbList();
        this.setWalking();
        if (!this.isInActiveRegion() && this.hasAI()) {
            this.getAI().stopAITask();
        }
    }

    public boolean isSpoil() {
        return this._isSpoil;
    }

    public void setSpoil(boolean isSpoil) {
        this._isSpoil = isSpoil;
    }

    public final int getIsSpoiledBy() {
        return this._isSpoiledBy;
    }

    public final void setIsSpoiledBy(int value) {
        this._isSpoiledBy = value;
    }

    public void setSeeded(L2PcInstance seeder) {
        if (this._seedType != 0 && this._seederObjId == seeder.getObjectId()) {
            this.setSeeded(this._seedType, seeder.getLevel());
        }
    }

    public void setSeeded(int id, L2PcInstance seeder) {
        if (!this._seeded) {
            this._seedType = id;
            this._seederObjId = seeder.getObjectId();
        }
    }

    private void setSeeded(int id, int seederLvl) {
        int diff;
        this._seeded = true;
        this._seedType = id;
        int count = 1;
        Map<Integer, L2Skill> skills = this.getTemplate().getSkills();
        if (skills != null) {
            for (int skillId : skills.keySet()) {
                switch (skillId) {
                    case 4303: {
                        count *= 2;
                        break;
                    }
                    case 4304: {
                        count *= 3;
                        break;
                    }
                    case 4305: {
                        count *= 4;
                        break;
                    }
                    case 4306: {
                        count *= 5;
                        break;
                    }
                    case 4307: {
                        count *= 6;
                        break;
                    }
                    case 4308: {
                        count *= 7;
                        break;
                    }
                    case 4309: {
                        count *= 8;
                        break;
                    }
                    case 4310: {
                        count *= 9;
                    }
                }
            }
        }
        if ((diff = this.getLevel() - (L2Manor.getInstance().getSeedLevel(this._seedType) - 5)) > 0) {
            count += diff;
        }
        FastList harvested = new FastList();
        harvested.add((Object)new RewardItem(L2Manor.getInstance().getCropType(this._seedType), count * Config.RATE_DROP_MANOR));
        this._harvestItems = (RewardItem[])harvested.toArray((Object[])new RewardItem[harvested.size()]);
    }

    public int getSeederId() {
        return this._seederObjId;
    }

    public int getSeedType() {
        return this._seedType;
    }

    public boolean isSeeded() {
        return this._seeded;
    }

    public final void setOnKillDelay(int delay) {
        this._onKillDelay = delay;
    }

    @Override
    public boolean hasRandomAnimation() {
        return Config.MAX_MONSTER_ANIMATION > 0 && !(this instanceof L2GrandBossInstance);
    }

    @Override
    public boolean isMob() {
        return true;
    }

    protected void setCommandChannelTimer(CommandChannelTimer commandChannelTimer) {
        this._commandChannelTimer = commandChannelTimer;
    }

    public CommandChannelTimer getCommandChannelTimer() {
        return this._commandChannelTimer;
    }

    public L2CommandChannel getFirstCommandChannelAttacked() {
        return this._firstCommandChannelAttacked;
    }

    public void setFirstCommandChannelAttacked(L2CommandChannel firstCommandChannelAttacked) {
        this._firstCommandChannelAttacked = firstCommandChannelAttacked;
    }

    public long getCommandChannelLastAttack() {
        return this._commandChannelLastAttack;
    }

    public void setCommandChannelLastAttack(long channelLastAttack) {
        this._commandChannelLastAttack = channelLastAttack;
    }

    public void returnHome() {
        this.clearAggroList();
        if (this.hasAI() && this.getSpawn() != null) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(this.getSpawn().getLocx(), this.getSpawn().getLocy(), this.getSpawn().getLocz(), 0));
        }
    }

    public float getVitalityPoints(int damage) {
        if (damage <= 0) {
            return 0.0f;
        }
        float divider = this.getTemplate().baseVitalityDivider;
        if (divider == 0.0f) {
            return 0.0f;
        }
        return (float)(-Math.min(damage, this.getMaxHp())) / divider;
    }

    public boolean useVitalityRate() {
        return !this.isChampion() || Config.L2JMOD_CHAMPION_ENABLE_VITALITY;
    }

    @Override
    public boolean isRaid() {
        return this._isRaid;
    }

    public void setIsRaid(boolean isRaid) {
        this._isRaid = isRaid;
    }

    public void setIsRaidMinion(boolean val) {
        this._isRaid = val;
        this._isRaidMinion = val;
    }

    @Override
    public boolean isRaidMinion() {
        return this._isRaidMinion;
    }

    @Override
    public boolean isMinion() {
        return this.getLeader() != null;
    }

    public L2Attackable getLeader() {
        return null;
    }

    public void setChampion(boolean champ) {
        this._champion = champ;
    }

    @Override
    public boolean isChampion() {
        return this._champion;
    }

    private static class CommandChannelTimer
    implements Runnable {
        private L2Attackable _monster;

        public CommandChannelTimer(L2Attackable monster) {
            this._monster = monster;
        }

        @Override
        public void run() {
            if (System.currentTimeMillis() - this._monster.getCommandChannelLastAttack() > (long)Config.LOOT_RAIDS_PRIVILEGE_INTERVAL) {
                this._monster.setCommandChannelTimer(null);
                this._monster.setFirstCommandChannelAttacked(null);
                this._monster.setCommandChannelLastAttack(0L);
            } else {
                ThreadPoolManager.getInstance().scheduleGeneral(this, 10000L);
            }
        }
    }

    private static class OnKillNotifyTask
    implements Runnable {
        private L2Attackable _attackable;
        private Quest _quest;
        private L2PcInstance _killer;
        private boolean _isPet;

        public OnKillNotifyTask(L2Attackable attackable, Quest quest, L2PcInstance killer, boolean isPet) {
            this._attackable = attackable;
            this._quest = quest;
            this._killer = killer;
            this._isPet = isPet;
        }

        @Override
        public void run() {
            this._quest.notifyKill(this._attackable, this._killer, this._isPet);
        }
    }

    public static final class RewardItem {
        protected int _itemId;
        protected int _count;

        public RewardItem(int itemId, int count) {
            this._itemId = itemId;
            this._count = count;
        }

        public int getItemId() {
            return this._itemId;
        }

        public int getCount() {
            return this._count;
        }
    }

    public static final class AbsorberInfo {
        public int _objId;
        public double _absorbedHP;

        AbsorberInfo(int objId, double pAbsorbedHP) {
            this._objId = objId;
            this._absorbedHP = pAbsorbedHP;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AbsorberInfo) {
                return ((AbsorberInfo)obj)._objId == this._objId;
            }
            return false;
        }

        public int hashCode() {
            return this._objId;
        }
    }

    protected static final class RewardInfo {
        protected L2Character _attacker;
        protected int _dmg = 0;

        public RewardInfo(L2Character pAttacker, int pDmg) {
            this._attacker = pAttacker;
            this._dmg = pDmg;
        }

        public void addDamage(int pDmg) {
            this._dmg += pDmg;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RewardInfo) {
                return ((RewardInfo)obj)._attacker == this._attacker;
            }
            return false;
        }

        public int hashCode() {
            return this._attacker.getObjectId();
        }
    }

    public static final class AggroInfo {
        private final L2Character _attacker;
        private int _hate = 0;
        private int _damage = 0;

        AggroInfo(L2Character pAttacker) {
            this._attacker = pAttacker;
        }

        public final L2Character getAttacker() {
            return this._attacker;
        }

        public final int getHate() {
            return this._hate;
        }

        public final int checkHate(L2Character owner) {
            if (this._attacker.isAlikeDead() || !this._attacker.isVisible() || !owner.getKnownList().knowsObject(this._attacker)) {
                this._hate = 0;
            }
            return this._hate;
        }

        public final void addHate(int value) {
            this._hate = (int)Math.min((long)this._hate + (long)value, 999999999L);
        }

        public final void stopHate() {
            this._hate = 0;
        }

        public final int getDamage() {
            return this._damage;
        }

        public final void addDamage(int value) {
            this._damage = (int)Math.min((long)this._damage + (long)value, 999999999L);
        }

        public final boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AggroInfo) {
                return ((AggroInfo)obj).getAttacker() == this._attacker;
            }
            return false;
        }

        public final int hashCode() {
            return this._attacker.getObjectId();
        }
    }
}

