/*
 * Decompiled with CFR 0.152.
 */
package org.mmocore.network;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioNetStackList<E> {
    private final NioNetStackNode _start = new NioNetStackNode();
    private final NioNetStackNodeBuf _buf = new NioNetStackNodeBuf();
    private NioNetStackNode _end = new NioNetStackNode();

    public NioNetStackList() {
        this.clear();
    }

    public final void addLast(E elem) {
        NioNetStackNode newEndNode = this._buf.removeFirst();
        this._end._value = elem;
        this._end._next = newEndNode;
        this._end = newEndNode;
    }

    public final E removeFirst() {
        NioNetStackNode old = this._start._next;
        Object value = old._value;
        this._start._next = old._next;
        this._buf.addLast(old);
        return (E)value;
    }

    public final boolean isEmpty() {
        return this._start._next == this._end;
    }

    public final void clear() {
        this._start._next = this._end;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NioNetStackNodeBuf {
        private final NioNetStackNode _start;
        private NioNetStackNode _end;

        NioNetStackNodeBuf() {
            this._start = new NioNetStackNode();
            this._end = new NioNetStackNode();
            this._start._next = this._end;
        }

        final void addLast(NioNetStackNode node) {
            node._next = null;
            node._value = null;
            this._end._next = node;
            this._end = node;
        }

        final NioNetStackNode removeFirst() {
            if (this._start._next == this._end) {
                return new NioNetStackNode();
            }
            NioNetStackNode old = this._start._next;
            this._start._next = old._next;
            return old;
        }
    }

    private final class NioNetStackNode {
        private NioNetStackNode _next;
        private E _value;

        private NioNetStackNode() {
        }
    }
}

