/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.instancemanager.TownManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeFlagInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.zone.type.L2ArenaZone;
import com.l2jserver.gameserver.model.zone.type.L2ClanHallZone;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MapRegionTable {
    private static Logger _log = Logger.getLogger(MapRegionTable.class.getName());
    private final int[][] _regions = new int[16][18];

    public static MapRegionTable getInstance() {
        return SingletonHolder._instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapRegionTable() {
        int count2 = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT region, sec0, sec1, sec2, sec3, sec4, sec5, sec6, sec7, sec8, sec9, sec10,sec11,sec12,sec13,sec14,sec15 FROM mapregion");
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                int region = rset.getInt(1);
                for (int j = 0; j < 16; ++j) {
                    this._regions[j][region] = rset.getInt(j + 2);
                    ++count2;
                }
            }
            rset.close();
            statement.close();
            if (Config.DEBUG) {
                _log.fine(count2 + " mapregion loaded");
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error loading Map Region Table.", e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public final int getMapRegion(int posX, int posY) {
        try {
            return this._regions[this.getMapRegionX(posX)][this.getMapRegionY(posY)];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (Config.DEBUG) {
                _log.log(Level.WARNING, "MapRegionTable: Player outside map regions at X,Y=" + posX + "," + posY, e);
            }
            return 0;
        }
    }

    public final int getMapRegionX(int posX) {
        return (posX >> 15) + 9;
    }

    public final int getMapRegionY(int posY) {
        return (posY >> 15) + 10;
    }

    public int getAreaCastle(L2Character activeChar) {
        int castle;
        int area = this.getClosestTownNumber(activeChar);
        switch (area) {
            case 0: {
                castle = 1;
                break;
            }
            case 1: {
                castle = 4;
                break;
            }
            case 2: {
                castle = 4;
                break;
            }
            case 3: {
                castle = 9;
                break;
            }
            case 4: {
                castle = 9;
                break;
            }
            case 5: {
                castle = 1;
                break;
            }
            case 6: {
                castle = 1;
                break;
            }
            case 7: {
                castle = 2;
                break;
            }
            case 8: {
                castle = 3;
                break;
            }
            case 9: {
                castle = 4;
                break;
            }
            case 10: {
                castle = 5;
                break;
            }
            case 11: {
                castle = 5;
                break;
            }
            case 12: {
                castle = 3;
                break;
            }
            case 13: {
                castle = 6;
                break;
            }
            case 14: {
                castle = 8;
                break;
            }
            case 15: {
                castle = 7;
                break;
            }
            case 16: {
                castle = 9;
                break;
            }
            case 17: {
                castle = 2;
                break;
            }
            case 18: {
                castle = 8;
                break;
            }
            case 19: {
                castle = 5;
                break;
            }
            case 20: {
                castle = 6;
                break;
            }
            case 21: {
                castle = 8;
                break;
            }
            default: {
                castle = 5;
            }
        }
        return castle;
    }

    public int getClosestTownNumber(L2Character activeChar) {
        return this.getMapRegion(activeChar.getX(), activeChar.getY());
    }

    public String getClosestTownName(int x, int y) {
        return this.getClosestTownName(this.getMapRegion(x, y));
    }

    public String getClosestTownName(L2Character activeChar) {
        return this.getClosestTownName(this.getMapRegion(activeChar.getX(), activeChar.getY()));
    }

    public String getClosestTownName(int townId) {
        String nearestTown = null;
        switch (townId) {
            case 0: {
                nearestTown = "\u8a71\u305b\u308b\u5cf6\u306e\u6751";
                break;
            }
            case 1: {
                nearestTown = "\u30a8\u30eb\u30d5\u306e\u6751";
                break;
            }
            case 2: {
                nearestTown = "\u30c0\u30fc\u30af\u30a8\u30eb\u30d5\u306e\u6751";
                break;
            }
            case 3: {
                nearestTown = "\u30aa\u30fc\u30af\u6751";
                break;
            }
            case 4: {
                nearestTown = "\u30c9\u30ef\u30fc\u30d5\u6751";
                break;
            }
            case 5: {
                nearestTown = "\u30b0\u30eb\u30fc\u30c7\u30a3\u30aa\u57ce\u306e\u6751";
                break;
            }
            case 6: {
                nearestTown = "\u30b0\u30eb\u30fc\u30c7\u30a3\u30f3\u6751";
                break;
            }
            case 7: {
                nearestTown = "\u30c7\u30a3\u30aa\u30f3\u57ce\u306e\u6751";
                break;
            }
            case 8: {
                nearestTown = "\u30ae\u30e9\u30f3\u57ce\u306e\u6751";
                break;
            }
            case 9: {
                nearestTown = "\u30aa\u30fc\u30ec\u30f3\u57ce\u306e\u6751";
                break;
            }
            case 10: {
                nearestTown = "\u30a2\u30c7\u30f3\u57ce\u306e\u6751";
                break;
            }
            case 11: {
                nearestTown = "\u731f\u5e2b\u306e\u6751";
                break;
            }
            case 12: {
                nearestTown = "\u30ae\u30e9\u30f3\u6e2f";
                break;
            }
            case 13: {
                nearestTown = "\u6c34\u4e0a\u90fd\u5e02\u30cf\u30a4\u30cd\u30b9";
                break;
            }
            case 14: {
                nearestTown = "\u30eb\u30a6\u30f3\u57ce\u306e\u6751";
                break;
            }
            case 15: {
                nearestTown = "\u30b4\u30c0\u30fc\u30c9\u57ce\u306e\u6751";
                break;
            }
            case 16: {
                nearestTown = "\u30b7\u30e5\u30c1\u30e5\u30c3\u30c4\u30ac\u30eb\u30c8\u57ce\u306e\u6751";
                break;
            }
            case 18: {
                nearestTown = "\u53e4\u4ee3\u306e\u5cf6";
                break;
            }
            case 19: {
                nearestTown = "\u30ab\u30de\u30a8\u30eb\u306e\u6751";
                break;
            }
            case 20: {
                nearestTown = "\u8352\u5730\u5357";
                break;
            }
            case 21: {
                nearestTown = "\u5e7b\u60f3\u306e\u5cf6";
                break;
            }
            case 22: {
                nearestTown = "\u4e2d\u7acb\u6d77\u57df";
                break;
            }
            case 23: {
                nearestTown = "\u30b3\u30ed\u30b7\u30a2\u30e0";
                break;
            }
            case 24: {
                nearestTown = "GM\u76f8\u8ac7\u6240";
                break;
            }
            case 25: {
                nearestTown = "\u6b21\u5143\u306e\u72ed\u9593";
                break;
            }
            case 26: {
                nearestTown = "\u5e1d\u56fd\u306e\u5893\u5730";
                break;
            }
            case 27: {
                nearestTown = "\u92fc\u9244\u306e\u57ce";
                break;
            }
            case 28: {
                nearestTown = "Steel Citadel Resistance";
                break;
            }
            case 29: {
                nearestTown = "\u30ab\u30de\u30ed\u30ab";
                break;
            }
            case 30: {
                nearestTown = "\u30cb\u30a2 \u30ab\u30de\u30ed\u30ab";
                break;
            }
            case 31: {
                nearestTown = "\u30ea\u30e0 \u30ab\u30de\u30ed\u30ab";
                break;
            }
            case 32: {
                nearestTown = "\u30af\u30bb\u30eb\u30b9\u540c\u76df\u306e\u9023\u5408\u57fa\u5730";
                break;
            }
            case 33: {
                nearestTown = "\u4e0d\u6ec5\u306e\u7a2e \u5185\u90e8";
                break;
            }
            case 34: {
                nearestTown = "\u4e0d\u6ec5\u306e\u7a2e \u5916\u90e8";
                break;
            }
            case 35: {
                nearestTown = "\u30af\u30e9\u30d5\u30c8";
                break;
            }
            default: {
                nearestTown = "\u30a2\u30c7\u30f3\u57ce\u306e\u6751";
            }
        }
        return nearestTown;
    }

    public Location getTeleToLocation(L2Character activeChar, TeleportWhereType teleportWhere) {
        if (activeChar instanceof L2PcInstance) {
            int[] coord;
            Instance inst;
            L2PcInstance player = (L2PcInstance)activeChar;
            if (player.isInsideZone((byte)9)) {
                return new Location(12661, 181687, -3560);
            }
            Castle castle = null;
            Fort fort = null;
            ClanHall clanhall = null;
            if (player.getClan() != null && !player.isFlyingMounted() && !player.isFlying()) {
                L2ClanHallZone zone;
                if (teleportWhere == TeleportWhereType.ClanHall && (clanhall = ClanHallManager.getInstance().getClanHallByOwner(player.getClan())) != null && (zone = clanhall.getZone()) != null && !player.isFlyingMounted()) {
                    return zone.getSpawnLoc();
                }
                if (teleportWhere == TeleportWhereType.Castle) {
                    castle = CastleManager.getInstance().getCastleByOwner(player.getClan());
                    if (!(castle != null || (castle = CastleManager.getInstance().getCastle(player)) != null && castle.getSiege().getIsInProgress() && castle.getSiege().getDefenderClan(player.getClan()) != null)) {
                        castle = null;
                    }
                    if (castle != null && castle.getCastleId() > 0) {
                        return castle.getCastleZone().getSpawnLoc();
                    }
                }
                if (teleportWhere == TeleportWhereType.Fortress) {
                    fort = FortManager.getInstance().getFortByOwner(player.getClan());
                    if (!(fort != null || (fort = FortManager.getInstance().getFort(player)) != null && fort.getSiege().getIsInProgress() && fort.getOwnerClan() == player.getClan())) {
                        fort = null;
                    }
                    if (fort != null && fort.getFortId() > 0) {
                        return fort.getFortZone().getSpawnLoc();
                    }
                }
                if (teleportWhere == TeleportWhereType.SiegeFlag) {
                    List<L2Npc> flags;
                    castle = CastleManager.getInstance().getCastle(player);
                    fort = FortManager.getInstance().getFort(player);
                    L2SiegeFlagInstance tw_flag = TerritoryWarManager.getInstance().getFlagForClan(player.getClan());
                    if (tw_flag != null) {
                        return new Location(tw_flag.getX(), tw_flag.getY(), tw_flag.getZ());
                    }
                    if (castle != null) {
                        if (castle.getSiege().getIsInProgress() && (flags = castle.getSiege().getFlag(player.getClan())) != null && !flags.isEmpty()) {
                            L2Npc flag = flags.get(0);
                            return new Location(flag.getX(), flag.getY(), flag.getZ());
                        }
                    } else if (fort != null && fort.getSiege().getIsInProgress() && (flags = fort.getSiege().getFlag(player.getClan())) != null && !flags.isEmpty()) {
                        L2Npc flag = flags.get(0);
                        return new Location(flag.getX(), flag.getY(), flag.getZ());
                    }
                }
            }
            if (player.getKarma() > 0) {
                try {
                    return TownManager.getClosestTown(activeChar).getChaoticSpawnLoc();
                }
                catch (Exception e) {
                    if (player.isFlyingMounted()) {
                        return new Location(-186330, 242944, 2544);
                    }
                    return new Location(17817, 170079, -3530);
                }
            }
            L2ArenaZone arena = ZoneManager.getInstance().getArena(player);
            if (arena != null) {
                return arena.getSpawnLoc();
            }
            castle = CastleManager.getInstance().getCastle(player);
            if (castle != null && castle.getSiege().getIsInProgress() && (castle.getSiege().checkIsDefender(player.getClan()) || castle.getSiege().checkIsAttacker(player.getClan())) && SevenSigns.getInstance().getSealOwner(3) == 2) {
                return TownManager.getSecondClosestTown(activeChar).getSpawnLoc();
            }
            if (player.getInstanceId() > 0 && (inst = InstanceManager.getInstance().getInstance(player.getInstanceId())) != null && (coord = inst.getSpawnLoc())[0] != 0 && coord[1] != 0 && coord[2] != 0) {
                return new Location(coord[0], coord[1], coord[2]);
            }
        }
        try {
            return TownManager.getClosestTown(activeChar).getSpawnLoc();
        }
        catch (NullPointerException e) {
            return new Location(-84176, 243382, -3126);
        }
    }

    private static class SingletonHolder {
        protected static final MapRegionTable _instance = new MapRegionTable();

        private SingletonHolder() {
        }
    }

    public static enum TeleportWhereType {
        Castle,
        ClanHall,
        SiegeFlag,
        Town,
        Fortress;

    }
}

