/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.TeleportLocationTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2TeleportLocation;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.StringTokenizer;

public class L2DoormenInstance
extends L2NpcInstance {
    public L2DoormenInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
        this.setInstanceType(L2Object.InstanceType.L2DoormenInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("Chat")) {
            this.showChatWindow(player);
            return;
        }
        if (command.startsWith("open_doors")) {
            if (this.isOwnerClan(player)) {
                if (this.isUnderSiege()) {
                    this.cannotManageDoors(player);
                } else {
                    this.openDoors(player, command);
                }
            }
            return;
        }
        if (command.startsWith("close_doors")) {
            if (this.isOwnerClan(player)) {
                if (this.isUnderSiege()) {
                    this.cannotManageDoors(player);
                } else {
                    this.closeDoors(player, command);
                }
            }
            return;
        }
        if (command.startsWith("tele")) {
            if (this.isOwnerClan(player)) {
                this.doTeleport(player, command);
            }
            return;
        }
        super.onBypassFeedback(player, command);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        if (!this.isOwnerClan(player)) {
            html.setFile(player.getHtmlPrefix(), "data/html/doormen/" + this.getTemplate().npcId + "-no.htm");
        } else {
            html.setFile(player.getHtmlPrefix(), "data/html/doormen/" + this.getTemplate().npcId + ".htm");
        }
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        player.sendPacket(html);
    }

    protected void openDoors(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command.substring(10), ", ");
        st.nextToken();
        while (st.hasMoreTokens()) {
            DoorTable.getInstance().getDoor(Integer.parseInt(st.nextToken())).openMe();
        }
    }

    protected void closeDoors(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command.substring(11), ", ");
        st.nextToken();
        while (st.hasMoreTokens()) {
            DoorTable.getInstance().getDoor(Integer.parseInt(st.nextToken())).closeMe();
        }
    }

    protected void cannotManageDoors(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), "data/html/doormen/" + this.getTemplate().npcId + "-busy.htm");
        player.sendPacket(html);
    }

    protected void doTeleport(L2PcInstance player, String command) {
        int whereTo = Integer.parseInt(command.substring(5).trim());
        L2TeleportLocation list = TeleportLocationTable.getInstance().getTemplate(whereTo);
        if (list != null) {
            if (!player.isAlikeDead()) {
                player.teleToLocation(list.getLocX(), list.getLocY(), list.getLocZ(), false);
            }
        } else {
            _log.warning("No teleport destination with id:" + whereTo);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    protected boolean isOwnerClan(L2PcInstance player) {
        return true;
    }

    protected boolean isUnderSiege() {
        return false;
    }
}

