/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.WorldInfo;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class AllyLeave
extends L2GameClientPacket {
    private static final String _C__84_ALLYLEAVE = "[C] 84 AllyLeave";

    @Override
    protected void readImpl() {
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (player.getClan() == null) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_ARE_NOT_A_CLAN_MEMBER));
            return;
        }
        if (!player.isClanLeader()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ONLY_CLAN_LEADER_WITHDRAW_ALLY));
            return;
        }
        L2Clan clan = player.getClan();
        if (clan.getAllyId() == 0) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NO_CURRENT_ALLIANCES));
            return;
        }
        if (clan.getClanId() == clan.getAllyId()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ALLIANCE_LEADER_CANT_WITHDRAW));
            return;
        }
        long currentTime = System.currentTimeMillis();
        clan.setAllyId(0);
        clan.setAllyName(null);
        clan.changeAllyCrest(0, true);
        clan.setAllyPenaltyExpiryTime(currentTime + (long)Config.ALT_ALLY_JOIN_DAYS_WHEN_LEAVED * 86400000L, 1);
        clan.updateClanInDB();
        CommunityServerThread.getInstance().sendPacket(new WorldInfo(null, clan, 3));
        player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_WITHDRAWN_FROM_ALLIANCE));
    }

    @Override
    public String getType() {
        return _C__84_ALLYLEAVE;
    }
}

