/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.instancemanager.BoatManager;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.GetOnVehicle;
import com.l2jserver.util.Point3D;

public final class RequestGetOnVehicle
extends L2GameClientPacket {
    private static final String _C__5C_GETONVEHICLE = "[C] 5C GetOnVehicle";
    private int _boatId;
    private Point3D _pos;

    @Override
    protected void readImpl() {
        this._boatId = this.readD();
        int x = this.readD();
        int y = this.readD();
        int z = this.readD();
        this._pos = new Point3D(x, y, z);
    }

    @Override
    protected void runImpl() {
        L2BoatInstance boat;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (activeChar.isInBoat()) {
            boat = activeChar.getBoat();
            if (boat.getObjectId() != this._boatId) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        } else {
            boat = BoatManager.getInstance().getBoat(this._boatId);
            if (boat == null || boat.isMoving() || !activeChar.isInsideRadius(boat, 1000, true, false)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        }
        activeChar.setInVehiclePosition(this._pos);
        activeChar.setVehicle(boat);
        activeChar.broadcastPacket(new GetOnVehicle(activeChar.getObjectId(), boat.getObjectId(), this._pos));
        activeChar.setXYZ(boat.getX(), boat.getY(), boat.getZ());
        activeChar.revalidateZone(true);
    }

    @Override
    public String getType() {
        return _C__5C_GETONVEHICLE;
    }
}

