/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.PetItemList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Logger;

public final class RequestPetUseItem
extends L2GameClientPacket {
    private static Logger _log = Logger.getLogger(RequestPetUseItem.class.getName());
    private static final String _C__8A_REQUESTPETUSEITEM = "[C] 8a RequestPetUseItem";
    private int _objectId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
    }

    @Override
    protected void runImpl() {
        IItemHandler handler;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2PetInstance pet = (L2PetInstance)activeChar.getPet();
        if (pet == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getUseItem().tryPerformAction("pet use item")) {
            return;
        }
        L2ItemInstance item = pet.getInventory().getItemByObjectId(this._objectId);
        if (item == null) {
            return;
        }
        int itemId = item.getItemId();
        if (activeChar.isAlikeDead() || pet.isDead()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addItemName(item);
            activeChar.sendPacket(sm);
            sm = null;
            return;
        }
        if (Config.DEBUG) {
            _log.finest(activeChar.getObjectId() + ": pet use item " + this._objectId);
        }
        if (!item.isEquipped() && !item.getItem().checkCondition(pet, pet, true)) {
            return;
        }
        if (item.isEquipable()) {
            if (!item.getItem().isConditionAttached()) {
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.PET_CANNOT_USE_ITEM));
                return;
            }
            this.useItem(pet, item, activeChar);
            return;
        }
        if (PetDataTable.isPetFood(itemId)) {
            if (pet.canEatFoodId(itemId)) {
                this.useItem(pet, item, activeChar);
            } else {
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.PET_CANNOT_USE_ITEM));
                return;
            }
        }
        if ((handler = ItemHandler.getInstance().getItemHandler(item.getEtcItem())) != null) {
            this.useItem(pet, item, activeChar);
        } else {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.PET_CANNOT_USE_ITEM));
        }
    }

    private void useItem(L2PetInstance pet, L2ItemInstance item, L2PcInstance activeChar) {
        if (item.isEquipable()) {
            if (item.isEquipped()) {
                pet.getInventory().unEquipItemInSlot(item.getLocationSlot());
            } else {
                pet.getInventory().equipItem(item);
            }
            activeChar.sendPacket(new PetItemList(pet));
            pet.updateAndBroadcastStatus(1);
        } else {
            IItemHandler handler = ItemHandler.getInstance().getItemHandler(item.getEtcItem());
            if (handler != null) {
                handler.useItem(pet, item, false);
                pet.updateAndBroadcastStatus(1);
            } else {
                _log.warning("no itemhandler registered for itemId:" + item.getItemId());
            }
        }
    }

    @Override
    public String getType() {
        return _C__8A_REQUESTPETUSEITEM;
    }
}

