/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import java.util.logging.Logger;
import javolution.io.UTF8StreamReader;

public final class L2Properties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static Logger _log = Logger.getLogger(L2Properties.class.getName());

    public L2Properties() {
    }

    public L2Properties(String name) throws IOException {
        this.load(new FileInputStream(name));
    }

    public L2Properties(File file) throws IOException {
        this.load(new FileInputStream(file));
    }

    public L2Properties(InputStream inStream) throws IOException {
        this.load(inStream);
    }

    public L2Properties(Reader reader) throws IOException {
        this.load(reader);
    }

    public void load(String name) throws IOException {
        this.load(new FileInputStream(name));
    }

    public void load(File file) throws IOException {
        this.load(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(InputStream inStream) throws IOException {
        UTF8StreamReader reader = null;
        try {
            reader = new UTF8StreamReader().setInput(inStream);
            super.load((Reader)reader);
        }
        finally {
            inStream.close();
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Reader reader) throws IOException {
        try {
            super.load(reader);
        }
        finally {
            reader.close();
        }
    }

    @Override
    public String getProperty(String key) {
        String property = super.getProperty(key);
        if (property == null) {
            _log.info("L2Properties: Missing property for key - " + key);
            return null;
        }
        return property.trim();
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String property = super.getProperty(key, defaultValue);
        if (property == null) {
            _log.warning("L2Properties: Missing defaultValue for key - " + key);
            return null;
        }
        return property.trim();
    }
}

