## Active Perl 5.8.8
use utf8;
use warnings;
use strict;
binmode STDOUT,'encoding(cp932)';

open CSV, '<:utf8', 'temp/servername-j.txt'  or die $!;
my $mtime = (stat CSV)[9];

open TXT, '>:utf8', 'servername.xml'  or die $!;
print TXT '<?xml version="1.0" encoding="UTF-8"?>
<servers_list xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="servername.xsd">
';

<CSV>; # skip header
while (not eof CSV) {
	my $buf = <CSV>;
	chomp $buf;
	my @field = split /\t/, $buf;
	foreach (@field) {s/^[ua],//; s/\\0//; s/\\\\n/\\n/g}
	my ($server_id,$server_name) = ($field[0],$field[2]);
	print "$server_id\r";
	print TXT '	<server id="', (1+$server_id), '" name="', $server_name, '" />', "\n";
}
print TXT '</servers_list>';
close TXT;
utime $mtime,$mtime,'servername.txt';

close CSV;
print "\n";
