/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestPledgeSetAcademyMaster
extends L2GameClientPacket {
    private static final String _C__D0_12_REQUESTSETPLEADGEACADEMYMASTER = "[C] D0:12 RequestPledgeSetAcademyMaster";
    private String _currPlayerName;
    private int _set;
    private String _targetPlayerName;

    @Override
    protected void readImpl() {
        this._set = this.readD();
        this._currPlayerName = this.readS();
        this._targetPlayerName = this.readS();
    }

    @Override
    protected void runImpl() {
        L2ClanMember sponsorMember;
        L2ClanMember apprenticeMember;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        L2Clan clan = activeChar.getClan();
        if (clan == null) {
            return;
        }
        if ((activeChar.getClanPrivileges() & 0x100) != 256) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_DO_NOT_HAVE_THE_RIGHT_TO_DISMISS_AN_APPRENTICE));
            return;
        }
        L2ClanMember currentMember = clan.getClanMember(this._currPlayerName);
        L2ClanMember targetMember = clan.getClanMember(this._targetPlayerName);
        if (currentMember == null || targetMember == null) {
            return;
        }
        if (currentMember.getPledgeType() == -1) {
            apprenticeMember = currentMember;
            sponsorMember = targetMember;
        } else {
            apprenticeMember = targetMember;
            sponsorMember = currentMember;
        }
        L2PcInstance apprentice = apprenticeMember.getPlayerInstance();
        L2PcInstance sponsor = sponsorMember.getPlayerInstance();
        SystemMessage sm = null;
        if (this._set == 0) {
            if (apprentice != null) {
                apprentice.setSponsor(0);
            } else {
                apprenticeMember.initApprenticeAndSponsor(0, 0);
            }
            if (sponsor != null) {
                sponsor.setApprentice(0);
            } else {
                sponsorMember.initApprenticeAndSponsor(0, 0);
            }
            apprenticeMember.saveApprenticeAndSponsor(0, 0);
            sponsorMember.saveApprenticeAndSponsor(0, 0);
            sm = SystemMessage.getSystemMessage(SystemMessageId.S2_CLAN_MEMBER_C1_APPRENTICE_HAS_BEEN_REMOVED);
        } else {
            if (apprenticeMember.getSponsor() != 0 || sponsorMember.getApprentice() != 0 || apprenticeMember.getApprentice() != 0 || sponsorMember.getSponsor() != 0) {
                activeChar.sendMessage("Remove previous connections first.");
                return;
            }
            if (apprentice != null) {
                apprentice.setSponsor(sponsorMember.getObjectId());
            } else {
                apprenticeMember.initApprenticeAndSponsor(0, sponsorMember.getObjectId());
            }
            if (sponsor != null) {
                sponsor.setApprentice(apprenticeMember.getObjectId());
            } else {
                sponsorMember.initApprenticeAndSponsor(apprenticeMember.getObjectId(), 0);
            }
            apprenticeMember.saveApprenticeAndSponsor(0, sponsorMember.getObjectId());
            sponsorMember.saveApprenticeAndSponsor(apprenticeMember.getObjectId(), 0);
            sm = SystemMessage.getSystemMessage(SystemMessageId.S2_HAS_BEEN_DESIGNATED_AS_APPRENTICE_OF_CLAN_MEMBER_S1);
        }
        sm.addString(sponsorMember.getName());
        sm.addString(apprenticeMember.getName());
        if (sponsor != activeChar && sponsor != apprentice) {
            activeChar.sendPacket(sm);
        }
        if (sponsor != null) {
            sponsor.sendPacket(sm);
        }
        if (apprentice != null) {
            apprentice.sendPacket(sm);
        }
    }

    @Override
    public String getType() {
        return _C__D0_12_REQUESTSETPLEADGEACADEMYMASTER;
    }
}

