/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.CharSelectionInfo;
import com.l2jserver.gameserver.network.serverpackets.RestartResponse;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class RequestRestart
extends L2GameClientPacket {
    private static final String _C__46_REQUESTRESTART = "[C] 46 RequestRestart";
    private static final Logger _log = Logger.getLogger(RequestRestart.class.getName());
    protected static final Logger _logAccounting = Logger.getLogger("accounting");

    @Override
    protected void readImpl() {
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (player.isFlying()) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NO_RESTART_HERE));
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.getActiveEnchantItem() != null || player.getActiveEnchantAttrItem() != null) {
            this.sendPacket(RestartResponse.valueOf(false));
            return;
        }
        if (player.isLocked()) {
            _log.warning("Player " + player.getName() + " tried to restart during class change.");
            this.sendPacket(RestartResponse.valueOf(false));
            return;
        }
        if (player.getPrivateStoreType() != 0) {
            player.sendMessage("\u30a2\u30a4\u30c6\u30e0 \u30c8\u30ec\u30fc\u30c9\u4e2d\u306f\u30ea\u30b9\u30bf\u30fc\u30c8\u3067\u304d\u307e\u305b\u3093\u3002");
            this.sendPacket(RestartResponse.valueOf(false));
            return;
        }
        if (!(!AttackStanceTaskManager.getInstance().getAttackStanceTask(player) || player.isGM() && Config.GM_RESTART_FIGHTING)) {
            if (Config.DEBUG) {
                _log.fine("Player " + player.getName() + " tried to logout while fighting.");
            }
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANT_RESTART_WHILE_FIGHTING));
            this.sendPacket(RestartResponse.valueOf(false));
            return;
        }
        if (player.isFestivalParticipant()) {
            if (SevenSignsFestival.getInstance().isFestivalInitialized()) {
                player.sendMessage("\u796d\u5178\u306b\u53c2\u52a0\u4e2d\u306f\u30ea\u30b9\u30bf\u30fc\u30c8\u3067\u304d\u307e\u305b\u3093\u3002");
                this.sendPacket(RestartResponse.valueOf(false));
                return;
            }
            L2Party playerParty = player.getParty();
            if (playerParty != null) {
                player.getParty().broadcastToPartyMembers(SystemMessage.sendString(player.getName() + " \u304c\u796d\u5178\u304b\u3089\u5916\u308c\u307e\u3057\u305f\u3002"));
            }
        }
        player.removeFromBossZone();
        L2GameClient client = (L2GameClient)this.getClient();
        LogRecord record = new LogRecord(Level.INFO, "Logged out");
        record.setParameters(new Object[]{client});
        _logAccounting.log(record);
        player.setClient(null);
        player.deleteMe();
        client.setActiveChar(null);
        AntiFeedManager.getInstance().onDisconnect(client);
        client.setState(L2GameClient.GameClientState.AUTHED);
        this.sendPacket(RestartResponse.valueOf(true));
        CharSelectionInfo cl = new CharSelectionInfo(client.getAccountName(), client.getSessionId().playOkID1);
        this.sendPacket(cl);
        client.setCharSelection(cl.getCharInfo());
    }

    @Override
    public String getType() {
        return _C__46_REQUESTRESTART;
    }
}

