/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.templates.item;

import com.l2jserver.gameserver.handler.ISkillHandler;
import com.l2jserver.gameserver.handler.SkillHandler;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Formulas;
import com.l2jserver.gameserver.skills.SkillHolder;
import com.l2jserver.gameserver.skills.conditions.Condition;
import com.l2jserver.gameserver.skills.conditions.ConditionGameChance;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import javolution.util.FastList;

public final class L2Weapon
extends L2Item {
    private final L2WeaponType _type;
    private final boolean _isMagicWeapon;
    private final int _rndDam;
    private final int _soulShotCount;
    private final int _spiritShotCount;
    private final int _mpConsume;
    private SkillHolder _enchant4Skill = null;
    private final int _changeWeaponId;
    private SkillHolder _skillsOnCast;
    private Condition _skillsOnCastCondition = null;
    private SkillHolder _skillsOnCrit;
    private Condition _skillsOnCritCondition = null;
    private final int _reuseDelay;

    public L2Weapon(StatsSet set) {
        super(set);
        int chance;
        int id;
        String[] info;
        this._type = L2WeaponType.valueOf(set.getString("weapon_type", "none").toUpperCase());
        this._type1 = 0;
        this._type2 = 0;
        this._isMagicWeapon = set.getBool("is_magic_weapon", false);
        this._soulShotCount = set.getInteger("soulshots", 0);
        this._spiritShotCount = set.getInteger("spiritshots", 0);
        this._rndDam = set.getInteger("random_damage", 0);
        this._mpConsume = set.getInteger("mp_consume", 0);
        this._reuseDelay = set.getInteger("reuse_delay", 0);
        String skill = set.getString("enchant4_skill", null);
        if (skill != null && (info = skill.split("-")) != null && info.length == 2) {
            int id2 = 0;
            int level = 0;
            try {
                id2 = Integer.parseInt(info[0]);
                level = Integer.parseInt(info[1]);
            }
            catch (Exception nfe) {
                _log.info(StringUtil.concat("> Couldnt parse ", skill, " in weapon enchant skills! item ", this.toString()));
            }
            if (id2 > 0 && level > 0) {
                this._enchant4Skill = new SkillHolder(id2, level);
            }
        }
        if ((skill = set.getString("oncast_skill", null)) != null) {
            info = skill.split("-");
            String infochance = set.getString("oncast_chance", null);
            if (info != null && info.length == 2) {
                id = 0;
                int level = 0;
                chance = 0;
                try {
                    id = Integer.parseInt(info[0]);
                    level = Integer.parseInt(info[1]);
                    if (infochance != null) {
                        chance = Integer.parseInt(infochance);
                    }
                }
                catch (Exception nfe) {
                    _log.info(StringUtil.concat("> Couldnt parse ", skill, " in weapon oncast skills! item ", this.toString()));
                }
                if (id > 0 && level > 0 && chance > 0) {
                    this._skillsOnCast = new SkillHolder(id, level);
                    if (infochance != null) {
                        this._skillsOnCastCondition = new ConditionGameChance(chance);
                    }
                }
            }
        }
        if ((skill = set.getString("oncrit_skill", null)) != null) {
            info = skill.split("-");
            String infochance = set.getString("oncrit_chance", null);
            if (info != null && info.length == 2) {
                id = 0;
                int level = 0;
                chance = 0;
                try {
                    id = Integer.parseInt(info[0]);
                    level = Integer.parseInt(info[1]);
                    if (infochance != null) {
                        chance = Integer.parseInt(infochance);
                    }
                }
                catch (Exception nfe) {
                    _log.info(StringUtil.concat("> Couldnt parse ", skill, " in weapon oncrit skills! item ", this.toString()));
                }
                if (id > 0 && level > 0 && chance > 0) {
                    this._skillsOnCrit = new SkillHolder(id, level);
                    if (infochance != null) {
                        this._skillsOnCritCondition = new ConditionGameChance(chance);
                    }
                }
            }
        }
        this._changeWeaponId = set.getInteger("change_weaponId", 0);
    }

    @Override
    public L2WeaponType getItemType() {
        return this._type;
    }

    @Override
    public int getItemMask() {
        return this.getItemType().mask();
    }

    public boolean isMagicWeapon() {
        return this._isMagicWeapon;
    }

    public int getSoulShotCount() {
        return this._soulShotCount;
    }

    public int getSpiritShotCount() {
        return this._spiritShotCount;
    }

    public int getRandomDamage() {
        return this._rndDam;
    }

    public int getReuseDelay() {
        return this._reuseDelay;
    }

    public int getMpConsume() {
        return this._mpConsume;
    }

    public L2Skill getEnchant4Skill() {
        if (this._enchant4Skill == null) {
            return null;
        }
        return this._enchant4Skill.getSkill();
    }

    public int getChangeWeaponId() {
        return this._changeWeaponId;
    }

    @Override
    public Func[] getStatFuncs(L2ItemInstance instance, L2Character player) {
        if (this._funcTemplates == null || this._funcTemplates.length == 0) {
            return _emptyFunctionSet;
        }
        ArrayList<Func> funcs = new ArrayList<Func>(this._funcTemplates.length);
        Env env = new Env();
        env.player = player;
        env.item = instance;
        for (FuncTemplate t : this._funcTemplates) {
            Func f = t.getFunc(env, instance);
            if (f == null) continue;
            funcs.add(f);
        }
        return funcs.toArray(new Func[funcs.size()]);
    }

    public L2Effect[] getSkillEffects(L2Character caster, L2Character target, boolean crit) {
        if (this._skillsOnCrit == null || !crit) {
            return _emptyEffectSet;
        }
        FastList effects = new FastList();
        if (this._skillsOnCritCondition != null) {
            Env env = new Env();
            env.player = caster;
            env.target = target;
            env.skill = this._skillsOnCrit.getSkill();
            if (!this._skillsOnCritCondition.test(env)) {
                return _emptyEffectSet;
            }
        }
        byte shld = Formulas.calcShldUse(caster, target, this._skillsOnCrit.getSkill());
        if (!Formulas.calcSkillSuccess(caster, target, this._skillsOnCrit.getSkill(), shld, false, false, false)) {
            return _emptyEffectSet;
        }
        if (target.getFirstEffect(this._skillsOnCrit.getSkill().getId()) != null) {
            target.getFirstEffect(this._skillsOnCrit.getSkill().getId()).exit();
        }
        for (L2Effect e : this._skillsOnCrit.getSkill().getEffects(caster, target, new Env(shld, false, false, false))) {
            effects.add(e);
        }
        if (effects.isEmpty()) {
            return _emptyEffectSet;
        }
        return effects.toArray(new L2Effect[effects.size()]);
    }

    public L2Effect[] getSkillEffects(L2Character caster, L2Character target, L2Skill trigger) {
        if (this._skillsOnCast == null) {
            return _emptyEffectSet;
        }
        if (trigger.isOffensive() != this._skillsOnCast.getSkill().isOffensive()) {
            return _emptyEffectSet;
        }
        if (trigger.isToggle() && this._skillsOnCast.getSkill().getSkillType() == L2SkillType.BUFF) {
            return _emptyEffectSet;
        }
        if (!trigger.isMagic() && this._skillsOnCast.getSkill().getSkillType() == L2SkillType.BUFF) {
            return _emptyEffectSet;
        }
        if (this._skillsOnCastCondition != null) {
            Env env = new Env();
            env.player = caster;
            env.target = target;
            env.skill = this._skillsOnCast.getSkill();
            if (!this._skillsOnCastCondition.test(env)) {
                return _emptyEffectSet;
            }
        }
        byte shld = Formulas.calcShldUse(caster, target, this._skillsOnCast.getSkill());
        if (this._skillsOnCast.getSkill().isOffensive() && !Formulas.calcSkillSuccess(caster, target, this._skillsOnCast.getSkill(), shld, false, false, false)) {
            return _emptyEffectSet;
        }
        ISkillHandler handler = SkillHandler.getInstance().getSkillHandler(this._skillsOnCast.getSkill().getSkillType());
        L2Object[] targets = new L2Character[]{target};
        if (handler != null) {
            handler.useSkill(caster, this._skillsOnCast.getSkill(), targets);
        } else {
            this._skillsOnCast.getSkill().useSkill(caster, targets);
        }
        if (caster instanceof L2PcInstance) {
            Collection<L2Object> objs = caster.getKnownList().getKnownObjects().values();
            for (L2Object spMob : objs) {
                L2Npc npcMob;
                if (!(spMob instanceof L2Npc) || (npcMob = (L2Npc)spMob).getTemplate().getEventQuests(Quest.QuestEventType.ON_SKILL_SEE) == null) continue;
                for (Quest quest : npcMob.getTemplate().getEventQuests(Quest.QuestEventType.ON_SKILL_SEE)) {
                    quest.notifySkillSee(npcMob, (L2PcInstance)caster, this._skillsOnCast.getSkill(), targets, false);
                }
            }
        }
        return _emptyEffectSet;
    }
}

