/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class AutoSpawnHandler {
    protected static final Logger _log = Logger.getLogger(AutoSpawnHandler.class.getName());
    private static final boolean TEST1 = true;
    private static final int DEFAULT_INITIAL_SPAWN = 30000;
    private static final int DEFAULT_RESPAWN = 3600000;
    private static final int DEFAULT_DESPAWN = 3600000;
    protected Map<Integer, AutoSpawnInstance> _registeredSpawns = new FastMap();
    protected Map<Integer, ScheduledFuture<?>> _runningSpawns = new FastMap();
    protected boolean _activeState = true;

    private AutoSpawnHandler() {
        this.restoreSpawnData();
    }

    public static AutoSpawnHandler getInstance() {
        return SingletonHolder._instance;
    }

    public final int size() {
        return this._registeredSpawns.size();
    }

    public void reload() {
        for (ScheduledFuture<?> sf : this._runningSpawns.values()) {
            if (sf == null) continue;
            sf.cancel(true);
        }
        for (AutoSpawnInstance asi : this._registeredSpawns.values()) {
            if (asi == null) continue;
            this.removeSpawn(asi);
        }
        this._registeredSpawns = new FastMap();
        this._runningSpawns = new FastMap();
        this.restoreSpawnData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSpawnData() {
        Connection con;
        block6: {
            int numLoaded = 0;
            con = null;
            try {
                PreparedStatement statement = null;
                PreparedStatement statement2 = null;
                ResultSet rs = null;
                ResultSet rs2 = null;
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement("SELECT * FROM random_spawn ORDER BY groupId ASC");
                rs = statement.executeQuery();
                statement2 = con.prepareStatement("SELECT * FROM random_spawn_loc WHERE groupId=?");
                while (rs.next()) {
                    AutoSpawnInstance spawnInst = this.registerSpawn(rs.getInt("npcId"), rs.getInt("initialDelay"), rs.getInt("respawnDelay"), rs.getInt("despawnDelay"));
                    spawnInst.setSpawnCount(rs.getInt("count"));
                    spawnInst.setBroadcast(rs.getBoolean("broadcastSpawn"));
                    spawnInst.setRandomSpawn(rs.getBoolean("randomSpawn"));
                    ++numLoaded;
                    statement2.setInt(1, rs.getInt("groupId"));
                    rs2 = statement2.executeQuery();
                    statement2.clearParameters();
                    while (rs2.next()) {
                        spawnInst.addSpawnLocation(rs2.getInt("x"), rs2.getInt("y"), rs2.getInt("z"), rs2.getInt("heading"));
                    }
                    rs2.close();
                }
                statement2.close();
                rs.close();
                statement.close();
                if (!Config.DEBUG) break block6;
                _log.info("AutoSpawnHandler: Loaded " + numLoaded + " spawn group(s) from the database.");
            }
            catch (Exception e) {
                try {
                    _log.log(Level.WARNING, "AutoSpawnHandler: Could not restore spawn data: " + e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    L2DatabaseFactory.close(con);
                    throw throwable;
                }
                L2DatabaseFactory.close(con);
            }
        }
        L2DatabaseFactory.close(con);
    }

    public AutoSpawnInstance registerSpawn(int npcId, int[][] spawnPoints, int initialDelay, int respawnDelay, int despawnDelay) {
        int newId;
        if (initialDelay < 0) {
            initialDelay = 30000;
        }
        if (respawnDelay < 0) {
            respawnDelay = 3600000;
        }
        if (despawnDelay < 0) {
            despawnDelay = 3600000;
        }
        AutoSpawnInstance newSpawn = new AutoSpawnInstance(npcId, initialDelay, respawnDelay, despawnDelay);
        if (spawnPoints != null) {
            for (int[] spawnPoint : spawnPoints) {
                newSpawn.addSpawnLocation(spawnPoint);
            }
        }
        newSpawn._objectId = newId = IdFactory.getInstance().getNextId();
        this._registeredSpawns.put(newId, newSpawn);
        this.setSpawnActive(newSpawn, true);
        if (Config.DEBUG) {
            _log.info("AutoSpawnHandler: Registered auto spawn for NPC ID " + npcId + " (Object ID = " + newId + ").");
        }
        return newSpawn;
    }

    public AutoSpawnInstance registerSpawn(int npcId, int initialDelay, int respawnDelay, int despawnDelay) {
        return this.registerSpawn(npcId, null, initialDelay, respawnDelay, despawnDelay);
    }

    public boolean removeSpawn(AutoSpawnInstance spawnInst) {
        if (!this.isSpawnRegistered(spawnInst)) {
            return false;
        }
        try {
            this._registeredSpawns.remove(spawnInst.getNpcId());
            ScheduledFuture<?> respawnTask = this._runningSpawns.remove(spawnInst._objectId);
            respawnTask.cancel(false);
            if (Config.DEBUG) {
                _log.info("AutoSpawnHandler: Removed auto spawn for NPC ID " + spawnInst._npcId + " (Object ID = " + spawnInst._objectId + ").");
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "AutoSpawnHandler: Could not auto spawn for NPC ID " + spawnInst._npcId + " (Object ID = " + spawnInst._objectId + "): " + e.getMessage(), e);
            return false;
        }
        return true;
    }

    public void removeSpawn(int objectId) {
        this.removeSpawn(this._registeredSpawns.get(objectId));
    }

    public void setSpawnActive(AutoSpawnInstance spawnInst, boolean isActive) {
        if (spawnInst == null) {
            return;
        }
        int objectId = spawnInst._objectId;
        if (this.isSpawnRegistered(objectId)) {
            ScheduledFuture<?> spawnTask = null;
            if (isActive) {
                AutoSpawner rs = new AutoSpawner(objectId);
                spawnTask = spawnInst._desDelay > 0 ? ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(rs, spawnInst._initDelay, spawnInst._resDelay) : ThreadPoolManager.getInstance().scheduleEffect(rs, spawnInst._initDelay);
                this._runningSpawns.put(objectId, spawnTask);
            } else {
                AutoDespawner rd = new AutoDespawner(objectId);
                spawnTask = this._runningSpawns.remove(objectId);
                if (spawnTask != null) {
                    spawnTask.cancel(false);
                }
                rd.run();
            }
            spawnInst.setSpawnActive(isActive);
        }
    }

    public void setAllActive(boolean isActive) {
        if (this._activeState == isActive) {
            return;
        }
        for (AutoSpawnInstance spawnInst : this._registeredSpawns.values()) {
            this.setSpawnActive(spawnInst, isActive);
        }
        this._activeState = isActive;
    }

    public final long getTimeToNextSpawn(AutoSpawnInstance spawnInst) {
        int objectId = spawnInst.getObjectId();
        if (!this.isSpawnRegistered(objectId)) {
            return -1L;
        }
        return this._runningSpawns.get(objectId).getDelay(TimeUnit.MILLISECONDS);
    }

    public final AutoSpawnInstance getAutoSpawnInstance(int id, boolean isObjectId) {
        if (isObjectId) {
            if (this.isSpawnRegistered(id)) {
                return this._registeredSpawns.get(id);
            }
        } else {
            for (AutoSpawnInstance spawnInst : this._registeredSpawns.values()) {
                if (spawnInst.getNpcId() != id) continue;
                return spawnInst;
            }
        }
        return null;
    }

    public Map<Integer, AutoSpawnInstance> getAutoSpawnInstances(int npcId) {
        FastMap spawnInstList = new FastMap();
        for (AutoSpawnInstance spawnInst : this._registeredSpawns.values()) {
            if (spawnInst.getNpcId() != npcId) continue;
            spawnInstList.put(spawnInst.getObjectId(), spawnInst);
        }
        return spawnInstList;
    }

    public final boolean isSpawnRegistered(int objectId) {
        return this._registeredSpawns.containsKey(objectId);
    }

    public final boolean isSpawnRegistered(AutoSpawnInstance spawnInst) {
        return this._registeredSpawns.containsValue(spawnInst);
    }

    private static class SingletonHolder {
        protected static final AutoSpawnHandler _instance = new AutoSpawnHandler();

        private SingletonHolder() {
        }
    }

    public static class AutoSpawnInstance {
        protected int _objectId;
        protected int _spawnIndex;
        protected final int _npcId;
        protected final int _initDelay;
        protected final int _resDelay;
        protected final int _desDelay;
        protected int _spawnCount = 1;
        protected int _lastLocIndex = -1;
        private List<L2Npc> _npcList = new FastList();
        private List<Location> _locList = new FastList();
        private boolean _spawnActive;
        private boolean _randomSpawn = false;
        private boolean _broadcastAnnouncement = false;

        protected AutoSpawnInstance(int npcId, int initDelay, int respawnDelay, int despawnDelay) {
            this._npcId = npcId;
            this._initDelay = initDelay;
            this._resDelay = respawnDelay;
            this._desDelay = despawnDelay;
        }

        protected void setSpawnActive(boolean activeValue) {
            this._spawnActive = activeValue;
        }

        protected boolean addNpcInstance(L2Npc npcInst) {
            return this._npcList.add(npcInst);
        }

        protected boolean removeNpcInstance(L2Npc npcInst) {
            return this._npcList.remove(npcInst);
        }

        public int getObjectId() {
            return this._objectId;
        }

        public int getNpcId() {
            return this._npcId;
        }

        public Location[] getLocationList() {
            return this._locList.toArray(new Location[this._locList.size()]);
        }

        public L2Npc[] getNPCInstanceList() {
            return this._npcList.toArray(new L2Npc[this._npcList.size()]);
        }

        private void setSpawnCount(int spawnCount) {
            this._spawnCount = spawnCount;
        }

        public void setRandomSpawn(boolean randValue) {
            this._randomSpawn = randValue;
        }

        public void setBroadcast(boolean broadcastValue) {
            this._broadcastAnnouncement = broadcastValue;
        }

        public boolean isSpawnActive() {
            return this._spawnActive;
        }

        public boolean isRandomSpawn() {
            return this._randomSpawn;
        }

        public boolean isBroadcasting() {
            return this._broadcastAnnouncement;
        }

        public boolean addSpawnLocation(int x, int y, int z, int heading) {
            return this._locList.add(new Location(x, y, z, heading));
        }

        public boolean addSpawnLocation(int[] spawnLoc) {
            if (spawnLoc.length != 3) {
                return false;
            }
            return this.addSpawnLocation(spawnLoc[0], spawnLoc[1], spawnLoc[2], -1);
        }
    }

    private class AutoDespawner
    implements Runnable {
        private int _objectId;

        protected AutoDespawner(int objectId) {
            this._objectId = objectId;
        }

        @Override
        public void run() {
            try {
                AutoSpawnInstance spawnInst = AutoSpawnHandler.this._registeredSpawns.get(this._objectId);
                if (spawnInst == null) {
                    _log.info("AutoSpawnHandler: No spawn registered for object ID = " + this._objectId + ".");
                    return;
                }
                for (L2Npc npcInst : spawnInst.getNPCInstanceList()) {
                    if (npcInst == null) continue;
                    npcInst.deleteMe();
                    SpawnTable.getInstance().deleteSpawn(npcInst.getSpawn(), false);
                    spawnInst.removeNpcInstance(npcInst);
                    if (!Config.DEBUG) continue;
                    _log.info("AutoSpawnHandler: Spawns removed for spawn instance (Object ID = " + this._objectId + ").");
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "AutoSpawnHandler: An error occurred while despawning spawn (Object ID = " + this._objectId + "): " + e.getMessage(), e);
                e.printStackTrace();
            }
        }
    }

    private class AutoSpawner
    implements Runnable {
        private int _objectId;

        protected AutoSpawner(int objectId) {
            this._objectId = objectId;
        }

        @Override
        public void run() {
            try {
                Location[] locationList;
                boolean isDespawnSchedule;
                AutoSpawnInstance spawnInst = AutoSpawnHandler.this._registeredSpawns.get(this._objectId);
                if (!spawnInst.isSpawnActive()) {
                    return;
                }
                long now = System.currentTimeMillis();
                boolean bl = isDespawnSchedule = spawnInst._desDelay < spawnInst._resDelay;
                if (spawnInst._desDelay > 0 && !isDespawnSchedule) {
                    new AutoDespawner(this._objectId).run();
                }
                if ((locationList = spawnInst.getLocationList()).length == 0) {
                    _log.info("AutoSpawnHandler: No location co-ords specified for spawn instance (Object ID = " + this._objectId + ").");
                    return;
                }
                int locationCount = locationList.length;
                int locationIndex = Rnd.nextInt(locationCount);
                if (!spawnInst.isRandomSpawn()) {
                    locationIndex = spawnInst._lastLocIndex + 1;
                    if (locationIndex == locationCount) {
                        locationIndex = 0;
                    }
                    spawnInst._lastLocIndex = locationIndex;
                }
                int x = locationList[locationIndex].getX();
                int y = locationList[locationIndex].getY();
                int z = locationList[locationIndex].getZ();
                int heading = locationList[locationIndex].getHeading();
                L2NpcTemplate npcTemp = NpcTable.getInstance().getTemplate(spawnInst.getNpcId());
                if (npcTemp == null) {
                    _log.warning("Couldnt find NPC id" + spawnInst.getNpcId() + " Try to update your DP");
                    return;
                }
                L2Spawn newSpawn = new L2Spawn(npcTemp);
                newSpawn.setLocx(x);
                newSpawn.setLocy(y);
                newSpawn.setLocz(z);
                if (heading != -1) {
                    newSpawn.setHeading(heading);
                }
                newSpawn.setAmount(spawnInst._spawnCount);
                if (spawnInst._desDelay == 0) {
                    newSpawn.setRespawnDelay(spawnInst._resDelay);
                }
                SpawnTable.getInstance().addNewSpawn(newSpawn, false);
                L2Npc npcInst = null;
                if (spawnInst._spawnCount == 1) {
                    npcInst = newSpawn.doSpawn();
                    npcInst.setXYZ(npcInst.getX(), npcInst.getY(), npcInst.getZ());
                    spawnInst.addNpcInstance(npcInst);
                } else {
                    for (int i = 0; i < spawnInst._spawnCount; ++i) {
                        npcInst = newSpawn.doSpawn();
                        npcInst.setXYZ(npcInst.getX() + Rnd.nextInt(50), npcInst.getY() + Rnd.nextInt(50), npcInst.getZ());
                        spawnInst.addNpcInstance(npcInst);
                    }
                }
                String nearestTown = MapRegionManager.getInstance().getClosestTownName(npcInst);
                if (spawnInst.isBroadcasting()) {
                    Announcements.getInstance().announceToAll(SystemMessage.getSystemMessage(SystemMessageId.S2_S1).addString("\u306b" + npcInst.getName() + "\u304c\u3084\u3063\u3066\u307e\u3044\u308a\u307e\u3057\u305f\uff01").addZoneName(x, y, z));
                }
                if (Config.DEBUG) {
                    _log.info("AutoSpawnHandler: Spawned NPC ID " + spawnInst.getNpcId() + " at " + x + ", " + y + ", " + z + " (Near " + nearestTown + ") for " + spawnInst._resDelay / 60000 + " minute(s).");
                }
                if (spawnInst._desDelay > 0 && isDespawnSchedule) {
                    AutoDespawner rd = new AutoDespawner(this._objectId);
                    ThreadPoolManager.getInstance().scheduleAi(rd, now + (long)spawnInst._desDelay - System.currentTimeMillis());
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "AutoSpawnHandler: An error occurred while initializing spawn instance (Object ID = " + this._objectId + "): " + e.getMessage(), e);
            }
        }
    }
}

