/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.skills.Stats;
import javolution.util.FastList;

public class PcFreight
extends ItemContainer {
    private final L2PcInstance _owner;
    private int _ownerId = 0;

    public PcFreight(int object_id) {
        this._owner = null;
        this._ownerId = object_id;
        this.restore();
    }

    public PcFreight(L2PcInstance owner) {
        this._owner = owner;
        this._ownerId = owner.getObjectId();
    }

    @Override
    public L2PcInstance getOwner() {
        return this._owner;
    }

    @Override
    public L2ItemInstance.ItemLocation getBaseLocation() {
        return L2ItemInstance.ItemLocation.FREIGHT;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (L2ItemInstance item : this._items) {
            if (item.getLocation() != L2ItemInstance.ItemLocation.INVENTORY) continue;
            ++size;
        }
        return size;
    }

    @Override
    public L2ItemInstance[] getItems() {
        FastList list = new FastList();
        for (L2ItemInstance item : this._items) {
            if (!item.isFreightable()) continue;
            list.add(item);
        }
        return list.toArray(new L2ItemInstance[list.size()]);
    }

    @Override
    public L2ItemInstance getItemByItemId(int itemId) {
        for (L2ItemInstance item : this._items) {
            if (item.getItemId() != itemId || item.getLocation() != L2ItemInstance.ItemLocation.INVENTORY) continue;
            return item;
        }
        return null;
    }

    @Override
    public int getOwnerId() {
        return this._ownerId;
    }

    @Override
    public boolean validateCapacity(int slots) {
        int curSlots = this._owner == null ? Config.ALT_FREIGHT_SLOTS : Config.ALT_FREIGHT_SLOTS + (int)this._owner.getStat().calcStat(Stats.FREIGHT_LIM, 0.0, null, null);
        return this.getSize() + slots <= curSlots;
    }
}

